/*
 * Decompiled with CFR 0.152.
 */
package sun.jdbc.odbc;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Vector;
import sun.jdbc.odbc.JdbcOdbc;
import sun.jdbc.odbc.JdbcOdbcBatchUpdateException;
import sun.jdbc.odbc.JdbcOdbcBoundArrayOfParams;
import sun.jdbc.odbc.JdbcOdbcBoundParam;
import sun.jdbc.odbc.JdbcOdbcConnectionInterface;
import sun.jdbc.odbc.JdbcOdbcResultSet;
import sun.jdbc.odbc.JdbcOdbcResultSetInterface;
import sun.jdbc.odbc.JdbcOdbcResultSetMetaData;
import sun.jdbc.odbc.JdbcOdbcSQLWarning;
import sun.jdbc.odbc.JdbcOdbcStatement;
import sun.jdbc.odbc.JdbcOdbcUtils;

public class JdbcOdbcPreparedStatement
extends JdbcOdbcStatement
implements PreparedStatement {
    protected int numParams;
    protected JdbcOdbcBoundParam[] boundParams;
    protected JdbcOdbcBoundArrayOfParams arrayParams;
    protected Vector batchSqlVec;
    protected boolean batchSupport;
    protected boolean batchParamsOn;
    protected int batchSize;
    protected int arrayDef;
    protected int arrayScale;
    protected int StringDef;
    protected int NumberDef;
    protected int NumberScale;
    protected int batchRCFlag;
    protected int[] paramsProcessed;
    protected int[] paramStatusArray;
    protected long[] pA1;
    protected long[] pA2;
    protected int binaryPrec;
    protected JdbcOdbcUtils utils = new JdbcOdbcUtils();

    public JdbcOdbcPreparedStatement(JdbcOdbcConnectionInterface jdbcOdbcConnectionInterface) {
        super(jdbcOdbcConnectionInterface);
    }

    public void initialize(JdbcOdbc jdbcOdbc, long l, long l2, Hashtable hashtable, int n, int n2) throws SQLException {
        super.initialize(jdbcOdbc, l, l2, hashtable, n, n2);
    }

    public ResultSet executeQuery() throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*PreparedStatement.executeQuery");
        }
        ResultSet resultSet = null;
        if (!this.execute()) {
            throw new SQLException("No ResultSet was produced");
        }
        resultSet = this.getResultSet(false);
        return resultSet;
    }

    public ResultSet executeQuery(String string) throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*PreparedStatement.executeQuery (" + string + ")");
        }
        throw new SQLException("Driver does not support this function", "IM001");
    }

    public int executeUpdate() throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*PreparedStatement.executeUpdate");
        }
        int n = -1;
        if (this.execute()) {
            throw new SQLException("No row count was produced");
        }
        n = this.getUpdateCount();
        return n;
    }

    public int executeUpdate(String string) throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*PreparedStatement.executeUpdate (" + string + ")");
        }
        throw new SQLException("Driver does not support this function", "IM001");
    }

    public boolean execute(String string) throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*PreparedStatement.execute (" + string + ")");
        }
        throw new SQLException("Driver does not support this function", "IM001");
    }

    public synchronized boolean execute() throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*PreparedStatement.execute");
        }
        boolean bl = false;
        SQLWarning sQLWarning = null;
        boolean bl2 = false;
        this.clearWarnings();
        this.reset();
        try {
            bl2 = this.OdbcApi.SQLExecute(this.hStmt);
            while (bl2) {
                int n = this.OdbcApi.SQLParamData(this.hStmt);
                if (n == -1) {
                    bl2 = false;
                    continue;
                }
                if (this.batchParamsOn) {
                    InputStream inputStream = null;
                    int n2 = this.paramsProcessed[0];
                    inputStream = this.arrayParams.getInputStreamElement(n, n2);
                    this.boundParams[n - 1].setInputStream(inputStream, this.arrayParams.getElementLength(n, n2));
                }
                this.putParamData(n);
            }
        }
        catch (SQLWarning sQLWarning2) {
            sQLWarning = sQLWarning2;
        }
        if (this.getColumnCount() > 0) {
            bl = true;
        }
        return bl;
    }

    public void setNull(int n, int n2) throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*PreparedStatement.setNull (" + n + "," + n2 + ")");
        }
        this.clearParameter(n);
        this.setInputParameter(n, true);
        byte[] byArray = this.getLengthBuf(n);
        long[] lArray = new long[]{0L, 0L};
        int n3 = 0;
        int n4 = 0;
        if (n2 == 1 || n2 == 12) {
            n3 = this.StringDef;
        } else if (n2 == 2 || n2 == 3) {
            n3 = this.NumberDef;
            n4 = this.NumberScale;
        } else if (n2 == -2 || n2 == -3 || n2 == -4) {
            n2 = this.boundParams[n - 1].boundType;
            n3 = this.binaryPrec;
        }
        if (n3 <= 0) {
            n3 = this.getPrecision(n2);
        }
        if (n3 <= 0) {
            n3 = 1;
        }
        if (!this.batchOn) {
            this.OdbcApi.SQLBindInParameterNull(this.hStmt, n, n2, n3, n4, byArray, lArray);
        }
        this.boundParams[n - 1].pA1 = lArray[0];
        this.boundParams[n - 1].pA2 = lArray[1];
        this.boundParams[n - 1].scale = n4;
        this.boundParams[n - 1].boundType = n2;
        this.boundParams[n - 1].boundValue = null;
        this.arrayParams.storeValue(n - 1, null, -1);
        this.setSqlType(n, n2);
    }

    public void setBoolean(int n, boolean bl) throws SQLException {
        int n2 = 0;
        if (bl) {
            n2 = 1;
        }
        this.clearParameter(n);
        this.setInputParameter(n, true);
        byte[] byArray = this.allocBindBuf(n, 4);
        long[] lArray = new long[]{0L, 0L};
        if (!this.batchOn) {
            this.OdbcApi.SQLBindInParameterInteger(this.hStmt, n, -7, n2, byArray, lArray);
        }
        this.boundParams[n - 1].pA1 = lArray[0];
        this.boundParams[n - 1].pA2 = lArray[1];
        this.boundParams[n - 1].boundType = -7;
        this.boundParams[n - 1].boundValue = new Boolean(bl);
        this.arrayParams.storeValue(n - 1, new Boolean(bl), 0);
        this.setSqlType(n, -7);
    }

    public void setByte(int n, byte by) throws SQLException {
        this.clearParameter(n);
        this.setInputParameter(n, true);
        byte[] byArray = this.allocBindBuf(n, 4);
        long[] lArray = new long[]{0L, 0L};
        if (!this.batchOn) {
            this.OdbcApi.SQLBindInParameterInteger(this.hStmt, n, -6, by, byArray, lArray);
        }
        this.boundParams[n - 1].pA1 = lArray[0];
        this.boundParams[n - 1].pA2 = lArray[1];
        this.boundParams[n - 1].boundType = -6;
        this.boundParams[n - 1].boundValue = new Byte(by);
        this.arrayParams.storeValue(n - 1, new Byte(by), 0);
        this.setSqlType(n, -6);
    }

    public void setShort(int n, short s) throws SQLException {
        this.clearParameter(n);
        this.setInputParameter(n, true);
        byte[] byArray = this.allocBindBuf(n, 4);
        long[] lArray = new long[]{0L, 0L};
        if (!this.batchOn) {
            this.OdbcApi.SQLBindInParameterInteger(this.hStmt, n, 5, s, byArray, lArray);
        }
        this.boundParams[n - 1].pA1 = lArray[0];
        this.boundParams[n - 1].pA2 = lArray[1];
        this.boundParams[n - 1].boundType = 5;
        this.boundParams[n - 1].boundValue = new Short(s);
        this.arrayParams.storeValue(n - 1, new Short(s), 0);
        this.setSqlType(n, 5);
    }

    public void setInt(int n, int n2) throws SQLException {
        this.clearParameter(n);
        this.setInputParameter(n, true);
        byte[] byArray = this.allocBindBuf(n, 4);
        long[] lArray = new long[]{0L, 0L};
        if (!this.batchOn) {
            this.OdbcApi.SQLBindInParameterInteger(this.hStmt, n, 4, n2, byArray, lArray);
        }
        this.boundParams[n - 1].pA1 = lArray[0];
        this.boundParams[n - 1].pA2 = lArray[1];
        this.boundParams[n - 1].boundType = 4;
        this.boundParams[n - 1].boundValue = new Integer(n2);
        this.arrayParams.storeValue(n - 1, new Integer(n2), 0);
        this.setSqlType(n, 4);
    }

    public void setLong(int n, long l) throws SQLException {
        this.clearParameter(n);
        if (this.myConnection.getODBCVer() == 2) {
            this.setChar(n, -5, new Long(l).intValue(), String.valueOf(l));
        } else if (this.myConnection.getODBCVer() >= 3) {
            this.setInputParameter(n, true);
            byte[] byArray = this.allocBindBuf(n, 8);
            long[] lArray = new long[]{0L, 0L};
            if (!this.batchOn) {
                this.OdbcApi.SQLBindInParameterBigint(this.hStmt, n, -5, 0, l, byArray, lArray);
            }
            this.boundParams[n - 1].pA1 = lArray[0];
            this.boundParams[n - 1].pA2 = lArray[1];
            this.arrayParams.storeValue(n - 1, new BigInteger(String.valueOf(l)), 0);
            this.setSqlType(n, -5);
        }
        this.boundParams[n - 1].boundType = -5;
        this.boundParams[n - 1].boundValue = new BigInteger(String.valueOf(l));
    }

    public void setReal(int n, float f) throws SQLException {
        this.clearParameter(n);
        this.setInputParameter(n, true);
        byte[] byArray = this.allocBindBuf(n, 8);
        long[] lArray = new long[]{0L, 0L};
        if (!this.batchOn) {
            this.OdbcApi.SQLBindInParameterFloat(this.hStmt, n, 7, 0, f, byArray, lArray);
        }
        this.boundParams[n - 1].pA1 = lArray[0];
        this.boundParams[n - 1].pA2 = lArray[1];
        this.arrayParams.storeValue(n - 1, new Float(f), 0);
        this.setSqlType(n, 7);
    }

    public void setFloat(int n, float f) throws SQLException {
        this.setDouble(n, f);
    }

    public void setDouble(int n, double d) throws SQLException {
        this.clearParameter(n);
        this.setInputParameter(n, true);
        byte[] byArray = this.allocBindBuf(n, 8);
        long[] lArray = new long[]{0L, 0L};
        if (!this.batchOn) {
            this.OdbcApi.SQLBindInParameterDouble(this.hStmt, n, 8, 0, d, byArray, lArray);
        }
        this.boundParams[n - 1].pA1 = lArray[0];
        this.boundParams[n - 1].pA2 = lArray[1];
        this.boundParams[n - 1].boundType = 8;
        this.boundParams[n - 1].boundValue = new Double(d);
        this.arrayParams.storeValue(n - 1, new Double(d), 0);
        this.setSqlType(n, 8);
    }

    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.clearParameter(n);
        if (bigDecimal == null) {
            this.setNull(n, 2);
        } else {
            this.setChar(n, 2, bigDecimal.scale(), bigDecimal.toString());
        }
        this.boundParams[n - 1].boundType = 2;
        this.boundParams[n - 1].boundValue = bigDecimal;
    }

    public void setDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.clearParameter(n);
        if (bigDecimal == null) {
            this.setNull(n, 3);
        } else {
            this.setChar(n, 3, bigDecimal.scale(), bigDecimal.toString());
        }
        this.boundParams[n - 1].boundType = 3;
        this.boundParams[n - 1].boundValue = bigDecimal;
    }

    public void setString(int n, String string) throws SQLException {
        if (string == null) {
            this.setNull(n, 1);
        } else if (string.length() >= 254) {
            this.setChar(n, -1, 0, string);
        } else {
            this.setChar(n, 1, 0, string);
        }
    }

    public void setBytes(int n, byte[] byArray) throws SQLException {
        if (byArray == null) {
            this.setNull(n, -2);
        } else if (byArray.length > 8000) {
            this.setBinaryStream(n, (InputStream)new ByteArrayInputStream(byArray), byArray.length);
        } else {
            this.setBinary(n, -2, byArray);
        }
        this.boundParams[n - 1].boundType = -2;
        this.boundParams[n - 1].boundValue = byArray;
    }

    public void setDate(int n, Date date) throws SQLException {
        if (date == null) {
            this.setNull(n, 91);
            return;
        }
        this.clearParameter(n);
        this.setInputParameter(n, true);
        byte[] byArray = this.allocBindBuf(n, 32);
        long[] lArray = new long[]{0L, 0L};
        if (!this.batchOn) {
            this.OdbcApi.SQLBindInParameterDate(this.hStmt, n, date, byArray, lArray);
        }
        this.boundParams[n - 1].pA1 = lArray[0];
        this.boundParams[n - 1].pA2 = lArray[1];
        this.boundParams[n - 1].boundType = 91;
        this.boundParams[n - 1].boundValue = date;
        this.arrayParams.storeValue(n - 1, date, -3);
        this.setSqlType(n, 91);
    }

    public void setTime(int n, Time time) throws SQLException {
        if (time == null) {
            this.setNull(n, 92);
            return;
        }
        this.clearParameter(n);
        this.setInputParameter(n, true);
        byte[] byArray = this.allocBindBuf(n, 32);
        long[] lArray = new long[]{0L, 0L};
        if (!this.batchOn) {
            this.OdbcApi.SQLBindInParameterTime(this.hStmt, n, time, byArray, lArray);
        }
        this.boundParams[n - 1].pA1 = lArray[0];
        this.boundParams[n - 1].pA2 = lArray[1];
        this.boundParams[n - 1].boundType = 92;
        this.boundParams[n - 1].boundValue = time;
        this.arrayParams.storeValue(n - 1, time, -3);
        this.setSqlType(n, 92);
    }

    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        if (timestamp == null) {
            this.setNull(n, 93);
            return;
        }
        this.clearParameter(n);
        this.setInputParameter(n, true);
        byte[] byArray = this.allocBindBuf(n, 32);
        long[] lArray = new long[]{0L, 0L};
        if (!this.batchOn) {
            this.OdbcApi.SQLBindInParameterTimestamp(this.hStmt, n, timestamp, byArray, lArray);
        }
        this.boundParams[n - 1].pA1 = lArray[0];
        this.boundParams[n - 1].pA2 = lArray[1];
        this.boundParams[n - 1].boundValue = timestamp;
        this.boundParams[n - 1].boundType = 93;
        this.arrayParams.storeValue(n - 1, timestamp, -3);
        this.setSqlType(n, 93);
    }

    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.setStream(n, inputStream, n2, -1, 1);
    }

    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.setStream(n, inputStream, n2, -1, 2);
    }

    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.setStream(n, inputStream, n2, -4, 3);
        this.binaryPrec = n2;
    }

    public void clearParameters() throws SQLException {
        if (this.hStmt != 0L) {
            this.OdbcApi.SQLFreeStmt(this.hStmt, 3);
            this.FreeParams();
            for (int i = 1; this.boundParams != null && i <= this.boundParams.length; ++i) {
                this.boundParams[i - 1].binaryData = null;
                this.boundParams[i - 1].initialize();
                this.boundParams[i - 1].paramInputStream = null;
                this.boundParams[i - 1].inputParameter = false;
            }
        }
    }

    public void clearParameter(int n) throws SQLException {
        if (this.hStmt != 0L) {
            if (this.boundParams[n - 1].pA1 != 0L) {
                JdbcOdbc.ReleaseStoredBytes(this.boundParams[n - 1].pA1, this.boundParams[n - 1].pA2);
                this.boundParams[n - 1].pA1 = 0L;
                this.boundParams[n - 1].pA2 = 0L;
            }
            if (this.boundParams[n - 1].pB1 != 0L) {
                JdbcOdbc.ReleaseStoredBytes(this.boundParams[n - 1].pB1, this.boundParams[n - 1].pB2);
                this.boundParams[n - 1].pB1 = 0L;
                this.boundParams[n - 1].pB2 = 0L;
            }
            if (this.boundParams[n - 1].pC1 != 0L) {
                JdbcOdbc.ReleaseStoredBytes(this.boundParams[n - 1].pC1, this.boundParams[n - 1].pC2);
                this.boundParams[n - 1].pC1 = 0L;
                this.boundParams[n - 1].pC2 = 0L;
            }
            if (this.boundParams[n - 1].pS1 != 0L) {
                JdbcOdbc.ReleaseStoredChars(this.boundParams[n - 1].pS1, this.boundParams[n - 1].pS2);
                this.boundParams[n - 1].pS1 = 0L;
                this.boundParams[n - 1].pS2 = 0L;
            }
            this.boundParams[n - 1].binaryData = null;
            this.boundParams[n - 1].initialize();
            this.boundParams[n - 1].paramInputStream = null;
            this.boundParams[n - 1].inputParameter = false;
        }
    }

    public void setObject(int n, Object object) throws SQLException {
        this.setObject(n, object, JdbcOdbcPreparedStatement.getTypeFromObject(object));
    }

    public void setObject(int n, Object object, int n2) throws SQLException {
        this.setObject(n, object, n2, 0);
    }

    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        if (object == null) {
            this.setNull(n, n2);
            return;
        }
        String string = null;
        string = object instanceof byte[] ? new String("byte[]") : new String(object.getClass().getName());
        int n4 = 0;
        BigInteger bigInteger = null;
        if (string.equalsIgnoreCase("java.lang.Boolean")) {
            if (object.toString().equalsIgnoreCase("true")) {
                n4 = 1;
                bigInteger = BigInteger.ONE;
            } else {
                n4 = 0;
                bigInteger = BigInteger.ZERO;
            }
        }
        try {
            switch (n2) {
                case 1: {
                    if (string.equalsIgnoreCase("java.lang.String") || string.equalsIgnoreCase("java.math.BigDecimal") || string.equalsIgnoreCase("java.lang.Boolean") || string.equalsIgnoreCase("java.lang.Integer") || string.equalsIgnoreCase("java.lang.Short") || string.equalsIgnoreCase("java.lang.Long") || string.equalsIgnoreCase("java.lang.Float") || string.equalsIgnoreCase("java.lang.Double") || string.equalsIgnoreCase("java.sql.Date") || string.equalsIgnoreCase("java.sql.Time") || string.equalsIgnoreCase("java.sql.Timestamp")) {
                        this.setString(n, object.toString());
                        break;
                    }
                    throw new SQLException("Conversion not supported by setObject!!");
                }
                case 12: {
                    if (string.equalsIgnoreCase("java.lang.String") || string.equalsIgnoreCase("java.math.BigDecimal") || string.equalsIgnoreCase("java.lang.Boolean") || string.equalsIgnoreCase("java.lang.Integer") || string.equalsIgnoreCase("java.lang.Short") || string.equalsIgnoreCase("java.lang.Long") || string.equalsIgnoreCase("java.lang.Float") || string.equalsIgnoreCase("java.lang.Double") || string.equalsIgnoreCase("java.sql.Date") || string.equalsIgnoreCase("java.sql.Time") || string.equalsIgnoreCase("java.sql.Timestamp")) {
                        this.setChar(n, n2, 0, object.toString());
                        break;
                    }
                    throw new SQLException("Conversion not supported by setObject!!");
                }
                case -1: {
                    if (string.equalsIgnoreCase("java.lang.String") || string.equalsIgnoreCase("java.math.BigDecimal") || string.equalsIgnoreCase("java.lang.Boolean") || string.equalsIgnoreCase("java.lang.Integer") || string.equalsIgnoreCase("java.lang.Short") || string.equalsIgnoreCase("java.lang.Long") || string.equalsIgnoreCase("java.lang.Float") || string.equalsIgnoreCase("java.lang.Double") || string.equalsIgnoreCase("java.sql.Date") || string.equalsIgnoreCase("java.sql.Time") || string.equalsIgnoreCase("java.sql.Timestamp")) {
                        this.setChar(n, n2, 0, object.toString());
                        break;
                    }
                    throw new SQLException("Conversion not supported by setObject!!");
                }
                case 2: {
                    if (string.equalsIgnoreCase("java.lang.Integer") || string.equalsIgnoreCase("java.lang.Long") || string.equalsIgnoreCase("java.lang.Short")) {
                        BigDecimal bigDecimal = new BigDecimal(new BigInteger(object.toString()), 0);
                        BigDecimal bigDecimal2 = bigDecimal.movePointRight(n3);
                        BigDecimal bigDecimal3 = bigDecimal2.movePointLeft(n3);
                        this.setBigDecimal(n, bigDecimal3);
                        break;
                    }
                    if (string.equalsIgnoreCase("java.lang.Float") || string.equalsIgnoreCase("java.lang.Double") || string.equalsIgnoreCase("java.lang.String") || string.equalsIgnoreCase("java.math.BigDecimal")) {
                        this.setBigDecimal(n, new BigDecimal(object.toString()));
                        break;
                    }
                    if (string.equalsIgnoreCase("java.lang.Boolean")) {
                        this.setBigDecimal(n, new BigDecimal(bigInteger.toString()));
                        break;
                    }
                    throw new SQLException("Conversion not supported by setObject!!");
                }
                case 3: {
                    if (string.equalsIgnoreCase("java.lang.Integer") || string.equalsIgnoreCase("java.lang.Long") || string.equalsIgnoreCase("java.lang.Short")) {
                        BigDecimal bigDecimal = new BigDecimal(new BigInteger(object.toString()), 0);
                        BigDecimal bigDecimal4 = bigDecimal.movePointRight(n3);
                        BigDecimal bigDecimal5 = bigDecimal4.movePointLeft(n3);
                        this.setDecimal(n, bigDecimal5);
                        break;
                    }
                    if (string.equalsIgnoreCase("java.lang.Float") || string.equalsIgnoreCase("java.lang.Double") || string.equalsIgnoreCase("java.lang.String") || string.equalsIgnoreCase("java.math.BigDecimal")) {
                        this.setDecimal(n, new BigDecimal(object.toString()));
                        break;
                    }
                    if (string.equalsIgnoreCase("java.lang.Boolean")) {
                        this.setDecimal(n, new BigDecimal(bigInteger.toString()));
                        break;
                    }
                    throw new SQLException("Conversion not supported by setObject!!");
                }
                case -7: {
                    if (string.equalsIgnoreCase("java.lang.String") || string.equalsIgnoreCase("java.lang.Boolean")) {
                        if (object.toString().equalsIgnoreCase("true")) {
                            this.setBoolean(n, true);
                            break;
                        }
                        this.setBoolean(n, false);
                        break;
                    }
                    if (string.equalsIgnoreCase("java.lang.Integer") || string.equalsIgnoreCase("java.lang.Long") || string.equalsIgnoreCase("java.lang.Short") || string.equalsIgnoreCase("java.math.BigDecimal")) {
                        if (object.toString().equalsIgnoreCase("1")) {
                            this.setBoolean(n, true);
                            break;
                        }
                        this.setBoolean(n, false);
                        break;
                    }
                    if (string.equalsIgnoreCase("java.lang.Float")) {
                        if (new Float(0.0f).compareTo((Float)object) == 0) {
                            this.setBoolean(n, false);
                            break;
                        }
                        this.setBoolean(n, true);
                        break;
                    }
                    if (string.equalsIgnoreCase("java.lang.Double")) {
                        if (new Double(0.0).compareTo((Double)object) == 0) {
                            this.setBoolean(n, false);
                            break;
                        }
                        this.setBoolean(n, true);
                        break;
                    }
                    throw new SQLException("Conversion not supported by setObject!!");
                }
                case -6: {
                    if (string.equalsIgnoreCase("java.lang.Float")) {
                        this.setByte(n, new Float(object.toString()).byteValue());
                        break;
                    }
                    if (string.equalsIgnoreCase("java.lang.Double")) {
                        this.setByte(n, new Double(object.toString()).byteValue());
                        break;
                    }
                    if (string.equalsIgnoreCase("java.lang.Boolean")) {
                        this.setByte(n, (byte)n4);
                        break;
                    }
                    if (string.equalsIgnoreCase("java.lang.String") || string.equalsIgnoreCase("java.lang.Integer") || string.equalsIgnoreCase("java.lang.Short") || string.equalsIgnoreCase("java.lang.Long") || string.equalsIgnoreCase("java.math.BigDecimal")) {
                        this.setByte(n, new Byte(object.toString()));
                        break;
                    }
                    throw new SQLException("Conversion not supported by setObject!!");
                }
                case 5: {
                    if (string.equalsIgnoreCase("java.lang.Float")) {
                        this.setShort(n, new Float(object.toString()).shortValue());
                        break;
                    }
                    if (string.equalsIgnoreCase("java.lang.Double")) {
                        this.setShort(n, new Double(object.toString()).shortValue());
                        break;
                    }
                    if (string.equalsIgnoreCase("java.lang.Boolean")) {
                        this.setShort(n, (short)n4);
                        break;
                    }
                    if (string.equalsIgnoreCase("java.lang.String") || string.equalsIgnoreCase("java.lang.Integer") || string.equalsIgnoreCase("java.lang.Short") || string.equalsIgnoreCase("java.lang.Long") || string.equalsIgnoreCase("java.math.BigDecimal")) {
                        this.setShort(n, new Short(object.toString()));
                        break;
                    }
                    throw new SQLException("Conversion not supported by setObject!!");
                }
                case 4: {
                    if (string.equalsIgnoreCase("java.lang.Float")) {
                        this.setInt(n, new Float(object.toString()).intValue());
                        break;
                    }
                    if (string.equalsIgnoreCase("java.lang.Double")) {
                        this.setInt(n, new Double(object.toString()).intValue());
                        break;
                    }
                    if (string.equalsIgnoreCase("java.lang.Boolean")) {
                        this.setInt(n, n4);
                        break;
                    }
                    if (string.equalsIgnoreCase("java.lang.String") || string.equalsIgnoreCase("java.lang.Integer") || string.equalsIgnoreCase("java.lang.Short") || string.equalsIgnoreCase("java.lang.Long") || string.equalsIgnoreCase("java.math.BigDecimal")) {
                        this.setInt(n, new Integer(object.toString()));
                        break;
                    }
                    throw new SQLException("Conversion not supported by setObject!!");
                }
                case -5: {
                    if (string.equalsIgnoreCase("java.lang.Float")) {
                        this.setLong(n, new Float(object.toString()).longValue());
                        break;
                    }
                    if (string.equalsIgnoreCase("java.lang.Double")) {
                        this.setLong(n, new Double(object.toString()).longValue());
                        break;
                    }
                    if (string.equalsIgnoreCase("java.lang.Boolean")) {
                        this.setLong(n, n4);
                        break;
                    }
                    if (string.equalsIgnoreCase("java.lang.String") || string.equalsIgnoreCase("java.lang.Integer") || string.equalsIgnoreCase("java.lang.Short") || string.equalsIgnoreCase("java.lang.Long") || string.equalsIgnoreCase("java.math.BigDecimal")) {
                        this.setLong(n, new Long(object.toString()));
                        break;
                    }
                    throw new SQLException("Conversion not supported by setObject!!");
                }
                case 6: 
                case 7: 
                case 8: {
                    if (string.equalsIgnoreCase("java.lang.Boolean")) {
                        this.setDouble(n, n4);
                        break;
                    }
                    if (string.equalsIgnoreCase("java.lang.String") || string.equalsIgnoreCase("java.lang.Integer") || string.equalsIgnoreCase("java.lang.Short") || string.equalsIgnoreCase("java.lang.Long") || string.equalsIgnoreCase("java.math.BigDecimal") || string.equalsIgnoreCase("java.lang.Float") || string.equalsIgnoreCase("java.lang.Double")) {
                        this.setDouble(n, new Double(object.toString()));
                        break;
                    }
                    throw new SQLException("Conversion not supported by setObject!!");
                }
                case -2: {
                    if (string.equalsIgnoreCase("java.lang.String")) {
                        this.setBytes(n, ((String)object).getBytes());
                        break;
                    }
                    if (string.equalsIgnoreCase("byte[]")) {
                        this.setBytes(n, (byte[])object);
                        break;
                    }
                    throw new SQLException("Conversion not supported by setObject!!");
                }
                case -4: 
                case -3: {
                    byte[] byArray = null;
                    if (string.equalsIgnoreCase("java.lang.String")) {
                        byArray = ((String)object).getBytes();
                    } else if (string.equalsIgnoreCase("byte[]")) {
                        byArray = (byte[])object;
                    } else {
                        throw new SQLException("Conversion not supported by setObject!!");
                    }
                    if (byArray.length > 8000) {
                        this.setBinaryStream(n, (InputStream)new ByteArrayInputStream(byArray), byArray.length);
                        break;
                    }
                    this.setBinary(n, n2, byArray);
                    break;
                }
                case 91: {
                    if (string.equalsIgnoreCase("java.lang.String")) {
                        this.setDate(n, Date.valueOf(object.toString()));
                        break;
                    }
                    if (string.equalsIgnoreCase("java.sql.Timestamp")) {
                        this.setDate(n, new Date(Timestamp.valueOf(object.toString()).getTime()));
                        break;
                    }
                    if (string.equalsIgnoreCase("java.sql.Date")) {
                        this.setDate(n, (Date)object);
                        break;
                    }
                    throw new SQLException("Conversion not supported by setObject!!");
                }
                case 92: {
                    if (string.equalsIgnoreCase("java.lang.String")) {
                        this.setTime(n, Time.valueOf(object.toString()));
                        break;
                    }
                    if (string.equalsIgnoreCase("java.sql.Timestamp")) {
                        this.setTime(n, new Time(Timestamp.valueOf(object.toString()).getTime()));
                        break;
                    }
                    if (string.equalsIgnoreCase("java.sql.Time")) {
                        this.setTime(n, (Time)object);
                        break;
                    }
                    throw new SQLException("Conversion not supported by setObject!!");
                }
                case 93: {
                    if (string.equalsIgnoreCase("java.lang.String")) {
                        this.setTimestamp(n, Timestamp.valueOf(object.toString()));
                        break;
                    }
                    if (string.equalsIgnoreCase("java.sql.Date")) {
                        this.setTimestamp(n, new Timestamp(Date.valueOf(object.toString()).getTime()));
                        break;
                    }
                    if (string.equalsIgnoreCase("java.sql.Timestamp")) {
                        this.setTimestamp(n, (Timestamp)object);
                        break;
                    }
                    throw new SQLException("Conversion not supported by setObject!!");
                }
                default: {
                    throw new SQLException("Unknown SQL Type for PreparedStatement.setObject (SQL Type=" + n2);
                }
            }
        }
        catch (SQLException sQLException) {
            throw new SQLException("SQL Exception : " + sQLException.getMessage());
        }
        catch (Exception exception) {
            throw new SQLException("Unexpected exception : " + exception.getMessage());
        }
    }

    public void addBatch(String string) throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*PreparedStatement.addBatch (" + string + ")");
        }
        throw new SQLException("Driver does not support this function", "IM001");
    }

    public void clearBatch() {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*PreparedStatement.clearBatch");
        }
        try {
            if (this.batchSqlVec != null) {
                this.cleanUpBatch();
                this.batchOn = false;
                this.batchParamsOn = false;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void addBatch() throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*PreparedStatement.addBatch");
        }
        try {
            int n;
            this.batchSqlVec = this.myConnection.getBatchVector(this);
            if (this.batchSqlVec == null) {
                this.batchSqlVec = new Vector(5, 10);
                n = 0;
            } else {
                n = this.batchSqlVec.size();
            }
            Object[] objectArray = this.arrayParams.getStoredParameterSet();
            int[] nArray = this.arrayParams.getStoredIndexSet();
            int n2 = objectArray.length;
            int n3 = nArray.length;
            if (n3 == this.numParams) {
                this.batchSqlVec.addElement(objectArray);
                this.myConnection.setBatchVector(this.batchSqlVec, this);
                this.arrayParams.storeRowIndex(n, nArray);
                this.batchOn = true;
            } else {
                if (n == 0) {
                    throw new SQLException("Parameter-Set has missing values.");
                }
                this.batchOn = true;
            }
        }
        catch (NullPointerException nullPointerException) {
            this.batchOn = false;
        }
    }

    public int[] executeBatchUpdate() throws BatchUpdateException {
        int[] nArray = new int[]{};
        if (this.numParams <= 0) {
            this.batchSize = 0;
            this.batchOn = false;
            this.batchParamsOn = false;
            return this.executeNoParametersBatch();
        }
        this.batchSqlVec = this.myConnection.getBatchVector(this);
        if (this.batchSqlVec == null) {
            nArray = new int[]{};
            return nArray;
        }
        this.batchSize = this.batchSqlVec.size();
        if (this.batchSize > 0) {
            nArray = new int[this.batchSize];
            this.FreeIntParams();
            this.paramStatusArray = new int[this.batchSize];
            this.paramsProcessed = new int[this.batchSize];
            boolean bl = true;
            int n = 0;
            try {
                if (!bl) {
                    this.OdbcApi.SQLSetStmtAttr(this.hStmt, 18, 0, 0);
                    try {
                        this.setStmtParameterSize(this.batchSize);
                        n = this.getStmtParameterAttr(22);
                    }
                    catch (SQLException sQLException) {
                        this.batchSupport = false;
                    }
                }
                if (n != this.batchSize) {
                    this.batchSupport = false;
                    try {
                        this.setStmtParameterSize(1);
                    }
                    catch (SQLException sQLException) {}
                } else {
                    this.pA2 = new long[2];
                    this.pA2[0] = 0L;
                    this.pA2[1] = 0L;
                    this.OdbcApi.SQLSetStmtAttrPtr(this.hStmt, 20, this.paramStatusArray, 0, this.pA2);
                    this.pA1 = new long[2];
                    this.pA1[0] = 0L;
                    this.pA1[1] = 0L;
                    this.OdbcApi.SQLSetStmtAttrPtr(this.hStmt, 21, this.paramsProcessed, 0, this.pA1);
                    this.batchSupport = true;
                }
            }
            catch (SQLException sQLException) {
                this.batchSupport = false;
            }
            if (this.batchSupport) {
                this.batchParamsOn = true;
                int[] nArray2 = new int[]{};
                this.arrayParams.builtColumWiseParameteSets(this.batchSize, this.batchSqlVec);
                for (int i = 0; i < this.numParams; ++i) {
                    this.arrayDef = 0;
                    this.arrayScale = 0;
                    int n2 = 0;
                    int n3 = i + 1;
                    try {
                        Object[] objectArray = this.arrayParams.getColumnWiseParamSet(n3);
                        int[] nArray3 = this.arrayParams.getColumnWiseIndexArray(n3);
                        this.setPrecisionScaleArgs(objectArray, nArray3);
                        n2 = this.getSqlType(n3);
                        this.bindArrayOfParameters(n3, n2, this.arrayDef, this.arrayScale, objectArray, nArray3);
                        continue;
                    }
                    catch (SQLException sQLException) {
                        sQLException.printStackTrace();
                    }
                }
                try {
                    if (this.execute()) {
                        this.cleanUpBatch();
                        throw new JdbcOdbcBatchUpdateException("SQL Attempt to produce a ResultSet from executeBatch", this.paramStatusArray);
                    }
                    this.paramStatusArray[0] = this.getUpdateCount();
                    this.arrayParams.clearStoredRowIndexs();
                    nArray = this.paramStatusArray;
                    this.batchOn = false;
                    this.batchParamsOn = false;
                    this.cleanUpBatch();
                }
                catch (SQLException sQLException) {
                    try {
                        this.paramStatusArray[0] = this.getUpdateCount();
                    }
                    catch (SQLException sQLException2) {
                        // empty catch block
                    }
                    nArray2 = new int[this.paramsProcessed[0] - 1];
                    this.cleanUpBatch();
                    throw new JdbcOdbcBatchUpdateException(sQLException.getMessage(), sQLException.getSQLState(), nArray2);
                }
            }
            if (!this.batchSupport) {
                this.batchOn = false;
                this.batchParamsOn = false;
                return this.emulateExecuteBatch();
            }
        }
        return nArray;
    }

    protected int[] executeNoParametersBatch() throws BatchUpdateException {
        int[] nArray = new int[1];
        try {
            if (this.execute()) {
                this.cleanUpBatch();
                throw new JdbcOdbcBatchUpdateException("SQL Attempt to produce a ResultSet from executeBatch", nArray);
            }
            this.cleanUpBatch();
            nArray[0] = this.getUpdateCount();
        }
        catch (SQLException sQLException) {
            try {
                nArray[0] = this.getUpdateCount();
            }
            catch (SQLException sQLException2) {
                // empty catch block
            }
            this.cleanUpBatch();
            throw new JdbcOdbcBatchUpdateException(sQLException.getMessage(), sQLException.getSQLState(), nArray);
        }
        return nArray;
    }

    protected int getStmtParameterAttr(int n) throws SQLException {
        try {
            this.clearWarnings();
            return this.OdbcApi.SQLGetStmtAttr(this.hStmt, n);
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            return -1;
        }
    }

    protected void setStmtParameterSize(int n) throws SQLException {
        try {
            this.clearWarnings();
            this.OdbcApi.SQLSetStmtAttr(this.hStmt, 22, n, 0);
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    protected void bindArrayOfParameters(int n, int n2, int n3, int n4, Object[] objectArray, int[] nArray) throws SQLException {
        switch (n2) {
            case 1: 
            case 2: 
            case 3: 
            case 12: {
                this.OdbcApi.SQLBindInParameterStringArray(this.hStmt, n, n2, objectArray, n3, n4, nArray);
                break;
            }
            case -1: {
                if (this.getTypeFromObjectArray(objectArray) == -4) {
                    this.arrayParams.setInputStreamElements(n, objectArray);
                    this.OdbcApi.SQLBindInParameterAtExecArray(this.hStmt, n, n2, n3, nArray);
                    break;
                }
                this.OdbcApi.SQLBindInParameterStringArray(this.hStmt, n, n2, objectArray, n3, n4, nArray);
                break;
            }
            case -7: 
            case -6: 
            case 4: 
            case 5: {
                this.OdbcApi.SQLBindInParameterIntegerArray(this.hStmt, n, n2, objectArray, nArray);
                break;
            }
            case 8: {
                this.OdbcApi.SQLBindInParameterDoubleArray(this.hStmt, n, n2, objectArray, nArray);
                break;
            }
            case -5: 
            case 6: 
            case 7: {
                this.OdbcApi.SQLBindInParameterFloatArray(this.hStmt, n, n2, objectArray, nArray);
                break;
            }
            case 91: {
                this.OdbcApi.SQLBindInParameterDateArray(this.hStmt, n, objectArray, nArray);
                break;
            }
            case 92: {
                this.OdbcApi.SQLBindInParameterTimeArray(this.hStmt, n, objectArray, nArray);
                break;
            }
            case 93: {
                this.OdbcApi.SQLBindInParameterTimestampArray(this.hStmt, n, objectArray, nArray);
                break;
            }
            case -3: 
            case -2: {
                this.OdbcApi.SQLBindInParameterBinaryArray(this.hStmt, n, n2, objectArray, n3, nArray);
                break;
            }
            case -4: {
                this.arrayParams.setInputStreamElements(n, objectArray);
                this.OdbcApi.SQLBindInParameterAtExecArray(this.hStmt, n, n2, n3, nArray);
            }
        }
    }

    protected int[] emulateExecuteBatch() throws BatchUpdateException {
        int[] nArray = new int[this.batchSize];
        int[] nArray2 = new int[]{};
        int n = 0;
        for (int i = 0; i < this.batchSize; ++i) {
            int n2;
            int n3;
            Object[] objectArray = (Object[])this.batchSqlVec.elementAt(i);
            int[] nArray3 = this.arrayParams.getStoredRowIndex(i);
            try {
                for (n3 = 0; n3 < objectArray.length; ++n3) {
                    n2 = 1111;
                    int n4 = 0;
                    int n5 = 0;
                    int n6 = n3 + 1;
                    InputStream inputStream = null;
                    n2 = JdbcOdbcPreparedStatement.getTypeFromObject(objectArray[n3]);
                    int n7 = this.getSqlType(n6);
                    if (n2 == -4) {
                        inputStream = (InputStream)objectArray[n3];
                        n4 = nArray3[n3];
                        switch (n7) {
                            case -4: {
                                n5 = 3;
                                break;
                            }
                            case -1: {
                                n5 = this.boundParams[n3].getStreamType();
                            }
                        }
                    }
                    if (n4 > 0 && 0 < n5) {
                        switch (n5) {
                            case 1: 
                            case 2: {
                                this.setStream(n6, inputStream, n4, -1, n5);
                                break;
                            }
                            case 3: {
                                this.setStream(n6, inputStream, n4, -4, n5);
                            }
                        }
                        continue;
                    }
                    if (n2 == 1111) continue;
                    if (n2 != 0) {
                        this.setObject(n6, objectArray[n3], n7);
                        continue;
                    }
                    this.setNull(n6, n7);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            try {
                if (!this.execute()) {
                    this.myConnection.removeBatchVector(this);
                    nArray[i] = this.getUpdateCount();
                    ++n;
                    continue;
                }
                for (n3 = 0; n3 < i - 1; ++n3) {
                    nArray2 = new int[n];
                    nArray2[n3] = nArray[n3];
                }
                this.cleanUpBatch();
                throw new JdbcOdbcBatchUpdateException("SQL Attempt to produce a ResultSet from executeBatch", nArray2);
            }
            catch (SQLException sQLException) {
                for (n2 = 0; n2 < i - 1; ++n2) {
                    nArray2 = new int[n];
                    nArray2[n2] = nArray[n2];
                }
                this.cleanUpBatch();
                throw new JdbcOdbcBatchUpdateException(sQLException.getMessage(), sQLException.getSQLState(), nArray2);
            }
        }
        this.cleanUpBatch();
        return nArray;
    }

    protected void cleanUpBatch() {
        this.myConnection.removeBatchVector(this);
        if (this.batchSqlVec != null) {
            this.batchSqlVec.setSize(0);
            this.batchSize = 0;
        }
    }

    protected void setPrecisionScaleArgs(Object[] objectArray, int[] nArray) {
        int n = this.getTypeFromObjectArray(objectArray);
        for (int i = 0; i < this.batchSize; ++i) {
            byte[] byArray = null;
            String string = null;
            BigDecimal bigDecimal = null;
            int n2 = 0;
            try {
                if (n == 3 || n == 2) {
                    if (objectArray[i] != null) {
                        int n3 = 0;
                        bigDecimal = (BigDecimal)objectArray[i];
                        string = bigDecimal.toString();
                        n2 = string.indexOf(46);
                        if (n2 == -1) {
                            n2 = string.length();
                        } else {
                            n3 = bigDecimal.scale();
                            n2 += n3 + 1;
                        }
                        if (n3 > this.arrayScale) {
                            this.arrayScale = n3;
                        }
                    }
                } else if (n == 1 || n == 12) {
                    if (objectArray[i] != null) {
                        string = (String)objectArray[i];
                        n2 = string.length();
                    }
                } else if (n == -4) {
                    if (nArray[i] > this.arrayDef) {
                        this.arrayDef = nArray[i];
                    }
                } else if ((n == -2 || n == -3) && objectArray[i] != null) {
                    byArray = (byte[])objectArray[i];
                    n2 = byArray.length;
                }
                if (n2 <= this.arrayDef) continue;
                this.arrayDef = n2;
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    protected void setSqlType(int n, int n2) {
        if (n >= 1 && n <= this.numParams) {
            this.boundParams[n - 1].setSqlType(n2);
        }
    }

    protected int getSqlType(int n) {
        int n2 = 1111;
        if (n >= 1 && n <= this.numParams) {
            n2 = this.boundParams[n - 1].getSqlType();
        }
        return n2;
    }

    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.clearParameter(n);
        BufferedReader bufferedReader = null;
        BufferedOutputStream bufferedOutputStream = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        ByteArrayInputStream byteArrayInputStream = null;
        String string = this.OdbcApi.charSet;
        int n3 = 300;
        if (n2 < n3) {
            n3 = n2;
        }
        int n4 = 0;
        int n5 = 0;
        try {
            n5 = (int)Charset.forName(string).newEncoder().maxBytesPerChar();
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
            // empty catch block
        }
        if (n5 == 0) {
            n5 = 1;
        }
        try {
            if (reader != null) {
                boolean bl = false;
                int n6 = 0;
                bufferedReader = new BufferedReader(reader);
                byteArrayOutputStream = new ByteArrayOutputStream();
                bufferedOutputStream = new BufferedOutputStream(byteArrayOutputStream);
                char[] cArray = new char[n3];
                while (n6 != -1) {
                    int n7;
                    byte[] byArray = new byte[]{};
                    n6 = bufferedReader.read(cArray);
                    if (n6 == -1) continue;
                    char[] cArray2 = new char[n6];
                    for (n7 = 0; n7 < n6; ++n7) {
                        cArray2[n7] = cArray[n7];
                    }
                    byArray = this.CharsToBytes(string, cArray2);
                    n7 = byArray.length - 1;
                    bufferedOutputStream.write(byArray, 0, n7);
                    bufferedOutputStream.flush();
                }
                n4 = byteArrayOutputStream.size();
                byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            }
        }
        catch (IOException iOException) {
            throw new SQLException("CharsToBytes Reader Conversion: " + iOException.getMessage());
        }
        this.setStream(n, byteArrayInputStream, n4, -1, 3);
    }

    public void setRef(int n, Ref ref) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setBlob(int n, Blob blob) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setClob(int n, Clob clob) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setArray(int n, Array array) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*PreparedStatement.getMetaData");
        }
        JdbcOdbcResultSet jdbcOdbcResultSet = null;
        if (this.hStmt == 0L) {
            throw new SQLException("Statement is closed");
        }
        jdbcOdbcResultSet = new JdbcOdbcResultSet();
        jdbcOdbcResultSet.initialize(this.OdbcApi, this.hDbc, this.hStmt, true, null);
        return new JdbcOdbcResultSetMetaData(this.OdbcApi, (JdbcOdbcResultSetInterface)jdbcOdbcResultSet);
    }

    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        if (date == null) {
            this.setNull(n, 91);
            return;
        }
        long l = this.utils.convertToGMT(date, calendar);
        date = new Date(l);
        calendar = Calendar.getInstance();
        calendar.setTime(date);
        this.clearParameter(n);
        this.setInputParameter(n, true);
        byte[] byArray = this.allocBindBuf(n, 32);
        long[] lArray = new long[]{0L, 0L};
        if (!this.batchOn) {
            this.OdbcApi.SQLBindInParameterCalendarDate(this.hStmt, n, calendar, byArray, lArray);
        }
        this.boundParams[n - 1].pA1 = lArray[0];
        this.boundParams[n - 1].pA2 = lArray[1];
        this.boundParams[n - 1].boundType = 91;
        this.boundParams[n - 1].boundValue = date;
        this.arrayParams.storeValue(n - 1, calendar, -3);
        this.setSqlType(n, 91);
    }

    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        if (time == null) {
            this.setNull(n, 92);
            return;
        }
        long l = this.utils.convertToGMT(time, calendar);
        time = new Time(l);
        calendar = Calendar.getInstance();
        calendar.setTime(time);
        this.clearParameter(n);
        this.setInputParameter(n, true);
        byte[] byArray = this.allocBindBuf(n, 32);
        long[] lArray = new long[]{0L, 0L};
        if (!this.batchOn) {
            this.OdbcApi.SQLBindInParameterCalendarTime(this.hStmt, n, calendar, byArray, lArray);
        }
        this.boundParams[n - 1].pA1 = lArray[0];
        this.boundParams[n - 1].pA2 = lArray[1];
        this.boundParams[n - 1].boundType = 92;
        this.boundParams[n - 1].boundValue = time;
        this.arrayParams.storeValue(n - 1, calendar, -3);
        this.setSqlType(n, 92);
    }

    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        if (timestamp == null) {
            this.setNull(n, 93);
            return;
        }
        long l = this.utils.convertToGMT(timestamp, calendar);
        timestamp = new Timestamp(l);
        calendar = Calendar.getInstance();
        calendar.setTime(timestamp);
        this.clearParameter(n);
        this.setInputParameter(n, true);
        byte[] byArray = this.allocBindBuf(n, 32);
        long[] lArray = new long[]{0L, 0L};
        if (!this.batchOn) {
            this.OdbcApi.SQLBindInParameterCalendarTimestamp(this.hStmt, n, calendar, byArray, lArray);
        }
        this.boundParams[n - 1].pA1 = lArray[0];
        this.boundParams[n - 1].pA2 = lArray[1];
        this.boundParams[n - 1].boundType = 93;
        this.boundParams[n - 1].boundValue = timestamp;
        this.arrayParams.storeValue(n - 1, calendar, -3);
        this.setSqlType(n, 93);
    }

    public void setNull(int n, int n2, String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void initBoundParam() throws SQLException {
        this.numParams = this.OdbcApi.SQLNumParams(this.hStmt);
        if (this.numParams > 0) {
            this.boundParams = new JdbcOdbcBoundParam[this.numParams];
            for (int i = 0; i < this.numParams; ++i) {
                this.boundParams[i] = new JdbcOdbcBoundParam();
                this.boundParams[i].initialize();
            }
            this.arrayParams = new JdbcOdbcBoundArrayOfParams(this.numParams);
            this.batchRCFlag = this.myConnection.getBatchRowCountFlag(1);
            this.batchSupport = this.batchRCFlag > 0 && this.batchRCFlag == 1;
            this.StringDef = 0;
            this.NumberDef = 0;
            this.NumberDef = 0;
            this.binaryPrec = 0;
        }
    }

    protected byte[] allocBindBuf(int n, int n2) {
        byte[] byArray = null;
        if (n >= 1 && n <= this.numParams) {
            byArray = this.boundParams[n - 1].allocBindDataBuffer(n2);
        }
        return byArray;
    }

    protected byte[] getDataBuf(int n) {
        byte[] byArray = null;
        if (n >= 1 && n <= this.numParams) {
            byArray = this.boundParams[n - 1].getBindDataBuffer();
        }
        return byArray;
    }

    protected byte[] getLengthBuf(int n) {
        byte[] byArray = null;
        if (n >= 1 && n <= this.numParams) {
            byArray = this.boundParams[n - 1].getBindLengthBuffer();
        }
        return byArray;
    }

    public int getParamLength(int n) {
        int n2 = -1;
        if (n >= 1 && n <= this.numParams) {
            n2 = this.OdbcApi.bufferToInt(this.boundParams[n - 1].getBindLengthBuffer());
        }
        return n2;
    }

    protected void putParamData(int n) throws SQLException, JdbcOdbcSQLWarning {
        int n2 = 2000;
        byte[] byArray = new byte[n2];
        boolean bl = false;
        if (n < 1 || n > this.numParams) {
            if (this.OdbcApi.getTracer().isTracing()) {
                this.OdbcApi.getTracer().trace("Invalid index for putParamData()");
            }
            return;
        }
        InputStream inputStream = this.boundParams[n - 1].getInputStream();
        int n3 = this.boundParams[n - 1].getInputStreamLen();
        int n4 = this.boundParams[n - 1].getStreamType();
        while (!bl) {
            int n5;
            try {
                if (this.OdbcApi.getTracer().isTracing()) {
                    this.OdbcApi.getTracer().trace("Reading from input stream");
                }
                n5 = inputStream.read(byArray);
                if (this.OdbcApi.getTracer().isTracing()) {
                    this.OdbcApi.getTracer().trace("Bytes read: " + n5);
                }
            }
            catch (IOException iOException) {
                throw new SQLException(iOException.getMessage());
            }
            if (n5 == -1) {
                if (n3 != 0) {
                    throw new SQLException("End of InputStream reached before satisfying length specified when InputStream was set");
                }
                bl = true;
                break;
            }
            if (n5 > n3) {
                n5 = n3;
                bl = true;
            }
            int n6 = n5;
            if (n4 == 2) {
                n6 = n5 / 2;
                for (int i = 0; i < n6; ++i) {
                    byArray[i] = byArray[i * 2 + 1];
                }
            }
            this.OdbcApi.SQLPutData(this.hStmt, byArray, n6);
            n3 -= n5;
            if (this.OdbcApi.getTracer().isTracing()) {
                this.OdbcApi.getTracer().trace("" + n3 + " bytes remaining");
            }
            if (n3 != 0) continue;
            bl = true;
        }
    }

    public void setStream(int n, InputStream inputStream, int n2, int n3, int n4) throws SQLException {
        this.clearParameter(n);
        this.setInputParameter(n, true);
        byte[] byArray = this.getLengthBuf(n);
        byte[] byArray2 = this.allocBindBuf(n, 4);
        long[] lArray = new long[]{0L, 0L, 0L, 0L};
        if (!this.batchOn) {
            this.OdbcApi.SQLBindInParameterAtExec(this.hStmt, n, n3, n2, byArray2, byArray, lArray);
        }
        this.boundParams[n - 1].pA1 = lArray[0];
        this.boundParams[n - 1].pA2 = lArray[1];
        this.boundParams[n - 1].pB1 = lArray[2];
        this.boundParams[n - 1].pB2 = lArray[3];
        this.boundParams[n - 1].boundType = n3;
        this.boundParams[n - 1].boundValue = inputStream;
        this.boundParams[n - 1].setInputStream(inputStream, n2);
        this.boundParams[n - 1].setStreamType(n4);
        this.arrayParams.storeValue(n - 1, inputStream, n2);
        this.setSqlType(n, n3);
    }

    protected void setChar(int n, int n2, int n3, String string) throws SQLException {
        this.clearParameter(n);
        this.setInputParameter(n, true);
        int n4 = 0;
        boolean bl = false;
        char[] cArray = string.toCharArray();
        byte[] byArray = new byte[]{};
        try {
            byArray = this.CharsToBytes(this.OdbcApi.charSet, cArray);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        byte[] byArray2 = this.allocBindBuf(n, byArray.length);
        n4 = this.getPrecision(n2);
        if (n4 < 0 || n4 > 8000) {
            n4 = byArray.length;
        }
        long[] lArray = new long[]{0L, 0L, 0L, 0L};
        if (!this.batchOn) {
            this.OdbcApi.SQLBindInParameterString(this.hStmt, n, n2, n4, n3, byArray, byArray2, lArray);
        }
        this.boundParams[n - 1].pA1 = lArray[0];
        this.boundParams[n - 1].pA2 = lArray[1];
        this.boundParams[n - 1].pB1 = lArray[2];
        this.boundParams[n - 1].pB2 = lArray[3];
        this.boundParams[n - 1].scale = n3;
        this.boundParams[n - 1].boundType = n2;
        this.boundParams[n - 1].boundValue = string;
        if (n2 == 2 || n2 == 3) {
            this.arrayParams.storeValue(n - 1, new BigDecimal(string.trim()), -3);
            this.NumberDef = n4;
            if (n3 > this.NumberScale) {
                this.NumberScale = n3;
            }
        } else if (n2 == -5) {
            this.arrayParams.storeValue(n - 1, new BigInteger(string.trim()), -3);
            this.NumberDef = n4;
            if (n3 > this.NumberScale) {
                this.NumberScale = n3;
            }
        } else {
            this.arrayParams.storeValue(n - 1, string, -3);
            this.StringDef = n4;
        }
        this.setSqlType(n, n2);
    }

    protected void setBinary(int n, int n2, byte[] byArray) throws SQLException {
        this.clearParameter(n);
        this.setInputParameter(n, true);
        byte[] byArray2 = this.allocBindBuf(n, byArray.length);
        byte[] byArray3 = this.getLengthBuf(n);
        long[] lArray = new long[]{0L, 0L, 0L, 0L, 0L, 0L};
        if (!this.batchOn) {
            this.OdbcApi.SQLBindInParameterBinary(this.hStmt, n, n2, byArray, byArray2, byArray3, lArray);
        }
        this.boundParams[n - 1].pA1 = lArray[0];
        this.boundParams[n - 1].pA2 = lArray[1];
        this.boundParams[n - 1].pB1 = lArray[2];
        this.boundParams[n - 1].pB2 = lArray[3];
        this.boundParams[n - 1].pC1 = lArray[4];
        this.boundParams[n - 1].pC2 = lArray[5];
        this.boundParams[n - 1].boundType = n2;
        this.boundParams[n - 1].boundValue = byArray;
        this.binaryPrec = byArray.length;
        this.arrayParams.storeValue(n - 1, byArray, -3);
        this.setSqlType(n, n2);
    }

    protected int getTypeFromObjectArray(Object[] objectArray) {
        int n = 1111;
        for (int i = 0; i < this.batchSize && (n = JdbcOdbcPreparedStatement.getTypeFromObject(objectArray[i])) == 0; ++i) {
        }
        return n;
    }

    public synchronized void close() throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*PreparedStatement.close");
        }
        this.clearMyResultSet();
        try {
            this.clearWarnings();
            if (this.hStmt != 0L) {
                if (this.closeCalledFromFinalize) {
                    if (!this.myConnection.isFreeStmtsFromConnectionOnly()) {
                        this.OdbcApi.SQLFreeStmt(this.hStmt, 1);
                    }
                } else {
                    this.OdbcApi.SQLFreeStmt(this.hStmt, 1);
                }
                this.hStmt = 0L;
                this.FreeParams();
                for (int i = 1; this.boundParams != null && i <= this.boundParams.length; ++i) {
                    this.boundParams[i - 1].binaryData = null;
                    this.boundParams[i - 1].initialize();
                    this.boundParams[i - 1].paramInputStream = null;
                    this.boundParams[i - 1].inputParameter = false;
                }
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.FreeIntParams();
        this.myConnection.deregisterStatement(this);
        if (this.batchOn) {
            this.clearBatch();
        }
    }

    public synchronized void FreeIntParams() {
        if (this.pA1 != null && this.pA1[0] != 0L) {
            JdbcOdbc.ReleaseStoredIntegers(this.pA1[0], this.pA1[1]);
            this.pA1[0] = 0L;
            this.pA1[1] = 0L;
        }
        if (this.pA2 != null && this.pA2[0] != 0L) {
            JdbcOdbc.ReleaseStoredIntegers(this.pA2[0], this.pA2[1]);
            this.pA2[0] = 0L;
            this.pA2[1] = 0L;
        }
    }

    public synchronized void FreeParams() throws NullPointerException {
        try {
            for (int i = 1; i <= this.boundParams.length; ++i) {
                if (this.boundParams[i - 1].pA1 != 0L) {
                    JdbcOdbc.ReleaseStoredBytes(this.boundParams[i - 1].pA1, this.boundParams[i - 1].pA2);
                    this.boundParams[i - 1].pA1 = 0L;
                    this.boundParams[i - 1].pA2 = 0L;
                }
                if (this.boundParams[i - 1].pB1 != 0L) {
                    JdbcOdbc.ReleaseStoredBytes(this.boundParams[i - 1].pB1, this.boundParams[i - 1].pB2);
                    this.boundParams[i - 1].pB1 = 0L;
                    this.boundParams[i - 1].pB2 = 0L;
                }
                if (this.boundParams[i - 1].pC1 != 0L) {
                    JdbcOdbc.ReleaseStoredBytes(this.boundParams[i - 1].pC1, this.boundParams[i - 1].pC2);
                    this.boundParams[i - 1].pC1 = 0L;
                    this.boundParams[i - 1].pC2 = 0L;
                }
                if (this.boundParams[i - 1].pS1 == 0L) continue;
                JdbcOdbc.ReleaseStoredChars(this.boundParams[i - 1].pS1, this.boundParams[i - 1].pS2);
                this.boundParams[i - 1].pS1 = 0L;
                this.boundParams[i - 1].pS2 = 0L;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void setSql(String string) {
        this.mySql = string.toUpperCase();
    }

    public Object[] getObjects() {
        Object[] objectArray = new Object[this.numParams];
        Object[] objectArray2 = this.arrayParams.getStoredParameterSet();
        if (objectArray2 != null) {
            try {
                for (int i = 0; i < this.numParams; ++i) {
                    objectArray[i] = objectArray2[i];
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                System.out.println("Exception, while calculating row count: " + arrayIndexOutOfBoundsException.getMessage());
                arrayIndexOutOfBoundsException.printStackTrace();
            }
        }
        return objectArray;
    }

    public int[] getObjectTypes() {
        int[] nArray = new int[this.numParams];
        for (int i = 0; i < this.numParams; ++i) {
            nArray[i] = this.boundParams[i].getSqlType();
        }
        return nArray;
    }

    public int getParamCount() {
        return this.numParams;
    }

    protected void setInputParameter(int n, boolean bl) {
        if (n >= 1 && n <= this.numParams) {
            this.boundParams[n - 1].setInputParameter(bl);
        }
    }

    public void setURL(int n, URL uRL) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setRowId(int n, RowId rowId) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setNString(int n, String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setNCharacterStream(int n, Reader reader, long l) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setNClob(int n, NClob nClob) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setClob(int n, Reader reader, long l) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setBlob(int n, InputStream inputStream, long l) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setNClob(int n, Reader reader, long l) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setSQLXML(int n, SQLXML sQLXML) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setPoolable(boolean bl) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean isPoolable() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean isClosed() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setCharacterStream(int n, Reader reader, long l) throws SQLException {
    }

    public void setBinaryStream(int n, InputStream inputStream, long l) throws SQLException {
    }

    public void setAsciiStream(int n, InputStream inputStream, long l) throws SQLException {
    }

    public void setAsciiStream(int n, InputStream inputStream) throws SQLException {
    }

    public void setBinaryStream(int n, InputStream inputStream) throws SQLException {
    }

    public void setCharacterStream(int n, Reader reader) throws SQLException {
    }

    public void setNCharacterStream(int n, Reader reader) throws SQLException {
    }

    public void setClob(int n, Reader reader) throws SQLException {
    }

    public void setBlob(int n, InputStream inputStream) throws SQLException {
    }

    public void setNClob(int n, Reader reader) throws SQLException {
    }
}

