/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent.locks;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.AbstractOwnableSynchronizer;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.LockSupport;
import sun.misc.Unsafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractQueuedSynchronizer
extends AbstractOwnableSynchronizer
implements Serializable {
    private static final long serialVersionUID = 7373984972572414691L;
    private volatile transient Node head;
    private volatile transient Node tail;
    private volatile int state;
    static final long spinForTimeoutThreshold = 1000L;
    private static final Unsafe unsafe = Unsafe.getUnsafe();
    private static final long stateOffset;
    private static final long headOffset;
    private static final long tailOffset;
    private static final long waitStatusOffset;
    private static final long nextOffset;

    protected AbstractQueuedSynchronizer() {
    }

    protected final int getState() {
        return this.state;
    }

    protected final void setState(int n) {
        this.state = n;
    }

    protected final boolean compareAndSetState(int n, int n2) {
        return unsafe.compareAndSwapInt(this, stateOffset, n, n2);
    }

    private Node enq(Node node) {
        Node node2;
        while (true) {
            if ((node2 = this.tail) == null) {
                Node node3 = new Node();
                node3.next = node;
                node.prev = node3;
                if (!this.compareAndSetHead(node3)) continue;
                this.tail = node;
                return node3;
            }
            node.prev = node2;
            if (this.compareAndSetTail(node2, node)) break;
        }
        node2.next = node;
        return node2;
    }

    private Node addWaiter(Node node) {
        Node node2 = new Node(Thread.currentThread(), node);
        Node node3 = this.tail;
        if (node3 != null) {
            node2.prev = node3;
            if (this.compareAndSetTail(node3, node2)) {
                node3.next = node2;
                return node2;
            }
        }
        this.enq(node2);
        return node2;
    }

    private void setHead(Node node) {
        this.head = node;
        node.thread = null;
        node.prev = null;
    }

    private void unparkSuccessor(Node node) {
        AbstractQueuedSynchronizer.compareAndSetWaitStatus(node, -1, 0);
        Node node2 = node.next;
        if (node2 == null || node2.waitStatus > 0) {
            node2 = null;
            Node node3 = this.tail;
            while (node3 != null && node3 != node) {
                if (node3.waitStatus <= 0) {
                    node2 = node3;
                }
                node3 = node3.prev;
            }
        }
        if (node2 != null) {
            LockSupport.unpark(node2.thread);
        }
    }

    private void setHeadAndPropagate(Node node, int n) {
        Node node2;
        this.setHead(node);
        if (n > 0 && node.waitStatus != 0 && ((node2 = node.next) == null || node2.isShared())) {
            this.unparkSuccessor(node);
        }
    }

    private void cancelAcquire(Node node) {
        if (node == null) {
            return;
        }
        node.thread = null;
        Node node2 = node.prev;
        while (node2.waitStatus > 0) {
            node.prev = node2 = node2.prev;
        }
        Node node3 = node2.next;
        node.waitStatus = 1;
        if (node == this.tail && this.compareAndSetTail(node, node2)) {
            AbstractQueuedSynchronizer.compareAndSetNext(node2, node3, null);
        } else {
            if (node2 != this.head && (node2.waitStatus == -1 || AbstractQueuedSynchronizer.compareAndSetWaitStatus(node2, 0, -1)) && node2.thread != null) {
                Node node4 = node.next;
                if (node4 != null && node4.waitStatus <= 0) {
                    AbstractQueuedSynchronizer.compareAndSetNext(node2, node3, node4);
                }
            } else {
                this.unparkSuccessor(node);
            }
            node.next = node;
        }
    }

    private static boolean shouldParkAfterFailedAcquire(Node node, Node node2) {
        int n = node.waitStatus;
        if (n < 0) {
            return true;
        }
        if (n > 0) {
            do {
                node2.prev = node = node.prev;
            } while (node.waitStatus > 0);
            node.next = node2;
        } else {
            AbstractQueuedSynchronizer.compareAndSetWaitStatus(node, 0, -1);
        }
        return false;
    }

    private static void selfInterrupt() {
        Thread.currentThread().interrupt();
    }

    private final boolean parkAndCheckInterrupt() {
        LockSupport.park(this);
        return Thread.interrupted();
    }

    final boolean acquireQueued(Node node, int n) {
        try {
            boolean bl = false;
            while (true) {
                Node node2;
                if ((node2 = node.predecessor()) == this.head && this.tryAcquire(n)) {
                    this.setHead(node);
                    node2.next = null;
                    return bl;
                }
                if (!AbstractQueuedSynchronizer.shouldParkAfterFailedAcquire(node2, node) || !this.parkAndCheckInterrupt()) continue;
                bl = true;
            }
        }
        catch (RuntimeException runtimeException) {
            this.cancelAcquire(node);
            throw runtimeException;
        }
    }

    private void doAcquireInterruptibly(int n) throws InterruptedException {
        Node node = this.addWaiter(Node.EXCLUSIVE);
        try {
            Node node2;
            do {
                if ((node2 = node.predecessor()) != this.head || !this.tryAcquire(n)) continue;
                this.setHead(node);
                node2.next = null;
                return;
            } while (!AbstractQueuedSynchronizer.shouldParkAfterFailedAcquire(node2, node) || !this.parkAndCheckInterrupt());
        }
        catch (RuntimeException runtimeException) {
            this.cancelAcquire(node);
            throw runtimeException;
        }
        this.cancelAcquire(node);
        throw new InterruptedException();
    }

    private boolean doAcquireNanos(int n, long l) throws InterruptedException {
        long l2 = System.nanoTime();
        Node node = this.addWaiter(Node.EXCLUSIVE);
        try {
            do {
                Node node2;
                if ((node2 = node.predecessor()) == this.head && this.tryAcquire(n)) {
                    this.setHead(node);
                    node2.next = null;
                    return true;
                }
                if (l <= 0L) {
                    this.cancelAcquire(node);
                    return false;
                }
                if (l > 1000L && AbstractQueuedSynchronizer.shouldParkAfterFailedAcquire(node2, node)) {
                    LockSupport.parkNanos(this, l);
                }
                long l3 = System.nanoTime();
                l -= l3 - l2;
                l2 = l3;
            } while (!Thread.interrupted());
        }
        catch (RuntimeException runtimeException) {
            this.cancelAcquire(node);
            throw runtimeException;
        }
        this.cancelAcquire(node);
        throw new InterruptedException();
    }

    private void doAcquireShared(int n) {
        Node node = this.addWaiter(Node.SHARED);
        try {
            boolean bl = false;
            while (true) {
                int n2;
                Node node2;
                if ((node2 = node.predecessor()) == this.head && (n2 = this.tryAcquireShared(n)) >= 0) {
                    this.setHeadAndPropagate(node, n2);
                    node2.next = null;
                    if (bl) {
                        AbstractQueuedSynchronizer.selfInterrupt();
                    }
                    return;
                }
                if (!AbstractQueuedSynchronizer.shouldParkAfterFailedAcquire(node2, node) || !this.parkAndCheckInterrupt()) continue;
                bl = true;
            }
        }
        catch (RuntimeException runtimeException) {
            this.cancelAcquire(node);
            throw runtimeException;
        }
    }

    private void doAcquireSharedInterruptibly(int n) throws InterruptedException {
        Node node = this.addWaiter(Node.SHARED);
        try {
            Node node2;
            do {
                int n2;
                if ((node2 = node.predecessor()) != this.head || (n2 = this.tryAcquireShared(n)) < 0) continue;
                this.setHeadAndPropagate(node, n2);
                node2.next = null;
                return;
            } while (!AbstractQueuedSynchronizer.shouldParkAfterFailedAcquire(node2, node) || !this.parkAndCheckInterrupt());
        }
        catch (RuntimeException runtimeException) {
            this.cancelAcquire(node);
            throw runtimeException;
        }
        this.cancelAcquire(node);
        throw new InterruptedException();
    }

    private boolean doAcquireSharedNanos(int n, long l) throws InterruptedException {
        long l2 = System.nanoTime();
        Node node = this.addWaiter(Node.SHARED);
        try {
            do {
                int n2;
                Node node2;
                if ((node2 = node.predecessor()) == this.head && (n2 = this.tryAcquireShared(n)) >= 0) {
                    this.setHeadAndPropagate(node, n2);
                    node2.next = null;
                    return true;
                }
                if (l <= 0L) {
                    this.cancelAcquire(node);
                    return false;
                }
                if (l > 1000L && AbstractQueuedSynchronizer.shouldParkAfterFailedAcquire(node2, node)) {
                    LockSupport.parkNanos(this, l);
                }
                long l3 = System.nanoTime();
                l -= l3 - l2;
                l2 = l3;
            } while (!Thread.interrupted());
        }
        catch (RuntimeException runtimeException) {
            this.cancelAcquire(node);
            throw runtimeException;
        }
        this.cancelAcquire(node);
        throw new InterruptedException();
    }

    protected boolean tryAcquire(int n) {
        throw new UnsupportedOperationException();
    }

    protected boolean tryRelease(int n) {
        throw new UnsupportedOperationException();
    }

    protected int tryAcquireShared(int n) {
        throw new UnsupportedOperationException();
    }

    protected boolean tryReleaseShared(int n) {
        throw new UnsupportedOperationException();
    }

    protected boolean isHeldExclusively() {
        throw new UnsupportedOperationException();
    }

    public final void acquire(int n) {
        if (!this.tryAcquire(n) && this.acquireQueued(this.addWaiter(Node.EXCLUSIVE), n)) {
            AbstractQueuedSynchronizer.selfInterrupt();
        }
    }

    public final void acquireInterruptibly(int n) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (!this.tryAcquire(n)) {
            this.doAcquireInterruptibly(n);
        }
    }

    public final boolean tryAcquireNanos(int n, long l) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        return this.tryAcquire(n) || this.doAcquireNanos(n, l);
    }

    public final boolean release(int n) {
        if (this.tryRelease(n)) {
            Node node = this.head;
            if (node != null && node.waitStatus != 0) {
                this.unparkSuccessor(node);
            }
            return true;
        }
        return false;
    }

    public final void acquireShared(int n) {
        if (this.tryAcquireShared(n) < 0) {
            this.doAcquireShared(n);
        }
    }

    public final void acquireSharedInterruptibly(int n) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (this.tryAcquireShared(n) < 0) {
            this.doAcquireSharedInterruptibly(n);
        }
    }

    public final boolean tryAcquireSharedNanos(int n, long l) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        return this.tryAcquireShared(n) >= 0 || this.doAcquireSharedNanos(n, l);
    }

    public final boolean releaseShared(int n) {
        if (this.tryReleaseShared(n)) {
            Node node = this.head;
            if (node != null && node.waitStatus != 0) {
                this.unparkSuccessor(node);
            }
            return true;
        }
        return false;
    }

    public final boolean hasQueuedThreads() {
        return this.head != this.tail;
    }

    public final boolean hasContended() {
        return this.head != null;
    }

    public final Thread getFirstQueuedThread() {
        return this.head == this.tail ? null : this.fullGetFirstQueuedThread();
    }

    private Thread fullGetFirstQueuedThread() {
        Thread thread;
        Node node;
        Node node2 = this.head;
        if (node2 != null && (node = node2.next) != null && node.prev == this.head && (thread = node.thread) != null || (node2 = this.head) != null && (node = node2.next) != null && node.prev == this.head && (thread = node.thread) != null) {
            return thread;
        }
        Node node3 = this.tail;
        Thread thread2 = null;
        while (node3 != null && node3 != this.head) {
            Thread thread3 = node3.thread;
            if (thread3 != null) {
                thread2 = thread3;
            }
            node3 = node3.prev;
        }
        return thread2;
    }

    public final boolean isQueued(Thread thread) {
        if (thread == null) {
            throw new NullPointerException();
        }
        Node node = this.tail;
        while (node != null) {
            if (node.thread == thread) {
                return true;
            }
            node = node.prev;
        }
        return false;
    }

    final boolean apparentlyFirstQueuedIsExclusive() {
        Node node;
        Node node2 = this.head;
        return node2 != null && (node = node2.next) != null && node.nextWaiter != Node.SHARED;
    }

    final boolean isFirst(Thread thread) {
        Node node;
        Node node2 = this.head;
        return node2 == null || (node = node2.next) != null && node.thread == thread || this.fullIsFirst(thread);
    }

    final boolean fullIsFirst(Thread thread) {
        Node node;
        Thread thread2 = null;
        Node node2 = this.head;
        if (node2 != null && (node = node2.next) != null && node.prev == this.head && (thread2 = node.thread) != null) {
            return thread2 == thread;
        }
        Node node3 = this.tail;
        while (node3 != null && node3 != this.head) {
            Thread thread3 = node3.thread;
            if (thread3 != null) {
                thread2 = thread3;
            }
            node3 = node3.prev;
        }
        return thread2 == thread || thread2 == null;
    }

    public final int getQueueLength() {
        int n = 0;
        Node node = this.tail;
        while (node != null) {
            if (node.thread != null) {
                ++n;
            }
            node = node.prev;
        }
        return n;
    }

    public final Collection<Thread> getQueuedThreads() {
        ArrayList<Thread> arrayList = new ArrayList<Thread>();
        Node node = this.tail;
        while (node != null) {
            Thread thread = node.thread;
            if (thread != null) {
                arrayList.add(thread);
            }
            node = node.prev;
        }
        return arrayList;
    }

    public final Collection<Thread> getExclusiveQueuedThreads() {
        ArrayList<Thread> arrayList = new ArrayList<Thread>();
        Node node = this.tail;
        while (node != null) {
            Thread thread;
            if (!node.isShared() && (thread = node.thread) != null) {
                arrayList.add(thread);
            }
            node = node.prev;
        }
        return arrayList;
    }

    public final Collection<Thread> getSharedQueuedThreads() {
        ArrayList<Thread> arrayList = new ArrayList<Thread>();
        Node node = this.tail;
        while (node != null) {
            Thread thread;
            if (node.isShared() && (thread = node.thread) != null) {
                arrayList.add(thread);
            }
            node = node.prev;
        }
        return arrayList;
    }

    public String toString() {
        int n = this.getState();
        String string = this.hasQueuedThreads() ? "non" : "";
        return super.toString() + "[State = " + n + ", " + string + "empty queue]";
    }

    final boolean isOnSyncQueue(Node node) {
        if (node.waitStatus == -2 || node.prev == null) {
            return false;
        }
        if (node.next != null) {
            return true;
        }
        return this.findNodeFromTail(node);
    }

    private boolean findNodeFromTail(Node node) {
        Node node2 = this.tail;
        while (node2 != node) {
            if (node2 == null) {
                return false;
            }
            node2 = node2.prev;
        }
        return true;
    }

    final boolean transferForSignal(Node node) {
        if (!AbstractQueuedSynchronizer.compareAndSetWaitStatus(node, -2, 0)) {
            return false;
        }
        Node node2 = this.enq(node);
        int n = node2.waitStatus;
        if (n > 0 || !AbstractQueuedSynchronizer.compareAndSetWaitStatus(node2, n, -1)) {
            LockSupport.unpark(node.thread);
        }
        return true;
    }

    final boolean transferAfterCancelledWait(Node node) {
        if (AbstractQueuedSynchronizer.compareAndSetWaitStatus(node, -2, 0)) {
            this.enq(node);
            return true;
        }
        while (!this.isOnSyncQueue(node)) {
            Thread.yield();
        }
        return false;
    }

    final int fullyRelease(Node node) {
        try {
            int n = this.getState();
            if (this.release(n)) {
                return n;
            }
        }
        catch (RuntimeException runtimeException) {
            node.waitStatus = 1;
            throw runtimeException;
        }
        node.waitStatus = 1;
        throw new IllegalMonitorStateException();
    }

    public final boolean owns(ConditionObject conditionObject) {
        if (conditionObject == null) {
            throw new NullPointerException();
        }
        return conditionObject.isOwnedBy(this);
    }

    public final boolean hasWaiters(ConditionObject conditionObject) {
        if (!this.owns(conditionObject)) {
            throw new IllegalArgumentException("Not owner");
        }
        return conditionObject.hasWaiters();
    }

    public final int getWaitQueueLength(ConditionObject conditionObject) {
        if (!this.owns(conditionObject)) {
            throw new IllegalArgumentException("Not owner");
        }
        return conditionObject.getWaitQueueLength();
    }

    public final Collection<Thread> getWaitingThreads(ConditionObject conditionObject) {
        if (!this.owns(conditionObject)) {
            throw new IllegalArgumentException("Not owner");
        }
        return conditionObject.getWaitingThreads();
    }

    private final boolean compareAndSetHead(Node node) {
        return unsafe.compareAndSwapObject(this, headOffset, null, node);
    }

    private final boolean compareAndSetTail(Node node, Node node2) {
        return unsafe.compareAndSwapObject(this, tailOffset, node, node2);
    }

    private static final boolean compareAndSetWaitStatus(Node node, int n, int n2) {
        return unsafe.compareAndSwapInt(node, waitStatusOffset, n, n2);
    }

    private static final boolean compareAndSetNext(Node node, Node node2, Node node3) {
        return unsafe.compareAndSwapObject(node, nextOffset, node2, node3);
    }

    static /* synthetic */ void access$000() {
        AbstractQueuedSynchronizer.selfInterrupt();
    }

    static {
        try {
            stateOffset = unsafe.objectFieldOffset(AbstractQueuedSynchronizer.class.getDeclaredField("state"));
            headOffset = unsafe.objectFieldOffset(AbstractQueuedSynchronizer.class.getDeclaredField("head"));
            tailOffset = unsafe.objectFieldOffset(AbstractQueuedSynchronizer.class.getDeclaredField("tail"));
            waitStatusOffset = unsafe.objectFieldOffset(Node.class.getDeclaredField("waitStatus"));
            nextOffset = unsafe.objectFieldOffset(Node.class.getDeclaredField("next"));
        }
        catch (Exception exception) {
            throw new Error(exception);
        }
    }

    public class ConditionObject
    implements Condition,
    Serializable {
        private static final long serialVersionUID = 1173984872572414699L;
        private transient ConditionNode firstWaiter;
        private transient ConditionNode lastWaiter;
        static final long OOME_COND_WAIT_DELAY = 10000000L;

        private void doSignal(ConditionNode first, boolean all) {
            while (first != null) {
                ConditionNode next = first.nextWaiter;
                this.firstWaiter = next;
                if (this.firstWaiter == null) {
                    this.lastWaiter = null;
                } else {
                    first.nextWaiter = null;
                }
                if ((first.getAndUnsetStatus(2) & 2) != 0) {
                    AbstractQueuedSynchronizer.this.enqueue(first);
                    if (!all) break;
                }
                first = next;
            }
        }

        @Override
        public final void signal() {
            ConditionNode first = this.firstWaiter;
            if (!AbstractQueuedSynchronizer.this.isHeldExclusively()) {
                throw new IllegalMonitorStateException();
            }
            if (first != null) {
                this.doSignal(first, false);
            }
        }

        @Override
        public final void signalAll() {
            ConditionNode first = this.firstWaiter;
            if (!AbstractQueuedSynchronizer.this.isHeldExclusively()) {
                throw new IllegalMonitorStateException();
            }
            if (first != null) {
                this.doSignal(first, true);
            }
        }

        private int enableWait(ConditionNode node) {
            if (AbstractQueuedSynchronizer.this.isHeldExclusively()) {
                node.waiter = Thread.currentThread();
                node.setStatusRelaxed(3);
                ConditionNode last = this.lastWaiter;
                if (last == null) {
                    this.firstWaiter = node;
                } else {
                    last.nextWaiter = node;
                }
                this.lastWaiter = node;
                int savedState = AbstractQueuedSynchronizer.this.getState();
                if (AbstractQueuedSynchronizer.this.release(savedState)) {
                    return savedState;
                }
            }
            node.status = Integer.MIN_VALUE;
            throw new IllegalMonitorStateException();
        }

        private boolean canReacquire(ConditionNode node) {
            Node p;
            return node != null && (p = node.prev) != null && (p.next == node || AbstractQueuedSynchronizer.this.isEnqueued(node));
        }

        private void unlinkCancelledWaiters(ConditionNode node) {
            if (node == null || node.nextWaiter != null || node == this.lastWaiter) {
                ConditionNode w = this.firstWaiter;
                ConditionNode trail = null;
                while (w != null) {
                    ConditionNode next = w.nextWaiter;
                    if ((w.status & 2) == 0) {
                        w.nextWaiter = null;
                        if (trail == null) {
                            this.firstWaiter = next;
                        } else {
                            trail.nextWaiter = next;
                        }
                        if (next == null) {
                            this.lastWaiter = trail;
                        }
                    } else {
                        trail = w;
                    }
                    w = next;
                }
            }
        }

        private ConditionNode newConditionNode() {
            int savedState;
            if (AbstractQueuedSynchronizer.this.tryInitializeHead() != null) {
                try {
                    return new ConditionNode();
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    // empty catch block
                }
            }
            if (!AbstractQueuedSynchronizer.this.isHeldExclusively() || !AbstractQueuedSynchronizer.this.release(savedState = AbstractQueuedSynchronizer.this.getState())) {
                throw new IllegalMonitorStateException();
            }
            U.park(false, 10000000L);
            AbstractQueuedSynchronizer.this.acquireOnOOME(false, savedState);
            return null;
        }

        @Override
        public final void awaitUninterruptibly() {
            ConditionNode node = this.newConditionNode();
            if (node == null) {
                return;
            }
            int savedState = this.enableWait(node);
            LockSupport.setCurrentBlocker(this);
            boolean interrupted = false;
            boolean rejected = false;
            while (!this.canReacquire(node)) {
                if (Thread.interrupted()) {
                    interrupted = true;
                    continue;
                }
                if ((node.status & 2) != 0) {
                    try {
                        if (rejected) {
                            node.block();
                            continue;
                        }
                        ForkJoinPool.managedBlock(node);
                    }
                    catch (RejectedExecutionException ex) {
                        rejected = true;
                    }
                    catch (InterruptedException ie) {
                        interrupted = true;
                    }
                    continue;
                }
                Thread.onSpinWait();
            }
            LockSupport.setCurrentBlocker(null);
            node.clearStatus();
            AbstractQueuedSynchronizer.this.acquire(node, savedState, false, false, false, 0L);
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }

        @Override
        public final void await() throws InterruptedException {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            ConditionNode node = this.newConditionNode();
            if (node == null) {
                return;
            }
            int savedState = this.enableWait(node);
            LockSupport.setCurrentBlocker(this);
            boolean interrupted = false;
            boolean cancelled = false;
            boolean rejected = false;
            while (!this.canReacquire(node)) {
                if (interrupted |= Thread.interrupted()) {
                    cancelled = (node.getAndUnsetStatus(2) & 2) != 0;
                    if (!cancelled) continue;
                    break;
                }
                if ((node.status & 2) != 0) {
                    try {
                        if (rejected) {
                            node.block();
                            continue;
                        }
                        ForkJoinPool.managedBlock(node);
                    }
                    catch (RejectedExecutionException ex) {
                        rejected = true;
                    }
                    catch (InterruptedException ie) {
                        interrupted = true;
                    }
                    continue;
                }
                Thread.onSpinWait();
            }
            LockSupport.setCurrentBlocker(null);
            node.clearStatus();
            AbstractQueuedSynchronizer.this.acquire(node, savedState, false, false, false, 0L);
            if (interrupted) {
                if (cancelled) {
                    this.unlinkCancelledWaiters(node);
                    throw new InterruptedException();
                }
                Thread.currentThread().interrupt();
            }
        }

        @Override
        public final long awaitNanos(long nanosTimeout) throws InterruptedException {
            long remaining;
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            ConditionNode node = this.newConditionNode();
            if (node == null) {
                return nanosTimeout - 10000000L;
            }
            int savedState = this.enableWait(node);
            long nanos = nanosTimeout < 0L ? 0L : nanosTimeout;
            long deadline = System.nanoTime() + nanos;
            boolean cancelled = false;
            boolean interrupted = false;
            while (!this.canReacquire(node)) {
                if ((interrupted |= Thread.interrupted()) || (nanos = deadline - System.nanoTime()) <= 0L) {
                    cancelled = (node.getAndUnsetStatus(2) & 2) != 0;
                    if (!cancelled) continue;
                    break;
                }
                LockSupport.parkNanos(this, nanos);
            }
            node.clearStatus();
            AbstractQueuedSynchronizer.this.acquire(node, savedState, false, false, false, 0L);
            if (cancelled) {
                this.unlinkCancelledWaiters(node);
                if (interrupted) {
                    throw new InterruptedException();
                }
            } else if (interrupted) {
                Thread.currentThread().interrupt();
            }
            return (remaining = deadline - System.nanoTime()) <= nanosTimeout ? remaining : Long.MIN_VALUE;
        }

        @Override
        public final boolean awaitUntil(Date deadline) throws InterruptedException {
            long abstime = deadline.getTime();
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            ConditionNode node = this.newConditionNode();
            if (node == null) {
                return false;
            }
            int savedState = this.enableWait(node);
            boolean cancelled = false;
            boolean interrupted = false;
            while (!this.canReacquire(node)) {
                if ((interrupted |= Thread.interrupted()) || System.currentTimeMillis() >= abstime) {
                    cancelled = (node.getAndUnsetStatus(2) & 2) != 0;
                    if (!cancelled) continue;
                    break;
                }
                LockSupport.parkUntil(this, abstime);
            }
            node.clearStatus();
            AbstractQueuedSynchronizer.this.acquire(node, savedState, false, false, false, 0L);
            if (cancelled) {
                this.unlinkCancelledWaiters(node);
                if (interrupted) {
                    throw new InterruptedException();
                }
            } else if (interrupted) {
                Thread.currentThread().interrupt();
            }
            return !cancelled;
        }

        @Override
        public final boolean await(long time, TimeUnit unit) throws InterruptedException {
            long nanosTimeout = unit.toNanos(time);
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            ConditionNode node = this.newConditionNode();
            if (node == null) {
                return false;
            }
            int savedState = this.enableWait(node);
            long nanos = nanosTimeout < 0L ? 0L : nanosTimeout;
            long deadline = System.nanoTime() + nanos;
            boolean cancelled = false;
            boolean interrupted = false;
            while (!this.canReacquire(node)) {
                if ((interrupted |= Thread.interrupted()) || (nanos = deadline - System.nanoTime()) <= 0L) {
                    cancelled = (node.getAndUnsetStatus(2) & 2) != 0;
                    if (!cancelled) continue;
                    break;
                }
                LockSupport.parkNanos(this, nanos);
            }
            node.clearStatus();
            AbstractQueuedSynchronizer.this.acquire(node, savedState, false, false, false, 0L);
            if (cancelled) {
                this.unlinkCancelledWaiters(node);
                if (interrupted) {
                    throw new InterruptedException();
                }
            } else if (interrupted) {
                Thread.currentThread().interrupt();
            }
            return !cancelled;
        }

        final boolean isOwnedBy(AbstractQueuedSynchronizer sync) {
            return sync == AbstractQueuedSynchronizer.this;
        }

        protected final boolean hasWaiters() {
            if (!AbstractQueuedSynchronizer.this.isHeldExclusively()) {
                throw new IllegalMonitorStateException();
            }
            ConditionNode w = this.firstWaiter;
            while (w != null) {
                if ((w.status & 2) != 0) {
                    return true;
                }
                w = w.nextWaiter;
            }
            return false;
        }

        protected final int getWaitQueueLength() {
            if (!AbstractQueuedSynchronizer.this.isHeldExclusively()) {
                throw new IllegalMonitorStateException();
            }
            int n = 0;
            ConditionNode w = this.firstWaiter;
            while (w != null) {
                if ((w.status & 2) != 0) {
                    ++n;
                }
                w = w.nextWaiter;
            }
            return n;
        }

        protected final Collection<Thread> getWaitingThreads() {
            if (!AbstractQueuedSynchronizer.this.isHeldExclusively()) {
                throw new IllegalMonitorStateException();
            }
            ArrayList<Thread> list = new ArrayList<Thread>();
            ConditionNode w = this.firstWaiter;
            while (w != null) {
                Thread t;
                if ((w.status & 2) != 0 && (t = w.waiter) != null) {
                    list.add(t);
                }
                w = w.nextWaiter;
            }
            return list;
        }
    }

    static final class Node {
        static final int CANCELLED = 1;
        static final int SIGNAL = -1;
        static final int CONDITION = -2;
        static final Node SHARED = new Node();
        static final Node EXCLUSIVE = null;
        volatile int waitStatus;
        volatile Node prev;
        volatile Node next;
        volatile Thread thread;
        Node nextWaiter;

        final boolean isShared() {
            return this.nextWaiter == SHARED;
        }

        final Node predecessor() throws NullPointerException {
            Node node = this.prev;
            if (node == null) {
                throw new NullPointerException();
            }
            return node;
        }

        Node() {
        }

        Node(Thread thread, Node node) {
            this.nextWaiter = node;
            this.thread = thread;
        }

        Node(Thread thread, int n) {
            this.waitStatus = n;
            this.thread = thread;
        }
    }
}

