/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Spliterator;
import java.util.WeakHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeakHashMap<K, V>
extends AbstractMap<K, V>
implements Map<K, V> {
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private Entry[] table;
    private int size;
    private int threshold;
    private final float loadFactor;
    private final ReferenceQueue<K> queue = new ReferenceQueue();
    private volatile int modCount;
    private static final Object NULL_KEY = new Object();
    private transient Set<Map.Entry<K, V>> entrySet = null;

    public WeakHashMap(int n, float f) {
        int n2;
        if (n < 0) {
            throw new IllegalArgumentException("Illegal Initial Capacity: " + n);
        }
        if (n > 0x40000000) {
            n = 0x40000000;
        }
        if (f <= 0.0f || Float.isNaN(f)) {
            throw new IllegalArgumentException("Illegal Load factor: " + f);
        }
        for (n2 = 1; n2 < n; n2 <<= 1) {
        }
        this.table = new Entry[n2];
        this.loadFactor = f;
        this.threshold = (int)((float)n2 * f);
    }

    public WeakHashMap(int n) {
        this(n, 0.75f);
    }

    public WeakHashMap() {
        this.loadFactor = 0.75f;
        this.threshold = 16;
        this.table = new Entry[16];
    }

    public WeakHashMap(Map<? extends K, ? extends V> map) {
        this(Math.max((int)((float)map.size() / 0.75f) + 1, 16), 0.75f);
        this.putAll(map);
    }

    private static Object maskNull(Object object) {
        return object == null ? NULL_KEY : object;
    }

    private static <K> K unmaskNull(Object object) {
        return (K)(object == NULL_KEY ? null : object);
    }

    static boolean eq(Object object, Object object2) {
        return object == object2 || object.equals(object2);
    }

    static int indexFor(int n, int n2) {
        return n & n2 - 1;
    }

    private void expungeStaleEntries() {
        Entry entry;
        block0: while ((entry = (Entry)this.queue.poll()) != null) {
            Entry entry2;
            int n = entry.hash;
            int n2 = WeakHashMap.indexFor(n, this.table.length);
            Entry entry3 = entry2 = this.table[n2];
            while (entry3 != null) {
                Entry entry4 = entry3.next;
                if (entry3 == entry) {
                    if (entry2 == entry) {
                        this.table[n2] = entry4;
                    } else {
                        entry2.next = entry4;
                    }
                    entry.next = null;
                    entry.value = null;
                    --this.size;
                    continue block0;
                }
                entry2 = entry3;
                entry3 = entry4;
            }
        }
    }

    private Entry[] getTable() {
        this.expungeStaleEntries();
        return this.table;
    }

    @Override
    public int size() {
        if (this.size == 0) {
            return 0;
        }
        this.expungeStaleEntries();
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public V get(Object object) {
        Object object2 = WeakHashMap.maskNull(object);
        int n = HashMap.hash(object2.hashCode());
        Entry[] entryArray = this.getTable();
        int n2 = WeakHashMap.indexFor(n, entryArray.length);
        Entry entry = entryArray[n2];
        while (entry != null) {
            if (entry.hash == n && WeakHashMap.eq(object2, entry.get())) {
                return (V)entry.value;
            }
            entry = entry.next;
        }
        return null;
    }

    @Override
    public boolean containsKey(Object object) {
        return this.getEntry(object) != null;
    }

    Entry<K, V> getEntry(Object object) {
        Object object2 = WeakHashMap.maskNull(object);
        int n = HashMap.hash(object2.hashCode());
        Entry[] entryArray = this.getTable();
        int n2 = WeakHashMap.indexFor(n, entryArray.length);
        Entry entry = entryArray[n2];
        while (!(entry == null || entry.hash == n && WeakHashMap.eq(object2, entry.get()))) {
            entry = entry.next;
        }
        return entry;
    }

    @Override
    public V put(K k, V v) {
        Object object = WeakHashMap.maskNull(k);
        int n = HashMap.hash(object.hashCode());
        Entry[] entryArray = this.getTable();
        int n2 = WeakHashMap.indexFor(n, entryArray.length);
        Entry entry = entryArray[n2];
        while (entry != null) {
            if (n == entry.hash && WeakHashMap.eq(object, entry.get())) {
                Object object2 = entry.value;
                if (v != object2) {
                    entry.value = v;
                }
                return (V)object2;
            }
            entry = entry.next;
        }
        ++this.modCount;
        entry = entryArray[n2];
        entryArray[n2] = new Entry<Object, V>(object, v, this.queue, n, entry);
        if (++this.size >= this.threshold) {
            this.resize(entryArray.length * 2);
        }
        return null;
    }

    void resize(int n) {
        Entry[] entryArray = this.getTable();
        int n2 = entryArray.length;
        if (n2 == 0x40000000) {
            this.threshold = Integer.MAX_VALUE;
            return;
        }
        Entry[] entryArray2 = new Entry[n];
        this.transfer(entryArray, entryArray2);
        this.table = entryArray2;
        if (this.size >= this.threshold / 2) {
            this.threshold = (int)((float)n * this.loadFactor);
        } else {
            this.expungeStaleEntries();
            this.transfer(entryArray2, entryArray);
            this.table = entryArray;
        }
    }

    private void transfer(Entry[] entryArray, Entry[] entryArray2) {
        for (int i = 0; i < entryArray.length; ++i) {
            Entry entry = entryArray[i];
            entryArray[i] = null;
            while (entry != null) {
                Entry entry2 = entry.next;
                Object t = entry.get();
                if (t == null) {
                    entry.next = null;
                    entry.value = null;
                    --this.size;
                } else {
                    int n = WeakHashMap.indexFor(entry.hash, entryArray2.length);
                    entry.next = entryArray2[n];
                    entryArray2[n] = entry;
                }
                entry = entry2;
            }
        }
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        int n = map.size();
        if (n == 0) {
            return;
        }
        if (n > this.threshold) {
            int n2;
            int n3 = (int)((float)n / this.loadFactor + 1.0f);
            if (n3 > 0x40000000) {
                n3 = 0x40000000;
            }
            for (n2 = this.table.length; n2 < n3; n2 <<= 1) {
            }
            if (n2 > this.table.length) {
                this.resize(n2);
            }
        }
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(Object object) {
        Entry entry;
        Object object2 = WeakHashMap.maskNull(object);
        int n = HashMap.hash(object2.hashCode());
        Entry[] entryArray = this.getTable();
        int n2 = WeakHashMap.indexFor(n, entryArray.length);
        Entry entry2 = entry = entryArray[n2];
        while (entry2 != null) {
            Entry entry3 = entry2.next;
            if (n == entry2.hash && WeakHashMap.eq(object2, entry2.get())) {
                ++this.modCount;
                --this.size;
                if (entry == entry2) {
                    entryArray[n2] = entry3;
                } else {
                    entry.next = entry3;
                }
                return (V)entry2.value;
            }
            entry = entry2;
            entry2 = entry3;
        }
        return null;
    }

    Entry<K, V> removeMapping(Object object) {
        Entry entry;
        if (!(object instanceof Map.Entry)) {
            return null;
        }
        Entry[] entryArray = this.getTable();
        Map.Entry entry2 = (Map.Entry)object;
        Object object2 = WeakHashMap.maskNull(entry2.getKey());
        int n = HashMap.hash(object2.hashCode());
        int n2 = WeakHashMap.indexFor(n, entryArray.length);
        Entry entry3 = entry = entryArray[n2];
        while (entry3 != null) {
            Entry entry4 = entry3.next;
            if (n == entry3.hash && entry3.equals(entry2)) {
                ++this.modCount;
                --this.size;
                if (entry == entry3) {
                    entryArray[n2] = entry4;
                } else {
                    entry.next = entry4;
                }
                return entry3;
            }
            entry = entry3;
            entry3 = entry4;
        }
        return null;
    }

    @Override
    public void clear() {
        while (this.queue.poll() != null) {
        }
        ++this.modCount;
        Entry[] entryArray = this.table;
        for (int i = 0; i < entryArray.length; ++i) {
            entryArray[i] = null;
        }
        this.size = 0;
        while (this.queue.poll() != null) {
        }
    }

    @Override
    public boolean containsValue(Object object) {
        if (object == null) {
            return this.containsNullValue();
        }
        Entry[] entryArray = this.getTable();
        int n = entryArray.length;
        while (n-- > 0) {
            Entry entry = entryArray[n];
            while (entry != null) {
                if (object.equals(entry.value)) {
                    return true;
                }
                entry = entry.next;
            }
        }
        return false;
    }

    private boolean containsNullValue() {
        Entry[] entryArray = this.getTable();
        int n = entryArray.length;
        while (n-- > 0) {
            Entry entry = entryArray[n];
            while (entry != null) {
                if (entry.value == null) {
                    return true;
                }
                entry = entry.next;
            }
        }
        return false;
    }

    @Override
    public Set<K> keySet() {
        Set set = this.keySet;
        return set != null ? set : (this.keySet = new KeySet());
    }

    @Override
    public Collection<V> values() {
        Collection collection = this.values;
        return collection != null ? collection : (this.values = new Values(this, null));
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySet entrySet = this.entrySet;
        return entrySet != null ? entrySet : (this.entrySet = new EntrySet(this, null));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Entry<K, V>
    extends WeakReference<K>
    implements Map.Entry<K, V> {
        private V value;
        private final int hash;
        private Entry<K, V> next;

        Entry(K k, V v, ReferenceQueue<K> referenceQueue, int n, Entry<K, V> entry) {
            super(k, referenceQueue);
            this.value = v;
            this.hash = n;
            this.next = entry;
        }

        @Override
        public K getKey() {
            return (K)WeakHashMap.unmaskNull(this.get());
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V v) {
            V v2 = this.value;
            this.value = v;
            return v2;
        }

        @Override
        public boolean equals(Object object) {
            Object v;
            V v2;
            Object k;
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            K k2 = this.getKey();
            return (k2 == (k = entry.getKey()) || k2 != null && k2.equals(k)) && ((v2 = this.getValue()) == (v = entry.getValue()) || v2 != null && v2.equals(v));
        }

        @Override
        public int hashCode() {
            K k = this.getKey();
            V v = this.getValue();
            return (k == null ? 0 : k.hashCode()) ^ (v == null ? 0 : v.hashCode());
        }

        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }
    }

    private class EntryIterator
    extends HashIterator<Map.Entry<K, V>> {
        private EntryIterator(WeakHashMap weakHashMap) {
        }

        @Override
        public Map.Entry<K, V> next() {
            return this.nextEntry();
        }
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator(WeakHashMap.this);
        }

        @Override
        public boolean contains(Object o) {
            Map.Entry e;
            return o instanceof Map.Entry && WeakHashMap.this.getEntry((e = (Map.Entry)o).getKey()) != null && WeakHashMap.this.getEntry(e.getKey()).equals(e);
        }

        @Override
        public boolean remove(Object o) {
            return WeakHashMap.this.removeMapping(o);
        }

        @Override
        public int size() {
            return WeakHashMap.this.size();
        }

        @Override
        public void clear() {
            WeakHashMap.this.clear();
        }

        private List<Map.Entry<K, V>> deepCopy() {
            ArrayList list = new ArrayList(this.size());
            for (Map.Entry e : this) {
                list.add(new AbstractMap.SimpleEntry(e));
            }
            return list;
        }

        @Override
        public Object[] toArray() {
            return this.deepCopy().toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.deepCopy().toArray(a);
        }

        public Spliterator<Map.Entry<K, V>> spliterator() {
            return new EntrySpliterator(WeakHashMap.this, 0, -1, 0, 0);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class HashIterator<T>
    implements Iterator<T> {
        int index;
        Entry<K, V> entry = null;
        Entry<K, V> lastReturned = null;
        int expectedModCount = WeakHashMap.access$400(WeakHashMap.this);
        Object nextKey = null;
        Object currentKey = null;

        HashIterator() {
            this.index = WeakHashMap.this.size() != 0 ? WeakHashMap.this.table.length : 0;
        }

        @Override
        public boolean hasNext() {
            Entry[] entryArray = WeakHashMap.this.table;
            while (this.nextKey == null) {
                Entry entry = this.entry;
                int n = this.index;
                while (entry == null && n > 0) {
                    entry = entryArray[--n];
                }
                this.entry = entry;
                this.index = n;
                if (entry == null) {
                    this.currentKey = null;
                    return false;
                }
                this.nextKey = entry.get();
                if (this.nextKey != null) continue;
                this.entry = this.entry.next;
            }
            return true;
        }

        protected Entry<K, V> nextEntry() {
            if (WeakHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.nextKey == null && !this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.entry;
            this.entry = this.entry.next;
            this.currentKey = this.nextKey;
            this.nextKey = null;
            return this.lastReturned;
        }

        @Override
        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            if (WeakHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            WeakHashMap.this.remove(this.currentKey);
            this.expectedModCount = WeakHashMap.this.modCount;
            this.lastReturned = null;
            this.currentKey = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeyIterator
    extends HashIterator<K> {
        private KeyIterator() {
        }

        @Override
        public K next() {
            return this.nextEntry().getKey();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeySet
    extends AbstractSet<K> {
        private KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return new KeyIterator();
        }

        @Override
        public int size() {
            return WeakHashMap.this.size();
        }

        @Override
        public boolean contains(Object object) {
            return WeakHashMap.this.containsKey(object);
        }

        @Override
        public boolean remove(Object object) {
            if (WeakHashMap.this.containsKey(object)) {
                WeakHashMap.this.remove(object);
                return true;
            }
            return false;
        }

        @Override
        public void clear() {
            WeakHashMap.this.clear();
        }
    }

    private class ValueIterator
    extends HashIterator<V> {
        private ValueIterator(WeakHashMap weakHashMap) {
        }

        @Override
        public V next() {
            return this.nextEntry().value;
        }
    }

    private class Values
    extends AbstractCollection<V> {
        private Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator(WeakHashMap.this);
        }

        @Override
        public int size() {
            return WeakHashMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return WeakHashMap.this.containsValue(o);
        }

        @Override
        public void clear() {
            WeakHashMap.this.clear();
        }

        public Spliterator<V> spliterator() {
            return new ValueSpliterator(WeakHashMap.this, 0, -1, 0, 0);
        }
    }
}

