/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.PropertyPermission;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import sun.security.action.GetPropertyAction;
import sun.util.TimeZoneNameUtility;
import sun.util.calendar.ZoneInfo;
import sun.util.calendar.ZoneInfoFile;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class TimeZone
implements Serializable,
Cloneable {
    public static final int SHORT = 0;
    public static final int LONG = 1;
    private static final int ONE_MINUTE = 60000;
    private static final int ONE_HOUR = 3600000;
    private static final int ONE_DAY = 86400000;
    private static Hashtable cachedLocaleData = new Hashtable(3);
    static final long serialVersionUID = 3581463369166924961L;
    static final TimeZone NO_TIMEZONE = null;
    private String ID;
    private static volatile TimeZone defaultTimeZone;
    private static final InheritableThreadLocal<TimeZone> defaultZoneTL;
    static final String GMT_ID = "GMT";
    private static final int GMT_ID_LENGTH = 3;

    public abstract int getOffset(int var1, int var2, int var3, int var4, int var5, int var6);

    public int getOffset(long l) {
        if (this.inDaylightTime(new Date(l))) {
            return this.getRawOffset() + this.getDSTSavings();
        }
        return this.getRawOffset();
    }

    int getOffsets(long l, int[] nArray) {
        int n = this.getRawOffset();
        int n2 = 0;
        if (this.inDaylightTime(new Date(l))) {
            n2 = this.getDSTSavings();
        }
        if (nArray != null) {
            nArray[0] = n;
            nArray[1] = n2;
        }
        return n + n2;
    }

    public abstract void setRawOffset(int var1);

    public abstract int getRawOffset();

    public String getID() {
        return this.ID;
    }

    public void setID(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.ID = string;
    }

    public final String getDisplayName() {
        return this.getDisplayName(false, 1, Locale.getDefault());
    }

    public final String getDisplayName(Locale locale) {
        return this.getDisplayName(false, 1, locale);
    }

    public final String getDisplayName(boolean bl, int n) {
        return this.getDisplayName(bl, n, Locale.getDefault());
    }

    public String getDisplayName(boolean bl, int n, Locale locale) {
        int n2;
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("Illegal style: " + n);
        }
        String string = this.getID();
        String[] stringArray = TimeZone.getDisplayNames(string, locale);
        if (stringArray == null) {
            int n3;
            if (string.startsWith("GMT") && ((n3 = (int)string.charAt(3)) == 43 || n3 == 45)) {
                return string;
            }
            n3 = this.getRawOffset();
            if (bl) {
                n3 += this.getDSTSavings();
            }
            return ZoneInfoFile.toCustomID(n3);
        }
        int n4 = n2 = bl ? 3 : 1;
        if (n == 0) {
            ++n2;
        }
        return stringArray[n2];
    }

    private static final String[] getDisplayNames(String string, Locale locale) {
        String[] stringArray;
        Map map = DisplayNames.access$000();
        SoftReference softReference = (SoftReference)map.get(string);
        if (softReference != null && (stringArray = (String[])softReference.get()) != null) {
            String[] stringArray2 = (String[])stringArray.get(locale);
            if (stringArray2 != null) {
                return stringArray2;
            }
            stringArray2 = TimeZoneNameUtility.retrieveDisplayNames((String)string, (Locale)locale);
            if (stringArray2 != null) {
                stringArray.put(locale, stringArray2);
            }
            return stringArray2;
        }
        stringArray = TimeZoneNameUtility.retrieveDisplayNames((String)string, (Locale)locale);
        if (stringArray != null) {
            ConcurrentHashMap<Locale, String[]> concurrentHashMap = new ConcurrentHashMap<Locale, String[]>();
            concurrentHashMap.put(locale, stringArray);
            softReference = new SoftReference(concurrentHashMap);
            map.put(string, softReference);
        }
        return stringArray;
    }

    public int getDSTSavings() {
        if (this.useDaylightTime()) {
            return 3600000;
        }
        return 0;
    }

    public abstract boolean useDaylightTime();

    public abstract boolean inDaylightTime(Date var1);

    public static synchronized TimeZone getTimeZone(String string) {
        return TimeZone.getTimeZone(string, true);
    }

    private static TimeZone getTimeZone(String string, boolean bl) {
        TimeZone timeZone = ZoneInfo.getTimeZone(string);
        if (timeZone == null && (timeZone = TimeZone.parseCustomTimeZone(string)) == null && bl) {
            timeZone = new ZoneInfo("GMT", 0);
        }
        return timeZone;
    }

    public static synchronized String[] getAvailableIDs(int n) {
        return ZoneInfo.getAvailableIDs(n);
    }

    public static synchronized String[] getAvailableIDs() {
        return ZoneInfo.getAvailableIDs();
    }

    private static native String getSystemTimeZoneID(String var0, String var1);

    private static native String getSystemGMTOffsetID();

    public static TimeZone getDefault() {
        return (TimeZone)TimeZone.getDefaultRef().clone();
    }

    static TimeZone getDefaultRef() {
        TimeZone timeZone = (TimeZone)defaultZoneTL.get();
        if (timeZone == null && (timeZone = defaultTimeZone) == null) {
            timeZone = TimeZone.setDefaultZone();
            assert (timeZone != null);
        }
        return timeZone;
    }

    private static synchronized TimeZone setDefaultZone() {
        String string;
        TimeZone timeZone = null;
        String string2 = AccessController.doPrivileged(new GetPropertyAction("user.timezone"));
        if (string2 == null || string2.equals("")) {
            string = AccessController.doPrivileged(new GetPropertyAction("user.country"));
            String string3 = AccessController.doPrivileged(new GetPropertyAction("java.home"));
            try {
                string2 = TimeZone.getSystemTimeZoneID(string3, string);
                if (string2 == null) {
                    string2 = "GMT";
                }
            }
            catch (NullPointerException nullPointerException) {
                string2 = "GMT";
            }
        }
        if ((timeZone = TimeZone.getTimeZone(string2, false)) == null) {
            string = TimeZone.getSystemGMTOffsetID();
            if (string != null) {
                string2 = string;
            }
            timeZone = TimeZone.getTimeZone(string2, true);
        }
        assert (timeZone != null);
        string = string2;
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                System.setProperty("user.timezone", string);
                return null;
            }
        });
        defaultTimeZone = timeZone;
        return timeZone;
    }

    private static boolean hasPermission() {
        boolean bl = true;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            try {
                securityManager.checkPermission(new PropertyPermission("user.timezone", "write"));
            }
            catch (SecurityException securityException) {
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDefault(TimeZone timeZone) {
        if (TimeZone.hasPermission()) {
            Class<TimeZone> clazz = TimeZone.class;
            synchronized (TimeZone.class) {
                defaultTimeZone = timeZone;
                defaultZoneTL.set(null);
                // ** MonitorExit[var1_1] (shouldn't be in output)
            }
        } else {
            defaultZoneTL.set(timeZone);
        }
    }

    public boolean hasSameRules(TimeZone timeZone) {
        return timeZone != null && this.getRawOffset() == timeZone.getRawOffset() && this.useDaylightTime() == timeZone.useDaylightTime();
    }

    public Object clone() {
        try {
            TimeZone timeZone = (TimeZone)super.clone();
            timeZone.ID = this.ID;
            return timeZone;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    private static final TimeZone parseCustomTimeZone(String string) {
        char c;
        int n = string.length();
        if (n < 5 || string.indexOf("GMT") != 0) {
            return null;
        }
        ZoneInfo zoneInfo = ZoneInfoFile.getZoneInfo(string);
        if (zoneInfo != null) {
            return zoneInfo;
        }
        int n2 = 3;
        boolean bl = false;
        if ((c = string.charAt(n2++)) == '-') {
            bl = true;
        } else if (c != '+') {
            return null;
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        while (n2 < n) {
            if ((c = string.charAt(n2++)) == ':') {
                if (n5 > 0) {
                    return null;
                }
                if (n6 > 2) {
                    return null;
                }
                n3 = n4;
                ++n5;
                n4 = 0;
                n6 = 0;
                continue;
            }
            if (c < '0' || c > '9') {
                return null;
            }
            n4 = n4 * 10 + (c - 48);
            ++n6;
        }
        if (n2 != n) {
            return null;
        }
        if (n5 == 0) {
            if (n6 <= 2) {
                n3 = n4;
                n4 = 0;
            } else {
                n3 = n4 / 100;
                n4 %= 100;
            }
        } else if (n6 != 2) {
            return null;
        }
        if (n3 > 23 || n4 > 59) {
            return null;
        }
        int n7 = (n3 * 60 + n4) * 60 * 1000;
        if (n7 == 0) {
            zoneInfo = ZoneInfoFile.getZoneInfo("GMT");
            if (bl) {
                zoneInfo.setID("GMT-00:00");
            } else {
                zoneInfo.setID("GMT+00:00");
            }
        } else {
            zoneInfo = ZoneInfoFile.getCustomTimeZone(string, bl ? -n7 : n7);
        }
        return zoneInfo;
    }

    static {
        defaultZoneTL = new InheritableThreadLocal();
    }
}

