/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.spi.CurrencyNameProvider;
import sun.util.LocaleServiceProviderPool;
import sun.util.locale.provider.LocaleServiceProviderPool;
import sun.util.resources.LocaleData;
import sun.util.resources.OpenListResourceBundle;

public final class Currency
implements Serializable {
    private static final long serialVersionUID = -158308464356906721L;
    private final String currencyCode;
    private final transient int defaultFractionDigits;
    private static HashMap instances = new HashMap(7);
    static String mainTable;
    static long[] scCutOverTimes;
    static String[] scOldCurrencies;
    static String[] scNewCurrencies;
    static int[] scOldCurrenciesDFD;
    static int[] scNewCurrenciesDFD;
    static String otherCurrencies;
    static int[] otherCurrenciesDFD;
    private static final int A_TO_Z = 26;
    private static final int INVALID_COUNTRY_ENTRY = 127;
    private static final int COUNTRY_WITHOUT_CURRENCY_ENTRY = 128;
    private static final int SIMPLE_CASE_COUNTRY_MASK = 0;
    private static final int SIMPLE_CASE_COUNTRY_FINAL_CHAR_MASK = 31;
    private static final int SIMPLE_CASE_COUNTRY_DEFAULT_DIGITS_MASK = 96;
    private static final int SIMPLE_CASE_COUNTRY_DEFAULT_DIGITS_SHIFT = 5;
    private static final int SPECIAL_CASE_COUNTRY_MASK = 128;
    private static final int SPECIAL_CASE_COUNTRY_INDEX_MASK = 31;
    private static final int SPECIAL_CASE_COUNTRY_INDEX_DELTA = 1;
    private static final int COUNTRY_TYPE_MASK = 128;

    private Currency(String string, int n) {
        this.currencyCode = string;
        this.defaultFractionDigits = n;
    }

    public static Currency getInstance(String string) {
        return Currency.getInstance(string, Integer.MIN_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Currency getInstance(String string, int n) {
        HashMap hashMap = instances;
        synchronized (hashMap) {
            Currency currency = (Currency)instances.get(string);
            if (currency != null) {
                return currency;
            }
            if (n == Integer.MIN_VALUE) {
                char c;
                if (string.length() != 3) {
                    throw new IllegalArgumentException();
                }
                char c2 = string.charAt(0);
                int n2 = Currency.getMainTableEntry(c2, c = string.charAt(1));
                if ((n2 & 0x80) == 0 && n2 != 127 && string.charAt(2) - 65 == (n2 & 0x1F)) {
                    n = (n2 & 0x60) >> 5;
                } else {
                    if (string.charAt(2) == '-') {
                        throw new IllegalArgumentException();
                    }
                    int n3 = otherCurrencies.indexOf(string);
                    if (n3 == -1) {
                        throw new IllegalArgumentException();
                    }
                    n = otherCurrenciesDFD[n3 / 4];
                }
            }
            currency = new Currency(string, n);
            instances.put(string, currency);
            return currency;
        }
    }

    public static Currency getInstance(Locale locale) {
        char c;
        String string = locale.getCountry();
        if (string == null) {
            throw new NullPointerException();
        }
        if (string.length() != 2) {
            throw new IllegalArgumentException();
        }
        char c2 = string.charAt(0);
        int n = Currency.getMainTableEntry(c2, c = string.charAt(1));
        if ((n & 0x80) == 0 && n != 127) {
            char c3 = (char)((n & 0x1F) + 65);
            int n2 = (n & 0x60) >> 5;
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.append(c3);
            return Currency.getInstance(stringBuffer.toString(), n2);
        }
        if (n == 127) {
            throw new IllegalArgumentException();
        }
        if (n == 128) {
            return null;
        }
        int n3 = (n & 0x1F) - 1;
        if (scCutOverTimes[n3] == Long.MAX_VALUE || System.currentTimeMillis() < scCutOverTimes[n3]) {
            return Currency.getInstance(scOldCurrencies[n3], scOldCurrenciesDFD[n3]);
        }
        return Currency.getInstance(scNewCurrencies[n3], scNewCurrenciesDFD[n3]);
    }

    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public String getSymbol() {
        return this.getSymbol(Locale.getDefault());
    }

    public String getSymbol(Locale locale) {
        try {
            Object object;
            LocaleServiceProviderPool localeServiceProviderPool = LocaleServiceProviderPool.getPool(CurrencyNameProvider.class);
            if (localeServiceProviderPool.hasProviders() && (object = (String)localeServiceProviderPool.getLocalizedObject(CurrencyNameGetter.access$000(), locale, (OpenListResourceBundle)null, this.currencyCode, new Object[0])) != null) {
                return object;
            }
            object = LocaleData.getCurrencyNames(locale);
            return ((ResourceBundle)object).getString(this.currencyCode);
        }
        catch (MissingResourceException missingResourceException) {
            return this.currencyCode;
        }
    }

    public int getDefaultFractionDigits() {
        return this.defaultFractionDigits;
    }

    public String toString() {
        return this.currencyCode;
    }

    private Object readResolve() {
        return Currency.getInstance(this.currencyCode);
    }

    private static int getMainTableEntry(char c, char c2) {
        if (c < 'A' || c > 'Z' || c2 < 'A' || c2 > 'Z') {
            throw new IllegalArgumentException();
        }
        return mainTable.charAt((c - 65) * 26 + (c2 - 65));
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    Class<?> clazz = Class.forName("java.util.CurrencyData");
                    mainTable = (String)clazz.getDeclaredField("mainTable").get(clazz);
                    scCutOverTimes = (long[])clazz.getDeclaredField("scCutOverTimes").get(clazz);
                    scOldCurrencies = (String[])clazz.getDeclaredField("scOldCurrencies").get(clazz);
                    scNewCurrencies = (String[])clazz.getDeclaredField("scNewCurrencies").get(clazz);
                    scOldCurrenciesDFD = (int[])clazz.getDeclaredField("scOldCurrenciesDFD").get(clazz);
                    scNewCurrenciesDFD = (int[])clazz.getDeclaredField("scNewCurrenciesDFD").get(clazz);
                    otherCurrencies = (String)clazz.getDeclaredField("otherCurrencies").get(clazz);
                    otherCurrenciesDFD = (int[])clazz.getDeclaredField("otherCurrenciesDFD").get(clazz);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new InternalError();
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    throw new InternalError();
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new InternalError();
                }
                return null;
            }
        });
    }

    private static class CurrencyNameGetter
    implements LocaleServiceProviderPool.LocalizedObjectGetter<CurrencyNameProvider, String> {
        private static final CurrencyNameGetter INSTANCE = new CurrencyNameGetter();

        private CurrencyNameGetter() {
        }

        @Override
        public String getObject(CurrencyNameProvider currencyNameProvider, Locale locale, String key, Object ... params) {
            assert (params.length == 1);
            int type = (Integer)params[0];
            switch (type) {
                case 0: {
                    return currencyNameProvider.getSymbol(key, locale);
                }
                case 1: {
                    return currencyNameProvider.getDisplayName(key, locale);
                }
            }
            assert (false);
            return null;
        }
    }
}

