/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.Format;

public class FieldPosition {
    int field = 0;
    int endIndex = 0;
    int beginIndex = 0;
    private Format.Field attribute;

    public FieldPosition(int n) {
        this.field = n;
    }

    public FieldPosition(Format.Field field) {
        this(field, -1);
    }

    public FieldPosition(Format.Field field, int n) {
        this.attribute = field;
        this.field = n;
    }

    public Format.Field getFieldAttribute() {
        return this.attribute;
    }

    public int getField() {
        return this.field;
    }

    public int getBeginIndex() {
        return this.beginIndex;
    }

    public int getEndIndex() {
        return this.endIndex;
    }

    public void setBeginIndex(int n) {
        this.beginIndex = n;
    }

    public void setEndIndex(int n) {
        this.endIndex = n;
    }

    Format.FieldDelegate getFieldDelegate() {
        return new Delegate(this, null);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof FieldPosition)) {
            return false;
        }
        FieldPosition fieldPosition = (FieldPosition)object;
        if (this.attribute == null ? fieldPosition.attribute != null : !this.attribute.equals(fieldPosition.attribute)) {
            return false;
        }
        return this.beginIndex == fieldPosition.beginIndex && this.endIndex == fieldPosition.endIndex && this.field == fieldPosition.field;
    }

    public int hashCode() {
        return this.field << 24 | this.beginIndex << 16 | this.endIndex;
    }

    public String toString() {
        return this.getClass().getName() + "[field=" + this.field + ",attribute=" + this.attribute + ",beginIndex=" + this.beginIndex + ",endIndex=" + this.endIndex + ']';
    }

    private boolean matchesField(Format.Field field) {
        if (this.attribute != null) {
            return this.attribute.equals(field);
        }
        return false;
    }

    private boolean matchesField(Format.Field field, int n) {
        if (this.attribute != null) {
            return this.attribute.equals(field);
        }
        return n == this.field;
    }

    static /* synthetic */ boolean access$100(FieldPosition fieldPosition, Format.Field field) {
        return fieldPosition.matchesField(field);
    }

    static /* synthetic */ boolean access$200(FieldPosition fieldPosition, Format.Field field, int n) {
        return fieldPosition.matchesField(field, n);
    }

    private class Delegate
    implements Format.FieldDelegate {
        private boolean encounteredField;

        private Delegate() {
        }

        @Override
        public void formatted(Format.Field attr, Object value, int start, int end, StringBuffer buffer) {
            if (!this.encounteredField && FieldPosition.this.matchesField(attr)) {
                FieldPosition.this.setBeginIndex(start);
                FieldPosition.this.setEndIndex(end);
                this.encounteredField = start != end;
            }
        }

        @Override
        public void formatted(int fieldID, Format.Field attr, Object value, int start, int end, StringBuffer buffer) {
            if (!this.encounteredField && FieldPosition.this.matchesField(attr, fieldID)) {
                FieldPosition.this.setBeginIndex(start);
                FieldPosition.this.setEndIndex(end);
                this.encounteredField = start != end;
            }
        }
    }
}

