;;;begain suprgear.lsp 
;************************************************* 
;SPURGEAR.LSP - a lisp program by Tony Hotchkiss 
;------------------------------------------------- 
; This routine draws a spur gear using joined 
; polylines. It lets you use any pressure angle 
; to design the gear teeth. 
;************************************************* 
(defun err (s) 
(if (= s "Function cancelled") 
(princ "\nSPURGEAR - cancelled: ") 
(progn (princ "\nSPURGEAR - Error: ") (princ s) 
(terpri)) 
); if 
(resetting) 
(princ "SYSTEM VARIABLES have been reset\n") 
(princ) 
); err 

(defun setv (systvar newval) 
(setq x (read (strcat systvar "1"))) 
(set x (getvar systvar)) 
(setvar systvar newval) 
); setv 

(defun setting () 
(setq oerr *error*) 
(setq *error* err) 
(setv "CMDECHO" 0) 
(setv "BLIPMODE" 0) 
); end of setting 
(defun rsetv (systvar) 
(setq x (read (strcat systvar "1"))) 
(setvar systvar (eval x)) 
); restv 
(defun resetting () 
(rsetv "CMDECHO") 
(rsetv "BLIPMODE") 
(setq *error* oerr) 
); end of resetting 

(defun dxf (code ename) 
(cdr (assoc code (entget ename))) 
); dxf 

(defun spurgear (/ D N phi DO RO A B DR DB inv-plst p1 
trimcode invent p0 p curvent linent linent2 ent2 p2) 
(setq D (getreal "\nPitch diameter: ") 
N (getint "\nNumber of teeth: ") 
phi (getreal "\nPressure angle: ") 
phi (* (/ phi 180) pi) ; Pressure angle 
DO (* D (+ (/ 2.0 N) 1.0)); Outside diameter 
RO (/ DO 2.0) ; Outside radius 
A (/ D N) ; Addendum 
B (* 1.25 A) ; Dedendum 
DR (- D (* B 2.0)) ; Root diameter 
DB (* D (cos phi)) ; Base circle dia. 
inv-plst (involute DB N phi);involute points 
trimcode nil 
); setq 
(command "ZOOM" (list 0 (- B)) 
(list RO (/ RO 1.5)) 
); command 
(setq invent (draw-inv inv-plst)); Draw involute. 
(setq p0 (car inv-plst) 
trimcode (ext-trim p0 DR D);trim or extend 
); setq ; the involute. 
(if (and trimcode (= trimcode 0)) 
(progn ; Joins the involute to the extension. 
(setq p (list (/ DR 2.0) 0)) 
(command "PEDIT" p "Y" "J" invent "" "X") 
(setq curvent (entlast)) 
); progn 
(setq curvent (entlast)) 
); if 
(if (null trimcode) (setq curvent invent)) 
(setq linent (draw-top-line D DB N RO)); top line. 
(command "COPY" linent "" "0,0" "0,0") 
(setq linent2 (entlast)) 
(setq ent2 (mir-it curvent linent)); mirror curve 
(command "PEDIT" curvent "J" linent ent2 "" "X") 
(segment DR N linent2) ; Finish the job! 
(setq p1 (list (- RO) (- RO))) 
(setq p2 (list RO RO)) 
(command "ZOOM" p1 p2) 
(prompt "\nConverting to POLYLINE, please wait...") 
(command "PEDIT" (entlast) "J" "C" p1 p2 "" "X") 
(prompt "\nAll done!") 
); spurgear 

(defun involute (DB N phi / numer denom frac theta2max 
thetamax theta-inc theta plist RB xval yval p) 
(setq invfact 3) 
(setq numer (+ N 2.0) 
denom (* N (cos phi)) 
frac (/ numer denom) 
theta2max (- (* frac frac) 1) 
thetamax (sqrt theta2max) 
theta-inc (/ thetamax (float invfact)) 
theta 0 
plist nil 
RB (/ DB 2.0) 
); setq 
(repeat (1+ invfact) 
(setq xval (do-x RB theta) 
yval (do-y RB theta) 
p (list xval yval) 
plist (append plist (list p)) 
); setq 
(setq theta (+ theta theta-inc)) 
); repeat 
plist 
); involute 

(defun do-x (RB theta) 
(* RB (+ (cos theta) (* theta (sin theta)))) 
); do-x 

(defun do-y (RB theta) 
(* RB (- (sin theta) (* theta (cos theta)))) 
); do-y 

(defun draw-inv (inv-plst / dirpt plist p) 
(command "PLINE" (nth 0 inv-plst)) 
(setq dirpt (polar (nth 0 inv-plst) 0 1)) 
(command "A" "D" dirpt) 
(setq plist (cdr inv-plst)) 
(foreach p plist (command p)) 
(command "") 
(entlast) 
); draw-inv 

(defun ext-trim (p0 DR D / trimcode dist endr) 
(if (> (car p0) (/ DR 2.0)) ; Extends the involute 
(progn 
(command "LINE" (list (/ DR 2.0) 0) p0 "") 
(setq trimcode 0) 
); progn 
); if 
(if (< (car p0) (/ DR 2.0)) ; Trims the involute 
(progn 
(command "CIRCLE" "0,0" "D" DR); Root circle 
(setq dist (- (/ D 2.0) (car p0))) 
(command "ZOOM" p0 
(polar p0 0.6 dist)) 
(setq endr (entlast)) 
(command "TRIM" endr "" p0 "") 
(command "ZOOM" "P") 
(entdel endr) 
(setq trimcode 1) 
); progn 
); if 
trimcode 
); ext-trim 

(defun draw-top-line (D DB N RO / theta-p xp yp alpha 
beta tang angend inv-endpt lend) 
(setq theta-p (sqrt (- (* (/ D DB) (/ D DB)) 1.0)) 
xp (do-x (/ DB 2.0) theta-p); This section 
yp (do-y (/ DB 2.0) theta-p); sets up angles 
alpha (atan yp xp) ; for drawing a 
abeta (angle (list 0 0) (last inv-plst)) 
beta (- abeta alpha) ; line across the 
tang (/ pi N) ; top of a tooth 
angend (- (+ alpha tang) beta) 
inv-endpt (last inv-plst); This also creates 
lend (polar (list 0 0) angend RO); the tooth 
); setq ; thickness. 
(command "LINE" inv-endpt lend ""); Draws the line 
(redraw) 
(entlast) 
); draw-top-line 

(defun mir-it (cvent linent / pt) 
(setq pt (dxf 11 linent)) 
(command "MIRROR" cvent "" "MID" pt "0,0" "") 
(entlast) 
); mir-it 

(defun segment (DR N en / p1 p2 ang dist midp p0 pang 
pang2 p p3 ent3 entl1 entl2 en1 en2) 
(setq p1 (dxf 10 en) 
p2 (dxf 11 en) 
ang (angle p1 p2) 
dist (/ (distance p1 p2) 2.0) 
midp (polar p1 ang dist) 
p0 (list 0 0) 
pang (angle p0 midp) 
pang2 (/ pi N) 
p (polar p0 pang (/ DR 2.0)) 
p1 (polar p0 (- pang pang2) (/ DR 2.0)) 
p2 (polar p0 (+ pang pang2) (/ DR 2.0)) 
p3 (polar p0 (+ pang pang2 pang2) (/ DR 2.0)) 
ent3 (entlast); This is the tooth p-line 
); setq 
(command "ZOOM" "W" p3 p1) 
(command "CIRCLE" "0,0" "D" DR) ;Root circle 
(command "TRIM" ent3 "" p ""); Trim the root circle 
(command "ZOOM" "P") 
(command "LINE" p0 p1 "") 
(setq entl1 (entlast)) 
(command "LINE" p0 p2 "") 
(setq entl2 (entlast)) 
(command "TRIM" entl1 entl2 "" p3 "") 
(entdel entl1) 
(entdel entl2) 
(entdel en) 
(command "ZOOM" "W" p3 p1) 
(command "PEDIT" p1 "Y" "X") 
(setq en1 (entlast)) 
(command "PEDIT" p2 "Y" "X") 
(setq en2 (entlast)) 
(command "PEDIT" en1 "J" midp en2 "" "X") 
(command "ZOOM" "P") 
(command "ARRAY" p1 "" "P" "0,0" N "360" "Y") 
); segment 

(defun c:sg () 
(setting) 
(spurgear) 
(resetting) 
(princ) 
); c:sg 

(prompt "\n**SPURGEAR.LSP Loaded!") 
(prompt "\n Enter 'SG' to start") 
;;;end suprgear.lsp 
