
(defun eppos(/ 	inspt 		screw_set 	ent_count	i 		ent_nam 
		all_mxb_ent	screw_count	epin_count	apn_count	all_count	
		old_set		old_set_nstd	all_mxb_ent)
;------------------------------------------
;shut off command echo and set undo mark
;------------------------------------------
  (setvar "cmdecho" 0)
  (command "undo" "m")
;------------------------------------------
;save current system var
;------------------------------------------
  (setq os_old (getvar "osmode"))
  (setq la_old (getvar "clayer"))
;------------------------------------------
;set user system var
;------------------------------------------
  (if (not (tblsearch "layer" "mxb"))
    (command "_.layer" "_new" "mxb" "_color" "red" "mxb" "_ltype" "continuous" "mxb" "")
    (command "_.layer" "thaw" "mxb" "on" "mxb" "unlock" "mxb" "")
  )
  (setvar "clayer" "mxb")
  (ini_useri2)
;------------------------------------------
;delete old bill table
;------------------------------------------
  (if (not (tblsearch "appid" "mxb_standard"))
    (regapp "mxb_standard")
  )
  (setq old_set (ssget "X" '((0 . "INSERT") (-3 ("mxb_standard")))))
  (if old_set
    (command "erase" old_set "")
  )
;------------------------------------------
;get bill table insert point
;------------------------------------------
  (if (> (getvar "useri1") 0)
    (progn
      (setq inspt (getpoint "\nPlease get a insert point:"))
      (if (not inspt)
        (progn
          (setq bpt (wtou (list (getvar "userr1") (getvar "userr2"))))
          (if ent_sel_mxb
            (setq i (+ (getvar "useri1") 1))
            (setq i 0)
          )
          (setq inspt (polar bpt (* pi 0.5) (* 8 i)))
        )
      )
    )
    (while (not inspt)
      (setq inspt (getpoint "\nPlease get a insert point:"))
    )
  )
;------------------------------------------
;Initializing
;------------------------------------------
  (setvar "osmode" 0)
  (princ "\nAnalyzing entity... \nBegin to create SCREW bill table, please wait...")
  (if (not (tblsearch "appid" "mxb_standard"))
    (regapp "mxb_standard")
  )
  (setq all_mxb_ent nil
	screw_count 0
     	epin_count  0
        all_count   0
     	pin_count   0
     	sp_count    0
        apn_count   0
  )
  (setq inshdpt inspt)
  (setq inspt (polar inspt (* pi 0.5) 8.0))

;---------------------------------------------------------
;Find out ejector pin entities and create ejector pin bill
;---------------------------------------------------------
  (setq inspt (polar inshdpt (/ pi 2) (* 8 (+ 1 all_count))))
  (setq epin_set (ssget "X" '((0 . "INSERT") (-3 ("epin")))))
  (if epin_set
    (progn
      (setq ent_count (sslength epin_set))
      (setq i 0)
      (while (< i ent_count)
	(setq ent_nam (ssname epin_set i))
	(deal_epin)
	(setq i (+ i 1))
      )
      (setq all_count (+ all_count epin_count))
      (if (> epin_count 0)
        (princ (strcat "\nFound" " " (itoa epin_count) " " "kinds of ejector pin!"))
      )
    )
    (princ "\nNot found any ejector pin!")
  )

;---------------------------------------------------------
;Find out pin entities and create pin bill table
;---------------------------------------------------------
  (setq inspt (polar inshdpt (/ pi 2) (* 8 (+ 1 all_count))))
  (setq pin_set (ssget "X" '((0 . "INSERT") (-3 ("pin")))))
  (if pin_set
    (progn
      (setq ent_count (sslength pin_set))
      (setq i 0)
      (while (< i ent_count)
	(setq ent_nam (ssname pin_set i))
	(deal_pin)
	(setq i (+ i 1))
      )
      (setq all_count (+ all_count pin_count))
      (if (> pin_count 0)
        (princ (strcat "\nFound" " " (itoa pin_count) " " "kinds of pin!"))
      )
    )
    (princ "\nNot found any pin!")
  )

;----------------------------------------------
;Reset system variable
;----------------------------------------------
  (if (< 0 all_count)
    (progn
      (command "insert" "mxb_head" inshdpt "" "" "")
      (setq xd (list (list -3 (list "mxb_standard" (cons 1000 "mxb_head")))))
      (mxdata (entlast) xd)
    )
  )
  (ac_lxy_set)
  (prin1)
)
;********************************** End of function ***********************************;




;************************* Begin create ejector pin bill table ************************;
(defun deal_epin()
  (setq epin_data (cdr (cadr (cadr (assoc -3 (entget ent_nam '("epin")))))))
  (setq epin_data (strtolst epin_data))
  (progn
    (setq rep      (nth 0 epin_data)
	  mb       (nth 6 epin_data)
	  type_old (nth 2 epin_data)
	  len_old  (nth 3 epin_data)
	  zc       (nth 1 epin_data)
          if_h_v   (nth 4 epin_data)
          typ_old  (nth 5 epin_data)
          cot      (strcat "%%c" type_old "X" len_old)
    )
    (cond
      ((= "N" typ_old)
        (setq chin "ֱ")
	(setq desc "EJECTOR PIN")
      )
      ((= "W" typ_old)
	(setq chin "ж")
	(setq desc "STEP EJECTOR PIN")
      )
    )
  )
  (setq spec_var (strcat chin cot))
  (if (= "Z" zc)
    (progn
      (transtomxb "epin")
      (if (= 1 ins_lb)
        (if (> (atoi (substr rep 2)) epin_count)
          (setq epin_count (atoi (substr rep 2)))
        )
      )
    )
  )
)
;********************************** End of function ***********************************;




;***************************** Begin create pin bill table ****************************;
(defun deal_pin()
  (setq pin_data (cdr (cadr (cadr (assoc -3 (entget ent_nam '("pin")))))))
  (setq pin_data (strtolst pin_data))
  (progn
    (setq rep      (nth 0 pin_data)
	  mb       (nth 6 pin_data)
	  type_old (nth 2 pin_data)
	  len_old  (nth 3 pin_data)
	  zc       (nth 1 pin_data)
          if_h_v   (nth 4 pin_data)
          typ_old  (nth 5 pin_data)
          cot      (strcat "%%c" type_old "X" len_old)
    )
    (setq chin "")
    (setq desc "EJECTOR PIN")
  )
  (setq spec_var (strcat chin cot))
  (if (= "Z" zc)
    (progn
      (transtomxb "pin")
      (if (= 1 ins_lb)
        (if (> (atoi (substr rep 2)) pin_count)
          (setq pin_count (atoi (substr rep 2)))
        )
      )
    )
  )
)
;********************************** End of function ***********************************;




;********************************** Share function ************************************;
(defun mod_ent(ent_name mod_data / ent_data)
  (setq ent_data (entget ent_name))
  (setq ent_data (subst (cons 1 mod_data)
			(assoc 1 ent_data)
			ent_data)
  )
  (entmod ent_data)
  (entupd ent_name)
)
;********************************** End of function ***********************************;


;********************************* Create bill table **********************************;
(defun transtomxb(app_name /    entn 		ent_sel 	ent_chin 	ent_qty 	
				ent_rep		ent_obv 	ent_cot		ent_amt 	
				ent_desc 	spec)
  (setq ins_lb 1)
  (if all_mxb_ent
    (foreach entn all_mxb_ent 
      (progn
	(setq ent_sel  (handent entn))
 	(setq ent_rep  (entnext ent_sel))
	(setq ent_qty  (entnext ent_rep))
	(setq ent_chin (entnext ent_qty))
	(setq ent_desc (entnext ent_chin))
	(setq ent_mat  (entnext ent_desc))
	(setq ent_cot  (entnext ent_mat))
	(setq ent_obv  (entnext ent_cot))
	(setq spec (strcat (cdr (assoc 1 (entget ent_chin)))
			   (cdr (assoc 1 (entget ent_cot)))
		   )
	)
	(if (= rep (cdr (assoc 1 (entget ent_rep))))
	  (if (= spec_var spec)
	    (add_qty)
            (progn
              (command "undo" "b")
              (redraw ent_nam 3)
	      (*error* (strcat "\"" rep "\"" 
			       "кֲͬ"
			       "\n\n     \"" spec "\"\n     \"" spec_var "\"
		               \n\n" "ͼֽ.")
	      )
            )
	  )
	)
      )
    )
  )
  (if (= 1 ins_lb)
    (progn
      (setq n (- (atoi (substr rep 2)) 1))
      (setq pti (polar (polar inspt (/ pi 2) (* n 8)) pi 200))
      (setq xd (list (list -3 (list "mxb_standard" (cons 1000 (strcat app_name " " rep))))))
      (command "insert" "mxb_tab_l.dwg" pti "" "" "" rep "1" chin desc "STD" cot "")
      (mxdata (entlast) xd)
      (if all_mxb_ent
        (setq all_mxb_ent (append all_mxb_ent (list (cdr (assoc 5 (entget (entlast)))))))
        (setq all_mxb_ent (list (cdr (assoc 5 (entget (entlast))))))
      )
    )
  )
)
;********************************** End of function ***********************************;


(defun add_qty(/ qty_new)
  (setq qty_new (itoa (+ 1 (atoi (cdr (assoc 1 (entget ent_qty)))))))
  (mod_ent ent_qty qty_new)
  (setq ins_lb 0)
)
;********************************** End of function ***********************************;