(defun Sldnew(     /	ErrSldDia	SldDclID	ScrNo		AngLine
			ValidFlag	inspt		inspt1		inspt2
			SldA		SldW		SldH		SldL
			SldW1		SldW2		SldB 		SldC
			SldM)
  (setvar "cmdecho" 0)
  (command "undo" "m")
  (setq os_old (getvar "osmode")
	la_old (getvar "clayer")
	co_old (getvar "cecolor")
	lt_old (getvar "celtype")
	st_old (getvar "textstyle")
	pw_old (getvar "plinewid")
  )
  (if (not (tblsearch "appid" "ini_layer")) 
    (if (/= 'LIST (type IniLayer)) 
      (progn
	(load "ini_lay")
	(IniLayer)
      )
      (IniLayer)
    )
  )
  (setq SldDclID (load_dialog "Slide"))
;------------------------------------------
;Initializing dialog varies
;------------------------------------------
  (setq ErrSldDia nil)
  (setq AngLine  "1")
;------------------------------------------
  (while (not ErrSldDia)
    (if (not (new_dialog "SLIDE" SldDclID))
      (exit)
    )
    (IniDialog)
    (action_tile "DimW"    "(setq ValidFlag $reason) (Verify \"DimW\")")
    (action_tile "DimA"    "(setq ValidFlag $reason) (Verify \"DimA\")")
    (action_tile "DimH"    "(setq ValidFlag $reason) (Verify \"DimH\")")
    (action_tile "DimL"    "(setq ValidFlag $reason) (Verify \"DimL\")")
    (action_tile "ScrNo"   "(setq ValidFlag $reason) (Verify \"ScrNo\")")
    (action_tile "AddAL"   "(setq AngLine (get_tile \"AddAL\"))")
    (action_tile "Rejt"    "(setq ErrSldDia T) (done_dialog 0)")
    (action_tile "Accpt"   "(setq ErrSldDia T) (done_dialog 1)")
    (action_tile "CSld_Aply" "(setq ContiFlag T) (GetAllInput \"CVIEW\") (if ContiFlag (done_dialog 2))")
    (action_tile "ZSld_Aply" "(setq ContiFlag T) (GetAllInput \"ZVIEW\") (if ContiFlag (done_dialog 3))")
    (setq what_next (start_dialog))
    (cond 
      ((= 0 what_next)
	(command "undo" "b")
      )
      ((= 1 what_next)
	()
      )
      ((= 2 what_next)
	(setq inspt (getpoint "\nInsert Point:"))
	(setvar "osmode" 0)
	(if inspt (DrawSectionView))
	(setvar "osmode" os_old)
      )
      ((= 3 what_next)
	(setq inspt1 (getpoint "\nFirst Point:"))
	(if inspt1
	  (progn
	    (setq inspt2 (getpoint inspt1 "\nSecond Point:"))
	    (setvar "osmode" 0)
	    (DrawFlatView)
	    (setvar "osmode" os_old)
	  )
	)
      )
    )
  )
  (ac_lxy_set)
  (unload_dialog SldDclID)
  (prin1)
)
;------------------------------------------

;------------------------------------------
;Initialize dialog function
;------------------------------------------
(defun IniDialog()
  (IniImage)
  (if (= 'STR (type ScrNo))
    (set_tile "ScrNo" ScrNo)
  )
  (set_tile "AddAL" AngLine)
  (if (< 0 SldW) 
    (progn
      (set_tile "DimW"  (RemZeroR SldW))
      (setq ValidFlag 2)
      (Verify "DimW")
    )
  )
  (if (< 0 SldA) 
    (progn
      (set_tile "DimA"  (RemZeroR SldA))
      (setq ValidFlag 2)
      (Verify "DimA")
    )
  )
  (if (< 0 SldH) 
    (progn
      (set_tile "DimH"  (RemZeroR SldH))
      (setq ValidFlag 2)
      (Verify "DimH")
    )
  )
  (if (< 0 SldL) 
    (progn
      (set_tile "DimL"  (RemZeroR SldL))
      (setq ValidFlag 2)
      (Verify "DimL")
    )
  )
)
;------------------------------------------

;------------------------------------------
;Initialize dialog Image function
;------------------------------------------
(defun IniImage(/ pin_fn)
  (foreach pic_fn '("CSld" "ZSld")
    (start_image pic_fn)
    (slide_image 0 0 (dimx_tile pic_fn) (dimy_tile pic_fn) (strcat pic_fn ".sld"))
    (end_image)
  )
)
;------------------------------------------

;------------------------------------------
;Verify user input
;------------------------------------------
(defun Verify(DimVar / temp msg)
  (if (= 2 ValidFlag)
    (if (or (= "ScrNo" DimVar) (< 0.0 (atof (get_tile DimVar))))
      (cond
	((= "DimA" DimVar)
      	  (setq SldA (atof (get_tile DimVar)))
	  (cond
	    ((< SldA 18) 
	      (setq SldA nil) 
	      (setq msg "Invalid Dim A, Dim A must >=18!")
	    )
	    ((and (>= SldA 18) (< SldA 22))
	      (setq SldB 5
		    SldC 5
		    SldM "5/16\"BSW"
		    SldW1 9.5
		    SldW2 17.5
		    Sldd  (* 0.25 25.4)
	      )
	    )
	    ((and (>= SldA 22) (< SldA 30))
	      (setq SldB 8
		    SldC 5
		    SldM "5/16\"BSW"
		    SldW1 9.5
		    SldW2 20
		    Sldd  (* 0.25 25.4)
	      )
	    )
	    ((>= SldA 30)
	      (setq SldB 12
		    SldC 8
		    SldM "3/8\"BSW"
		    SldW1 13.5
		    SldW2 25
		    Sldd  (* (/ 5 16.0) 25.4)
	      )
	    )
          )
	)
	((= "DimW" DimVar)
	  (setq SldW (atof (get_tile DimVar)))
	  (if (< 0.0 SldH)
	    (cond 
	      ((and (> DimL 0) (<= DimW 90))
	        (if (<= SldH 45) 
		  (setq ApnNum 1 ApnD (* 0.5 25.4))
		  (setq ApnNum 1 ApnD (* 0.625 25.4))
		)
	      )
	      ((and (> DimW 90) (<= DimH 180))
	        (if (<= SldH 45) 
		  (setq ApnNum 2 ApnD (* 0.5 25.4))
		  (setq ApnNum 1 ApnD (* 0.625 25.4))
		)
	      )
	      ((> DimW 180)
		(setq ApnNum 2 ApnD (* 0.75 25.4))
	      )
	    )
	    (setq ApnNum nil ApnD nil)
	  )
	)
	((= "DimH" DimVar)
	  (setq SldH (atof (get_tile DimVar)))
	  (if (< 0.0 SldW)
	    (cond 
	      ((and (> DimW 0) (<= DimW 90))
	        (if (<= SldH 45) 
		  (setq ApnNum 1 ApnD (* 0.5 25.4))
		  (setq ApnNum 1 ApnD (* 0.625 25.4))
		)
	      )
	      ((and (> DimW 90) (<= DimH 180))
	        (if (<= SldH 45) 
		  (setq ApnNum 2 ApnD (* 0.5 25.4))
		  (setq ApnNum 1 ApnD (* 0.625 25.4))
		)
	      )
	      ((> DimW 180)
		(setq ApnNum 2 ApnD (* 0.75 25.4))
	      )
	    )
	    (setq ApnNum nil ApnD nil)
	  )
	)
	((= "DimL" DimVar)
	  (setq SldL (atof (get_tile DimVar)))
	  (if (> SldL 100) 
	    (setq Is_6_Scr t) 
	    (if (> SldL 42)
	      (setq Is_6_Scr nil)
	      (progn
		(setq msg "Dim \"L\" is too small!")
		(setq SldL nil)
	      )
	    )
	  )
	)
	((= "ScrNo" DimVar)
	  (setq ScrNo (lxy_trim (get_tile DimVar)))
	  (if (= "" ScrNo)
	    (setq msg "Invalid Screw item label!")
	    (if (/= "V" (strcase (substr ScrNo 1 1)))
	      (setq msg "Invalid Screw item label!")
	      (if (< (atoi (substr ScrNo 2)) 1)
		(setq msg "Invalid Screw item label!")
		(progn
		  (setq ScrNo (strcat "V" (itoa (atoi (substr ScrNo 2)))))
		  (set_tile "ScrNo" ScrNo)
		)
	      )
	    )
	  )
	  (if msg (setq ScrNo nil))
	)
      )
      (setq msg "Invalid Input!")
    )
  )
  (if (= 2 ValidFlag) 
    (progn
      (setq ValidFlag nil)
      (if msg
	(progn
	  (set_tile DimVar "")
	  (set_tile "ERRMSG" msg)
	)
	(set_tile "ERRMSG" "")
      )
    )
  )
)
;------------------------------------------

;*******************************************************;
;Get all user input function
;*******************************************************;
(defun GetAllInput(ToDo)
  (cond
    ((= "CVIEW" ToDo)
      (if (and SldW SldA SldH ScrNo)
	(setq ContiFlag T)
        (progn
          (setq ContiFlag nil)
          (set_tile "ERRMSG" (strcat "Invalid Parameters: "   
					(if (not SldW) "\"W\" " "")
					(if (not SldA) "\"A\" " "")
					(if (not SldH) "\"H\" " "")
					(if (not ScrNo) "\"Screw No.\" " ""))
	  )
	)
      )
    )
    ((= "ZVIEW" ToDO)
      (if (and SldW SldA SldL ScrNo)
	(setq ContiFlag T)
	(progn
	  (setq ConTiFlag nil)
	  (set_tile "ERRMSG" (strcat "Invalid Parameters: "   
					(if (not SldW) "\"W\" " "")
					(if (not SldA) "\"A\" " "")
					(if (not SldL) "\"L\" " "")
					(if (not ScrNo) "\"Screw No.\" " ""))
	  )
	)
      )
    )			
  )
)


;**************************************************************;
;Draw SLIDE section view
;**************************************************************;
(defun DrawSectionView(/	w1		w2		w3		w4
				h		d		l		a
				b		bpt1		bpt2		bpt3
				bpt4		scpt		dwpt1		dwpt2)
  (setq w1 (/ SldW 2.0)
	w2 (/ (+ (* SldC 2.0)  SldW) 2.0)
	w3 (/ (+ (* SldW1 2.0) SldW) 2.0)
	w4 (/ (+ (* SldW2 2.0) SldW) 2.0)
	h  SldH
	d  Sldd
	a  SldA
	b  SldB)
  (setq bpt1 (polar inspt (* pi 0.5) b)
	bpt2 (polar inspt (* pi 0.5) (- a 0.5))
	bpt3 (polar inspt (* pi 0.5) a)
	bpt4 (polar inspt (* pi 0.5) h)
	scpt (polar bpt2  0  w3)
  )
  (setq dwpt1 (polar bpt2  pi w3))
;---------------------------------------
  (setvar "clayer" "continuous")
;---------------------------------------
  (command "line" (polar inspt pi w2) (polar bpt1 pi w2) (polar bpt1 pi w1) (polar bpt4  pi w1)
		  (polar bpt4  0  w1) (polar bpt1 0  w1) (polar bpt1 0  w2) (polar inspt 0 w2) "")
;---------------------------------------
  (command "line" (polar bpt3 pi w1) (polar bpt3 pi w4) ""
	   "line" (polar bpt3 0  w1) (polar bpt3 0  w4) "")
;---------------------------------------
  (command "line" (polar inspt pi (+ w2 0.5)) (polar bpt1 pi (+ w2 0.5)) (polar bpt1  pi w1) 
		  (polar bpt2  pi w1)         (polar bpt2 pi w4)         (polar inspt pi w4) "")
  (command "line" (polar inspt 0 (+ w2 0.5))  (polar bpt1 0 (+ w2 0.5)) (polar bpt1  0 w1) 
		  (polar bpt2  0 w1)          (polar bpt2 0 w4)         (polar inspt 0 w4) "")
  (command "line" (polar inspt pi w4)               (polar inspt pi (+ w3 (* d 0.5))) ""
	   "line" (polar inspt pi (- w3 (* d 0.5))) (polar inspt 0 w4) "")
;---------------------------------------
  (command "line" (polar bpt2 pi (+ w3 (* Sldd 0.5))) (polar inspt pi (+ w3 (* Sldd 0.5))) ""
	   "line" (polar bpt2 pi (- w3 (* Sldd 0.5))) (polar inspt pi (- w3 (* Sldd 0.5))) "")
  (DrawDlPinC dwpt1 (* pi 1.5) sldd (fix (* a 1.5)))
;---------------------------------------
  (setvar "clayer" "center")
  (command "line" (polar inspt (* pi 1.5) 5) (polar bpt4  (* pi 0.5) 5) "")
  (command "line" (polar dwpt1 (* pi 0.5) 3) (polar dwpt1 (* pi 1.5) (+ 3 (fix (* a 1.5)))) "")
;---------------------------------------
  (if (= "1" AngLine)
    (progn
      (setvar "clayer" "hidden")
      (setq ang5D (* (/ 5 180.0) pi))
      (setq angLen (+ (/ (- SldH SldA 2) (cos ang5D)) (* 2 (/ (sin ang5D) (cos ang5D)))))	
      (setq VertPt1 (polar bpt3 pi w1)
	    VertPt2 (polar VertPt1 (- (* pi 0.5) ang5D) angLen)
	    cenpt1  (polar VertPt2 (- 0 ang5D) 2)
	    VertPt3 (polar cenpt1 (* pi 0.5) 2)
      )
      (setq VertPt4 (polar bpt3 0 w1)
	    VertPt5 (polar VertPt4 (+ (* pi 0.5) ang5D) angLen)
	    cenpt2  (polar VertPt5 (+ pi ang5D) 2)
	    VertPt6 (polar cenpt2 (* pi 0.5) 2)
      )
      (command "pline" VertPt3 "a" "ce" cenpt1 VertPt2 "l" VertPt1 ""
	       "pline" VertPt4 VertPt5 "a" "ce" cenpt2 VertPt6 "")
    )
  )
;---------------------------------------
  (if (/= 'LIST (type ScrewGet)) (load "ScrewGet"))
  (setvar "clayer" "screw")
  (ScrewGet 'CAP scpt (polar scpt (* pi 1.5) (- a 0.5)) nil SldM ScrNo 28)
;---------------------------------------
  (setvar "clayer" "dim")
  (command "dim" "hor"  (polar bpt1 pi w1) (polar bpt1 0 w1) 
			(polar inspt (* pi 1.5) 10) (RemZeroR (* 2 w1))
		 "hor" 	(polar inspt pi w2) (polar inspt 0 w2) 
			(polar inspt (* pi 1.5) 20) (RemZeroR (* 2 w2))
		 "hor"  (polar bpt4 0 w1) (polar bpt3 0 w4) 
			(polar scpt (* pi 0.5) (+ (- SldH SldA) 5)) (RemZeroR (- w4 w1))
		 "ver"  (polar inspt 0 w4) (polar bpt3 0 w4) 
			(polar (polar inspt 0 (+ w4 8)) (* pi 0.5) (* SldA 0.5)) (RemZeroR SldA)
		 "ver"  (polar inspt pi w4) (polar bpt4 pi w1) 
			(polar (polar inspt pi (+ w4 8)) (* pi 0.5) (* SldH 0.5)) (RemZeroR SldH)
		 "ver"  (polar inspt pi w1) (polar bpt1 pi w1)
			(polar (polar inspt pi (- w1 8)) (* pi 0.5) (* 2 SldB)) (RemZeroR SldB)
	   "exit")
)
;*********************** End of function **********************;

;**************************************************************;
;Draw SLIDE section view
;**************************************************************;
(defun DrawFlatView()
  (setq w1 (/ SldW 2.0)
	w2 (/ (+ (* SldC 2.0)  SldW) 2.0)
	w3 (/ (+ (* SldW1 2.0) SldW) 2.0)
	w4 (/ (+ (* SldW2 2.0) SldW) 2.0)
  )
  (setq ang (angle inspt1 inspt2)
	angh (+ ang pi)
	angv (+ ang (* pi 0.5))
	angvv (- ang (* pi 0.5))
  )
  (setq inspt2 (polar inspt1 ang SldL))
  (setq bpt1 (polar inspt1 ang 10)
	bpt2 (polar inspt1 ang 22)
	bpt3 (polar inspt2 angh 10)
	bpt4 (polar inspt2 angh 22)
  )
  (if Is_6_Scr (setq bpt5 (polar inspt1 ang (* SldL 0.5))))
;-----------------------------------------
  (setvar "clayer" "continuous")
  (command "line" (polar inspt1 angv w4) (polar inspt1 angvv w4)
		  (polar inspt2 angvv w4) (polar inspt2 angv w4) "C"
	   "line" (polar inspt1 angv w1) (polar inspt2 angv w1) ""
	   "line" (polar inspt1 angvv w1) (polar inspt2 angvv w1) "")
  (setvar "clayer" "hidden")
  (command "line" (polar inspt1 angv w2) (polar inspt2 angv w2) ""
	   "line" (polar inspt1 angvv w2) (polar inspt2 angvv w2) "")
;----------------------------------------
  (if (/= 'LIST (type ScrewGet)) (load "ScrewGet"))
  (setvar "clayer" "screw")
  (if Is_6_Scr
    (progn
      (ScrewGet 'CAP (polar bpt5 angvv w3) (polar bpt5 angvv (- (+ w3 SldA) 0.5)) nil SldM ScrNo 8)
      (ScrewGet 'CAP (polar bpt5 angv w3) (polar bpt5 angv (- (+ w3 SldA) 0.5)) nil SldM ScrNo 8)
      (ScrewGet 'CAP (polar bpt1 angv w3) (polar bpt1 angv (- (+ w3 SldA) 0.5)) nil SldM ScrNo 8)
      (ScrewGet 'CAP (polar bpt3 angv w3) (polar bpt3 angv (- (+ w3 SldA) 0.5)) nil SldM ScrNo 8)
      (ScrewGet 'CAP (polar bpt1 angvv w3) (polar bpt1 angvv (- (+ w3 SldA) 0.5)) nil SldM ScrNo 8)
      (ScrewGet 'CAP (polar bpt3 angvv w3) (polar bpt3 angvv (- (+ w3 SldA) 0.5)) nil SldM ScrNo 8)
    )
    (progn
      (ScrewGet 'CAP (polar bpt1 angv w3) (polar bpt1 angv (- (+ w3 SldA) 0.5)) nil SldM ScrNo 8)
      (ScrewGet 'CAP (polar bpt4 angv w3) (polar bpt4 angv (- (+ w3 SldA) 0.5)) nil SldM ScrNo 8)
      (ScrewGet 'CAP (polar bpt1 angvv w3) (polar bpt1 angvv (- (+ w3 SldA) 0.5)) nil SldM ScrNo 8)
      (ScrewGet 'CAP (polar bpt4 angvv w3) (polar bpt4 angvv (- (+ w3 SldA) 0.5)) nil SldM ScrNo 8)
    )
  )
  (if Is_6_Scr
    (progn
      (DrawDlPinZ (polar bpt2 angv w3)  Sldd ang)
      (DrawDlPinZ (polar bpt2 angvv w3) Sldd ang)
      (DrawDlPinZ (polar bpt4 angv w3)  Sldd ang)
      (DrawDlPinZ (polar bpt4 angvv w3) Sldd ang)
    )
    (progn
      (DrawDlPinZ (polar bpt2 angv w3)  Sldd ang)
      (DrawDlPinZ (polar bpt2 angvv w3) Sldd ang)
      (DrawDlPinZ (polar bpt3 angv w3)  Sldd ang)
      (DrawDlPinZ (polar bpt3 angvv w3) Sldd ang)
    )
  )
;---------------------------------------
  (setvar "clayer" "dim")
  (command "dim" "align" (polar bpt1 angv w3) (polar inspt1 angv w3) "t" "10" (polar (polar bpt1 angh 5) angv (+ w4 8))
		 "align" (polar bpt1 angv w3) (polar bpt2   angv w3) "t" "12" (polar (polar bpt1 ang  6) angv (+ w4 8))
		 "align" (polar bpt3 angv w3) (polar inspt2 angv w3) "t" "10" (polar (polar bpt3 ang  5) angv (+ w4 8))
		 "align" (polar bpt3 angv w3) (polar bpt4   angv w3) "t" "12" (polar (polar bpt4 ang  6) angv (+ w4 8))
		 "align" (polar bpt1 angvv w3) (polar inspt1 angvv w3) "t" "10" (polar (polar bpt1 angh 5) angvv (+ w4 8))
		 "align" (polar bpt1 angvv w3) (polar bpt2   angvv w3) "t" "12" (polar (polar bpt1 ang  6) angvv (+ w4 8))
		 "align" (polar bpt3 angvv w3) (polar inspt2 angvv w3) "t" "10" (polar (polar bpt3 ang  5) angvv (+ w4 8))
		 "align" (polar bpt3 angvv w3) (polar bpt4   angvv w3) "t" "12" (polar (polar bpt4 ang  6) angvv (+ w4 8))
		 "align" (polar bpt1 angv  w3) (polar bpt1 angvv w3) "t" (RemZeroR (* w3 2)) (polar inspt1 angh 10)
	   "exit")
  (if Is_6_Scr
    (command "dim" "align" (polar inspt1 angvv w3) (polar bpt5 angvv w3) "t" (RemZeroR (* SldL 0.5))
			   (polar (polar inspt1 ang (* SldL 0.25)) angvv (+ w4 16))
		   "align" (polar inspt1 angv w3) (polar bpt5 angv w3) "t" (RemZeroR (* SldL 0.5))
			   (polar (polar inspt1 ang (* SldL 0.25)) angv (+ w4 16))
	    "exit")
  )
;---------------------------------------
  (setvar "clayer" "center")
  (command "line" (polar inspt1 angh 5) (polar inspt2 ang 5) "")
)
;*********************** End of function **********************;


;**************************************************************;
;Draw dual pin
;**************************************************************;
(defun DrawDlPinC(StartPt Ang D L / EndPt	NextStartPt	NextEndPt
				AngH		AngV		AngVV)
  (setvar "osmode" 0)
  (setq AngH  (+ Ang pi)
	AngV  (+ Ang (* pi 0.5))
	AngVV (- Ang (* pi 0.5))
  )
  (setq EndPt       (polar StartPt Ang  L)
	NextStartPt (polar StartPt Ang  0.5)
	NextEndPt   (polar EndPt   AngH 0.5)
  )
  (command "line" (polar StartPt     AngV  (- (* D 0.5) 0.5)) (polar StartPt     AngVV (- (* D 0.5) 0.5))
		  (polar NextStartPt AngVV (* D 0.5))         (polar NextEndPt   AngVV (* D 0.5))
		  (polar EndPt       AngVV (- (* D 0.5) 0.5)) (polar EndPt       AngV  (- (* D 0.5) 0.5))
		  (polar NextEndPt   AngV  (* D 0.5))         (polar NextStartPt AngV  (* D 0.5)) "C"
	   "line" (polar NextStartPt AngV  (* D 0.5))         (polar NextStartPt AngVV (* D 0.5)) ""
	   "line" (polar NextEndPt   AngV  (* D 0.5))         (polar NextEndPt   AngVV (* D 0.5)) ""
  )
)
;---------------------------------
(defun DrawDlPinZ(CenterPt D ang / angH angV angVV)
  (setvar "osmode" 0)
  (setvar "clayer" "continuous")
  (setq angH  (+ ang pi)
	angV  (+ ang (* pi 0.5))
	angVV (- ang (* pi 0.5))
  )
  (command "pline" (polar CenterPt angH (* D 0.25)) "w" (* D 0.5) "" 
		   "a" "ce" CenterPt (polar CenterPt ang (* D 0.25)) ""
	   "circle" CenterPt (* D 0.5)
  )
  (setvar "clayer" "center")
  (command "line" (polar CenterPt angH (+ (* D 0.5) 2)) (polar CenterPt ang (+ (* D 0.5) 2)) ""
	   "line" (polar CenterPt angV (+ (* D 0.5) 2)) (polar CenterPt angVV (+ (* D 0.5) 2)) "")
  (setvar "plinewid" pw_old)
)
;************************** End of function **********************;