
(defun ssort(/ 	inspt 		screw_set 	ent_count	i 		ent_nam 
		all_mxb_ent	screw_count	epin_count	apn_count	all_count	
		old_set		old_set_nstd	all_mxb_ent)
;------------------------------------------
;shut off command echo and set undo mark
;------------------------------------------
  (setvar "cmdecho" 0)
  (command "undo" "m")
;------------------------------------------
;save current system var
;------------------------------------------
  (setq os_old (getvar "osmode"))
  (setq la_old (getvar "clayer"))
;------------------------------------------
;set user system var
;------------------------------------------
  (if (not (tblsearch "layer" "mxb"))
    (command "_.layer" "_new" "mxb" "_color" "red" "mxb" "_ltype" "continuous" "mxb" "")
    (command "_.layer" "thaw" "mxb" "on" "mxb" "unlock" "mxb" "")
  )
  (setvar "clayer" "mxb")
  (ini_useri2)
;------------------------------------------
;delete old bill table
;------------------------------------------
  (if (not (tblsearch "appid" "mxb_standard"))
    (regapp "mxb_standard")
  )
  (setq old_set (ssget "X" '((0 . "INSERT") (-3 ("mxb_standard")))))
  (if old_set
    (command "erase" old_set "")
  )
;------------------------------------------
;get bill table insert point
;------------------------------------------
  (if (> (getvar "useri1") 0)
    (progn
      (setq inspt (getpoint "\nPlease get a insert point:"))
      (if (not inspt)
        (progn
          (setq bpt (wtou (list (getvar "userr1") (getvar "userr2"))))
          (if ent_sel_mxb
            (setq i (+ (getvar "useri1") 1))
            (setq i 0)
          )
          (setq inspt (polar bpt (* pi 0.5) (* 8 i)))
        )
      )
    )
    (while (not inspt)
      (setq inspt (getpoint "\nPlease get a insert point:"))
    )
  )
;------------------------------------------
;Initializing
;------------------------------------------
  (setvar "osmode" 0)
  (princ "\nAnalyzing entity... \nBegin to create SCREW bill table, please wait...")
  (if (not (tblsearch "appid" "mxb_standard"))
    (regapp "mxb_standard")
  )
  (setq all_mxb_ent nil
	screw_count 0
     	epin_count  0
        all_count   0
     	pin_count   0
     	sp_count    0
        apn_count   0
  )
  (setq inshdpt inspt)
  (setq inspt (polar inspt (* pi 0.5) 8.0))
;------------------------------------------
;Find out screw entities and create screw bill
;------------------------------------------
  (setq screw_set (ssget "X" '((0 . "INSERT") (-3 ("screw")))))
  (if screw_set
    (progn
      (setq ent_count (sslength screw_set))
      (setq i 0)
      (while (< i ent_count)
	(setq ent_nam (ssname screw_set i))
	(deal_screw)
	(setq i (+ i 1))
      )
      (if screw_count
        (setq all_count screw_count)
      )
      (if (> screw_count 0)
        (princ (strcat "\nFound" " " (itoa screw_count) " " "kinds of screw!"))
      )
    )
    (princ "\nNot found any screw!")
  )
;---------------------------------------------------------
;Find out ejector pin entities and create ejector pin bill
;---------------------------------------------------------
  (setq inspt (polar inshdpt (/ pi 2) (* 8 (+ 1 all_count))))
  (setq epin_set (ssget "X" '((0 . "INSERT") (-3 ("epin")))))
  (if epin_set
    (progn
      (setq ent_count (sslength epin_set))
      (setq i 0)
      (while (< i ent_count)
	(setq ent_nam (ssname epin_set i))
	(deal_epin)
	(setq i (+ i 1))
      )
      (setq all_count (+ all_count epin_count))
      (if (> epin_count 0)
        (princ (strcat "\nFound" " " (itoa epin_count) " " "kinds of ejector pin!"))
      )
    )
    (princ "\nNot found any ejector pin!")
  )
;---------------------------------------------------------
;Find out angle pin entities and create angle pin bill
;---------------------------------------------------------
  (setq inspt (polar inshdpt (/ pi 2) (* 8 (+ 1 all_count))))
  (setq apn_set (ssget "X" '((0 . "INSERT") (-3 ("apn")))))
  (if apn_set
    (progn
      (setq ent_count (sslength apn_set))
      (setq i 0)
      (while (< i ent_count)
	(setq ent_nam (ssname apn_set i))
	(deal_apn)
	(setq i (+ i 1))
      )
      (setq all_count (+ all_count apn_count))
      (if (> apn_count 0)
        (princ (strcat "\nFound" " " (itoa apn_count) " " "kinds of angle pin!"))
      )
    )
    (princ "\nNot found any angle pin!")
  )
;---------------------------------------------------------
;Find out pin entities and create pin bill table
;---------------------------------------------------------
  (setq inspt (polar inshdpt (/ pi 2) (* 8 (+ 1 all_count))))
  (setq pin_set (ssget "X" '((0 . "INSERT") (-3 ("pin")))))
  (if pin_set
    (progn
      (setq ent_count (sslength pin_set))
      (setq i 0)
      (while (< i ent_count)
	(setq ent_nam (ssname pin_set i))
	(deal_pin)
	(setq i (+ i 1))
      )
      (setq all_count (+ all_count pin_count))
      (if (> pin_count 0)
        (princ (strcat "\nFound" " " (itoa pin_count) " " "kinds of pin!"))
      )
    )
    (princ "\nNot found any pin!")
  )
;---------------------------------------------------------
;Find out spring entities and create spring bill table
;---------------------------------------------------------
  (setq inspt (polar inshdpt (/ pi 2) (* 8 (+ 1 all_count))))
  (setq sp_set (ssget "X" '((0 . "INSERT") (-3 ("spring")))))
  (if sp_set
    (progn
      (setq ent_count (sslength sp_set))
      (setq i 0)
      (while (< i ent_count)
	(setq ent_nam (ssname sp_set i))
	(deal_sp)
	(setq i (+ i 1))
      )
      (setq all_count (+ all_count sp_count))
      (if (> sp_count 0)
        (princ (strcat "\nFound" " " (itoa sp_count) " " "kinds of spring!"))
      )
    )
    (princ "\nNot found any spring!")
  )
;----------------------------------------------
;Reset system variable
;----------------------------------------------
  (if (< 0 all_count)
    (progn
      (command "insert" "mxb_head" inshdpt "" "" "")
      (setq xd (list (list -3 (list "mxb_standard" (cons 1000 "mxb_head")))))
      (mxdata (entlast) xd)
    )
  )
  (ac_lxy_set)
  (prin1)
)
;********************************** End of function ***********************************;


;************************* Begin screw create screw bill table ************************;
(defun deal_screw()
  (setq screw_data (cdr (cadr (cadr (assoc -3 (entget ent_nam '("screw")))))))
  (setq screw_data (strtolst screw_data))
  (progn
    (setq rep      (nth 0 screw_data)
	  mb       (nth 6 screw_data)
	  type_old (nth 2 screw_data)
	  len_old  (nth 3 screw_data)
	  zc       (nth 1 screw_data)
          if_h_v   (nth 4 screw_data)
          typ_old  (nth 5 screw_data)
          cot      (strcat type_old "X" len_old)
    )
    (cond
      ((= "CAP" typ_old)
        (setq chin "ͷ˿")
	(setq desc "S.H.C.S")
      )
      ((= "SET" typ_old)
	(setq chin "ͷ˿")
	(setq desc "S.H.S.S")
      )
      ((= "FLAT" typ_old)
	(setq chin "ƽͷ˿")
	(setq desc "F.H.C.S")
      )
    )
  )
  (setq spec_var (strcat chin cot))
  (if (= "Z" zc)
    (progn
      (transtomxb "screw")
      (if (= 1 ins_lb)
        (if (> (atoi (substr rep 2)) screw_count)
          (setq screw_count (atoi (substr rep 2)))
        )
      )
    )
  )
)
;********************************** End of function ***********************************;


;************************* Begin create ejector pin bill table ************************;
(defun deal_epin()
  (setq epin_data (cdr (cadr (cadr (assoc -3 (entget ent_nam '("epin")))))))
  (setq epin_data (strtolst epin_data))
  (progn
    (setq rep      (nth 0 epin_data)
	  mb       (nth 6 epin_data)
	  type_old (nth 2 epin_data)
	  len_old  (nth 3 epin_data)
	  zc       (nth 1 epin_data)
          if_h_v   (nth 4 epin_data)
          typ_old  (nth 5 epin_data)
          cot      (strcat "%%c" type_old "X" len_old)
    )
    (cond
      ((= "N" typ_old)
        (setq chin "ֱ")
	(setq desc "EJECTOR PIN")
      )
      ((= "W" typ_old)
	(setq chin "ж")
	(setq desc "STEP EJECTOR PIN")
      )
    )
  )
  (setq spec_var (strcat chin cot))
  (if (= "Z" zc)
    (progn
      (transtomxb "epin")
      (if (= 1 ins_lb)
        (if (> (atoi (substr rep 2)) epin_count)
          (setq epin_count (atoi (substr rep 2)))
        )
      )
    )
  )
)
;********************************** End of function ***********************************;


;************************** Begin  create angle pin bill table ************************;
(defun deal_apn()
  (setq apn_data (cdr (cadr (cadr (assoc -3 (entget ent_nam '("apn")))))))
  (setq apn_data (strtolst apn_data))
  (progn
    (setq rep      (nth 0 apn_data)
	  mb       (nth 6 apn_data)
	  type_old (nth 2 apn_data)
	  len_old  (nth 3 apn_data)
	  zc       (nth 1 apn_data)
          if_h_v   (nth 4 apn_data)
          typ_old  (nth 5 apn_data)
          cot      (strcat "%%c" type_old "X" len_old)
    )
    (setq chin "б")
    (setq desc "ANGLE PIN")
  )
  (setq spec_var (strcat chin cot))
  (if (= "ZB" zc)
    (progn
      (transtomxb "apn")
      (if (= 1 ins_lb)
        (if (> (atoi (substr rep 2)) apn_count)
          (setq apn_count (atoi (substr rep 2)))
        )
      )
    )
  )
)
;********************************** End of function ***********************************;


;***************************** Begin create pin bill table ****************************;
(defun deal_pin()
  (setq pin_data (cdr (cadr (cadr (assoc -3 (entget ent_nam '("pin")))))))
  (setq pin_data (strtolst pin_data))
  (progn
    (setq rep      (nth 0 pin_data)
	  mb       (nth 6 pin_data)
	  type_old (nth 2 pin_data)
	  len_old  (nth 3 pin_data)
	  zc       (nth 1 pin_data)
          if_h_v   (nth 4 pin_data)
          typ_old  (nth 5 pin_data)
          cot      (strcat "%%c" type_old "X" len_old)
    )
    (setq chin "")
    (setq desc "EJECTOR PIN")
  )
  (setq spec_var (strcat chin cot))
  (if (= "Z" zc)
    (progn
      (transtomxb "pin")
      (if (= 1 ins_lb)
        (if (> (atoi (substr rep 2)) pin_count)
          (setq pin_count (atoi (substr rep 2)))
        )
      )
    )
  )
)
;********************************** End of function ***********************************;


;*************************** Begin create spring bill table ***************************;
(defun deal_sp()
  (setq sp_data (cdr (cadr (cadr (assoc -3 (entget ent_nam '("spring")))))))
  (setq sp_data (strtolst sp_data))
  (progn
    (setq rep      (nth 0 sp_data)
	  mb       (nth 6 sp_data)
	  type_old (nth 2 sp_data)
	  len_old  (nth 3 sp_data)
	  zc       (nth 1 sp_data)
          if_h_v   (nth 4 sp_data)
          typ_old  (nth 5 sp_data)
          cot      (strcat "OD" type_old "X" len_old)
    )
    (setq chin "")
    (setq desc "SPRING")
  )
  (setq spec_var (strcat chin cot))
  (if (= "Z" zc)
    (progn
      (transtomxb "spring")
      (if (= 1 ins_lb)
        (if (> (atoi (substr rep 2)) sp_count)
          (setq sp_count (atoi (substr rep 2)))
        )
      )
    )
  )
)
;********************************** End of function ***********************************;


;********************************** Share function ************************************;
(defun mod_ent(ent_name mod_data / ent_data)
  (setq ent_data (entget ent_name))
  (setq ent_data (subst (cons 1 mod_data)
			(assoc 1 ent_data)
			ent_data)
  )
  (entmod ent_data)
  (entupd ent_name)
)
;********************************** End of function ***********************************;


;********************************* Create bill table **********************************;
(defun transtomxb(app_name /    entn 		ent_sel 	ent_chin 	ent_qty 	
				ent_rep		ent_obv 	ent_cot		ent_amt 	
				ent_desc 	spec)
  (setq ins_lb 1)
  (if all_mxb_ent
    (foreach entn all_mxb_ent 
      (progn
	(setq ent_sel  (handent entn))
 	(setq ent_rep  (entnext ent_sel))
	(setq ent_qty  (entnext ent_rep))
	(setq ent_chin (entnext ent_qty))
	(setq ent_desc (entnext ent_chin))
	(setq ent_mat  (entnext ent_desc))
	(setq ent_cot  (entnext ent_mat))
	(setq ent_obv  (entnext ent_cot))
	(setq spec (strcat (cdr (assoc 1 (entget ent_chin)))
			   (cdr (assoc 1 (entget ent_cot)))
		   )
	)
	(if (= rep (cdr (assoc 1 (entget ent_rep))))
	  (if (= spec_var spec)
	    (add_qty)
            (progn
              (command "undo" "b")
              (redraw ent_nam 3)
	      (*error* (strcat "\"" rep "\"" 
			       "кֲͬ"
			       "\n\n     \"" spec "\"\n     \"" spec_var "\"
		               \n\n" "ͼֽ.")
	      )
            )
	  )
	)
      )
    )
  )
  (if (= 1 ins_lb)
    (progn
      (setq n (- (atoi (substr rep 2)) 1))
      (setq pti (polar (polar inspt (/ pi 2) (* n 8)) pi 200))
      (setq xd (list (list -3 (list "mxb_standard" (cons 1000 (strcat app_name " " rep))))))
      (setq old_var (getvar "attdia" ))
      (setvar "attdia" 0)
      (command "insert" "mxb_tab_l.dwg" pti "" "" "" rep "1" chin desc "STD" cot "")
      (setvar "attdia" old_var)
      (mxdata (entlast) xd)
      (if all_mxb_ent
        (setq all_mxb_ent (append all_mxb_ent (list (cdr (assoc 5 (entget (entlast)))))))
        (setq all_mxb_ent (list (cdr (assoc 5 (entget (entlast))))))
      )
    )
  )
)
;********************************** End of function ***********************************;


(defun add_qty(/ qty_new)
  (setq qty_new (itoa (+ 1 (atoi (cdr (assoc 1 (entget ent_qty)))))))
  (mod_ent ent_qty qty_new)
  (setq ins_lb 0)
)
;********************************** End of function ***********************************;