(defun set_cst(/ spt1 	spt2	spt3	spt4	spt5	spt6	spt7	spt8	spt9	spt10
		spt11	spt12 	spt13	spt14	spt15	spt16	spt17	spt18	angh	angv	
		angvv	scpt1	scpt2	sel_ent textpt1	textpt2	textang	textangv)
;---------------------------------------------------------
;Calculate angle value
;---------------------------------------------------------
  (if (= "NEW" app_typ)
    (progn 
      (setq l12 (distance pt1 pt2))
      (setq ang (angle pt1 pt2))
    )
    (progn
      (setq pt2 (polar pt ang l))
      (setq pt1 (polar pt2 (+ ang pi) l12))
    )
  )
  (setq angh  (+ pi ang))
  (setq angv  (+ ang (/ pi 2)))
  (setq angvv (- ang (/ pi 2)))
;-----------------------------------------------------
;calculate c'bore points ordinate
;-----------------------------------------------------
  (setq spt1 (polar pt1 angv (/ d 2))
	spt4 (polar pt1 angvv (/ d 2))
	spt2 (polar spt1 angvv (* d 0.1))
	spt3 (polar spt4 angv (* d 0.1))
	spt11 (polar spt1 ang (distance pt1 pt2))
	spt12 (polar spt2 ang (distance pt1 pt2))
	spt15 (polar spt3 ang (distance pt1 pt2))
	spt16 (polar spt4 ang (distance pt1 pt2))
  )
;-----------------------------------------------------
;calculate screw points ordinate
;-----------------------------------------------------
  (setq spt5  (polar pt angv (- (/ d 2) (* d 0.1)))
	spt6  (polar pt angvv (- (/ d 2) (* d 0.1)))
	spt7  (polar (polar spt5 ang (* d  0.1)) angv (* d 0.1))
	spt8  (polar (polar spt6 ang (* d  0.1)) angvv (* d 0.1))
	spt9  (polar spt7 ang (- l z (* d 0.1)))
	spt10 (polar spt8 ang (- l z (* d 0.1)))
	spt13 (polar (polar spt9 ang z) angvv z)
	spt14 (polar (polar spt10 ang z) angv z)
	spt17 (polar (polar spt9 angvv (* d 0.1)) ang (* d 0.1))
	spt18 (polar (polar spt10 angv (* d 0.1)) ang (* d 0.1))
  )
;-----------------------------------------------------
;calculate center line points ordinate and
;text insert points ordinate
;-----------------------------------------------------
  (setq scpt1 (polar pt1 angh 1)
        scpt2 (polar pt2 ang 1)
  )
  (setq textpt1 (polar pt1 angh (+ 1.5 (abs (* 1.77 (cos (- (/ pi 4) ang)))))))
  (if (and (> ang (* pi 0.51)) (< ang (* pi 1.50)))
    (progn
      (setq textang (* (+ ang pi) (/ 180 pi)))
      (setq textangv angvv)
      (if (and (> (- (distance spt7 spt9) 0.5) (* 1.25 (strlen (strcat screw_type "X" screw_len))))
	       (>= d 4)
          )
        (progn
	  (setq textpt2 (polar (polar pt ang (+ (* d 0.2) (* 1.25 (strlen (strcat screw_type "X" screw_len)))))
			       angv 1.25))
          (setq scpt3   (polar pt ang (* d 0.1)))
          (setq scpt4   (polar scpt3  ang (* 1.25 (strlen (strcat screw_type "X" screw_len)))))
        )
        (progn
	  (setq textpt2 (polar (polar spt10 angvv 0.5) ang 0.5)) 
          (setq scpt3 nil)
          (setq scpt4 nil)
        )
      )
    )
    (progn
      (setq textang (* ang (/ 180 pi)))
      (setq textangv angv)
      (if (and (> (- (distance spt7 spt9) 0.5) (* 1.25 (strlen (strcat screw_type "X" screw_len))))
	       (>= d 4)
          )
        (progn
	  (setq textpt2 (polar (polar spt7 angvv (+ (* d 0.5) 1.25)) ang 0.4))
          (setq scpt3   (polar pt ang (* d 0.1)))
          (setq scpt4   (polar scpt3  ang (* 1.25 (strlen (strcat screw_type "X" screw_len)))))
        )
        (progn
	  (setq textpt2 (polar (polar spt7 angv 0.5) angh 0.5))
          (setq scpt3 nil)
          (setq scpt4 nil)
        )
      )
    )
  )
;-------------------------------------------------------
;if hidden then set current linetype as hidden
;-------------------------------------------------------
  (if (= if_h_v "1")
     (progn
    	(command "linetype" "s" "hidden" "")
    	(setvar "cecolor" "yellow")
     )
  )
;------------------------------------------------------
;cancel osnap mode
;------------------------------------------------------
  (setvar "osmode" 0)
;------------------------------------------------------
;draw screw
;------------------------------------------------------
  (progn
    (setq sel_ent (ssadd))
    (command "pline" spt5 spt7 spt9 spt13 spt14 spt10 spt8 spt6 spt5 "")
    (setq sel_ent (ssadd (entlast) sel_ent))
    (command "line" spt5 spt17 "")
    (setq sel_ent (ssadd (entlast) sel_ent))
    (command "line" spt7 spt8 "")
    (setq sel_ent (ssadd (entlast) sel_ent))
    (command "line" spt9 spt10 "")
    (setq sel_ent (ssadd (entlast) sel_ent))
    (command "line" spt6 spt18 "")
    (setq sel_ent (ssadd (entlast) sel_ent))
  )
;-----------------------------------------------------
;Draw c'bore and screw hole
;-----------------------------------------------------
  (progn
    (command "pline" spt1 spt11 "")
    ;(setq sel_ent (ssadd (entlast) sel_ent))
    (command "pline" spt2 spt12 "")
    ;(setq sel_ent (ssadd (entlast) sel_ent))
    (command "pline" spt3 spt15 "")
    ;(setq sel_ent (ssadd (entlast) sel_ent))
    (command "pline" spt4 spt16 "")
    ;(setq sel_ent (ssadd (entlast) sel_ent))
  )
;-----------------------------------------------------
;Draw center line
;-----------------------------------------------------
  (progn 
    (command "linetype" "s" "center" "")
    (setvar "cecolor" "red")
    (if (and scpt2 scpt4)
      (progn
        (command "line" scpt1 scpt3 "")
        ;(setq sel_ent (ssadd (entlast) sel_ent))
        (command "line" scpt4 scpt2 "")
        ;(setq sel_ent (ssadd (entlast) sel_ent))
      )
      (progn
        (command "line" scpt1 scpt2 "")
        ;(setq sel_ent (ssadd (entlast) sel_ent))
      )
    )
    (setvar "celtype" "bylayer")
    (setvar "cecolor" "bylayer")
  )
;-----------------------------------------------------
;Dim specification and item number
;-----------------------------------------------------
  (progn
     (if (not (tblsearch "style" "lxy1"))
	(command "-style" "lxy1" "txt" "" 0.5 "" "" "" "")
	(setvar "textstyle" "lxy1")
     )
     (command "text" textpt2 2.5 textang (strcat screw_type "X" screw_len))
     ;(setq sel_ent (ssadd (entlast) sel_ent))
     (if (not (tblsearch "style" "lxy2"))
	(command "-style" "lxy2" "txt" "" 0.6 "" "" "" "")
	(setvar "textstyle" "lxy2")
     )
     (command "text" "j" "mc" textpt1 2.5 0 rep)
     (setq sel_ent (ssadd (entlast) sel_ent))
     (setvar "textstyle" st_old)
  )
;-----------------------------------------------------
;Make screw block and add extend data in it
;-----------------------------------------------------
  (mblk (strcat "AC_LXY_BLK" (itoa (getvar "useri2"))) pt sel_ent)
  (setq xd (strcat 	rep " " 		;item number
			"C" " " 		;view flag
			screw_type " " 		;dim diameter
			screw_len " " 		;dim length
			if_h_v " " 		;hidden flag
			"SET" " " 		;type flag
			mb " " 			;meter or inch flag
			(rtos ang 2 5) " "	;angle
        		(rtos l12 2 5)))	;thickness of 1st plate
  (setq xd (list (list -3 (list "screw" (cons 1000 xd)))))
  (mxdata  (entlast) xd)
  (setvar "useri2" (+ 1 (getvar "useri2")))
;------------------------------------------------------
;reset osnap mode
;------------------------------------------------------
  (setvar "osmode" os_old)
)
;*************************************** End of function ****************************************;