;****************************************;
;*this is scr_flat.lsp program		*;
;*completely complied in 12/13/98	*;
;*last changed in 02/03/99		*;
;*ZX Mold Ltd   XY.Liao			*;
;****************************************;
;********************************************************************************************************;
(defun scr_flat(/ ex_lb		m_b_lb		scr_m_n		scr_m_len	scr_b_n		if_h_v	
		d		hd		b		s		k		screw_len	
		screw_lenf	screw_type	flat_dcl)		
;---------------------------------------
;set undo mark
;---------------------------------------
  (command "undo" "m")
;---------------------------------------
;initializing
;---------------------------------------
  (setq ex_lb 1)
  (setq m_b_lb 0
	scr_m_n 0
	scr_m_len 0
	scr_b_n 0
	scr_b_len 0
	if_h_v "0"
  )
;---------------------------------------
;start dialog
;---------------------------------------
  (while (= 1 ex_lb) 
    (if (not (new_dialog "shfsdlg" screw_dcl))
	(exit)
    )
;---------------------------------------
;initializing dialog
;---------------------------------------
    (ini_dcl_v)
;---------------------------------------
;set dialog action
;---------------------------------------
    (action_tile "FLATM" "(setq m_b_lb 1) (ini_dcl_v)")
    (action_tile "FLATB" "(setq m_b_lb 0) (ini_dcl_v)")
    (action_tile "FLATTYP" "(typ_flat_act)")
    (action_tile "FLATLEN" "(len_flat_act)")
    (action_tile "HIDDENV" "(hid_ch)")
    (action_tile "cancel" "(done_dialog 0)")
    (action_tile "accept" "(done_dialog 1)")
    (action_tile "flat_z" "(get_all_v) (done_dialog 2)")
    (action_tile "flat_c" "(get_all_v) (done_dialog 3)")
    (action_tile "BACK" "(done_dialog 4)")
    (action_tile "LOOK" "(done_dialog 5)")
;---------------------------------------
;determine what to next
;---------------------------------------
    (setq what_next (start_dialog))
    (cond
;---------------------------------------
;cancel action and exit
;---------------------------------------
	((= 0 what_next)
	   (command "undo" "b")
	   (setq ex_lb 0)
	   (setq if_next 0)
	)
;---------------------------------------
;exit
;---------------------------------------
	((= 1 what_next)
	   (setq ex_lb 0)
	   (setq if_next 0)
	)
;---------------------------------------
;call "scr_cap_zst" to create top view
;---------------------------------------
	((= 2 what_next)
	   (scr_flat_zst)
	   (setq ex_lb 1)
	)
;---------------------------------------
;call "scr_cap_cst" to create section view
;---------------------------------------
	((= 3 what_next)
	   (scr_flat_cst)
	   (setq ex_lb 1)
	)
;---------------------------------------
;return to main dialog
;---------------------------------------
	((= 4 what_next)
	   (setq ex_lb 0)
	   (setq if_next 1)
	)
;---------------------------------------
;hidden dialog 
;---------------------------------------
	((= 5 what_next)
	   (look)
	   (setq ex_lb 1)
	)
    )
  )
)

;*************************************** End of function ****************************************;


;******************************** dialog control function group *********************************;
;---------------------------------------
;start image function
;---------------------------------------
(defun start_vs(/ pic_fn)
  (foreach pic_fn '("flat_z" "flat_c")
	(start_image pic_fn)
	(fill_image 0 0 (dimx_tile pic_fn) (dimy_tile pic_fn) 0)
	(end_image)
  )
  (foreach pic_fn '("flat_z" "flat_c")
	(start_image pic_fn)
	(slide_image 0 0 (dimx_tile pic_fn) (dimy_tile pic_fn) (strcat "ac_lxy(" pic_fn ")"))
	(end_image)
  )
)
(defun start_vs_h(/ pic_fn)
  (foreach pic_fn '("flat_z" "flat_c")
	(start_image pic_fn)
	(fill_image 0 0 (dimx_tile pic_fn) (dimy_tile pic_fn) 0)
	(end_image)
  )
  (foreach pic_fn '("flat_z" "flat_c")
	(start_image pic_fn)
	(slide_image 0 0 (dimx_tile pic_fn) (dimy_tile pic_fn) (strcat "ac_lxy(" pic_fn "_h)"))
	(end_image)
  )
)
;---------------------------------------
;initializing dialog function
;---------------------------------------
(defun ini_dcl_v()
  (cond 
     ((= 0 m_b_lb)
      (set_tile "FLATB" "1")
      (ini_list "FLATTYP" (scr_lib "SHFSB" "spec"))
      (ini_list "FLATLEN" (nth scr_b_n (scr_lib "SHFSB" "cl")))
      (set_tile "FLATTYP" (itoa scr_b_n))
      (set_tile "FLATLEN" (itoa scr_b_len))
      (setq screw_type (nth scr_b_n (scr_lib "SHFSB" "spec")))
      (setq screw_len (nth scr_b_len (nth scr_b_n (scr_lib "SHFSB" "cl"))))
      (setq screw_lenf (nth scr_b_len (nth scr_b_n (scr_lib "SHFSB" "cll"))))
      (setq d (nth scr_b_n (scr_lib "SHFSB" "d_ct")))
      (setq hd (nth scr_b_n (scr_lib "SHFSB" "d_ch")))
      (setq s (nth scr_b_n (scr_lib "SHFSB" "cs")))
      (setq k (nth scr_b_n (scr_lib "SHFSB" "ck")))
     )
     ((= 1 m_b_lb)
      (set_tile "FLATM" "1")
      (ini_list "FLATTYP" (scr_lib "SHFSM" "spec"))
      (ini_list "FLATLEN" (nth scr_m_n (scr_lib "SHFSM" "cl")))
      (set_tile "FLATTYP" (itoa scr_m_n))
      (set_tile "FLATLEN" (itoa scr_m_len))
      (setq screw_type (nth scr_m_n (scr_lib "SHFSM" "spec")))
      (setq screw_len (nth scr_m_len (nth scr_m_n (scr_lib "SHFSM" "cl"))))
      (setq screw_lenf (atof screw_len))
      (setq d (nth scr_m_n (scr_lib "SHFSM" "d_ct")))
      (setq hd (nth scr_m_n (scr_lib "SHFSM" "d_ch")))
      (setq s (nth scr_m_n (scr_lib "SHFSM" "cs")))
      (setq k (nth scr_m_n (scr_lib "SHFSM" "ck")))
     )
  )
  (set_tile "FLATSPEC" (strcat screw_type "X" screw_len))
  (set_tile "FLATITEM" (strcat "V" (itoa screw_i)))
  (set_tile "HIDDENV" if_h_v)
  (if (= "1" if_h_v)
     (start_vs_h)
     (start_vs)
  )
)
;---------------------------------------
;spec select action
;---------------------------------------
(defun typ_flat_act()
  (cond
     ((= 0 m_b_lb)
      (setq scr_b_n (atoi (get_tile "FLATTYP")))
      (ini_list "FLATLEN" (nth scr_b_n (scr_lib "SHFSB" "cl")))
      (setq screw_type (nth scr_b_n (scr_lib "SHFSB" "spec")))
      (if (not (xh_get screw_len (nth scr_b_n (scr_lib "SHFSB" "cl"))))
	(setq scr_b_len 0)
	(setq scr_b_len (xh_get screw_len (nth scr_b_n (scr_lib "SHFSB" "cl"))))
      )
      (set_tile "FLATLEN" (itoa scr_b_len))
      (setq screw_len (nth scr_b_len (nth scr_b_n (scr_lib "SHFSB" "cl"))))
      (setq screw_lenf (nth scr_b_len (nth scr_b_n (scr_lib "SHFSB" "cll"))))
      (setq d  (nth scr_b_n (scr_lib "SHFSB" "d_ct")))
      (setq hd (nth scr_b_n (scr_lib "SHFSB" "d_ch")))
      (setq s  (nth scr_b_n (scr_lib "SHFSB" "cs")))
      (setq k  (nth scr_b_n (scr_lib "SHFSB" "ck")))
     )
     ((= 1 m_b_lb)
      (setq scr_m_n (atoi (get_tile "FLATTYP")))
      (ini_list "FLATLEN" (nth scr_m_n (scr_lib "SHFSM" "cl")))
      (setq screw_type (nth scr_m_n (scr_lib "SHFSM" "spec")))
      (if (not (xh_get screw_len (nth scr_m_n (scr_lib "SHFSM" "cl"))))
	(setq scr_m_len 0)
	(setq scr_m_len (xh_get screw_len (nth scr_m_n (scr_lib "SHFSM" "cl"))))
      )
      (set_tile "FLATLEN" (itoa scr_m_len))
      (setq screw_len  (nth scr_m_len (nth scr_m_n (scr_lib "SHFSM" "cl"))))
      (setq screw_lenf (atof screw_len))
      (setq d  (nth scr_m_n (scr_lib "SHFSM" "d_ct")))
      (setq hd (nth scr_m_n (scr_lib "SHFSM" "d_ch")))
      (setq s  (nth scr_m_n (scr_lib "SHFSM" "cs")))
      (setq k  (nth scr_m_n (scr_lib "SHFSM" "ck")))
     )
  )
  (set_tile "FLATSPEC" (strcat screw_type "X" screw_len))
)
;---------------------------------------
;length select action 
;---------------------------------------
(defun len_flat_act()
  (cond
     ((= 0 m_b_lb)
      (setq scr_b_len (atoi (get_tile "FLATLEN")))
      (setq screw_len (nth scr_b_len (nth scr_b_n (scr_lib "SHFSB" "cl"))))
      (setq screw_lenf (nth scr_b_len (nth scr_b_n (scr_lib "SHFSB" "cll"))))
     )
     ((= 1 m_b_lb)
      (setq scr_m_len (atoi (get_tile "FLATLEN")))
      (setq screw_len (nth scr_m_len (nth scr_m_n (scr_lib "SHFSM" "cl"))))
      (setq screw_lenf (atof screw_len))
     )
  )
  (set_tile "FLATSPEC" (strcat screw_type "X" screw_len))
)
;---------------------------------------
;if draw screw in hidden select action
;---------------------------------------
(defun hid_ch()
  (setq if_h_v (get_tile "HIDDENV"))
  (if (= "1" if_h_v)
     (start_vs_h)
     (start_vs)
  )
)
;---------------------------------------
;get all parameter function
;---------------------------------------
(defun get_all_v()
  (setq rep (get_tile "FLATITEM"))
  (setq spec (get_tile "FLATSPEC"))
  (setq screw_i (atoi (substr rep 2)))
) 
;************************************ End of function group *************************************;

;************************************************************************************************;
(defun scr_flat_cst(/ pt1 		pt2 		ex_f 		mb		app_typ)
;-----------------------------------------------------
;calculate screw parameter and set mb flag
;-----------------------------------------------------
  (if (= 0 m_b_lb)
     (progn
	(setq d (* d 25.4))
	(setq hd (* hd 25.4))
	(setq l (* screw_lenf 25.4))
	(setq k (* k 25.4))
	(setq mb "B")
     )
     (progn
     	(setq l screw_lenf)
     	(setq mb "M")
     )
  )
;-----------------------------------------------------
;initializing
;-----------------------------------------------------
  (initget 32)
  (setq ex_f 1)
  (load "flat_cst")
;---------------------------------------
;begin to call INS_CST to create screw
;---------------------------------------
  (while (= 1 ex_f)
     (setq pt1 (getpoint "\nGet base point:"))
     (if pt1
        (setq pt2 (getpoint pt1 "\nGet second point:"))
     )
     (setvar "osmode" 0)
     (setq app_typ "NEW")
     (if (and pt1 pt2)
        (progn
          (setq pt (polar pt1 (angle pt1 pt2) 0.5))
          (flat_cst)
        )
	(setq ex_f 0)
     )
     (setvar "osmode" os_old)
  )
)
;*************************************** End of function ****************************************;


;********************************************************************************************************;
(defun scr_flat_zst(/ cenpt add_i)
;-----------------------------------------------------
;calculate screw parameter and set mb flag
;-----------------------------------------------------
  (if (= 0 m_b_lb)
     (progn
	(setq hd (* hd 25.4))
	(setq s (* s 25.4))
	(setq mb "B")
     )
     (setq mb "M")
  )
;-----------------------------------------------------
;Initializing
;-----------------------------------------------------
  (load "flat_zst")
;-----------------------------------------------------
;Call INS_ZST to create screw top view
;-----------------------------------------------------
  (while (setq cenpt (getpoint "\nGet center:"))
      (setvar "osmode" 0)
      (flat_zst)
      (setq add_i T)
      (setvar "osmode" os_old)
  )
;-----------------------------------------------------
;counter
;-----------------------------------------------------
  (if add_i
      (setq screw_i (+ screw_i 1))
  )
)
;*************************************** End of function ****************************************;

