(defun snew(/ lt_old	co_old		la_old		os_old		pw_old		st_old	
	      dim_old	if_next		screw_dcl	orgpt)
;----------------------------------------------------
;save old system variable
;----------------------------------------------------
  (setq lt_old (getvar "celtype"))
  (setq co_old (getvar "cecolor"))
  (setq dim_old (getvar "dimstyle"))
  (setq la_old (getvar "clayer"))
  (setq os_old (getvar "osmode"))
  (setq st_old (getvar "textstyle"))
  (setq pw_old (getvar "plinewid"))
  (setq orgpt (getvar "ucsorg"))
;---------------------------------------------------
;set application system variable
;---------------------------------------------------
  (setvar "cmdecho" 0)
  (load "screwlib")
  (if (not (tblsearch "layer" "screw"))
    (command "layer" "n" "screw" "c" "white" "screw" "l" "continuous" "screw" "")
    (command "_.layer" "thaw" "screw" "on" "screw" "unlock" "screw" "")
  )
  (setvar "clayer" "screw")
  (setvar "plinewid" 0)
;--------------------------------------------------
;initializing
;--------------------------------------------------
  (if (not (tblsearch "appid" "screw"))
    (regapp "screw")
  )
  (if (not screw_i)
    (setq screw_i 1)
  )
  (ini_useri2)
;-------------------------------------------------
;start dialog
;-------------------------------------------------
  (setq screw_dcl (load_dialog "screw.dcl"))
  (setq if_next 1)
  (while (= 1 if_next)
     (if (not (new_dialog "screwdlg" screw_dcl))
     	(exit)
     )
     (ini_screw)
     (action_tile "scr_cap" "(done_dialog 1)")
     (action_tile "scr_set" "(done_dialog 2)")
     (action_tile "scr_flat" "(done_dialog 3)")
     (action_tile "scr_other" "(done_dialog 4)")
     (action_tile "accept" "(done_dialog 5)")
     (setq screw_next (start_dialog))
     (cond
	((= 1 screw_next)
	 (load "scr_cap")
	 (scr_cap)
	)
	((= 2 screw_next)
	 (load "scr_set")
	 (scr_set)
	)
	((= 3 screw_next)
	 (load "scr_flat")
	 (scr_flat)
	)
	((= 5 screw_next)
	 (setq if_next 0)
	)
     )
  )
  (ac_lxy_set)
  (prin1)
)

(defun ini_screw(/ pic_fn)
  (foreach pic_fn '("scr_cap" "scr_set" "scr_flat" "scr_other")
	(start_image pic_fn)
	(slide_image 0 0 (dimx_tile pic_fn) (dimy_tile pic_fn) (strcat "ac_lxy(" pic_fn ")"))
	(end_image)
  )
)

(defun look()
  (command "zoom" "")
)
;------------------------------------------------------------------------------------;


