
(defun p_edit()
;---------------------------------------------------
;shut off command echo and set undo mark
;---------------------------------------------------
  (setvar "cmdecho" 0)
  (command "undo" "m")
;---------------------------------------------------
;Save current system variable
;---------------------------------------------------
  (setq os_old (getvar "osmode")
	la_old (getvar "clayer")
	lt_old (getvar "celtype")
	co_old (getvar "cecolor")
	pw_old (getvar "plinewid")
	or_old (getvar "orthomode")
	st_old (getvar "textstyle")
	bp_old (getvar "blipmode")
  )
;---------------------------------------------------
;Initializing
;---------------------------------------------------
  (ini_useri2)
  (setvar "plinewid" 0)
  (setvar "blipmode" 0)
  (setvar "celtype" "bylayer")
  (setvar "cecolor" "bylayer")
  (if (not (tblsearch "layer" "epin"))
    (command "layer" "_new" "epin" "_color" "green" "epin" "l" "continuous" "epin" "")
    (command "_.layer" "thaw" "epin" "on" "epin" "unlock" "epin" "")
  )
  (setvar "clayer" "epin")
  (setq pin_conlb 1)
  (regapp "pin")
  (load "epin_lib")
;--------------------------------------------------
;Get ejector pin
;--------------------------------------------------
  (setq INU T)
  (while INU
    (setq pin_ent (entsel))
    (if (not pin_ent)
      (setq pin_ent (entsel))
      (progn
        (setq pin_ent (car pin_ent))
        (if (assoc -3 (entget pin_ent '("pin")))
          (if (/= "pin" (car (cadr (assoc -3 (entget pin_ent '("pin"))))))
            (princ "\nIt is not a pin!\n")
	    (setq INU nil)
	  )
	)
      )
    )
  )
  (setq pin_data (cdr (cadr (cadr (assoc -3 (entget pin_ent '("pin")))))))
  (setq pin_data (strtolst pin_data))
  (progn
    (setq rep_old  (nth 0 pin_data)
	  mb       (nth 6 pin_data)
	  type_old (nth 2 pin_data)
	  len_old  (nth 3 pin_data)
	  zc       (nth 1 pin_data)
          if_h_v   (nth 4 pin_data)
          spec_old (strcat type_old "X" len_old)
    )
    (if (= "C" zc)
      (setq ang (atof (nth 7 pin_data)))
    )
    (setq chin "")
    (setq desc "EJECTOR PIN")
  )
;-----------------------------------------------
;start dialog
;-----------------------------------------------
  (setq dcl_id (load_dialog "pin.dcl"))
  (setq edit_next 1)
  (while (= 1 edit_next) 
    (if (not (new_dialog "pinedit" dcl_id))
      (exit)
    )
    (set_tile "rep" rep_old)
    (set_tile "chin" chin)
    (set_tile "desc" desc)
    (set_tile "cot" spec_old)
    (mode_tile "desc" 1)
    (mode_tile "chin" 1)
    (if err_msg
      (set_tile "MSG" err_msg)
    )
    (action_tile "accept" "(rep_get) (done_dialog 2)")
    (action_tile "E_DEL"  "(rep_get) (done_dialog 4)")
    (action_tile "rep"    "(setq rep_r  $reason) (valid_verify)")
    (action_tile "cot"    "(setq spec_r $reason) (valid_verify)")
    (action_tile "cancel" "(done_dialog 3)")
    (setq what_next (start_dialog))
    (cond
      ((= 2 what_next)
        (setq if_del_lb 0)
        (setq edit_next 0)
        (if (and (or rep_new spec_new)
	         (or (/= rep_old rep_new) (/= spec_old spec_new))
	         (not err_msg)
            )
          (if (= 1 if_all_lb)
            (progn
	      (princ "\nAnalyzing entity, Please wait a moment...")
              (setq all_set (ssget "X" '((0 . "INSERT") (-3 ("pin")))))
  	      (setq ent_count (sslength all_set))
  	      (setq i 0)
  	      (while (< i ent_count)
	        (setq ent_name (ssname all_set i))
	        (pin_modify ent_name)
	        (setq i (+ i 1))
	      )
            )
            (pin_modify pin_ent)
          )
          (setq edit_next 1)
        )
      )
      ((= 3 what_next)
        (setq edit_next 0)
      )
      ((= 4 what_next)
        (setq if_del_lb 1)
        (setq edit_next 0)
        (if (= 1 if_all_lb)
          (progn
	    (princ "\nAnalyzing entity, Please wait a moment...")
            (setq all_set (ssget "X" '((0 . "INSERT") (-3 ("pin")))))
  	    (setq ent_count (sslength all_set))
  	    (setq i 0)
  	    (while (< i ent_count)
	      (setq ent_name (ssname all_set i))
              (pin_del ent_name)
	      (setq i (+ i 1))
	    )
          )
          (pin_del pin_ent)
        )
      )
    )
  )
  (ac_lxy_set)
  (princ "done")
  (prin1)
)
;------------------------------------------------------------------------------------;	

;------------------------------------------------------------------------------------;	
(defun rep_get()
  (if (= "1" (get_tile "if_all"))
    (setq if_all_lb 1)
    (setq if_all_lb 0)
  )
) 


;------------------------------------------------------------------------------------;	
(defun pin_modify(ent_name / con_lb)
  (setq pin_data (cdr (cadr (cadr (assoc -3 (entget ent_name '("pin")))))))
  (setq pin_data (strtolst pin_data))
  (progn
     (setq rep      (nth 0 pin_data)
	   type_cur (nth 2 pin_data)
	   len      (nth 3 pin_data)
	   zc       (nth 1 pin_data)
           if_h_v   (nth 4 pin_data)
           spec     (strcat type_cur "X" len)
    )
    (if (= "C" zc)
      (setq ang    (atof (nth 7 pin_data))
	    li1    (atof (nth 8 pin_data))
	    li2    (atof (nth 9 pin_data))
      )
    )
    ;(setq  pt1   (wtou (cdr (assoc 10 (entget ent_name)))))
    (setq  pt1   (cdr (assoc 10 (entget ent_name))))
    (if (= -1.0 (cdr (assoc 41 (entget ent_name))))
      (progn
        (setq ang_mirr (cdr (assoc 50 (entget ent_name))))
        (setq ang_mirr (/ ang_mirr 2))
        (setq ang_mirr (+ ang_mirr (/ pi 2)))
        (if (<= pi ang_mirr)
          (setq ang_mirr (- ang_mirr pi))
        )
        (if (= "C" zc)
          (progn
	    (setq ang_mirr (- (- ang (* (fix (/ ang pi)) pi)) ang_mirr))
	    (setq ang (- ang (* 2 ang_mirr)))
          )
        )
      )
      (if (= "C" zc)
        (setq ang (+ ang (cdr (assoc 50 (entget ent_name)))))
      )
    )
    (if (= "C" zc)
      (progn
        (if (> ang (* pi 2))
          (setq ang (- ang (* pi 2)))
        )
        (if (< ang 0)
          (setq ang (+ ang (* 2 pi)))
        )
      )
    )
  )
  (if (= rep rep_old)
    (progn
      (if (/= spec spec_old)
        (progn
          (redraw ent_name 3)
          (command "zoom" "c" pt 50)
          (setq con_lb (yn  (strcat "ֲͬ" spec "! ?")))
	  (command "zoom" "p")
        )
        (setq con_lb 1)
      )
      (if (= 1 con_lb)
        (progn
          (entdel ent_name)
          (setq rep rep_new)
          (setq pin_app "OLD")
          (cond
	    ((= "C" zc)
              (load "pin_cst")
	      (pin_cst)
	    )
	    ((= "Z" zc)
              (setq cenpt pt1)
              (load "pin_zst")
              (pin_zst)
            )
          )
        ) 
      )
    )
  )
)

(defun pin_del(ent_name / con_lb)
  (setq pin_data (cdr (cadr (cadr (assoc -3 (entget ent_name '("pin")))))))
  (setq pin_data (strtolst pin_data))
  (progn
     (setq rep      (nth 0 pin_data)
	   type_cur (nth 2 pin_data)
	   len      (nth 3 pin_data)
	   zc       (nth 1 pin_data)
           if_h_v   (nth 4 pin_data)
           spec     (strcat type_cur "X" len)
    )
  )
  (if (= rep rep_old)
    (progn
      (if (/= spec spec_old)
        (progn
          (redraw ent_name 3)
          (command "zoom" "c" pt1 50)
          (setq con_lb (yn  (strcat "ֲͬ" spec "! ɾ?")))
          (command "zoom" "p")
        )
        (setq con_lb 1)
      )
      (if (= 1 con_lb)
        (entdel ent_name)
        (redraw ent_name 4)
      )
    )
  )
)



(defun valid_verify()
  (if (or (= 2 rep_r) (= 2 spec_r))
    (progn
;--------------------------------------------------
;Verify item number
;--------------------------------------------------
      (setq rep_new (lxy_trim (get_tile "rep")))
      (if (< 2 (strlen rep_new))
        (setq err_msg1 "Invalid item number!")
        (if (/= "P" (strcase (substr rep_new 1 1)))
          (setq err_msg1 "Invalid item number!")
          (if (= 0.0 (atof (substr rep_new 2)))
            (setq err_msg1 "Invalid item number!")
            (progn
              (setq rep_new (strcat "P" (itoa (fix (atof (substr rep_new 2))))))
              (set_tile "rep" rep_new)
	      (setq err_msg1 nil)
            )
          )
        )
      )
;---------------------------------------------------
;Verify ejector pin specification
;---------------------------------------------------
      (setq spec_new (lxy_trim (get_tile "cot")))
      (if (not (lxy_word spec_new "X"))
	(setq err_msg "Invalid ejector pin specification!")
        (progn
          (setq pin_type (substr spec_new 1 (- (lxy_word spec_new "X") 1))
	   	pin_len  (substr spec_new (+ (lxy_word spec_new "X") 1) (- (strlen spec_new) (lxy_word spec_new "X")))
    	  )
          (cond
            ((= "B" mb)
	      (setq n (xh_get pin_type (lib_ep 4)))
	      (if (not n)
	        (setq err_msg2 "Invalid ejector pin specification!")
                (progn
	          (setq d  (nth n (lib_ep 5))
	                hd (nth n (lib_ep 6))
	                b  (nth n (lib_ep 7))
                  )
                )
              )
            )
            ((= "M" mb)
	      (setq n (xh_get pin_type (lib_ep 4)))
	      (if (not n)
	        (setq err_msg2 "Invalid ejector pin specification!")
                (progn
	          (setq d  (atof (nth n (lib_ep 1)))
	                hd (nth n (lib_ep 2))
	                b  (nth n (lib_ep 3))
                  )
                )
              )
            )
          )
        )
      )
    )
  )
  (if err_msg1
    (progn 
      (mode_tile "rep" 2)
      (set_tile "MSG" err_msg1)
    )
    (if (not err_msg2)
      (set_tile "MSG" "")
      (progn 
        (mode_tile "spec" 2)
        (set_tile "MSG" err_msg2)
      )
    )
  )
)
