;*****************************************************;
;* This is "pin_cst.lsp" program 		     *;
;* Complete compiled in 02/25/99                     *;
;* Last change in 02/25/99    			     *;
;* ZX Mold Ltd  XY.Liao				     *;
;*****************************************************;
;****************************************Main function start********************************************;
(defun pin_cst(/ )
;npt1  		npt2  		npt3  		npt4  		npt5  
;		npt6  		npt7  		npt8		npt9  		npt10 
;		angv  		angvv 		angh  		int_pt1		
;		textpt1 	int_pt2     	npct1 		npct2 		tr_ent1		
;		tr_ent2		instpt  	sel_ent   	textpt2		textang		
;		textangv)

;------------------------------------------------
;calculate parameter
;------------------------------------------------
  (if (= "NEW" pin_app)
    (progn

      (setq pt2 (nth 1 ob_ent))
      (setq ang  (angle pt1 pt2))
      (if ang_auto
        (cond
          ((and (<= 0 ang) (> (* pi 0.25) ang))
            (setq ang 0)
          )
          ((and (<= (* pi 0.25) ang) (> (* pi 0.75) ang))
            (setq ang (* pi 0.5))
          )
          ((and (<= (* pi 0.75) ang) (> (* pi 1.25) ang))
            (setq ang pi)
          )
          ((and (<= (* pi 1.25) ang) (> (* pi 1.75) ang))
            (setq ang (* pi 1.5))
          )
          ((and (<= (* pi 1.75) ang) (> (* pi 2.0) ang))
            (setq ang 0)
          )
        )
        (setq ang (* (/ pin_ang 180) pi))
      )
    )
  )
  (setq angv  (+ ang (/ pi 2)))
  (setq angvv (- ang (/ pi 2)))
  (setq angh  (+ ang pi))
(print "xxx")
;------------------------------------------------
;calculate parameter
;------------------------------------------------
  (setq npt3  (polar pt1 angv (/ hd 2.0))
	npt4  (polar pt1 angvv (/ hd 2.0))
	npt6  (polar npt3 ang b)
	npt7  (polar npt6 angvv (/ (- hd d) 2))
	npt8  (polar npt7 angvv d)
	npt9  (polar npt4 ang b)
  )
  (setq npt1  (polar npt3 angv 0.5)
	npt2  (polar npt4 angvv 0.5)
	npt5  (polar npt1 ang b)
	npt10 (polar npt2 ang b)
  )
  (setq tempt1 (polar npt7 ang 1)
	tempt2 (polar npt8 ang 1)
  )
	(print "sss")
	(print tempt1)
	(print "cc")
;-----------------------------------------------
;Get intersect points ordinate
;-----------------------------------------------
  (if (= "NEW" pin_app)
    (setq int_pt1 (pline_int npt7 tempt1 (car ob_ent) (cdr ob_ent))
  	  int_pt2 (pline_int npt8 tempt2 (car ob_ent) (cdr ob_ent))		
    ) 

    (setq int_pt1 (polar npt7 ang (- li1 b))
	  int_pt2 (polar npt8 ang (- li2 b))		
    )
  )
  (if (not (and int_pt1 int_pt2))
    (setq err_msg2 "Ejector pin don't intersect entity you selected!")
    (progn
      (if (listp (car int_pt1))
        (if (> (distance (cadr ob_ent) (car int_pt1))
	       (distance (cadr ob_ent) (cadr int_pt1))
            )
          (setq int_pt1 (cadr int_pt1))
          (setq int_pt1 (car int_pt1))
        )
      )
      (if (listp (car int_pt2))
        (if (> (distance (cadr ob_ent) (car int_pt2))
	       (distance (cadr ob_ent) (cadr int_pt2))
            )
          (setq int_pt2 (cadr int_pt2))
          (setq int_pt2 (car int_pt2))
        )
      )
      (setq li1 (distance npt8 int_pt1)
	    li2 (distance npt9 int_pt2)
      )
      (setq l (if (> li1 li2) li1 li2)
	    l (+ l b)
      )
      (if (> l 700)
        (setq err_msg2 "Exceed max ejector pin length!")
      )
      (setq ncpt1 (polar pt1 angh 1))
      (setq ncpt2 (polar pt1 ang (+ l 1)))
    )
  )
  (if (not err_msg2)
    (progn 
;-------------------------------------------------
;Round l as a standard ejector pin length
;-------------------------------------------------
		
      (cond
	((= "M" mb)
	  (cond 
	    ((>= 100 l)
	      (setq len "100")
	    )
	    ((and (>= 150 l) (< 100 l))
	      (setq len "150")
	    )
	    ((and (>= 200 l) (< 150 l))
	      (setq len "200")
	    )
	    ((and (>= 250 l) (< 200 l))
	      (setq len "250")
	    )
	    ((and (>= 300 l) (< 250 l))
	      (setq len "300")
	    )
	    ((and (>= 350 l) (< 300 l))
	      (setq len "350")
	    )  
	    ((and (>= 400 l) (< 350 l))
	      (setq len "400")
	    )  
	    ((and (>= 450 l) (< 400 l))
	      (setq len "450")
	    )  
	    ((and (>= 500 l) (< 450 l))
	      (setq len "500")
	    )  
	    ((and (>= 550 l) (< 500 l))
	      (setq len "550")
	    )  
	    ((and (>= 600 l) (< 550 l))
	      (setq len "600")
	    )  
	    ((and (>= 650 l) (< 600 l))
	      (setq len "650")
	    )  
	    ((and (>= 700 l) (< 650 l))
	      (setq len "700")
	    )
	  )
	)
	((= "B" mb)
	  (cond 
	    ((>= 101.6 l)
	      (setq len "4\"")
	    )
	    ((and (>= 152.4 l) (< 101.6 l))
	      (setq len "6\"")
	    )
	    ((and (>= 203.2 l) (< 152.4 l))
	      (setq len "8\"")
	    )
	    ((and (>= 254 l) (< 203.2 l))
	      (setq len "10\"")
	    )
	    ((and (>= 304.8 l) (< 254 l))
	      (setq len "12\"")
	    )
	    ((and (>= 355.6 l) (< 304.8 l))
	      (setq len "14\"")
	    )
	    ((and (>= 406.4 l) (< 355.6 l))
	      (setq len "16\"")
	    )
	    ((and (>= 457.2 l) (< 406.4 l))
	      (setq len "18\"")
	    )
	    ((and (>= 508 l) (< 457.4 l))
	      (setq len "20\"")
	    )
	    ((and (>= 558.8 l) (< 508 l))
	      (setq len "22\"")
	    )
	    ((and (>= 609.6 l) (< 558.8 l))
	      (setq len "24\"")
	    )
	    ((and (>= 660.4 l) (< 609.6 l))
	      (setq len "26\"")
	    )
	    ((and (>= 711.2 l) (< 660.4 l))
	      (setq len "28\"")
	    )
	  )
	)
      )
;---------------------------------------------------
;Draw pin entitis and c'bore
;---------------------------------------------------
      (if (= "1" if_h_v)
        (progn
     	  (command "linetype" "s" "hidden" "")
	  (setvar "cecolor" "yellow")
        )
      )
      (setvar "osmode" 0)
      (progn
        (setq sel_ent (ssadd))
        (command "pline" npt3 npt4 npt9 npt6 "C") 
        (setq sel_ent (ssadd (entlast) sel_ent))
        (command "pline" npt7 int_pt1 "")
        (setq sel_ent (ssadd (entlast) sel_ent))
        (command "pline" npt8 int_pt2 "")
        (setq sel_ent (ssadd (entlast) sel_ent))
      )
      (progn
        (command "pline" npt1 npt5 npt10 npt2 "")
        ;(setq sel_ent (ssadd (entlast) sel_ent))
      )
;--------------------------------------------------
;get correct epin specification
;--------------------------------------------------
      (setq spec (strcat "%%C" pin_type "X" len))
;--------------------------------------------------
;get center line points and text locate points
;--------------------------------------------------
      (setq textpt1 (polar pt1 angh (+ 2 (abs (* 1.77 (cos (- (/ pi 4) ang)))))))
;-----------------------------------------------------
;Draw center line
;-----------------------------------------------------
      (progn 
        (command "linetype" "s" "center" "")
        (setvar "cecolor" "red")
        (command "line" ncpt1 ncpt2 "")
        ;(setq sel_ent (ssadd (entlast) sel_ent))
        (setvar "celtype" "bylayer")
        (setvar "cecolor" "bylayer")
      )
;-----------------------------------------------------
;Dim specification and item number
;-----------------------------------------------------
      (progn
        (if (not (tblsearch "style" "lxy2"))
	  (command "-style" "lxy2" "txt" "" 0.6 "" "" "" "")
	  (setvar "textstyle" "lxy2")
        )
        (command "text" "j" "mc" textpt1 2.5 0 rep)
        (setq sel_ent (ssadd (entlast) sel_ent))
        (setvar "textstyle" st_old)
      )
;-----------------------------------------------------
;Make screw block and add extend data in it
;-----------------------------------------------------
      (mblk (strcat "AC_LXY_BLK" (itoa (getvar "useri2"))) pt1 sel_ent)
      (setq xd (strcat 	rep " " 			;item number
			"C" " " 			;view flag
			pin_type " " 			;dim diameter
			len " " 			;dim length
			if_h_v " " 			;hidden flag
			"0" " " 			;type flag
			mb " " 				;meter or inch flag
			(rtos ang 2 5) " "		;angle
			(rtos (+ b li1) 2 5) " "		;int_pt1
			(rtos (+ b li2) 2 5)))		;int_pt2
      (setq xd (list (list -3 (list "pin" (cons 1000 xd)))))
      (mxdata  (entlast) xd)
      (setvar "useri2" (+ 1 (getvar "useri2")))
      (setvar "osmode" os_old)
      (setq err_msg2 nil)
    )
  )
)
;*************************************** End of function ****************************************;