;****************************************;
;*this is MoldCapZ.lsp program		*;
;*completely complied in 12/13/98	*;
;*last changed in 02/03/99		*;
;*ZX Mold Ltd   XY.Liao			*;
;****************************************;
;********************************************************************************************************;
(defun MoldCapZ(scrD		cenpt		if_h_v	/ 	cenpt1 		cenpt2
 		cenpt3 		cenpt4 		ent_no		sel_ent		scr_m_n)
  (load "screwlib")
  (setq scr_m_n (xh_get scrD (scr_lib "SHCSM" "spec")))
  (setq hd (nth scr_m_n (scr_lib "SHCSM" "d_ch")))
  (setq s (nth scr_m_n (scr_lib "SHCSM" "cs")))
;-----------------------------------------------------
;calculate center line points ordinate
;-----------------------------------------------------
  (setq cenpt1 (polar cenpt 0 (+ (/ hd 2) 2)))
  (setq cenpt2 (polar cenpt pi (+ (/ hd 2) 2)))
  (setq cenpt3 (polar cenpt (/ pi 2) (+ (/ hd 2) 2)))
  (setq cenpt4 (polar cenpt (* pi 1.5) (+ (/ hd 2) 2)))
;-----------------------------------------------------
;if hidden then set current linetype as hidden
;-----------------------------------------------------
  (if (= if_h_v "1")
    (progn
      (command "linetype" "s" "hidden" "")
      (setvar "cecolor" "yellow")
    )
  )
;-----------------------------------------------------
;Draw screw top view and center line
;-----------------------------------------------------
  (setvar "osmode" 0)
  (progn
    (setq sel_ent (ssadd))
    (command "polygon" "6" cenpt "c" (/ s 2))
    (setq sel_ent (ssadd (entlast) sel_ent))
    (command "circle" cenpt (/ hd 2))
    (setq sel_ent (ssadd (entlast) sel_ent))
  )
  (progn 
    (command "linetype" "s" "center" "")
    (setvar "cecolor" "red")
    (command "line" cenpt1 cenpt2 "")
    (setq sel_ent (ssadd (entlast) sel_ent))
    (command "line" cenpt3 cenpt4 "")
    (setq sel_ent (ssadd (entlast) sel_ent))
    (setvar "celtype" "bylayer")
    (setvar "cecolor" "bylayer")
  )
;-----------------------------------------------------
;Make Block
;-----------------------------------------------------
  (mblk (strcat "AC_LXY_BLK" (itoa (getvar "useri2"))) cenpt sel_ent)
  (setvar "useri2" (+ 1 (getvar "useri2")))
)
;***************************************** End of function **************************************;