;****************************************;
;*this is MoldBase.lsp program		*;
;*completely complied in 03/30/99	*;
;*last changed in 04/01/99		*;
;*ZX Mold Ltd   XY.Liao			*;
;****************************************;
;*******************************************************************************************************;



(defun MoldSys(/ IfExitMoldSys	MoldSysNext MoldSysLstItem)

;---------------------------------------------
;Shut off command echo and setq Undo Mark
;---------------------------------------------
  (setvar "cmdecho" 0)
  (command "undo" "m")
;---------------------------------------------
;Initializing layer
;---------------------------------------------
  (load "ini_lay")
  (IniLayer)
  (IniStyle)
  (IniDimStyle)
;---------------------------------------------
;Save old system variable
;---------------------------------------------
  (setq os_old (getvar "osmode")
	la_old (getvar "clayer")
	co_old (getvar "cecolor")
	lt_old (getvar "celtype")
	pw_old (getvar "plinewid")
        st_old (getvar "textstyle")
  )
;--------------------------------------------
;defun Mold Base system library
;--------------------------------------------
  (setq MoldSysLib '("1. Side Gate System" "2. Three Plate Type System" "3. Pin Point Gate System"))
;--------------------------------------------
;Initialize MoldSysNum as "SG"
;--------------------------------------------
  (setq IfExitMoldSys T)
  (setq MoldSysLstItem "0")
;--------------------------------------------
;Start dialog
;--------------------------------------------
  (setq MoldDclId (load_dialog "MoldBase.dcl"))
  (while (= IfExitMoldSys T)
    (if (not (new_dialog "mold1" MoldDclId))
      (exit)
    )
    (ini_list "MoldSysLst" MoldSysLib)
    (if MoldSysLstItem
      (progn
        (set_tile "MoldSysLst" MoldSysLstItem)
        (msLst_Click)
      )      
    ) 
    (action_tile "MoldSysLst" "(msLst_Click)")



;*************************************************
    (setq MoldSysNext (start_dialog))
    (cond
      ((= 1 MoldSysNext)
      ;-------------------------------------
      ;select "Next"
      ;-------------------------------------
        (cond
          ((= "0" MoldSysLstItem)
            (setq MoldSysNum "SG")
            (MoldTypeSG)
          ) 
          ((= "1" MoldSysLstItem)
            (setq MoldSysNum "TP")
            (MoldTypeTP)
          ) 
          ((= "2" MoldSysLstItem)
            (setq MoldSysNum "PP")
            (MoldTypePP)
          )
        )
      )
      ((= 0 MoldSysNext)
      ;-------------------------------------
      ;select "Exit"
      ;-------------------------------------
        (setq IfExitMoldSys nil)
      )
    )
  )
  (unload_dialog MoldDclId)
(ac_lxy_set)
  (prin1)
)

;-------------------------------------------
;Do action when click on Mold system List
;-------------------------------------------
(defun msLst_Click()
  ;----------------------------------------------
  ;Defun local function
  ;----------------------------------------------
  (defun ShowImage(ImageName)
    (start_image "MoldSysView")
    (fill_image 0 0 (dimx_tile "MoldSysView") (dimy_tile "MoldSysView") 0)
    (slide_image 0 0 (dimx_tile "MoldSysView") (dimy_tile "MoldSysView") (strcat "MoldBase(" ImageName ")"))
    (end_image)
  )
  ;-------------------------------------------
  (setq MoldSysLstItem (get_tile "MoldSysLst"))
  (cond 
    ((= "0" MoldSysLstItem)
      (ShowImage "SideGate")
    )
    ((= "1" MoldSysLstItem)
      (ShowImage "3thPlate")
    )
    ((= "2" MoldSysLstItem)
      (ShowImage "PinPoint")
    )
  )
)

;********************************************************************************************************
;%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
;Get Side Gate System Mold Base Type Function
;%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
(defun MoldTypeSG( / LastView		CurView 	IfExitMoldType		ImageLst)

;--------------------------------------------------------
;Initialize Image list and set MoldTypeNum as "AI" first 
;--------------------------------------------------------
  (setq ImageLst '("AIV" "AHV" "ATV" "BIV" "BHV" "BTV" "CIV" "CHV" "CTV" "DIV" "DHV" "DTV"))
  (setq CurView 1)
;-------------------------------------
;Start dialog
;-------------------------------------
  (setq IfExitMoldType T)
  (while IfExitMoldType
    (if (not (new_dialog "mold21" MoldDclId))
      (exit)
    )
    (IniImage)
    (setq LastView nil)
    (Click CurView)
    (action_tile "AI" "(setq CurView 1) (Click CurView)")
    (action_tile "AH" "(setq CurView 2) (Click CurView)")
    (action_tile "AT" "(setq CurView 3) (Click CurView)")
    (action_tile "BI" "(setq CurView 4) (Click CurView)")
    (action_tile "BH" "(setq CurView 5) (Click CurView)")
    (action_tile "BT" "(setq CurView 6) (Click CurView)")
    (action_tile "CI" "(setq CurView 7) (Click CurView)")
    (action_tile "CH" "(setq CurView 8) (Click CurView)")
    (action_tile "CT" "(setq CurView 9) (Click CurView)")
    (action_tile "DI" "(setq CurView 10) (Click CurView)")
    (action_tile "DH" "(setq CurView 11) (Click CurView)")
    (action_tile "DT" "(setq CurView 12) (Click CurView)")
    (action_tile "back21" "(done_dialog 2)")
    (setq MoldTypeNext (start_dialog))
    (cond 
      ((= 0 MoldTypeNext)
      ;-------------------------------------------
      ;Select "Exit" and exit Program
      ;----------------------------- -------------
	(setq IfExitMoldType nil)
	(setq IfExitMoldSys nil)
      )
      ((= 1 MoldTypeNext)
      ;-------------------------------------------
      ;Select "Next" and call "MoldSpec" Function
      ;-------------------------------------------
	(MoldSpec)
      )
      ((= 2 MoldTypeNext)
      ;-------------------------------------------
      ;Select "Back" and go back "MoldSys" Function
      ;-------------------------------------------
	(setq IfExitMoldType nil)
      )
    )
  )
)

;%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
;Get Three Plate Type System Mold Base Type Function
;%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
(defun MoldTypeTP( / LastView		CurView 	IfExitMoldType		ImageLst)
;----------------------------------------------------------
;Initialize Image list and set "MoldTypeNum" as "FAI" first
;----------------------------------------------------------
  (setq ImageLst '("FAIV" "FCIV" "GAIV" "GCIV" "FAHV" "FCHV" "GAHV" "GCHV"))
  (setq CurView 1)
;----------------------------
;Start dialog
;----------------------------
  (setq IfExitMoldType T)
  (while IfExitMoldType
    (if (not (new_dialog "mold22" MoldDclId))
      (exit)
    )
    (IniImage)
    (setq LastView nil)
    (Click CurView)
    (action_tile "FAI" "(setq CurView 1) (Click CurView)")
    (action_tile "FCI" "(setq CurView 2) (Click CurView)")
    (action_tile "GAI" "(setq CurView 3) (Click CurView)")
    (action_tile "GCI" "(setq CurView 4) (Click CurView)")
    (action_tile "FAH" "(setq CurView 5) (Click CurView)")
    (action_tile "FCH" "(setq CurView 6) (Click CurView)")
    (action_tile "GAH" "(setq CurView 7) (Click CurView)")
    (action_tile "GCH" "(setq CurView 8) (Click CurView)")
    (action_tile "back21" "(done_dialog 2)")
    (setq MoldTypeNext (start_dialog))
    (cond 
      ((= 0 MoldTypeNext)
      ;--------------------------------------------
      ;Select "Exit" and exit program
      ;--------------------------------------------
	(setq IfExitMoldType nil)
	(setq IfExitMoldSys nil)
      )
      ((= 1 MoldTypeNext)
      ;--------------------------------------------
      ;Select "Next" and Call "MoldSpec" function
      ;--------------------------------------------
	(MoldSpec)
      )
      ((= 2 MoldTypeNext)
      ;-----------------------------------------------
      ;Select "Back" and go back to "MoldSys" function
      ;-----------------------------------------------
	(setq IfExitMoldType nil)
      )
    )
  )
)

;%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
;Get Pin Point Gate System Mold Base Type Function
;%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
(defun MoldTypePP( / LastView		CurView 	IfExitMoldType		ImageLst)
;----------------------------------------------------------
;Initialize Image list and set "MoldTypeNum" as "FAI" first
;----------------------------------------------------------
  (setq ImageLst '("DAIV" "DBIV" "DCIV" "DDIV" "EAIV" "EBIV" "ECIV" "EDIV"))
  (setq CurView 1)
;-----------------------------------
;Start dialog
;-----------------------------------
  (setq IfExitMoldType T)
  (while IfExitMoldType
    (if (not (new_dialog "mold23" MoldDclId))
      (exit)
    )
    (IniImage)
    (setq LastView nil)
    (Click CurView)
    (action_tile "DAI" "(setq CurView 1) (Click CurView)")
    (action_tile "DBI" "(setq CurView 2) (Click CurView)")
    (action_tile "DCI" "(setq CurView 3) (Click CurView)")
    (action_tile "DDI" "(setq CurView 4) (Click CurView)")
    (action_tile "EAI" "(setq CurView 5) (Click CurView)")
    (action_tile "EBI" "(setq CurView 6) (Click CurView)")
    (action_tile "ECI" "(setq CurView 7) (Click CurView)")
    (action_tile "EDI" "(setq CurView 8) (Click CurView)")
    (action_tile "back21" "(done_dialog 2)")
    (setq MoldTypeNext (start_dialog))
    (cond 
      ((= 0 MoldTypeNext)
	(setq IfExitMoldType nil)
	(setq IfExitMoldSys nil)
      )
      ((= 1 MoldTypeNext)
	(MoldSpec)
      )
      ((= 2 MoldTypeNext)
	(setq IfExitMoldType nil)
      )
    )
  )
)

(defun IniImage()
  (foreach Image ImageLst
    (progn
      (start_image Image)
      (slide_image 0 0 (dimx_tile Image) (dimy_tile Image) (strcat "MoldBase(" Image ")"))
      (end_image)
    )
  )
)

(defun Click(ViewNumber / ViewTemp)
  ;--------------------------------
  ;Defun Local Function
  ;--------------------------------
  (defun ImageHighLight(Image)
    (if (/= LastView Image)
      (progn 
        (mode_tile Image 4)
        (if LastView
          (mode_tile LastView 4)
        )
        (setq LastView Image)
      )
    )
  )
  ;--------------------------------
  (setq ViewTemp (nth (- CurView 1) ImageLst))
  (setq MoldTypeNum (substr ViewTemp 1 (- (strlen ViewTemp) 1)))
  (ImageHighLight ViewTemp)
)
;********************************************************************************************************;

(defun MoldSpec(/ IfExitMoldSpec MoldSpecNext /*MoldSpecNum*/);	aPThk	bPThk	sbPThk	tpZ	tpX	tpY
			;sbX	sbY	sbZ	cpX	cpY	scr1X	scr1Y	scr1Num	scr1D	scr2X	scr2Y
			;scr2Num	scr2D	scr3X	scr3Y	scr3Y2	scr2Num	scr2D	gpnX	gpnY	gpnNum	gpnD
			;rpnX	rpnY	rpnNum	rpnD	bpZ	stZ	spZ	rpZ	erpZ	epZ	bpZ
			;epX	epY	TapHaD	TapHaI	TapHaL	TapHbD	TapHbI	TapHbL	tpZ	IfRpnNew
			;IfAddSpg	mb	SpgHolDep)
  (setq IfExitMoldSpec T)
  (while IfExitMoldSpec
    (if (not (new_dialog "mold3" MoldDclId))
      (exit)
    )
    (mode_tile "SpecSel" 2)
    (IniMoldSpec)
    (action_tile "SpecSel"    "(MoldSpecSel MoldSysNum)")
    (action_tile "aPlateSel"  "(PlateThkSel 1)")
    (action_tile "bPlateSel"  "(PlateThkSel 2)")
    (action_tile "sbPlateSel" "(PlateThkSel 3)")
    (action_tile "SpecValue"  "(setq SpecValidNum $reason) (SpecVerify)")
    (action_tile "aPlateThk"  "(setq aPTValidNum $reason)  (PTVerify 1)")
    (action_tile "bPlateThk"  "(setq bPTValidNum $reason)  (PTVerify 2)")
    (action_tile "sbPlateThk" "(setq sbPTValidNum $reason) (PTVerify 3)")
    (action_tile "option"     "(ResetRpn)")
    (action_tile "back32"     "(done_dialog 2)")
    (setq MoldSpecNext (start_dialog))
    (cond 
      ((= 0 MoldSpecNext)
        (setq IfExitMoldSpec nil)
        (setq IfExitMoldType nil)
        (setq IfExitMoldSys nil)
      )
      ((= 1 MoldSpecNext)
        (if (and MoldSpecNum aPThk bPThk sbPThk)
	  (progn
	    (setTapHoldSpec)
            (MoldPosition)
          )
        )
      )
      ((= 2 MoldSpecNext)
        (setq IfExitMoldSpec nil)
      )
    )
  )
)

(defun IniMoldSpec()
  (if MoldSpecNum
    (progn
      (set_tile "SpecValue" MoldSpecNum)
      (if erpZ
        (set_tile "erp" (itoa erpZ))
      )
      (if epZ
        (set_tile "ep"  (itoa epZ))
      )
      (if tpZ
        (set_tile "tp"  (itoa tpZ))
      )
      (if bpZ
        (set_tile "bp"  (itoa bpZ))
      )
      (if rpZ
        (set_tile "rp"  (itoa rpZ))
      )
      (if spZ
        (set_tile "sp"  (itoa spZ))
      )
      (if stZ
        (set_tile "st"  (itoa stZ))
      )
    )
    (mode_tile "option" 1)
  )
  (if aPThk
    (set_tile "aPlateThk" (itoa aPThk))
  )
  (if bPThk
    (set_tile "bPlateThk" (itoa bPThk))
  )
  (if sbPThk
    (set_tile "sbPlateThk" (itoa sbPThk))
  )
  (if (not (and MoldSpecNum aPThk bPThk sbPThk))
    (mode_tile "next34" 1)
  )
)



(defun MoldSpecSel(SysVar / SpecLst MoldSpecItem)
;-------------------------------------------
;Defun Mold Base Specification list
;-------------------------------------------
  (setq SGSpecLst '("1515" "1520" "1525" "1820" "1823" "1825" "2020" "2023" "2025" "2030" "2035" "2330" "2335"
	            "2525" "2527" "2530" "2535" "2540" "2550" "2730" "2735" "2740" "3030" "3035" "3040" "3045"
	            "3050" "3060" "3535" "3540" "3545" "3550" "3560" "3570" "4040" "4045" "4050" "4055" "4060"
	            "4070" "4545" "4550" "4555" "4560" "4570" "5050" "5055" "5060" "5070" "5555" "5560" "5565"
		    "5570" "6060" "6065" "6070" "6075" "6080"))
  (setq TPSpecLst '("1520" "1525" "1820" "1823" "1825" "2020" "2023" "2025" "2030" "2035" "2330" "2335" "2525" 
	            "2527" "2530" "2535" "2540" "2550" "2730" "2735" "2740" "3030" "3035" "3040"))
  (setq PPSpecLst '("2025" "2030" "2035" "2330" "2335" "2525" "2527" "2530" "2535" "2540" "2550" "2730" "2735"
		    "2740" "3030" "3035" "3040" "3045" "3050" "3060" "3535" "3540" "3545" "3550" "3560" "3570"
	            "4040" "4045" "4050" "4055" "4060" "4070" "4545" "4550" "4555" "4560" "4570" "5050" "5055"
		    "5060" "5070"))
  (if (not (new_dialog "mold31" MoldDclId))
    (exit)
  )
  (cond
    ((= "SG" MoldSysNum)
      (ini_list "MoldSpecLst" SGSpecLst)
    )
    ((= "TP" MoldSysNum)
      (ini_list "MoldSpecLst" TPSpecLst)
    )
    ((= "PP" MoldSysNum)
      (ini_list "MoldSpecLst" PPSpecLst)
    )
  )
  (action_tile "MoldSpecLst" "(setMoldSpec)")
  (action_tile "accept" "(exitMoldLst)")
;**************************************************OK(ABOVE)
  (start_dialog)
;**************************************************OK(ABOVE)
  (getMoldBaseData)
  (if (and MoldSpecNum aPThk bPThk sbPThk)
    (progn
      (mode_tile "next34" 0)
      (mode_tile "next34" 2)
    )
  )
)


;*************OK******START
(defun setMoldSpec()
  (setq MoldSpecItem (get_tile "MoldSpecLst"))
  (cond
    ((= "SG" MoldSysNum)
      (setq MoldSpecNum (nth (atoi MoldSpecItem) SGSpecLst))
	(set_tile "MoldSpecValue" (strcat "You select: SG" MoldSpecNum))
    )
    ((= "TP" MoldSysNum)
      (setq MoldSpecNum (nth (atoi MoldSpecItem) TPSpecLst))
	(set_tile "MoldSpecValue" (strcat "You select: TP" MoldSpecNum))
    )
    ((= "PP" MoldSysNum)
      (setq MoldSpecNum (nth (atoi MoldSpecItem) PPSpecLst))
	(set_tile "MoldSpecValue" (strcat "You select: PP" MoldSpecNum))
    )
  )
  ;(set_tile "MoldSpecValue" (strcat "You select: " MoldSpecNum))
  (mode_tile "accept" 2)
)
;*************OK******END

;*************OK******START
(defun exitMoldLst()
  (if (not MoldSpecItem)
    (set_tile "MSG" "You did not select any item!")
    (done_dialog)
  )
)
;*************OK******END
;*****eg / TempData fn /*MoldBaseData/* err_msg***
(defun getMoldBaseData()
  (setq fn (open (findfile "MoldBase.lib") "r"))
  (setq MoldSysSpec (read (strcat MoldSysNum MoldSpecNum)))
  (setq aa MoldSysSpec)
  (setq MoldBaseData (read (read-line fn)))
  (while (and (/= MoldSysSpec (car MoldBaseData)) MoldBaseData)
    (if (setq TempData (read-line fn))
      (setq MoldBaseData (read TempData))
      (setq MoldBaseData nil)
    )
  )
  (close fn)
  (if (not MoldBaseData)
    (setq err_msg "Invalid!")
    (progn
      (setq MoldBaseData (cadr MoldBaseData))
      (setq TempData (assoc 'PT MoldBaseData))
      (setq cpX  (car  (nth 1 TempData))
	    cpY  (cadr (nth 1 TempData))
	    tpX  (car  (nth 2 TempData))
	    tpY  (cadr (nth 2 TempData))
	    sbX1 (car  (nth 3 TempData))
	    sbX2 cpx
	    sbY  (cadr (nth 3 TempData))
	    epX  (car  (nth 4 TempData))
	    epY  (cadr (nth 4 TempData))
      )
      (setq TempData (assoc 'PLATE MoldBaseData))
      (setq erpZ (cadr (nth 1 TempData))
	    epZ  (cadr (nth 2 TempData))
	    tpZ  (cadr (nth 3 TempData))
	    bpZ  (cadr (nth 4 TempData))
	    rpZ  (cadr (nth 5 TempData))
	    stZ  (cadr (nth 6 TempData))
	    spZ  (cadr (nth 7 TempData))
      )
      (setq TempData (assoc 'PIN MoldBaseData))
      (setq gpnD    (nth 1 (nth 1 TempData))
	    gpnNum  (nth 2 (nth 1 TempData))
	    gpnX    (car  (nth 3 (nth 1 TempData)))
	    gpnY    (cadr (nth 3 (nth 1 TempData)))
 	    rpnD    (nth 1 (nth 2 TempData))
	    rpnNum  (nth 2 (nth 2 TempData))
	    rpnX    (car  (nth 3 (nth 2 TempData)))
	    rpnY    (cadr (nth 3 (nth 2 TempData)))
      )
      (if (= "PP" MoldSysNum)
        (setq spnD   (nth 1 (nth 3 TempData))
	      spnNum (nth 2 (nth 3 TempData))
	      spnX   (car  (nth 3 (nth 3 TempData)))
	      spnY   (cadr (nth 3 (nth 3 TempData)))
        )
      )
      (setq TempData (assoc 'SCREW MoldBaseData))
      (setq scr1D    (nth 0 (nth 1 TempData))
	    scr1Num  (nth 1 (nth 1 TempData))
	    scr1X    (car  (nth 2 (nth 1 TempData)))
	    scr1Y    (cadr (nth 2 (nth 1 TempData)))
 	    scr2D    (nth 0 (nth 2 TempData))
	    scr2Num  (nth 1 (nth 2 TempData))
	    scr2X    (car  (nth 2 (nth 2 TempData)))
	    scr2Y    (cadr (nth 2 (nth 2 TempData)))
 	    scr3D    (nth 0 (nth 3 TempData))
	    scr3Num  (nth 1 (nth 3 TempData))
	    scr3X    (car  (nth 2 (nth 3 TempData)))
	    scr3Y    (cadr (nth 2 (nth 3 TempData)))
      )
      (if (= 16 scr3Num)
        (setq scr3Y2 (caddr (nth 2 (nth 3 TempData))))
      )
    )
  )
  (if (not err_msg)
    (progn
      (cond
        ((= "SG" MoldSysNum)
          (if (/= "I" (substr MoldTypeNum 2 1))
            (setq tpX cpX)
          )
          (if (= "A" (substr MoldTypeNum 1 1))
            (setq stZ 0)
          )
          (if (= "C" (substr MoldTypeNum 1 1))
            (setq stZ 0
	          spZ 0
            )
          )
          (if (= "D" (substr MoldTypeNum 1 1))
            (setq spZ 0)
          )
          (if (= "H" (substr MoldTypeNum 2 1))
            (setq tpZ 0)
          )
        )
        ((= "TP" MoldSysNum)
          (if (= "H" (substr MoldTypeNum 3 1))
            (setq tpX cpX)
          )
          (if (= "FC" (substr MoldTypeNum 1 2))
            (setq spZ 0)
          ) 
          (if (= "GA" (substr MoldTypeNum 1 2))
            (setq rpZ 0)
          ) 
          (if (= "GC" (substr MoldTypeNum 1 2))
            (setq spZ 0
                  rpZ 0)
          )
        )
        ((= "PP" MoldSysNum)
          (if (= "E" (substr MoldTypeNum 1 1))
            (setq rpZ 0)
          )
          (if (= "A" (substr MoldTypeNum 2 1))
            (setq stZ 0)
          ) 
          (if (= "D" (substr MoldTypeNum 2 1))
            (setq spZ 0)
          ) 
          (if (= "C" (substr MoldTypeNum 2 1))
            (setq stZ 0
                  spZ 0)
          )
        )
      )
      (set_tile "erp" (itoa erpZ))
      (set_tile "ep"  (itoa epZ))
      (set_tile "tp"  (itoa tpZ))
      (set_tile "bp"  (itoa bpZ))
      (set_tile "rp"  (itoa rpZ))
      (set_tile "st"  (itoa stZ))
      (set_tile "sp"  (itoa spZ))
      (set_tile "SpecValue" MoldSpecNum)
      (mode_tile "option" 0)
    )
    (progn
      (set_tile "SpecValue" err_msg)
      (setq MoldSpecNum nil)
    )
  )
)


(defun PlateThkSel(PlateNum / PlateLst PlateThkItem)
  (setq plateLst '("25" "30" "35" "40" "50" "60" "70" "80" "90" "100" "110" "120" "130" "140" "150" "160"
                   "170" "180" "190" "200" "210")
  )
  (if (not (new_dialog "mold32" MoldDclId))
    (exit)
  )
  (ini_list "Lst" PlateLst)
  (action_tile "Lst" "(setPlateThk)")
  (action_tile "accept" "(exitPlateLst)")
  (start_dialog)
  (if aPThk
    (set_tile "aPlateThk" (itoa aPThk))
  )
  (if bPThk
    (set_tile "bPlateThk" (itoa bPThk))
  )
  (if sbPThk
    (set_tile "sbPlateThk" (itoa sbPThk))
  )
  (if (and aPThk bPThk sbPThk)
    (progn
      (mode_tile "next34" 0)
      (mode_tile "next34" 2)
    )
  )
)

(defun setPlateThk()
  (setq PlateThkItem (get_tile "Lst"))
  (cond
    ((= 1 PlateNum)
      (setq aPThk (nth (atoi PlateThkItem) PlateLst))
      (set_tile "Value" (strcat "You select: " aPThk))
      (setq aPThk (atoi aPThk))
    )
    ((= 2 PlateNum)
      (setq bPThk (nth (atoi PlateThkItem) PlateLst))
      (set_tile "Value" (strcat "You select: " bPThk))
      (setq bPThk (atoi bPThk))
    )
    ((= 3 PlateNum)
      (setq sbPThk (nth (atoi PlateThkItem) PlateLst))
      (set_tile "Value" (strcat "You select: " sbPThk))
      (setq sbPThk (atoi sbPThk))
    ) 
  )
  (mode_tile "accept" 2)
)

(defun exitPlateLst()
  (if (not PlateThkItem)
    (set_tile "MSG" "You did not select any item!")
    (done_dialog)
  )
)

(defun SpecVerify()
  (if (= 2 SpecValidNum)
    (progn
      (setq MoldSpecNum (lxy_trim (get_tile "SpecValue")))
      (getMoldBaseData)
      (if (and MoldSpecNum aPThk bPThk sbPThk)
        (progn
          (mode_tile "next34" 0)
          (mode_tile "next34" 2)
        )
      )
    )
  )
)

(defun PTVerify(PlateNum)
  (cond
    ((= 1 PlateNum)
      (setq PThk (get_tile "aPlateThk"))
      (if (>= (atof PThk) 25)
        (setq aPThk (atof PThk)
	      err_PT1 nil)
        (setq err_PT1 "Invalid!"
              aPThk nil)
      )
      (if err_PT1 
        (set_tile "aPlateThk" err_PT1)
      )
    )
    ((= 2 PlateNum)
      (setq PThk (get_tile "bPlateThk"))
      (if (>= (atoi PThk) 25)
        (setq bPThk (atof PThk)
	      err_PT2 nil)
        (setq err_PT2 "Invalid!"
	      bPThk nil)
      )
      (if err_PT2 
        (set_tile "bPlateThk" err_PT2)
      )
    )
    ((= 3 PlateNum)
      (setq PThk (get_tile "sbPlateThk"))
      (if (>= (atoi PThk) 25)
        (setq sbPThk (atof PThk)
	      err_PT3 nil)
        (setq err_PT3 "Invalid!"
              sbPThk nil)
      )
      (if err_PT3 
        (set_tile "sbPlateThk" err_PT3)
      )
    )
  )
  (if (and MoldSpecNum aPThk bPThk sbPThk)
    (progn
      (mode_tile "next34" 0)
      (mode_tile "next34" 2)
      (if (= aPThk (fix aPThk))
        (setq aPThk (fix aPThk))
      )
      (if (= bPThk (fix bPThk))
        (setq bPThk (fix bPThk))
      )
      (if (= sbPThk (fix sbPThk))
        (setq sbPThk (fix sbPThk))
      )
    )
  )
)

(defun setTapHoldSpec( / TapHoldLib Ta Tb TaTemp)
  (setq TapHoldLib '(("15015025" "15015030" "15015035" "15015040" "15015050" "15015060" "15015070" "15020025" "15020030" "15020035" "15020040"
		      "15020050" "15020060" "15020070" "15025025" "15025030" "15025035" "15025040" "15025050" "15025060" "15025070" (10 20 28))
		     ("18020025" "18020030" "18020035" "18020040" "18020050" "18020060" "18020070" "18020080" "18023025" "18020030" "18023035"
		      "18023040" "18023050" "18023060" "18023070" "18023080" "18025025" "18025030" "18025035" "18025040" "18025050" "18025060"
		      "18025070" "18025080" "20020025" "20020030" "20020035" "20020040" "20020050" "20020060" "20020070" "20020080" "20023025"
		      "20023030" "20023035" "20023040" "20023050" "20023060" "20023070" "20023080" "20025025" "20025030" "20025035" "20025040"
		      "20025050" "20025060" "20025070" "20025080" "20030025" "20030030" "20030035" "20030040" "20030050" "20030060" "20030070"
		      "20030080" "20035025" "20035030" "20035035" "20035040" "20035050" "20035060" "20035070" "20035080" "23030025" "23030030"
		      "23030035" "23030040" "23035025" "23035030" "23035035" "23035040" "25025030" "25025035" "25025040" "25027030" "25027035"
		      "25027040" "25030030" "20030035" "20030040" (12 24 33))
		     ("23030050" "23030060" "23030070" "23030080" "23035050" "23035060" "23035070" "23035080" "25025050" "25025060" "25025070"
		      "25025080" "25025090" "250250100" "25027050" "25027060" "25027070" "25027080" "25027090" "250270100" "25030050" "25030060"
                      "25030070" "25030080" "25030090" "250300100" "25035030" "25035035" "25035040" "25035050" "25035060" "25035070" "25035080"
	              "25035090" "25035100" "25040030" "25040035" "25040040" "25040050" "25040060" "25040070" "25040080" "25040090" "250400100"
		      "25050030" "25050035" "25050040" "25050050" "25050060" "25050070" "25050080" "25050090" "250500100" "27030030" "27030035"
		      "27030040" "27030050" "27030060" "27030070" "27030080" "27030090" "270300100" "27035030" "27035035" "27035040" "27035050"
		      "27035060" "27035070" "27035080" "27035090" "270350100" "27040030" "27040035" "27040040" "27040050" "27040060" "27040070"
		      "27040080" "27040090" "270400100" "30030030" "30030035" "30030040" "30030050" "30030060" "30030070" "30030080" "30030090"
		      "300300100" "300300110" "300300120" "300300130" "30035030" "30035035" "30035040" "30035050" "30035060" "30035070" "30035080"
		      "30035090" "300350100" "300350110" "300350120" "300350130" (16 29 39))
		     ("30040035" "30040040" "30040050" "30040060" "30040070" "30040080" "30040090" "300400100" "300400110" "300400120" "300400130" 
		      "30045035" "30045040" "30045050" "30045060" "30045070" "30045080" "30045090" "300450100" "300450110" "300450120" "300450130"
		      "30050035" "30050040" "30050050" "30050060" "30050070" "30050080" "30050090" "300500100" "300500110" "300500120" "300500130"
		      "35035040" "35035050" "35035060" "35035070" "35035080" "35035090" "350350100" "350350110" "350350120" "350350130" "35040040"
		      "35040050" "35040060" "35040070" "35040080" "35040090" "350400100" "350400110" "350400120" "350400130" (20 33 46))
	             ("30060035" "30060040" "30060050" "30060060" "30060070" "30060080" "30060090" "300600100" "300600110" "300600120" "300600130"
		      "35045040" "35045050" "35045060" "35045070" "35045080" "35045090" "350450100" "350450110" "350450120" "350450130" "35050040"
		      "35050050" "35050060" "35050070" "35050080" "35050090" "350500100" "350500110" "350500120" "350500130" "350500140" "350500150"
		      "35060040" "35060050" "35060060" "35060070" "35060080" "35060090" "350600100" "350600110" "350600120" "350600130" "350600140"
		      "350600150" "35070040" "35070050" "35070060" "35070070" "35070080" "35070090" "350700100" "350700110" "350700120" "350700130"
		      "350700140" "350700150" "40040040" "40040050" "40040060" "40040070" "40040080" "40040090" "400400100" "400400110" "400400120"
	              "400400130" "400400140" "400400150" "40045040" "40045050" "40045060" "40045070" "40045080" "40045090" "400450100" "400450110"
		      "400450120" "400450130" "400450140" "400450150" "40050040" "40050050" "40050060" "40050070" "40050080" "40050090" "400500100"
		      "400500110" "400500120" "400500130" "400500140" "400500150" "40055040" "40060040" "40070040" (24 41 56))
		     ("40055050" "40055060" "40055070" "40055080" "40055090" "400550100" "400550110" "400550120" "400550130" "400550140" "400550150" 
		      "40060050" "40060060" "40060070" "40060080" "40060090" "400600100" "400600110" "400600120" "400600130" "400600140" "400600150"
		      "40070050" "40070060" "40070070" "40070080" "40070090" "400700100" "400700110" "400700120" "400700130" "400700140" "400700150"
		      "45045050" "45045060" "45045070" "45045080" "45045090" "450450100" "450450110" "450450120" "450450130" "450450140" "450450150"
		      "450450160" "450450170" "450450180" "45050050" "45050060" "45050070" "45050080" "45050090" "450500100" "450500110" "450500120"
		      "450500130" "450500140" "450500150" "450500160" "450500170" "450500180" "45055050" "45055060" "45055070" "45055080" "45055090"
		      "450550100" "450550110" "450550120" "450550130" "450550140" "450550150" "450550160" "450550170" "450550180" "45060050" "45060060"
		      "45060070" "45060080" "45060090" "450600100" "450600110" "450600120" "450600130" "450600140" "450600150" "450600160" "450600170"
		      "450600180" "45070050" "45070060" "45070070" "45070080" "45070090" "450700100" "450700110" "450700120" "450700130" "450700140"
		      "450700150" "450700160" "450700170" "450700180" "50050050" "50050060" "50050070" "50050080" "50050090" "500500100" "500500110"
		      "500500120" "500500130" "500500140" "500500150" "500500160" "500500170" "500500180" "50055050" "50055060" "50055070" "50055080"
		      "50055090" "500550100" "500550110" "500550120" "500550130" "500550140" "500550150" "500550160" "500550170" "500550180" "50060050"
		      "50060060" "50060070" "50060080" "50060090" "500600100" "50070050" "50070060" "50070070" "50070080" "50070090" "500700100" 
		      "55055070" "55055080" "55055090" "550550100" "55060070" "55060080" "55060090" "550600100" "55070070" "55070080" "55070090"
		      "550700100" "60060070" "60060080" "60060090" "600600100" "60065070" "60065080" "60065090" "600650100" "60065070" "60065080"
		      "60065090" "600650100" "60070070" "60070080" "60070090" "600700100" "60075070" "60075080" "60075090" "600750100" "60080070"
		      "60080080" "60080090" "600800100" (30 49 67))
		     ("500600110" "500600120" "500600130" "500600140" "500600150" "500600160" "500600170" "500600180" "500700110" "500700120" "500700130"
		      "500700140" "500700150" "500700160" "500700170" "500700180" "550550110" "550550120" "550550130" "550550140" "550550150" "550550160"
		      "550550170" "550550180" "550550200" "550600110" "550600120" "550600130" "550600140" "550600150" "550600160" "550600170" "550600180"
		      "550600200" "550650110" "550650120" "550650130" "550650140" "550650150" "550650160" "550650170" "550650180" "550650200" "550700110"
		      "550700120" "550700130" "550700140" "550700150" "550700160" "550700170" "550700180" "550700200" "600600110" "600600120" "600600130"
		      "600600140" "600600150" "600600160" "600600170" "600600180" "600600200" "600650110" "600650120" "600650130" "600650140" "600650150"
		      "600650160" "600650170" "600650180" "600650200" "600700110" "600700120" "600700130" "600700140" "600700150" "600700160" "600700170"
		      "600700180" "600700200" "600750110" "600750120" "600750130" "600750140" "600750150" "600750160" "600750170" "600750180" "600750200"
		      "600800110" "600800120" "600800130" "600800140" "600800150" "600800160" "600800170" "600800180" "600800200" (36 59 82))))
  (setq PlateThkLib '(25 30 35 40 50 60 70 80 90 100 110 120 130 140 150 160 170 180 200))
  (setq i 1)
  (setq Ta (nth 0 PlateThkLib))
  (setq Tb (nth 0 PlateThkLib))
  (while (< i 18)
    (setq TaTemp (nth i PlateThkLib))
    (if (> (abs (- aPThk Ta)) (abs (- aPThk TaTemp)))
      (setq Ta TaTemp)
    )
    (if (> (abs (- bPThk Tb)) (abs (- bPThk TaTemp)))
      (setq Tb TaTemp)
    )
    (setq i (+ i 1))
  )
  (setq aLabel (strcat (itoa (* 2 cpX)) (itoa (* 2 cpY)) (itoa Ta)))
  (setq bLabel (strcat (itoa (* 2 cpX)) (itoa (* 2 cpY)) (itoa Tb)))
  (foreach Lst TapHoldLib
    (progn
      (if (xh_get aLabel Lst)
        (setq TapHaD (car (last Lst))
 	      TapHaI (cadr (last Lst))
 	      TapHaL (caddr (last Lst))
        )
      )
      (if (xh_get bLabel Lst)
        (setq TapHbD (car (last Lst))
 	      TapHbI (cadr (last Lst))
 	      TapHbL (caddr (last Lst))
        )
      )
    )
  )
)

;------------------------------------------------------------------
;Modify return pin and determine whether add spring or not
;------------------------------------------------------------------
(defun ResetRpn()
  (setq RpnLst ("12" "15" "20"))
  (setq SpgLst ("26" "32" "40"))
  (setq IfExitMold33 t)
  (load "sp_lib")
  (while IfExitMold33 
    (if (not (new_dialog "mold33" MoldDclId))
      (exit)
    )

    (if (not IfRpnNew)
      (setq IfRpnNew "0")
    )
    (set_tile "IfRpnNew" IfRpnNew)

    (ini_list "RpnSpecLst" RpnLst)
    (if (= "0" (get_tile "IfRpnNew"))
      (progn
        (mode_tile "RpnSpecLst" 1)
        (mode_tile "RpnSpec" 1)
      )
      (progn
        (mode_tile "RpnSpecLst" 0)
        (mode_tile "RpnSpec" 0)
      )
    )
    (if (xh_get (itoa rpnD) RpnLst)
      (progn
        (set_tile "RpnSpecLst" (itoa (xh_get (itoa rpnD) RpnLst)))
        (set_tile "RpnSpec" (itoa rpnD))
      )
      (progn
        (setq IfAddSpg "0")
        (mode_tile "IfAddSpg" 1)
      )
    )
    (if (not IfAddSpg)
      (setq IfAddSpg "0")
    )
    (set_tile "IfAddSpg" IfAddSpg)
    (if (not mb)
      (setq mb "M")
    )
    (if (= "M" mb)
      (set_tile "mb" "0")
      (set_tile "mb" "1")
    )
    (if (not SpgHolDep)
      (progn
	(setq SpgHolDep (fix (* 0.12 (- sbPThk epZ erpZ 5))))
	(set_tile "SpgHDep" (itoa SpgHolDep))
      )
      (set_tile "SpgHDep" (itoa SpgHolDep))
    )
    (ini_list "SpgSpecLst" SpgLst)
    (setSpgLst)
    (setMb)
    (action_tile "IfRpnNew" "(setRpnLst)")
    (action_tile "IfAddSpg" "(setSpgLst)")
    (action_tile "RpnSpecLst" "(RpnSpecCli)")
    (action_tile "SpgSpecLst" "(SpgSpecCli)")
    (action_tile "SpgLenLst" "(SpgLenCli)")
    (action_tile "OK" "(ResetRpnData)")
    (action_tile "mb" "(setMb)")
    (start_dialog)
  )
)

(defun setRpnLst()
  (setq IfRpnNew (get_tile "IfRpnNew"))
  (if (= "1" ifRpnNew)
    (progn
      (mode_tile "RpnSpecLst" 0)
      (mode_tile "RpnSpec" 0)
    )
    (progn
      (mode_tile "RpnSpecLst" 1)
      (mode_tile "RpnSpec" 1)
    )
  )
)

(defun RpnSpecCli()
  (set_tile "RpnSpec" (nth (atoi (get_tile "RpnSpecLst")) RpnLst))
  (mode_tile "IfAddSpg" 0)
  (if (= "1" IfAddSpg)
    (progn
      (set_tile "mb" "0")
      (setMb)
    )
  )
)

(defun SpgSpecCli()
  (cond 
    ((= "M" mb)
      (set_tile "SpgSpec" (nth (atoi (get_tile "SpgSpecLst")) SpgLst))
      (ini_list "SpgLenLst" (nth (+ (atoi (get_tile "SpgSpecLst")) 3) (sp_lib "SPM" "spl")))
    )
    ((= "B" mb)
      (set_tile "SpgSpec" (nth (atoi (get_tile "SpgSpecLst")) (sp_lib "SPB" "spec")))
      (ini_list "SpgLenLst" (nth (atoi (get_tile "SpgSpecLst")) (sp_lib "SPB" "spl")))
    )
  )
)

(defun SpgLenCli()
  (cond
    ((= "M" mb)
      (set_tile "SpgSpec" (strcat (nth (atoi (get_tile "SpgSpecLst")) SpgLst) "X"
			          (nth (atoi (get_tile "SpgLenLst")) (nth (+ (atoi (get_tile "SpgSpecLst")) 3) (sp_lib "SPM" "spl")))))
    )
    ((= "B" mb)
      (set_tile "SpgSpec" (strcat (nth (atoi (get_tile "SpgSpecLst")) (sp_lib "SPB" "spec")) "X"
			          (nth (atoi (get_tile "SpgLenLst")) (nth (atoi (get_tile "SpgSpecLst")) (sp_lib "SPB" "spl")))))
    )
  )
)

(defun setSpgLst()
  (setq IfAddSpg (get_tile "IfAddSpg"))
  (if (= "0" IfAddSpg)
    (progn
      (mode_tile "mb" 1)
      (mode_tile "SpgSpecLst" 1)
      (mode_tile "SpgLenLst" 1)
      (mode_tile "SpgHDep" 1)
    )
    (progn
      (mode_tile "mb" 0)
      (mode_tile "SpgSpecLst" 0)
      (mode_tile "SpgLenLst" 0)
      (mode_tile "SpgHDep" 0)
      (if (= "B" mb)
        (ini_list "SpgLenLst" (nth (atoi (get_tile "SpgSpecLst")) (sp_lib "SPB" "spl")))
        (progn
          (set_tile "SpgSpecLst" (get_tile "RpnSpecLst"))
          (set_tile "SpgSpec" (nth (atoi (get_tile "SpgSpecLst")) SpgLst))
          (ini_list "SpgLenLst" (nth (+ (atoi (get_tile "SpgSpecLst")) 3) (sp_lib "SPM" "spl")))
        )
      )
    )
  )
)

(defun setMb()
  (if (= "1" (get_tile "mb"))
    (setq mb "B")
    (setq mb "M")
  )
  (if (= "1" IfAddSpg)
    (cond
      ((= "B" mb)
        (ini_list "SpgSpecLst" (sp_lib "SPB" "spec"))
        (ini_list "SpgLenLst" ())
        (set_tile "SpgSpec" "")
      )
      ((= "M" mb)
        (ini_list "SpgSpecLst" SpgLst)
        (if (= "1" IfRpnNew)
          (set_tile "SpgSpecLst" (get_tile "RpnSpecLst"))
        )
        (set_tile "SpgSpec" (nth (atoi (get_tile "SpgSpecLst")) SpgLst))
        (ini_list "SpgLenLst" (nth (+ (atoi (get_tile "SpgSpecLst")) 3) (sp_lib "SPM" "spl")))
      )
    )
  )
)

(defun ResetRpnData()
  (if (= "1" IfRpnNew)
    (setq rpnD (atoi (nth (atoi (get_tile "RpnSpecLst")) RpnLst)))
  )
  (if (= "1" IfAddSpg)
    (if (= "" (get_tile "SpgSpecLst"))
      (setq Msg "Invalid Spring specification!")
      (if (= "" (get_tile "SpgLenLst"))
        (setq Msg "Invalid Spring length!")
        (cond 
          ((= "B" mb)
            (setq SpgTyp (nth (atoi (get_tile "SpgSpecLst")) (sp_lib "SPB" "spec")))
	    (setq SpgLen (nth (atoi (get_tile "SpgLenLst")) (nth (xh_get SpgTyp (sp_lib "SPB" "spec")) (sp_lib "SPB" "spl"))))
	    (setq SpgOd  (nth (atoi (get_tile "SpgSpecLst")) (sp_lib "SPB" "od")))
	    (setq SpgId  (nth (atoi (get_tile "SpgSpecLst")) (sp_lib "SPB" "id")))
	    (setq SpgA   (nth (atoi (get_tile "SpgSpecLst")) (sp_lib "SPB" "r1")))
	    (setq SpgB   (nth (atoi (get_tile "SpgSpecLst")) (sp_lib "SPB" "r2")))
            (setq SpgOd (* SpgOd 25.4))
            (setq SpgId (* SpgId 25.4))
            (setq Msg nil)
          )
          ((= "M" mb)
            (setq SpgTyp (nth (atoi (get_tile "SpgSpecLst")) SpgLst))
	    (setq SpgLen (nth (atoi (get_tile "SpgLenLst")) (nth (xh_get SpgTyp (sp_lib "SPM" "spec")) (sp_lib "SPM" "spl"))))
	    (setq SpgOd  (nth (xh_get SpgTyp (sp_lib "SPM" "spec")) (sp_lib "SPM" "od")))
	    (setq SpgId  (nth (xh_get SpgTyp (sp_lib "SPM" "spec")) (sp_lib "SPM" "id")))
	    (setq SpgA   (nth (xh_get SpgTyp (sp_lib "SPM" "spec")) (sp_lib "SPM" "r1")))
	    (setq SpgB   (nth (xh_get SpgTyp (sp_lib "SPM" "spec")) (sp_lib "SPM" "r2")))
            (setq Msg nil)
          )
        )
      )
    )
  )
  (if Msg 
    (set_tile "MSG33" Msg)
    (progn
      (setq IfNext 1)
      (setq SpgHolDep (atoi (get_tile "SpgHDep")))
      (if (= "1" IfAddSpg)
        (if (>= 0 SpgHolDep)
          (setq IfNext (yn "Spring Hole depth is 0, Continuous?"))
        )
      )
      (if (= 1 IfNext)
        (progn
          (done_dialog)
          (setq IfExitMold33 nil)
        )
        (mode_tile "SpgHDep" 4)
      )
    )
  )
)
;********************************************************************************************************;

(defun MoldPosition(/ V1BasePt	V2BasePt	V3BasePt	V4BasePt	IfExitMoldPosition	gpt
				MoldPosNext)
  (setq IfExitMoldPos T)
  (setq IfOnScr "0")
  (while IfExitMoldPos
    (if (not (new_dialog "mold41" MoldDclId))
      (exit)
    )
    (IniMoldPos)
    (action_tile "V1PT" "(gPoint 1)")
    (action_tile "V2PT" "(gPoint 2)")
    (action_tile "V3PT" "(gPoint 3)")
    (action_tile "V4PT" "(gPoint 4)")
    (action_tile "IfAuto" "(IniMoldPos)")
    (action_tile "gPtOnScr" "(setOnScr)")
    (action_tile "finish" "(GetAndDo) (done_dialog 1)")
    (action_tile "back43" "(done_dialog 3)")
    (setq MoldPosNext (start_dialog))
    (cond
      ((= 0 MoldPosNext) 
        (setq IfExitMoldSpec nil
    	      IfExitMoldType nil
    	      IfExitMoldSys nil
    	      IfExitMoldPos nil
        )
      )
      ((= 1 MoldPosNext)
        (if (and (= IfAuto "1") (= IfOnScr "1"))
          (progn
            (setq V1BasePt (getpoint "\nGet first view base point:"))
            (if V1BasePt 
              (progn
      	        (setq V2BasePt (polar V1BasePt 0 (+ tpX tpZ rpZ aPThk stZ bPThk spZ sbPThk bpZ 100))
	              V3BasePt (polar V2BasePt 0 (+ tpX 80))
	              V4BasePt (polar V1BasePt (* pi 1.5) (+ cpY tpZ rpZ aPThk stZ bPThk spZ sbPThk bpZ 80))
                )
      	      )
            )
          )
        )
        (if (and (= IfAuto "0") (= IfOnScr "1"))
          (progn
            (setq V1BasePt (getpoint "\nGet the first view base point:"))
            (if V1BasePt 
	      (setq V2BasePt (getpoint "\nGet the second view base point:"))
	      (setq V2BasePt nil)
            )
            (if V2BasePt 
	      (setq V3BasePt (getpoint "\nGet the third view base point:"))
	      (setq V3BasePt nil)
            )
            (if V3BasePt 
	      (setq V4BasePt (getpoint "\nGet the fourth view base point:"))
	      (setq V4BasePt nil)
            )
          )
        )
        (if (and V1BasePt V2BasePt V3BasePt V4BasePt)
          (progn
            (setq IfExitMoldSpec nil
    	          IfExitMoldType nil
    	          IfExitMoldSys nil
    	          IfExitMoldPos nil
            )
            (drawMoldBase)
          )
        )
      ) 
      ((= 2 MoldPosNext)
        (cond
          ((= 1 gpt)
            (setq V1BasePt (getpoint "\nPick a Point:"))
          )
          ((= 2 gpt)
            (setq V2BasePt (getpoint "\nPick a Point:"))
          )
          ((= 3 gpt)
            (setq V3BasePt (getpoint "\nPick a Point:"))
          )
          ((= 4 gpt)
            (setq V4BasePt (getpoint "\nPick a Point:"))
          )
        )
      )
      ((= 3 MoldPosNext)
        (setq IfExitMoldPos nil)
      )
    )
  )
)

(defun IniMoldPos()
  (setq IfAuto (get_tile "IfAuto"))
  (if V1BasePt
    (progn
      (set_tile "V1X" (rtos (car V1BasePt) 2 3))
      (set_tile "V1Y" (rtos (cadr V1BasePt) 2 3))
      (set_tile "V1Z" (rtos (caddr V1BasePt) 2 3))
    )
    (progn
      (setq V1BasePt '(0.0 0.0 0.0))
      (set_tile "V1X" "0.0")
      (set_tile "V1Y" "0.0")
      (set_tile "V1Z" "0.0")
    )
  )
  (if (= "0" IfOnScr)
    (if (= "1" IfAuto)
      (progn
        (setq V2BasePt (polar V1BasePt 0 (+ tpX tpZ rpZ aPThk stZ bPThk spZ sbPThk bpZ 100))
	      V3BasePt (polar V2BasePt 0 (+ tpX 80))
	      V4BasePt (polar V1BasePt (* pi 1.5) (+ cpY tpZ rpZ aPThk stZ bPThk spZ sbPThk bpZ 80))
        )
        (mode_tile "V2PT" 1)
        (mode_tile "V2X" 1)
        (mode_tile "V2Y" 1)
        (mode_tile "V2Z" 1)
        (mode_tile "V3PT" 1)
        (mode_tile "V3X" 1)
        (mode_tile "V3Y" 1)
        (mode_tile "V3Z" 1)
        (mode_tile "V4PT" 1)
        (mode_tile "V4X" 1)
        (mode_tile "V4Y" 1)
        (mode_tile "V4Z" 1)
      )
      (progn
        (mode_tile "V2PT" 0)
        (mode_tile "V2X" 0)
        (mode_tile "V2Y" 0)
        (mode_tile "V2Z" 0)
        (mode_tile "V3PT" 0)
        (mode_tile "V3X" 0)
        (mode_tile "V3Y" 0)
        (mode_tile "V3Z" 0)
        (mode_tile "V4PT" 0)
        (mode_tile "V4X" 0)
        (mode_tile "V4Y" 0)
        (mode_tile "V4Z" 0)
      )
    )
  )
  (if V2BasePt
    (progn
      (set_tile "V2X" (rtos (car V2BasePt) 2 3))
      (set_tile "V2Y" (rtos (cadr V2BasePt) 2 3))
      (set_tile "V2Z" (rtos (caddr V2BasePt) 2 3))
    )
    (progn
      (set_tile "V2X" "0.0")
      (set_tile "V2Y" "0.0")
      (set_tile "V2Z" "0.0")
    )
  )
  (if V3BasePt
    (progn
      (set_tile "V3X" (rtos (car V3BasePt) 2 3))
      (set_tile "V3Y" (rtos (cadr V3BasePt) 2 3))
      (set_tile "V3Z" (rtos (caddr V3BasePt) 2 3))
    )
    (progn
      (set_tile "V3X" "0.0")
      (set_tile "V3Y" "0.0")
      (set_tile "V3Z" "0.0")
    )
  )
  (if V4BasePt
    (progn
      (set_tile "V4X" (rtos (car V4BasePt) 2 3))
      (set_tile "V4Y" (rtos (cadr V4BasePt) 2 3))
      (set_tile "V4Z" (rtos (caddr V4BasePt) 2 3))
    )
    (progn
      (set_tile "V4X" "0.0")
      (set_tile "V4Y" "0.0")
      (set_tile "V4Z" "0.0")
    )
  )
  (if (= "0" IfOnScr)
    (if (and V1BasePt V2BasePt V3BasePt V4BasePt)
      (mode_tile "finish" 0)
      (mode_tile "finish" 1)
    )
  )
)

(defun setOnScr()
  (setq IfOnScr (get_tile "gPtOnScr"))
  (cond
    ((= "1" IfOnScr)
      (mode_tile "finish" 0)
      (if (= "1" IfAuto)
        (progn
	  (mode_tile "V1PT" 1)
	  (mode_tile "V1X" 1)
	  (mode_tile "V1Y" 1)
	  (mode_tile "V1Z" 1)
        )
        (progn
	  (mode_tile "V1PT" 1)
	  (mode_tile "V1X" 1)
	  (mode_tile "V1Z" 1)
	  (mode_tile "V1Y" 1)
          (mode_tile "V2PT" 1)
          (mode_tile "V2X" 1)
          (mode_tile "V2Y" 1)
          (mode_tile "V2Z" 1)
          (mode_tile "V3PT" 1)
          (mode_tile "V3X" 1)
          (mode_tile "V3Y" 1)
          (mode_tile "V3Z" 1)
          (mode_tile "V4PT" 1)
          (mode_tile "V4X" 1)
          (mode_tile "V4Y" 1)
          (mode_tile "V4Z" 1)
        )
      )
    )
    ((= "0" IfOnScr)
      (if (and V1BasePt V2BasePt V3BasePt V4BasePt)
        (mode_tile "finish" 0)
        (mode_tile "finish" 1)
      )
      (if (= "1" IfAuto)
        (progn
	  (mode_tile "V1PT" 0)
	  (mode_tile "V1X" 0)
	  (mode_tile "V1Y" 0)
	  (mode_tile "V1Z" 0)
        )
        (progn
	  (mode_tile "V1PT" 0)
	  (mode_tile "V1X" 0)
	  (mode_tile "V1Y" 0)
	  (mode_tile "V1Y" 0)
          (mode_tile "V2PT" 0)
          (mode_tile "V2X" 0)
          (mode_tile "V2Y" 0)
          (mode_tile "V2Z" 0)
          (mode_tile "V3PT" 0)
          (mode_tile "V3X" 0)
          (mode_tile "V3Y" 0)
          (mode_tile "V3Z" 0)
          (mode_tile "V4PT" 0)
          (mode_tile "V4X" 0)
          (mode_tile "V4Y" 0)
          (mode_tile "V4Z" 0)
        )
      )
    )
  )
)

(defun GetAndDo()
  (if (= IfAuto "0")
    (setq V1BasePt (list (atof (get_tile "V1X")) (atof (get_tile "V1Y")) (atof (get_tile "V1Z")))
          V2BasePt (list (atof (get_tile "V2X")) (atof (get_tile "V2Y")) (atof (get_tile "V2Z")))
	  V3BasePt (list (atof (get_tile "V3X")) (atof (get_tile "V3Y")) (atof (get_tile "V3Z")))
	  V4BasePt (list (atof (get_tile "V4X")) (atof (get_tile "V4Y")) (atof (get_tile "V4Z")))
    )
  )
)

(defun gPoint(ViewVar)
  (done_dialog 2)
  (cond 
    ((= 1 ViewVar)
      (setq gpt 1)
    )
    ((= 2 ViewVar)
      (setq gpt 2)
    )
    ((= 3 ViewVar)
      (setq gpt 3)
    )
    ((= 4 ViewVar)
      (setq gpt 4)
    )
  )
)
;********************************************************************************************************;

;%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
;Main call function of Mold Base Creation
;%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
(defun drawMoldBase(/ scrMLst	scrMMLst	scrDLst		scrDDLst	gpnDHLst	gpnHDLst
		gpnHD1Lst	gpnHDDLst	gpnHHLst	gpnCTLst	gpnCSLst	aP
		bP		sbP)

  (princ "\nPlease wait a moment...")
;---------------------------------------
;Register App
;---------------------------------------
  (regapp "V1X")
  (regapp "V1Y")
  (regapp "V2X")
  (regapp "V2Y")
  (regapp "V3X")
  (regapp "V3Y")
  (regapp "V4X")
  (regapp "V4Y")

  (setq scrMLst  '(M6   M8   M10   M12   M14   M16   M20)
	scrMMLst '("M6" "M8" "M10" "M12" "M14" "M16" "M20")
	scrDLst  '(6    8    10    12    14    16    20)
	scrDDLst '(10   13   16    18    21    24    30)
  )
  (if (= 'REAL (type aPThk))
    (setq aP (rtos aPThk 2 1))
    (setq aP (itoa aPThk))
  )
  (if (= 'REAL (type bPThk))
    (setq bP (rtos bPThk 2 1))
    (setq bP (itoa bPThk))
  )
  (if (= 'REAL (type sbPThk))
    (setq sbP (rtos sbPThk 2 1))
    (setq sbP (itoa sbPThk))
  )
  (cond
    ((= "SG" MoldSysNum)
      (setq gpnDHLst  '(6  6  8  8  8  10 12 15))
      (setq gpnHDLst  '(16 20 25 30 35 40 50 60))
      (setq gpnHD1Lst '(25 30 35 42 48 55 70 80))
      (setq gpnHDDLst '(30 35 40 47 54 61 76 86))
      (setq gpnHHLst  '(6  8  8  10 10 10 12 15))
    )
    ((= "TP" MoldSysNum)
      (setq gpnDHLst  '(8  10 12 14))
      (setq gpnHDLst  '(16 20 25 30))
      (setq gpnHD1Lst '(25 30 35 42))
      (setq gpnHDDLst '(30 35 40 47))
      (setq gpnHHLst  '(6  8  8  10))
    )
    ((= "PP" MoldSysNum)
      (setq spnDHLst  '(10 12 14 16 18))
      (setq spnHDLst  '(20 25 30 35 40))
      (setq spnHD1Lst '(30 35 42 42 55))
      (setq spnHDDLst '(35 40 47 54 61))
      (setq spnHHLst  '(8  8  10 10 10))
      (setq spnCDLst  '(26 31 38 43 48))
      (setq spnCSLst  '(18 21 24 24 24))
      (setq spnSSLst  '(10 12 14 14 14))
      (setq spnSHLst  '(12 14 16 16 16))

      (setq gpnDHLst  '(6  8  8  8  10))
      (setq gpnHDLst  '(20 25 30 35 40))
      (setq gpnHD1Lst '(30 35 42 48 55))
      (setq gpnHDDLst '(35 40 47 54 61))
      (setq gpnHHLst  '(8  8  10 10 10))
    )
  )
  (load "MoldCapC")
  (if V1BasePt
    (cond
      ((= "SG" MoldSysNum)
        (drawSGMoldView1)
      )
      ((= "TP" MoldSysNum)
        (drawTPMoldView1)
      )
      ((= "PP" MoldSysNum)
        (drawPPMoldView1)
      )
    )
  )
  (if V2BasePt
    (cond
      ((= "SG" MoldSysNum)
        (drawSGMoldView2)
      )
      ((= "TP" MoldSysNum)
        (drawTPMoldView2)
      )
      ((= "PP" MoldSysNum)
        (drawPPMoldView2)
      )
    )
  )
  (if V3BasePt
    (cond
      ((= "SG" MoldSysNum)
        (drawSGMoldView3)
      )
      ((= "TP" MoldSysNum)
        (drawTPMoldView3)
      )
      ((= "PP" MoldSysNum)
        (drawPPMoldView3)
      )
    )
  )
  (if V4BasePt
    (cond
      ((= "SG" MoldSysNum)
        (drawSGMoldView4)
      )
      ((= "TP" MoldSysNum)
        (drawTPMoldView4)
      )
      ((= "PP" MoldSysNum)
        (drawPPMoldView4)
      )
    )
  )
  (princ "Done")
)

;*******************************************************************************************************;
;side Gate Mold Base System
;*******************************************************************************************************;
(defun drawSGMoldView1()
  (setq tpPT1 (polar (polar V1BasePt 0 tpX) (* pi 0.5) tpY)
	tpPT2 (polar tpPT1 pi (* tpX 2))
	tpPT3 (polar tpPT2 (* pi 1.5) (* tpY 2))
	tpPT4 (polar tpPT3 0 (* tpX 2))
  )
  (setq sbPT1 (polar (polar V1BasePt 0 sbX2) (* pi 0.5) sbY)
	sbPT2 (polar (polar V1BasePt 0 sbX1) (* pi 0.5) sbY)
        sbPT3 (polar sbPT2 (* pi 1.5) (* sbY 2))
        sbPT4 (polar sbPT1 (* pi 1.5) (* sbY 2))
	sbPT5 (polar (polar V1BasePt pi sbX1) (* pi 0.5) sbY)
	sbPT6 (polar (polar V1BasePt pi sbX2) (* pi 0.5) sbY)
        sbPT7 (polar sbPT6 (* pi 1.5) (* sbY 2))
        sbPT8 (polar sbPT5 (* pi 1.5) (* sbY 2))
  )
  (setq epPT1 (polar (polar V1BasePt 0 epX) (* pi 0.5) epY)
	epPT2 (polar epPT1 pi (* epX 2))
	epPT3 (polar epPT2 (* pi 1.5) (* epY 2))
	epPT4 (polar epPT3 0 (* epX 2))
  )
  (setq cPT1 (polar V1BasePt 0 (+ tpX 5))
	cPT2 (polar V1BasePt (* pi 0.5) (+ tpY 5))
	cPT3 (polar V1BasePt pi (+ tpX 5))
	cPT4 (polar V1BasePt (* pi 1.5) (+ tpY 5))
  )
  (setq gpnHD1 (nth (xh_get gpnD gpnHDLst) gpnHD1Lst)
	cgpnPT1 (polar (polar V1BasePt 0 gpnX) (* pi 0.5) gpnY)
	cgpnPT2 (polar cgpnPT1 pi (* gpnX 2))
	cgpnPT3 (polar cgpnPT2 (* pi 1.5) (* gpnY 2))
	cgpnPT4 (polar cgpnPT1 (* pi 1.5) (- (* gpnY 2) 2))
  )
  (cond 
    ((= 4 rpnNum)
      (setq crpnPT1 (polar (polar V1BasePt 0 rpnX) (* pi 0.5) rpnY)
	    crpnPT2 (polar crpnPT1 pi (* rpnX 2))
	    crpnPT3 (polar crpnPT2 (* pi 1.5) (* rpnY 2))
	    crpnPT4 (polar crpnPT1 (* pi 1.5) (* rpnY 2))
      )
    )
    ((= 6 rpnNum)
      (setq crpnPT1 (polar (polar V1BasePt 0 rpnX) (* pi 0.5) rpnY)
	    crpnPT2 (polar crpnPT1 pi (* rpnX 2))
	    crpnPT3 (polar crpnPT2 (* pi 1.5) (* rpnY 2))
	    crpnPT4 (polar crpnPT1 (* pi 1.5) (* rpnY 2))
	    crpnPT5 (polar V1BasePt 0 rpnX)
	    crpnPT6 (polar V1BasePt pi rpnX)
      )
    )
  )
  (cond
    ((= 4 scr1Num)
      (setq scr1PT1 (polar (polar V1BasePt 0 scr1X) (* pi 0.5) scr1Y)
	    scr1PT2 (polar scr1PT1 pi (* scr1X 2))
	    scr1PT3 (polar scr1PT2 (* pi 1.5) (* scr1Y 2))
	    scr1PT4 (polar scr1PT1 (* pi 1.5) (* scr1Y 2))
      )
    )
    ((= 6 scr1Num)
      (setq scr1PT1 (polar (polar V1BasePt 0 scr1X) (* pi 0.5) scr1Y)
	    scr1PT2 (polar scr1PT1 pi (* scr1X 2))
	    scr1PT3 (polar scr1PT2 (* pi 1.5) (* scr1Y 2))
	    scr1PT4 (polar scr1PT1 (* pi 1.5) (* scr1Y 2))
	    scr1PT5 (polar V1BasePt 0 scr1X)
	    scr1PT6 (polar V1BasePt pi scr1X)
      )
    )
  )
  (setq scr2PT1 (polar (polar V1BasePt 0 scr2X) (* pi 0.5) scr2Y)
	scr2PT2 (polar scr2PT1 pi (* scr2X 2))
	scr2PT3 (polar scr2PT2 (* pi 1.5) (* scr2Y 2))
	scr2PT4 (polar scr2PT1 (* pi 1.5) (* scr2Y 2))
  )
  (cond
    ((= 8 scr3Num)
      (setq scr3PT1 (polar (polar V1BasePt 0 scr3X) (* pi 0.5) scr3Y)
	    scr3PT2 (polar scr3PT1 pi (* scr3X 2))
	    scr3PT3 (polar scr3PT2 (* pi 1.5) (* scr3Y 2))
	    scr3PT4 (polar scr3PT1 (* pi 1.5) (* scr3Y 2))
      )
    )
    ((= 12 scr3Num)
      (setq scr3PT1 (polar (polar V1BasePt 0 scr3X) (* pi 0.5) scr3Y)
	    scr3PT2 (polar scr3PT1 pi (* scr3X 2))
	    scr3PT3 (polar scr3PT2 (* pi 1.5) (* scr3Y 2))
	    scr3PT4 (polar scr3PT1 (* pi 1.5) (* scr3Y 2))
	    scr3PT5 (polar V1BasePt 0 scr3X)
	    scr3PT6 (polar V1BasePt pi scr3X)
      )
    )
    ((= 16 scr3Num)
      (setq scr3PT1 (polar (polar V1BasePt 0 scr3X) (* pi 0.5) scr3Y)
	    scr3PT2 (polar scr3PT1 pi (* scr3X 2))
	    scr3PT3 (polar scr3PT2 (* pi 1.5) (* scr3Y 2))
	    scr3PT4 (polar scr3PT1 (* pi 1.5) (* scr3Y 2))
	    scr3PT5 (polar (polar V1BasePt 0 scr3X) (* pi 0.5) scr3Y2)
	    scr3PT6 (polar scr3PT5 pi (* scr3X 2))
	    scr3PT7 (polar scr3PT6 (* pi 1.5) (* scr3Y2 2))
	    scr3PT8 (polar scr3PT5 (* pi 1.5) (* scr3Y2 2))
      )
    )
  )
  (setq scr1D1 (nth (xh_get scr1D scrMLst) scrDLst)
	scr1D2 (nth (xh_get scr1D scrMLst) scrDdLst)
	scr2D1 (nth (xh_get scr2D scrMLst) scrDLst)
	scr2D2 (nth (xh_get scr2D scrMLst) scrDdLst)
	scr3D1 (nth (xh_get scr3D scrMLst) scrDLst)
	scr3D2 (nth (xh_get scr3D scrMLst) scrDdLst)
  )
;;LCA - WARNING: The OSMODE sysvar has changed.
;;LCA - WARNING: The OSMODE sysvar has changed.
;;LCA - WARNING: The OSMODE sysvar has changed.
;;LCA - WARNING: The OSMODE sysvar has changed.
;;LCA - WARNING: The OSMODE sysvar has changed.
;;LCA - WARNING: The OSMODE sysvar has changed.
  (setvar "osmode" 0)
  (setvar "cecolor" "bylayer")
  (setvar "celtype" "bylayer")
  (setvar "clayer" "continuous")
  (if (= "I" (substr MoldTypeNum 2 1))
    (progn
      (command "line" tpPT1 tpPt2 tpPT3 tpPT4 "c")
      (command "line" sbPT1 sbPT4 ""
	       "line" sbPT6 sbPT7 "")
    )
    (command "line" sbPT1 sbPT6 sbPT7 sbPT4 "c")
  )
  (command "circle" cgpnPT1 (/ gpnD   2.0)
           "circle" cgpnPT1 (/ gpnHD1 2.0)
	   "circle" cgpnPT2 (/ gpnD   2.0)
	   "circle" cgpnPT2 (/ gpnHD1 2.0)
	   "circle" cgpnPT3 (/ gpnD   2.0)
	   "circle" cgpnPT3 (/ gpnHD1 2.0)
	   "circle" cgpnPT4 (/ gpnD   2.0)
	   "circle" cgpnPT4 (/ gpnHD1 2.0)
  )
  (if (not IfAddSpg)
    (progn
      (command "circle" crpnPT1 (/ rpnD 2.0)
	       "circle" crpnPT2 (/ rpnD 2.0)
	       "circle" crpnPT3 (/ rpnD 2.0)
	       "circle" crpnPT4 (/ rpnD 2.0)
      )
      (if (= 6 rpnNum)
        (command "circle" crpnPT5 (/ rpnD 2.0)
	         "circle" crpnPT6 (/ rpnD 2.0)
        )
      )
    )
    (progn
      (load "MoldSpgZ")
      (setvar "clayer" "spring")
      (setq rep "S1")
      (MoldSpgZst crpnPT1 SpgOd SpgTyp SpgLen "1")
      (MoldSpgZst crpnPT2 SpgOd SpgTyp SpgLen "1")
      (MoldSpgZst crpnPT3 SpgOd SpgTyp SpgLen "1")
      (MoldSpgZst crpnPT4 SpgOd SpgTyp SpgLen "1")
      (if (= 6 rpnNum)
        (progn
          (MoldSpgZst crpnPT5 SpgOd SpgTyp SpgLen "1")
          (MoldSpgZst crpnPT6 SpgOd SpgTyp SpgLen "1")
        )
      )
    )
  )
  (setvar "clayer" "hidden")
  (command "line" sbPT2 sbPT3 ""
	   "line" sbPT5 sbPT8 ""
	   "line" epPT1 epPT4 ""
	   "line" epPT2 epPT3 ""
  )

  (if (and TapHaD TapHbD)
    (progn
      (setq aTapPt  (polar V1BasePt (* pi 0.5) cpY)
	    aTapPT1 (polar aTapPt pi (/ TapHaD 2.0))
	    aTapPT2 (polar aTapPt pi (/ (* 0.8 TapHaD) 2))
	    aTapPT4 (polar aTapPt 0  (/ TapHaD 2.0))
	    aTapPT3 (polar aTapPt 0  (/ (* 0.8 TapHaD) 2))
	    aTapPT5 (polar aTapPt (* pi 1.5) TapHaL)
	    aTapPT6 (polar aTapPT5 2.618  (/ (* TapHaD 0.4) (cos 0.5236)))
	    aTapPT7 (polar aTapPT5 0.5236 (/ (* TapHaD 0.4) (cos 0.5236)))

	    bTapPT  (polar V1BasePt (* pi 1.5) cpY)
	    bTapPT1 (polar bTapPt pi (/ TapHbD 2.0))
	    bTapPT2 (polar bTapPt pi (/ (* 0.8 TapHbD) 2))
	    bTapPT4 (polar bTapPt 0  (/ TapHbD 2.0))
	    bTapPT3 (polar bTapPt 0  (/ (* 0.8 TapHbD) 2))
	    bTapPT5 (polar bTapPt (* pi 0.5) TapHbL)
	    bTapPT6 (polar bTapPT5 3.6552  (/ (* TapHbD 0.4) (cos 0.5236)))
	    bTapPT7 (polar bTapPT5 -0.5236 (/ (* TapHbD 0.4) (cos 0.5236)))
      )
      (command "line" aTapPT1 (polar aTapPT1 (* pi 1.5) TapHaI) (polar aTapPT4 (* pi 1.5) TapHaI) aTapPT4 ""
	       "line" aTapPT2 aTapPT6 aTapPT5 aTapPT7 aTapPT3 ""
	       "line" aTapPT6 aTapPT7 ""
	       "line" bTapPT1 (polar bTapPT1 (* pi 0.5) TapHbI) (polar bTapPT4 (* pi 0.5) TapHbI) bTapPT4 ""
	       "line" bTapPT2 bTapPT6 bTapPT5 bTapPT7 bTapPT3 ""
	       "line" bTapPT6 bTapPT7 ""
      )
    )
  )
;------------------------------------------------
;Draw screw flat view
;------------------------------------------------
  (load "MoldCapZ")
  (setvar "clayer" "screw")
  (MoldCapZ (nth (xh_get scr1D scrMLst) scrMMlst) scr1PT1 "1")
  (MoldCapZ (nth (xh_get scr1D scrMLst) scrMMlst) scr1PT2 "1")
  (MoldCapZ (nth (xh_get scr1D scrMLst) scrMMlst) scr1PT3 "1")
  (MoldCapZ (nth (xh_get scr1D scrMLst) scrMMlst) scr1PT4 "1")
  (if (= 6 scr1Num)
    (progn
      (MoldCapZ (nth (xh_get scr1D scrMLst) scrMMlst) scr1PT5 "1")
      (MoldCapZ (nth (xh_get scr1D scrMLst) scrMMlst) scr1PT6 "1")
    )
  )

  (MoldCapZ (nth (xh_get scr2D scrMLst) scrMMlst) scr2PT1 "1")
  (MoldCapZ (nth (xh_get scr2D scrMLst) scrMMlst) scr2PT2 "1")
  (MoldCapZ (nth (xh_get scr2D scrMLst) scrMMlst) scr2PT3 "1")
  (MoldCapZ (nth (xh_get scr2D scrMLst) scrMMlst) scr2PT4 "1")

  (MoldCapZ (nth (xh_get scr3D scrMLst) scrMMlst) scr3PT1 "1")
  (MoldCapZ (nth (xh_get scr3D scrMLst) scrMMlst) scr3PT2 "1")
  (MoldCapZ (nth (xh_get scr3D scrMLst) scrMMlst) scr3PT3 "1")
  (MoldCapZ (nth (xh_get scr3D scrMLst) scrMMlst) scr3PT4 "1")
  (if (= 12 scr3Num)
    (progn
      (MoldCapZ (nth (xh_get scr3D scrMLst) scrMMlst) scr3PT5 "1")
      (MoldCapZ (nth (xh_get scr3D scrMLst) scrMMlst) scr3PT6 "1")
    )
  )
  (if (= 16 scr3Num)
    (progn
      (MoldCapZ (nth (xh_get scr3D scrMLst) scrMMlst) scr3PT5 "1")
      (MoldCapZ (nth (xh_get scr3D scrMLst) scrMMlst) scr3PT6 "1")
      (MoldCapZ (nth (xh_get scr3D scrMLst) scrMMlst) scr3PT7 "1")
      (MoldCapZ (nth (xh_get scr3D scrMLst) scrMMlst) scr3PT8 "1")
    )
  )

;--------------------------------------------------------
;Defun Extent Data
;--------------------------------------------------------
  (setvar "clayer" "center")
  (setq ExData1 (list (list -3 (list "V1X" (cons 1000 (strcat MoldTypeNum MoldSpecNum "A" aP "B" bP "C" sbP))))))
  (setq ExData2 (list (list -3 (list "V1Y" (cons 1000 (strcat (itoa bpZ) " " (itoa epZ) " " (itoa erpZ) " " (rtos sbPThk 2 2) " " (itoa spZ) " "
							      (rtos bPThk 2 2)  " " (itoa stZ) " " (rtos aPThk 2 2) " " (itoa rpZ) " " (itoa tpZ)))))))
  (command "line" cPT1 cPT3 "")
  (mxdata (entlast) ExData1)
  (command "line" cPT2 cPT4 "")
  (mxdata (entlast) ExData2)
;--------------------------------------------------------
  (command "line" (polar cgpnPT1 0          (+ (/ gpnHD1 2.0) 2)) (polar cgpnPT1 pi         (+ (/ gpnHD1 2.0) 2)) ""
	   "line" (polar cgpnPT1 (* pi 0.5) (+ (/ gpnHD1 2.0) 2)) (polar cgpnPT1 (* pi 1.5) (+ (/ gpnHD1 2.0) 2)) ""
           "line" (polar cgpnPT2 0          (+ (/ gpnHD1 2.0) 2)) (polar cgpnPT2 pi         (+ (/ gpnHD1 2.0) 2)) ""
	   "line" (polar cgpnPT2 (* pi 0.5) (+ (/ gpnHD1 2.0) 2)) (polar cgpnPT2 (* pi 1.5) (+ (/ gpnHD1 2.0) 2)) ""
           "line" (polar cgpnPT3 0          (+ (/ gpnHD1 2.0) 2)) (polar cgpnPT3 pi         (+ (/ gpnHD1 2.0) 2)) ""
	   "line" (polar cgpnPT3 (* pi 0.5) (+ (/ gpnHD1 2.0) 2)) (polar cgpnPT3 (* pi 1.5) (+ (/ gpnHD1 2.0) 2)) ""
           "line" (polar cgpnPT4 0          (+ (/ gpnHD1 2.0) 2)) (polar cgpnPT4 pi         (+ (/ gpnHD1 2.0) 2)) ""
	   "line" (polar cgpnPT4 (* pi 0.5) (+ (/ gpnHD1 2.0) 2)) (polar cgpnPT4 (* pi 1.5) (+ (/ gpnHD1 2.0) 2)) ""
  )
  (command "line" (polar crpnPT1 0          (+ (/ rpnD 2.0) 2)) (polar crpnPT1 pi         (+ (/ rpnD 2.0) 2)) ""
	   "line" (polar crpnPT1 (* pi 0.5) (+ (/ rpnD 2.0) 2)) (polar crpnPT1 (* pi 1.5) (+ (/ rpnD 2.0) 2)) ""
           "line" (polar crpnPT2 0          (+ (/ rpnD 2.0) 2)) (polar crpnPT2 pi         (+ (/ rpnD 2.0) 2)) ""
	   "line" (polar crpnPT2 (* pi 0.5) (+ (/ rpnD 2.0) 2)) (polar crpnPT2 (* pi 1.5) (+ (/ rpnD 2.0) 2)) ""
           "line" (polar crpnPT3 0          (+ (/ rpnD 2.0) 2)) (polar crpnPT3 pi         (+ (/ rpnD 2.0) 2)) ""
	   "line" (polar crpnPT3 (* pi 0.5) (+ (/ rpnD 2.0) 2)) (polar crpnPT3 (* pi 1.5) (+ (/ rpnD 2.0) 2)) ""
           "line" (polar crpnPT4 0          (+ (/ rpnD 2.0) 2)) (polar crpnPT4 pi         (+ (/ rpnD 2.0) 2)) ""
	   "line" (polar crpnPT4 (* pi 0.5) (+ (/ rpnD 2.0) 2)) (polar crpnPT4 (* pi 1.5) (+ (/ rpnD 2.0) 2)) ""
  )
  (if (and TapHaD TapHbD) 
    (command "line" (polar aTapPT (* pi 0.5) 5) (polar aTapPT5 (* pi 1.5) 4) ""
	     "line" (polar bTapPT (* pi 0.5) 5) (polar bTapPT5 (* pi 1.5) 4) ""
    )
  )
;------------------------------------
;Dim
;------------------------------------
  (setvar "clayer" "dim")
  (command "dim"
           "ver" (polar (polar V1BasePt (* pi 1.5) scr3Y) pi (+ 2 (/ scr3D2 2.0) scr3X)) (polar (polar V1BasePt (* pi 0.5) scr3Y) pi (+ 2 (/ scr3D2 2.0) scr3X))
	         (polar v1BasePt pi (+ tpX 17)) (strcat (itoa (* scr3Y 2)) " S.C.H.S")
           "ver" (polar (polar V1BasePt (* pi 1.5) gpnY) pi (+ 2 (/ gpnHD1 2.0) gpnX)) (polar (polar V1BasePt (* pi 0.5) gpnY) pi (+ 2 (/ gpnHD1 2.0) gpnX))
	         (polar v1BasePt pi (+ tpX 26)) (strcat (itoa (* gpnY 2)) " LEADER PIN")
           "ver" (polar (polar V1BasePt (* pi 1.5) scr1Y) pi (+ 2 (/ scr1D2 2.0) scr1X)) (polar (polar V1BasePt (* pi 0.5) scr1Y) pi (+ 2 (/ scr1D2 2.0) scr1X))
	         (polar v1BasePt pi (+ tpX 35)) (strcat (itoa (* scr1Y 2)) " S.C.H.S")
           "ver" tpPT2 tpPT3 (polar v1BasePt pi (+ tpX 44)) (itoa (* tpY 2))

           "ver" (polar (polar V1BasePt (* pi 1.5) rpnY) 0 (+ 2 (/ rpnD 2.0) rpnX)) (polar (polar V1BasePt (* pi 0.5) rpnY) 0 (+ 2 (/ rpnD 2.0) rpnX))
	         (polar v1BasePt 0 (+ tpX 17)) (strcat (itoa (* rpnY 2)) " RETURN PIN")
           "ver" (polar (polar V1BasePt (* pi 1.5) (- gpnY 2)) 0 (+ 2 (/ gpnHD1 2.0) gpnX)) (polar v1BasePt 0 (+ tpX 5)) 
    	         (polar (polar V1BasePt (* pi 1.5) (/ gpnY 2.0)) 0 (+ tpX 8)) (strcat (itoa (- gpnY 2)) " OFFSET")
           "ver" (polar (polar V1BasePt (* pi 0.5) gpnY) 0 (+ 2 (/ gpnHD1 2.0) gpnX)) (polar v1BasePt 0 (+ tpX 5)) 
    	         (polar (polar V1BasePt (* pi 0.5) (/ gpnY 2.0)) 0 (+ tpX 8)) (itoa gpnY)

           "hor" (polar (polar V1BasePt pi rpnX) (* pi 0.5) (+ 2 (/ rpnD 2.0) rpnY)) (polar (polar V1BasePt 0 rpnX) (* pi 0.5) (+ 2 (/ rpnD 2.0) rpnY))
	         (polar v1BasePt (* pi 0.5) (+ tpY 10)) (strcat (itoa (* rpnX 2)) " RETURN PIN")
           "hor" (polar (polar V1BasePt pi scr1X) (* pi 0.5) (+ 2 (/ scr1D2 2.0) scr1Y)) (polar (polar V1BasePt 0 scr1X) (* pi 0.5) (+ 2 (/ scr1D2 2.0) scr1Y))
	         (polar v1BasePt (* pi 0.5) (+ tpY 18)) (strcat (itoa (fix (* scr1X 2))) " S.C.H.S")

           "hor" (polar (polar V1BasePt pi gpnX) (* pi 0.5) (+ 2 (/ gpnHD1 2.0) gpnY)) (polar (polar V1BasePt 0 gpnX) (* pi 0.5) (+ 2 (/ gpnHD1 2.0) gpnY))
	         (polar v1BasePt (* pi 0.5) (+ tpY 26)) (strcat(itoa (* gpnX 2)) " LEADER PIN")
           "hor" (polar (polar V1BasePt pi scr2X) (* pi 0.5) (+ 2 (/ scr2D2 2.0) scr3Y)) (polar (polar V1BasePt 0 scr3X) (* pi 0.5) (+ 2 (/ scr2D2 2.0) scr2Y))
	         (polar v1BasePt (* pi 0.5) (+ tpY 34)) (strcat (itoa (fix (* scr2X 2))) " S.C.H.S")

           "hor" epPT3 epPT4 (polar v1BasePt (* pi 1.5) (+ tpY 10)) (itoa (* epX 2))
           "hor" sbPT3 sbPT4 (polar (polar sbPT3 0 (/ (- sbX2 sbX1) 2)) (* pi 1.5) 10) (itoa (- sbX2 sbX1))
           "hor" sbPT7 sbPT8 (polar (polar sbPT8 0 (/ (- sbX2 sbX1) 2)) (* pi 1.5) 10) (itoa (- sbX2 sbX1))
	   "exit"
  )
  (if (= scr3Num 16)
    (command "dim"
             "ver" (polar (polar V1BasePt (* pi 1.5) scr3Y2) pi (+ 2 (/ scr3D2 2.0) scr3X)) (polar (polar V1BasePt (* pi 0.5) scr3Y2) pi (+ 2 (/ scr3D2 2.0) scr3X))
	           (polar v1BasePt pi (+ tpX 8)) (strcat (itoa (* scr3Y2 2)) " S.C.H.S")
	     "exit"
    )
  )
  (if (> tpX cpX)
    (command "dim"
             "hor" tpPT1 tpPT2 (polar v1BasePt (* pi 0.5) (+ tpY 42)) (itoa (* tpX 2))
	     "exit"
    )
  )
  (setq ofPT1 (polar cgpnPT4 -0.7854 (/ (+ (- cpY gpnY -2) 30) (sin 0.7854)))
	ofPT2 (polar ofPT1 0 37)
  )
  (command "line" cgpnPT4 ofPT1 ofPT2 "")
  (command "text" "s" "lxy3" (polar ofPT1 (* pi 0.5) 1) "" "OFFSET")
  (command "text" "s" "lxy3" "j" "c" (polar V1BasePt (* pi 1.5) (+ cpY 45)) 0 "EJ. SIDE PLAN VIEW" "")
)

;######################################################################################################################################################
(defun drawSGMoldView2(/ bpPt ep1Pt ep2Pt erpPt b1Pt b2Pt a1Pt a2Pt sbpt spPt stPt tpPt)
  (setq bpPt  (polar V2BasePt pi bpZ)
	ep1Pt (polar bpPt  pi 5)
	ep2Pt (polar ep1Pt pi epZ)
	erpPt (polar ep2Pt pi erpZ)
	b1Pt  (polar bpPt  pi (+ sbPThk spZ))
	b2Pt  (polar b1Pt  pi bPThk)
	a1Pt  (polar b2Pt  pi (+ 1 stZ))
	a2Pt  (polar a1Pt  pi aPThk)
	sbPt  (polar bpPt  pi sbPThk)
  )
  (if (> spZ 0)
    (setq spPt sbpt)
  ) 
  (if (> stZ 0)
    (setq stPt (polar b2Pt pi 1))
  )
  (if (> tpZ 0)
    (setq tpPt (polar a2Pt pi tpZ))
  )
  (setq rpPt  (list (car ep2Pt) (- (cadr V2BasePt) rpnY) 0.0))
  (setq rpPT1 (polar (polar b1Pt 0 spZ) (* pi 1.5) (- rpnY (/ rpnD 2.0)))
	rpPT2 (polar rpPT1 (* pi 1.5) rpnD)
	rpPT3 (polar b1Pt  (* pi 1.5) (- rpnY (/ rpnD 2.0)))
	rpPT4 (polar rpPT3 (* pi 1.5) rpnD)
  ) 

  (setvar "clayer" "continuous")
  (command "line" (polar V2BasePt (* pi 0.5) tpY) (polar bpPt (* pi 0.5) tpY) (polar bpPt (* pi 1.5) tpY) (polar V2BasePt (* pi 1.5) tpY) "")

  (command "line" (polar bpPt (* pi 0.5) cpY) (polar sbPt (* pi 0.5) cpY) rpPT1 ""
	   "line" rpPT2  (polar sbPt (* pi 1.5) cpY) (polar bpPt (* pi 1.5) cpY) ""
  )

  (command "line" (polar ep1Pt (* pi 0.5) cpY) (polar ep1Pt (* pi 1.5) cpY) ""
           "line" (polar ep2Pt (* pi 0.5) cpY) (polar ep2Pt (* pi 1.5) cpY) ""
	   "line" (polar ep2Pt (* pi 0.5) cpY) (polar erpPt (* pi 0.5) cpY) (polar erpPt (* pi 1.5) (- rpnY (/ rpnD 2.0))) ""
	   "line" (polar erpPt (* pi 1.5) (+ rpnY (/ rpnD 2.0))) (polar erpPt (* pi 1.5) cpY) (polar ep2Pt (* pi 1.5) cpY) ""
  )

  (command "line" rpPT3 (polar b1Pt (* pi 0.5) cpY) (polar b2Pt (* pi 0.5) cpY) (polar b2Pt (* pi 1.5) (- rpnY (/ rpnD 2.0))) ""
	   "line" (polar b2Pt (* pi 1.5) (+ rpnY (/ rpnD 2.0))) (polar b2Pt (* pi 1.5) cpY) (polar b1Pt (* pi 1.5) cpY) rpPT4 ""
  )

  (command "line" (polar a1Pt (* pi 0.5) cpY) (polar a2Pt (* pi 0.5) cpY) (polar a2Pt (* pi 1.5) cpY) (polar a1Pt (* pi 1.5) cpY) "c")

  (command "line" (polar ep1Pt (* pi 1.5) (- rpnY 7)) (polar (polar ep1Pt (* pi 1.5) (- rpnY 8)) 0 1) (polar (polar ep1Pt (* pi 1.5) (- rpnY 8)) 0 5)
		  (polar (polar ep1Pt (* pi 1.5) (+ rpnY 8)) 0 5) (polar (polar ep1Pt (* pi 1.5) (+ rpnY 8)) 0 1) (polar ep1Pt (* pi 1.5) (+ rpnY 7)) ""
	   "line" (polar (polar ep1Pt (* pi 1.5) (- rpnY 8)) 0 1) (polar (polar ep1Pt (* pi 1.5) (+ rpnY 8)) 0 1) ""
	   "line" (polar bpPt (* pi 1.5) (- rpnY 4)) (polar V2BasePt (* pi 1.5) (- rpnY 4)) ""
	   "line" (polar bpPt (* pi 1.5) (+ rpnY 4)) (polar V2BasePt (* pi 1.5) (+ rpnY 4)) ""
	   "line" (polar (polar bpPt (* pi 1.5) (- rpnY 4)) 0 9)  (polar (polar bpPt (* pi 1.5) (- rpnY 3)) 0 10)
		  (polar (polar bpPt (* pi 1.5) (+ rpnY 3)) 0 10) (polar (polar bpPt (* pi 1.5) (+ rpnY 4)) 0 9) ""
	   "line" (polar (polar bpPt (* pi 1.5) (- rpnY 4)) 0 9)  (polar (polar bpPt (* pi 1.5) (+ rpnY 4)) 0 9) ""
  )

  (if spPt
    (command "line" (polar sbPt (* pi 0.5) cpY) (polar b1Pt (* pi 0.5) cpY) ""
	     "line" (polar sbPt (* pi 1.5) cpY) (polar b1Pt (* pi 1.5) cpY) ""
    )
  )
  (if stPt
    (command "line" (polar b2Pt (* pi 0.5) cpY) (polar a1Pt (* pi 0.5) cpY) ""
	     "line" (polar b2Pt (* pi 1.5) cpY) (polar a1Pt (* pi 1.5) cpY) ""
	     "line" (polar stPt (* pi 0.5) cpY) (polar stPt (* pi 1.5) cpY) ""
    )
  )
  (if tpPt
    (command "line" (polar a2Pt (* pi 0.5) tpY) (polar tpPt (* pi 0.5) tpY) 
	            (polar tpPt (* pi 1.5) tpY) (polar a2Pt (* pi 1.5) tpY) "c"
    )
  )
  (if (> rpnD 21)
    (setq rpnH 8)
    (setq rpnH 4)
  )
  (setq rpPT5  (polar rpPt  (* pi 0.5) (/ (+ rpnD 5) 2.0))
	rpPT6  (polar rpPt  (* pi 1.5) (/ (+ rpnD 5) 2.0))
	rpPT7  (polar rpPT5 (* pi 0.5) 1)
	rpPT8  (polar rpPT6 (* pi 1.5) 1)
      	rpPT9  (polar (polar rpPt (* pi 0.5) (/ rpnD 2.0)) pi rpnH)
      	rpPT10 (polar (polar rpPt (* pi 1.5) (/ rpnD 2.0)) pi rpnH)
  )
  (command "line" rpPT7 (polar rpPT7 pi rpnH) (polar rpPT8 pi rpnH) rpPT8 ""
	   "line" rpPT5 (polar rpPT5 pi rpnH) ""
	   "line" rpPT6 (polar rpPT6 pi rpnH) ""
  )
  (command "line" rpPT9  (polar (polar b2Pt (* pi 1.5) (- rpnY (/ rpnD 2.0))) pi 1) ""
           "line" rpPT10 (polar (polar b2Pt (* pi 1.5) (+ rpnY (/ rpnD 2.0))) pi 1) ""
  )

  (if (and TapHaD TapHbD)
    (progn
      (setq aTapPt  (polar (polar a1Pt (* pi 0.5) cpY) pi (/ aPThk 2))
	    aTapPT1 (polar aTapPt pi (/ TapHaD 2.0))
	    aTapPT2 (polar aTapPt pi (/ (* 0.8 TapHaD) 2))
	    aTapPT4 (polar aTapPt 0  (/ TapHaD 2.0))
	    aTapPT3 (polar aTapPt 0  (/ (* 0.8 TapHaD) 2))
	    aTapPT5 (polar aTapPt (* pi 1.5) TapHaL)
	    aTapPT6 (polar aTapPT5 2.618  (/ (* TapHaD 0.4) (cos 0.5236)))
	    aTapPT7 (polar aTapPT5 0.5236 (/ (* TapHaD 0.4) (cos 0.5236)))

	    bTapPT  (polar (polar b1Pt (* pi 0.5) cpY) pi (/ bPThk 2))
	    bTapPT1 (polar bTapPt pi (/ TapHbD 2.0))
	    bTapPT2 (polar bTapPt pi (/ (* 0.8 TapHbD) 2))
	    bTapPT4 (polar bTapPt 0  (/ TapHbD 2.0))
	    bTapPT3 (polar bTapPt 0  (/ (* 0.8 TapHbD) 2))
	    bTapPT5 (polar bTapPt (* pi 1.5) TapHbL)
	    bTapPT6 (polar bTapPT5 2.618  (/ (* TapHbD 0.4) (cos 0.5236)))
	    bTapPT7 (polar bTapPT5 0.5236 (/ (* TapHbD 0.4) (cos 0.5236)))
      )
      (command "line" aTapPT1 (polar aTapPT1 (* pi 1.5) TapHaI) (polar aTapPT4 (* pi 1.5) TapHaI) aTapPT4 ""
	       "line" aTapPT2 aTapPT6 aTapPT5 aTapPT7 aTapPT3 ""
	       "line" aTapPT6 aTapPT7 ""
	       "line" bTapPT1 (polar bTapPT1 (* pi 1.5) TapHbI) (polar bTapPT4 (* pi 1.5) TapHbI) bTapPT4 ""
	       "line" bTapPT2 bTapPT6 bTapPT5 bTapPT7 bTapPT3 ""
	       "line" bTapPT6 bTapPT7 ""
      )
    )
  )
  (if (= "1" IfAddSpg)
    (progn
      (command "line" (polar sbPt (* pi 1.5) (- rpnY (+ (/ SpgOd 2.0) 1))) (polar (polar sbPt (* pi 1.5) (- rpnY (+ (/ SpgOd 2.0) 1))) pi SpgHolDep)
		      (polar (polar sbPt (* pi 1.5) (+ rpnY (+ (/ SpgOd 2.0) 1))) pi SpgHolDep) (polar sbPt (* pi 1.5) (+ rpnY (+ (/ SpgOd 2.0) 1))) ""
      )
      (setvar "clayer" "spring")
      (load "MoldSpgC")
      (MoldSpgCst (polar erpPt (* pi 1.5) rpnY) (polar (polar sbPt (* pi 1.5) rpnY) pi SpgHolDep) SpgTyp SpgLen SpgOd SpgId SpgA SpgB "0")
    )
  )
;----------------------------------------------------------------
;Defun Extent Entry Data
;----------------------------------------------------------------
  (setvar "clayer" "continuous")
  (setq ExData1 (list (list -3 (list "V2X" (cons 1000 " ")))))
  (setq ExData2 (list (list -3 (list "V2Y" (cons 1000 " ")))))

  (command "line" (polar V2BasePt (* pi 0.5) tpY) (polar V2BasePt (* pi 1.5) tpY) "")
  (mxdata (entlast) ExData2)

  (setvar "clayer" "center")
  (command "line" (polar V2BasePt 0 8) (polar V2BasePt pi (+ bpZ sbPThk stZ spZ aPThk bPThk tpZ 8)) "")
  (mxdata (entlast) ExData1)
;----------------------------------------------------------------
  (command "line" (polar rpPt 0 4) (polar (polar b2Pt (* pi 1.5) rpnY) pi 4) "")
  (if (and TapHaD TapHbD) 
    (command "line" (polar aTapPT (* pi 0.5) 5) (polar aTapPT5 (* pi 1.5) 4) ""
	     "line" (polar bTapPT (* pi 0.5) 5) (polar bTapPT5 (* pi 1.5) 4) ""
    )
  )
  (command "line" (polar (polar bpPt (* pi 1.5) rpnY) pi 8) (polar (polar V2BasePt (* pi 1.5) rpnY) 0 3) "")
;-------------------------------------------
;dim
;-------------------------------------------
  (setvar "clayer" "dim")
  (command "dim"
	   "hor" (polar (polar V2BasePt pi (+ bpZ sbPThk bPThk aPThk rpZ spZ stZ tpZ 1.0)) (* pi 1.5) cpY) (polar V2BasePt (* pi 1.5) cpY) 
		 (polar (polar V2BasePt pi (/ (+ bpZ sbPThk bPThk aPThk rpZ spZ stZ tpZ 1.0) 2.0))  (* pi 1.5) (+ cpY 10)) 
		 (itoa (fix (+ bpZ sbPThk bPThk aPThk rpZ spZ stZ tpZ 1)))
	   "hor" (polar a2Pt (* pi 0.5) cpY) (polar a1Pt (* pi 0.5) cpY) (polar (polar a2Pt 0 (/ aPThk 2.0))  (* pi 0.5) (+ cpY 19)) aP
	   "hor" (polar b2Pt (* pi 0.5) cpY) (polar b1Pt (* pi 0.5) cpY) (polar (polar b2Pt 0 (/ bPThk 2.0))  (* pi 0.5) (+ cpY 19)) bP
	   "hor" (polar sbPt (* pi 0.5) cpY) (polar bpPt (* pi 0.5) cpY) (polar (polar sbPt 0 (/ sbPThk 2.0)) (* pi 0.5) (+ cpY 19)) sbP
	   "hor" (polar bpPt (* pi 0.5) cpY) (polar v2BasePt (* pi 0.5) cpY) (polar (polar bpPt 0 (/ bpZ 2.0)) (* pi 0.5) (+ cpY 19)) (itoa bpZ)
	   "hor" (polar ep2Pt (* pi 0.5) cpY) (polar erpPt (* pi 0.5) cpY) (polar (polar erpPt 0 (/ erpZ 2.0))  (* pi 0.5) (+ cpY 10)) (itoa erpZ)
	   "hor" (polar ep2Pt (* pi 0.5) cpY) (polar ep1Pt (* pi 0.5) cpY) (polar (polar ep2Pt 0 (/ epZ 2.0))  (* pi 0.5) (+ cpY 10)) (itoa epZ)
	   "hor" (polar ep1Pt (* pi 0.5) cpY) (polar bpPt (* pi 0.5) cpY) (polar (polar ep1Pt 0 2.5)  (* pi 0.5) (+ cpY 10)) "5"
 	   "exit"
  )
  (if (> tpZ 1)
    (command "dim"
	     "hor" (polar tpPt (* pi 0.5) cpY) (polar a2Pt (* pi 0.5) cpY) (polar (polar tpPt 0 (/ tpZ 2.0))  (* pi 0.5) (+ cpY 19)) (itoa tpZ)
	     "exit"
    )
  )
  (if (> spZ 1)
    (command "dim"
	     "hor" (polar b1Pt (* pi 0.5) cpY) (polar spPt (* pi 0.5) cpY) (polar (polar b1Pt 0 (/ spZ 2.0))  (* pi 0.5) (+ cpY 19)) (itoa spZ)
	     "exit"
    )
  )
  (if (> stZ 1)
    (command "dim"
	     "hor" (polar a1Pt (* pi 0.5) cpY) (polar stPt (* pi 0.5) cpY) (polar (polar a1Pt 0 (/ stZ 2.0))  (* pi 0.5) (+ cpY 19)) (itoa stZ)
	     "exit"
    )
  )
  (command "text" "s" "lxy3" "j" "c" (polar (polar V2BasePt (* pi 1.5) (+ cpY 45)) pi (/ (+ tpZ sbPThk spZ bPThk stZ aPThk tpZ) 2)) "" "SECTION A - A")
  (setq lhPT1 (polar (polar aTapPt (* pi 0.75) (/ 60 (sin 0.7854))) pi 35)
	lhPT2 (polar lhPT1 (* pi 1.5) 10) 
	lhPT3 (polar lhPT2 (* pi 1.5) 10) 
	lhPT4 (polar lhPT3 (* pi 1.5) 10) 
  )
  (command "line" aTapPt (polar lhPT1 0 35) lhPT1 ""
 	   "line" lhPT2  (polar lhPT2 0 35) ""
 	   "line" lhPT3  (polar lhPT3 0 35) ""
 	   "line" lhPT4  (polar lhPT4 0 35) ""
  )
  (command "text" "s" "lxy4" (polar (polar lhPT1 (* pi 0.5) 1) 0 1.5) "" "LIFT HOLE"
	   "text" "s" "lxy4" (polar (polar lhPT2 (* pi 0.5) 1) 0 1.5) "" "DR.& TAP."
	   "text" "s" "lxy4" (polar (polar lhPT3 (* pi 0.5) 1) 0 1.5) "" (strcat "M" (itoa TapHaD) "X" (itoa TapHaL))
	   "text" "s" "lxy4" (polar (polar lhPT4 (* pi 0.5) 1) 0 1.5) "" "TAP. 4"
  )
)

;#############################################################################################################################################
(defun drawSGMoldView3()
  (setq tpPT1 (polar (polar V3BasePt 0 tpX) (* pi 0.5) tpY)
	tpPT2 (polar tpPT1 pi (* tpX 2.0))
	tpPT3 (polar tpPT2 (* pi 1.5) (* tpY 2.0))
	tpPT4 (polar tpPT3 0  (* tpX 2.0))
  )
  (setq sbPT1 (polar (polar V3BasePt 0 sbX2) (* pi 0.5) sbY)
	sbPT2 (polar (polar V3BasePt 0 sbX1) (* pi 0.5) sbY)
        sbPT3 (polar sbPT2  (* pi 1.5) (* sbY 2.0))
        sbPT4 (polar sbPT1  (* pi 1.5) (* sbY 2.0))
	sbPT5 (polar (polar V3BasePt pi sbX1) (* pi 0.5) sbY)
	sbPT6 (polar (polar V3BasePt pi sbX2) (* pi 0.5) sbY)
        sbPT7 (polar sbPT6  (* pi 1.5) (* sbY 2.0))
        sbPT8 (polar sbPT5  (* pi 1.5) (* sbY 2.0))
  )
  (setq cPT1 (polar V3BasePt 0 (+ tpX 5))
	cPT2 (polar V3BasePt (* pi 0.5) (+ tpY 5))
	cPT3 (polar V3BasePt pi (+ tpX 5))
	cPT4 (polar V3BasePt (* pi 1.5) (+ tpY 5))
  )
  (setq cgpnPT1 (polar (polar V3BasePt 0 gpnX) (* pi 0.5) gpnY)
	cgpnPT2 (polar cgpnPT1 pi (* gpnX 2))
	cgpnPT4 (polar cgpnPT1 (* pi 1.5) (* gpnY 2))
	cgpnPT3 (polar cgpnPT2 (* pi 1.5) (- (* gpnY 2) 2))
  )
  (setvar "clayer" "continuous")
  (if (= "I" (substr MoldTypeNum 2 1))
    (progn
      (command "line" tpPT1 tpPt2 tpPT3 tpPT4 "c")
      (command "line" sbPT1 sbPT4 ""
	       "line" sbPT6 sbPT7 "")
    )
    (command "line" sbPT1 sbPT6 sbPT7 sbPT4 "c")
  )
  (command "circle" cgpnPT1 (/ gpnD 2)
	   "circle" cgpnPT2 (/ gpnD 2.0)
	   "circle" cgpnPT3 (/ gpnD 2.0)
	   "circle" cgpnPT4 (/ gpnD 2.0)
  )
  (setvar "clayer" "hidden")
  (if (and TapHaD TapHbD)
    (progn
      (setq aTapPt  (polar V3BasePt (* pi 0.5) cpY)
	    aTapPT1 (polar aTapPt pi (/ TapHaD 2.0))
	    aTapPT2 (polar aTapPt pi (/ (* 0.8 TapHaD) 2))
	    aTapPT4 (polar aTapPt 0  (/ TapHaD 2.0))
	    aTapPT3 (polar aTapPt 0  (/ (* 0.8 TapHaD) 2))
	    aTapPT5 (polar aTapPt (* pi 1.5) TapHaL)
	    aTapPT6 (polar aTapPT5 2.618 (/ (* TapHaD 0.4) (cos 0.5236)))
	    aTapPT7 (polar aTapPT5 0.5236 (/ (* TapHaD 0.4) (cos 0.5236)))

	    bTapPT  (polar V3BasePt (* pi 1.5) cpY)
	    bTapPT1 (polar bTapPt pi (/ TapHbD 2.0))
	    bTapPT2 (polar bTapPt pi (/ (* 0.8 TapHbD) 2))
	    bTapPT4 (polar bTapPt 0  (/ TapHbD 2.0))
	    bTapPT3 (polar bTapPt 0  (/ (* 0.8 TapHbD) 2))
	    bTapPT5 (polar bTapPt (* pi 0.5) TapHbL)
	    bTapPT6 (polar bTapPT5 3.6552  (/ (* TapHbD 0.4) (cos 0.5236)))
	    bTapPT7 (polar bTapPT5 -0.5236 (/ (* TapHbD 0.4) (cos 0.5236)))
      )
      (command "line" aTapPT1 (polar aTapPT1 (* pi 1.5) TapHaI) (polar aTapPT4 (* pi 1.5) TapHaI) aTapPT4 ""
	       "line" aTapPT2 aTapPT6 aTapPT5 aTapPT7 aTapPT3 ""
	       "line" aTapPT6 aTapPT7 ""
	       "line" bTapPT1 (polar bTapPT1 (* pi 0.5) TapHbI) (polar bTapPT4 (* pi 0.5) TapHbI) bTapPT4 ""
	       "line" bTapPT2 bTapPT6 bTapPT5 bTapPT7 bTapPT3 ""
	       "line" bTapPT6 bTapPT7 ""
      )
    )
  )
  (setvar "clayer" "center")
;-------------------------------------------------------------
;Defun Extent data
;-------------------------------------------------------------
  (setq ExData1 (list (list -3 (list "V3X" (cons 1000 " ")))))
  (setq ExData2 (list (list -3 (list "V3Y" (cons 1000 " ")))))
  (command "line" cPT1 cPT3 "")
  (mxdata (entlast) ExData1)
  (command "line" cPT2 cPT4 "")
  (mxdata (entlast) ExData2)
;-------------------------------------------------------------
  (command "line" (polar cgpnPT1 0          (+ (/ gpnD 2.0) 2)) (polar cgpnPT1 pi         (+ (/ gpnD 2.0) 2)) ""
	   "line" (polar cgpnPT1 (* pi 0.5) (+ (/ gpnD 2.0) 2)) (polar cgpnPT1 (* pi 1.5) (+ (/ gpnD 2.0) 2)) ""
           "line" (polar cgpnPT2 0          (+ (/ gpnD 2.0) 2)) (polar cgpnPT2 pi         (+ (/ gpnD 2.0) 2)) ""
	   "line" (polar cgpnPT2 (* pi 0.5) (+ (/ gpnD 2.0) 2)) (polar cgpnPT2 (* pi 1.5) (+ (/ gpnD 2.0) 2)) ""
           "line" (polar cgpnPT3 0          (+ (/ gpnD 2.0) 2)) (polar cgpnPT3 pi         (+ (/ gpnD 2.0) 2)) ""
	   "line" (polar cgpnPT3 (* pi 0.5) (+ (/ gpnD 2.0) 2)) (polar cgpnPT3 (* pi 1.5) (+ (/ gpnD 2.0) 2)) ""
           "line" (polar cgpnPT4 0          (+ (/ gpnD 2.0) 2)) (polar cgpnPT4 pi         (+ (/ gpnD 2.0) 2)) ""
	   "line" (polar cgpnPT4 (* pi 0.5) (+ (/ gpnD 2.0) 2)) (polar cgpnPT4 (* pi 1.5) (+ (/ gpnD 2.0) 2)) ""
  )
;-------------------------------------------------------------
;dim
;-------------------------------------------------------------
  (setvar "clayer" "dim")
  (setq ofPT1 (polar cgpnPT3 3.927 (/ (+ (- cpY gpnY -2) 30) (sin 0.7854)))
	ofPT2 (polar ofPT1 pi 37)
  )
  (command "line" cgpnPT3 ofPT1 ofPT2 "")
  (command "text" "s" "lxy3" (polar ofPT2 (* pi 0.5) 1) "" "OFFSET")
  (command "text" "s" "lxy3" "j" "c" (polar V3BasePt (* pi 1.5) (+ cpY 45)) "" "HOT SIDE PLAN VIEW")
)

;#################################################################################################################################################
(defun drawSGMoldView4()
  (setq bpPt  (polar V4BasePt (* 0.5 pi) bpZ)
	ep1Pt (polar bpPt  (* 0.5 pi) 5)
	ep2Pt (polar ep1Pt (* 0.5 pi) epZ)
	erpPt (polar ep2Pt (* 0.5 pi) erpZ)
	b1Pt  (polar bpPt  (* 0.5 pi) (+ sbPThk spZ))
	b2Pt  (polar b1Pt  (* 0.5 pi) bPThk)
	a1Pt  (polar b2Pt  (* 0.5 pi) (+ 1 stZ))
	a2Pt  (polar a1Pt  (* 0.5 pi) aPThk)
	sbPt  (polar bpPt  (* 0.5 pi) sbPThk)
  )
  (if (> spZ 1)
    (setq spPt sbpt)
    (setq spPt nil)
  ) 
  (if (> stZ 1)
    (setq stPt (polar b2Pt (* 0.5 pi) 1))
    (setq stPt nil)
  )
  (if (> tpZ 1)
    (setq tpPt (polar a2Pt (* 0.5 pi) tpZ))
    (setq tpPt nil)
  )
  (setq gpnDD1 (+ gpnD 5)
	gpnDH  (nth (xh_get gpnD gpnHDLst) gpnDHLst)
	gpnHD1 (nth (xh_get gpnD gpnHDLst) gpnHD1Lst)
	gpnHDD (nth (xh_get gpnD gpnHDLst) gpnHDDLst)
	gpnHH  (nth (xh_get gpnD gpnHDLst) gpnHHLst)
	gpnL   (- (+ aPThk stZ bPThk 1) (+ gpnDH (* gpnD 0.1)))
  )
  (setq gpnPt   (polar a2Pt pi gpnX)
	gpnPT1  (polar gpnPt pi (/ gpnDD1 2.0))
	gpnPT2  (polar gpnPt 0  (/ gpnDD1 2.0))
	gpnPT3  (polar (polar gpnPt pi (/ gpnD 2.0)) (* pi 1.5) gpnDH)
	gpnPT4  (polar (polar gpnPt 0  (/ gpnD 2.0)) (* pi 1.5) gpnDH)
	gpnPT5  (polar gpnPT3 (* pi 1.5) (- gpnL gpnDH))
	gpnPT6  (polar gpnPT4 (* pi 1.5) (- gpnL gpnDH))
	gpnPT8  (polar b1Pt pi (+ gpnX (/ gpnHDD 2.0)))
	gpnPT7  (polar gpnPT8 pi 1)
	gpnPT9  (polar b1Pt pi (- gpnX (/ gpnHDD 2.0)))
	gpnPT10 (polar gpnPT9 0 1)
	gpnPT11 (polar (polar b1Pt pi (+ gpnX (/ gpnHD1 2.0))) (* pi 0.5) gpnHH)
	gpnPT12 (polar (polar b1Pt pi (- gpnX (/ gpnHD1 2.0))) (* pi 0.5) gpnHH)
	gpnPT13 (polar a1Pt pi (+ gpnX (/ gpnD 2.0)))
	gpnPT14 (polar a1Pt pi (- gpnX (/ gpnD 2.0)))
	gpnPT15 (polar b2Pt pi (+ gpnX (/ gpnD 2.0)))
	gpnPT16 (polar b2Pt pi (- gpnX (/ gpnD 2.0)))
  )
  (setvar "clayer" "continuous")
  (command "line" (polar V4BasePt 0 tpX) (polar bpPt 0 tpX) (polar bpPt pi tpX) (polar V4BasePt pi tpX) "")
  (command "line" (polar bpPt 0  sbX2) (polar sbPt 0  sbX2) (polar sbPt 0  sbX1) (polar bpPt 0  sbX1) "c"
	   "line" (polar bpPt pi sbX2) (polar sbPt pi sbX2) (polar sbPt pi sbX1) (polar bpPt pi sbX1) "c")
  (command "line" (polar ep1Pt 0 epX) (polar ep2Pt 0 epX) (polar ep2Pt pi epX) (polar ep1Pt pi epX) "c"
           "line" (polar ep2Pt 0 epX) (polar erpPt 0 epX) (polar erpPt pi epX) (polar ep2Pt pi epX) ""
  )
  (command "line" gpnPT15 (polar b2Pt pi cpX) (polar b1Pt pi cpX) (polar b1Pt 0 cpX) (polar b2Pt 0 cpX) gpnPT16 "")
  (command "line" gpnPT7  (polar gpnPT7  (* pi 0.5) gpnHH) gpnPT11 (polar gpnPT11 (* pi 0.5) (- bPThk gpnHH)) ""
	   "line" gpnPT8  (polar gpnPT8  (* pi 0.5) gpnHH) ""
	   "line" gpnPT9  (polar gpnPT9  (* pi 0.5) gpnHH) ""
	   "line" gpnPT10 (polar gpnPT10 (* pi 0.5) gpnHH) gpnPT12 (polar gpnPT12 (* pi 0.5) (- bPThk gpnHH)) ""
  )
  (command "line"  gpnPT1 (polar gpnPT1 (* pi 1.5) gpnDH) (polar gpnPT2 (* pi 1.5) gpnDH) gpnPT2 ""
	   "line"  gpnPT3 (polar gpnPT5 (* pi 1.5) (+ gpnDH (* gpnD 0.1))) ""
	   "line"  gpnPT4 (polar gpnPT6 (* pi 1.5) (+ gpnDH (* gpnD 0.1))) ""
	   "pline" gpnPT5 "a" "ce" (polar gpnPT5 0 (* gpnD 0.1)) (polar (polar gpnPT5 0 (* gpnD 0.1)) (* pi 1.5) (* gpnD 0.1)) "l" 
		   (polar (polar gpnPT6 pi (* gpnD 0.1)) (* pi 1.5) (* gpnD 0.1)) "a" "ce" (polar gpnPT6 pi (* gpnD 0.1)) gpnPT6 ""
  )
  (command "line" gpnPT14 (polar a1Pt 0 cpX) (polar a2Pt 0 cpX) (polar a2Pt pi cpX) (polar a1Pt pi cpX) gpnPT13 "")
  (if spPt
    (command "line" (polar b1Pt pi cpX) (polar sbPt pi cpX) (polar sbPt 0 cpX) (polar b1Pt 0 cpX) "c")
  )
  (if stPt
    (command "line" (polar stPt pi (- gpnX (/ gpnHD1 2.0))) (polar a1Pt pi (- gpnX (/ gpnHD1 2.0))) ""
	     "line" (polar stPt pi (+ gpnX (/ gpnHD1 2.0))) (polar a1Pt pi (+ gpnX (/ gpnHD1 2.0))) ""
	     "line" (polar a1Pt pi cpX) (polar stPt pi cpX) (polar stPt pi (+ gpnX (/ gpnD 2.0))) ""
	     "line" (polar stPt pi (- gpnX (/ gpnD 2.0))) (polar stPt 0 cpX) (polar a2Pt 0 cpX) ""
    )
  )
  (if tpPt
    (command "line" (polar a2Pt 0 tpX) (polar tpPt 0 tpX) (polar tpPt pi tpX) (polar a2Pt pi tpX) "c")
  )
;---------------------------------------------------------------------
;Defun Extent Data
;---------------------------------------------------------------------
  (setq ExData1 (list (list -3 (list "V4X" (cons 1000 " ")))))
  (setq ExData2 (list (list -3 (list "V4Y" (cons 1000 " ")))))

  (command "line" (polar V4BasePt pi tpX) (polar V4BasePt 0 tpX) "")
  (mxdata (entlast) ExData1)

  (setvar "clayer" "center")
  (command "line" (polar V4BasePt (* pi 1.5) 10) (polar a2Pt (* pi 0.5) (+ tpZ 10)) "")
  (mxdata (entlast) ExData2)
;---------------------------------------------------------------------
  (command "line" (polar gpnPt (* pi 0.5) 5) (polar (polar b1Pt pi gpnX) (* pi 1.5) 5) "") 
  (setvar "clayer" "screw")
  (MoldCapCst (nth (xh_get scr2D scrMLst) scrMMlst) (+ bpZ (* 1.0 (nth (xh_get scr2D scrMLst) scrDLst)))
	      (polar V4BasePt pi scr2X) (polar bpPt pi scr2X) "0" nil)

  (MoldCapCst (nth (xh_get scr3D scrMLst) scrMMlst) (+ bpZ sbPThk spZ (* 1.5 (nth (xh_get scr3D scrMLst) scrDLst)))
	      (polar V4BasePt 0 scr3X) (polar b1Pt 0 scr3X) "1" nil)
  (MoldCapCst (nth (xh_get scr1D scrMLst) scrMMlst) (+ epZ (* 1.0 (nth (xh_get scr1D scrMLst) scrDLst)))
	      (polar ep1Pt 0 scr1X) (polar ep2Pt 0 scr1X) "1" (polar erpPt 0 scr1X))
;---------------------------------------------------------------------
;dim
;---------------------------------------------------------------------
  (setvar "clayer" "dim")
  (command "text" "s" "lxy3" "j" "c" (polar V4BasePt (* pi 1.5) 45) "" "SECTION B - B")
)

;*************************************************************************************************************************************;
;Three Plate Type Mold Base System
;*************************************************************************************************************************************;
(defun drawTPMoldView1()
  (setq tpPT1 (polar (polar V1BasePt 0 tpX) (* pi 0.5) tpY)
	tpPT2 (polar tpPT1 pi (* tpX 2))
	tpPT3 (polar tpPT2 (* pi 1.5) (* tpY 2))
	tpPT4 (polar tpPT3 0 (* tpX 2))
  )
  (setq sbPT1 (polar (polar V1BasePt 0 sbX2) (* pi 0.5) sbY)
	sbPT2 (polar (polar V1BasePt 0 sbX1) (* pi 0.5) sbY)
        sbPT3 (polar sbPT2 (* pi 1.5) (* sbY 2))
        sbPT4 (polar sbPT1 (* pi 1.5) (* sbY 2))
	sbPT5 (polar (polar V1BasePt pi sbX1) (* pi 0.5) sbY)
	sbPT6 (polar (polar V1BasePt pi sbX2) (* pi 0.5) sbY)
        sbPT7 (polar sbPT6 (* pi 1.5) (* sbY 2))
        sbPT8 (polar sbPT5 (* pi 1.5) (* sbY 2))
  )
  (setq epPT1 (polar (polar V1BasePt 0 epX) (* pi 0.5) epY)
	epPT2 (polar epPT1 pi (* epX 2))
	epPT3 (polar epPT2 (* pi 1.5) (* epY 2))
	epPT4 (polar epPT3 0 (* epX 2))
  )
  (setq cPT1 (polar V1BasePt 0 (+ tpX 5))
	cPT2 (polar V1BasePt (* pi 0.5) (+ tpY 5))
	cPT3 (polar V1BasePt pi (+ tpX 5))
	cPT4 (polar V1BasePt (* pi 1.5) (+ tpY 5))
  )
  (setq gpnHD1 (nth (xh_get gpnD gpnHDLst) gpnHD1Lst)
	cgpnPT1 (polar (polar V1BasePt 0 gpnX) (* pi 0.5) gpnY)
	cgpnPT2 (polar cgpnPT1 pi (* gpnX 2))
	cgpnPT3 (polar cgpnPT2 (* pi 1.5) (* gpnY 2))
	cgpnPT4 (polar cgpnPT1 (* pi 1.5) (- (* gpnY 2) 2))
  )
  (setq crpnPT1 (polar (polar V1BasePt 0 rpnX) (* pi 0.5) rpnY)
        crpnPT2 (polar crpnPT1 pi (* rpnX 2))
	crpnPT3 (polar crpnPT2 (* pi 1.5) (* rpnY 2))
	crpnPT4 (polar crpnPT1 (* pi 1.5) (* rpnY 2))
  )
  (setq scr1PT1 (polar (polar V1BasePt 0 scr1X) (* pi 0.5) scr1Y)
	scr1PT2 (polar scr1PT1 pi (* scr1X 2))
	scr1PT3 (polar scr1PT2 (* pi 1.5) (* scr1Y 2))
	scr1PT4 (polar scr1PT1 (* pi 1.5) (* scr1Y 2))
  )
  (setq scr2PT1 (polar (polar V1BasePt 0 scr2X) (* pi 0.5) scr2Y)
	scr2PT2 (polar scr2PT1 pi (* scr2X 2))
	scr2PT3 (polar scr2PT2 (* pi 1.5) (* scr2Y 2))
	scr2PT4 (polar scr2PT1 (* pi 1.5) (* scr2Y 2))
  )
  (cond
    ((= 4 scr3Num)
      (setq scr3PT1 (polar (polar V1BasePt 0 scr3X) (* pi 0.5) scr3Y)
	    scr3PT2 (polar scr3PT1 pi (* scr3X 2))
	    scr3PT3 (polar scr3PT2 (* pi 1.5) (* scr3Y 2))
	    scr3PT4 (polar scr3PT1 (* pi 1.5) (* scr3Y 2))
      )
    )
    ((= 6 scr3Num)
      (setq scr3PT1 (polar (polar V1BasePt 0 scr3X) (* pi 0.5) scr3Y)
	    scr3PT2 (polar scr3PT1 pi (* scr3X 2))
	    scr3PT3 (polar scr3PT2 (* pi 1.5) (* scr3Y 2))
	    scr3PT4 (polar scr3PT1 (* pi 1.5) (* scr3Y 2))
	    scr3PT5 (polar V1BasePt 0 scr3X)
	    scr3PT6 (polar V1BasePt pi scr3X)
      )
    )
  )
  (setq scr1D1 (nth (xh_get scr1D scrMLst) scrDLst)
	scr1D2 (nth (xh_get scr1D scrMLst) scrDdLst)
	scr2D1 (nth (xh_get scr2D scrMLst) scrDLst)
	scr2D2 (nth (xh_get scr2D scrMLst) scrDdLst)
	scr3D1 (nth (xh_get scr3D scrMLst) scrDLst)
	scr3D2 (nth (xh_get scr3D scrMLst) scrDdLst)
  )
;;LCA - WARNING: The OSMODE sysvar has changed.
;;LCA - WARNING: The OSMODE sysvar has changed.
  (setvar "osmode" 0)
  (setvar "cecolor" "bylayer")
  (setvar "celtype" "bylayer")
  (setvar "clayer" "continuous")
  (if (= "I" (substr MoldTypeNum 3 1))
    (progn
      (command "line" tpPT1 tpPt2 tpPT3 tpPT4 "c")
      (command "line" sbPT1 sbPT4 ""
	       "line" sbPT6 sbPT7 "")
    )
    (command "line" sbPT1 sbPT6 sbPT7 sbPT4 "c")
  )
  (command "circle" cgpnPT1 (/ gpnD   2.0)
           "circle" cgpnPT1 (/ gpnHD1 2.0)
	   "circle" cgpnPT2 (/ gpnD   2.0)
	   "circle" cgpnPT2 (/ gpnHD1 2.0)
	   "circle" cgpnPT3 (/ gpnD   2.0)
	   "circle" cgpnPT3 (/ gpnHD1 2.0)
	   "circle" cgpnPT4 (/ gpnD   2.0)
	   "circle" cgpnPT4 (/ gpnHD1 2.0)
  )
  (if (= "1" IfAddSpg)
    (progn
      (load "MoldSpgZ")
      (setvar "clayer" "spring")
      (setq rep "S1")
      (MoldSpgZst crpnPT1 SpgOd SpgTyp SpgLen "1")
      (MoldSpgZst crpnPT2 SpgOd SpgTyp SpgLen "1")
      (MoldSpgZst crpnPT3 SpgOd SpgTyp SpgLen "1")
      (MoldSpgZst crpnPT4 SpgOd SpgTyp SpgLen "1")
    )
    (command "circle" crpnPT1 (/ rpnD 2.0)
	     "circle" crpnPT2 (/ rpnD 2.0)
	     "circle" crpnPT3 (/ rpnD 2.0)
	     "circle" crpnPT4 (/ rpnD 2.0)
    )
  )
  (setvar "clayer" "hidden")
  (command "line" sbPT2 sbPT3 ""
	   "line" sbPT5 sbPT8 ""
	   "line" epPT1 epPT4 ""
	   "line" epPT2 epPT3 ""
  )

  (if (and TapHaD TapHbD)
    (progn
      (setq aTapPt  (polar V1BasePt  (* pi 0.5) cpY)
	    aTapPT1 (polar aTapPt pi (/ TapHaD 2.0))
	    aTapPT2 (polar aTapPt pi (/ (* 0.8 TapHaD) 2))
	    aTapPT4 (polar aTapPt 0  (/ TapHaD 2.0))
	    aTapPT3 (polar aTapPt 0  (/ (* 0.8 TapHaD) 2))
	    aTapPT5 (polar aTapPt (* pi 1.5) TapHaL)
	    aTapPT6 (polar aTapPT5 2.618  (/ (* TapHaD 0.4) (cos 0.5236)))
	    aTapPT7 (polar aTapPT5 0.5236 (/ (* TapHaD 0.4) (cos 0.5236)))

	    bTapPT  (polar V1BasePt  (* pi 1.5) cpY)
	    bTapPT1 (polar bTapPt pi (/ TapHbD 2.0))
	    bTapPT2 (polar bTapPt pi (/ (* 0.8 TapHbD) 2))
	    bTapPT4 (polar bTapPt 0  (/ TapHbD 2.0))
	    bTapPT3 (polar bTapPt 0  (/ (* 0.8 TapHbD) 2))
	    bTapPT5 (polar bTapPt (* pi 0.5) TapHbL)
	    bTapPT6 (polar bTapPT5 3.6552  (/ (* TapHbD 0.4) (cos 0.5236)))
	    bTapPT7 (polar bTapPT5 -0.5236 (/ (* TapHbD 0.4) (cos 0.5236)))
      )
      (command "line" aTapPT1 (polar aTapPT1 (* pi 1.5) TapHaI) (polar aTapPT4 (* pi 1.5) TapHaI) aTapPT4 ""
	       "line" aTapPT2 aTapPT6 aTapPT5 aTapPT7 aTapPT3 ""
	       "line" aTapPT6 aTapPT7 ""
	       "line" bTapPT1 (polar bTapPT1 (* pi 0.5) TapHbI) (polar bTapPT4 (* pi 0.5) TapHbI) bTapPT4 ""
	       "line" bTapPT2 bTapPT6 bTapPT5 bTapPT7 bTapPT3 ""
	       "line" bTapPT6 bTapPT7 ""
      )
    )
  )
;------------------------------------------------
;Draw screw flat view
;------------------------------------------------
  (load "MoldCapZ")
  (setvar "clayer" "screw")
  (MoldCapZ (nth (xh_get scr1D scrMLst) scrMMlst) scr1PT1 "1")
  (MoldCapZ (nth (xh_get scr1D scrMLst) scrMMlst) scr1PT2 "1")
  (MoldCapZ (nth (xh_get scr1D scrMLst) scrMMlst) scr1PT3 "1")
  (MoldCapZ (nth (xh_get scr1D scrMLst) scrMMlst) scr1PT4 "1")

  (MoldCapZ (nth (xh_get scr2D scrMLst) scrMMlst) scr2PT1 "1")
  (MoldCapZ (nth (xh_get scr2D scrMLst) scrMMlst) scr2PT2 "1")
  (MoldCapZ (nth (xh_get scr2D scrMLst) scrMMlst) scr2PT3 "1")
  (MoldCapZ (nth (xh_get scr2D scrMLst) scrMMlst) scr2PT4 "1")

  (MoldCapZ (nth (xh_get scr3D scrMLst) scrMMlst) scr3PT1 "1")
  (MoldCapZ (nth (xh_get scr3D scrMLst) scrMMlst) scr3PT2 "1")
  (MoldCapZ (nth (xh_get scr3D scrMLst) scrMMlst) scr3PT3 "1")
  (MoldCapZ (nth (xh_get scr3D scrMLst) scrMMlst) scr3PT4 "1")
  (if (= 6 scr1Num)
    (progn
      (MoldCapZ (nth (xh_get scr3D scrMLst) scrMMlst) scr3PT5 "1")
      (MoldCapZ (nth (xh_get scr3D scrMLst) scrMMlst) scr3PT6 "1")
    )
  )
;--------------------------------------------------------
;Defun Extent Data
;--------------------------------------------------------
  (setvar "clayer" "center")
  (setq ExData1 (list (list -3 (list "V1X" (cons 1000 (strcat MoldTypeNum MoldSpecNum "A" aP "B" bP "C" sbP))))))
  (setq ExData2 (list (list -3 (list "V1Y" (cons 1000 (strcat (itoa bpZ) " " (itoa epZ) " " (itoa erpZ) " " (rtos sbPThk 2 2) " " (itoa spZ) " "
							      (rtos bPThk 2 2)  " " (itoa stZ) " " (rtos aPThk 2 2) " " (itoa rpZ) " " (itoa tpZ)))))))
  (command "line" cPT1 cPT3 "")
  (mxdata (entlast) ExData1)
  (command "line" cPT2 cPT4 "")
  (mxdata (entlast) ExData2)
;--------------------------------------------------------
  (command "line" (polar cgpnPT1 0          (+ (/ gpnHD1 2.0) 2)) (polar cgpnPT1 pi         (+ (/ gpnHD1 2.0) 2)) ""
	   "line" (polar cgpnPT1 (* pi 0.5) (+ (/ gpnHD1 2.0) 2)) (polar cgpnPT1 (* pi 1.5) (+ (/ gpnHD1 2.0) 2)) ""
           "line" (polar cgpnPT2 0          (+ (/ gpnHD1 2.0) 2)) (polar cgpnPT2 pi         (+ (/ gpnHD1 2.0) 2)) ""
	   "line" (polar cgpnPT2 (* pi 0.5) (+ (/ gpnHD1 2.0) 2)) (polar cgpnPT2 (* pi 1.5) (+ (/ gpnHD1 2.0) 2)) ""
           "line" (polar cgpnPT3 0          (+ (/ gpnHD1 2.0) 2)) (polar cgpnPT3 pi         (+ (/ gpnHD1 2.0) 2)) ""
	   "line" (polar cgpnPT3 (* pi 0.5) (+ (/ gpnHD1 2.0) 2)) (polar cgpnPT3 (* pi 1.5) (+ (/ gpnHD1 2.0) 2)) ""
           "line" (polar cgpnPT4 0          (+ (/ gpnHD1 2.0) 2)) (polar cgpnPT4 pi         (+ (/ gpnHD1 2.0) 2)) ""
	   "line" (polar cgpnPT4 (* pi 0.5) (+ (/ gpnHD1 2.0) 2)) (polar cgpnPT4 (* pi 1.5) (+ (/ gpnHD1 2.0) 2)) ""
  )
  (command "line" (polar crpnPT1 0          (+ (/ rpnD 2.0) 2)) (polar crpnPT1 pi         (+ (/ rpnD 2.0) 2)) ""
	   "line" (polar crpnPT1 (* pi 0.5) (+ (/ rpnD 2.0) 2)) (polar crpnPT1 (* pi 1.5) (+ (/ rpnD 2.0) 2)) ""
           "line" (polar crpnPT2 0          (+ (/ rpnD 2.0) 2)) (polar crpnPT2 pi         (+ (/ rpnD 2.0) 2)) ""
	   "line" (polar crpnPT2 (* pi 0.5) (+ (/ rpnD 2.0) 2)) (polar crpnPT2 (* pi 1.5) (+ (/ rpnD 2.0) 2)) ""
           "line" (polar crpnPT3 0          (+ (/ rpnD 2.0) 2)) (polar crpnPT3 pi         (+ (/ rpnD 2.0) 2)) ""
	   "line" (polar crpnPT3 (* pi 0.5) (+ (/ rpnD 2.0) 2)) (polar crpnPT3 (* pi 1.5) (+ (/ rpnD 2.0) 2)) ""
           "line" (polar crpnPT4 0          (+ (/ rpnD 2.0) 2)) (polar crpnPT4 pi         (+ (/ rpnD 2.0) 2)) ""
	   "line" (polar crpnPT4 (* pi 0.5) (+ (/ rpnD 2.0) 2)) (polar crpnPT4 (* pi 1.5) (+ (/ rpnD 2.0) 2)) ""
  )
  (if (and TapHaD TapHbD) 
    (command "line" (polar aTapPT (* pi 0.5) 5) (polar aTapPT5 (* pi 1.5) 4) ""
	     "line" (polar bTapPT (* pi 0.5) 5) (polar bTapPT5 (* pi 1.5) 4) ""
    )
  )
;------------------------------------
;Dim
;------------------------------------
  (setvar "clayer" "dim")
  (command "dim"
           "ver" (polar (polar V1BasePt (* pi 1.5) scr2Y) pi (+ 2 (/ scr2D2 2.0) scr2X)) (polar (polar V1BasePt (* pi 0.5) scr2Y) pi (+ 2 (/ scr2D2 2.0) scr2X))
	         (polar v1BasePt pi (+ tpX 8)) (strcat (itoa (* scr2Y 2)) " S.C.H.S")
           "ver" (polar (polar V1BasePt (* pi 1.5) scr3Y) pi (+ 2 (/ scr3D2 2.0) scr3X)) (polar (polar V1BasePt (* pi 0.5) scr3Y) pi (+ 2 (/ scr3D2 2.0) scr3X))
	         (polar v1BasePt pi (+ tpX 17)) (strcat (itoa (* scr3Y 2)) " S.C.H.S")
           "ver" (polar (polar V1BasePt (* pi 1.5) gpnY) pi (+ 2 (/ gpnHD1 2.0) gpnX)) (polar (polar V1BasePt (* pi 0.5) gpnY) pi (+ 2 (/ gpnHD1 2.0) gpnX))
	         (polar v1BasePt pi (+ tpX 26)) (strcat (itoa (* gpnY 2)) " LEADER PIN")
           "ver" (polar (polar V1BasePt (* pi 1.5) scr1Y) pi (+ 2 (/ scr1D2 2.0) scr1X)) (polar (polar V1BasePt (* pi 0.5) scr1Y) pi (+ 2 (/ scr1D2 2.0) scr1X))
	         (polar v1BasePt pi (+ tpX 35)) (strcat (itoa (* scr1Y 2)) " S.C.H.S")
           "ver" tpPT2 tpPT3 (polar v1BasePt pi (+ tpX 44)) (itoa (* tpY 2))

           "ver" (polar (polar V1BasePt (* pi 1.5) rpnY) 0 (+ 2 (/ rpnD 2.0) rpnX)) (polar (polar V1BasePt (* pi 0.5) rpnY) 0 (+ 2 (/ rpnD 2.0) rpnX))
	         (polar v1BasePt 0 (+ tpX 17)) (strcat (itoa (* rpnY 2)) " RETURN PIN")
           "ver" (polar (polar V1BasePt (* pi 1.5) (- gpnY 2)) 0 (+ 2 (/ gpnHD1 2.0) gpnX)) (polar v1BasePt 0 (+ tpX 5)) 
    	         (polar (polar V1BasePt (* pi 1.5) (/ gpnY 2.0)) 0 (+ tpX 8)) (strcat (itoa (- gpnY 2)) " OFFSET")
           "ver" (polar (polar V1BasePt (* pi 0.5) gpnY) 0 (+ 2 (/ gpnHD1 2.0) gpnX)) (polar v1BasePt 0 (+ tpX 5)) 
    	         (polar (polar V1BasePt (* pi 0.5) (/ gpnY 2.0)) 0 (+ tpX 8)) (itoa gpnY)

           "hor" (polar (polar V1BasePt pi rpnX) (* pi 0.5) (+ 2 (/ rpnD 2.0) rpnY)) (polar (polar V1BasePt 0 rpnX) (* pi 0.5) (+ 2 (/ rpnD 2.0) rpnY))
	         (polar v1BasePt (* pi 0.5) (+ tpY 10)) (strcat (itoa (* rpnX 2)) " RETURN PIN")
           "hor" (polar (polar V1BasePt pi scr1X) (* pi 0.5) (+ 2 (/ scr1D2 2.0) scr1Y)) (polar (polar V1BasePt 0 scr1X) (* pi 0.5) (+ 2 (/ scr1D2 2.0) scr1Y))
	         (polar v1BasePt (* pi 0.5) (+ tpY 18)) (strcat (itoa (fix (* scr1X 2))) " S.C.H.S")

           "hor" (polar (polar V1BasePt pi gpnX) (* pi 0.5) (+ 2 (/ gpnHD1 2.0) gpnY)) (polar (polar V1BasePt 0 gpnX) (* pi 0.5) (+ 2 (/ gpnHD1 2.0) gpnY))
	         (polar v1BasePt (* pi 0.5) (+ tpY 26)) (strcat (itoa (* gpnX 2)) " LEADER PIN")
           "hor" (polar (polar V1BasePt pi scr3X) (* pi 0.5) (+ 2 (/ scr3D2 2.0) scr3Y)) (polar (polar V1BasePt 0 scr3X) (* pi 0.5) (+ 2 (/ scr3D2 2.0) scr3Y))
	         (polar v1BasePt (* pi 0.5) (+ tpY 34)) (strcat (itoa (fix (* scr3X 2))) " S.C.H.S")

           "hor" epPT3 epPT4 (polar v1BasePt (* pi 1.5) (+ tpY 10)) (itoa (* epX 2))
           "hor" sbPT3 sbPT4 (polar (polar sbPT3 0 (/ (- sbX2 sbX1) 2)) (* pi 1.5) 10) (itoa (- sbX2 sbX1))
           "hor" sbPT7 sbPT8 (polar (polar sbPT8 0 (/ (- sbX2 sbX1) 2)) (* pi 1.5) 10) (itoa (- sbX2 sbX1))
	   "exit"
  )
  (if (> tpX cpX)
    (command "dim"
             "hor" tpPT1 tpPT2 (polar v1BasePt (* pi 0.5) (+ tpY 42)) (itoa (* tpX 2))
	     "exit"
    )
  )
  (setq ofPT1 (polar cgpnPT4 -0.7854 (/ (+ (- cpY gpnY -2) 30) (sin 0.7854)))
	ofPT2 (polar ofPT1 0 37)
  )
  (command "line" cgpnPT4 ofPT1 ofPT2 "")
  (command "text" "s" "lxy3" (polar ofPT1 (* pi 0.5) 1) "" "OFFSET")
  (command "text" "s" "lxy3" "j" "c" (polar V1BasePt (* pi 1.5) (+ cpY 45)) "" "EJ. SIDE PLAN VIEW")
)

;#######################################################################
(defun drawTPMoldView2()
  (setq bpPt  (polar V2BasePt pi bpZ)
	ep1Pt (polar bpPt pi 5)
	ep2Pt (polar ep1Pt pi epZ)
	erpPt (polar ep2Pt pi erpZ)
	b1Pt  (polar bpPt pi (+ sbPThk spZ))
	b2Pt  (polar b1Pt pi bPThk)
	a1Pt  (polar b2Pt pi 1)
	a2Pt  (polar a1Pt pi aPThk)
	sbPt  (polar bpPt pi sbPThk)
        tp1Pt (polar a2Pt pi rpZ)
        tp2Pt (polar tp1Pt pi tpZ)
  )
  (if (> spZ 1)
    (setq spPt sbpt)
    (setq spPt nil)
  ) 
  (if (> rpZ 1)
    (setq rpPt (polar a2Pt pi rpZ))
    (setq rpPt nil)
  )
  (setq rpnPt  (list (car ep2Pt) (- (cadr V2BasePt) rpnY) 0.0))
  (setq rpnPT1 (polar (polar b1Pt 0 spZ) (* pi 1.5) (- rpnY (/ rpnD 2.0)))
	rpnPT2 (polar rpnPT1 (* pi 1.5) rpnD)
	rpnPT3 (polar b1Pt   (* pi 1.5) (- rpnY (/ rpnD 2.0)))
	rpnPT4 (polar rpnPT3 (* pi 1.5) rpnD)
  ) 
  (setvar "clayer" "continuous")
  (command "line" (polar V2BasePt (* pi 0.5) tpY) (polar bpPt (* pi 0.5) tpY) (polar bpPt (* pi 1.5) tpY) (polar V2BasePt (* pi 1.5) tpY) "")
  (command "line" (polar bpPt (* pi 0.5) cpY) (polar sbPt (* pi 0.5) cpY) rpnPT1 ""
	   "line" rpnPT2  (polar sbPt (* pi 1.5) cpY) (polar bpPt (* pi 1.5) cpY) ""
  )
  (command "line" (polar ep1Pt (* pi 0.5) cpY) (polar ep1Pt (* pi 1.5) cpY) ""
           "line" (polar ep2Pt (* pi 0.5) cpY) (polar ep2Pt (* pi 1.5) cpY) ""
	   "line" (polar ep2Pt (* pi 0.5) cpY) (polar erpPt (* pi 0.5) cpY) (polar erpPt (* pi 1.5) (- rpnY (/ rpnD 2.0))) ""
	   "line" (polar erpPt (* pi 1.5) (+ rpnY (/ rpnD 2.0))) (polar erpPt (* pi 1.5) cpY) (polar ep2Pt (* pi 1.5) cpY) ""
  )
  (command "line" rpnPT3 (polar b1Pt (* pi 0.5) cpY) (polar b2Pt (* pi 0.5) cpY) (polar b2Pt (* pi 1.5) (- rpnY (/ rpnD 2.0))) ""
	   "line" (polar b2Pt (* pi 1.5) (+ rpnY (/ rpnD 2.0))) (polar b2Pt (* pi 1.5) cpY) (polar b1Pt (* pi 1.5) cpY) rpnPT4 "")
  (command "line" (polar a1Pt (* pi 0.5) cpY) (polar a2Pt (* pi 0.5) cpY) (polar a2Pt (* pi 1.5) cpY) (polar a1Pt (* pi 1.5) cpY) "c")
  (command "line" (polar ep1Pt (* pi 1.5) (- rpnY 7)) (polar (polar ep1Pt (* pi 1.5) (- rpnY 8)) 0 1) (polar (polar ep1Pt (* pi 1.5) (- rpnY 8)) 0 5)
		  (polar (polar ep1Pt (* pi 1.5) (+ rpnY 8)) 0 5) (polar (polar ep1Pt (* pi 1.5) (+ rpnY 8)) 0 1) (polar ep1Pt (* pi 1.5) (+ rpnY 7)) ""
	   "line" (polar (polar ep1Pt (* pi 1.5) (- rpnY 8)) 0 1) (polar (polar ep1Pt (* pi 1.5) (+ rpnY 8)) 0 1) ""
	   "line" (polar bpPt (* pi 1.5) (- rpnY 4)) (polar V2BasePt (* pi 1.5) (- rpnY 4)) ""
	   "line" (polar bpPt (* pi 1.5) (+ rpnY 4)) (polar V2BasePt (* pi 1.5) (+ rpnY 4)) ""
	   "line" (polar (polar bpPt (* pi 1.5) (- rpnY 4)) 0 9) (polar (polar bpPt (* pi 1.5) (- rpnY 3)) 0 10)
		  (polar (polar bpPt (* pi 1.5) (+ rpnY 3)) 0 10) (polar (polar bpPt (* pi 1.5) (+ rpnY 4)) 0 9) ""
	   "line" (polar (polar bpPt (* pi 1.5) (- rpnY 4)) 0 9) (polar (polar bpPt (* pi 1.5) (+ rpnY 4)) 0 9) ""
  )
  (command "line" (polar tp1Pt (* pi 0.5) tpY) (polar tp2Pt (* pi 0.5) tpY) 
	          (polar tp2Pt (* pi 1.5) tpY) (polar tp1Pt (* pi 1.5) tpY) "c"
  )

  (if spPt
    (command "line" (polar sbPt (* pi 0.5) cpY) (polar b1Pt (* pi 0.5) cpY) ""
	     "line" (polar sbPt (* pi 1.5) cpY) (polar b1Pt (* pi 1.5) cpY) ""
    )
  )
  (if rpPt
    (command "line" (polar a2Pt (* pi 0.5) cpY) (polar rpPt (* pi 0.5) cpY) ""
	     "line" (polar a2Pt (* pi 1.5) cpY) (polar rpPt (* pi 1.5) cpY) ""
    )
  )
  (if (> rpnD 21)
    (setq rpnH 8)
    (setq rpnH 4)
  )
  (setq rpnPT5  (polar rpnPt (* pi 0.5) (/ (+ rpnD 5) 2.0))
	rpnPT6  (polar rpnPt (* pi 1.5) (/ (+ rpnD 5) 2.0))
	rpnPT7  (polar rpnPT5 (* pi 0.5) 1)
	rpnPT8  (polar rpnPT6 (* pi 1.5) 1)
      	rpnPT9  (polar (polar rpnPt (* pi 0.5) (/ rpnD 2.0)) pi rpnH)
      	rpnPT10 (polar (polar rpnPt (* pi 1.5) (/ rpnD 2.0)) pi rpnH)
  )
  (command "line" rpnPT7 (polar rpnPT7 pi rpnH) (polar rpnPT8 pi rpnH) rpnPT8 ""
	   "line" rpnPT5 (polar rpnPT5 pi rpnH) ""
	   "line" rpnPT6 (polar rpnPT6 pi rpnH) ""
  )
  (command "line" rpnPT9  (polar (polar b2Pt (* pi 1.5) (- rpnY (/ rpnD 2.0))) pi 1) ""
           "line" rpnPT10 (polar (polar b2Pt (* pi 1.5) (+ rpnY (/ rpnD 2.0))) pi 1) ""
  )
  (if (and TapHaD TapHbD)
    (progn
      (setq aTapPt  (polar (polar a1Pt (* pi 0.5) cpY) pi (/ aPThk 2.0))
	    aTapPT1 (polar aTapPt pi (/ TapHaD 2.0))
	    aTapPT2 (polar aTapPt pi (/ (* 0.8 TapHaD) 2))
	    aTapPT4 (polar aTapPt 0  (/ TapHaD 2.0))
	    aTapPT3 (polar aTapPt 0  (/ (* 0.8 TapHaD) 2))
	    aTapPT5 (polar aTapPt (* pi 1.5) TapHaL)
	    aTapPT6 (polar aTapPT5 2.618 (/ (* TapHaD 0.4) (cos 0.5236)))
	    aTapPT7 (polar aTapPT5 0.5236 (/ (* TapHaD 0.4) (cos 0.5236)))

	    bTapPT (polar (polar b1Pt (* pi 0.5) cpY) pi (/ bPThk 2))
	    bTapPT1 (polar bTapPt pi (/ TapHbD 2.0))
	    bTapPT2 (polar bTapPt pi (/ (* 0.8 TapHbD) 2))
	    bTapPT4 (polar bTapPt 0  (/ TapHbD 2.0))
	    bTapPT3 (polar bTapPt 0  (/ (* 0.8 TapHbD) 2))
	    bTapPT5 (polar bTapPt (* pi 1.5) TapHbL)
	    bTapPT6 (polar bTapPT5 2.618  (/ (* TapHbD 0.4) (cos 0.5236)))
	    bTapPT7 (polar bTapPT5 0.5236 (/ (* TapHbD 0.4) (cos 0.5236)))
      )
      (command "line" aTapPT1 (polar aTapPT1 (* pi 1.5) TapHaI) (polar aTapPT4 (* pi 1.5) TapHaI) aTapPT4 ""
	       "line" aTapPT2 aTapPT6 aTapPT5 aTapPT7 aTapPT3 ""
	       "line" aTapPT6 aTapPT7 ""
	       "line" bTapPT1 (polar bTapPT1 (* pi 1.5) TapHbI) (polar bTapPT4 (* pi 1.5) TapHbI) bTapPT4 ""
	       "line" bTapPT2 bTapPT6 bTapPT5 bTapPT7 bTapPT3 ""
	       "line" bTapPT6 bTapPT7 ""
      )
    )
  )
  (if (= "1" IfAddSpg)
    (progn
      (command "line" (polar sbPt (* pi 1.5) (- rpnY (+ (/ SpgOd 2.0) 1))) (polar (polar sbPt (* pi 1.5) (- rpnY (+ (/ SpgOd 2.0) 1))) pi SpgHolDep)
		      (polar (polar sbPt (* pi 1.5) (+ rpnY (+ (/ SpgOd 2.0) 1))) pi SpgHolDep) (polar sbPt (* pi 1.5) (+ rpnY (+ (/ SpgOd 2.0) 1))) ""
      )
      (setvar "clayer" "spring")
      (load "MoldSpgC")
      (MoldSpgCst (polar erpPt (* pi 1.5) rpnY) (polar (polar sbPt (* pi 1.5) rpnY) pi SpgHolDep) SpgTyp SpgLen SpgOd SpgId SpgA SpgB "0")
    )
  )
;----------------------------------------------------------------
;Defun Extent Entry Data
;----------------------------------------------------------------
  (setvar "clayer" "continuous")
  (setq ExData1 (list (list -3 (list "V2X" (cons 1000 " ")))))
  (setq ExData2 (list (list -3 (list "V2Y" (cons 1000 " ")))))

  (command "line" (polar V2BasePt (* pi 0.5) tpY) (polar V2BasePt (* pi 1.5) tpY) "")
  (mxdata (entlast) ExData2)

  (setvar "clayer" "center")
  (command "line" (polar V2BasePt 0 8) (polar V2BasePt pi (+ bpZ sbPThk stZ spZ aPThk bPThk rpZ tpZ 8)) "")
  (mxdata (entlast) ExData1)
;----------------------------------------------------------------
  (command "line" (polar rpnPt 0 4) (polar (polar b2Pt (* pi 1.5) rpnY) pi 4) "")
  (if (and TapHaD TapHbD) 
    (command "line" (polar aTapPT (* pi 0.5) 5) (polar aTapPT5 (* pi 1.5) 4) ""
	     "line" (polar bTapPT (* pi 0.5) 5) (polar bTapPT5 (* pi 1.5) 4) ""
    )
  )
  (command "line" (polar (polar bpPt (* pi 1.5) rpnY) pi 8) (polar (polar V2BasePt (* pi 1.5) rpnY) 0 3) "")
;-------------------------------------------
;dim
;-------------------------------------------
  (setvar "clayer" "dim")
  (command "dim"
	   "hor" (polar (polar V2BasePt pi (+ bpZ sbPThk bPThk aPThk rpZ spZ stZ tpZ 1.0)) (* pi 1.5) cpY) (polar V2BasePt (* pi 1.5) cpY) 
		 (polar (polar V2BasePt pi (/ (+ bpZ sbPThk bPThk aPThk rpZ spZ stZ tpZ 1.0) 2.0))  (* pi 1.5) (+ cpY 10)) 
		 (itoa (fix (+ bpZ sbPThk bPThk aPThk rpZ spZ stZ tpZ 1)))
	   "hor" (polar a2Pt (* pi 0.5) cpY) (polar a1Pt (* pi 0.5) cpY) (polar (polar a2Pt 0 (/ aPThk 2.0))  (* pi 0.5) (+ cpY 19)) aP
	   "hor" (polar b2Pt (* pi 0.5) cpY) (polar b1Pt (* pi 0.5) cpY) (polar (polar b2Pt 0 (/ bPThk 2.0))  (* pi 0.5) (+ cpY 19)) bP
	   "hor" (polar sbPt (* pi 0.5) cpY) (polar bpPt (* pi 0.5) cpY) (polar (polar sbPt 0 (/ sbPThk 2.0)) (* pi 0.5) (+ cpY 19)) sbP
	   "hor" (polar bpPt (* pi 0.5) cpY) (polar v2BasePt (* pi 0.5) cpY) (polar (polar bpPt 0 (/ bpZ 2.0)) (* pi 0.5) (+ cpY 19)) (itoa bpZ)
	   "hor" (polar ep2Pt (* pi 0.5) cpY) (polar erpPt (* pi 0.5) cpY) (polar (polar erpPt 0 (/ erpZ 2.0))  (* pi 0.5) (+ cpY 10)) (itoa erpZ)
	   "hor" (polar ep2Pt (* pi 0.5) cpY) (polar ep1Pt (* pi 0.5) cpY) (polar (polar ep2Pt 0 (/ epZ 2.0))  (* pi 0.5) (+ cpY 10)) (itoa epZ)
	   "hor" (polar ep1Pt (* pi 0.5) cpY) (polar bpPt (* pi 0.5) cpY) (polar (polar ep1Pt 0 2.5)  (* pi 0.5) (+ cpY 10)) "5"
 	   "exit"
  )
  (if (> tpZ 1)
    (command "dim"
	     "hor" (polar tp2Pt (* pi 0.5) cpY) (polar tp1Pt (* pi 0.5) cpY) (polar (polar tp2Pt 0 (/ tpZ 2.0))  (* pi 0.5) (+ cpY 19)) (itoa tpZ)
	     "exit"
    )
  )
  (if (> spZ 1)
    (command "dim"
	     "hor" (polar b1Pt (* pi 0.5) cpY) (polar spPt (* pi 0.5) cpY) (polar (polar b1Pt 0 (/ spZ 2.0))  (* pi 0.5) (+ cpY 19)) (itoa spZ)
	     "exit"
    )
  )
  (if (> stZ 1)
    (command "dim"
	     "hor" (polar a1Pt (* pi 0.5) cpY) (polar stPt (* pi 0.5) cpY) (polar (polar a1Pt 0 (/ stZ 2.0))  (* pi 0.5) (+ cpY 19)) (itoa stZ)
	     "exit"
    )
  )
  (if (> rpZ 1)
    (command "dim"
	     "hor" (polar tp1Pt (* pi 0.5) cpY) (polar a2Pt (* pi 0.5) cpY) (polar (polar tp1Pt 0 (/ spZ 2.0))  (* pi 0.5) (+ cpY 19)) (itoa rpZ)
	     "exit"
    )
  )
  (command "text" "s" "lxy3" "j" "c" (polar (polar V2BasePt (* pi 1.5) (+ cpY 45)) pi (/ (+ tpZ sbPThk spZ bPThk stZ aPThk rpZ tpZ) 2)) "" "SECTION A - A")
  (setq lhPT1 (polar (polar aTapPt (* pi 0.75) (/ 60 (sin 0.7854))) pi 35)
	lhPT2 (polar lhPT1 (* pi 1.5) 10) 
	lhPT3 (polar lhPT2 (* pi 1.5) 10) 
	lhPT4 (polar lhPT3 (* pi 1.5) 10) 
  )
  (command "line" aTapPt (polar lhPT1 0 35) lhPT1 ""
 	   "line" lhPT2  (polar lhPT2 0 35) ""
 	   "line" lhPT3  (polar lhPT3 0 35) ""
 	   "line" lhPT4  (polar lhPT4 0 35) ""
  )
  (command "text" "s" "lxy4" (polar (polar lhPT1 (* pi 0.5) 1) 0 1.5) "" "LIFT HOLE"
	   "text" "s" "lxy4" (polar (polar lhPT2 (* pi 0.5) 1) 0 1.5) "" "DR.& TAP."
	   "text" "s" "lxy4" (polar (polar lhPT3 (* pi 0.5) 1) 0 1.5) "" (strcat "M" (itoa TapHaD) "X" (itoa TapHaL))
	   "text" "s" "lxy4" (polar (polar lhPT4 (* pi 0.5) 1) 0 1.5) "" "TAP. 4"
  )
)

;################################################################
(defun drawTPMoldView3()
  (setq tpPT1 (polar (polar V3BasePt 0 tpX) (* pi 0.5) tpY)
	tpPT2 (polar tpPT1 pi (* tpX 2))
	tpPT3 (polar tpPT2 (* pi 1.5) (* tpY 2))
	tpPT4 (polar tpPT3 0 (* tpX 2))
  )
  (setq sbPT1 (polar (polar V3BasePt 0 sbX2) (* pi 0.5) sbY)
	sbPT2 (polar (polar V3BasePt 0 sbX1) (* pi 0.5) sbY)
        sbPT3 (polar sbPT2 (* pi 1.5) (* sbY 2))
        sbPT4 (polar sbPT1 (* pi 1.5) (* sbY 2))
	sbPT5 (polar (polar V3BasePt pi sbX1) (* pi 0.5) sbY)
	sbPT6 (polar (polar V3BasePt pi sbX2) (* pi 0.5) sbY)
        sbPT7 (polar sbPT6 (* pi 1.5) (* sbY 2))
        sbPT8 (polar sbPT5 (* pi 1.5) (* sbY 2))
  )
  (setq cPT1 (polar V3BasePt 0 (+ tpX 5))
	cPT2 (polar V3BasePt (* pi 0.5) (+ tpY 5))
	cPT3 (polar V3BasePt pi (+ tpX 5))
	cPT4 (polar V3BasePt (* pi 1.5) (+ tpY 5))
  )
  (setq cgpnPT1 (polar (polar V3BasePt 0 gpnX) (* pi 0.5) gpnY)
	cgpnPT2 (polar cgpnPT1 pi (* gpnX 2))
	cgpnPT4 (polar cgpnPT1 (* pi 1.5) (* gpnY 2))
	cgpnPT3 (polar cgpnPT2 (* pi 1.5) (- (* gpnY 2) 2))
  )
  (setvar "clayer" "continuous")
  (if (= "I" (substr MoldTypeNum 3 1))
    (progn
      (command "line" tpPT1 tpPt2 tpPT3 tpPT4 "c")
      (command "line" sbPT1 sbPT4 ""
	       "line" sbPT6 sbPT7 "")
    )
    (command "line" sbPT1 sbPT6 sbPT7 sbPT4 "c")
  )
  (command "circle" cgpnPT1 (/ gpnD 2.0)
	   "circle" cgpnPT2 (/ gpnD 2.0)
	   "circle" cgpnPT3 (/ gpnD 2.0)
	   "circle" cgpnPT4 (/ gpnD 2.0)
  )
  (command "circle" cgpnPT1 (/ gpnHD1 2.0)
	   "circle" cgpnPT2 (/ gpnHD1 2.0)
	   "circle" cgpnPT3 (/ gpnHD1 2.0)
	   "circle" cgpnPT4 (/ gpnHD1 2.0)
  )
  (setvar "clayer" "hidden")
  (if (and TapHaD TapHbD)
    (progn
      (setq aTapPt (polar V3BasePt (* pi 0.5) cpY)
	    aTapPT1 (polar aTapPt pi (/ TapHaD 2.0))
	    aTapPT2 (polar aTapPt pi (/ (* 0.8 TapHaD) 2))
	    aTapPT4 (polar aTapPt 0 (/ TapHaD 2.0))
	    aTapPT3 (polar aTapPt 0 (/ (* 0.8 TapHaD) 2))
	    aTapPT5 (polar aTapPt (* pi 1.5) TapHaL)
	    aTapPT6 (polar aTapPT5 2.618 (/ (* TapHaD 0.4) (cos 0.5236)))
	    aTapPT7 (polar aTapPT5 0.5236 (/ (* TapHaD 0.4) (cos 0.5236)))

	    bTapPT (polar V3BasePt (* pi 1.5) cpY)
	    bTapPT1 (polar bTapPt pi (/ TapHbD 2.0))
	    bTapPT2 (polar bTapPt pi (/ (* 0.8 TapHbD) 2))
	    bTapPT4 (polar bTapPt 0 (/ TapHbD 2.0))
	    bTapPT3 (polar bTapPt 0 (/ (* 0.8 TapHbD) 2))
	    bTapPT5 (polar bTapPt (* pi 0.5) TapHbL)
	    bTapPT6 (polar bTapPT5 3.6552 (/ (* TapHbD 0.4) (cos 0.5236)))
	    bTapPT7 (polar bTapPT5 -0.5236 (/ (* TapHbD 0.4) (cos 0.5236)))
      )
      (command "line" aTapPT1 (polar aTapPT1 (* pi 1.5) TapHaI) (polar aTapPT4 (* pi 1.5) TapHaI) aTapPT4 ""
	       "line" aTapPT2 aTapPT6 aTapPT5 aTapPT7 aTapPT3 ""
	       "line" aTapPT6 aTapPT7 ""
	       "line" bTapPT1 (polar bTapPT1 (* pi 0.5) TapHbI) (polar bTapPT4 (* pi 0.5) TapHbI) bTapPT4 ""
	       "line" bTapPT2 bTapPT6 bTapPT5 bTapPT7 bTapPT3 ""
	       "line" bTapPT6 bTapPT7 ""
      )
    )
  )
;-------------------------------------------------------------
;Defun Extent data
;-------------------------------------------------------------
  (setvar "clayer" "center")
  (setq ExData1 (list (list -3 (list "V3X" (cons 1000 " ")))))
  (setq ExData2 (list (list -3 (list "V3Y" (cons 1000 " ")))))
  (command "line" cPT1 cPT3 "")
  (mxdata (entlast) ExData1)
  (command "line" cPT2 cPT4 "")
  (mxdata (entlast) ExData2)
;-------------------------------------------------------------
  (command "line" (polar cgpnPT1 0          (+ (/ gpnHD1 2.0) 2)) (polar cgpnPT1 pi         (+ (/ gpnHD1 2.0) 2)) ""
	   "line" (polar cgpnPT1 (* pi 0.5) (+ (/ gpnHD1 2.0) 2)) (polar cgpnPT1 (* pi 1.5) (+ (/ gpnHD1 2.0) 2)) ""
           "line" (polar cgpnPT2 0          (+ (/ gpnHD1 2.0) 2)) (polar cgpnPT2 pi         (+ (/ gpnHD1 2.0) 2)) ""
	   "line" (polar cgpnPT2 (* pi 0.5) (+ (/ gpnHD1 2.0) 2)) (polar cgpnPT2 (* pi 1.5) (+ (/ gpnHD1 2.0) 2)) ""
           "line" (polar cgpnPT3 0          (+ (/ gpnHD1 2.0) 2)) (polar cgpnPT3 pi         (+ (/ gpnHD1 2.0) 2)) ""
	   "line" (polar cgpnPT3 (* pi 0.5) (+ (/ gpnHD1 2.0) 2)) (polar cgpnPT3 (* pi 1.5) (+ (/ gpnHD1 2.0) 2)) ""
           "line" (polar cgpnPT4 0          (+ (/ gpnHD1 2.0) 2)) (polar cgpnPT4 pi         (+ (/ gpnHD1 2.0) 2)) ""
	   "line" (polar cgpnPT4 (* pi 0.5) (+ (/ gpnHD1 2.0) 2)) (polar cgpnPT4 (* pi 1.5) (+ (/ gpnHD1 2.0) 2)) ""
  )
;-------------------------------------------------------------
;dim
;-------------------------------------------------------------
  (setvar "clayer" "dim")
  (setq ofPT1 (polar cgpnPT3 3.927 (/ (+ (- cpY gpnY -2) 30) (sin 0.7854)))
	ofPT2 (polar ofPT1 pi 37)
  )
  (command "line" cgpnPT3 ofPT1 ofPT2 "")
  (command "text" "s" "lxy3" (polar ofPT2 (* pi 0.5) 1) "" "OFFSET")
  (command "text" "s" "lxy3" "j" "c" (polar V3BasePt (* pi 1.5) (+ cpY 45)) "" "HOT SIDE PLAN VIEW")
)

;#######################################################################
(defun drawTPMoldView4()
  (setq bpPt  (polar V4BasePt (* 0.5 pi) bpZ)
	ep1Pt (polar bpPt  (* 0.5 pi) 5)
	ep2Pt (polar ep1Pt (* 0.5 pi) epZ)
	erpPt (polar ep2Pt (* 0.5 pi) erpZ)
	b1Pt  (polar bpPt  (* 0.5 pi) (+ sbPThk spZ))
	b2Pt  (polar b1Pt  (* 0.5 pi) bPThk)
	a1Pt  (polar b2Pt  (* 0.5 pi) (+ 1 stZ))
	a2Pt  (polar a1Pt  (* 0.5 pi) aPThk)
	sbPt  (polar bpPt  (* 0.5 pi) sbPThk)
        tp1Pt (polar a2Pt  (* pi 0.5) rpZ) 
        tp2Pt (polar tp1Pt (* pi 0.5) tpZ)
  )
  (setq gppnD gpnD)
  (if (> spZ 1)
    (setq spPt sbpt)
    (setq spPt nil)
  ) 
  (if (> rpZ 1)
    (setq rpPt (polar a2Pt (* 0.5 pi) rpZ))
    (setq rpPt nil)
  )
  (setq gpnDD1 (+ gpnD 5)
	gpnDH  (nth (xh_get gpnD gpnHDLst) gpnDHLst)
	gpnHD1 (nth (xh_get gpnD gpnHDLst) gpnHD1Lst)
	gpnHDD (nth (xh_get gpnD gpnHDLst) gpnHDDLst)
	gpnHH  (nth (xh_get gpnD gpnHDLst) gpnHHLst)
	gpnL   (- (+ aPThk bPThk 1 sbPThk rpZ spZ tpZ) (+ gpnDH (* gpnD 0.1)))
  )
  (setq gpnPt   (polar tp2Pt pi gpnX)
	gpnPT1  (polar gpnPt pi (/ gpnDD1 2.0))
	gpnPT2  (polar gpnPt 0  (/ gpnDD1 2.0))
	gpnPT3  (polar (polar gpnPt pi (/ gpnD 2.0)) (* pi 1.5) gpnDH)
	gpnPT4  (polar (polar gpnPt 0  (/ gpnD 2.0)) (* pi 1.5) gpnDH)
	gpnPT5  (polar gpnPT3 (* pi 1.5) (- gpnL (* 1.2 gpnD)))
	gpnPT6  (polar gpnPT4 (* pi 1.5) (- gpnL (* 1.2 gpnD)))

	gpnPT8  (polar a2Pt pi (+ gpnX (/ gpnHDD 2.0)))
	gpnPT7  (polar gpnPT8 pi 1)
	gpnPT9  (polar a2Pt pi (- gpnX (/ gpnHDD 2.0)))
	gpnPT10 (polar gpnPT9 0 1)
	gpnPT11 (polar (polar a2Pt pi (+ gpnX (/ gpnHD1 2.0))) (* pi 1.5) gpnHH)
	gpnPT12 (polar (polar a2Pt pi (- gpnX (/ gpnHD1 2.0))) (* pi 1.5) gpnHH)

	gpnPT14 (polar b1Pt pi (+ gpnX (/ gpnHDD 2.0)))
	gpnPT13 (polar gpnPT14 pi 1)
	gpnPT15 (polar b1Pt pi (- gpnX (/ gpnHDD 2.0)))
	gpnPT16 (polar gpnPT15 0 1)
	gpnPT17 (polar (polar b1Pt pi (+ gpnX (/ gpnHD1 2.0))) (* pi 0.5) gpnHH)
	gpnPT18 (polar (polar b1Pt pi (- gpnX (/ gpnHD1 2.0))) (* pi 0.5) gpnHH)

	gpnPT19 (polar tp1Pt pi (+ gpnX (/ gpnD 2.0)))
	gpnPT20 (polar gpnPT19 0 gpnD)
	gpnPT21 (polar bpPt pi (+ gpnX (/ gpnD 2.0) 0.5))
	gpnPT22 (polar gpnPT21 0 (+ gpnD 1))
  )
  (setvar "clayer" "continuous")
  (command "line" (polar V4BasePt 0 tpX) (polar bpPt 0 tpX) (polar bpPt pi tpX) (polar V4BasePt pi tpX) "")
  (command "line" (polar bpPt 0 sbX2) (polar sbPt 0 sbX2) (polar sbPt 0 sbX1) (polar bpPt 0 sbX1) "c"

	   "line" (polar bpPt pi sbX2) (polar sbPt pi sbX2) (polar gpnPT19 (* pi 1.5) (+ rpZ aPThk 1 bPThk spZ)) "" 
           "line" (polar gpnPT20 (* pi 1.5) (+ rpZ aPThk 1 bPThk spZ)) (polar sbPt pi sbX1) (polar bpPt pi sbX1) ""

           "line" (polar ep1Pt 0 epX) (polar ep2Pt 0 epX) (polar ep2Pt pi epX) (polar ep1Pt pi epX) "c"
           "line" (polar ep2Pt 0 epX) (polar erpPt 0 epX) (polar erpPt pi epX) (polar ep2Pt pi epX) ""

	   "line" (polar gpnPT20 (* pi 1.5) (+ rpZ aPThk 1 bPThk)) (polar b1Pt 0  cpX) (polar b2Pt 0  cpX) (polar gpnPT20 (* pi 1.5) (+ rpZ 1 aPThk)) ""
	   "line" (polar gpnPT19 (* pi 1.5) (+ rpZ aPThk 1 bPThk)) (polar b1Pt pi cpX) (polar b2Pt pi cpX) (polar gpnPT19 (* pi 1.5) (+ rpZ 1 aPThk)) ""

	   "line" (polar gpnPT20 (* pi 1.5) (+ rpZ aPThk)) (polar a1Pt 0  cpX) (polar a2Pt 0  cpX) (polar gpnPT20 (* pi 1.5) rpZ) ""
	   "line" (polar gpnPT19 (* pi 1.5) (+ rpZ aPThk)) (polar a1Pt pi cpX) (polar a2Pt pi cpX) (polar gpnPT19 (* pi 1.5) rpZ) ""

           "line" gpnPT20 (polar tp1Pt 0 tpX) (polar tp2Pt 0 tpX) (polar tp2Pt pi tpX) (polar tp1Pt pi tpX) gpnPT19 ""
  )

  (command "line" gpnPT7  (polar gpnPT7  (* pi 1.5) gpnHH) gpnPT11 (polar a1Pt pi (+ gpnX (/ gpnHD1 2.0))) ""
	   "line" gpnPT10 (polar gpnPT10 (* pi 1.5) gpnHH) gpnPT12 (polar a1Pt pi (- gpnX (/ gpnHD1 2.0))) ""
	   "line" gpnPT8  (polar gpnPT8  (* pi 1.5) gpnHH) ""
	   "line" gpnPT9  (polar gpnPT9  (* pi 1.5) gpnHH) ""
  )

  (command "line" gpnPT13 (polar gpnPT13 (* pi 0.5) gpnHH) gpnPT17 (polar b2Pt pi (+ gpnX (/ gpnHD1 2.0))) ""
	   "line" gpnPT16 (polar gpnPT16 (* pi 0.5) gpnHH) gpnPT18 (polar b2Pt pi (- gpnX (/ gpnHD1 2.0))) ""
	   "line" gpnPT14 (polar gpnPT14 (* pi 0.5) gpnHH) ""
	   "line" gpnPT15 (polar gpnPT15 (* pi 0.5) gpnHH) ""
  )

  (command "line"  gpnPT1 (polar gpnPT1 (* pi 1.5) gpnDH) (polar gpnPT2 (* pi 1.5) gpnDH) gpnPT2 ""
	   "line"  gpnPT3 gpnPT5 ""
	   "line"  gpnPT4 gpnPT6 ""
	   "pline" gpnPT5 "a" "ce" (polar gpnPT5 0 (* gpnD 0.1)) (polar (polar gpnPT5 0 (* gpnD 0.1)) (* pi 1.5) (* gpnD 0.1)) "l" 
		   (polar (polar gpnPT6 pi (* gpnD 0.1)) (* pi 1.5) (* gpnD 0.1)) "a" "ce" (polar gpnPT6 pi (* gpnD 0.1)) gpnPT6 ""
  )

  (command "line" gpnPT21 (polar gpnPT21 (* pi 0.5) (+ spZ sbPThk)) ""
	   "line" gpnPT22 (polar gpnPT22 (* pi 0.5) (+ spZ sbPThk)) ""
  )

  (if spPt
    (command "line" (polar b1Pt pi cpX) (polar sbPt pi cpX) (polar gpnPT19 (* pi 1.5) (+ spZ bPThk 1 aPThk rpZ)) ""
             "line" (polar gpnPT20 (* pi 1.5) (+ spZ bPThk 1 aPThk rpZ)) (polar sbPt 0 cpX) (polar b1Pt 0 cpX) ""
    )
  )
  (if rpPt
    (command "line" (polar a1Pt pi cpX) (polar tp1Pt pi cpX) ""
             "line" (polar a1Pt 0  cpX) (polar tp1Pt 0  cpX) ""
	     "line" (polar tp1Pt pi (+ gpnX (/ gpnHD1 2.0))) (polar a2Pt pi (+ gpnX (/ gpnHD1 2.0))) ""
	     "line" (polar tp1Pt pi (- gpnX (/ gpnHD1 2.0))) (polar a2Pt pi (- gpnX (/ gpnHD1 2.0))) ""
    )
  )
;---------------------------------------------------------------------
;Defun Extent Data
;---------------------------------------------------------------------
  (setq ExData1 (list (list -3 (list "V4X" (cons 1000 " ")))))
  (setq ExData2 (list (list -3 (list "V4Y" (cons 1000 " ")))))

  (command "line" (polar V4BasePt pi tpX) (polar V4BasePt 0 tpX) "")
  (mxdata (entlast) ExData1)

  (setvar "clayer" "center")
  (command "line" (polar V4BasePt (* pi 1.5) 10) (polar tp2Pt (* pi 0.5) 10) "")
  (mxdata (entlast) ExData2)
;---------------------------------------------------------------------
  (command "line" (polar gpnPt (* pi 0.5) 5) (polar (polar V4BasePt pi gpnX) (* pi 1.5) 5) "") 
  (setvar "clayer" "screw")
  (MoldCapCst (nth (xh_get scr2D scrMLst) scrMMlst) (+ bpZ (* 1.0 (nth (xh_get scr2D scrMLst) scrDLst)))
	      (polar V4BasePt pi scr2X) (polar bpPt pi scr2X) "1" nil)

  (MoldCapCst (nth (xh_get scr3D scrMLst) scrMMlst) (+ bpZ sbPThk spZ (* 1.5 (nth (xh_get scr3D scrMLst) scrDLst)))
	      (polar V4BasePt 0 scr3X) (polar b1Pt 0 scr3X) "1" nil)
  (MoldCapCst (nth (xh_get scr1D scrMLst) scrMMlst) (+ epZ (* 1.0 (nth (xh_get scr1D scrMLst) scrDLst)))
	      (polar ep1Pt 0 scr1X) (polar ep2Pt 0 scr1X) "1" (polar erpPt 0 scr1X))
;---------------------------------------------------------------------
;dim
;---------------------------------------------------------------------
  (setvar "clayer" "dim")
  (command "text" "s" "lxy3" "j" "c" (polar V4BasePt (* pi 1.5) 45) "" "SECTION B - B")
)

;*******************************************************************************************************;
;Pin Point Gate Mold Base System
;*******************************************************************************************************;
(defun drawPPMoldView1()
  (setq tpPT1 (polar (polar V1BasePt 0 tpX) (* pi 0.5) tpY)
	tpPT2 (polar tpPT1 pi (* tpX 2))
	tpPT3 (polar tpPT2 (* pi 1.5) (* tpY 2))
	tpPT4 (polar tpPT3 0 (* tpX 2))
  )
  (setq sbPT1 (polar (polar V1BasePt 0 sbX2) (* pi 0.5) sbY)
	sbPT2 (polar (polar V1BasePt 0 sbX1) (* pi 0.5) sbY)
        sbPT3 (polar sbPT2 (* pi 1.5) (* sbY 2))
        sbPT4 (polar sbPT1 (* pi 1.5) (* sbY 2))
	sbPT5 (polar (polar V1BasePt pi sbX1) (* pi 0.5) sbY)
	sbPT6 (polar (polar V1BasePt pi sbX2) (* pi 0.5) sbY)
        sbPT7 (polar sbPT6 (* pi 1.5) (* sbY 2))
        sbPT8 (polar sbPT5 (* pi 1.5) (* sbY 2))
  )
  (setq epPT1 (polar (polar V1BasePt 0 epX) (* pi 0.5) epY)
	epPT2 (polar epPT1 pi (* epX 2))
	epPT3 (polar epPT2 (* pi 1.5) (* epY 2))
	epPT4 (polar epPT3 0 (* epX 2))
  )
  (setq cPT1 (polar V1BasePt 0 (+ tpX 5))
	cPT2 (polar V1BasePt (* pi 0.5) (+ tpY 5))
	cPT3 (polar V1BasePt pi (+ tpX 5))
	cPT4 (polar V1BasePt (* pi 1.5) (+ tpY 5))
  )
  (setq gpnHD1 (nth (xh_get gpnD gpnHDLst) gpnHD1Lst)
	cgpnPT1 (polar (polar V1BasePt 0 gpnX) (* pi 0.5) gpnY)
	cgpnPT2 (polar cgpnPT1 pi (* gpnX 2))
	cgpnPT3 (polar cgpnPT2 (* pi 1.5) (* gpnY 2))
	cgpnPT4 (polar cgpnPT1 (* pi 1.5) (- (* gpnY 2) 2))
  )
  (setq crpnPT1 (polar (polar V1BasePt 0 rpnX) (* pi 0.5) rpnY)
        crpnPT2 (polar crpnPT1 pi (* rpnX 2))
	crpnPT3 (polar crpnPT2 (* pi 1.5) (* rpnY 2))
	crpnPT4 (polar crpnPT1 (* pi 1.5) (* rpnY 2))
  )
  (setq spnHH   (nth (xh_get spnD spnHDLst) spnHHLst)
	spnHD1  (nth (xh_get spnD spnHDLst) spnHD1Lst)
        spnHDD  (nth (xh_get spnD spnHDLst) spnHDDLst)
	spnCT   (nth (xh_get spnD spnHDLst) spnDHLst)
	spnCD   (nth (xh_get spnD spnHDLst) spnCDLst)
	spnCS   (nth (xh_get spnD spnHDLst) spnCSLst)
	cspnPT1 (polar (polar V1BasePt 0 spnX) (* pi 0.5) spnY)
        cspnPT2 (polar cspnPT1 pi (* spnX 2))
	cspnPT3 (polar cspnPT2 (* pi 1.5) (* spnY 2))
	cspnPT4 (polar cspnPT1 (* pi 1.5) (- (* spnY 2) 2))
  )
  (setq scr1PT1 (polar (polar V1BasePt 0 scr1X) (* pi 0.5) scr1Y)
	scr1PT2 (polar scr1PT1 pi (* scr1X 2))
	scr1PT3 (polar scr1PT2 (* pi 1.5) (* scr1Y 2))
	scr1PT4 (polar scr1PT1 (* pi 1.5) (* scr1Y 2))
  )
  (setq scr2PT1 (polar (polar V1BasePt 0 scr2X) (* pi 0.5) scr2Y)
	scr2PT2 (polar scr2PT1 pi (* scr2X 2))
	scr2PT3 (polar scr2PT2 (* pi 1.5) (* scr2Y 2))
	scr2PT4 (polar scr2PT1 (* pi 1.5) (* scr2Y 2))
  )
  (cond
    ((= 4 scr3Num)
      (setq scr3PT1 (polar (polar V1BasePt 0 scr3X) (* pi 0.5) scr3Y)
	    scr3PT2 (polar scr3PT1 pi (* scr3X 2))
	    scr3PT3 (polar scr3PT2 (* pi 1.5) (* scr3Y 2))
	    scr3PT4 (polar scr3PT1 (* pi 1.5) (* scr3Y 2))
      )
    )
    ((= 6 scr3Num)
      (setq scr3PT1 (polar (polar V1BasePt 0 scr3X) (* pi 0.5) scr3Y)
	    scr3PT2 (polar scr3PT1 pi (* scr3X 2))
	    scr3PT3 (polar scr3PT2 (* pi 1.5) (* scr3Y 2))
	    scr3PT4 (polar scr3PT1 (* pi 1.5) (* scr3Y 2))
	    scr3PT5 (polar V1BasePt 0 scr3X)
	    scr3PT6 (polar V1BasePt pi scr3X)
      )
    )
  )
  (setq scr1D1 (nth (xh_get scr1D scrMLst) scrDLst)
	scr1D2 (nth (xh_get scr1D scrMLst) scrDdLst)
	scr2D1 (nth (xh_get scr2D scrMLst) scrDLst)
	scr2D2 (nth (xh_get scr2D scrMLst) scrDdLst)
	scr3D1 (nth (xh_get scr3D scrMLst) scrDLst)
	scr3D2 (nth (xh_get scr3D scrMLst) scrDdLst)
  )
;;LCA - WARNING: The OSMODE sysvar has changed.
;;LCA - WARNING: The OSMODE sysvar has changed.
  (setvar "osmode" 0)
  (setvar "cecolor" "bylayer")
  (setvar "celtype" "bylayer")
  (setvar "clayer" "continuous")
  (if (= "I" (substr MoldTypeNum 3 1))
    (progn
      (command "line" tpPT1 tpPt2 tpPT3 tpPT4 "c")
      (command "line" sbPT1 sbPT4 ""
	       "line" sbPT6 sbPT7 "")
    )
    (command "line" sbPT1 sbPT6 sbPT7 sbPT4 "c")
  )
  (command "circle" cgpnPT1 (/ gpnD  2.0)
	   "circle" cgpnPT2 (/ gpnD  2.0)
	   "circle" cgpnPT3 (/ gpnD  2.0)
	   "circle" cgpnPT4 (/ gpnD  2.0)
  )
  (command "circle" cspnPT1 (/ (+ 1 spnCD)  2.0)
	   "circle" cspnPT2 (/ (+ 1 spnCD)  2.0)
	   "circle" cspnPT3 (/ (+ 1 spnCD)  2.0)
	   "circle" cspnPT4 (/ (+ 1 spnCD)  2.0)
  )
  (if (= "1" IfAddSpg)
    (progn
      (load "MoldSpgZ")
      (setvar "clayer" "spring")
      (setq rep "S1")
      (MoldSpgZst crpnPT1 SpgOd SpgTyp SpgLen "1")
      (MoldSpgZst crpnPT2 SpgOd SpgTyp SpgLen "1")
      (MoldSpgZst crpnPT3 SpgOd SpgTyp SpgLen "1")
      (MoldSpgZst crpnPT4 SpgOd SpgTyp SpgLen "1")
    )
    (command "circle" crpnPT1 (/ rpnD 2.0)
	     "circle" crpnPT2 (/ rpnD 2.0)
	     "circle" crpnPT3 (/ rpnD 2.0)
	     "circle" crpnPT4 (/ rpnD 2.0)
    )
  )
  (setvar "clayer" "hidden")
  (command "line" sbPT2 sbPT3 ""
	   "line" sbPT5 sbPT8 ""
	   "line" epPT1 epPT4 ""
	   "line" epPT2 epPT3 ""
  )

  (command "circle" cgpnPT1 (/ (+ 5 gpnD)  2.0)
	   "circle" cgpnPT2 (/ (+ 5 gpnD)  2.0)
	   "circle" cgpnPT3 (/ (+ 5 gpnD)  2.0)
	   "circle" cgpnPT4 (/ (+ 5 gpnD)  2.0)
  )

  (if (and TapHaD TapHbD)
    (progn
      (setq aTapPt  (polar V1BasePt  (* pi 0.5) cpY)
	    aTapPT1 (polar aTapPt pi (/ TapHaD 2.0))
	    aTapPT2 (polar aTapPt pi (/ (* 0.8 TapHaD) 2))
	    aTapPT4 (polar aTapPt 0  (/ TapHaD 2.0))
	    aTapPT3 (polar aTapPt 0  (/ (* 0.8 TapHaD) 2))
	    aTapPT5 (polar aTapPt (* pi 1.5) TapHaL)
	    aTapPT6 (polar aTapPT5 2.618  (/ (* TapHaD 0.4) (cos 0.5236)))
	    aTapPT7 (polar aTapPT5 0.5236 (/ (* TapHaD 0.4) (cos 0.5236)))

	    bTapPT  (polar V1BasePt  (* pi 1.5) cpY)
	    bTapPT1 (polar bTapPt pi (/ TapHbD 2.0))
	    bTapPT2 (polar bTapPt pi (/ (* 0.8 TapHbD) 2))
	    bTapPT4 (polar bTapPt 0  (/ TapHbD 2.0))
	    bTapPT3 (polar bTapPt 0  (/ (* 0.8 TapHbD) 2))
	    bTapPT5 (polar bTapPt (* pi 0.5) TapHbL)
	    bTapPT6 (polar bTapPT5 3.6552  (/ (* TapHbD 0.4) (cos 0.5236)))
	    bTapPT7 (polar bTapPT5 -0.5236 (/ (* TapHbD 0.4) (cos 0.5236)))
      )
      (command "line" aTapPT1 (polar aTapPT1 (* pi 1.5) TapHaI) (polar aTapPT4 (* pi 1.5) TapHaI) aTapPT4 ""
	       "line" aTapPT2 aTapPT6 aTapPT5 aTapPT7 aTapPT3 ""
	       "line" aTapPT6 aTapPT7 ""
	       "line" bTapPT1 (polar bTapPT1 (* pi 0.5) TapHbI) (polar bTapPT4 (* pi 0.5) TapHbI) bTapPT4 ""
	       "line" bTapPT2 bTapPT6 bTapPT5 bTapPT7 bTapPT3 ""
	       "line" bTapPT6 bTapPT7 ""
      )
    )
  )
;------------------------------------------------
;Draw screw flat view
;------------------------------------------------
  (load "MoldCapZ")
  (setvar "clayer" "screw")
  (MoldCapZ (nth (xh_get scr1D scrMLst) scrMMlst) scr1PT1 "1")
  (MoldCapZ (nth (xh_get scr1D scrMLst) scrMMlst) scr1PT2 "1")
  (MoldCapZ (nth (xh_get scr1D scrMLst) scrMMlst) scr1PT3 "1")
  (MoldCapZ (nth (xh_get scr1D scrMLst) scrMMlst) scr1PT4 "1")

  (MoldCapZ (nth (xh_get scr2D scrMLst) scrMMlst) scr2PT1 "1")
  (MoldCapZ (nth (xh_get scr2D scrMLst) scrMMlst) scr2PT2 "1")
  (MoldCapZ (nth (xh_get scr2D scrMLst) scrMMlst) scr2PT3 "1")
  (MoldCapZ (nth (xh_get scr2D scrMLst) scrMMlst) scr2PT4 "1")

  (MoldCapZ (nth (xh_get scr3D scrMLst) scrMMlst) scr3PT1 "1")
  (MoldCapZ (nth (xh_get scr3D scrMLst) scrMMlst) scr3PT2 "1")
  (MoldCapZ (nth (xh_get scr3D scrMLst) scrMMlst) scr3PT3 "1")
  (MoldCapZ (nth (xh_get scr3D scrMLst) scrMMlst) scr3PT4 "1")
  (if (= 6 scr1Num)
    (progn
      (MoldCapZ (nth (xh_get scr3D scrMLst) scrMMlst) scr3PT5 "1")
      (MoldCapZ (nth (xh_get scr3D scrMLst) scrMMlst) scr3PT6 "1")
    )
  )
;--------------------------------------------------------
;Defun Extent Data
;--------------------------------------------------------
  (setvar "clayer" "center")
  (setq ExData1 (list (list -3 (list "V1X" (cons 1000 (strcat MoldTypeNum MoldSpecNum "A" aP "B" bP "C" sbP))))))
  (setq ExData2 (list (list -3 (list "V1Y" (cons 1000 (strcat (itoa bpZ) " " (itoa epZ) " " (itoa erpZ) " " (rtos sbPThk 2 2) " " (itoa spZ) " "
							      (rtos bPThk 2 2)  " " (itoa stZ) " " (rtos aPThk 2 2) " " (itoa rpZ) " " (itoa tpZ)))))))
  (command "line" cPT1 cPT3 "")
  (mxdata (entlast) ExData1)
  (command "line" cPT2 cPT4 "")
  (mxdata (entlast) ExData2)
;--------------------------------------------------------
  (command "line" (polar cgpnPT1 0          (+ (/ gpnD 2.0) 5)) (polar cgpnPT1 pi         (+ (/ gpnD 2.0) 5)) ""
	   "line" (polar cgpnPT1 (* pi 0.5) (+ (/ gpnD 2.0) 5)) (polar cgpnPT1 (* pi 1.5) (+ (/ gpnD 2.0) 5)) ""
           "line" (polar cgpnPT2 0          (+ (/ gpnD 2.0) 5)) (polar cgpnPT2 pi         (+ (/ gpnD 2.0) 5)) ""
	   "line" (polar cgpnPT2 (* pi 0.5) (+ (/ gpnD 2.0) 5)) (polar cgpnPT2 (* pi 1.5) (+ (/ gpnD 2.0) 5)) ""
           "line" (polar cgpnPT3 0          (+ (/ gpnD 2.0) 5)) (polar cgpnPT3 pi         (+ (/ gpnD 2.0) 5)) ""
	   "line" (polar cgpnPT3 (* pi 0.5) (+ (/ gpnD 2.0) 5)) (polar cgpnPT3 (* pi 1.5) (+ (/ gpnD 2.0) 5)) ""
           "line" (polar cgpnPT4 0          (+ (/ gpnD 2.0) 5)) (polar cgpnPT4 pi         (+ (/ gpnD 2.0) 5)) ""
	   "line" (polar cgpnPT4 (* pi 0.5) (+ (/ gpnD 2.0) 5)) (polar cgpnPT4 (* pi 1.5) (+ (/ gpnD 2.0) 5)) ""
  )
  (command "line" (polar crpnPT1 0          (+ (/ rpnD 2.0) 2)) (polar crpnPT1 pi         (+ (/ rpnD 2.0) 2)) ""
	   "line" (polar crpnPT1 (* pi 0.5) (+ (/ rpnD 2.0) 2)) (polar crpnPT1 (* pi 1.5) (+ (/ rpnD 2.0) 2)) ""
           "line" (polar crpnPT2 0          (+ (/ rpnD 2.0) 2)) (polar crpnPT2 pi         (+ (/ rpnD 2.0) 2)) ""
	   "line" (polar crpnPT2 (* pi 0.5) (+ (/ rpnD 2.0) 2)) (polar crpnPT2 (* pi 1.5) (+ (/ rpnD 2.0) 2)) ""
           "line" (polar crpnPT3 0          (+ (/ rpnD 2.0) 2)) (polar crpnPT3 pi         (+ (/ rpnD 2.0) 2)) ""
	   "line" (polar crpnPT3 (* pi 0.5) (+ (/ rpnD 2.0) 2)) (polar crpnPT3 (* pi 1.5) (+ (/ rpnD 2.0) 2)) ""
           "line" (polar crpnPT4 0          (+ (/ rpnD 2.0) 2)) (polar crpnPT4 pi         (+ (/ rpnD 2.0) 2)) ""
	   "line" (polar crpnPT4 (* pi 0.5) (+ (/ rpnD 2.0) 2)) (polar crpnPT4 (* pi 1.5) (+ (/ rpnD 2.0) 2)) ""
  )
  (command "line" (polar cspnPT1 0          (+ (/ spnCD 2.0) 3)) (polar cspnPT1 pi         (+ (/ spnCD 2.0) 3)) ""
	   "line" (polar cspnPT1 (* pi 0.5) (+ (/ spnCD 2.0) 3)) (polar cspnPT1 (* pi 1.5) (+ (/ spnCD 2.0) 3)) ""
           "line" (polar cspnPT2 0          (+ (/ spnCD 2.0) 3)) (polar cspnPT2 pi         (+ (/ spnCD 2.0) 3)) ""
	   "line" (polar cspnPT2 (* pi 0.5) (+ (/ spnCD 2.0) 3)) (polar cspnPT2 (* pi 1.5) (+ (/ spnCD 2.0) 3)) ""
           "line" (polar cspnPT3 0          (+ (/ spnCD 2.0) 3)) (polar cspnPT3 pi         (+ (/ spnCD 2.0) 3)) ""
	   "line" (polar cspnPT3 (* pi 0.5) (+ (/ spnCD 2.0) 3)) (polar cspnPT3 (* pi 1.5) (+ (/ spnCD 2.0) 3)) ""
           "line" (polar cspnPT4 0          (+ (/ spnCD 2.0) 3)) (polar cspnPT4 pi         (+ (/ spnCD 2.0) 3)) ""
	   "line" (polar cspnPT4 (* pi 0.5) (+ (/ spnCD 2.0) 3)) (polar cspnPT4 (* pi 1.5) (+ (/ spnCD 2.0) 3)) ""
  )
  (if (and TapHaD TapHbD) 
    (command "line" (polar aTapPT (* pi 0.5) 5) (polar aTapPT5 (* pi 1.5) 4) ""
	     "line" (polar bTapPT (* pi 0.5) 5) (polar bTapPT5 (* pi 1.5) 4) ""
    )
  )
;------------------------------------
;Dim
;------------------------------------
  (setvar "clayer" "dim")
  (command "dim"
           "ver" (polar (polar V1BasePt (* pi 1.5) scr2Y) pi (+ 2 (/ scr2D2 2.0) scr2X)) (polar (polar V1BasePt (* pi 0.5) scr2Y) pi (+ 2 (/ scr2D2 2.0) scr2X))
	         (polar v1BasePt pi (+ tpX 8)) (strcat (itoa (* scr2Y 2)) " S.C.H.S")
           "ver" (polar (polar V1BasePt (* pi 1.5) gpnY) pi (+ 2 (/ gpnHD1 2.0) gpnX)) (polar (polar V1BasePt (* pi 0.5) gpnY) pi (+ 2 (/ gpnHD1 2.0) gpnX))
	         (polar v1BasePt pi (+ tpX 16)) (strcat (itoa (* gpnY 2)) " LEADER PIN")
           "ver" (polar (polar V1BasePt (* pi 1.5) scr3Y) pi (+ 2 (/ scr3D2 2.0) scr3X)) (polar (polar V1BasePt (* pi 0.5) scr3Y) pi (+ 2 (/ scr3D2 2.0) scr3X))
	         (polar v1BasePt pi (+ tpX 24)) (strcat (itoa (* scr3Y 2)) " S.C.H.S")
           "ver" (polar (polar V1BasePt (* pi 1.5) spnY) pi (+ 2 (/ spnHD1 2.0) spnX)) (polar (polar V1BasePt (* pi 0.5) spnY) pi (+ 2 (/ spnHD1 2.0) spnX))
	         (polar v1BasePt pi (+ tpX 32)) (strcat (itoa (* spnY 2)) " LEADER PIN")
           "ver" (polar (polar V1BasePt (* pi 1.5) scr1Y) pi (+ 2 (/ scr1D2 2.0) scr1X)) (polar (polar V1BasePt (* pi 0.5) scr1Y) pi (+ 2 (/ scr1D2 2.0) scr1X))
	         (polar v1BasePt pi (+ tpX 40)) (strcat (itoa (* scr1Y 2)) " S.C.H.S")
           "ver" tpPT2 tpPT3 (polar v1BasePt pi (+ tpX 48)) (itoa (* tpY 2))

           "ver" (polar (polar V1BasePt (* pi 1.5) rpnY) 0 (+ 2 (/ rpnD 2.0) rpnX)) (polar (polar V1BasePt (* pi 0.5) rpnY) 0 (+ 2 (/ rpnD 2.0) rpnX))
	         (polar v1BasePt 0 (+ tpX 16)) (strcat (itoa (* rpnY 2)) " RETURN PIN")
           "ver" (polar (polar V1BasePt (* pi 1.5) (- spnY 2)) 0 (+ 2 (/ spnHD1 2.0) spnX)) (polar v1BasePt 0 (+ tpX 5)) 
    	         (polar (polar V1BasePt (* pi 1.5) (/ spnY 2.0)) 0 (+ tpX 8)) (strcat (itoa (- spnY 2)) " OFFSET")
           "ver" (polar (polar V1BasePt (* pi 0.5) spnY) 0 (+ 2 (/ spnHD1 2.0) spnX)) (polar v1BasePt 0 (+ tpX 5)) 
    	         (polar (polar V1BasePt (* pi 0.5) (/ spnY 2.0)) 0 (+ tpX 8)) (itoa spnY)

           "hor" (polar (polar V1BasePt pi rpnX) (* pi 0.5) (+ 2 (/ rpnD 2.0) rpnY)) (polar (polar V1BasePt 0 rpnX) (* pi 0.5) (+ 2 (/ rpnD 2.0) rpnY))
	         (polar v1BasePt (* pi 0.5) (+ tpY 10)) (strcat (itoa (* rpnX 2)) " RETURN PIN")
           "hor" (polar (polar V1BasePt pi scr1X) (* pi 0.5) (+ 2 (/ scr1D2 2.0) scr1Y)) (polar (polar V1BasePt 0 scr1X) (* pi 0.5) (+ 2 (/ scr1D2 2.0) scr1Y))
	         (polar v1BasePt (* pi 0.5) (+ tpY 18)) (strcat (itoa (fix (* scr1X 2))) " S.C.H.S")

           "hor" (polar (polar V1BasePt pi gpnX) (* pi 0.5) (+ 2 (/ gpnHD1 2.0) spnY)) (polar (polar V1BasePt 0 gpnX) (* pi 0.5) (+ 2 (/ gpnHD1 2.0) gpnY))
	         (polar v1BasePt (* pi 0.5) (+ tpY 26)) (strcat (itoa (* gpnX 2)) " LEADER PIN")
           "hor" (polar (polar V1BasePt pi scr3X) (* pi 0.5) (+ 2 (/ scr3D2 2.0) scr3Y)) (polar (polar V1BasePt 0 scr3X) (* pi 0.5) (+ 2 (/ scr3D2 2.0) scr3Y))
	         (polar v1BasePt (* pi 0.5) (+ tpY 34)) (strcat (itoa (fix (* scr3X 2))) " S.C.H.S")

           "hor" epPT3 epPT4 (polar v1BasePt (* pi 1.5) (+ cpY 10)) (itoa (* epX 2))
           "hor" sbPT3 sbPT4 (polar (polar sbPT3 0 (/ (- sbX2 sbX1) 2)) (* pi 1.5) 10) (itoa (- sbX2 sbX1))
           "hor" sbPT7 sbPT8 (polar (polar sbPT8 0 (/ (- sbX2 sbX1) 2)) (* pi 1.5) 10) (itoa (- sbX2 sbX1))
	   "exit"
  )
  (if (> tpX cpX)
    (command "dim"
             "hor" tpPT1 tpPT2 (polar v1BasePt (* pi 0.5) (+ tpY 42)) (itoa (* tpX 2))
	     "exit"
    )
  )
  (setq ofPT1 (polar cspnPT4 -0.7854 (/ (+ (- cpY spnY -2) 30) (sin 0.7854)))
	ofPT2 (polar ofPT1 0 37)
  )
  (command "line" cspnPT4 ofPT1 ofPT2 "")
  (command "text" "s" "lxy3" (polar ofPT1 (* pi 0.5) 1) "" "OFFSET")
  (command "text" "s" "lxy3" "j" "c" (polar V1BasePt (* pi 1.5) (+ cpY 45)) "" "EJ. SIDE PLAN VIEW")
)

;###############################################################################################################################
(defun drawPPMoldView2()
  (setq bpPt  (polar V2BasePt pi bpZ)
	ep1Pt (polar bpPt pi 5)
	ep2Pt (polar ep1Pt pi epZ)
	erpPt (polar ep2Pt pi erpZ)
	b1Pt  (polar bpPt pi (+ sbPThk spZ))
	b2Pt  (polar b1Pt pi bPThk)
	a1Pt  (polar b2Pt pi (+ stZ 1))
	a2Pt  (polar a1Pt pi aPThk)
	sbPt  (polar bpPt pi sbPThk)
        tp1Pt (polar a2Pt pi rpZ)
        tp2Pt (polar tp1Pt pi tpZ)
  )
  (if (> spZ 1)
    (setq spPt sbpt)
    (setq spPt nil)
  ) 
  (if (> rpZ 1)
    (setq rpPt (polar a2Pt pi rpZ))
    (setq rpPt nil)
  )
  (if (> stZ 1)
    (setq stPt (polar b2Pt pi 1))
    (setq stPt nil)
  )
  (setq rpnPt  (list (car ep2Pt) (- (cadr V2BasePt) rpnY) 0.0))
  (setq rpnPT1 (polar (polar b1Pt 0 spZ) (* pi 1.5) (- rpnY (/ rpnD 2.0)))
	rpnPT2 (polar rpnPT1 (* pi 1.5) rpnD)
	rpnPT3 (polar b1Pt   (* pi 1.5) (- rpnY (/ rpnD 2.0)))
	rpnPT4 (polar rpnPT3 (* pi 1.5) rpnD)
  ) 
  (setvar "clayer" "continuous")
  (command "line" (polar V2BasePt (* pi 0.5) tpY) (polar bpPt (* pi 0.5) tpY) (polar bpPt (* pi 1.5) tpY) (polar V2BasePt (* pi 1.5) tpY) "")
  (command "line" (polar bpPt (* pi 0.5) cpY) (polar sbPt (* pi 0.5) cpY) rpnPT1 ""
	   "line" rpnPT2  (polar sbPt (* pi 1.5) cpY) (polar bpPt (* pi 1.5) cpY) ""
  )
  (command "line" (polar ep1Pt (* pi 0.5) cpY) (polar ep1Pt (* pi 1.5) cpY) ""
           "line" (polar ep2Pt (* pi 0.5) cpY) (polar ep2Pt (* pi 1.5) cpY) ""
	   "line" (polar ep2Pt (* pi 0.5) cpY) (polar erpPt (* pi 0.5) cpY) (polar erpPt (* pi 1.5) (- rpnY (/ rpnD 2.0))) ""
	   "line" (polar erpPt (* pi 1.5) (+ rpnY (/ rpnD 2.0))) (polar erpPt (* pi 1.5) cpY) (polar ep2Pt (* pi 1.5) cpY) ""
  )
  (command "line" rpnPT3 (polar b1Pt (* pi 0.5) cpY) (polar b2Pt (* pi 0.5) cpY) (polar b2Pt (* pi 1.5) (- rpnY (/ rpnD 2.0))) ""
	   "line" (polar b2Pt (* pi 1.5) (+ rpnY (/ rpnD 2.0))) (polar b2Pt (* pi 1.5) cpY) (polar b1Pt (* pi 1.5) cpY) rpnPT4 "")
  (command "line" (polar a1Pt (* pi 0.5) cpY) (polar a2Pt (* pi 0.5) cpY) (polar a2Pt (* pi 1.5) cpY) (polar a1Pt (* pi 1.5) cpY) "c")
  (command "line" (polar ep1Pt (* pi 1.5) (- rpnY 7)) (polar (polar ep1Pt (* pi 1.5) (- rpnY 8)) 0 1) (polar (polar ep1Pt (* pi 1.5) (- rpnY 8)) 0 5)
		  (polar (polar ep1Pt (* pi 1.5) (+ rpnY 8)) 0 5) (polar (polar ep1Pt (* pi 1.5) (+ rpnY 8)) 0 1) (polar ep1Pt (* pi 1.5) (+ rpnY 7)) ""
	   "line" (polar (polar ep1Pt (* pi 1.5) (- rpnY 8)) 0 1) (polar (polar ep1Pt (* pi 1.5) (+ rpnY 8)) 0 1) ""
	   "line" (polar bpPt (* pi 1.5) (- rpnY 4)) (polar V2BasePt (* pi 1.5) (- rpnY 4)) ""
	   "line" (polar bpPt (* pi 1.5) (+ rpnY 4)) (polar V2BasePt (* pi 1.5) (+ rpnY 4)) ""
	   "line" (polar (polar bpPt (* pi 1.5) (- rpnY 4)) 0 9) (polar (polar bpPt (* pi 1.5) (- rpnY 3)) 0 10)
		  (polar (polar bpPt (* pi 1.5) (+ rpnY 3)) 0 10) (polar (polar bpPt (* pi 1.5) (+ rpnY 4)) 0 9) ""
	   "line" (polar (polar bpPt (* pi 1.5) (- rpnY 4)) 0 9) (polar (polar bpPt (* pi 1.5) (+ rpnY 4)) 0 9) ""
  )
  (command "line" (polar tp1Pt (* pi 0.5) tpY) (polar tp2Pt (* pi 0.5) tpY) 
	          (polar tp2Pt (* pi 1.5) tpY) (polar tp1Pt (* pi 1.5) tpY) "c"
  )

  (if spPt
    (command "line" (polar sbPt (* pi 0.5) cpY) (polar b1Pt (* pi 0.5) cpY) ""
	     "line" (polar sbPt (* pi 1.5) cpY) (polar b1Pt (* pi 1.5) cpY) ""
    )
  )
  (if rpPt
    (command "line" (polar a2Pt (* pi 0.5) cpY) (polar rpPt (* pi 0.5) cpY) ""
	     "line" (polar a2Pt (* pi 1.5) cpY) (polar rpPt (* pi 1.5) cpY) ""
    )
  )
  (if stPt
    (command "line" (polar a1Pt (* pi 1.5) cpY) (polar stPt (* pi 1.5) cpY) (polar stPt (* 0.5 pi) cpY) (polar a1Pt (* 0.5 pi) cpY) "")
  )
  (if (> rpnD 21)
    (setq rpnH 8)
    (setq rpnH 4)
  )
  (setq rpnPT5  (polar rpnPt (* pi 0.5) (/ (+ rpnD 5) 2.0))
	rpnPT6  (polar rpnPt (* pi 1.5) (/ (+ rpnD 5) 2.0))
	rpnPT7  (polar rpnPT5 (* pi 0.5) 1)
	rpnPT8  (polar rpnPT6 (* pi 1.5) 1)
      	rpnPT9  (polar (polar rpnPt (* pi 0.5) (/ rpnD 2.0)) pi rpnH)
      	rpnPT10 (polar (polar rpnPt (* pi 1.5) (/ rpnD 2.0)) pi rpnH)
  )
  (command "line" rpnPT7 (polar rpnPT7 pi rpnH) (polar rpnPT8 pi rpnH) rpnPT8 ""
	   "line" rpnPT5 (polar rpnPT5 pi rpnH) ""
	   "line" rpnPT6 (polar rpnPT6 pi rpnH) ""
  )
  (command "line" rpnPT9  (polar (polar b2Pt (* pi 1.5) (- rpnY (/ rpnD 2.0))) pi 1) ""
           "line" rpnPT10 (polar (polar b2Pt (* pi 1.5) (+ rpnY (/ rpnD 2.0))) pi 1) ""
  )
  (if (and TapHaD TapHbD)
    (progn
      (setq aTapPt  (polar (polar a1Pt (* pi 0.5) cpY) pi (/ aPThk 2.0))
	    aTapPT1 (polar aTapPt pi (/ TapHaD 2.0))
	    aTapPT2 (polar aTapPt pi (/ (* 0.8 TapHaD) 2))
	    aTapPT4 (polar aTapPt 0  (/ TapHaD 2.0))
	    aTapPT3 (polar aTapPt 0  (/ (* 0.8 TapHaD) 2))
	    aTapPT5 (polar aTapPt (* pi 1.5) TapHaL)
	    aTapPT6 (polar aTapPT5 2.618 (/ (* TapHaD 0.4) (cos 0.5236)))
	    aTapPT7 (polar aTapPT5 0.5236 (/ (* TapHaD 0.4) (cos 0.5236)))

	    bTapPT (polar (polar b1Pt (* pi 0.5) cpY) pi (/ bPThk 2))
	    bTapPT1 (polar bTapPt pi (/ TapHbD 2.0))
	    bTapPT2 (polar bTapPt pi (/ (* 0.8 TapHbD) 2))
	    bTapPT4 (polar bTapPt 0  (/ TapHbD 2.0))
	    bTapPT3 (polar bTapPt 0  (/ (* 0.8 TapHbD) 2))
	    bTapPT5 (polar bTapPt (* pi 1.5) TapHbL)
	    bTapPT6 (polar bTapPT5 2.618  (/ (* TapHbD 0.4) (cos 0.5236)))
	    bTapPT7 (polar bTapPT5 0.5236 (/ (* TapHbD 0.4) (cos 0.5236)))
      )
      (command "line" aTapPT1 (polar aTapPT1 (* pi 1.5) TapHaI) (polar aTapPT4 (* pi 1.5) TapHaI) aTapPT4 ""
	       "line" aTapPT2 aTapPT6 aTapPT5 aTapPT7 aTapPT3 ""
	       "line" aTapPT6 aTapPT7 ""
	       "line" bTapPT1 (polar bTapPT1 (* pi 1.5) TapHbI) (polar bTapPT4 (* pi 1.5) TapHbI) bTapPT4 ""
	       "line" bTapPT2 bTapPT6 bTapPT5 bTapPT7 bTapPT3 ""
	       "line" bTapPT6 bTapPT7 ""
      )
    )
  )
  (if (= "1" IfAddSpg)
    (progn
      (command "line" (polar sbPt (* pi 1.5) (- rpnY (+ (/ SpgOd 2.0) 1))) (polar (polar sbPt (* pi 1.5) (- rpnY (+ (/ SpgOd 2.0) 1))) pi SpgHolDep)
		      (polar (polar sbPt (* pi 1.5) (+ rpnY (+ (/ SpgOd 2.0) 1))) pi SpgHolDep) (polar sbPt (* pi 1.5) (+ rpnY (+ (/ SpgOd 2.0) 1))) ""
      )
      (setvar "clayer" "spring")
      (load "MoldSpgC")
      (MoldSpgCst (polar erpPt (* pi 1.5) rpnY) (polar (polar sbPt (* pi 1.5) rpnY) pi SpgHolDep) SpgTyp SpgLen SpgOd SpgId SpgA SpgB "0")
    )
  )
;----------------------------------------------------------------
;Defun Extent Entry Data
;----------------------------------------------------------------
  (setvar "clayer" "continuous")
  (setq ExData1 (list (list -3 (list "V2X" (cons 1000 " ")))))
  (setq ExData2 (list (list -3 (list "V2Y" (cons 1000 " ")))))

  (command "line" (polar V2BasePt (* pi 0.5) tpY) (polar V2BasePt (* pi 1.5) tpY) "")
  (mxdata (entlast) ExData2)

  (setvar "clayer" "center")
  (command "line" (polar V2BasePt 0 8) (polar V2BasePt pi (+ bpZ sbPThk stZ spZ aPThk bPThk rpZ tpZ 8)) "")
  (mxdata (entlast) ExData1)
;----------------------------------------------------------------
  (command "line" (polar rpnPt 0 4) (polar (polar b2Pt (* pi 1.5) rpnY) pi 4) "")
  (if (and TapHaD TapHbD) 
    (command "line" (polar aTapPT (* pi 0.5) 5) (polar aTapPT5 (* pi 1.5) 4) ""
	     "line" (polar bTapPT (* pi 0.5) 5) (polar bTapPT5 (* pi 1.5) 4) ""
    )
  )
  (command "line" (polar (polar bpPt (* pi 1.5) rpnY) pi 8) (polar (polar V2BasePt (* pi 1.5) rpnY) 0 3) "")
;-------------------------------------------
;dim
;-------------------------------------------
  (setvar "clayer" "dim")
  (command "dim"
	   "hor" (polar (polar V2BasePt pi (+ bpZ sbPThk bPThk aPThk rpZ spZ stZ tpZ 1.0)) (* pi 1.5) cpY) (polar V2BasePt (* pi 1.5) cpY) 
		 (polar (polar V2BasePt pi (/ (+ bpZ sbPThk bPThk aPThk rpZ spZ stZ tpZ 1.0) 2.0))  (* pi 1.5) (+ cpY 10)) 
		 (itoa (fix (+ bpZ sbPThk bPThk aPThk rpZ spZ stZ tpZ 1)))
	   "hor" (polar a2Pt (* pi 0.5) cpY) (polar a1Pt (* pi 0.5) cpY) (polar (polar a2Pt 0 (/ aPThk 2.0))  (* pi 0.5) (+ cpY 19)) aP
	   "hor" (polar b2Pt (* pi 0.5) cpY) (polar b1Pt (* pi 0.5) cpY) (polar (polar b2Pt 0 (/ bPThk 2.0))  (* pi 0.5) (+ cpY 19)) bP
	   "hor" (polar sbPt (* pi 0.5) cpY) (polar bpPt (* pi 0.5) cpY) (polar (polar sbPt 0 (/ sbPThk 2.0)) (* pi 0.5) (+ cpY 19)) sbP
	   "hor" (polar bpPt (* pi 0.5) cpY) (polar v2BasePt (* pi 0.5) cpY) (polar (polar bpPt 0 (/ bpZ 2.0)) (* pi 0.5) (+ cpY 19)) (itoa bpZ)
	   "hor" (polar ep2Pt (* pi 0.5) cpY) (polar erpPt (* pi 0.5) cpY) (polar (polar erpPt 0 (/ erpZ 2.0))  (* pi 0.5) (+ cpY 10)) (itoa erpZ)
	   "hor" (polar ep2Pt (* pi 0.5) cpY) (polar ep1Pt (* pi 0.5) cpY) (polar (polar ep2Pt 0 (/ epZ 2.0))  (* pi 0.5) (+ cpY 10)) (itoa epZ)
	   "hor" (polar ep1Pt (* pi 0.5) cpY) (polar bpPt (* pi 0.5) cpY) (polar (polar ep1Pt 0 2.5)  (* pi 0.5) (+ cpY 10)) "5"
 	   "exit"
  )
  (if (> tpZ 1)
    (command "dim"
	     "hor" (polar tp2Pt (* pi 0.5) cpY) (polar tp1Pt (* pi 0.5) cpY) (polar (polar tp2Pt 0 (/ tpZ 2.0))  (* pi 0.5) (+ cpY 19)) (itoa tpZ)
	     "exit"
    )
  )
  (if (> spZ 1)
    (command "dim"
	     "hor" (polar b1Pt (* pi 0.5) cpY) (polar spPt (* pi 0.5) cpY) (polar (polar b1Pt 0 (/ spZ 2.0))  (* pi 0.5) (+ cpY 19)) (itoa spZ)
	     "exit"
    )
  )
  (if (> stZ 1)
    (command "dim"
	     "hor" (polar a1Pt (* pi 0.5) cpY) (polar stPt (* pi 0.5) cpY) (polar (polar a1Pt 0 (/ stZ 2.0))  (* pi 0.5) (+ cpY 19)) (itoa stZ)
	     "exit"
    )
  )
  (if (> rpZ 1)
    (command "dim"
	     "hor" (polar tp1Pt (* pi 0.5) cpY) (polar a2Pt (* pi 0.5) cpY) (polar (polar tp1Pt 0 (/ spZ 2.0))  (* pi 0.5) (+ cpY 19)) (itoa rpZ)
	     "exit"
    )
  )
  (command "text" "s" "lxy3" "j" "c" (polar (polar V2BasePt (* pi 1.5) (+ cpY 45)) pi (/ (+ tpZ sbPThk spZ bPThk stZ aPThk rpZ tpZ) 2)) "" "SECTION A - A")
  (setq lhPT1 (polar (polar aTapPt (* pi 0.75) (/ 60 (sin 0.7854))) pi 35)
	lhPT2 (polar lhPT1 (* pi 1.5) 10) 
	lhPT3 (polar lhPT2 (* pi 1.5) 10) 
	lhPT4 (polar lhPT3 (* pi 1.5) 10) 
  )
  (command "line" aTapPt (polar lhPT1 0 35) lhPT1 ""
 	   "line" lhPT2  (polar lhPT2 0 35) ""
 	   "line" lhPT3  (polar lhPT3 0 35) ""
 	   "line" lhPT4  (polar lhPT4 0 35) ""
  )
  (command "text" "s" "lxy4" (polar (polar lhPT1 (* pi 0.5) 1) 0 1.5) "" "LIFT HOLE"
	   "text" "s" "lxy4" (polar (polar lhPT2 (* pi 0.5) 1) 0 1.5) "" "DR.& TAP."
	   "text" "s" "lxy4" (polar (polar lhPT3 (* pi 0.5) 1) 0 1.5) "" (strcat "M" (itoa TapHaD) "X" (itoa TapHaL))
	   "text" "s" "lxy4" (polar (polar lhPT4 (* pi 0.5) 1) 0 1.5) "" "TAP. 4"
  )
)

;################################################################################################################################
(defun drawPPMoldView3()
  (setq tpPT1 (polar (polar V3BasePt 0 tpX) (* pi 0.5) tpY)
	tpPT2 (polar tpPT1 pi (* tpX 2))
	tpPT3 (polar tpPT2 (* pi 1.5) (* tpY 2))
	tpPT4 (polar tpPT3 0 (* tpX 2))
  )
  (setq sbPT1 (polar (polar V3BasePt 0 sbX2) (* pi 0.5) sbY)
	sbPT2 (polar (polar V3BasePt 0 sbX1) (* pi 0.5) sbY)
        sbPT3 (polar sbPT2 (* pi 1.5) (* sbY 2))
        sbPT4 (polar sbPT1 (* pi 1.5) (* sbY 2))
	sbPT5 (polar (polar V3BasePt pi sbX1) (* pi 0.5) sbY)
	sbPT6 (polar (polar V3BasePt pi sbX2) (* pi 0.5) sbY)
        sbPT7 (polar sbPT6 (* pi 1.5) (* sbY 2))
        sbPT8 (polar sbPT5 (* pi 1.5) (* sbY 2))
  )
  (setq cPT1 (polar V3BasePt 0 (+ tpX 5))
	cPT2 (polar V3BasePt (* pi 0.5) (+ tpY 5))
	cPT3 (polar V3BasePt pi (+ tpX 5))
	cPT4 (polar V3BasePt (* pi 1.5) (+ tpY 5))
  )
  (setq cgpnPT1 (polar (polar V3BasePt 0 gpnX) (* pi 0.5) gpnY)
	cgpnPT2 (polar cgpnPT1 pi (* gpnX 2))
	cgpnPT4 (polar cgpnPT1 (* pi 1.5) (* gpnY 2))
	cgpnPT3 (polar cgpnPT2 (* pi 1.5) (- (* gpnY 2) 2))
  )
  (setq spnSS   (nth (xh_get spnD spnHDLst) spnSSLst))
  (setq cspnPT1 (polar (polar V3BasePt 0 spnX) (* pi 0.5) spnY)
	cspnPT2 (polar cspnPT1 pi (* spnX 2))
	cspnPT4 (polar cspnPT1 (* pi 1.5) (* spnY 2))
	cspnPT3 (polar cspnPT2 (* pi 1.5) (- (* spnY 2) 2))
  )
  (setvar "clayer" "continuous")
  (if (= "I" (substr MoldTypeNum 3 1))
    (progn
      (command "line" tpPT1 tpPt2 tpPT3 tpPT4 "c")
      (command "line" sbPT1 sbPT4 ""
	       "line" sbPT6 sbPT7 "")
    )
    (command "line" sbPT1 sbPT6 sbPT7 sbPT4 "c")
  )
  (command "circle" cgpnPT1 (/ gpnD 2.0)
	   "circle" cgpnPT2 (/ gpnD 2.0)
	   "circle" cgpnPT3 (/ gpnD 2.0)
	   "circle" cgpnPT4 (/ gpnD 2.0)
  )
  (command "circle" cgpnPT1 (/ gpnHD1 2.0)
	   "circle" cgpnPT2 (/ gpnHD1 2.0)
	   "circle" cgpnPT3 (/ gpnHD1 2.0)
	   "circle" cgpnPT4 (/ gpnHD1 2.0)
  )
  (command "circle" cspnPT1 (/ spnHDD 2.0)
	   "circle" cspnPT2 (/ spnHDD 2.0)
	   "circle" cspnPT3 (/ spnHDD 2.0)
	   "circle" cspnPT4 (/ spnHDD 2.0)
  )
  (command "circle" cspnPT1 (/ spnCD 2.0)
	   "circle" cspnPT2 (/ spnCD 2.0)
	   "circle" cspnPT3 (/ spnCD 2.0)
	   "circle" cspnPT4 (/ spnCD 2.0)
  )
  (command "circle" cspnPT1 (/ spnCS 2.0)
	   "circle" cspnPT2 (/ spnCS 2.0)
	   "circle" cspnPT3 (/ spnCS 2.0)
	   "circle" cspnPT4 (/ spnCS 2.0)
  )
  (command "polygon" "6" cspnPT1 "c" (polar cspnPT1 (* pi 0.5) (/ spnSS 2.0))
           "polygon" "6" cspnPT2 "c" (polar cspnPT2 (* pi 0.5) (/ spnSS 2.0))
           "polygon" "6" cspnPT3 "c" (polar cspnPT3 (* pi 0.5) (/ spnSS 2.0))
           "polygon" "6" cspnPT4 "c" (polar cspnPT4 (* pi 0.5) (/ spnSS 2.0))
  )
  (setvar "clayer" "hidden")
  (if (and TapHaD TapHbD)
    (progn
      (setq aTapPt (polar V3BasePt (* pi 0.5) cpY)
	    aTapPT1 (polar aTapPt pi (/ TapHaD 2.0))
	    aTapPT2 (polar aTapPt pi (/ (* 0.8 TapHaD) 2))
	    aTapPT4 (polar aTapPt 0 (/ TapHaD 2.0))
	    aTapPT3 (polar aTapPt 0 (/ (* 0.8 TapHaD) 2))
	    aTapPT5 (polar aTapPt (* pi 1.5) TapHaL)
	    aTapPT6 (polar aTapPT5 2.618 (/ (* TapHaD 0.4) (cos 0.5236)))
	    aTapPT7 (polar aTapPT5 0.5236 (/ (* TapHaD 0.4) (cos 0.5236)))

	    bTapPT (polar V3BasePt (* pi 1.5) cpY)
	    bTapPT1 (polar bTapPt pi (/ TapHbD 2.0))
	    bTapPT2 (polar bTapPt pi (/ (* 0.8 TapHbD) 2))
	    bTapPT4 (polar bTapPt 0 (/ TapHbD 2.0))
	    bTapPT3 (polar bTapPt 0 (/ (* 0.8 TapHbD) 2))
	    bTapPT5 (polar bTapPt (* pi 0.5) TapHbL)
	    bTapPT6 (polar bTapPT5 3.6552 (/ (* TapHbD 0.4) (cos 0.5236)))
	    bTapPT7 (polar bTapPT5 -0.5236 (/ (* TapHbD 0.4) (cos 0.5236)))
      )
      (command "line" aTapPT1 (polar aTapPT1 (* pi 1.5) TapHaI) (polar aTapPT4 (* pi 1.5) TapHaI) aTapPT4 ""
	       "line" aTapPT2 aTapPT6 aTapPT5 aTapPT7 aTapPT3 ""
	       "line" aTapPT6 aTapPT7 ""
	       "line" bTapPT1 (polar bTapPT1 (* pi 0.5) TapHbI) (polar bTapPT4 (* pi 0.5) TapHbI) bTapPT4 ""
	       "line" bTapPT2 bTapPT6 bTapPT5 bTapPT7 bTapPT3 ""
	       "line" bTapPT6 bTapPT7 ""
      )
    )
  )
;-------------------------------------------------------------
;Defun Extent data
;-------------------------------------------------------------
  (setvar "clayer" "center")
  (setq ExData1 (list (list -3 (list "V3X" (cons 1000 " ")))))
  (setq ExData2 (list (list -3 (list "V3Y" (cons 1000 " ")))))
  (command "line" cPT1 cPT3 "")
  (mxdata (entlast) ExData1)
  (command "line" cPT2 cPT4 "")
  (mxdata (entlast) ExData2)
;-------------------------------------------------------------
  (command "line" (polar cgpnPT1 0          (+ (/ gpnHD1 2.0) 2)) (polar cgpnPT1 pi         (+ (/ gpnHD1 2.0) 2)) ""
	   "line" (polar cgpnPT1 (* pi 0.5) (+ (/ gpnHD1 2.0) 2)) (polar cgpnPT1 (* pi 1.5) (+ (/ gpnHD1 2.0) 2)) ""
           "line" (polar cgpnPT2 0          (+ (/ gpnHD1 2.0) 2)) (polar cgpnPT2 pi         (+ (/ gpnHD1 2.0) 2)) ""
	   "line" (polar cgpnPT2 (* pi 0.5) (+ (/ gpnHD1 2.0) 2)) (polar cgpnPT2 (* pi 1.5) (+ (/ gpnHD1 2.0) 2)) ""
           "line" (polar cgpnPT3 0          (+ (/ gpnHD1 2.0) 2)) (polar cgpnPT3 pi         (+ (/ gpnHD1 2.0) 2)) ""
	   "line" (polar cgpnPT3 (* pi 0.5) (+ (/ gpnHD1 2.0) 2)) (polar cgpnPT3 (* pi 1.5) (+ (/ gpnHD1 2.0) 2)) ""
           "line" (polar cgpnPT4 0          (+ (/ gpnHD1 2.0) 2)) (polar cgpnPT4 pi         (+ (/ gpnHD1 2.0) 2)) ""
	   "line" (polar cgpnPT4 (* pi 0.5) (+ (/ gpnHD1 2.0) 2)) (polar cgpnPT4 (* pi 1.5) (+ (/ gpnHD1 2.0) 2)) ""
  )
  (command "line" (polar cspnPT1 0          (+ (/ spnHDD 2.0) 2)) (polar cspnPT1 pi         (+ (/ spnHDD 2.0) 2)) ""
	   "line" (polar cspnPT1 (* pi 0.5) (+ (/ spnHDD 2.0) 2)) (polar cspnPT1 (* pi 1.5) (+ (/ spnHDD 2.0) 2)) ""
           "line" (polar cspnPT2 0          (+ (/ spnHDD 2.0) 2)) (polar cspnPT2 pi         (+ (/ spnHDD 2.0) 2)) ""
	   "line" (polar cspnPT2 (* pi 0.5) (+ (/ spnHDD 2.0) 2)) (polar cspnPT2 (* pi 1.5) (+ (/ spnHDD 2.0) 2)) ""
           "line" (polar cspnPT3 0          (+ (/ spnHDD 2.0) 2)) (polar cspnPT3 pi         (+ (/ spnHDD 2.0) 2)) ""
	   "line" (polar cspnPT3 (* pi 0.5) (+ (/ spnHDD 2.0) 2)) (polar cspnPT3 (* pi 1.5) (+ (/ spnHDD 2.0) 2)) ""
           "line" (polar cspnPT4 0          (+ (/ spnHDD 2.0) 2)) (polar cspnPT4 pi         (+ (/ spnHDD 2.0) 2)) ""
	   "line" (polar cspnPT4 (* pi 0.5) (+ (/ spnHDD 2.0) 2)) (polar cspnPT4 (* pi 1.5) (+ (/ spnHDD 2.0) 2)) ""
  )
;-------------------------------------------------------------
;dim
;-------------------------------------------------------------
  (setvar "clayer" "dim")
  (setq ofPT1 (polar cspnPT3 3.927 (/ (+ (- cpY spnY -2) 30) (sin 0.7854)))
	ofPT2 (polar ofPT1 pi 37)
  )
  (command "line" cspnPT3 ofPT1 ofPT2 "")
  (command "text" "s" "lxy3" (polar ofPT2 (* pi 0.5) 1) "" "OFFSET")
  (command "text" "s" "lxy3" "j" "c" (polar V3BasePt (* pi 1.5) (+ cpY 45)) "" "HOT SIDE PLAN VIEW")
)

;##################################################################################################################################
(defun drawPPMoldView4()
  (setq bpPt  (polar V4BasePt (* 0.5 pi) bpZ)
	ep1Pt (polar bpPt  (* 0.5 pi) 5)
	ep2Pt (polar ep1Pt (* 0.5 pi) epZ)
	erpPt (polar ep2Pt (* 0.5 pi) erpZ)
	b1Pt  (polar bpPt  (* 0.5 pi) (+ sbPThk spZ))
	b2Pt  (polar b1Pt  (* 0.5 pi) bPThk)
	a1Pt  (polar b2Pt  (* 0.5 pi) (+ 1 stZ))
	a2Pt  (polar a1Pt  (* 0.5 pi) aPThk)
	sbPt  (polar bpPt  (* 0.5 pi) sbPThk)
        tp1Pt (polar a2Pt  (* pi 0.5) rpZ) 
        tp2Pt (polar tp1Pt (* pi 0.5) tpZ)
  )
  (setq gppnD gpnD)
  (if (> spZ 1)
    (setq spPt sbpt)
    (setq spPt nil)
  ) 
  (if (> rpZ 1)
    (setq rpPt (polar a2Pt (* 0.5 pi) rpZ))
    (setq rpPt nil)
  )
  (if (> stZ 1)
    (setq stPt (polar b2Pt (* 0.5 pi) 1))
    (setq stPt nil)
  )
  (setq gpnDD1 (+ gpnD 5)
	gpnDH  (nth (xh_get gpnD gpnHDLst) gpnDHLst)
	gpnHD1 (nth (xh_get gpnD gpnHDLst) gpnHD1Lst)
	gpnHDD (nth (xh_get gpnD gpnHDLst) gpnHDDLst)
	gpnHH  (nth (xh_get gpnD gpnHDLst) gpnHHLst)
	gpnL   (- (+ aPThk bPThk 1 stZ) (+ gpnDH 3))
  )
  (setq gpnPt   (polar b1Pt  0 gpnX)
	gpnPT1  (polar gpnPt pi (/ gpnDD1 2.0))
	gpnPT2  (polar gpnPt 0  (/ gpnDD1 2.0))
	gpnPT3  (polar (polar gpnPt pi (/ gpnD 2.0)) (* pi 0.5) gpnDH)
	gpnPT4  (polar (polar gpnPt 0  (/ gpnD 2.0)) (* pi 0.5) gpnDH)
	gpnPT5  (polar gpnPT3 (* pi 0.5) (- gpnL (* 0.1 gpnD)))
	gpnPT6  (polar gpnPT4 (* pi 0.5) (- gpnL (* 0.1 gpnD)))

	gpnPT8  (polar a2Pt 0 (- gpnX (/ gpnHDD 2.0)))
	gpnPT7  (polar gpnPT8 pi 1)
	gpnPT9  (polar a2Pt 0 (+ gpnX (/ gpnHDD 2.0)))
	gpnPT10 (polar gpnPT9 0 1)
	gpnPT11 (polar (polar a2Pt 0 (- gpnX (/ gpnHD1 2.0))) (* pi 1.5) gpnHH)
	gpnPT12 (polar (polar a2Pt 0 (+ gpnX (/ gpnHD1 2.0))) (* pi 1.5) gpnHH)
  )
  (setq spnDD1 (+ gpnD 5)
	spnDH  (nth (xh_get spnD spnHDLst) spnDHLst)
	spnHD1 (nth (xh_get spnD spnHDLst) spnHD1Lst)
	spnHDD (nth (xh_get spnD spnHDLst) spnHDDLst)
	spnHH  (nth (xh_get spnD spnHDLst) spnHHLst)
	spnSH  (nth (xh_get spnD spnHDLst) spnSHLst)
	spnL   (- (+ aPThk bPThk 1 stZ sbPThk rpZ spZ tpZ) (+ (* 2 spnDH) spnSH spnD))
  )
  (setq spnPt   (polar tp2Pt pi spnX)
	spnPPt1 (polar spnPt (* pi 1.5) (+ spnL spnDH))
	spnPPt2 (polar spnPt (* pi 1.5) (+ spnL (* 2 spnDH)))
	spnPT1  (polar spnPt pi (/ spnDD1 2.0))
	spnPT2  (polar spnPt 0  (/ spnDD1 2.0))
	spnPT3  (polar (polar spnPt pi (/ spnD 2.0)) (* pi 1.5) spnDH)
	spnPT4  (polar (polar spnPt 0  (/ gpnD 2.0)) (* pi 1.5) spnDH)
	spnPT5  (polar spnPT3 (* pi 1.5) (- spnL (* 0.1 spnD)))
	spnPT6  (polar spnPT4 (* pi 1.5) (- spnL (* 0.1 spnD)))

	spnPT8  (polar a1Pt pi (+ spnX (/ spnHDD 2.0)))
	spnPT7  (polar spnPT8 pi 1)
	spnPT9  (polar a1Pt pi (- spnX (/ spnHDD 2.0)))
	spnPT10 (polar spnPT9 0 1)
	spnPT11 (polar (polar a1Pt pi (+ spnX (/ spnHD1 2.0))) (* pi 0.5) spnHH)
	spnPT12 (polar (polar a1Pt pi (- spnX (/ spnHD1 2.0))) (* pi 0.5) spnHH)
  )
  (setvar "clayer" "continuous")
  (command "line" (polar V4BasePt 0 tpX) (polar bpPt 0 tpX) (polar bpPt pi tpX) (polar V4BasePt pi tpX) "c")
  (command "line" (polar bpPt 0 sbX2) (polar sbPt 0 sbX2) (polar sbPt 0 sbX1) (polar bpPt 0 sbX1) "c"

	   "line" (polar bpPt pi sbX2) (polar sbPt pi sbX2) (polar sbPt pi (+ spnX (/ spnD 2.0))) "" 
           "line" (polar sbPt pi (- spnX (/ spnD 2.0))) (polar sbPt pi sbX1) (polar bpPt pi sbX1) ""

           "line" (polar ep1Pt 0 epX) (polar ep2Pt 0 epX) (polar ep2Pt pi epX) (polar ep1Pt pi epX) "c"
           "line" (polar ep2Pt 0 epX) (polar erpPt 0 epX) (polar erpPt pi epX) (polar ep2Pt pi epX) ""

	   "line" (polar b1Pt pi (- spnX (/ spnD 2.0))) (polar b1Pt 0  (- gpnX (/ gpnD 2.0))) "" 
	   "line" (polar b1Pt 0  (+ gpnX (/ gpnD 2.0))) (polar b1Pt 0  cpX) (polar b2Pt 0  cpX) (polar b2Pt 0  (+ gpnX (/ gpnD 2.0))) ""
	   "line" (polar b2Pt 0  (- gpnX (/ gpnD 2.0))) (polar b2Pt pi (- spnX (/ spnD 2.0))) ""
	   "line" (polar b2Pt pi (+ spnX (/ spnD 2.0))) (polar b2Pt pi cpX) (polar b1Pt pi cpX) (polar b1Pt pi (+ spnX (/ spnD 2.0))) ""

	   "line" (polar a1Pt pi (- spnX (/ spnD 2.0))) (polar a1Pt 0  (- gpnX (/ gpnD 2.0))) "" 
	   "line" (polar a1Pt 0  (+ gpnX (/ gpnD 2.0))) (polar a1Pt 0  cpX) (polar a2Pt 0  cpX) (polar a2Pt pi (- spnX (/ spnD 2.0))) ""
	   "line" (polar a2Pt pi (+ spnX (/ spnD 2.0))) (polar a2Pt pi cpX) (polar a1Pt pi cpX) (polar a1Pt pi (+ spnX (/ spnD 2.0))) ""

           "line" (polar tp1Pt pi (- spnX (/ spnD 2.0))) (polar tp1Pt 0 tpX) (polar tp2Pt 0 tpX) (polar tp2Pt pi tpX) (polar tp1Pt pi tpX) 
		  (polar tp1Pt pi (+ spnX (/ spnD 2.0))) ""
  )

  (command "line"  spnPT7  (polar spnPT7  (* pi 0.5) spnHH) spnPT11 (polar a2Pt pi (+ spnX (/ spnHD1 2.0))) ""
	   "line"  spnPT10 (polar spnPT10 (* pi 0.5) spnHH) spnPT12 (polar a2Pt pi (- spnX (/ spnHD1 2.0))) ""
	   "line"  spnPT8  (polar spnPT8  (* pi 0.5) spnHH) ""
	   "line"  spnPT9  (polar spnPT9  (* pi 0.5) spnHH) ""
  )

  (command "line"  spnPT1 (polar spnPT1 (* pi 1.5) spnDH) (polar spnPT2 (* pi 1.5) spnDH) spnPT2 ""
	   "line"  spnPT3 spnPT5 ""
	   "line"  spnPT4 spnPT6 ""
	   "pline" spnPT5 "a" "ce" (polar spnPT5 0 (* spnD 0.1)) (polar (polar spnPT5 0 (* spnD 0.1)) (* pi 1.5) (* spnD 0.1)) "l" 
		   (polar (polar spnPT6 pi (* spnD 0.1)) (* pi 1.5) (* spnD 0.1)) "a" "ce" (polar spnPT6 pi (* spnD 0.1)) spnPT6 ""
	   "line"  (polar spnPPt1 0 (/ spnCD 2.0)) (polar spnPPt2 0 (/ spnCD 2.0)) (polar spnPPt2 pi (/ spnCD 2.0)) (polar spnPPt1 pi (/ spnCD 2.0)) "c"
	   "line"  (polar spnPPt2 0 (/ spnCS 2.0)) (polar (polar spnPPt2 0 (/ spnCS 2.0)) (* pi 1.5) spnSH)
		   (polar (polar spnPPt2 pi (/ spnCS 2.0)) (* pi 1.5) spnSH) (polar spnPPt2 pi (/ spnCS 2.0)) ""
  )

  (command "line"  gpnPT7  (polar gpnPT7  (* pi 1.5) gpnHH) gpnPT11 (polar a1Pt 0 (- gpnX (/ gpnHD1 2.0))) ""
	   "line"  gpnPT10 (polar gpnPT10 (* pi 1.5) gpnHH) gpnPT12 (polar a1Pt 0 (+ gpnX (/ gpnHD1 2.0))) ""
	   "line"  gpnPT8  (polar gpnPT8  (* pi 1.5) gpnHH) ""
	   "line"  gpnPT9  (polar gpnPT9  (* pi 1.5) gpnHH) ""
  )

  (command "line"  gpnPT1 (polar gpnPT1 (* pi 0.5) gpnDH) (polar gpnPT2 (* pi 0.5) gpnDH) gpnPT2 ""
	   "line"  gpnPT3 (polar a2Pt 0 (- gpnX (/ gpnD 2.0))) ""
	   "line"  gpnPT4 (polar a2Pt 0 (+ gpnX (/ gpnD 2.0))) ""
	   "pline" gpnPT6 "a" "ce" (polar gpnPT6 pi (* gpnD 0.1)) (polar (polar gpnPT6 pi (* gpnD 0.1)) (* pi 0.5) (* gpnD 0.1)) "l" 
		   (polar (polar gpnPT5 0 (* gpnD 0.1)) (* pi 0.5) (* gpnD 0.1)) "a" "ce" (polar gpnPT5 0 (* gpnD 0.1)) gpnPT5 ""
  )

  (command "line"  (polar b2Pt pi (- spnX (/ (+ spnCD 1) 2.0))) (polar bpPt pi (- spnX (/ (+ spnCD 1) 2.0))) ""
	   "line"  (polar b2Pt pi (+ spnX (/ (+ spnCD 1) 2.0))) (polar bpPt pi (+ spnX (/ (+ spnCD 1) 2.0))) ""
  )

  (if spPt
    (command "line" (polar sbPt pi (+ spnX (/ spnD 2.0))) (polar sbPt pi cpX) (polar b1Pt pi cpX) (polar b1Pt pi (+ spnX (/ spnD 2.0))) ""
             "line" (polar sbPt pi (- spnX (/ spnD 2.0))) (polar sbPt 0  cpX) (polar b1Pt 0  cpX) (polar b1Pt pi (- spnX (/ spnD 2.0))) ""
    )
  )
  (if rpPt
    (command "line" (polar a1Pt pi cpX) (polar tp1Pt pi cpX) ""
             "line" (polar a1Pt 0  cpX) (polar tp1Pt 0  cpX) ""
	     "line" (polar tp1Pt pi (+ spnX (/ spnHD1 2.0))) (polar a2Pt pi (+ spnX (/ spnHD1 2.0))) ""
	     "line" (polar tp1Pt pi (- spnX (/ spnHD1 2.0))) (polar a2Pt pi (- spnX (/ spnHD1 2.0))) ""
    )
  )
  (if stPt
    (command "line" (polar stPt pi (+ spnX (/ (+ spnCD 1) 2))) (polar a1Pt pi (+ spnX (/ (+ spnCD 1) 2))) ""
	     "line" (polar stPt pi (- spnX (/ (+ spnCD 1) 2))) (polar a1Pt pi (- spnX (/ (+ spnCD 1) 2))) ""
             "line" (polar stPt 0  (+ gpnX (/ gpnHD1      2))) (polar a1Pt 0  (+ gpnX (/ gpnHD1      2))) ""
             "line" (polar stPt 0  (- gpnX (/ gpnHD1      2))) (polar a1Pt 0  (- gpnX (/ gpnHD1      2))) ""
             "line" (polar stPt pi cpX) (polar a1Pt pi cpX) ""
             "line" (polar stPt 0  cpX) (polar a1Pt 0  cpX) ""
    )
  )
;---------------------------------------------------------------------
;Defun Extent Data
;---------------------------------------------------------------------
  (setq ExData1 (list (list -3 (list "V4X" (cons 1000 " ")))))
  (setq ExData2 (list (list -3 (list "V4Y" (cons 1000 " ")))))

  (command "line" (polar V4BasePt pi tpX) (polar V4BasePt 0 tpX) "")
  (mxdata (entlast) ExData1)

  (setvar "clayer" "center")
  (command "line" (polar V4BasePt (* pi 1.5) 10) (polar tp2Pt (* pi 0.5) 10) "")
  (mxdata (entlast) ExData2)
;---------------------------------------------------------------------
  (command "line" (polar gpnPt (* pi 1.5) 5) (polar gpnPt (* pi 0.5) (+ bPThk stZ aPThk 5)) ""
	   "line" (polar spnPt (* pi 0.5) 5) (polar (polar bpPt pi spnX) (* pi 1.5) 3) ""
  ) 
  (setvar "clayer" "screw")
  (MoldCapCst (nth (xh_get scr2D scrMLst) scrMMlst) (+ bpZ (* 1.0 (nth (xh_get scr2D scrMLst) scrDLst)))
	      (polar V4BasePt pi scr2X) (polar bpPt pi scr2X) "1" nil)

  (MoldCapCst (nth (xh_get scr3D scrMLst) scrMMlst) (+ bpZ sbPThk spZ (* 1.5 (nth (xh_get scr3D scrMLst) scrDLst)))
	      (polar V4BasePt 0 scr3X) (polar b1Pt 0 scr3X) "1" nil)
  (MoldCapCst (nth (xh_get scr1D scrMLst) scrMMlst) (+ epZ (* 1.0 (nth (xh_get scr1D scrMLst) scrDLst)))
	      (polar ep1Pt 0 scr1X) (polar ep2Pt 0 scr1X) "1" (polar erpPt 0 scr1X))
;---------------------------------------------------------------------
;dim
;---------------------------------------------------------------------
  (setvar "clayer" "dim")
  (command "text" "s" "lxy3" "j" "c" (polar V4BasePt (* pi 1.5) 45) "" "SECTION B - B")
)
;@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@












