;****************************************;
;* This is "layman.lsp" program		*;
;* full compiled in 02/23/99		*;
;* Last changed in 02/23/99		*;
;* ZX Mold Ltd XY.Liao			*;
;****************************************;
;*************************** Main function start ****************************;	
(defun layman()
;-----------------------------------------
;shut off command echo and set undo mark
;-----------------------------------------
  (setvar "cmdecho" 0)
  (command "undo" "m")
;-----------------------------------------
;load dialog and start dialog
;-----------------------------------------
  (setq lay_dcl_id (load_dialog "layman"))
  (setq lay_next 1)
  (while (= 1 lay_next)
    (if (not (new_dialog "layman" lay_dcl_id))
      (exit)
    ) 
    (action_tile "POSITION" "(done_dialog 1)")
    (action_tile "CA"       "(done_dialog 2)")
    (action_tile "WATER"    "(done_dialog 3)")
    (action_tile "CK_P"     "(done_dialog 4)")
    (action_tile "M_CA"     "(done_dialog 5)")
    (action_tile "CK_WATER" "(done_dialog 6)")
    (action_tile "CK_PART"  "(done_dialog 7)")
    (action_tile "F_CA"     "(done_dialog 8)")
    (action_tile "INI"      "(done_dialog 9)")
    (action_tile "accept"   "(done_dialog 10)")
    (action_tile "cancel"   "(done_dialog 11)")
    (setq what_next (start_dialog))
;---------------------------------------------
;determine what to do next
;---------------------------------------------
    (cond 
      ((= 1 what_next)
        (position)
      )
      ((= 2 what_next)
        (ca)
      )
      ((= 3 what_next)
        (water)
      )
      ((= 4 what_next)
        (ck_p)
      )
      ((= 5 what_next)
        (m_ca)
      )
      ((= 6 what_next)
        (ck_water)
      )
      ((= 7 what_next)
        (ck_part)
      )
      ((= 8 what_next)
        (f_ca)
      )
      ((= 9 what_next)
        (load "ini_lay")
        (IniLayer)
      )
      ((= 10 what_next)
        (setq lay_next 0)
      )
      ((= 11 what_next)
        (command "undo" "b")
        (setq lay_next 0)
      )
    )
  )
;----------------------------------------
;unload dialog
;----------------------------------------
  (unload_dialog lay_dcl_id)
  (prin1)
)
;************************* Main function end ********************************;

;---------------------------------------------------
;set layer status for position
;---------------------------------------------------
(defun position()
  (opall)
  (setvar "clayer" "run")
  (command "_.layer" "_freeze" "*" "")
  (command "_.layer" "_thaw" "ca"
		     "_thaw" "part"
		     "_thaw" "run"
		     "_thaw" "epin"
		     "_thaw" "screw"
		     "_thaw" "center" "_lock" "center"
		     "_thaw" "hidden" "_lock" "hidden"
		     "_thaw" "text" "_lock" "text"
		     "_thaw" "continuous" "_lock" "continuous"
		     "_thaw" "dim" "_lock" "dim"
                     "")
)

;---------------------------------------------------
;set layer status for drawing ca
;---------------------------------------------------
(defun ca()
  (opall)
  (setvar "clayer" "water")
  (command "_.layer" "_freeze" "*" "")
  (command "_.layer" "_thaw" "ca"
		     "_thaw" "dim_ca"
		     "_thaw" "water"
		     "_thaw" "dim_water"
		     "_thaw" "epin"
		     "_thaw" "screw"
		     "_thaw" "temp"
		     "_thaw" "center" "_lock" "center"
		     "_thaw" "hidden" "_lock" "hidden"
		     "_thaw" "text" "_lock" "text"
		     "_thaw" "continuous" "_lock" "continuous"
		     "_thaw" "dim" "_lock" "dim"
                     "")
)

;---------------------------------------------------
;set layer status for drawing water
;---------------------------------------------------
(defun water()
  (opall)
  (setvar "clayer" "water")
  (command "_.layer" "_lock" "*" "")
  (command "_.layer" "_unlock" "water"
		     "_unlock" "dim_water"
		     "_unlock" "epin"
		     "_unlock" "screw"
		     "_unlock" "mxb" "_off" "mxb"
		     "_unlock" "hatch" "_off" "hatch"
                     "")
)

;---------------------------------------------------
;set layer status for checking position
;---------------------------------------------------
(defun ck_p()
  (opall)
  (setvar "clayer" "part")
  (command "_.layer" "_freeze" "*" "")
  (command "_.layer" "_thaw" "ca"
		     "_thaw" "part"
		     "_thaw" "run"
		     "_thaw" "epin"
                     "")
)

;---------------------------------------------------
;set layer status for modifying ca
;---------------------------------------------------
(defun m_ca()
  (opall)
  (setvar "clayer" "continuous")
  (command "_.layer" "_freeze" "*" "")
  (command "_.layer" "_thaw" "center"
		     "_thaw" "hidden"
		     "_thaw" "text"
		     "_thaw" "continuous"
		     "_thaw" "dim"
                     "")
)

;---------------------------------------------------
;set layer status for checking water
;---------------------------------------------------
(defun ck_water()
  (opall)
  (setvar "clayer" "water")
  (command "_.layer" "_freeze" "*" "")
  (command "_.layer" "_thaw" "water"
		     "_thaw" "epin"
		     "_thaw" "screw"
		     "_thaw" "run" "_lock" "run"
		     "_thaw" "part" "_lock" "part"
		     "_thaw" "temp" "_lock" "temp"
                     "")
)

;---------------------------------------------------
;set layer status for checking part
;---------------------------------------------------
(defun ck_part()
  (opall)
  (setvar "clayer" "dim_ca")
  (command "_.layer" "_freeze" "*" "")
  (command "_.layer" "_thaw" "dim_ca"
		     "_thaw" "ca"
		     "_thaw" "part"
		     "_thaw" "epin" "_lock" "epin"
                     "")
)

;---------------------------------------------------
;set layer status for finish ca
;---------------------------------------------------
(defun f_ca()
  (opall)
  (setvar "clayer" "continuous")
  (command "_.layer" "_freeze" "*" "")
  (command "_.layer" "_thaw" "continuous"
		     "_thaw" "center"
		     "_thaw" "hidden"
		     "_thaw" "dim"
		     "_thaw" "text"
                     "")
)

;-----------------------------------------------------
;on unlock and thaw all layer
;-----------------------------------------------------
(defun opall()
  (if (not (tblsearch "appid" "ini_layer"))
    (ini)
    (command "_.layer" "thaw" "*" "on" "*" "unlock" "*" "")
  )
)

(defun ini()
  (load "ini_lay")
  (IniLayer)
)