(defun IniLayer()
  (if (not (tblsearch "appid" "ini_layer"))
    (progn
      (regapp "ini_layer")
      (command "_.layer" "thaw" "*" "on" "*" "unlock" "*" "")
      (setvar "cecolor" "bylayer")
      (setvar "celtype" "bylayer")
      (if (tblsearch "layer" "center")
        (command "_.layer" "_color" "red" "center" "_ltype" "center" "center" "")
        (command "_.layer" "_new" "center" "_color" "red" "center" "_ltype" "center" "center" "")
      )
      (if (tblsearch "layer" "hidden")
        (command "_.layer" "_color" "yellow" "hidden" "_ltype" "hidden" "hidden" "")
        (command "_.layer" "_new" "hidden" "_color" "yellow" "hidden" "_ltype" "hidden" "hidden" "")
      )
      (if (tblsearch "layer" "continuous")
        (command "_.layer" "_color" "white" "continuous" "_ltype" "continuous" "continuous" "")
        (command "_.layer" "_new" "continuous" "_color" "white" "continuous" "_ltype" "continuous" "continuous" "")
      )
      (if (tblsearch "layer" "text")
        (command "_.layer" "_color" "cyan" "text" "_ltype" "continuous" "text" "")
        (command "_.layer" "_new" "text" "_color" "cyan" "text" "_ltype" "continuous" "text" "")
      )
      (if (tblsearch "layer" "dim")
        (command "_.layer" "_color" "green" "dim" "_ltype" "continuous" "dim" "")
        (command "_.layer" "_new" "dim" "_color" "green" "dim" "_ltype" "continuous" "dim" "")
      )
      (if (tblsearch "layer" "epin")
        (command "_.layer" "_color" "green" "epin" "_ltype" "continuous" "epin" "")
        (command "_.layer" "_new" "epin" "_color" "green" "epin" "_ltype" "continuous" "epin" "")
      )
      (if (tblsearch "layer" "screw")
        (command "_.layer" "_color" "white" "screw" "_ltype" "continuous" "screw" "")
        (command "_.layer" "_new" "screw" "_color" "white" "screw" "_ltype" "continuous" "screw" "")
      )
      (if (tblsearch "layer" "spring")
        (command "_.layer" "_color" "cyan" "spring" "_ltype" "phantom2" "spring" "")
        (command "_.layer" "_new" "spring" "_color" "cyan" "spring" "_ltype" "phantom2" "spring" "")
      )
      (if (tblsearch "layer" "mxb")
        (command "_.layer" "_color" "green" "mxb" "_ltype" "continuous" "mxb" "")
        (command "_.layer" "_new" "mxb" "_color" "green" "mxb" "_ltype" "continuous" "mxb" "")
      )
      (if (tblsearch "layer" "part")
        (command "_.layer" "_color" "cyan" "part" "_ltype" "continuous" "part" "")
        (command "_.layer" "_new" "part" "_color" "cyan" "part" "_ltype" "continuous" "part" "")
      )
      (if (tblsearch "layer" "water")
        (command "_.layer" "_color" "9" "water" "_ltype" "hidden" "water" "")
        (command "_.layer" "_new" "water" "_color" "9" "water" "_ltype" "hidden" "water" "")
      )
      (if (tblsearch "layer" "dim_water")
        (command "_.layer" "_color" "9" "dim_water" "_ltype" "continuous" "dim_water" "")
        (command "_.layer" "_new" "dim_water" "_color" "9" "dim_water" "_ltype" "continuous" "dim_water" "")
      )
      (if (tblsearch "layer" "run")
        (command "_.layer" "_color" "magenta" "run" "_ltype" "continuous" "run" "")
        (command "_.layer" "_new" "run" "_color" "magenta" "run" "_ltype" "continuous" "run" "")
      )
      (if (tblsearch "layer" "ca")
        (command "_.layer" "_color" "green" "ca" "_ltype" "continuous" "ca" "")
        (command "_.layer" "_new" "ca" "_color" "green" "ca" "_ltype" "continuous" "ca" "")
      )
      (if (tblsearch "layer" "dim_ca")
        (command "_.layer" "_color" "blue" "dim_ca" "_ltype" "continuous" "dim_ca" "")
        (command "_.layer" "_new" "dim_ca" "_color" "blue" "dim_ca" "_ltype" "continuous" "dim_ca" "")
      )
      (if (tblsearch "layer" "temp")
        (command "_.layer" "_color" "white" "temp" "_ltype" "continuous" "temp" "")
        (command "_.layer" "_new" "temp" "_color" "white" "temp" "_ltype" "continuous" "temp" "")
      )
      (if (tblsearch "layer" "hatch")
        (command "_.layer" "_color" "magenta" "hatch" "_ltype" "continuous" "hatch" "")
        (command "_.layer" "_new" "hatch" "_color" "magenta" "hatch" "_ltype" "continuous" "hatch" "")
      )
    )
  )
)

(defun IniStyle()
  (if (not (tblsearch "appid" "inistyle"))
    (progn
      (regapp "inistyle")
      (command "style" "lxy3" "simplex" 10 0.7 "" "" "" "")
      (command "style" "lxy4" "simplex" 6 0.7 "" "" "" "")
      (setvar "ltscale" 20)
    )
  )
)

(defun IniDimStyle()
  (if (not (tblsearch "dimstyle" "mould"))
    (progn
      (setvar "dimscale" 15)
      (setvar "dimasz" 0.18)
      (setvar "dimexe" 0.18)
      (setvar "dimexo" 0.0625)
      (setvar "dimfit" 3)
      (setvar "dimgap" 0.09)
      (setvar "dimjust" 0)
      (setvar "dimlfac" 1.0)
      (setvar "dimtih" 0)
      (setvar "dimtxt" 0.18)
      (setvar "dimtxsty" "standard")
      (command "dimstyle" "s" "mould")
    )
    (if (/= "MOULD" (getvar "dimstyle"))
      (command "dimstyle" "r" "mould")
    )
  )
)



