
(defun ep_edit()
;---------------------------------------------------
;shut off command echo and set undo mark
;---------------------------------------------------
  (setvar "cmdecho" 0)
  (command "undo" "m")
;---------------------------------------------------
;Save current system variable
;---------------------------------------------------
  (setq os_old (getvar "osmode")
	la_old (getvar "clayer")
	lt_old (getvar "celtype")
	co_old (getvar "cecolor")
	pw_old (getvar "plinewid")
	or_old (getvar "orthomode")
	st_old (getvar "textstyle")
	bp_old (getvar "blipmode")
  )
;---------------------------------------------------
;Initializing
;---------------------------------------------------
  (ini_useri2)
  (setvar "plinewid" 0)
  (setvar "blipmode" 0)
  (setvar "celtype" "bylayer")
  (setvar "cecolor" "bylayer")
  (if (not (tblsearch "layer" "epin"))
    (command "layer" "_new" "epin" "_color" "green" "epin" "l" "continuous" "epin" "")
    (command "_.layer" "thaw" "epin" "on" "epin" "unlock" "epin" "")
  )
  (setvar "clayer" "epin")
  (setq epin_conlb 1)
  (regapp "epin")
  (load "epin_lib")
;--------------------------------------------------
;Get ejector pin
;--------------------------------------------------
  (setq INU T)
  (while INU
    (setq epin_ent (entsel))
    (if (not epin_ent)
      (setq epin_ent (entsel))
      (progn
        (setq epin_ent (car epin_ent))
        (if (assoc -3 (entget epin_ent '("epin")))
          (if (/= "epin" (car (cadr (assoc -3 (entget epin_ent '("epin"))))))
            (princ "\nIt is not a ejector pin!\n")
	    (setq INU nil)
	  )
	)
      )
    )
  )
  (setq epin_data (cdr (cadr (cadr (assoc -3 (entget epin_ent '("epin")))))))
  (setq epin_data (strtolst epin_data))
  (progn
    (setq rep_old  (nth 0 epin_data)
	  mb       (nth 6 epin_data)
	  type_old (nth 2 epin_data)
	  len_old  (nth 3 epin_data)
	  zc       (nth 1 epin_data)
          if_h_v   (nth 4 epin_data)
          typ_old  (nth 5 epin_data)
          spec_old (strcat type_old "X" len_old)
    )
    (if (= "C" zc)
      (setq ang (atof (nth 7 epin_data)))
    )
    (cond
      ((= "N" typ_old)
    	(setq chin "ֱ")
	(setq desc "EJECTOR PIN")
      )
      ((= "W" typ_old)
	(setq chin "ж")
	(setq desc "STEP EJECTOR PIN")
      )
    )
  )
;-----------------------------------------------
;start dialog
;-----------------------------------------------
  (setq edit_next 1)
  (setq epin_dcl_id (load_dialog "epin"))
  (while (= 1 edit_next) 
    (if (not (new_dialog "pinviewdlg" epin_dcl_id))
      (exit)
    )
    (set_tile "rep" rep_old)
    (set_tile "chin" chin)
    (set_tile "desc" desc)
    (set_tile "cot" spec_old)
    (mode_tile "desc" 1)
    (mode_tile "chin" 1)
    (if err_msg
      (set_tile "MSG" err_msg)
    )
    (action_tile "accept" "(rep_get) (done_dialog 2)")
    (action_tile "E_DEL"  "(rep_get) (done_dialog 4)")
    (action_tile "rep"    "(setq rep_r  $reason) (valid_verify)")
    (action_tile "cot"    "(setq spec_r $reason) (valid_verify)")
    (action_tile "cancel" "(done_dialog 3)")
    (setq what_next (start_dialog))
    (cond
      ((= 2 what_next)
        (setq if_del_lb 0)
        (setq edit_next 0)
        (if (and (or rep_new spec_new)
	         (or (/= rep_old rep_new) (/= spec_old spec_new))
	         (not err_msg)
            )
          (if (= 1 if_all_lb)
            (progn
	      (princ "\nAnalyzing entity, Please wait a moment...")
              (setq all_set (ssget "X" '((0 . "INSERT") (-3 ("epin")))))
  	      (setq ent_count (sslength all_set))
  	      (setq i 0)
  	      (while (< i ent_count)
	        (setq ent_name (ssname all_set i))
	        (epin_modify ent_name)
	        (setq i (+ i 1))
	      )
            )
            (epin_modify epin_ent)
          )
          (setq edit_next 1)
        )
      )
      ((= 3 what_next)
        (setq edit_next 0)
      )
      ((= 4 what_next)
        (setq if_del_lb 1)
        (setq edit_next 0)
        (if (= 1 if_all_lb)
          (progn
	    (princ "\nAnalyzing entity, Please wait a moment...")
            (setq all_set (ssget "X" '((0 . "INSERT") (-3 ("epin")))))
  	    (setq ent_count (sslength all_set))
  	    (setq i 0)
  	    (while (< i ent_count)
	      (setq ent_name (ssname all_set i))
              (epin_del ent_name)
	      (setq i (+ i 1))
	    )
          )
          (epin_del epin_ent)
        )
      )
    )
  )
  (ac_lxy_set)
  (princ "done")
  (prin1)
)
;------------------------------------------------------------------------------------;	

;------------------------------------------------------------------------------------;	
(defun rep_get()
  (if (= "1" (get_tile "if_all"))
    (setq if_all_lb 1)
    (setq if_all_lb 0)
  )
) 


;------------------------------------------------------------------------------------;	
(defun epin_modify(ent_name / con_lb)
  (setq epin_data (cdr (cadr (cadr (assoc -3 (entget ent_name '("epin")))))))
  (setq epin_data (strtolst epin_data))
  (progn
     (setq rep      (nth 0 epin_data)
	   type_cur (nth 2 epin_data)
	   len      (nth 3 epin_data)
	   zc       (nth 1 epin_data)
           if_h_v   (nth 4 epin_data)
           typ      (nth 5 epin_data)
           spec     (strcat type_cur "X" len)
    )
    (if (= "C" zc)
      (setq ang    (atof (nth 7 epin_data))
	    l12    (atof (nth 8 epin_data))
	    l23    (atof (nth 9 epin_data))
	    li1    (atof (nth 10 epin_data))
	    li2    (atof (nth 11 epin_data))
      )
    )
    (setq  pt1   (wtou (cdr (assoc 10 (entget ent_name)))))
    (if (= -1.0 (cdr (assoc 41 (entget ent_name))))
      (progn
        (setq ang_mirr (cdr (assoc 50 (entget ent_name))))
        (setq ang_mirr (/ ang_mirr 2))
        (setq ang_mirr (+ ang_mirr (/ pi 2)))
        (if (<= pi ang_mirr)
          (setq ang_mirr (- ang_mirr pi))
        )
        (if (= "C" zc)
          (progn
	    (setq ang_mirr (- (- ang (* (fix (/ ang pi)) pi)) ang_mirr))
	    (setq ang (- ang (* 2 ang_mirr)))
          )
        )
      )
      (if (= "C" zc)
        (setq ang (+ ang (cdr (assoc 50 (entget ent_name)))))
      )
    )
    (if (= "C" zc)
      (progn
        (if (> ang (* pi 2))
          (setq ang (- ang (* pi 2)))
        )
        (if (< ang 0)
          (setq ang (+ ang (* 2 pi)))
        )
      )
    )
  )
  (if (= rep rep_old)
    (progn
      (if (/= spec spec_old)
        (progn
          (redraw ent_name 3)
          (command "zoom" "c" pt 50)
          (setq con_lb (yn  (strcat "ֲͬ" spec "! ?")))
          (if (/= typ_old typ)
            (progn
              (if (= 1 con_lb)
                (alert "ֲͬͶ, ޷!")
              )
              (setq con_lb 0)
            )
            (if (= 0 con_lb)
              (redraw ent_name 4)
            )
          )
	  (command "zoom" "p")
        )
        (progn
          (setq con_lb 1)
          (if (/= typ_old typ)
            (progn
              (redraw ent_name 3)
              (command "zoom" "c" pt 50)
              (alert (strcat "" rep "вͬͶ!"))
              (setq con_lb 0)
            )
          )
        )
      )
      (if (= 1 con_lb)
        (progn
          (entdel ent_name)
          (setq rep rep_new)
          (setq epin_app "OLD")
          (cond
	    ((= "C" zc)
	      (cond
		((= "N" typ)
                  (load "epin_ns_cst")
		  (ns_cst)
		)
		((= "W" typ)
                  (load "epin_ws_cst")
		  (ws_cst)
		)
	      )
	    )
	    ((= "Z" zc)
              (setq cenpt pt1)
              (load "epin_zst")
              (epin_zst)
            )
          )
        ) 
      )
    )
  )
)

(defun epin_del(ent_name / con_lb)
  (setq epin_data (cdr (cadr (cadr (assoc -3 (entget ent_name '("epin")))))))
  (setq epin_data (strtolst epin_data))
  (progn
     (setq rep      (nth 0 epin_data)
	   type_cur (nth 2 epin_data)
	   len      (nth 3 epin_data)
	   zc       (nth 1 epin_data)
           if_h_v   (nth 4 epin_data)
           typ      (nth 5 epin_data)
           spec     (strcat type_cur "X" len)
    )
    (if (= "C" zc)
      (setq ang    (atof (nth 7 epin_data))
	    l12    (atof (nth 8 epin_data))
	    l23    (atof (nth 9 epin_data))
	    li1    (atof (nth 10 epin_data))
	    li2    (atof (nth 11 epin_data))
            ang    (+ ang (cdr (assoc 50 (entget ent_name))))
      )
    )
  )
  (if (= rep rep_old)
    (progn
      (if (/= spec spec_old)
        (progn
          (redraw ent_name 3)
          (command "zoom" "c" pt1 50)
          (if (/= typ_old typ)
            (setq con_lb (yn  (strcat "ֲͬͶ! ɾ?")))
            (setq con_lb (yn  (strcat "ֲͬ" spec "! ɾ?")))
          )
          (command "zoom" "p")
        )
        (progn
          (setq con_lb 1)
          (if (/= typ_old typ)
            (progn
              (redraw ent_name 3)
              (command "zoom" "c" pt1 50)
              (setq con_lb (yn  (strcat "ֲͬͶ! ɾ?")))
              (command "zoom" "p")
            )
          )
        )
      )
      (if (= 1 con_lb)
        (entdel ent_name)
        (redraw ent_name 4)
      )
    )
  )
)



(defun valid_verify()
  (print "xyq")
  (if (or (= 2 rep_r) (= 2 spec_r))
    (progn
;--------------------------------------------------
;Verify item number
;--------------------------------------------------
      (setq rep_new (lxy_trim (get_tile "rep")))
      (if (> 2 (strlen rep_new))
        (setq err_msg1 "Invalid item number!")
        (if (/= "E" (strcase (substr rep_new 1 1)))
          (setq err_msg1 "Invalid item number!")
          (if (>= 0.0 (atof (substr rep_new 2)))
            (setq err_msg1 "Invalid item number!")
            (progn
              (setq rep_new (strcat "E" (itoa (fix (atof (substr rep_new 2))))))
              (set_tile "rep" rep_new)
	      (setq err_msg1 nil)
            )
          )
        )
      )
;---------------------------------------------------
;Verify ejector pin specification
;---------------------------------------------------
      (setq spec_new (lxy_trim (get_tile "cot")))
      (if (not (lxy_word spec_new "X"))
	(setq err_msg2 "Invalid ejector pin specification!")
        (progn
          (setq epin_type (substr spec_new 1 (- (lxy_word spec_new "X") 1))
	   	epin_len  (substr spec_new (+ (lxy_word spec_new "X") 1) (- (strlen spec_new) (lxy_word spec_new "X")))
    	  )
          (setq err_msg2 nil)
          (cond
            ((= "N" typ_old)
              (cond
                ((= "B" mb)
	          (setq n (xh_get epin_type (lib_ep 4)))
	          (if (not n)
	            (setq err_msg2 "Invalid ejector pin specification!")
                    (progn
	              (setq d  (nth n (lib_ep 5))
	                    hd (nth n (lib_ep 6))
	                    b  (nth n (lib_ep 7))
                      )
                    )
                  )
                )
                ((= "M" mb)
	          (setq n (xh_get epin_type (lib_ep 1)))
	          (if (not n)
	            (setq err_msg2 "Invalid ejector pin specification!")
                    (progn
	              (setq d  (atof (nth n (lib_ep 1)))
	                    hd (nth n (lib_ep 2))
	                    b  (nth n (lib_ep 3))
                      )
                    )
                  )
                )
              )
            )
            ((= "W" typ_old)
              (cond
                ((= "B" mb)
	          (setq n (xh_get epin_type (lib_ep 9)))
	          (if (not n)
	            (setq err_msg2 "Invalid ejector pin specification!")
                    (progn
	              (setq d  (nth n (lib_ep 5))
	                    hd 6.35
	                    dd 3.175
	                    b  3.175
                      )
                    )
                  )
                )
                ((= "M" mb)
	          (setq n (xh_get epin_type (lib_ep 8)))
	          (if (not n)
	            (setq err_msg2 "Invalid ejector pin specification!")
                    (progn
	              (setq d  (atof (nth n (lib_ep 8)))
	                    hd 6.0
	                    dd 3.0
	                    b  4.0
                      )
                    )
                  )
                )
              )
            )
          )
        )
      )
    )
  )
  (if err_msg1
    (progn 
      (mode_tile "rep" 2)
      (set_tile "MSG" err_msg1)
    )
    (if (not err_msg2)
      (set_tile "MSG" "")
      (progn 
        (mode_tile "spec" 2)
        (set_tile "MSG" err_msg2)
      )
    )
  )
)
