;*****************************************************;
;* This is "epin_ns_cst.lsp" program 		     *;
;* Complete compiled in 12/20/98                     *;
;* Last change in 1/26/99    			     *;
;* ZX Mold Ltd  XY.Liao				     *;
;*****************************************************;
;****************************************Main function start********************************************;
(defun ns_cst(/ npt1  		npt2  		npt3  		npt4  		npt5  
		npt6  		npt7  		npt8		npt9  		npt10 
		npt11 		npt12 		npt13 		npt14 		npt15 
		npt16		npt17 		npt18 		npt19 		npt20 
		npt21 		npt22 		npt23 		npt24 		npt25 	
		npt26 		angv  		angvv 		angh  		int_pt1		
		textpt1 	int_pt2     	npct1 		npct2 		tr_ent1		
		tr_ent2		instpt  	sel_ent   	textpt2		textang		
		textangv)

;------------------------------------------------
;calculate parameter
;------------------------------------------------
  (if (= "NEW" epin_app)
    (progn
      (setq ang  (angle pt1 pt2))
      (if (> (abs (- ang (angle pt1 pt3))) 0.001)
        (setq err_msg2 "㲻һ")
        (setq l12 (distance pt1 pt2)
	      l23 (distance pt2 pt3)
        )
      )
    )
    (progn
      (setq pt2 (polar pt1 ang l12))
      (setq pt3 (polar pt2 ang l23))
    )
  )
  (setq angv  (+ ang (/ pi 2)))
  (setq angvv (- ang (/ pi 2)))
  (setq angh  (+ ang pi))
;------------------------------------------------
;calculate parameter
;------------------------------------------------
  (setq npt2  (polar pt1 angv (/ hd 2.0))
	npt3  (polar pt1 angvv (/ hd 2.0))
	npt6  (polar npt2 ang b)
	npt8  (polar npt6 angvv (/ (- hd d) 2))
	npt9  (polar npt8 angvv d)
	npt11 (polar npt3 ang b)
	npt14 (polar pt2 angv (/ d 2))
	npt15 (polar pt2 angvv (/ d 2))
	npt18 (polar npt14 ang l23)
	npt19 (polar npt15 ang l23)
  )
  (setq npt1  (polar npt2 angv 0.5)
	npt4  (polar npt3 angvv 0.5)
	npt13 (polar npt14 angv 0.5)
	npt16 (polar npt15 angvv 0.5)
	npt5  (polar npt1 ang b)
	npt12 (polar npt4 ang b)
	npt7  (polar npt13 angh (- l12 b))
	npt10 (polar npt16 angh (- l12 b))
  )
  (setq npt17 (polar npt13 ang l23)
	npt20 (polar npt16 ang l23)
  )
;-----------------------------------------------
;Get intersect points ordinate
;-----------------------------------------------
  (if (= "NEW" epin_app)
    (setq int_pt1 (pline_int npt8 npt14 (car ob_ent) (caddr ob_ent))
  	  int_pt2 (pline_int npt9 npt15 (car ob_ent) (caddr ob_ent))
    ) 
    (setq int_pt1 (polar npt8 ang (- li1 b))
	  int_pt2 (polar npt9 ang (- li2 b))
    )
  )
  (if (not (and int_pt1 int_pt2))
    (setq err_msg2 "Ejector pin don't intersect entity you selected!")
    (progn
      (if (listp (car int_pt1))
        (if (> (distance (cadr ob_ent) (car int_pt1))
	       (distance (cadr ob_ent) (cadr int_pt1))
            )
          (setq int_pt1 (cadr int_pt1))
          (setq int_pt1 (car int_pt1))
        )
      )
      (if (listp (car int_pt2))
        (if (> (distance (cadr ob_ent) (car int_pt2))
	       (distance (cadr ob_ent) (cadr int_pt2))
            )
          (setq int_pt2 (cadr int_pt2))
          (setq int_pt2 (car int_pt2))
        )
      )
      (setq li1 (+ (distance npt8 int_pt1) b)
	    li2 (+ (distance npt9 int_pt2) b)
      )
      (setq l (if (> li1 li2) li1 li2))
      (if (> l 700)
        (setq err_msg2 "Invalid ejector pin length!")
      )
    )
  )
  (if (not err_msg2)
    (progn 
;-------------------------------------------------
;Round l as a standard ejector pin length
;-------------------------------------------------
      (cond
	((= "M" mb)
	  (cond 
	    ((>= 100 l)
	      (setq len "100")
	    )
	    ((and (>= 125 l) (< 100 l))
	      (setq len "125")
	    )
	    ((and (>= 160 l) (< 100 l))
	      (setq len "160")
	    )
	    ((and (>= 200 l) (< 150 l))
	      (setq len "200")
	    )
	    ((and (>= 250 l) (< 200 l))
	      (setq len "250")
	    )
	    ((and (>= 300 l) (< 250 l))
	      (setq len "300")
	    )
	    ((and (>= 350 l) (< 300 l))
	      (setq len "350")
	    )  
	    ((and (>= 400 l) (< 350 l))
	      (setq len "400")
	    )  
	    ((and (>= 450 l) (< 400 l))
	      (setq len "450")
	    )  
	    ((and (>= 500 l) (< 450 l))
	      (setq len "500")
	    )  
	    ((and (>= 550 l) (< 500 l))
	      (setq len "550")
	    )  
	    ((and (>= 600 l) (< 550 l))
	      (setq len "600")
	    )  
	    ((and (>= 650 l) (< 600 l))
	      (setq len "650")
	    )  
	    ((and (>= 700 l) (< 650 l))
	      (setq len "700")
	    )
	  )
	)
	((= "B" mb)
	  (cond 
	    ((>= 101.6 l)
	      (setq len "4\"")
	    )
	    ((and (>= 152.4 l) (< 101.6 l))
	      (setq len "6\"")
	    )
	    ((and (>= 203.2 l) (< 152.4 l))
	      (setq len "8\"")
	    )
	    ((and (>= 254 l) (< 203.2 l))
	      (setq len "10\"")
	    )
	    ((and (>= 304.8 l) (< 254 l))
	      (setq len "12\"")
	    )
	    ((and (>= 355.6 l) (< 304.8 l))
	      (setq len "14\"")
	    )
	    ((and (>= 406.4 l) (< 355.6 l))
	      (setq len "16\"")
	    )
	    ((and (>= 457.2 l) (< 406.4 l))
	      (setq len "18\"")
	    )
	    ((and (>= 508 l) (< 457.4 l))
	      (setq len "20\"")
	    )
	    ((and (>= 558.8 l) (< 508 l))
	      (setq len "22\"")
	    )
	    ((and (>= 609.6 l) (< 558.8 l))
	      (setq len "24\"")
	    )
	    ((and (>= 660.4 l) (< 609.6 l))
	      (setq len "26\"")
	    )
	    ((and (>= 711.2 l) (< 660.4 l))
	      (setq len "28\"")
	    )
	  )
	)
      )
;------------------------------------------------
;calculate the remain points' ordinate
;------------------------------------------------
      (if (<= li1 li2)
        (setq npt22 (polar int_pt1 angh  20)
	      npt21 (polar npt22   angv  0.5)
	      npt23 (polar npt22   angvv d)
	      npt24 (polar npt23   angvv 0.5)
        )
        (setq npt23 (polar int_pt2 angh  20)
	      npt24 (polar npt23   angvv 0.5)
	      npt22 (polar npt23   angv  d)
	      npt21 (polar npt22   angv  0.5)
        )
      )
      (setq ncpt1 (polar pt1 angh 1)
	    ncpt2 (polar pt1 ang (+ l 2))
      )
      (setvar "osmode" 0)
;---------------------------------------------------
;Draw pin entitis and c'bore
;---------------------------------------------------
      (progn
        (setq sel_ent (ssadd))
        (command "line" npt14 npt18 "") 
        (setq sel_ent (ssadd (entlast) sel_ent))
        (setq tr_ent1 (entlast))
        (command "line" npt15 npt19 "")
        (setq sel_ent (ssadd (entlast) sel_ent))
        (setq tr_ent2 (entlast))
      )
      (if (= "1" if_h_v)
        (progn
     	  (command "linetype" "s" "hidden" "")
	  (setvar "cecolor" "yellow")
        )
        (command "trim" tr_ent1 tr_ent2 "" pt2 pt3 "")
      )
      (progn
        (command "pline" npt2 npt6 npt11 npt3 npt2 "")
        (setq sel_ent (ssadd (entlast) sel_ent))
        (command "line" npt9 npt15 "")
        (setq sel_ent (ssadd (entlast) sel_ent))
        (command "line" npt19 int_pt2 "")
        (setq sel_ent (ssadd (entlast) sel_ent))
        (command "line" npt8 npt14 "")
        (setq sel_ent (ssadd (entlast) sel_ent))
        (command "line" npt18 int_pt1 "")
        (setq sel_ent (ssadd (entlast) sel_ent))
      )
      (progn
        (command "pline" npt1 npt5 npt12 npt4 "")
        ;(setq sel_ent (ssadd (entlast) sel_ent))
        (command "line" npt7 npt13 "")
        ;(setq sel_ent (ssadd (entlast) sel_ent))
        (command "line" npt10 npt16 "")
        ;(setq sel_ent (ssadd (entlast) sel_ent))
        (command "pline" npt17 npt21 npt22 "")
        ;(setq sel_ent (ssadd (entlast) sel_ent))
        (command "pline" npt20 npt24 npt23 "")
        ;(setq sel_ent (ssadd (entlast) sel_ent))
        (command  "line" npt8 npt14 "")
        ;(setq sel_ent (ssadd (entlast) sel_ent))
        (command "line" npt9 npt15 "")
        ;(setq sel_ent (ssadd (entlast) sel_ent))
      )
;--------------------------------------------------
;get correct epin specification
;--------------------------------------------------
      (setq spec (strcat "%%C" epin_type "X" len))
;--------------------------------------------------
;get center line pints and text locate points
;--------------------------------------------------
      (setq textpt1 (polar pt1 angh (+ 2 (abs (* 1.77 (cos (- (/ pi 4) ang)))))))
      (if (and (> ang (* pi 0.51)) (< ang (* pi 1.51)))
        (progn
	  (setq textang (* (+ ang pi) (/ 180 pi)))
          (setq textangv angvv)
	  (if (> d 2.7)
            (progn
              (setq textpt2 (polar (polar npt8 ang (* 1.25 (- (strlen spec) 2))) angvv (- (/ d 2) 1.25)))
	      (setq ncpt3 (polar pt1 ang b))
	      (setq ncpt4 (polar ncpt3 ang (* 1.25 (- (strlen spec) 2))))
            )
            (progn
              (setq textpt2 (polar (polar npt10 ang (* 1.25 (- (strlen spec) 2))) angvv 0.5))
              (setq ncpt3 nil)
	      (setq ncpt4 nil)
            )
	  )
        )
        (progn
	  (setq textang (* ang (/ 180 pi)))
          (setq textangv angv)
	  (if (> d 2.7)
            (progn
              (setq textpt2 (polar (polar npt8 ang 0.4) angvv (+ (/ d 2) 1.25)))
	      (setq ncpt3 (polar pt1 ang b))
	      (setq ncpt4 (polar ncpt3 ang (* 1.25 (- (strlen spec) 2))))
            )
            (progn
              (setq textpt2 (polar (polar npt8 ang (* 1.25 (- (strlen spec) 2))) angv 0.5))
              (setq ncpt3 nil)
	      (setq ncpt4 nil)
            )
	  )
        )
      )
;-----------------------------------------------------
;Draw center line
;-----------------------------------------------------
      (progn 
        (command "linetype" "s" "center" "")
        (setvar "cecolor" "red")
        (if (and ncpt3 ncpt4)
          (progn
            (command "line" ncpt1 ncpt3 "")
            ;(setq sel_ent (ssadd (entlast) sel_ent))
            (command "line" ncpt4 ncpt2 "")
            ;(setq sel_ent (ssadd (entlast) sel_ent))
          )
          (progn
            (command "line" ncpt1 ncpt2 "")
            ;(setq sel_ent (ssadd (entlast) sel_ent))
          )
        )
        (setvar "celtype" "bylayer")
        (setvar "cecolor" "bylayer")
      )
;-----------------------------------------------------
;Dim specification and item number
;-----------------------------------------------------
      (progn
        (if (not (tblsearch "style" "lxy1"))
	  (command "-style" "lxy1" "txt" "" 0.5 "" "" "" "")
	  (setvar "textstyle" "lxy1")
        )
        (command "text" textpt2 2.5 textang spec)
        ;(setq sel_ent (ssadd (entlast) sel_ent))
        (if (not (tblsearch "style" "lxy2"))
	  (command "-style" "lxy2" "txt" "" 0.6 "" "" "" "")
	  (setvar "textstyle" "lxy2")
        )
        (command "text" "j" "mc" textpt1 2.5 0 rep)
        (setq sel_ent (ssadd (entlast) sel_ent))
        (setvar "textstyle" st_old)
      )
;-----------------------------------------------------
;Make screw block and add extend data in it
;-----------------------------------------------------
      (mblk (strcat "AC_LXY_BLK" (itoa (getvar "useri2"))) pt1 sel_ent)
      (setq xd (strcat 	rep " " 			;item number
			"C" " " 			;view flag
			epin_type " " 			;dim diameter
			len " " 			;dim length
			if_h_v " " 			;hidden flag
			"N" " " 			;type flag
			mb " " 				;meter or inch flag
			(rtos ang 2 5) " "		;angle
			(rtos l12 2 5) " "		;thickness of 1st plate
			(rtos l23 2 5) " "		;gap between 1st plate and 2st plate
			(rtos li1 2 5) " "		;int_pt1
			(rtos li2 2 5)))		;int_pt2
      (setq xd (list (list -3 (list "epin" (cons 1000 xd)))))
      (mxdata  (entlast) xd)
      (setvar "useri2" (+ 1 (getvar "useri2")))
      (setvar "osmode" os_old)
      (setq err_msg2 nil)
    )
  )
)
;*************************************** End of function ****************************************;