;****************************************;
;*this is cap_zst.lsp program		*;
;*completely complied in 12/13/98	*;
;*last changed in 02/03/99		*;
;*ZX Mold Ltd   XY.Liao			*;
;****************************************;
;********************************************************************************************************;
(defun cap_zst(/ cenpt1 	cenpt2 		cenpt3 		cenpt4 		ent_no 
		sel_ent)
;-----------------------------------------------------
;calculate center line points ordinate
;-----------------------------------------------------
  (setq cenpt1 (polar cenpt 0 (* hd 0.6)))
  (setq cenpt2 (polar cenpt pi (* hd 0.6)))
  (setq cenpt3 (polar cenpt (/ pi 2) (* hd 0.6)))
  (setq cenpt4 (polar cenpt (* pi 1.5) (* hd 0.6)))
  (setq textpt (polar cenpt (/ pi 4) (+ (/ hd 2) 2.5)))
;-----------------------------------------------------
;if hidden then set current linetype as hidden
;-----------------------------------------------------
  (if (= if_h_v "1")
    (progn
      (command "linetype" "s" "hidden" "")
      (setvar "cecolor" "yellow")
    )
  )
;-----------------------------------------------------
;Draw screw top view and center line
;-----------------------------------------------------
  (setvar "osmode" 0)
  (progn
    (setq sel_ent (ssadd))
    (command "polygon" "6" cenpt "c" (/ s 2))
    (setq sel_ent (ssadd (entlast) sel_ent))
    (command "circle" cenpt (/ hd 2))
    (setq sel_ent (ssadd (entlast) sel_ent))
  )
  (progn 
    (command "linetype" "s" "center" "")
    (setvar "cecolor" "red")
    (command "line" cenpt1 cenpt2 "")
    (setq sel_ent (ssadd (entlast) sel_ent))
    (command "line" cenpt3 cenpt4 "")
    (setq sel_ent (ssadd (entlast) sel_ent))
    (setvar "celtype" "bylayer")
    (setvar "cecolor" "bylayer")
  )
;-----------------------------------------------------
;Dim item number
;-----------------------------------------------------
  (progn
    (if (not (tblsearch "style" "lxy2"))
      (command "-style" "lxy2" "txt" "" 0.6 "" "" "" "")
      (setvar "textstyle" "lxy2")
    )
    (command "text" "j" "mc" textpt 2.5 0 rep)
    (setq sel_ent (ssadd (entlast) sel_ent))
    (setvar "textstyle" st_old)
  )
;-----------------------------------------------------
;Make screw top view block and 
;add extend data in it
;-----------------------------------------------------
  (mblk (strcat "AC_LXY_BLK" (itoa (getvar "useri2"))) cenpt sel_ent)
  (setq xd (strcat 	rep " " 		;item number
			"Z" " " 		;view flag
			screw_type " " 		;dim diameter
			screw_len " " 		;dim length
			if_h_v " " 		;hidden flag
			"CAP" " " 		;type flag
			mb " " 			;meter or inch flag
  ))
  (setq xd (list (list -3 (list "screw" (cons 1000 xd)))))
  (mxdata  (entlast) xd)
  (setvar "useri2" (+ 1 (getvar "useri2")))
  (setvar "osmode" os_old)
)
;***************************************** End of function **************************************;