OnCommand = function(cmdObj) {
	if(cmdObj.cmd.toUpperCase()=="CHECK_LIB"){
		var id = cmdObj.ctrl.GetID().toUpperCase();
		WND_LRC.Show(id == "CHECK_PLAYLRC");
	}
}

WND_LRC.OnMouseIn = function(wParam) {
    var ps = WND_LRC.box_toolbar.GetPlaceSet();
    ps.rect.top = 0;
    WND_LRC.box_toolbar.ResetCtrl(ps.rect, ps.size, "lrt", ps.zindex);
}

WND_LRC.OnMouseOut = function(bUserMove) {
    var ps = WND_LRC.box_toolbar.GetPlaceSet();
    ps.rect.top = -33;
    WND_LRC.box_toolbar.ResetCtrl(ps.rect, ps.size, "lrt", ps.zindex);
}

WND_LRC.OnInitSkin = function() {
    var bMouseIn = WND_LRC.IsMouseIn();
    var ps = WND_LRC.box_toolbar.GetPlaceSet();
    if (bMouseIn) ps.rect.top = 0;
    else ps.rect.top = -33;
    WND_LRC.box_toolbar.Reset(ps.rect, ps.size, "lrt", ps.zindex);
    RefreshBtn();
}

function RefreshBtn() {
    var song = skin.GetPlayingSong();
    var bHasLrc = false;
    if (song) bHasLrc = song.HasLrc;
    WND_LRC.box_toolbar.box_btn.BTN_COPYLRC.Enable(bHasLrc);
    WND_LRC.box_toolbar.box_btn.BTN_OPENLRCDIR.Enable(bHasLrc);
    WND_LRC.box_toolbar.box_btn.BTN_LINKLRC.Enable(song ? true : false);
}
skin.OnNotifyLrcInfoChanged = RefreshBtn;