/*
 * Decompiled with CFR 0.152.
 */
package com.thexfactor117.levels.helpers;

import com.thexfactor117.levels.helpers.RandomCollection;
import java.util.Random;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;

public enum Rarity {
    UNKNOWN("", 0.0),
    BASIC(EnumChatFormatting.WHITE, 0.5),
    UNCOMMON(EnumChatFormatting.DARK_GREEN, 0.25),
    RARE(EnumChatFormatting.AQUA, 0.15),
    LEGENDARY(EnumChatFormatting.DARK_PURPLE, 0.07),
    ANCIENT(EnumChatFormatting.GOLD, 0.03);

    private static final Rarity[] RARITIES;
    private static final RandomCollection<Rarity> RANDOM_RARITIES;
    private final String color;
    private final double weight;

    private Rarity(Object color, double weight) {
        this.color = color.toString();
        this.weight = weight;
    }

    public static Rarity getRandomRarity(Random random) {
        return RANDOM_RARITIES.next(random);
    }

    public static Rarity getRarity(NBTTagCompound nbt) {
        return nbt != null && nbt.func_74764_b("RARITY") ? RARITIES[nbt.func_74762_e("RARITY")] : UNKNOWN;
    }

    public void setRarity(NBTTagCompound nbt) {
        if (nbt != null) {
            nbt.func_74768_a("RARITY", this.ordinal());
        }
    }

    public String getColor() {
        return this.color;
    }

    static {
        RARITIES = Rarity.values();
        RANDOM_RARITIES = new RandomCollection();
        for (Rarity rarity : RARITIES) {
            if (!(rarity.weight > 0.0)) continue;
            RANDOM_RARITIES.add(rarity.weight, rarity);
        }
    }
}

