/*
 * Decompiled with CFR 0.152.
 */
package com.thexfactor117.levels.helpers;

import com.thexfactor117.levels.helpers.Ability;
import com.thexfactor117.levels.helpers.AbilityHelper;
import com.thexfactor117.levels.helpers.LogHelper;
import com.thexfactor117.levels.helpers.RandomCollection;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;

public class AbilitySelection {
    private static final RandomCollection<Integer>[] ABILITY_LEVELS = new RandomCollection[20];

    public static void getRandomizedAbilities(EntityPlayer player, NBTTagCompound nbt, int level, AbilityHelper abilityHelper, Random rand) {
        if (level > 1) {
            int abilityLevel = ABILITY_LEVELS[level - 1].next(rand);
            Ability ability = abilityHelper.getRandomAbility(abilityLevel, rand);
            if (!ability.hasAbility(nbt)) {
                player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.WHITE + "\u4f60\u7684\u6b66\u5668\u83b7\u5f97\u4e86\u65b0\u80fd\u529b, " + ability.getColor() + ability.toString().toLowerCase() + EnumChatFormatting.WHITE + "!"));
            } else {
                player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.WHITE + "\u597d\u5427,\u770b\u6765\u4f60\u5df2\u7ecf\u6709\u4e86\u8fd9\u4e2a\u80fd\u529b..."));
            }
            LogHelper.info((Object)ability);
            ability.addAbility(nbt);
        }
    }

    static {
        for (int level = 2; level <= 20; ++level) {
            RandomCollection<Integer> abilityLevels = new RandomCollection<Integer>();
            switch (level) {
                case 3: {
                    abilityLevels.add(0.8, 1);
                    abilityLevels.add(0.15, 2);
                    abilityLevels.add(0.05, 3);
                    break;
                }
                case 7: {
                    abilityLevels.add(0.7, 1);
                    abilityLevels.add(0.2, 2);
                    abilityLevels.add(0.1, 3);
                    break;
                }
                case 10: {
                    abilityLevels.add(0.6, 1);
                    abilityLevels.add(0.25, 2);
                    abilityLevels.add(0.15, 3);
                    break;
                }
                case 13: {
                    abilityLevels.add(0.5, 1);
                    abilityLevels.add(0.3, 2);
                    abilityLevels.add(0.2, 3);
                    break;
                }
                case 17: {
                    abilityLevels.add(0.4, 1);
                    abilityLevels.add(0.35, 2);
                    abilityLevels.add(0.25, 3);
                    break;
                }
                case 20: {
                    abilityLevels.add(0.3, 1);
                    abilityLevels.add(0.4, 2);
                    abilityLevels.add(0.3, 3);
                }
            }
            AbilitySelection.ABILITY_LEVELS[level - 1] = abilityLevels;
        }
    }
}

