/*
 * Decompiled with CFR 0.152.
 */
package com.thexfactor117.levels.helpers;

import com.thexfactor117.levels.helpers.Ability;
import com.thexfactor117.levels.helpers.RandomCollection;
import java.util.Random;

public enum AbilityHelper {
    ABILITIES(Ability.FIRE, Ability.FROST, Ability.POISON, Ability.STRENGTH, Ability.ELEMENTAL, Ability.DARKNESS, Ability.LIGHT, Ability.BLOODLUST, Ability.ETHEREAL, Ability.STING, Ability.VOID);

    private final RandomCollection<Ability>[] abilityCollections = new RandomCollection[3];
    private final Ability[] abilities;

    private AbilityHelper(Ability ... abilities) {
        this.abilities = abilities;
        for (int i = 0; i < 3; ++i) {
            RandomCollection<Ability> abilityCollection = new RandomCollection<Ability>();
            for (Ability ability : abilities) {
                double weight = ability.getWeights()[i];
                abilityCollection.add(weight, ability);
            }
            this.abilityCollections[i] = abilityCollection;
        }
    }

    public Ability[] getAbilities() {
        return this.abilities;
    }

    public Ability getRandomAbility(int level, Random rand) {
        return this.abilityCollections[level - 1].next(rand);
    }
}

