/*
 * Decompiled with CFR 0.152.
 */
package com.thexfactor117.levels.helpers;

import com.thexfactor117.levels.helpers.Rarity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;

public enum Ability {
    FIRE(EnumChatFormatting.RED, Rarity.UNCOMMON, 0.16, 0.13, 0.09),
    FROST(EnumChatFormatting.AQUA, Rarity.UNCOMMON, 0.16, 0.13, 0.09),
    POISON(EnumChatFormatting.DARK_GREEN, Rarity.UNCOMMON, 0.17, 0.12, 0.09),
    STRENGTH(EnumChatFormatting.LIGHT_PURPLE, Rarity.UNCOMMON, 0.16, 0.12, 0.08),
    ELEMENTAL(EnumChatFormatting.GREEN, Rarity.RARE, 0.07, 0.08, 0.1),
    DARKNESS(EnumChatFormatting.DARK_GRAY, Rarity.RARE, 0.07, 0.08, 0.1),
    LIGHT(EnumChatFormatting.WHITE, Rarity.RARE, 0.06, 0.09, 0.1),
    BLOODLUST(EnumChatFormatting.DARK_RED, Rarity.LEGENDARY, 0.05, 0.08, 0.1),
    ETHEREAL(EnumChatFormatting.YELLOW, Rarity.LEGENDARY, 0.05, 0.07, 0.1),
    STING(EnumChatFormatting.GOLD, Rarity.ANCIENT, 0.03, 0.05, 0.08),
    VOID(EnumChatFormatting.DARK_GRAY, Rarity.ANCIENT, 0.02, 0.05, 0.07);

    private final String color;
    private final Rarity rarity;
    private final double[] weights;

    private Ability(Object color, Rarity rarity, double ... weights) {
        this.color = color.toString();
        this.rarity = rarity;
        this.weights = weights;
    }

    public boolean hasAbility(NBTTagCompound nbt) {
        return nbt != null && nbt.func_74767_n(this.toString());
    }

    public void addAbility(NBTTagCompound nbt) {
        nbt.func_74757_a(this.toString(), true);
    }

    public void removeAbility(NBTTagCompound nbt) {
        nbt.func_82580_o(this.toString());
    }

    public String getColor() {
        return this.color;
    }

    public Rarity getAbilityRarity() {
        return this.rarity;
    }

    public double[] getWeights() {
        return this.weights;
    }
}

