/*
 * Decompiled with CFR 0.152.
 */
package com.thexfactor117.levels.events;

import com.thexfactor117.levels.helpers.AbilityHelper;
import com.thexfactor117.levels.helpers.Experience;
import com.thexfactor117.levels.helpers.NBTHelper;
import com.thexfactor117.levels.helpers.Rarity;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.event.entity.living.LivingDeathEvent;

public class EventLivingDeath {
    @SubscribeEvent
    public void onEntityDeath(LivingDeathEvent event) {
        if (event.source.func_76364_f() instanceof EntityPlayer) {
            NBTTagCompound nbt;
            EntityPlayer player = (EntityPlayer)event.source.func_76364_f();
            Random rand = player.field_70170_p.field_73012_v;
            ItemStack stack = player.field_71071_by.func_70448_g();
            if (stack != null && stack.func_77973_b() instanceof ItemSword && (nbt = NBTHelper.loadStackNBT(stack)) != null) {
                Rarity rarity = Rarity.getRarity(nbt);
                int level = Experience.getLevel(nbt);
                int experience = Experience.getExperience(nbt);
                if (rarity == Rarity.UNKNOWN) {
                    rarity = Rarity.getRandomRarity(rand);
                    rarity.setRarity(nbt);
                    if (rarity == Rarity.ANCIENT) {
                        player.field_70170_p.func_72956_a((Entity)player, "mob.enderdragon.end", 0.8f, 1.0f);
                    }
                }
                if (level < 20) {
                    if (event.entityLiving instanceof EntityMob) {
                        Experience.setExperience(nbt, Experience.getExperience(nbt) + 10);
                    }
                    if (event.entityLiving instanceof EntityAnimal) {
                        Experience.setExperience(nbt, Experience.getExperience(nbt) + 2);
                    }
                }
                level = Experience.getNextLevel(player, nbt, AbilityHelper.ABILITIES, level, experience, rand);
                Experience.setLevel(nbt, level);
                NBTHelper.saveStackNBT(stack, nbt);
            }
        }
    }
}

