/*
 * Decompiled with CFR 0.152.
 */
package com.thexfactor117.levels.events;

import com.thexfactor117.levels.helpers.Ability;
import com.thexfactor117.levels.helpers.AbilityHelper;
import com.thexfactor117.levels.helpers.Experience;
import com.thexfactor117.levels.helpers.NBTHelper;
import com.thexfactor117.levels.helpers.Rarity;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;

public class EventItemTooltip {
    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void addInformation(ItemTooltipEvent event) {
        ItemStack stack = event.itemStack;
        Item item = stack.func_77973_b();
        NBTTagCompound nbt = NBTHelper.loadStackNBT(stack);
        if (item != null && item instanceof ItemSword) {
            if (nbt != null) {
                Rarity rarity = Rarity.getRarity(nbt);
                AbilityHelper abilityHelper = AbilityHelper.ABILITIES;
                String exp = Experience.getLevel(nbt) == 20 ? I18n.func_135052_a((String)"levels.experience.max", (Object[])new Object[0]) : Experience.getExperience(nbt) + " / " + Experience.getMaxLevelExp(Experience.getLevel(nbt));
                event.toolTip.add("");
                event.toolTip.add(rarity.getColor() + EnumChatFormatting.ITALIC + I18n.func_135052_a((String)("levels.rarity." + rarity.ordinal()), (Object[])new Object[0]));
                event.toolTip.add("\u7b49\u7ea7: " + Experience.getLevel(nbt));
                event.toolTip.add("\u7ecf\u9a8c: " + exp);
                event.toolTip.add("\u8010\u4e45\u5ea6: " + (stack.func_77958_k() - stack.func_77960_j()) + " / " + stack.func_77958_k());
                event.toolTip.add("");
                for (Ability ability : abilityHelper.getAbilities()) {
                    if (!ability.hasAbility(nbt)) continue;
                    event.toolTip.add(ability.getColor() + I18n.func_135052_a((String)("levels.ability." + ability.toString().toLowerCase()), (Object[])new Object[0]));
                }
            } else {
                nbt = new NBTTagCompound();
                stack.func_77982_d(nbt);
                Rarity.UNKNOWN.setRarity(nbt);
                Experience.setExperience(nbt, 0);
                Experience.setLevel(nbt, 1);
            }
        }
    }
}

