<?php
// +----------------------------------------------------------------------
// | ThinkPHP [ WE CAN DO IT JUST THINK ]
// +----------------------------------------------------------------------
// | Copyright (c) 2006~2016 http://thinkphp.cn All rights reserved.
// +----------------------------------------------------------------------
// | Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------
// | Author: 麦当苗儿 <zuojiazi@vip.qq.com> <http://zjzit.cn>
// +----------------------------------------------------------------------

namespace think\exception;

use think\exception\DbException;

/**
 * PDO异常处理类
 * 重新封装了系统的\PDOException类
 */
class PDOException extends DbException 
{
    /**
     * PDOException constructor.
     * @param \PDOException $exception
     * @param array $config
     * @param string $sql
     * @param int $code
     */
    public function __construct(\PDOException $exception, Array $config, $sql, $code = 10501)
    {
        $error = $exception->errorInfo;

        $this->setData('PDO Error Info', [
            'SQLSTATE'             => $error[0],
            'Driver Error Code'    => $error[1],
            'Driver Error Message' => isset($error[2]) ? $error[2] : ''
        ]);

        parent::__construct($exception->getMessage(), $config, $sql, $code);
    }
}
