﻿/*==============================================================================================
   HTML Parsing Blocks. The following vars contain HTML code to be inserted in the Register
   Today HTML pages based on the business logic, e.g., whether the registration is for a company
   or individual, whether an old serial number is needed, whether State/Region/Province is 
   required, etc.

   (C) Copyright 2004 by Autodesk, Inc.  All rights reserved.
  ==============================================================================================*/

/////////////////////////////////////////////
// LOCALIZATION RESOURCES HERE:
/////////////////////////////////////////////

/////////////////////////////////////////////
// Product Language: 
//
// NOTE TO LOCALIZATION: The list below was inserted on 29 Jan 2001 and it was up to date at that point.
// You may use the codes detailed below if you are sure that these have not changed (they generally don抰 change), otherwise, 
// please check these before inserting the language code.
/////////////////////////////////////////////
//
//English - US and International:  (en-us)
//German:  (de)
//French:   (fr)
//Italian:   (it)
//Spanish:   (es)
//Czech:   (cs)             
//Hungarian:   (hu)
//Polish:   (pl)
//Russian:   (ru)
//Japanese:   (ja)
//Korean:   (ko)
//Traditional Chinese (Taiwan) :   (zh-tw)
//Simplified Chinese (PRC) :   (zh-cn)
//Brazilian Portuguese (pt-br)
//
/////////////////////////////////////////////

var xmsgProductLanguage= "zh-cn";

/////////////////////////////////////////////
// Disable field color
/////////////////////////////////////////////
var xmsgDisableColor= "#7f7f7f";

var xmsgNavigationBGColor= "#f4f4f4";
var xmsgNavigationDisableColor= "#808080";

/////////////////////////////////////////////
// HTML FILE TITLE STRINGS
/////////////////////////////////////////////
var xmsgRT0015TempSysErr= "连接错误 (0.15)";
var xmsgRT010203071213CannotCompErrA= "注册错误 (1.2.3.7.12.13)";
var xmsgRT09AlreadyReg= "已注册 (9)";
var xmsgRT10ExceededAuths= "超出授权数 (10)";
var xmsgRT12StolenSN= "被盗的序列号 (12)";
var xmsgRT18OldSNInvalid= "以前的序列号无效 (18)";
var xmsgRT20DataError= "数据错误 (20)";
var xmsgRT21CustIDTelErr= "客户 ID/电话错误 (21)";
var xmsgRT22NetworkInstallation= "网络安装错误 (22)";
var xmsgRT900SystemNotResponding= "系统未响应 (900)";
var xmsgRTAuthConfirmed= "授权已确认";
var xmsgRTAuthEntryError= "激活输入错误";
var xmsgRTAuthError= "激活错误";
var xmsgRTAuthNow= "立即授权";
var xmsgRTBeginReg= "开始注册";
var xmsgRTBuyInformation= "购买信息";
var xmsgRTConfirm= "用户确认";
var xmsgRTConnect= "连接";
var xmsgRTConnectFail= "连接错误";
var xmsgRTContactAutodesk= "与 Autodesk 联系";
var xmsgRTCountryPage= "国家/地区";
var xmsgRTCustID= "客户 ID";
var xmsgRTCustIDConfirm= "确定标识";
var xmsgRTEmail= "电子邮件";
var xmsgRTFaxUS= "用户传真给我们";
var xmsgRTMailUS= "用户邮寄给我们";
var xmsgRTNewSerialNumber= "新序列号信息";
var xmsgRTNoNewSN= "购买事务出错";
var xmsgRTPurchAuthFailed= "激活错误";
var xmsgRTPurchConfirmOther= "购买确认";
var xmsgRTPurchConfirmPerm= "购买确认 - 已注册和激活";
var xmsgRTPurchConfirmReg= "购买确认 - 已注册但未激活";
var xmsgRTPurchConfirmRegVol= "购买确认 - 已注册";
var xmsgRTPurchConfirmRent= "购买确认 - 已注册并激活租用";
var xmsgRTPurchConfirmUnReg= "购买确认 - 未注册或激活";
var xmsgRTPurchConnectionFailed= "购买连接失败";
var xmsgRTPurchaseError= "购买错误";
var xmsgRTPurchaseOffline= "脱机购买";
var xmsgRTRegConfirmed= "注册已确认";
var xmsgRTRegVol= "注册产品";
var xmsgRTSNMismatch= "购买事务出错 - 序列号不匹配";
var xmsgRTSUNDataConfirm= "SUN 数据确认";
var xmsgRTSUNOldSNInvalid= "以前的序列号无效 - SUN";
var xmsgRTSUNServer= "SUN 服务器";
var xmsgRTSUNSubmit= "用户确认/提交 SUN";
var xmsgRTUserInfo= "用户信息";
var xmsgRTLicFileSaveError= "Flexlm 许可证文件保存出错";
var xmsgNSARTBegin= "获取网络许可证";
var xmsgNSARTLocateLicense= "定位许可证文件";
var xmsgNSARTEditServerAndSeat= "输入或修改服务器信息";
var xmsgNSARTConfirmServerAndSeat= "确认服务器信息";
var xmsgNSARTEnterSN= "输入序列号";


/////////////////////////////////////////////
// Software Information RESOURCES HERE:
/////////////////////////////////////////////
var xmsgProduct= "产品: ";
var xmsgsernum= "序列号: ";
var xmsgsernumWGID= "序列号/编组 ID:  ";
var xmsgOsernum= "以前的序列号: ";
var xmsgOldSerialNum= "以前的序列号:*";
var xmsgNewSernum1= "新序列号";
var xmsgRequestCode= "申请号: ";
var xmsgRegAuthCode= "激活码: ";
var xmsgApplicationKey= "授权申请号: ";
var xmsgRTHostID= "主机 ID:";
var xmsgRTFlexlmLicenseFile= "许可证文件:";

/////////////////////////////////////////////
// Primary Rolodex RESOURCES HERE:
/////////////////////////////////////////////
var xmsgSalutation= "称呼:";
var xmsgNone= "(无)";
var xmsgNotEntered= "(未输入)";
var xmsgFirstname= "名字:";
var xmsgFirstnameKanji= "名字 (日语汉字):";
var xmsgFirstnameFurigana= "名字 (全角日语片假名):";
var xmsgLastname= "姓氏:";
var xmsgLastnameKanji= "姓氏 (日语汉字):";
var xmsgLastnameFurigana= "姓氏 (全角日语片假名):";
var xmsgCompanyName= "公司名称:*";
var xmsgCompanyName2= "公司名称:";
var xmsgCompanyNameJP= "公司名称 (日语汉字): ";
var xmsgPhone= "电话: ";
var xmsgArea= "地区:";
var xmsgNumber= "编号:";
var xmsgExt= "Ext:";
var xmsgFax= "Fax:";
var xmsgFaxTo= "传真至";
var xmsgEmail= "电子邮件:";
var xmsgEmailTo= "发送电子邮件至";
var xmsgAddress= "街道地址:";
var xmsgAddress2= "街道地址 2:";
var xmsgAddress3= "街道地址 3:";
var xmsgJPAddress= "镇:";
var xmsgJPAddress2= "街道地址:";
var xmsgJPAddress3= "建筑名称 (及房间号):";
var xmsgCity= "城市:";
var xmsgSRP= "州/地区/省:";
var xmsgStText= "州:";
var xmsgPrText= "省:";
var xmsgRegText= "地区:";
var xmsgPrefectureText= "区: ";
var xmsgCountyText= "县: ";
var xmsgCantonText= "乡: ";
var xmsgZipCode= "邮政编码:";
var xmsgPostCode= "邮政编码:";
var xmsgCountry= "国家或地区:";
var xmsgDealer= "Autodesk 授权经销商名称: ";
var xmsgMailTo= "邮寄至";
var xmsgAnEmail= "电子邮件地址";
var xmsgAFax= "传真号码";
var xmsgAMailAddress= "邮寄地址";

///////////////////////////////////////////////
// Button RESOURCES HERE:
///////////////////////////////////////////////
var xmsgBack= "上一步";
var xmsgCancel= "取消";
var xmsgExit= "退出";
var xmsgNext= "下一步";
var xmsgPrint= "打印";
var xmsgNo= "否";
var xmsgYes= "是";
var xmsgRegister= "注册";
var xmsgAuthorize= "激活";
var xmsgBrowse= "浏览";
var xmsgSkipStep= "上一步";
var xmsgLoad= "下一步";
var xmsgDone= "完成";
var xmsgOK= "确定";
var xmsgClose= "关闭";
var xmsgSubmit= "提交";
var xmsgFinish= "完成";

///////////////////////////////////////////////
// Registration User Prompt RESOURCES HERE:
///////////////////////////////////////////////
var xmsgPleaseSelect= "请选择 ";
var xmsgPleaseSelect2= "选择以下的某个选项，然后单击“下一步”。";
var xmsgSelectCountry= "产品使用者所在的国家/地区: ";
var xmsgSelectCountry2= "用于以下目的的联系信息: ";
var xmsgInformation= "信息";
var xmsgCompanyInfo= "公司信息";
var xmsgContactInfo= "联系信息";
var xmsgConfirmInfo= "确认信息";
var xmsgConfirmInfoTxt= "查看下列信息。单击“提交”以提交信息，或者单击“上一步”以进行修改。";
var xmsgConfirmCustIDInfoTxt= "确认以下信息。单击“下一步”继续，或者单击“上一步”进行修改。";
var xmsgCountryHdr= "开始注册 - 激活";
var xmsgNSACountryHdr= "注册并激活 Autodesk 产品";
var xmsgCountryRegTo= "本产品将注册给： ";
var xmsgCountryComp= "公司";
var xmsgCountryIndiv= "个人";
var xmsgCountryUpgrade= "这是升级版";
var xmsgCountryUpgDetail= "(如果您是 Subscription 客户，请单击“否”。)";
var xmsgConnectHdr1= "正在连接";
var xmsgConnectHdr= "连接到 Internet";
var xmsgConnectMsg= "连接";
var xmsgConnectTxt= "未检测到 Internet 连接。要提交联机请求，请现在就连接到 Internet。";
var xmsgConnectTxt2= "建立 Internet 连接后，单击“下一步”。";
var xmsgConnectTxt3= "要使用其他方式提交请求，请单击以下链接: ";
var xmsgConnectWarming= "提交此信息可能需要几分钟时间。请稍候。";
var xmsgTryAgain= "重试";
var xmsgReEnterOld= "重新输入先前的序列号";
var xmsgNewSernum3= "请输入新序列号并单击“下一步”。";
var xmsgNewSernum4= "试用版软件安装时使用了序列号 (000-00000000)，此序列号无法注册。如果您已经购买了本软件，您就已经获得了一个新序列号。必须使用这个序列号进行激活，使产品可以投入使用。";
var xmsgNewSernum5= "新序列号: ";
var xmsgNewSernum6= "确认新序列号: ";
var xmsgNewSernum8= "重输入新序列号";
var xmsgUseOtherMethod= "使用另一种注册方法";
var xmsgContactAutodesk= "与 Autodesk 联系";
var xmsgContactAutodeskLink= "要与 Autodesk 联系，请单击以下链接: ";
var xmsgContactOptions= "联络方式显示如下:";

var xmsgPuchaseInfo1= "购买信息";
var xmsgPuchaseInfo2= "您已选择进行联机购买。以下屏幕将: ";
var xmsgPuchaseInfo3= "收集必要的信息";
var xmsgPuchaseInfo4= "将此信息存储在计算机上以便注册时使用";
var xmsgPuchaseInfo5= "允许确认过程的每一步";
var xmsgPuchaseInfo6= "确认软件购买和激活";
var xmsgPuchaseInfo7= "请单击“下一步”继续；如果不需要继续，可单击“取消”。";

var xmsgRegTitle= "注册 - 激活";
var xmsgRegTitleBuy= "联机购买 Autodesk 产品";
var xmsgRegTitleNSA= "网络许可证激活";
var xmsgRegInfo= "客户信息";
var xmsgRegInfo2= "注册方法";
var xmsgRegInfo3= "请选择一种注册方法并单击“下一步”。";
var xmsgRegmethod1= "通过 Internet 直接连接";
var xmsgRegmethod3= "我希望通过以下方式收到激活码: ";
var xmsgRegmethod5= "邮件";
var xmsgRegmethod6= "单击下面的“打印”，并将此表格邮寄给:";
var xmsgRegmethod7= "传真";
var xmsgRegmethod8= "要打印可以传真给 Autodesk (传真号码 %1) 的表单，请首先选择接收激活码的方式，单击“打印”，然后传真该表单。";
var xmsgRegmethod9= "电子邮件";
var xmsgRegmethod10NSA= "下面显示的注册和许可服务器信息已自动保存到文件中。";
var xmsgRegmethod10= "注册信息已保存到以下文件中，该文件将用于完成电子邮件注册的过程 (请勿修改此文件): ";
var xmsgRegmethod11NSA= "通过电子邮件将注册和许可服务器信息文件 %1 发送到 %2。";
var xmsgRegmethod11= "通过电子邮件将注册信息文件 %1 发送到 %2。";
var xmsgRegmethod12= "确保您对该文件未作任何修改。<p>建议您将本页打印一份，然后存放到安全的地方。手动完成电子邮件过程时，将用到这些信息。<p>您可以将这些信息打印一份以作记录。单击“完成”关闭本应用程序。";
var xmsgRegmethod13= "要自动附着 %1 并将其发送至 Autodesk，请单击以下链接。";
var xmsgRegmethod14= "附着并发送电子邮件";
var xmsgRegmethod15= "注意: 这是自动进行回复的电子邮件地址。请勿与此地址进行电子邮件通信。]";
var xmsgRegmethod16= "要通过传真或电子邮件注册，请单击以下链接之一: ";
var xmsgRegmethod17= "发送电子邮件时出错";
var xmsgRegmethod18NSA= "在系统尝试自动发送注册和许可服务器信息时出错。";
var xmsgRegmethod18= "在系统尝试自动发送注册信息时出错。";
var xmsgRegmethod19= "要手动通过电子邮件发送该文件:";
var xmsgRegmethod20NSA= "通过电子邮件将注册和许可服务器信息文件 %1 发送到 %2。";
var xmsgRegmethod20= "通过电子邮件将注册信息文件 %1 发送到 %2。";
var xmsgRegmethod21= "确保您对该文件未作任何修改。<p>建议您将本页打印一份，然后存放到安全的地方。手动完成电子邮件过程时，将用到这些信息。<p>您可以将这些信息打印一份以作记录。单击“完成”关闭本应用程序。";
var xmsgRegAuthInfo= "激活";
var xmsgRegAuthInfo1= "确认";
var xmsgRegAuthInfo2= "获取激活码";
var xmsgRegAuthInfo3= "输入激活码"; 
var xmsgRegAuthInfo4= "输入激活码: ";
var xmsgRegAuthInfo4A= "输入激活码";
var xmsgRegAuthInfo5= "请选择国家或地区，输入激活码并单击“下一步”。";
var xmsgRegAuthInfo6= "注册 - 激活确认";	
var xmsgRegAuthInfo7= "感谢您注册并激活产品。";
var xmsgRegAuthInfo8= "注册确认";		
var xmsgRegAuthInfo9= "感谢您注册 Autodesk 产品。这将帮助我们为您提供更好的服务。";
var xmsgRegAuthInfo10= "一份注册信息已保存到以下位置，供您参考: ";		
var xmsgRegAuthInfo10B= "一份注册信息已保存到以下位置: ";		
var xmsgRegAuthInfo11= "感谢您的注册 - 您的产品现在已激活，并且许可证文件已保存。请单击“打印”以保留此信息的记录。";
var xmsgRegErrorHdr= "注册 - 激活错误";
var xmsgRegErrorSystem= "出现临时的系统问题，导致注册过程出错。请单击以下链接之一。";
var xmsgRegErrorOnline= "此注册无法以联机方式完成。请单击以下链接之一。";
var xmsgRegErrorPrevReg= "您输入的序列号已经注册。";
var xmsgRegErrorMaxAuth= "您已经超出了本产品所允许的激活数目。";
var xmsgRegErrorMaxAuth2= "您已经超出了本产品所允许的许可证数目。";
var xmsgRegErrorInvalidOld= "您输入的早期产品的序列号无效。请验证上面显示的早期序列号是否正确，然后单击以下链接之一。";
var xmsgRegErrorData= "您提供的注册数据有问题。您可以选择“重试”以查看并更正所输入的信息，使用其他方法进行注册，也可与 Autodesk 联络以便继续。";
var xmsgRegErrorNetwork= "您尝试注册的产品是网络授权的产品，必须以网络方式进行安装。您必须删除安装该软件，然后选择“网络”作为安装类型。<p>请参考安装指南中的“网络安装”一节，以了解安装和激活网络版的正确步骤。";
var xmsgRegNoResponse= "出现临时问题，导致联机注册过程出错。请单击以下链接之一。";
var xmsgRegErrorAuthEntry= "您输入的激活码有问题。请单击以下链接之一。";
var xmsgRegErrorAuthPermission = "要激活本 Autodesk 产品，您必须具有管理员权限或由系统管理员授予更高的权限。有关管理员和更高权限的详细信息，请与系统管理员联系。";							
var xmsgRegErrorAuth= "激活码有问题。请单击以下链接之一。";
var xmsgRegErrorFlex= "许可证有问题。请单击以下链接之一。";
var xmsgRegConnError= "连接错误";
var xmsgRegConnErrorTxt= "Internet 连接有问题。请单击以下链接之一。";
var xmsgRegPurchError1= "购买错误";
var xmsgRegPurchError2= "此购买事务没有以联机方式完成。请单击以下链接之一。";
var xmsgRegPurchError3= "使用另一种购买方法";
var xmsgRegPurchError4= "出现临时的系统问题，无法进行联机购买。请单击以下链接之一。";
var xmsgRegPurchError5= "感谢您选择购买 Autodesk 软件。<p>用以完成此过程的连接目前不可用，这可能是由于系统设置的缘故。<p>在下面的任意一个链接上单击以打开浏览器，如此可能使您连接成功。<p>";

var xmsgPurchTransErrHdr= "购买事务发生错误";
var xmsgPurchTransError1= "要完成购买，必须有一个新序列号 - 未发出新序列号。<br>请与 Autodesk 联系。";
var xmsgPurchTransError2= "在使用服务器确认序列号时出错。<br>请与 Autodesk 联系。";
var xmsgAuthErrHdr= "激活错误";
var xmsgThankForPurchase= "感谢您购买 Autodesk 软件";
var xmsgAuthError1= "出现临时问题，无法授权。请单击以下链接之一。";
var xmsgRentalInfo= "如果您购买的是租用产品，租用期从激活本产品之日开始。";
var xmsgRegLaterInfo= "如果您希望现在注册并激活，请单击“激活”。如果您希望以后再注册，请选择“帮助”|“联机购买”，然后选择“激活”。";
var xmsgAuthorizeNow= "立即联机激活";
var xmsgAuthorizeLater= "以后再激活";
var xmsgPurchOtherProdInfo= "随时可以选择“帮助|联机购买”来购买其他产品。";
var xmsgPurchAdditionalProdInfo= "随时可以选择“帮助|联机购买”来购买其他产品。";
var xmsgRegAndAuthInfo= "您的产品已注册且已激活。";
var xmsgRegButNotAuthInfo= "您的产品已注册，但尚未激活。";
var xmsgRegisteredInfo= "您的产品已注册。";
var xmsgNotRegOrAuthInfo= "您的软件尚未注册和激活。";
var xmsgToAuthorizeInfo= "要立即激活，请选择“激活”。";
var xmsgRegAndActiveRentalInfo= "您的产品已注册，现在开始计算您购买的租用期。";
var xmsgAuthNowOrLaterInfo= "如果您希望以后再激活，请选择“帮助”|“联机购买”，然后选择“激活”。";
var xmsgRemindRentalInfo= "当租用到期时，您会得到提示。";
var xmsgPurchHdr= "购买确认";
var xmsgRentalPurchHdr= "租用";

var xmsgAuthResellerMsg1= "从本地经销商处购买。与本地经销商联系，以完成购买。";

var xmsgLicSaveErrInfo= "保存许可证文件时出现错误。请单击以下链接之一。";

var xmsgOnlineStoreMsg1= "在 Autodesk 联机商店中购买。如果在商店中找不到要购买的产品，请与授权经销商联系。";
var xmsgOnlineStoreMsg2= "联机商店";
var xmsgAuthResellerMsg2= "授权经销商";
var xmsgLocateLicenseMsg1= "定位许可证文件";
var xmsgLocateLicenseMsg2= "输入许可证文件的路径 (或使用“浏览”定位一个许可证文件)，然后单击“下一步”继续。";
var xmsgLocateLicenseMsg3= "现有许可证文件:";
var xmsgRegError1_2Hdr= "序列号/Subscription 编组 ID 无效";
var xmsgRegError1_2Msg= "<p>您输入的序列号或编组 ID (仅对 Subscription 客户) 无效。请检查安装产品时输入的数字。</p><p>如果确定输入的序列号/编组 ID 不正确，请单击“关闭”以退出“注册 - 激活”。然后删除安装本产品，并使用正确的序列号/编组 ID 来重新安装。</p><p>注意: 如果产品不需要重新安装，请退出“现在注册”，然后重新输入序列号。</p><p>如果确定序列号/编组 ID 是正确的，请单击以下链接之一。</p>";
var xmsgRegError1_2Msg2= "<p>注意: 如果您是 Subscription 客户，则必须使用您的编组 ID 来安装软件。请勿使用产品序列号。序列号和编组 ID 都位于产品外包装上。</p>";
var xmsgUserContactMsg= "至少必须输入以下内容之一: ";

/////////////////////////////////////////////
// Single User Network RESOURCES HERE:
/////////////////////////////////////////////
var xmsgRegSunData1= "注册数据已保存";
var xmsgRegSunData2= "客户端展开所需的注册数据已经保存在 ";
var xmsgRegSunData3= "为此升级版注册提供的“以前的序列号”无效。请与管理员联系。";
var xmsgRegSunData4= "本软件必须以有效的以前的序列号重新安装。";
var xmsgRegSunData5= "多席位单机展开";
var xmsgRegSunData6= "要完成多席位单机展开，需要某些注册信息。随后的对话框将:";
var xmsgRegSunData7= "收集必要的信息。";
var xmsgRegSunData8= "如果升级时需要，可以输入以前的序列号。";
var xmsgRegSunData9= "在服务器上存储此信息，以便展开到所有的客户端安装。";
var xmsgRegSunData10= "此软件将用以下信息注册。单击“下一步”继续。";

/////////////////////////////////////////////
// Voluntary RESOURCES HERE:
/////////////////////////////////////////////
var xmsgRegVol1= "产品注册 - 授权";
var xmsgRegVol2= "请选择下列选项之一并单击“下一步”:";
var xmsgRegVol3= "现在注册 - 选择此选项开始联机注册";
var xmsgRegVol4= "以后注册 - 选择此选项试用此软件";
var xmsgRegVol5= "不再显示此消息";
var xmsgRegVol6= "(如果希望以后再注册，可以在“帮助”-“关于”对话框中选择注册选项。)";

/////////////////////////////////////////////
// Japan RESOURCES HERE:
/////////////////////////////////////////////
var xmsgCustIDMainTitle= "Customer Identification";
var xmsgCustIDTitle1= "Customer ID";
var xmsgCustIDText2= "在下面输入您的客户 ID 和电话号码。如果您没有客户 ID，请将这两个字段保留空白。<p> ";
var xmsgCustIDText3= "注意: 如果您要重新激活产品，则必须输入客户 ID。";
var xmsgCustIDText3NSA= "注意: 如果您要重新授权产品，则必须输入客户 ID。";
var xmsgCustIDTitle2= "电话号码:";
var xmsgCustIDTelEx4= "(例如: 03-111-1234)";
var xmsgRegCustIDTel= "您输入的“客户 ID”和“电话号码”与我们的记录不匹配。请单击以下链接之一。";
var xmsgPhoneNoAst= "电话号码";
var xmsgKatakana= "公司名称 (全角日语片假名):";
var xmsgDepartment= "部门: ";
var xmsgDepartment2= "Department name";

/////////////////////////////////////////////
// Autodesk Contact RESOURCES HERE:
/////////////////////////////////////////////
var xmsgFormWebHdr= "在 Internet 上: ";
var xmsgFormWebDataMsg1= "您还可以从 Autodesk 授权经销商处，或者通过访问以下网址获取激活码:<br>";
var xmsgFormEmailHdr= "通过电子邮件: ";
var xmsgFormEmailData= "";
var xmsgFormEmailDataBlock= "";
var xmsgFormEmailXMLData= "";
var xmsgFormEmailXMLDataBlock= "";
var xmsgFormFaxHdr= "通过传真: ";
var xmsgFormFaxHdrLocal= "通过传真至本地办事处: ";
var xmsgFormFaxHdrReg= "传真注册";
var xmsgFormFaxData= "";
var xmsgFormFaxDataRegister= "";
var xmsgFormCallHdr= "通过电话: ";
var xmsgFormCallData= "";
var xmsgFormMailHdr= "通过邮件: ";
var xmsgFormMailHdrLocal= "通过邮递至本地办事处: ";
var xmsgFormMailHdrReg= "邮件注册";
var xmsgFormMailData= "";
var xmsgFormMailDataRegister= "";
var xmsgFormPurchHdr= "购买软件";

/////////////////////////////////////////////
// Privacy Statement RESOURCES HERE:
/////////////////////////////////////////////

function xmsgPrivacy() {
var JPprivacystatement = "Autodesk 将使用您提供的信息来注册和/或发放激活码。进行注册即表明您同意 Autodesk 将您的相关信息提供给我们的授权商业合作伙伴，用于产品许可证管理和权利验证。如果您希望 Autodesk 不要将您的相关信息与授权商业合作伙伴共享，以用于这些有限的目的，请通过 <a href=mailto:information@autodesk.jp>information@autodesk.jp</a> 与 Autodesk 联系。如果您希望更正或更新注册数据，请单击<a "+ xmsgCountryHEREURL +">此处</a>与 Autodesk 联系，或者与当地的 Autodesk 分公司联系。";
				
var privacystatement = "Autodesk 将使用所提供的信息来注册和/或生成激活码、帮助您了解关于我们的产品和服务的最新信息，以及确保您从 Autodesk 授权用户的身份中受益。Autodesk 不会将您的信息出售或者提供给 Autodesk 或我们的授权商业合作伙伴之外的任何人。如果要更正或更新早期注册的客户信息，请单击<a "+ xmsgCountryHEREURL +">此处</a>，与 Autodesk 或当地的 Autodesk 办事处联系。";
				
	if (country == "JP") {
		return JPprivacystatement;
	} else {			
		return privacystatement;
	}
}
			
/////////////////////////////////////////////
// Privacy Policy
/////////////////////////////////////////////
var xmsgPrivacyPolicy= "保密政策";

/////////////////////////////////////////////
//  Note to Localization :
//
//	"InsertRegInfo" appears in RTUserInfo.html.  The full sentence in English is
//
//	"Fields marked in <FONT color=red>red</FONT> and with an asterisk?<FONT 
//	color=red>*</FONT>)燼re required to process your registration. Complete the form 
//	and click Next."
//
/////////////////////////////////////////////
var xmsgRegInfoMsg1= "标记为 <FONT color=red>*</FONT> 的字段是必需的字段。";
var xmsgRegInfoMsg2= "本页上输入的信息将与许可证存储在一起。此信息用于产品的重新激活和升级。请确保在此处输入有效的信息，以避免在使用产品时出现延迟。";

/////////////////////////////////////////////
//  Note to Localization :
//
//	"xmsgRT113SeatMsg1" appears in NSA_RT113TooManySeats.html.  The full sentence in English is
//
//	"Our records indicate that you have [Max allowed seats] valid [product name] seats available." 
/////////////////////////////////////////////
var xmsgRT113SeatMsg1= "我们的记录表明您可以使用 %1 个有效 %2 席位。<br>";

var xmsgLicLocationText1 = "将 <b>%1</b> 的许可证文件保存到:";

// Set Registration Info Header
var InsertRegInfo = "<p><b>"+xmsgRegInfo+"</b></p><p>" + xmsgRegInfoMsg1 + "</p>";


//=======================================================================
// Application Usage Information
//=======================================================================
var xmsgAppUsage= "问题: ";

var xmsgAppUsageQ1= "为了帮助 Autodesk 更好地了解您所在行业的需求，请回答几个简短的问题。";
var xmsgAppUsageQ2= "以下哪一项最好地描述了您的工作所属的市场？";
var xmsgAppUsageQ3= "选择您的职业";
var xmsgAppUsageQ4= "选择您的行业";
var xmsgAppUsageRequiredMark = ":*";
var xmsgAppUsageRequired= "显示问题";

var xmsgAppUsageBlankSpaces= "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";

var xmsgAppUsageOption01= "建筑设计、施工和管理 ";
var xmsgAppUsageOption02= "制造设计、文档和管理 ";
var xmsgAppUsageOption03= "制图、市政和基础设施管理 ";
var xmsgAppUsageOption04= "数字媒体创建、管理和提供 ";
var xmsgAppUsageOption05= "无线定位服务 ";
var xmsgAppUsageOption20= "其他 ";

var xmsgAppUsageOption21= "动画 ";
var xmsgAppUsageOption22= "应用程序开发 ";
var xmsgAppUsageOption23= "建筑 ";
var xmsgAppUsageOption24= "广播图形 ";
var xmsgAppUsageOption25= "建筑设备制造和供应 ";
var xmsgAppUsageOption26= "建筑系统工程 ";
var xmsgAppUsageOption27= "土木工程 ";
var xmsgAppUsageOption28= "施工管理 ";
var xmsgAppUsageOption29= "设计可视化 ";
var xmsgAppUsageOption30= "剪辑和修饰 ";
var xmsgAppUsageOption31= "电子网络设计 ";
var xmsgAppUsageOption32= "设备管理 ";
var xmsgAppUsageOption33= "游戏开发 ";
var xmsgAppUsageOption34= "地理信息系统 ";
var xmsgAppUsageOption35= "室内设计 ";
var xmsgAppUsageOption36= "IT 管理 ";
var xmsgAppUsageOption37= "园林建筑 ";
var xmsgAppUsageOption38= "机械设计 ";
var xmsgAppUsageOption39= "制造 ";
var xmsgAppUsageOption40= "制造分析 ";
var xmsgAppUsageOption41= "贴图";
var xmsgAppUsageOption42= "运营和租赁 ";
var xmsgAppUsageOption43= "规划 ";
var xmsgAppUsageOption44= "车间管理 ";
var xmsgAppUsageOption45= "工序和电力设备设计 ";
var xmsgAppUsageOption46= "采购 ";
var xmsgAppUsageOption47= "产品设计 ";
var xmsgAppUsageOption48= "项目管理 ";
var xmsgAppUsageOption49= "销售和市场 ";
var xmsgAppUsageOption50= "测绘 ";
var xmsgAppUsageOption51= "教学 ";
var xmsgAppUsageOption52= "电信工程 ";
var xmsgAppUsageOption53= "工具和模具设计 ";
var xmsgAppUsageOption54= "视觉效果 ";
var xmsgAppUsageOption55= "Web 视频编辑和发布 ";
var xmsgAppUsageOption59= "其他 ";
var xmsgAppUsageOption60= "应用程序开发 ";
var xmsgAppUsageOption61= "汽车零部件 ";
var xmsgAppUsageOption62= "广播 ";
var xmsgAppUsageOption63= "商务接待 ";
var xmsgAppUsageOption64= "商务办公 ";
var xmsgAppUsageOption65= "商务零售 ";
var xmsgAppUsageOption66= "通信 ";
var xmsgAppUsageOption67= "消费产品 ";
var xmsgAppUsageOption68= "设计可视化 ";
var xmsgAppUsageOption69= "教育 ";
var xmsgAppUsageOption70= "机电 ";
var xmsgAppUsageOption71= "紧急响应 ";
var xmsgAppUsageOption72= "环境 ";
var xmsgAppUsageOption73= "游戏 ";
var xmsgAppUsageOption74= "政府 ";
var xmsgAppUsageOption75= "工业 ";
var xmsgAppUsageOption76= "工业设备 ";
var xmsgAppUsageOption77= "工业机械 ";
var xmsgAppUsageOption78= "公共大学教育 ";
var xmsgAppUsageOption79= "公共中小学教育 ";
var xmsgAppUsageOption80= "公共保健 ";
var xmsgAppUsageOption81= "其他公共事务 ";
var xmsgAppUsageOption82= "自然资源 ";
var xmsgAppUsageOption83= "石油和天然气 ";
var xmsgAppUsageOption84= "后期制作 ";
var xmsgAppUsageOption85= "工序和电力 ";
var xmsgAppUsageOption86= "住宅 ";
var xmsgAppUsageOption87= "电信 ";
var xmsgAppUsageOption88= "工具和模具 ";
var xmsgAppUsageOption89= "运输 ";
var xmsgAppUsageOption90= "公共设施: 水、电、煤气 ";
var xmsgAppUsageOption91= "Web 和交互 ";
var xmsgAppUsageOption99= "其他 ";

var xmsgWrongCountryCodeMsg= "错误: 未输入已知的国家/地区代码！";

/////////////////////////////////////////////
// Version RESOURCES HERE:
/////////////////////////////////////////////
var xmsgVersion = "版本:";

/////////////////////////////////////////////
// Access RTFax or RTMail through RTEmail
/////////////////////////////////////////////
var xmsgAccessFaxMsg= "通过传真进行注册。";
var xmsgAccessMailMsg= "通过邮寄进行注册。";
var xmsgAccessHereMsg= "此处。";

/////////////////////////////////////////////
// Messages for Ease of reauth or multi-seat client registration
/////////////////////////////////////////////
var xmsgNoDialogHdrMsg= "正在验证您的许可证，<br>请稍候";

/////////////////////////////////////////////
// Resource for NSA_RTBegin.html
/////////////////////////////////////////////
var xmsgNSARTBeginTitle= "获取网络许可证";
var xmsgNSARTBeginMsg1= "使用“网络许可证激活”程序可以快速轻松地获取网络许可证。 ";
var xmsgNSARTBeginMsg2= "过程完成后，就可以拥有新的或修改过的 %1 许可证。然后就可以将其另存为新的许可证文件，或者附加到现有的许可证文件中。<p>";
var xmsgNSARTBeginMsg3= "默认情况下，该程序通过 Internet 来执行。*<p>该程序将引导您执行以下操作步骤:<p>步骤 1 <b>收集信息</b><br>步骤 2 <b>将信息传递给 Autodesk</b><br>步骤 3 <b>从 Autodesk 返回许可证</b><br>步骤 4 <b>将许可证保存到新的或现有的许可证文件中</b><br>步骤 5 <b>确认事务</b> (可以打印详细信息，以作记录)<p>要完成此过程，您需要有:<p><b>许可服务器信息</b> - 序列号、许可服务器模式、服务器主机名、每台服务器的席位数 (对于分布式服务器)<br><b>注册数据</b> - 姓名、地址、电话号码等 (如果以前未注册过)<br><b>以前的产品序列号</b> (仅对于升级)<br><b>可以保存许可证文件的位置</b> (包括写权限)<br>";
var xmsgNSARTBeginNoInternet= "*连接到 Internet 是获取许可证的最快方法。如果不希望现在使用 Internet，请选中此复选框。(您可以使用此应用程序快速完成注册过程，也可以选择其他方法。)";

/////////////////////////////////////////////
// Edit server and seat information
/////////////////////////////////////////////
var xmsgEditServerHdrMsg1= "服务器信息";
var xmsgEditServerHdrMsg2= "许可服务器模式*";
var xmsgEditServerMsg1= "输入许可服务器信息。使用“...”按钮查找服务器主机名。<br>单击“查寻”按钮将自动填写“主机 ID”字段。<p>";
var xmsgEditServerMsg2= "从现有的许可证文件获取服务器主机数据。";
var xmsgEditServerRemove= "删除";
var xmsgEditServerHostName= "服务器主机名*";
var xmsgEditServerHostID= "主机 ID*";
var xmsgEditServerSeat= "席位*";
var xmsgEditServerSingle= "单一服务器";
var xmsgEditServerDistributed= "分布式服务器";
var xmsgEditServerRedundant= "冗余服务器";
var xmsgEditServerDots= "...";
var xmsgEditServerLookup= "查寻";
var xmsgEditServerAddServer= "添加";
var xmsgEditServerRemoveServer= "删除";
var xmsgEditServerTotal= "总共:";
var xmsgEditServerExceedMaxServer= "注意: 一次最多可以授权 20 台分布式服务器。如果您需要授权的服务器超过 20 台，请与 Autodesk 联系。";
var xmsgEditServerSeatError= "“席位”中只能包含数字值。";

var xmsgConfirmServerMsg= "检查以下信息。单击“下一步”继续，或者单击“上一步”进行修改。";
var xmsgConfirmServerMsg2= "单击“下一步”后，这些信息将通过 Internet 发送给 Autodesk。";
var xmsgConfirmServerHdr2= "许可服务器模式:";
var xmsgConfirmServerHostName= "服务器主机名";
var xmsgConfirmServerHostID= "主机 ID";
var xmsgConfirmServerSeat= "席位";
var xmsgConfirmServerTotal= "席位总数:";

var xmsgLicErrorHdr= "授权错误"; 
var xmsgLicErrorInvalidSN= "您输入的序列号无效。请验证上面显示的序列号是否正确，然后单击以下链接之一。";
var xmsgLicReEnterSN= "重新输入序列号并重试。";

var xmsgLic113Msg2= "您为分布式服务器分配的总席位超过了此数目。";
var xmsgLic113ModifySeats= "修改席位分布。";

var xmsgSaveLicenseHdr= "已收到许可证";
var xmsgSaveLicenseMsg1= "您已从 Autodesk 收到许可证。必须现在就将它们保存到许可证文件中。<p> <b>将许可证保存到许可证文件中</b><p><LI><b>建议</b>将许可证文件保存在服务器上 Autodesk 网络许可管理器安装目录的“License”子目录中。";
var xmsgSaveLicenseMsg6= "<LI>如果您已经拥有<b>许可证文件</b>，可将新的许可证<b>插入</b>到其中。<br>单击“下一步”后，系统将自动把许可证信息插入到现有文件中的适当位置。</LI>";
var xmsgSaveLicenseMsg2= "如果上面指定的文件是现有的许可证文件:";
var xmsgSaveLicenseMsg3= "将新的许可证信息插入到其中。";
var xmsgSaveLicenseMsg4= "覆盖现有的许可证文件。";
var xmsgSaveLicenseMsg5= "请更正以下错误:";

var xmsgSaveErrorNoPermission= "错误: 没有足够的权限将文件保存到指定的位置。<br>可以将该文件保存到临时位置，获取适当的权限，然后再移动文件。";
var xmsgSaveErrorNoDiskSpace= "错误: 没有足够的磁盘空间将文件保存到指定的位置。<br>可以将该文件保存到临时位置，准备足够的空间，然后再移动文件。";
var xmsgSaveErrorInvalidFile= "错误: 新的许可证无法在不丢失数据的前提下附加到指定的文件。指定的文件可能是用于不同的计算机或服务器模式的。<BR>可以用不同的文件名保存新的许可证文件，或者将其保存在不同的位置，以后再手动将其附加到该文件。";															
var xmsgSaveErrorPathNotExit= "错误: 指定的路径不存在。<BR>请单击“浏览”按钮查找或创建该路径。";
var xmsgSaveErrorPathBlank= "错误: 必须指定有效的路径和许可证文件名。请在下面的字段中指定路径和文件名，或者单击“浏览”以查找某个路径和文件名。";

var xmsgLicAuthConfirmHdr1= "许可证激活成功！";
var xmsgLicAuthConfirmHdr2= "许可服务器主机信息";
var xmsgLicAuthConfirmMsg1= "感谢您注册产品。您可以打印此信息作为记录。";
var xmsgLicAuthConfirmDate= "日期:";

var xmsgLicPathMsg1= "已保存以下许可证文件:";
var xmsgLicPathMsg2= "您的许可证文件已被保存到 ";

var xmsgOtherMethodMsg1NSA= "通过其他方式获取授权的许可证。";
var xmsgOtherMethodMsg1= "使用其他方法。";

var xmsgContactAutodeskMsg1= "请使用以下方法之一与 Autodesk 联系: ";
								
/////////////////////////////////////////////
// Email Options
/////////////////////////////////////////////
var xmsgEmailOptionNSATitle= "通过电子邮件获取许可证文件";
var xmsgEmailOptionTitle= "通过电子邮件进行注册";
var xmsgEmailOptionNSAMsg= "您的注册和许可服务器信息已自动保存到文件中。该文件必须通过电子邮件发送到 Autodesk 的自动注册处理中心。<p>当该文件成功通过电子邮件发送到 Autodesk 之后，您将收到自动回复、授权的许可证文件以及关于如何完成注册过程的说明。";
var xmsgEmailOptionMsg= "您的注册信息已自动保存到文件中。该文件必须通过电子邮件发送到 Autodesk 的自动注册处理中心。<p>当该文件成功通过电子邮件发送到 Autodesk 之后，您将收到自动回复和关于如何完成注册过程的说明。";
var xmsgEmailOptionMsg2= "如果您使用的默认电子邮件系统目前可以通过 Internet 发送电子邮件，请单击“立即发送文件”，然后单击“下一步”。该文件将会自动发送出去。<p>如果您现在不能发送电子邮件，请单击“以后再手动发送文件”。您将获得关于如何手动发送该文件的说明。";
var xmsgEmailOptionInfo1= "立即发送文件。";
var xmsgEmailOptionInfo2= "以后再手动发送文件。";
var xmsgEmailOptionInfo3= "将电子邮件抄送到我提供的电子邮件地址。";

/////////////////////////////////////////////
// Local HERE customer information URLs
/////////////////////////////////////////////
var xmsgLocalHERETitle= "修改客户信息";
var xmsgLocalHEREInfo= "要修改客户信息，请与 Autodesk 授权代理商联系，或在下面浏览至适用于您所在国家或地区的链接。";
var xmsgLocalHEREUS= "美洲";
var xmsgLocalHEREEMEA= "欧洲、中东、非洲";
var xmsgLocalHEREAPAC= "亚太地区";

/////////////////////////////////////////////
// Help
/////////////////////////////////////////////
var xmsgHelpTitle= "帮助";
var xmsgHelpUpgradeMsg= "如果要注册或激活早期版本的升级版，则必须选中此框。将提示您输入要对其进行升级的那个版本的序列号。";
var xmsgHelpUpgradeRequiredTitle= "输入早期产品的序列号 (升级所需)";
var xmsgHelpUpgradeRequiredMsg= "这是早期版本软件的序列号。您可以在软件的“帮助”>“关于”对话框或早期产品的外包装上找到序列号。";

//	Fax or email error message
var xmsgNotEnterErrorMsg= "尚未输入%1。如果希望按此方式接收激活码，请使用“上一步”按钮返回并输入。";								

/////////////////////////////////////////////
// Email Error
/////////////////////////////////////////////
var xmsgEmailErrorHdr= "无法生成电子邮件";
var xmsgEmailErrorMsg1= "要通过电子邮件完成注册，请将以下文件附着到电子邮件中: ";
var xmsgEmailErrorMsg2= "将电子邮件发送到 %1。";
var xmsgEmailErrorMsg3= "该文件可以在以下位置中找到: ";

/////////////////////////////////////////////
// Error 12
/////////////////////////////////////////////
var xmsgErr12Hdr= "输入的序列号无效";
var xmsgErr12APAC= "<p>这是无效的序列号，无法激活。请通过以下电子邮件地址与我们联系: <a href=mailto:apacpl@listproc.autodesk.com target=\"_blank\">apacpl@listproc.autodesk.com</a></p>";
var xmsgErr12EMEA= "<p>尊敬的先生/女士</p><p>感谢您尝试向 Autodesk 注册 Autodesk(R) 或 Discreet(TM) 软件产品。</p><p>但是，记录表明您尝试注册的 Autodesk(R) 或 Discreet(TM) 软件产品的序列号无效，或该序列号是该软件产品的已知盗版版本的序列号。因此，您正在使用的 Autodesk(R) 或 Discreet(TM) 软件产品未经授权。</p><p>Autodesk(R) 软件产品的使用许可证可从 Autodesk 授权代理商处购买。要获得您所在地区的 Autodesk 授权代理商或 Autodesk 办事处的列表，请访问 <a href=\"http://www.autodesk.com\" target=\"_blank\">www.autodesk.com</a>。使用合法软件是确保您能够从使用软件中获得最大利益，并免于因非法使用和/或复制软件而被提起可能的民事和刑事诉讼的唯一方式。</p><p>Discreet(TM) 软件产品的使用许可证可从 Discreet 授权代理商处购买。要获得您所在地区的 Discreet 授权代理商或 Discreet 办事处的列表，请访问 <a href=\"http://www.discreet.com\" target=\"_blank\">www.discreet.com</a>。使用合法软件是确保您能够从使用软件中获得最大利益，并免于因非法使用和/或复制软件而被提起可能的民事和刑事诉讼的唯一方式。</p><p>因此，我们诚恳地请求您立即停止使用尝试向我们注册的未经授权的软件产品，删除保存在任何计算机硬件上的所有软件产品，并销毁包含软件产品的任何介质。我们相信您会自愿进行这些操作，但 Autodesk 保留与此问题相关的权利，并可能会将您的详细信息传送给商业软件联盟 (BSA)。</p><p>如果您有任何疑问，或确信错误地收到此消息，请通过以下电子邮件地址与我们联系:<a href=mailto:Authcodes.neu@autodesk.com target=\"_blank\">Authcodes.neu@autodesk.com</a></p><p>如果愿意提供有关使用或销售非法软件的信息，请与您所在地区的 Autodesk 办事处联系，或与 BSA 联系，网址为 <a href=\"http://www.BSA.org.cn\" target=\"_blank\">www.BSA.org.cn</a></p><p>谢谢</p>";
var xmsgErr12US= "<p>尊敬的先生/女士</p><p>您最近尝试向 Autodesk 或 Discreet 注册您的软件产品。</p><p>但是，记录表明您尝试注册的 Autodesk(R) 或 Discreet(TM) 软件产品的序列号无效，或该序列号是该软件产品的已知盗版版本的序列号。因此，您正在使用的 Autodesk(R) 或 Discreet(TM) 软件产品未经授权。</p><p>对于 Autodesk 用户，Autodesk(R) 软件产品的使用许可证可从 Autodesk 授权代理商处购买。要获得您所在地区的 Autodesk 授权代理商的列表，请访问 <a href=\"http://www.autodesk.com\" target=\"_blank\">www.autodesk.com</a>。使用合法软件是确保您能够从使用软件中获得最大利益，并免于因非法使用和/或复制软件而被提起可能的民事和刑事诉讼的唯一方式。</p><p>对于 Discreet(TM) 用户，Discreet(TM) 软件产品的使用许可证可从 Discreet 授权代理商处购买。要获得您所在地区的 Discreet 授权代理商或 Discreet 办事处的列表，请访问 <a href=\"http://www.discreet.com\" target=\"_blank\">www.discreet.com</a>。使用合法软件是确保您能够从使用软件中获得最大利益，并免于因非法使用和/或复制软件而被提起可能的民事和刑事诉讼的唯一方式。</p><p>您必须立即停止使用尝试向我们注册的未经授权的软件产品，删除保存在任何计算机硬件上的所有软件产品，并销毁包含软件产品的任何介质。我们相信您会自愿进行这些操作，但 Autodesk 保留与此问题相关的权利，并可能会将您的详细信息传送给商业软件联盟 (BSA)。</p><p>如果您有任何疑问，或确信错误地收到此消息，请通过以下电子邮件地址与我们联系:<a href=mailto:ProductActivation@activation.autodesk.com target=\"_blank\">ProductActivation@activation.autodesk.com</a></p><p>如果愿意提供有关使用或销售非法软件的信息，请与您所在地区的办事处联系，或与 BSA 联系，网址为 <a href=\"http://www.BSA.org.cn\" target=\"_blank\">www.BSA.org.cn</a></p><p>谢谢</p>";





// SIG // Begin signature block
// SIG // MIIWPgYJKoZIhvcNAQcCoIIWLzCCFisCAQExDjAMBggq
// SIG // hkiG9w0CBQUAMGYGCisGAQQBgjcCAQSgWDBWMDIGCisG
// SIG // AQQBgjcCAR4wJAIBAQQQEODJBs441BGiowAQS9NQkAIB
// SIG // AAIBAAIBAAIBAAIBADAgMAwGCCqGSIb3DQIFBQAEEOQG
// SIG // PqJb5ae7lSVAtX8zFrSgghGVMIIDxDCCAy2gAwIBAgIQ
// SIG // R78Zld+NUkZD99ttSA0xpDANBgkqhkiG9w0BAQUFADCB
// SIG // izELMAkGA1UEBhMCWkExFTATBgNVBAgTDFdlc3Rlcm4g
// SIG // Q2FwZTEUMBIGA1UEBxMLRHVyYmFudmlsbGUxDzANBgNV
// SIG // BAoTBlRoYXd0ZTEdMBsGA1UECxMUVGhhd3RlIENlcnRp
// SIG // ZmljYXRpb24xHzAdBgNVBAMTFlRoYXd0ZSBUaW1lc3Rh
// SIG // bXBpbmcgQ0EwHhcNMDMxMjA0MDAwMDAwWhcNMTMxMjAz
// SIG // MjM1OTU5WjBTMQswCQYDVQQGEwJVUzEXMBUGA1UEChMO
// SIG // VmVyaVNpZ24sIEluYy4xKzApBgNVBAMTIlZlcmlTaWdu
// SIG // IFRpbWUgU3RhbXBpbmcgU2VydmljZXMgQ0EwggEiMA0G
// SIG // CSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQCpyrKkzM0g
// SIG // rwp9iayHdfC0TvHfwQ+/Z2G9o2Qc2rv5yjOrhDCJWH6M
// SIG // 22vdNp4Pv9HsePJ3pn5vPL+Trw26aPRslMq9Ui2rSD31
// SIG // ttVdXxsCn/ovax6k96OaphrIAuF/TFLjDmDsQBx+uQ3e
// SIG // P8e034e9X3pqMS4DmYETqEcgzjFzDVctzXg0M5USmRK5
// SIG // 3mgvqubjwoqMKsOLIYdmvYNYV291vzyqJoddyhAVPJ+E
// SIG // 6lTBCm7E/sVK3bkHEZcifNs+J9EeeOyfMcnx5iIZ28Sz
// SIG // R0OaGl+gHpDkXvXufPF9q2IBj/VNC97QIlaolc2uiHau
// SIG // 7roN8+RN2aD7aKCuFDuzh8G7AgMBAAGjgdswgdgwNAYI
// SIG // KwYBBQUHAQEEKDAmMCQGCCsGAQUFBzABhhhodHRwOi8v
// SIG // b2NzcC52ZXJpc2lnbi5jb20wEgYDVR0TAQH/BAgwBgEB
// SIG // /wIBADBBBgNVHR8EOjA4MDagNKAyhjBodHRwOi8vY3Js
// SIG // LnZlcmlzaWduLmNvbS9UaGF3dGVUaW1lc3RhbXBpbmdD
// SIG // QS5jcmwwEwYDVR0lBAwwCgYIKwYBBQUHAwgwDgYDVR0P
// SIG // AQH/BAQDAgEGMCQGA1UdEQQdMBukGTAXMRUwEwYDVQQD
// SIG // EwxUU0EyMDQ4LTEtNTMwDQYJKoZIhvcNAQEFBQADgYEA
// SIG // Smv56ljCRBwxiXmZK5a/gqwB1hxMzbCKWG7fCCmjXsjK
// SIG // kxPnBFIN70cnLwA4sOTJk06a1CJiFfc/NyFPcDGA8Ys4
// SIG // h7Po6JcA/s9Vlk4k0qknTnqut2FB8yrO58nZXt27K4U+
// SIG // tZ212eFX/760xX71zwye8Jf+K9M7UhsbOCf3P0owggP/
// SIG // MIIC56ADAgECAhAN6Svw1NgpiBgyBQlemnaIMA0GCSqG
// SIG // SIb3DQEBBQUAMFMxCzAJBgNVBAYTAlVTMRcwFQYDVQQK
// SIG // Ew5WZXJpU2lnbiwgSW5jLjErMCkGA1UEAxMiVmVyaVNp
// SIG // Z24gVGltZSBTdGFtcGluZyBTZXJ2aWNlcyBDQTAeFw0w
// SIG // MzEyMDQwMDAwMDBaFw0wODEyMDMyMzU5NTlaMFcxCzAJ
// SIG // BgNVBAYTAlVTMRcwFQYDVQQKEw5WZXJpU2lnbiwgSW5j
// SIG // LjEvMC0GA1UEAxMmVmVyaVNpZ24gVGltZSBTdGFtcGlu
// SIG // ZyBTZXJ2aWNlcyBTaWduZXIwggEiMA0GCSqGSIb3DQEB
// SIG // AQUAA4IBDwAwggEKAoIBAQCyUChI3dNoeoQYRGZ1XX7E
// SIG // uJ9jJv89Q5x8ETgQJVVz2XUnaf1OuSBc0wr5oBsq7VVW
// SIG // IWHYHtvkvDNrx+/dozdljhuTDLZTHlx8ZjVfBYpF/nZO
// SIG // 31OAooEgna6IXKII9+Uw+e4iN0xCCs7fxh/E1lXpgT+1
// SIG // UqMsqgF68qKqjTX+n+ZdagWfPWvjv5bA/sxg+UDnB6BE
// SIG // 64FRbqUq8raKECjtj9wGoIZQmntKCA0wHcoQnmv36Viu
// SIG // BKlAmbIo6I8WrDzjU29L0zWdtW9kHbOWLLs953nrbXr5
// SIG // FuYmra/vmVO3QCyVuHmq/tRSqyl0fkLsOR6iahbmWbsk
// SIG // aNgAgEMQh4BrAgMBAAGjgcowgccwNAYIKwYBBQUHAQEE
// SIG // KDAmMCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC52ZXJp
// SIG // c2lnbi5jb20wDAYDVR0TAQH/BAIwADAzBgNVHR8ELDAq
// SIG // MCigJqAkhiJodHRwOi8vY3JsLnZlcmlzaWduLmNvbS90
// SIG // c3MtY2EuY3JsMBYGA1UdJQEB/wQMMAoGCCsGAQUFBwMI
// SIG // MA4GA1UdDwEB/wQEAwIGwDAkBgNVHREEHTAbpBkwFzEV
// SIG // MBMGA1UEAxMMVFNBMjA0OC0xLTU0MA0GCSqGSIb3DQEB
// SIG // BQUAA4IBAQCHeHDaTlIBIFvgecmCMMT9uRmWvZEAw73N
// SIG // zcb0Dtj/+U3AM2IwEcX1dBvUkt5fnCATsXxFvlDNg+eA
// SIG // F4OnJ5NnE0b7yriYQQPMm1FbBYt/qG/zG1AbJC7yaY1s
// SIG // Ive7yhaV7Qx0wGh32euZYofBc5D4iXR6I6ujmHuXsfeP
// SIG // KXFNLnUbSEHa8LUNIFTWd6CXgmNp/QnPivB1uwmb2fkR
// SIG // VSaaYTK+egKwe4a+osOLIix40TV2vJJzXPm55kwVCiPM
// SIG // 5NLUNC5JQBU8D2B6JMalZu+Wz3DrPuf0DX7c0XyjdnFp
// SIG // wZxPRzA1IbGirxpiPCvZjqoqB3vYGLNce+KdpW/+PImt
// SIG // MIIEvzCCBCigAwIBAgIQV2RuK1UAI9SQU0pVPqsNCjAN
// SIG // BgkqhkiG9w0BAQUFADBfMQswCQYDVQQGEwJVUzEXMBUG
// SIG // A1UEChMOVmVyaVNpZ24sIEluYy4xNzA1BgNVBAsTLkNs
// SIG // YXNzIDMgUHVibGljIFByaW1hcnkgQ2VydGlmaWNhdGlv
// SIG // biBBdXRob3JpdHkwHhcNMDQwNzE2MDAwMDAwWhcNMDkw
// SIG // NzE1MjM1OTU5WjCBtDELMAkGA1UEBhMCVVMxFzAVBgNV
// SIG // BAoTDlZlcmlTaWduLCBJbmMuMR8wHQYDVQQLExZWZXJp
// SIG // U2lnbiBUcnVzdCBOZXR3b3JrMTswOQYDVQQLEzJUZXJt
// SIG // cyBvZiB1c2UgYXQgaHR0cHM6Ly93d3cudmVyaXNpZ24u
// SIG // Y29tL3JwYSAoYykwNDEuMCwGA1UEAxMlVmVyaVNpZ24g
// SIG // Q2xhc3MgMyBDb2RlIFNpZ25pbmcgMjAwNCBDQTCCASIw
// SIG // DQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAL687rx+
// SIG // 74Pr4DdP+wMQOL4I0ox9nfqSfxkMwmvuQlKM3tMcSBMl
// SIG // 6sFjevlRZe7Tqjv18JScK/vyZtQk2vf1n24ZOTa80KN2
// SIG // CB4iJyRsOJEn4oRJrhuKof0lgiwQMOhxqyjod0pR8ezN
// SIG // +PBU1G/A420Kj9nYZI1jsi1OJ/aFDv5t4ymZ4oVHfC2G
// SIG // f+hXj61nwjMykRMg/KkjFJptwoRLdmgE1XEsXSH6iA0m
// SIG // /R8tkSvnAVVN8m01KILf2WtcttbZqoH9X82DumOd0CL8
// SIG // qTtCabKOOrW8tJ4PXsTqLIKLKP1TCJbdtQEg0fmlGOfA
// SIG // 7lFwN+G2BUhSSG846sPobHtEhLsCAwEAAaOCAaAwggGc
// SIG // MBIGA1UdEwEB/wQIMAYBAf8CAQAwRAYDVR0gBD0wOzA5
// SIG // BgtghkgBhvhFAQcXAzAqMCgGCCsGAQUFBwIBFhxodHRw
// SIG // czovL3d3dy52ZXJpc2lnbi5jb20vcnBhMDEGA1UdHwQq
// SIG // MCgwJqAkoCKGIGh0dHA6Ly9jcmwudmVyaXNpZ24uY29t
// SIG // L3BjYTMuY3JsMB0GA1UdJQQWMBQGCCsGAQUFBwMCBggr
// SIG // BgEFBQcDAzAOBgNVHQ8BAf8EBAMCAQYwEQYJYIZIAYb4
// SIG // QgEBBAQDAgABMCkGA1UdEQQiMCCkHjAcMRowGAYDVQQD
// SIG // ExFDbGFzczNDQTIwNDgtMS00MzAdBgNVHQ4EFgQUCPVR
// SIG // 6Pv+PT1kNnxoz1t4qN+5xTcwgYAGA1UdIwR5MHehY6Rh
// SIG // MF8xCzAJBgNVBAYTAlVTMRcwFQYDVQQKEw5WZXJpU2ln
// SIG // biwgSW5jLjE3MDUGA1UECxMuQ2xhc3MgMyBQdWJsaWMg
// SIG // UHJpbWFyeSBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eYIQ
// SIG // cLrkHRDZKTS2OMp7A8y6vzANBgkqhkiG9w0BAQUFAAOB
// SIG // gQCaZfXY1+Gk0F3e2H17w+7ECMJW0Izc7awijedQBg0H
// SIG // LKCkaZXMmd/MYzHPsMHklss4ziH7fOdYCiMhByyQl6vY
// SIG // lgSTVFO6OhBIcg2F7BsKQSXMfWysewPx93g88qhA0FVy
// SIG // 274LKLXIxwX+0+C1Idy8QLe+vGD1uOPYXjtl3WZWXzCC
// SIG // BQMwggProAMCAQICEH6lcJdnfQ6uDNAJLwq7UOIwDQYJ
// SIG // KoZIhvcNAQEFBQAwgbQxCzAJBgNVBAYTAlVTMRcwFQYD
// SIG // VQQKEw5WZXJpU2lnbiwgSW5jLjEfMB0GA1UECxMWVmVy
// SIG // aVNpZ24gVHJ1c3QgTmV0d29yazE7MDkGA1UECxMyVGVy
// SIG // bXMgb2YgdXNlIGF0IGh0dHBzOi8vd3d3LnZlcmlzaWdu
// SIG // LmNvbS9ycGEgKGMpMDQxLjAsBgNVBAMTJVZlcmlTaWdu
// SIG // IENsYXNzIDMgQ29kZSBTaWduaW5nIDIwMDQgQ0EwHhcN
// SIG // MDQxMjIwMDAwMDAwWhcNMDYwMzEzMjM1OTU5WjCBxTEL
// SIG // MAkGA1UEBhMCU0cxEjAQBgNVBAgTCVNpbmdhcG9yZTES
// SIG // MBAGA1UEBxMJU2luZ2Fwb3JlMR8wHQYDVQQKFBZBdXRv
// SIG // ZGVzayBBc2lhIFBURSBMdGQuMT4wPAYDVQQLEzVEaWdp
// SIG // dGFsIElEIENsYXNzIDMgLSBNaWNyb3NvZnQgU29mdHdh
// SIG // cmUgVmFsaWRhdGlvbiB2MjEMMAoGA1UECxQDV1dMMR8w
// SIG // HQYDVQQDFBZBdXRvZGVzayBBc2lhIFBURSBMdGQuMIGf
// SIG // MA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDjo3/MkALY
// SIG // tBC08ZfNfLsJLtoKWLD4awlmGxCQdog9dUZRXhbr83iu
// SIG // BWOuCvFntzJ+AIFsOMv+hYaj5Cz9vMqcK9VFS8Sjk7ir
// SIG // Md7t6x8qsf5C2agt8nICtYUCcJUFszajiQPuJNNEz3ZO
// SIG // N1o/9uU9ktwNhBAMr6DJifU3qr1LawIDAQABo4IBgDCC
// SIG // AXwwCQYDVR0TBAIwADAOBgNVHQ8BAf8EBAMCB4AwQAYD
// SIG // VR0fBDkwNzA1oDOgMYYvaHR0cDovL0NTQzMtMjAwNC1j
// SIG // cmwudmVyaXNpZ24uY29tL0NTQzMtMjAwNC5jcmwwRAYD
// SIG // VR0gBD0wOzA5BgtghkgBhvhFAQcXAzAqMCgGCCsGAQUF
// SIG // BwIBFhxodHRwczovL3d3dy52ZXJpc2lnbi5jb20vcnBh
// SIG // MBMGA1UdJQQMMAoGCCsGAQUFBwMDMHYGCCsGAQUFBwEB
// SIG // BGowaDAlBggrBgEFBQcwAYYZaHR0cHM6Ly9vY3NwLnZl
// SIG // cmlzaWduLmNvbTA/BggrBgEFBQcwAoYzaHR0cDovL0NT
// SIG // QzMtMjAwNC1haWEudmVyaXNpZ24uY29tL0NTQzMtMjAw
// SIG // NC1haWEuY2VyMB8GA1UdIwQYMBaAFAj1Uej7/j09ZDZ8
// SIG // aM9beKjfucU3MBEGCWCGSAGG+EIBAQQEAwIEEDAWBgor
// SIG // BgEEAYI3AgEbBAgwBgEBAAEB/zANBgkqhkiG9w0BAQUF
// SIG // AAOCAQEAE/qwRWJmcZDf07AZ6nxdvwYHkb2oZ0Vamxg6
// SIG // raOBkQUt12vcDtN8COGXfORepbLWJsi2xwVicDgEZiiO
// SIG // 23LoFVB9dhbuktjSE84M0GCMOBrOz6DUR/LRBI13onyw
// SIG // wNBJQAVsEBU9Y8ujf0oPCM5PAgIsHc4kqAYtDQICZcYw
// SIG // RUFh9ShnNamhu4BZpdmWSFctg/4aCNdixXYJtOi0eFwh
// SIG // 0TmGwcwvdCYQQ7vWzuBdouFa8GEY3+ldW3lsd8QG555f
// SIG // QHuzY6d5W/O+gjDH4X0BazZ61qM4yh1KqMJL+OFJJSIc
// SIG // qIrvidXqNC/IFNpshycdmfhZljc8fHnqRvkYMdxmATGC
// SIG // BBMwggQPAgEBMIHJMIG0MQswCQYDVQQGEwJVUzEXMBUG
// SIG // A1UEChMOVmVyaVNpZ24sIEluYy4xHzAdBgNVBAsTFlZl
// SIG // cmlTaWduIFRydXN0IE5ldHdvcmsxOzA5BgNVBAsTMlRl
// SIG // cm1zIG9mIHVzZSBhdCBodHRwczovL3d3dy52ZXJpc2ln
// SIG // bi5jb20vcnBhIChjKTA0MS4wLAYDVQQDEyVWZXJpU2ln
// SIG // biBDbGFzcyAzIENvZGUgU2lnbmluZyAyMDA0IENBAhB+
// SIG // pXCXZ30OrgzQCS8Ku1DiMAwGCCqGSIb3DQIFBQCggZow
// SIG // GQYJKoZIhvcNAQkDMQwGCisGAQQBgjcCAQQwHAYKKwYB
// SIG // BAGCNwIBCzEOMAwGCisGAQQBgjcCARUwHwYJKoZIhvcN
// SIG // AQkEMRIEED0s7gdgzf5Ad6u/kVpj5QIwPgYKKwYBBAGC
// SIG // NwIBDDEwMC6gEIAOAEcAZQBuAGUAcgBhAGyhGoAYaHR0
// SIG // cDovL3d3dy5hdXRvZGVzay5jb20gMA0GCSqGSIb3DQEB
// SIG // AQUABIGACGt+ofhoIFqUClA76VAD814w5Fq5BM4G3WmL
// SIG // ySIXaZILCWKNb4PPZupfaP2LD7w9V/fqi8DxOIhJ2S3Z
// SIG // v7rlKqH5geARVvSQGRcMFNxuOKyf1S1f4AGI7+JNK/k9
// SIG // Qo55hmIGQ7qyrsTfmn6iJXi3vLS3pdbRbBsRzWYZk/gS
// SIG // sk6hggH/MIIB+wYJKoZIhvcNAQkGMYIB7DCCAegCAQEw
// SIG // ZzBTMQswCQYDVQQGEwJVUzEXMBUGA1UEChMOVmVyaVNp
// SIG // Z24sIEluYy4xKzApBgNVBAMTIlZlcmlTaWduIFRpbWUg
// SIG // U3RhbXBpbmcgU2VydmljZXMgQ0ECEA3pK/DU2CmIGDIF
// SIG // CV6adogwDAYIKoZIhvcNAgUFAKBZMBgGCSqGSIb3DQEJ
// SIG // AzELBgkqhkiG9w0BBwEwHAYJKoZIhvcNAQkFMQ8XDTA1
// SIG // MDMwODAwMTIwNVowHwYJKoZIhvcNAQkEMRIEEKzGra5Q
// SIG // zYUF4xx8tlq09qgwDQYJKoZIhvcNAQEBBQAEggEATXw3
// SIG // FKB44TjYRAsFajlCJnsILfmbWa3Y1yDEuVtUGCqs9j9s
// SIG // EhQNW/tcnGul0gPsq+5XIIUohqQla4PshgrE2hEELTrw
// SIG // EoEMr/2D6vMslhXHz0vp7w5rHm6taUxKsZh6Y5jRYdCM
// SIG // HFNmlrmD6DNoq59Ke2V5ie4dj4NoHzBvdwSDMmvKcsL7
// SIG // PW85Qsx7sJmoCGN3/2YoLIhShcKhj0+4O/P85v6W9Ojn
// SIG // CXeYq+ttylkfAUQqWr+eRVAujQJBkg7hpJnFYDPLcXjp
// SIG // S0fsWuJ/Se5RamgzLTP0RwvNKQ5gyb27cmXi2fM2Q0Rs
// SIG // 24paA0dCBYxXfwUwp/fSH3y5Rk/2gQ==
// SIG // End signature block
