/*
********************************************************************************
Macro Scripts for Trackview
Author:   Adam Felt

Revision History:
		11 dec 2003, Pierre-Felix Breton, 
		added product switcher: this macroscript file can be shared with all Discreet products
		consolidated the macro_collapsecontroller.mcr with the macro_trackview.mcr



Modify at your own risk
-- ********************************************************************************
*/

-- Animation Editor Launch Macors
-- ********************************************
macroScript LaunchFCurveEditor
	enabledIn:#("max", "viz") --pfb: 2003.12.11 added product switch
	category:"Track View"
    internalcategory:"Track View" 
	toolTip:"߱༭()"
	buttonText:"߱༭..."
	Icon:#("TrackViewTools",23)
(
	on execute do
	(
-- Open the track view
		if  (trackviews.open "켣ͼ - ߱༭" layoutName:"߲") == true then 
		(
			-- Set up the parameters for a fcurve editor
			if trackviews.current != undefined do
			(
				trackviews.current.setname "켣ͼ - ߱༭"
				trackviews.current.modifySubTree = false
			)
		)
		else (
			messageBox "޷򿪹켣ͼڡ\nܴﵽı༭Ŀ\nԹرղɾй켣ͼ" title:"켣ͼ"
		)
	)
)--end macro

-------------------------------------------------------------------------------------------------------------
--***********************************************************************************************************
macroScript SwitchToFCurveEditor
	enabledIn:#("max", "viz") --pfb: 2003.12.11 added product switch
	category:"Track View"
    internalcategory:"Track View" 
	toolTip:"߱༭(л)"
	buttonText:"߱༭"
	--Icon:#("TrackViewTools",23)
(
	on execute do
	(
		if trackviews.current != undefined do
		(
			trackviews.current.setname "켣ͼ - ߱༭"
			trackviews.current.modifySubTree = false
			trackviews.current.ui.loadLayout "߲"
		)
	)
)--end macro

-------------------------------------------------------------------------------------------------------------
--***********************************************************************************************************
macroScript LaunchDopeSheetEditor
	enabledIn:#("max", "viz") --pfb: 2003.12.11 added product switch
	category:"Track View"
    internalcategory:"Track View" 
	toolTip:"Ӱ()"
	buttonText:"Ӱ..."
	Icon:#("TrackViewTools",15)
(
	on execute do
	(
		-- Open the track view
		if (trackviews.open "켣ͼ - Ӱ" layoutName:"Ӱ") == true then
		(
			-- Set up the parameters for a fcurve editor
			if trackviews.current != undefined do
			(
				trackviews.current.setname "켣ͼ - Ӱ"
				trackviews.current.modifySubTree = true
			)
		)
		else (
			messageBox "޷򿪹켣ͼڡ\nܴﵽı༭Ŀ\nԹرղɾй켣ͼ" title:"켣ͼ"
		)
	)
)--end macro

-------------------------------------------------------------------------------------------------------------
--***********************************************************************************************************
macroScript SwitchDopeSheetEditor
	enabledIn:#("max", "viz") --pfb: 2003.12.11 added product switch
	category:"Track View"
    internalcategory:"Track View" 
	toolTip:"Ӱ(л)"
	buttonText:"Ӱ"
	--Icon:#("TrackViewTools",15)
(
	on execute do
	(
		if trackviews.current != undefined do
		(
			trackviews.current.setname "켣ͼ - Ӱ"
			trackviews.current.modifySubTree = true
			trackviews.current.ui.loadLayout "Ӱ"
		)
	)
)--end macro

-------------------------------------------------------------------------------------------------------------
--***********************************************************************************************************
macroScript LaunchRangeEditor
	enabledIn:#("max", "viz") --pfb: 2003.12.11 added product switch
	category:"Track View"
    internalcategory:"Track View" 
	toolTip:"Χ༭()"
	buttonText:"Χ༭..."
	Icon:#("TrackViewTools",21)
(
	on execute do
	(
		
-- Pop up the warning with no titlebar
		createdialog ConstWarning style:#(#style_border)

-- Open the track view
		CR_Edit= trackviews.open "켣ͼ - ༭" layoutName:"Χ"
	
-- Set up the parameters for a controller editor	
		if trackviews.current != undefined do
		(
			trackviews.current.setname "켣ͼ - ༭"
			trackviews.current.modifySubTree = false
			trackviews.current.editmode = #positionranges
		)
	)
)--end macro

-------------------------------------------------------------------------------------------------------------
--***********************************************************************************************************
macroScript SwitchRangeEditor
	enabledIn:#("max", "viz") --pfb: 2003.12.11 added product switch
	category:"Track View"
    internalcategory:"Track View" 
	toolTip:"Χ(л)"
	buttonText:"Χ..."
	--Icon:#("TrackViewTools",21)
(
	on execute do
	(
		if trackviews.current != undefined do
		(
			trackviews.current.ui.showKeyableIcons = true
			trackviews.current.setname "켣ͼ - Χ"
			trackviews.current.modifySubTree = false
			trackviews.current.editmode = #positionranges
			trackviews.current.ui.loadLayout "Χ"
		)
	)
)--end macro

-------------------------------------------------------------------------------------------------------------
--***********************************************************************************************************
-- Curve Editor Macros
-- ********************************************
macroScript ShowNonselectedCurves
	enabledIn:#("max", "viz") --pfb: 2003.12.11 added product switch
	category:"Track View"
    internalcategory:"Track View" 
	toolTip:"ʾδѡ"
	buttonText:"ʾδѡ"
	Icon:#("TrackViewTools",62)
(
	on execute do
	(
		if trackviews.current != undefined do
		(
			trackviews.current.showNonSelCurves = true
			trackviews.current.freezeNonSelCurves = false
		)
	)
	On isChecked do
 	(
		if trackviews.current != undefined 
		then trackviews.current.showNonSelCurves
		else false
	)
)--end macro

-------------------------------------------------------------------------------------------------------------
--***********************************************************************************************************

macroScript HideNonselectedCurves
	enabledIn:#("max", "viz") --pfb: 2003.12.11 added product switch
	category:"Track View"
    internalcategory:"Track View" 
	toolTip:"δѡ"
	buttonText:"δѡ"
	Icon:#("TrackViewTools",64)
(
	on execute do
	(
		trackviews.current.showNonSelCurves = false
	)
	on isChecked do
 	(
		if trackviews.current != undefined 
		then not trackviews.current.showNonSelCurves
		else false
	)
)--end macro

-------------------------------------------------------------------------------------------------------------
--***********************************************************************************************************

macroScript FreezeNonselectedCurves
	enabledIn:#("max", "viz") --pfb: 2003.12.11 added product switch
	category:"Track View"
    internalcategory:"Track View" 
	toolTip:"δѡ"
	buttonText:"δѡ"
	Icon:#("TrackViewTools",63)
(
	on execute do
	(
		if (trackviews.currenttrackview.freezeNonSelCurves) == true 
		then trackviews.currenttrackview.freezeNonSelCurves = false
		else trackviews.currenttrackview.freezeNonSelCurves = true
	)
	on isChecked do
 	(
		if trackviews.current != undefined 
		then trackviews.current.freezeNonSelCurves
		else false
	)
	on isEnabled do
 	(
		if trackviews.current != undefined 
		then trackviews.current.showNonSelCurves
		else false
	)
)--end macro

-------------------------------------------------------------------------------------------------------------
--***********************************************************************************************************

macroScript ShowAllTangents
	enabledIn:#("max", "viz") --pfb: 2003.12.11 added product switch
	category:"Track View"
    internalcategory:"Track View" 
	toolTip:"ʾȫ"
	buttonText:"ʾȫ"
	Icon:#("TrackViewTools",80)
(
	on ischecked do
	(
		if trackviews.current != undefined 
		then ((trackviews.current.showTangents as string) == "all")
		else false
	)
	on execute do
	(
		if trackviews.current != undefined do
		(	
			if (trackviews.currenttrackview.showTangents as string) == "selected" or (trackviews.currenttrackview.showTangents as string) == "none" 
			then trackviews.currenttrackview.showTangents = #all
			else trackviews.currenttrackview.showTangents = #selected
		)
	)
)--end macro

-------------------------------------------------------------------------------------------------------------
--***********************************************************************************************************

macroScript ShowSelectedTangents
	enabledIn:#("max", "viz") --pfb: 2003.12.11 added product switch
	category:"Track View"
    internalcategory:"Track View" 
	toolTip:"ʾѡ"
	buttonText:"ѡ"
	Icon:#("TrackViewTools",77)
(
	on ischecked do
	(
		if trackviews.current != undefined 
		then ((trackviews.current.showTangents as string) == "selected")
		else false
	)
	on execute do
	(
		if trackviews.current != undefined do
		(	
			trackviews.current.showTangents = #selected
		)
	)
)--end macro

-------------------------------------------------------------------------------------------------------------
--***********************************************************************************************************

macroScript HideTangents
	enabledIn:#("max", "viz") --pfb: 2003.12.11 added product switch
	category:"Track View"
    internalcategory:"Track View" 
	toolTip:""
	buttonText:""
	Icon:#("TrackViewTools",78)
(
	on ischecked do
	(
		if trackviews.current != undefined 
		then ((trackviews.current.showTangents as string) == "none")
		else false
	)
	on execute do
	(
		if trackviews.current != undefined do
		(	
			trackviews.current.showTangents = #all
		)
	)
)--end macro

-------------------------------------------------------------------------------------------------------------
--***********************************************************************************************************

macroScript ShowFrozenKeys
	enabledIn:#("max", "viz") --pfb: 2003.12.11 added product switch
	category:"Track View"
    internalcategory:"Track View" 
	toolTip:"ʾؼ"
	buttonText:"ʾؼ"
	--Icon:#("TrackViewTools",63) NO ICON YET
(
	on execute do
	(
		if trackviews.current != undefined do
		(	
			trackviews.current.showFrozenKeys = not trackviews.current.showFrozenKeys
		)
	)
	on ischecked do
	(
		if trackviews.current != undefined 
		then trackviews.current.showFrozenKeys
		else false
	)
)--end macro

-------------------------------------------------------------------------------------------------------------
--***********************************************************************************************************

macroScript InteractiveUpdate
	enabledIn:#("max", "viz") --pfb: 2003.12.11 added product switch
	category:"Track View"
    internalcategory:"Track View" 
	toolTip:"ʽ"
	buttonText:"ʽ"
	--Icon:#("TrackViewTools",63) NO ICON YET
(
	on execute do
	(
		if trackviews.current != undefined do
		(	
			trackviews.currenttrackview.interactiveupdate = not trackviews.currenttrackview.interactiveupdate
			-- sync time and interactive update are mutually exclusive
			-- if you are turning on interactive update turn off sync time
			if trackviews.currenttrackview.interactiveupdate do
				trackviews.currenttrackview.syncTime = false
		)
	)
	on ischecked do
	(
		if trackviews.current != undefined 
		then trackviews.currenttrackview.interactiveupdate
		else false
	)
)--end macro

-------------------------------------------------------------------------------------------------------------
--***********************************************************************************************************

macroScript SyncTime
	enabledIn:#("max", "viz") --pfb: 2003.12.11 added product switch
	category:"Track View"
    internalcategory:"Track View" 
	toolTip:"ͬʱ"
	buttonText:"ͬʱ"
	--Icon:#("TrackViewTools",63) NO ICON YET
(
	on execute do
	(
		if trackviews.current != undefined do
		(	
			trackviews.currenttrackview.syncTime = not trackviews.currenttrackview.syncTime
			-- sync time and interactive update are mutually exclusive
			-- if you are turning on sync time turn off interactive update
			if trackviews.currenttrackview.syncTime do
				trackviews.currenttrackview.interactiveupdate = false
		)
	)
	on ischecked do
	(
		if trackviews.current != undefined 
		then trackviews.currenttrackview.syncTime
		else false
	)
)--end macro

-------------------------------------------------------------------------------------------------------------
--***********************************************************************************************************

-- UI Layout macros
-- ********************************************

macroScript TV_Load_Layout
			enabledIn:#("max", "viz") --pfb: 2003.12.11 added product switch
            category:"Track View" 
            internalcategory:"Track View" 
            tooltip:"ز" 
            buttontext:"ز..." 
            -- Icon:#("TrackViewTools",0)
(
	rollout Layouts "ز" width:150 height:117
	(
		local tv
		
		dropdownList layoutList "" pos:[9,11] width:132 height:40
		button LoadLayout "" pos:[37,77] width:72 height:24
		
		on Layouts open do
		(
			tv = trackviews.current.ui
			local ct = tv.LayoutCount()
			local items = #()			
			for i = 1 to ct do
			(
				append items (tv.getLayoutName i)
			)
			layoutList.items = items
		)
		on LoadLayout pressed do
		(
			tv.loadLayout layoutList.selected
		)
	)
	on execute do 
	(
		if trackviews.current != undefined do
		(
			createDialog Layouts parent:trackviews.current.ui.hwnd pos:[100,100]
		)
	)
	on isChecked return false
)--end macro

-------------------------------------------------------------------------------------------------------------
--***********************************************************************************************************

macroScript TV_Save_Layout
	enabledIn:#("max", "viz") --pfb: 2003.12.11 added product switch
            category:"Track View" 
            internalcategory:"Track View" 
            tooltip:"沼" 
            buttontext:"沼..." 
            -- Icon:#("TrackViewTools",0)
(
   
	rollout SaveLayouts "沼" width:162 height:108
	(
		editText LayoutName "" pos:[6,32] width:146 height:24
		label lbl1 "" pos:[11,11] width:141 height:18
		button SaveLayout "" pos:[41,68] width:75 height:27
		
		on SaveLayout pressed do
		(
			if LayoutName.text != "" then
			(
				trackviews.currenttrackview.ui.saveLayout (LayoutName.text)
			) else (
				MessageBox "Ϊṩ" title:"޲"
			)
		)
	)
   on execute do 
   (
   		if trackviews.currenttrackview != undefined do
		(
			createDialog SaveLayouts parent:trackviews.currenttrackview.ui.hwnd pos:[100,100]
		)
   )
   on isChecked return false
)--end macro

-------------------------------------------------------------------------------------------------------------
--***********************************************************************************************************

macroScript TV_Load_Menu_Bar
	enabledIn:#("max", "viz") --pfb: 2003.12.11 added product switch
            category:"Track View" 
            internalcategory:"Track View" 
            tooltip:"ز˵" 
            buttontext:"ز˵..." 
            -- Icon:#("TrackViewTools",0)
(
	rollout LoadMenuBar "²˵" width:248 height:108
	(
		button LoadMenu "" pos:[79,68] width:72 height:24
		dropDownList menuList "˵" pos:[12,17] width:222 height:40
		on LoadMenuBar open do
		(
			tv = trackviews.currenttrackview.ui
			local ct = menuMan.numMenus()
			local items = #()			
			for i = 1 to ct do
			(
				if (menuMan.getMenu i).GetTitle() != "" do
				(
					append items ((menuMan.getMenu i).GetTitle())
				)
			)
			menuList.items = items
		)
		on LoadMenu pressed do
		(
			trackviews.currenttrackview.ui.menuBar = menuList.selected
		)
	)   
	on execute do 
	(
		if trackviews.currenttrackview != undefined do
		(
			createDialog LoadMenuBar parent:trackviews.currenttrackview.ui.hwnd pos:[100,100]
		)
	)
   on isChecked return false
)--end macro

-------------------------------------------------------------------------------------------------------------
--***********************************************************************************************************

macroScript TV_Load_Controller_Quad_Menu
	enabledIn:#("max", "viz") --pfb: 2003.12.11 added product switch
            category:"Track View" 
            internalcategory:"Track View" 


            tooltip:"ؿԪ˵" 
            buttontext:"ؿԪ˵..." 
            -- Icon:#("TrackViewTools",0)
(
	rollout LoadQuadMenu "¿Ԫ˵" width:248 height:108
	(
		button LoadMenu "" pos:[79,68] width:72 height:24
		dropDownList menuList "˵" pos:[12,17] width:222 height:40
		on LoadQuadMenu open do
		(
			local ct = menuMan.numMenus()
			local items = #()			
			for i = 1 to ct do
			(
				if (menuMan.getMenu i).GetTitle() != "" do
				(
					append items ((menuMan.getMenu i).GetTitle())
				)
			)
			menuList.items = items
		)
		on LoadMenu pressed do
		(
			trackviews.current.ui.controllerQuadMenu = menuList.selected
		)
	)   
	on execute do 
	(
		if trackviews.current != undefined do
		(
			createDialog LoadQuadMenu parent:trackviews.current.ui.hwnd pos:[100,100]
		)
	)
   on isChecked return false
)--end macro

-------------------------------------------------------------------------------------------------------------
--***********************************************************************************************************

macroScript TV_Load_Key_Quad_Menu
	enabledIn:#("max", "viz") --pfb: 2003.12.11 added product switch
            category:"Track View" 
            internalcategory:"Track View" 
            tooltip:"عؼԪ˵" 
            buttontext:"عؼԪ˵..." 
            -- Icon:#("TrackViewTools",0)
(
	rollout LoadQuadMenu "¹ؼԪ˵" width:248 height:108
	(
		button LoadMenu "" pos:[79,68] width:72 height:24
		dropDownList menuList "˵" pos:[12,17] width:222 height:40
		on LoadQuadMenu open do
		(
			local ct = menuMan.numMenus()
			local items = #()			
			for i = 1 to ct do
			(
				if (menuMan.getMenu i).GetTitle() != "" do
				(
					append items ((menuMan.getMenu i).GetTitle())
				)
			)
			menuList.items = items
		)
		on LoadMenu pressed do
		(
			trackviews.current.ui.keyQuadMenu = menuList.selected
		)
	)   
	on execute do 
	(
		if trackviews.current != undefined do
		(
			createDialog LoadQuadMenu parent:trackviews.current.ui.hwnd pos:[100,100]
		)
	)
   on isChecked return false
)--end macro

-------------------------------------------------------------------------------------------------------------
--***********************************************************************************************************

macroScript TV_Add_Toolbar
	enabledIn:#("max", "viz") --pfb: 2003.12.11 added product switch
            category:"Track View" 
            internalcategory:"Track View" 
            tooltip:"ӹ" 
            buttontext:"ӹ..." 
            -- Icon:#("TrackViewTools",0)
(
	rollout AddToolbar "ӹ" width:162 height:108
	(
		editText ToolbarName "" pos:[6,32] width:146 height:24
		label lbl1 "" pos:[11,11] width:141 height:18
		button Add "" pos:[41,68] width:75 height:27
		
		on Add pressed do
		(
			if ToolbarName.text != "" then
			(
				trackviews.currenttrackview.ui.addToolbar (ToolbarName.text)
			) else (
				MessageBox "Ϊṩ" title:"޲"
			)
		)
	)
   on execute do 
   (
   		if trackviews.currenttrackview != undefined do
		(
			createDialog AddToolbar parent:trackviews.currenttrackview.ui.hwnd pos:[100,100]
		)
   )
   on isChecked return false
)--end macro

-------------------------------------------------------------------------------------------------------------
--***********************************************************************************************************

macroScript TV_Delete_Toolbar
	enabledIn:#("max", "viz") --pfb: 2003.12.11 added product switch
            category:"Track View" 
            internalcategory:"Track View" 
            tooltip:"ɾ" 
            buttontext:"ɾ..." 
            -- Icon:#("TrackViewTools",0)
(
	rollout DeleteToolbar "ɾ" width:248 height:108
	(
		button Delete "ɾ" pos:[79,68] width:72 height:24
		dropDownList toolbarList "" pos:[12,17] width:222 height:40
		on DeleteToolbar open do
		(
			tv = trackviews.currenttrackview.ui
			local ct = tv.toolbarCount()
			local items = #()			
			for i = 1 to ct do
			(
				append items (tv.getToolbarName i)
			)
			toolbarList.items = items
		)
		on Delete pressed do
		(
			if QueryBox "⽫ɾ\nǷҪ?" beep:false do
			(
				trackviews.currenttrackview.ui.DeleteToolbar toolbarList.selected
			)
		)
	)   
	on execute do 
	(
		if trackviews.current != undefined do
		(
			createDialog DeleteToolbar parent:trackviews.current.ui.hwnd pos:[100,100]
		)
	)
   on isChecked return false
)--end macro

-------------------------------------------------------------------------------------------------------------
--***********************************************************************************************************

/*
-- Provided as an example of how to toggle the display of a specific toolbar
macroScript TV_Show_Hide_Name_Toolbar
            category:"Track View" 
            internalcategory:"Track View" 
            tooltip:"ʾ/ƹ" 
            buttontext:"" 
            -- Icon:#("TrackViewTools",0)
(
   on execute do 
   (
	   	if trackviews.currenttrackview != undefined do
		(
			if trackviews.currenttrackview.ui.isToolbarVisible ": ༭" then
				( trackviews.currenttrackview.ui.hideToolbar ": ༭" )
			else ( trackviews.currenttrackview.ui.showToolbar ": ༭" )
		)
   )
   on isChecked do
   (
	   	if trackviews.current != undefined then
		then (trackviews.currenttrackview.ui.isToolbarVisible "name") 
		else false
	)
)
*/


 macroScript TV_Show_All_Toolbars
 	enabledIn:#("max", "viz") --pfb: 2003.12.11 added product switch
            category:"Track View" 
            internalcategory:"Track View" 
            tooltip:"ʾȫ" 
            buttontext:"ȫ" 
            -- Icon:#("TrackViewTools",0)
(
   on execute do 
   (
	   	if trackviews.currenttrackview != undefined do
		(
			trackviews.currenttrackview.ui.showAllToolbars()
		)
   )
   on isChecked return false
)--end macro

-------------------------------------------------------------------------------------------------------------
--***********************************************************************************************************

macroScript TV_Hide_All_Toolbars
	enabledIn:#("max", "viz") --pfb: 2003.12.11 added product switch
            category:"Track View" 
            internalcategory:"Track View" 
            tooltip:"ȫ" 
            buttontext:"" 
            -- Icon:#("TrackViewTools",0)
(
   on execute do
   (
	   	if trackviews.currenttrackview != undefined do
		(
			trackviews.currenttrackview.ui.hideAllToolbars()
		)
   )
   on isChecked return false
)--end macro

-------------------------------------------------------------------------------------------------------------
--***********************************************************************************************************

macroScript TV_Show_Hide_Menu_Bar
	enabledIn:#("max", "viz") --pfb: 2003.12.11 added product switch
            category:"Track View" 
            internalcategory:"Track View" 
            tooltip:"ʾ/ز˵" 
            buttontext:"˵" 
            -- Icon:#("TrackViewTools",0)
(
   on execute do
   (
	   	if trackviews.currenttrackview != undefined do
		(
			trackviews.currenttrackview.ui.showMenuBar = not trackviews.currenttrackview.ui.showMenuBar
		)
   )
   on isChecked do 
   (
 	   	if trackviews.current != undefined 
		then (trackviews.currenttrackview.ui.showMenuBar)
		else false
	)
)--end macro

-------------------------------------------------------------------------------------------------------------
--***********************************************************************************************************

macroScript TV_Show_Hide_Scroll_Bars
	enabledIn:#("max", "viz") --pfb: 2003.12.11 added product switch
            category:"Track View" 
            internalcategory:"Track View" 
            tooltip:"ʾ/ع" 
            buttontext:""
            -- Icon:#("TrackViewTools",0)
(
   on execute do
   (
	   	if trackviews.current != undefined do
		(
			trackviews.current.ui.showScrollBars = not trackviews.current.ui.showScrollBars
		)
   )
   on isChecked do 

   (
 	   	if trackviews.current != undefined 
		then (trackviews.currenttrackview.ui.showScrollBars)
		else false
	)
)--end macro

-------------------------------------------------------------------------------------------------------------
--***********************************************************************************************************

macroScript TV_Show_Hide_Controller_Window
	enabledIn:#("max", "viz") --pfb: 2003.12.11 added product switch
            category:"Track View" 
            internalcategory:"Track View" 
            tooltip:"ʾ/ؿ" 
            buttontext:""
            -- Icon:#("TrackViewTools",0)
(
   on execute do
   (
	   	if trackviews.currenttrackview != undefined do
		(
			trackviews.currenttrackview.ui.showTrackWindow = not trackviews.currenttrackview.ui.showTrackWindow
		)
   )
   on isChecked do 
   (
 	   	if trackviews.current != undefined 
		then (trackviews.currenttrackview.ui.showTrackWindow)
		else false
	)
)--end macro

-------------------------------------------------------------------------------------------------------------
--***********************************************************************************************************

macroScript TV_Show_Hide_Key_Window
	enabledIn:#("max", "viz") --pfb: 2003.12.11 added product switch
            category:"Track View" 
            internalcategory:"Track View" 
            tooltip:"ʾ/عؼ㴰" 
            buttontext:"ؼ㴰"
            -- Icon:#("TrackViewTools",0)
(
   on execute do
   (
	   	if trackviews.currenttrackview != undefined do
		(
			trackviews.currenttrackview.ui.showKeyWindow = not trackviews.currenttrackview.ui.showKeyWindow
		)
   )
   on isChecked do 
   (
 	   	if trackviews.current != undefined 
		then (trackviews.currenttrackview.ui.showKeyWindow)
		else false
	)
)--end macro

-------------------------------------------------------------------------------------------------------------
--***********************************************************************************************************

macroScript TV_Show_Hide_Time_Ruler
	enabledIn:#("max", "viz") --pfb: 2003.12.11 added product switch
            category:"Track View" 
            internalcategory:"Track View" 
            tooltip:"ʾ/ʱ" 
            buttontext:"ʱ"
            -- Icon:#("TrackViewTools",0)
(
   on execute do
   (
	   	if trackviews.currenttrackview != undefined do
		(
			trackviews.currenttrackview.ui.showTimeRuler = not trackviews.currenttrackview.ui.showTimeRuler
		)
   )
   on isChecked do 
   (
 	   	if trackviews.current != undefined 
		then (trackviews.currenttrackview.ui.showTimeRuler)
		else false
	)
)--end macro

-------------------------------------------------------------------------------------------------------------
--***********************************************************************************************************
-- Display and Selection Filter macros
-- ************************************************
MacroScript ManualNavigation
	enabledIn:#("max", "viz") --pfb: 2003.12.11 added product switch
	ButtonText:"ֶ" 
	Category:"Track View" 
	internalCategory:"Track View" 
	Tooltip:"ֶ" 
(
   	on execute do 
   	(
   		if trackviews.current != undefined do
		(
			trackviews.current.manualNavigation = not trackviews.current.manualNavigation
		)
	)
	on isChecked do 
	(
		if trackviews.current != undefined 
		then trackviews.current.manualNavigation
		else false
	)
)--end macro

-------------------------------------------------------------------------------------------------------------
--***********************************************************************************************************

MacroScript Auto_Expand_Children
	enabledIn:#("max", "viz") --pfb: 2003.12.11 added product switch
	ButtonText:"ԶչӶ" 
	Category:"Track View" 
	internalCategory:"Track View" 
	Tooltip:"ԶչӶ" 
	--Icon:#("TrackViewTools",23)
(
   	on execute do (trackviews.current.autoExpandChildren = not trackviews.current.autoExpandChildren)
	on isChecked do 
	(
		if trackviews.current != undefined 
		then trackviews.current.autoExpandChildren
		else false
	)
	on isEnabled do 
	(
		if trackviews.current != undefined 
		then not trackviews.current.manualNavigation
		else false
	)
)--end macro

-------------------------------------------------------------------------------------------------------------
--***********************************************************************************************************

MacroScript Auto_Expand_Selected_Only
	enabledIn:#("max", "viz") --pfb: 2003.12.11 added product switch
	ButtonText:"Զչѡ" 
	Category:"Track View" 
	internalCategory:"Track View" 
	Tooltip:"Զչѡ" 
	--Icon:#("TrackViewTools",23)
(
   	on execute do (trackviews.current.autoExpandSelectedOnly = not trackviews.current.autoExpandSelectedOnly)
	on isChecked do 
	(
		if trackviews.current != undefined 
		then trackviews.current.autoExpandSelectedOnly
		else false
	)
	on isEnabled do 
	(
		if trackviews.current != undefined 
		then not trackviews.current.manualNavigation
		else false
	)
)--end macro

-------------------------------------------------------------------------------------------------------------
--***********************************************************************************************************

MacroScript Auto_Expand_Transforms
	enabledIn:#("max", "viz") --pfb: 2003.12.11 added product switch
	ButtonText:"Զչ任" 
	Category:"Track View" 
	internalCategory:"Track View" 
	Tooltip:"Զչ任" 
	--Icon:#("TrackViewTools",23)
(
  	on execute do (trackviews.current.autoExpandTransforms = not trackviews.current.autoExpandTransforms)
	on isChecked do 
	(
		if trackviews.current != undefined 
		then trackviews.current.autoExpandTransforms
		else false
	)
	on isEnabled do 
	(
		if trackviews.current != undefined 
		then not trackviews.current.manualNavigation
		else false
	)
)--end macro

-------------------------------------------------------------------------------------------------------------
--***********************************************************************************************************

MacroScript Auto_Expand_XYZ
	enabledIn:#("max", "viz") --pfb: 2003.12.11 added product switch
	ButtonText:"Զչ XYZ " 
	Category:"Track View" 
	internalCategory:"Track View" 
	Tooltip:"Զչ XYZ " 
	--Icon:#("TrackViewTools",23)
(
   	on execute do (trackviews.current.autoExpandXYZ = not trackviews.current.autoExpandXYZ)
	on isChecked do 
	(
		if trackviews.current != undefined 
		then trackviews.current.autoExpandXYZ
		else false
	)
	on isEnabled do 
	(
		if trackviews.current != undefined 
		then not trackviews.current.manualNavigation
		else false
	)
)--end macro

-------------------------------------------------------------------------------------------------------------
--***********************************************************************************************************

MacroScript Auto_Expand_Objects
	enabledIn:#("max", "viz") --pfb: 2003.12.11 added product switch
	ButtonText:"Զչ" 
	Category:"Track View" 
	internalCategory:"Track View" 
	Tooltip:"Զչ" 
	--Icon:#("TrackViewTools",23)
(
   	on execute do (trackviews.current.autoExpandObjects = not trackviews.current.autoExpandObjects)
	on isChecked do 
	(
		if trackviews.current != undefined 
		then trackviews.current.autoExpandObjects
		else false
	)
	on isEnabled do 
	(
		if trackviews.current != undefined 
		then not trackviews.current.manualNavigation
		else false
	)
)--end macro

-------------------------------------------------------------------------------------------------------------
--***********************************************************************************************************
MacroScript Auto_Expand_Modifiers
	enabledIn:#("max") --pfb: 2003.12.11 added product switch
	ButtonText:"Զչ޸" 
	Category:"Track View" 
	internalCategory:"Animation Object" 
	Tooltip:"Զչ޸" 
	--Icon:#("TrackViewTools",23)
(
   	on execute do (trackviews.current.autoExpandModifiers = not trackviews.current.autoExpandModifiers)
	on isChecked do 
	(
		if trackviews.current != undefined 
		then trackviews.current.autoExpandModifiers
		else false
	)
	on isEnabled do 
	(
		if trackviews.current != undefined 
		then not trackviews.current.manualNavigation
		else false
	)
)--end macro

-------------------------------------------------------------------------------------------------------------
--***********************************************************************************************************

MacroScript Auto_Expand_Materials
	enabledIn:#("max") --pfb: 2003.12.11 added product switch
	ButtonText:"Զչ" 
	Category:"Track View" 
	internalCategory:"Track View" 
	Tooltip:"Զչ" 
	--Icon:#("TrackViewTools",23)
(
   	on execute do (trackviews.current.autoExpandMaterials = not trackviews.current.autoExpandMaterials)
	on isChecked do 
	(
		if trackviews.current != undefined 
		then trackviews.current.autoExpandMaterials
		else false
	)
	on isEnabled do 
	(
		if trackviews.current != undefined 
		then not trackviews.current.manualNavigation
		else false
	)
)--end macro

-------------------------------------------------------------------------------------------------------------
--***********************************************************************************************************

MacroScript Auto_Select_Animated
	enabledIn:#("max", "viz") --pfb: 2003.12.11 added product switch
	ButtonText:"Զѡ񶯻" 
	Category:"Track View" 
	internalCategory:"Track View" 
	Tooltip:"Զѡ񶯻" 
	--Icon:#("TrackViewTools",23)
(
   	on execute do (trackviews.current.autoSelectAnimated = not trackviews.current.autoSelectAnimated)
	on isChecked do 
	(
		if trackviews.current != undefined 
		then trackviews.current.autoSelectAnimated
		else false
	)
	on isEnabled do 
	(
		if trackviews.current != undefined 
		then not trackviews.current.manualNavigation
		else false
	)
)--end macro

-------------------------------------------------------------------------------------------------------------
--***********************************************************************************************************

MacroScript Auto_Select_Position
	enabledIn:#("max", "viz") --pfb: 2003.12.11 added product switch
	ButtonText:"Զѡλ" 
	Category:"Track View" 
	internalCategory:"Track View" 
	Tooltip:"Զѡλ" 
	--Icon:#("TrackViewTools",23)
(
   	on execute do (trackviews.current.autoSelectPosition = not trackviews.current.autoSelectPosition)
	on isChecked do 
	(
		if trackviews.current != undefined 
		then trackviews.current.autoSelectPosition
		else false
	)
	on isEnabled do 
	(
		if trackviews.current != undefined 
		then not trackviews.current.manualNavigation
		else false
	)
)--end macro

-------------------------------------------------------------------------------------------------------------
--***********************************************************************************************************

MacroScript Auto_Select_Rotation
	enabledIn:#("max", "viz") --pfb: 2003.12.11 added product switch
	ButtonText:"Զѡת" 
	Category:"Track View" 
	internalCategory:"Track View" 
	Tooltip:"Զѡת" 
	--Icon:#("TrackViewTools",23)
(
   	on execute do (trackviews.current.autoSelectRotation = not trackviews.current.autoSelectRotation)
	on isChecked do 
	(
		if trackviews.current != undefined 
		then trackviews.current.autoSelectRotation
		else false
	)
	on isEnabled do 
	(
		if trackviews.current != undefined 
		then not trackviews.current.manualNavigation
		else false
	)
)--end macro

-------------------------------------------------------------------------------------------------------------
--***********************************************************************************************************

MacroScript Auto_Select_Scale
	enabledIn:#("max", "viz") --pfb: 2003.12.11 added product switch
	ButtonText:"Զѡ" 
	Category:"Track View" 
	internalCategory:"Track View" 
	Tooltip:"Զѡ" 
	--Icon:#("TrackViewTools",23)
(
  	on execute do (trackviews.current.autoSelectScale = not trackviews.current.autoSelectScale)
	on isChecked do 
	(
		if trackviews.current != undefined 
		then trackviews.current.autoSelectScale
		else false
	)
	on isEnabled do 
	(
		if trackviews.current != undefined 
		then not trackviews.current.manualNavigation
		else false
	)
)--end macro

-------------------------------------------------------------------------------------------------------------
--***********************************************************************************************************

MacroScript Auto_Select_XYZ
	enabledIn:#("max", "viz") --pfb: 2003.12.11 added product switch
	ButtonText:"Զѡ XYZ " 
	Category:"Track View" 
	internalCategory:"Track View" 
	Tooltip:"Զѡ XYZ " 
	--Icon:#("TrackViewTools",23)
(
   	on execute do (trackviews.current.autoSelectXYZ = not trackviews.current.autoSelectXYZ)
	on isChecked do 
	(
		if trackviews.current != undefined 
		then trackviews.current.autoSelectXYZ
		else false
	)
	on isEnabled do 
	(
		if trackviews.current != undefined 
		then not trackviews.current.manualNavigation
		else false
	)
)--end macro

-------------------------------------------------------------------------------------------------------------
--***********************************************************************************************************

macroScript Auto_Scroll_To_Selected
	enabledIn:#("max", "viz") --pfb: 2003.12.11 added product switch
            category:"Track View" 
            internalcategory:"Track View" 
            tooltip:"Զѡ" 
            buttontext:"Զѡ" 
            -- Icon:#("TrackViewTools",0)
(
   	on execute do (trackviews.current.autoScrollToSelected = not trackviews.current.autoScrollToSelected)
	on isChecked do 
	(
		if trackviews.current != undefined 
		then trackviews.current.autoScrollToSelected
		else false
	)
	on isEnabled do 
	(
		if trackviews.current != undefined 
		then not trackviews.current.manualNavigation
		else false
	)
)--end macro

-------------------------------------------------------------------------------------------------------------
--***********************************************************************************************************

macroScript Auto_Scroll_To_Root
	enabledIn:#("max", "viz") --pfb: 2003.12.11 added product switch
            category:"Track View" 
            internalcategory:"Track View" 
            tooltip:"Զ" 
            buttontext:"Զ" 
            -- Icon:#("TrackViewTools",0)
(
   	on execute do (trackviews.current.autoScrollToRoot = not trackviews.current.autoScrollToRoot)
	on isChecked do 
	(
		if trackviews.current != undefined 
		then trackviews.current.autoScrollToRoot
		else false
	)
	on isEnabled do 
	(
		if trackviews.current != undefined 
		then not trackviews.current.manualNavigation
		else false
	)
)--end macro

-------------------------------------------------------------------------------------------------------------
--***********************************************************************************************************

-- R4 Trackview selected method
-- *************************************************
MacroScript TrackView_Selected
	enabledIn:#("max", "viz") --pfb: 2003.12.11 added product switch
	ButtonText:"ѡ켣ͼ" 
	Category:"Track View" 
	internalCategory:"Track View" 
	Tooltip:"鿴ѡ" 
	Icon:#("TrackViewTools",23)
(
	fn TrackSel = 
	(
		
		TrackView.Open "Selected"
		TrackView.setFilter "Selected" #modifiedObjects #SelectedObjects #curveX #curveY #curveZ #Objects #Hierarchy #Transforms #Position #Rotation #Scale #positionX #positionY #positionZ #rotationX #rotationY #rotationZ #scaleX #scaleY #scaleZ
		TrackView.zoomSelected "Selected"
	)
	
	fn CloseTrackSel =
	(
		for t in 1 to Trackview.NumTrackViews() do
		(
			If Trackview.GetTrackviewName T == "Selected" then
			(
				TrackView.Close "Selected"
 			)
			Else
			(
			)
		)
	)

	On IsVisible return selection.count != 0
	On IsEnabled return selection.count != 0
	On Execute do
	(
		(
			CloseTrackSel ()
			TrackSel ()
			TrackView.zoomSelected Selection[1].name
		)
	)

)--end macro

-------------------------------------------------------------------------------------------------------------
--***********************************************************************************************************

MacroScript Toggle_Keyable_Icons
	enabledIn:#("max", "viz") --pfb: 2003.12.11 added product switch
	ButtonText:"ʾùؼͼ" 
	Category:"Track View" 
	internalCategory:"Track View" 
	Tooltip:"ʾùؼͼ" 
	Icon:#("TrackViewTools",107)
(
    on execute do (trackviews.current.ui.showKeyableIcons = not trackviews.current.ui.showKeyableIcons)
	on isChecked do 
	(
		if trackviews.current != undefined 
		then trackviews.current.ui.showKeyableIcons
		else false
	)
)--end macro

-------------------------------------------------------------------------------------------------------------
--***********************************************************************************************************

MacroScript Toggle_Custom_Icons
	enabledIn:#("max", "viz") --pfb: 2003.12.11 added product switch
	ButtonText:"ʾԶͼ" 
	Category:"Track View" 
	internalCategory:"Track View" 
	Tooltip:"ʾԶͼ" 
	--Icon:#("TrackViewTools",23)
(
    on execute do (trackviews.current.ui.showCustomIcons = not trackviews.current.ui.showCustomIcons)
	on isChecked do 
	(
		if trackviews.current != undefined 
		then trackviews.current.ui.showCustomIcons
		else false
	)
)--end macro

-------------------------------------------------------------------------------------------------------------
--***********************************************************************************************************

MacroScript Toggle_Modify_Children
	enabledIn:#("max", "viz") --pfb: 2003.12.11 added product switch
	ButtonText:"޸Ӷؼ" 
	Category:"Track View" 
	internalCategory:"Track View" 
	Tooltip:"޸Ӷؼ" 
	Icon:#("TrackViewTools",60)
(
    on execute do (trackviews.current.modifyChildren = not trackviews.current.modifyChildren)
	on isChecked do 
	(
		if trackviews.current != undefined 
		then trackviews.current.modifyChildren
		else false
	)
	on isVisible do 
	(
		if trackviews.current != undefined 
		then trackviews.current.editMode != #editFCurves
		else false
	)
)--end macro

-------------------------------------------------------------------------------------------------------------
--***********************************************************************************************************

MacroScript Use_SoftSelect
	enabledIn:#("max", "viz") --pfb: 2003.12.11 added product switch
	ButtonText:"ʹѡ" 
	Category:"Track View" 
	internalCategory:"Track View" 
	Tooltip:"ʹѡ" 
(
	on execute do 
	(
		if trackviews.current != undefined do
		( 
			trackviews.current.useSoftSelect = not trackviews.current.useSoftSelect
		)
	)
	on isChecked do 
	(
		if trackviews.current != undefined 
		then trackviews.current.useSoftSelect
		else false
	)
)--end macro

-------------------------------------------------------------------------------------------------------------
--***********************************************************************************************************

MacroScript SoftSelect_Settings
	enabledIn:#("max", "viz") --pfb: 2003.12.11 added product switch
	ButtonText:"ѡ..." 
	Category:"Track View" 
	internalCategory:"Track View" 
	Tooltip:"ѡ" 
(
	on execute do 
	(
		tv = trackviews.current
		if tv != undefined do
		(
			tv.launchUtility "ѡù"
		)
	)
	on isChecked return false
)--end macro

-------------------------------------------------------------------------------------------------------------
--***********************************************************************************************************

MacroScript Maximize_Trackbar
	enabledIn:#("max", "viz") --pfb: 2003.12.11 added product switch
	ButtonText:"ر" 
	Category:"Track View" 
	internalCategory:"Track View" 
	Tooltip:"л켣" 
	Icon:#("TrackBar",1)
(
   on execute do with redraw off
   (
	   if timeslider.isvisible() == true then 
	   	(
			if (trackviews.open "켣" layoutName:"켣" dock:#bottom height:170) do
			   (
		  	   maxIni = (GetMAXIniFile())--pfb removed hardcoded access to 3dsmax.ini		
			   iniState = getFileAttribute maxIni #readOnly
			   setFileAttribute maxIni #readOnly true
			   maxOps.trackbar.visible = false
			   timeSlider.SetVisible false
			   setFileAttribute maxIni #readOnly iniState
			   )
		)
		Else 
		(
 		   trackviews.close "켣"
		   maxIni = (GetMAXIniFile())--pfb : removed hardcoded access to 3dsmax.ini
		   iniState = getFileAttribute maxIni #readOnly
		   setFileAttribute maxIni #readOnly true
		   maxOps.trackbar.visible = true
		   timeSlider.SetVisible true
		   setFileAttribute maxIni #readOnly iniState
  		)
   )
   on isChecked return false
)--end macro

-------------------------------------------------------------------------------------------------------------
--***********************************************************************************************************


/*
/********************************************************************************
Macro Script to collapse the current trackview selection to keyframe controllers.
This will turn any procedural controller into a keyframed controller. 
Options:
Start Frame
End Frame
Samples (displayed in frames)
New Controller type
Add to new layer (keeps the original controller stored on a layer with a weight of 0)
Written by Discreet Staff (02/25/02)

Revision History:
		11 dec 2003, Pierre-Felix Breton, 
		added product switcher: this macroscript file can be shared with all Discreet products



Modify at your own risk
-- ********************************************************************************
*/
macroScript collapseController
enabledIn:#("max", "viz") --pfb: 2003.12.11 added product switch
category:"Track View"
internalcategory:"Track View" 
toolTip:"ݿ..."
buttonText:"ݿ..."
(
	on isEnabled do
	(
		local res = false
 		if trackviews.current != undefined do 
		(
			local parentTracks = #()
			local subNums = #()
			for i in 1 to trackviews.current.numSelTracks() do
			(
				local p = (trackviews.current.getParentOfSelected i)
				if p != undefined do 
				(
					append parentTracks p
					append subNums (trackviews.current.getSelectedSubNum i)
				)
			)
			for i in 1 to parentTracks.count while not res do
			(
				local tmpController
				if parentTracks[i][subNums[i]] != undefined do 
				(
					tmpController = parentTracks[i][subNums[i]].controller
				)
				if (isController tmpController) == true do
				(
					if (classof tmpController != Biped_SubAnim and classof parentTracks[i] != Biped_SubAnim) do res = true
				)
			)
		)
		return res
	)
	
	on execute do
	(
		global rltCollapseControllerSetup, collapseController2Controller, collapseController2EulerController

		fn collapseController2EulerController ControllerFrom ControllerTo Start End Samples =
		(
			-- function handles everything in ticks, to ensure flexibility and precision
			local starttick = start*ticksPerFrame, endtick = end*ticksPerFrame, sampletick = samples*ticksPerFrame
			for i in starttick to endtick by sampletick do
			(
				t = ((i/ticksPerFrame) as time)
				tmpXKey = addNewKey controllerTo[1].controller t
				tmpXKey.value = at time t (QuatToEuler controllerFrom.value).x
				tmpYKey = addNewKey controllerTo[2].controller t
				tmpYKey.value = at time t (QuatToEuler controllerFrom.value).y
				tmpZKey = addNewKey controllerTo[3].controller t
				tmpZKey.value = at time t (QuatToEuler controllerFrom.value).z
				
			) -- end for
			controllerTo
		) -- end fn collapseController2EulerController
		
		fn collapseController2Controller ControllerFrom ControllerTo Start End Samples =
		(
			if (Classof controllerTo) == Euler_XYZ do
			(
				return (collapseController2EulerController ControllerFrom ControllerTo Start End Samples)
			) -- end if
			-- function handles everything in ticks, to ensure flexibility and precision
			local starttick = start*ticksPerFrame, endtick = end*ticksPerFrame, sampletick = samples*ticksPerFrame
			for i in starttick to endtick by sampletick do
			(
				tmpKey = addNewKey controllerTo ((i/ticksPerFrame) as time)
				tmpKey.value = at time ((i/ticksPerFrame) as time) controllerFrom.value
				
			) -- end for
			controllerTo
		) -- end fn collapseController2Controller
		
		rollout rltCollapseControllerSetup "ݿ" width:162 height:171
		(
		
			spinner spnStart "ʼ֡" pos:[28,7] width:111 height:16 range:[-100000,100000,0] fieldwidth:45
			spinner spnEnd "֡" pos:[31,28] width:108 height:16 range:[-100000,100000,100] fieldwidth:45
			spinner spnSamples "" pos:[42,49] width:97 height:16 range:[0,1000,1] fieldwidth:45
			label lbSampleUnits "f" pos:[146,50] width:3 height:13
			radiobuttons rbType "۵:" pos:[2,68] width:138 height:46 labels:#("Bezier  Euler ", "Ի TCB ") columns:1
			checkbox newLayer "ӵ²" pos:[15,119] width:135 height:15
			button btnOK "OK" pos:[15,143] width:65 height:21 across:2
			button btnCancel "ȡ" pos:[83,143] width:65 height:21
				
			on rltCollapseControllerSetup open do
			(
				controllerRange = animationRange
				
				if trackviews.current != undefined AND trackviews.current.numSelTracks() == 1 do
				(
					local tmpController = trackviews.current.getSelected 1
					if (isController tmpController) == true do
					(
						controllerRange = getTimeRange tmpController
						-- There's a bug in PositionXYZ. It does not return the ranges from the children controllers, so it's very tough to collapse them...
						if (controllerRange.start as integer)/ticksPerFrame == -13421772 do controllerRange = animationRange
					)
				)
				
				spnStart.value = controllerRange.start
				spnEnd.value = controllerRange.end
				
			)
			on btnOK pressed do
			(
				if spnSamples.value == 0.0 do 
				(
					destroyDialog rltCollapseControllerSetup
					return()
				)
					
				local parentTracks = #()
				local subNums = #()
				for i in 1 to trackviews.current.numSelTracks() do
				(
					append parentTracks (trackviews.current.getParentOfSelected i)
					append subNums (trackviews.current.getSelectedSubNum i)
				)
				
				for i in 1 to parentTracks.count do
				(
					if parentTracks[i] != undefined and classof parentTracks[i] != Biped_SubAnim do
					(	
						local oldController = parentTracks[i][subNums[i]].controller
						-- superclassof Biped_SubAnim incorrectly reports FloatController, exclude
						if (classof oldController == Biped_SubAnim) do oldController = undefined 
						local listController = undefined
						local newController = undefined
						case superClassof oldController of
						(
							PositionController:
							(
								case rbType.state of
								(
									1:	newController = Bezier_Position()
									2:	newController = Linear_Position()
								)
								if newLayer.checked == true and (classof parentTracks[i]) != Position_List do
									( listController = Position_List() )
							)
							FloatController:
							(
								case rbType.state of
								(
									1:	newController = Bezier_Float()
									2:	newController = Linear_Float()
								)
								if newLayer.checked == true and (classof parentTracks[i]) != Float_List do
									( listController = Float_List() )
							)
							Point3Controller:
							(
								case rbType.state of
								(
									1:	newController = Bezier_Point3()
									2:	newController = Bezier_Point3()
								)
								if newLayer.checked == true and (classof parentTracks[i]) != Point3_List do
									( listController = Point3_List() )
							)
							RotationController:
							(
								case rbType.state of
								(
									1:	newController = Euler_XYZ()
									2:	newController = TCB_Rotation()
								)
								if newLayer.checked == true and (classof parentTracks[i]) != Rotation_List do
									( listController = Rotation_List() )
							)
							ScaleController:
							(
								case rbType.state of
								(
									1:	newController = Bezier_Scale()
									2:	newController = Linear_Scale()
								)
								if newLayer.checked == true and (classof parentTracks[i]) != Scale_List do
									( listController = Scale_List() )
							)
						) -- end superclass case
						if newController != undefined do try
						(
							Undo "Collapse Controller" On 
							(
								if newLayer.checked == true then 
								(						
									local index = 0
									if listController == undefined then 
									(
										listController = parentTracks[i]
										index = subNums[i]
									)
									else 
									(
										parentTracks[i][subNums[i]].controller = listController
										index = listController.count
									)
										
									listController.weights[index].value = 0.0
									listController.setName index ((listController.getName index) + " (collapsed)")
									listController[listController.count+1].controller = newController
									listController.setActive listController.count
								)
								else 
								(
									parentTracks[i][subNums[i]].controller = newController
								)
								newController = collapseController2Controller oldController newController spnStart.value spnEnd.value spnSamples.value
							)
						)
						catch(format "failure replacing subanim % of %: controller: %\n" i parentTracks[i] oldController )
					)
				)
				destroyDialog rltCollapseControllerSetup
			)
			on btnCancel pressed do
				destroyDialog rltCollapseControllerSetup
		)
		
		if trackviews.current != undefined then
		(
			createDialog rltCollapseControllerSetup modal:false parent:trackviews.current.ui.hwnd
		)
		else
		(
			createDialog rltCollapseControllerSetup modal:false
		)
			
	) -- end Execute

) -- end Macro

