/*

Schematic View MacroScript File

Created:  		April 1 2003

Author :  Michael Russo
Version:  3ds max 6

	12 dec 2003, Pierre-Felix Breton, 
		added product switcher: this macro file can be shared with all Discreet products


--***********************************************************************************************
-- MODIFY THIS AT YOUR OWN RISK
-- 

*/

-- ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
-- Localization Notes
--
-- /* "Localize On" */ states an area where locization should begin
-- /* "Localize Off" */ states an area where locization should end
--
-- *** Localization Note *** states that the next line has special localization instructions for the next line.
-- ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

MacroScript SVAlignLeft
enabledIn:#("max", "viz") --pfb: 2003.12.12 added product switch
ButtonText:""
Category:"Schematic View" 
internalCategory:"Schematic View" 
Tooltip:"" 
(
	on Execute do
	(
		-- Get current schematic view interface
		local sv = schematicViews.current

		if sv != undefined do (

			-- Begin SV edit session
			sv.beginEdit()

			-- Get list of selected SV Nodes
			local selList = sv.getSelectedSVNodes()

			if selList.count > 1 do (

				-- Get first entry in selection list
				local pt = sv.getSVNodePos selList[1]
				local iLeft = pt.x

				-- Loop thru and find left-most node
				for i in selList do (
					pt = sv.getSVNodePos i
					if pt.x < iLeft then iLeft = pt.x
				)

				-- Set selection list to left-most value
				for i in selList do (
					pt = sv.getSVNodePos i
					pt.x = iLeft
					sv.setSVNodePos i sv.moveChildren pt
				)
			)

			-- End SV edit session
			sv.endEdit()
		)
	)

	on isEnabled do
	(
		if( schematicviews.current==undefined ) do return true
		return schematicviews.current.alwaysarrange != true
	)

	on isVisible do return (schematicViews.current!=undefined)
)

MacroScript SVAlignRight
enabledIn:#("max","viz") --pfb: 2003.12.12 added product switch
ButtonText:"Ҷ"
Category:"Schematic View" 
internalCategory:"Schematic View" 
Tooltip:"Ҷ" 
(
	on Execute do
	(
		-- Get current schematic view interface
		local sv = schematicViews.current

		if sv != undefined do (

			-- Begin SV edit session
			sv.beginEdit()

			-- Get list of selected SV Nodes
			local selList = sv.getSelectedSVNodes()

			if selList.count > 1 do (

				-- Get first entry in selection list
				local pt = sv.getSVNodePos selList[1]
				local iRight = pt.x

				-- Loop thru and find right-most node
				for i in selList do (
					pt = sv.getSVNodePos i
					if pt.x > iRight then iRight = pt.x
				)

				-- Set selection list to right-most value
				for i in selList do (
					pt = sv.getSVNodePos i
					pt.x = iRight
					sv.setSVNodePos i sv.moveChildren pt
				)
			)

			-- End SV edit session
			sv.endEdit()
		)
	)

	on isEnabled do
	(
		if( schematicviews.current==undefined ) do return true
		return schematicviews.current.alwaysarrange != true
	)
	on isVisible do return (schematicViews.current!=undefined)
)

MacroScript SVAlignTop
enabledIn:#("max","viz") --pfb: 2003.12.12 added product switch
ButtonText:"˶"
Category:"Schematic View" 
internalCategory:"Schematic View" 
Tooltip:"˶" 
(
	on Execute do
	(
		-- Get current schematic view interface
		local sv = schematicViews.current

		if sv != undefined do (

			-- Begin SV edit session
			sv.beginEdit()

			-- Get list of selected SV Nodes
			local selList = sv.getSelectedSVNodes()

			if selList.count > 1 do (

				-- Get first entry in selection list
				local pt = sv.getSVNodePos selList[1]
				local iTop = pt.y

				-- Loop thru and find top-most node
				for i in selList do (
					pt = sv.getSVNodePos i
					if pt.y < iTop then iTop = pt.y
				)

				-- Set selection list to top-most value
				for i in selList do (
					pt = sv.getSVNodePos i
					pt.y = iTop
					sv.setSVNodePos i sv.moveChildren pt
				)
			)

			-- End SV edit session
			sv.endEdit()
		)
	)

	on isEnabled do
	(
		if( schematicviews.current==undefined ) do return true
		return schematicviews.current.alwaysarrange != true
	)
	on isVisible do return (schematicViews.current!=undefined)
)

MacroScript SVAlignBottom
enabledIn:#("max","viz") --pfb: 2003.12.12 added product switch
ButtonText:"׶˶"
Category:"Schematic View" 
internalCategory:"Schematic View" 
Tooltip:"׶˶" 
(
	on Execute do
	(
		-- Get current schematic view interface
		local sv = schematicViews.current

		if sv != undefined do (

			-- Begin SV edit session
			sv.beginEdit()

			-- Get list of selected SV Nodes
			local selList = sv.getSelectedSVNodes()

			if selList.count > 1 do (

				-- Get first entry in selection list
				local pt = sv.getSVNodePos selList[1]
				local iBottom = pt.y

				-- Loop thru and find bottom-most node
				for i in selList do (
					pt = sv.getSVNodePos i
					if pt.y > iBottom then iBottom = pt.y
				)

				-- Set selection list to bottom-most value
				for i in selList do (
					pt = sv.getSVNodePos i
					pt.y = iBottom
					sv.setSVNodePos i sv.moveChildren pt
				)
			)

			-- End SV edit session
			sv.endEdit()
		)
	)

	on isEnabled do
	(
		if( schematicviews.current==undefined ) do return true
		return schematicviews.current.alwaysarrange != true
	)
	on isVisible do return (schematicViews.current!=undefined)
)

MacroScript SVAlignVCenter
enabledIn:#("max","viz") --pfb: 2003.12.12 added product switch
ButtonText:"ֱж"
Category:"Schematic View" 
internalCategory:"Schematic View" 
Tooltip:"ֱж" 
(
	on Execute do
	(
		-- Get current schematic view interface
		local sv = schematicViews.current

		if sv != undefined do (

			-- Begin SV edit session
			sv.beginEdit()

			-- Get list of selected SV Nodes
			local selList = sv.getSelectedSVNodes()

			if selList.count > 1 do (

				-- Get first entry in selection list
				local pt = sv.getSVNodePos selList[1]
				local iTop = pt.y
				local iBottom = pt.y

				-- Loop thru and find top and bottom-most values
				for i in selList do (
					pt = sv.getSVNodePos i
					if pt.y > iBottom then iBottom = pt.y
					if pt.y < iTop then iTop = pt.y
				)

				-- Set selection list to centered value
				for i in selList do (
					pt = sv.getSVNodePos i
					pt.y = (iTop + iBottom) / 2
					sv.setSVNodePos i sv.moveChildren pt
				)
			)

			-- End SV edit session
			sv.endEdit()
		)
	)

	on isEnabled do
	(
		if( schematicviews.current==undefined ) do return true
		return schematicviews.current.alwaysarrange != true
	)
	on isVisible do return (schematicViews.current!=undefined)
)

MacroScript SVAlignHCenter
enabledIn:#("max","viz") --pfb: 2003.12.12 added product switch
ButtonText:"ˮƽж"
Category:"Schematic View" 
internalCategory:"Schematic View" 
Tooltip:"ˮƽж" 
(
	on Execute do
	(
		-- Get current schematic view interface
		local sv = schematicViews.current

		if sv != undefined do (

			-- Begin SV edit session
			sv.beginEdit()

			-- Get list of selected SV Nodes
			local selList = sv.getSelectedSVNodes()

			if selList.count > 1 do (

				-- Get first entry in selection list
				local pt = sv.getSVNodePos selList[1]
				local iLeft = pt.x
				local iRight = pt.x

				-- Loop thru and find left and right-most values
				for i in selList do (
					pt = sv.getSVNodePos i
					if pt.x > iRight then iRight = pt.x
					if pt.x < iLeft then iLeft = pt.x
				)

				-- Set selection list to centered value
				for i in selList do (
					pt = sv.getSVNodePos i
					pt.x = (iLeft + iRight) / 2
					sv.setSVNodePos i sv.moveChildren pt
				)
			)

			-- End SV edit session
			sv.endEdit()
		)
	)

	on isEnabled do
	(
		if( schematicviews.current==undefined ) do return true
		return schematicviews.current.alwaysarrange != true
	)
	on isVisible do return (schematicViews.current!=undefined)
)

MacroScript SVParamWire
enabledIn:#("max","viz") --pfb: 2003.12.12 added product switch
ButtonText:""
Category:"Schematic View" 
internalCategory:"Schematic View" 
Tooltip:"" 
(
	on isVisible do return (schematicViews.current!=undefined)
	on Execute do
	(
		-- Get current schematic view interface
		local sv = schematicViews.current

		if sv != undefined do sv.setMode #PARAMWIRE
	)
)


MacroScript SVAlwaysArrange
enabledIn:#("max","viz") --pfb: 2003.12.12 added product switch
ButtonText:"ʼ"
Category:"Schematic View" 
internalCategory:"Schematic View" 
Tooltip:"ʼ" 
(
	on Execute do
	(
		if( schematicviews.current!=undefined ) do
			schematicviews.current.alwaysarrange = not schematicviews.current.alwaysarrange
	)

	on isEnabled do
	(
		if( schematicviews.current==undefined ) do return true
		return not schematicviews.current.TestIncludeFilter #selectedOnly
	)

	on isVisible do return (schematicViews.current!=undefined)
	on isChecked do
	(
		if( schematicviews.current==undefined ) do return false
		return schematicviews.current.alwaysarrange
	)
)

MacroScript SVSyncSelection
enabledIn:#("max","viz") --pfb: 2003.12.12 added product switch
ButtonText:"ͬѡ"
Category:"Schematic View" 
internalCategory:"Schematic View" 
Tooltip:"ͬѡ" 
(
	on Execute do
	(
		if( schematicviews.current!=undefined ) do
			schematicviews.current.syncSelection = not schematicviews.current.syncSelection
	)

	on isVisible do return (schematicViews.current!=undefined)
	on isChecked do
	(
		if( schematicviews.current==undefined ) do return false
		return schematicviews.current.syncSelection
	)
)


MacroScript SVUnShrinkAll
enabledIn:#("max","viz") --pfb: 2003.12.12 added product switch
ButtonText:"ȫȡ"
Category:"Schematic View" 
internalCategory:"Schematic View" 
Tooltip:"ȫȡ" 
(
	on isVisible do return (schematicViews.current!=undefined)
	on Execute do
	(
		if( schematicviews.current!=undefined ) do (
			schematicviews.current.unShrinkAll()
			schematicviews.current.updateView false
		)
	)
)


MacroScript SVShrinkSelected
enabledIn:#("max","viz") --pfb: 2003.12.12 added product switch
ButtonText:"ѡ"
Category:"Schematic View" 
internalCategory:"Schematic View" 
Tooltip:"ѡ" 
(
	on isVisible do return (schematicViews.current!=undefined)
	on Execute do
	(
		-- Get current schematic view interface
		local sv = schematicViews.current

		if sv != undefined do (

			-- Begin SV edit session
			sv.beginEdit()
			
			sv.shrink()

			-- End SV edit session
			sv.endEdit()
			
			sv.updateView false
		)
	)
)

MacroScript SVUnShrinkSelected
enabledIn:#("max","viz") --pfb: 2003.12.12 added product switch
ButtonText:"ȡѡ"
Category:"Schematic View" 
internalCategory:"Schematic View" 
Tooltip:"ȡѡ" 
(
	on isVisible do return (schematicViews.current!=undefined)
	on Execute do
	(
		-- Get current schematic view interface
		local sv = schematicViews.current

		if sv != undefined do (

			-- Begin SV edit session
			sv.beginEdit()

			sv.unshrink()

			-- End SV edit session
			sv.endEdit()
			
			sv.updateView false
		)
	)
)

MacroScript SVArrangeSelected
enabledIn:#("max","viz") --pfb: 2003.12.12 added product switch
ButtonText:"ѡ"
Category:"Schematic View" 
internalCategory:"Schematic View" 
Tooltip:"ѡ" 
(
	on isVisible do return (schematicViews.current!=undefined)
	on Execute do
	(
		-- Get current schematic view interface
		local sv = schematicViews.current

		if sv != undefined do (

			-- Begin SV edit session
			sv.beginEdit()

			-- Get list of selected SV Nodes
			local selList = sv.getSelectedSVNodes()

			if selList.count > 0 do (
				sv.arrangeSVNode()
			)

			-- End SV edit session
			sv.endEdit()
			
			sv.updateView false
		)
	)
)

MacroScript SVAssignController
enabledIn:#("max","viz") --pfb: 2003.12.12 added product switch
ButtonText:"ָ"
Category:"Schematic View" 
internalCategory:"Schematic View" 
Tooltip:"ָ" 
(
	on Execute do
	(
		if( schematicviews.current!=undefined ) do
			return schematicviews.current.ShowAssignControllerDialog()
	)

	on isEnabled do
	(
		if( schematicviews.current==undefined ) do return true
		return schematicviews.current.canAssignController()
	)
	on isVisible do return (schematicViews.current!=undefined)
)

MacroScript SVDeleteSelected
enabledIn:#("max","viz") --pfb: 2003.12.12 added product switch
ButtonText:"ɾѡ"
Category:"Schematic View" 
internalCategory:"Schematic View" 
Tooltip:"ɾѡ" 
(
	on isVisible do return (schematicViews.current!=undefined)
	on Execute do
	(
		if( schematicviews.current==undefined ) do return true
		return schematicviews.current.DeleteSelected()
	)
)

MacroScript SVRefresh
enabledIn:#("max","viz") --pfb: 2003.12.12 added product switch
ButtonText:"ˢͼ"
Category:"Schematic View" 
internalCategory:"Schematic View" 
Tooltip:"ˢͼ" 
(
	on isVisible do return (schematicViews.current!=undefined)
	on Execute do
	(
		if( schematicviews.current==undefined ) do return true
		return schematicviews.current.updateView true
	)
)

MacroScript SVShowPreferenceDialog
enabledIn:#("max","viz") --pfb: 2003.12.12 added product switch
ButtonText:"ѡ"
Category:"Schematic View" 
internalCategory:"Schematic View" 
Tooltip:"ѡ" 
(
	on isVisible do return (schematicViews.current!=undefined)
	on Execute do
	(
		if( schematicviews.current==undefined ) do return true
		return schematicviews.current.ShowPreferencesDialog()
	)
)

MacroScript SVShowDisplayFloater
enabledIn:#("max","viz") --pfb: 2003.12.12 added product switch
ButtonText:"ʾ"
Category:"Schematic View" 
internalCategory:"Schematic View" 
Tooltip:"ʾ" 
(
	on isVisible do return (schematicViews.current!=undefined)
	on Execute do
	(
		if( schematicviews.current==undefined ) do return true
		return schematicviews.current.ShowDisplayFloater true
	)
)

MacroScript SVShowRelDialogSelected
enabledIn:#("max","viz") --pfb: 2003.12.12 added product switch
ButtonText:"ѡϵ鿴"
Category:"Schematic View" 
internalCategory:"Schematic View" 
Tooltip:"ѡϵ鿴" 
(
	on isVisible do return (schematicViews.current!=undefined)
	on Execute do
	(
		if( schematicviews.current==undefined ) do return true
		return schematicviews.current.ShowRelationshipDialog false
	)
)

MacroScript SVShowRelDialogAll
enabledIn:#("max","viz") --pfb: 2003.12.12 added product switch
ButtonText:"ȫϵ鿴"
Category:"Schematic View" 
internalCategory:"Schematic View" 
Tooltip:"ȫϵ鿴" 
(
	on isVisible do return (schematicViews.current!=undefined)
	on Execute do
	(
		if( schematicviews.current==undefined ) do return true
		return schematicviews.current.ShowRelationshipDialog true
	)
)

MacroScript SVShowAnimatedControllers
enabledIn:#("max","viz") --pfb: 2003.12.12 added product switch
ButtonText:"бͼ - "
Category:"Schematic View" 
internalCategory:"Schematic View" 
Tooltip:"бͼ - " 
(
	on isVisible do return (schematicViews.current!=undefined)
	on Execute do
	(
		-- Get current schematic view interface
		local sv = schematicViews.current

		if sv != undefined do (

			-- Begin SV edit session
			sv.beginEdit()

			-- Get list of selected SV Nodes
			local numNodes = sv.getNumSVNodes()

			local animCtrls = #()

			for i = 0 to numNodes-1 do
			(
				if sv.testSVNodeState i #animated do append animCtrls i				
			)

			sv.ShowListViewdialog animCtrls title:"" id:50

			-- End SV edit session
			sv.endEdit()
		)
	)
)
