/*

-- Macro Scripts File
-- Macro Scripts for render properties and render presets

Revision History:

	30 Juin 2004, Pierre-Felix Breton
		bug fix:  motion blur don't fail anymore on multiple selection

	4 May 2004, Pierre-Felix Breton
		modified the quick render presets shortcuts to skip the environement and effects categories
		added icons

	29 march 2004, Pierre-Felix Breton
		added "quick render shortcuts" macros, for render presets
	
	12 dec 2003, Pierre-Felix Breton, 
		added product switcher: this macro file can be shared with all Discreet products

 	9 Juin 2003: Pierre-Felix Breton
 	added tests for "bylayer/byobject" flags to prevent "disconnections" from the layer system.
	
*/


--***********************************************************************************************
-- MODIFY THIS AT YOUR OWN RISK

--------------------------------------------------------------------------------------------
-- Quick render shortcuts macros 
--------------------------------------------------------------------------------------------

/*
Usage:

	Once on a toolbar, a user can Shift + Click, it will save the current render settings in a "slot"
	Click on the button loads the settings.
*/


macroScript RenderPresetSlotA
	category:"Render"
	internalcategory: "Render" 
	toolTip:"ȾԤ贰 A(shift+clickԱ)" 
	ButtonText:"A"
	Icon:#("Render",11)

(

	on execute do
	(
		if (keyboard.shiftPressed) 
		then RenderPresets.Save 0 ((getdir #renderpresets) + "\\a.rps") #{1,4..64} --shift key saves the preset. Environment and Effects categories (2 and 3) are skipped on purpose
		else -- no key pressed
		(
			--load the preset
			if (doesFileExist ((getdir #renderpresets) + "\\a.rps") == true) do	renderpresets.LoadAll 0 ((getdir #renderpresets) + "\\a.rps")
		)
	)--end on execute
)


macroScript RenderPresetSlotB
	category:"Render"
	internalcategory: "Render" 
	toolTip:"ȾԤ贰 B(shift+clickԱ)" 
	ButtonText:"B"
	Icon:#("Render",12)

(

	on execute do
	(
		if (keyboard.shiftPressed) 
		then RenderPresets.Save 0 ((getdir #renderpresets) + "\\b.rps") #{1,4..64} --shift key saves the preset. Environment and Effects categories (2 and 3) are skipped on purpose
		else -- no key pressed
		(
			--load the preset
			if (doesFileExist ((getdir #renderpresets) + "\\b.rps") == true) do	renderpresets.LoadAll 0 ((getdir #renderpresets) + "\\b.rps")
		)
	)--end on execute
)



macroScript RenderPresetSlotC
	category:"Render"
	internalcategory: "Render" 
	toolTip:"ȾԤ贰 C(shift+clickԱ)" 
	ButtonText:"C"
	Icon:#("Render",13)
(

	on execute do
	(
		if (keyboard.shiftPressed) 
		then RenderPresets.Save 0 ((getdir #renderpresets) + "\\c.rps") #{1,4..64} --shift key saves the preset. Environment and Effects categories (2 and 3) are skipped on purpose
		else -- no key pressed
		(
			--load the preset
			if (doesFileExist ((getdir #renderpresets) + "\\c.rps") == true) do	renderpresets.LoadAll 0 ((getdir #renderpresets) + "\\c.rps")
		)
	)--end on execute
)



--------------------------------------------------------------------------------------------
-- Object properties macros 
--------------------------------------------------------------------------------------------
MacroScript InheritVis
enabledIn:#("max", "viz") --pfb: 2003.12.12 added product switch

            ButtonText:"̳пɼ"
            category:"Render"
            internalcategory:"Render"
            Tooltip:"/ü̳пɼ"
(

	On IsEnabled Return if (selection.count != 1) then true else (not $.renderbylayer) -- pfb; 9 juin 2003
	On IsVisible Return superclassof $ == GeometryClass
	on ischecked Do Try ($.inheritvisibility) Catch ()
	On Execute Do Try ($.inheritvisibility = not $.inheritvisibility)Catch ()
)

MacroScript Renderable
enabledIn:#("max", "viz") --pfb: 2003.12.12 added product switch
            ButtonText:"Ⱦ"
            category:"Render"
            internalcategory:"Render"
            Tooltip:"/ÿȾ"
(

	--on altExecute type do actionMan.executeAction 0 "40022" -- loc_notes: DO NOT LOCALIZE THIS
	on IsEnabled Return if (selection.count != 1) then true else (not $.renderbylayer) -- pfb; 9 juin 2003
	On IsVisible Return ((superclassof $ == GeometryClass) or (superclassof $ == Light)) -- pfb; 9 juin 2003
	on ischecked Do	Try ($.renderable)Catch ()
	On Execute Do Try ($.renderable = not $.renderable)	Catch ()
)

MacroScript CastShadows
enabledIn:#("max", "viz") --pfb: 2003.12.12 added product switch
            ButtonText:"ͶӰӰ"
            category:"Render"
            internalcategory:"Render"
            Tooltip:"/ͶӰӰ" 
(
	on IsEnabled Return if (selection.count != 1) then true else (not $.renderbylayer) -- pfb; 9 juin 2003
	On IsVisible Return superclassof $ == GeometryClass
	on ischecked Do	Try ($.CastShadows)	Catch ()
	On Execute Do Try ($.CastShadows= not $.CastShadows)Catch ()
)
MacroScript ReceiveShadows
enabledIn:#("max", "viz") --pfb: 2003.12.12 added product switch
            ButtonText:"Ӱ"
            category:"Render"
            internalcategory:"Render"
            Tooltip:"/ýӰ"
(
	on IsEnabled Return if (selection.count != 1) then true else (not $.renderbylayer) -- pfb; 9 juin 2003
	On IsVisible Return superclassof $ == GeometryClass
	on ischecked Do	Try ($.ReceiveShadows)Catch ()
	On Execute Do Try ($.ReceiveShadows= not $.ReceiveShadows)Catch ()
)

MacroScript VisibleToCamera
enabledIn:#("max", "viz") --pfb: 2003.12.12 added product switch
            ButtonText:"Ӱɼ"
            category:"Render"
            internalcategory:"Render"
            Tooltip:"/Ӱɼ"
(
	on IsEnabled Return if (selection.count != 1) then true else (not $.renderbylayer) -- pfb; 9 juin 2003
	On IsVisible Return superclassof $ == GeometryClass
	on ischecked Do	Try ($.primaryVisibility)Catch ()
	
	On Execute Do Try ($.primaryVisibility= not $.primaryVisibility)Catch ()
)

MacroScript VisibleToReflection
enabledIn:#("max", "viz") --pfb: 2003.12.12 added product switch
            ButtonText:"ɼ"
            category:"Render"
            internalcategory:"Render"
            Tooltip:"/÷ɼ"
(
	on IsEnabled Return if (selection.count != 1) then true else (not $.renderbylayer) -- pfb; 9 juin 2003
	On IsVisible Return superclassof $ == GeometryClass
	on ischecked Do	Try ($.secondaryVisibility)	Catch ()
	On Execute Do Try ($.secondaryVisibility= not $.secondaryVisibility)Catch ()
)

MacroScript ApplyAtmospherics
enabledIn:#("max", "viz") --pfb: 2003.12.12 added product switch
            ButtonText:"ӦôЧ"
            category:"Render"
            internalcategory:"Render"
            Tooltip:"/ӦôЧ"
(
	on IsEnabled Return if (selection.count != 1) then true else (not $.renderbylayer) -- pfb; 9 juin 2003
	On IsVisible Return superclassof $ == GeometryClass
	on ischecked Do	Try ($.applyAtmospherics)Catch ()
	
	On Execute Do Try ($.applyAtmospherics= not $.applyAtmospherics)Catch ()
)
MacroScript RenderOccluded
enabledIn:#("max", "viz") --pfb: 2003.12.12 added product switch
            ButtonText:"Ⱦն"
            category:"Render"
            internalcategory:"Render"
            Tooltip:"/Ⱦն"
(
	on IsEnabled Return if (selection.count != 1) then true else (not $.renderbylayer) -- pfb; 9 juin 2003
	On IsVisible Return superclassof $ == GeometryClass
	on ischecked Do	Try ($.renderOccluded)Catch ()
	On Execute Do Try ($.renderOccluded= not $.renderOccluded)Catch ()
)
MacroScript MotionBlurToggle
enabledIn:#("max", "viz") --pfb: 2003.12.12 added product switch
            ButtonText:"̬ģ"
            category:"Render"
            internalcategory:"Render"
            Tooltip:"/ö̬ģ"
(
	on IsEnabled Return if (selection.count != 1) then true else (not $.motionbylayer) -- pfb; 9 juin 2003
	On IsVisible Return (selection.count == 1) --pfb 23 feb 2004: relaxed the mblur properties to work on all objects
	on ischecked Do	Try ($.motionBlurOn)Catch ()
	On Execute Do Try ($.motionBlurOn= not $.motionBlurOn)Catch ()
)
MacroScript RenderSelected
enabledIn:#("max", "viz") --pfb: 2003.12.12 added product switch
            ButtonText:"Ⱦѡ"
            category:"Render"
            internalcategory:"Render"
            Tooltip:"Ⱦѡ"
(
	On Execute Do Try (render rendertype:#selection)Catch ()
)