-- Notes MacroScript File
--
-- Created:  		Dec 1 2000
-- Last Updated: 	Dec 20 2000
--
-- Author :   Frederick Ruff
/*
Version:  3ds max 6

 
This script adds Popup Notes to scene files.
***********************************************************************************************
 MODIFY THIS AT YOUR OWN RISK
 

	12 dec 2003, Pierre-Felix Breton, 
		added product switcher: this macro file can be shared with all Discreet products


////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
 Localization Notes

 "Localize On" states an area where locization should begin
 "Localize Off"  states an area where locization should end

*** Localization Note *** states that the next line has special localization instructions for the next line.
 ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

*/

MacroScript AddPopupNote
enabledIn:#("max", "viz") --pfb: 2003.12.12 added product switch
ButtonText:"ע"
Category:"Pop up Note" 
internalCategory:"Pop up Note" 
Tooltip:"ӵע" 
(
	/* "Localize On" */
	--Persistent Global Note_NoteString
	--Persistent Global Note_AuthorString
	--Persistent Global Note_TextString
	rollout NoteRollout "ע" width:500 height:400
	(

	Edittext auth ":" fieldwidth:150 text:""
	Edittext dtstmp ":" fieldwidth:150 offset:[8,0] text:localtime
	Checkbox Persist "ļʱʾע" checked:true
	Edittext line1 height:200 text:""

	Button CanclAll "ȡ" offset:[110,0] width:75
	Button Go "ע" offset:[190,-26] width:75
	
	On Go pressed do
		(
		callbacks.removescripts id:#SceneNote
		
		
		-- *** Localization Note *** states that the next line has special localization instructions for the next line.
		-- Persistent Global Note_NoteString = "Messagebox \"" + "(loc)Author: " + auth.text+"\n"+dtstmp.text+"\n\n(loc)Note Comments:\n"+ line1.text+ "\"" + "title:\"(loc)Pop-up Note\""
		
		Persistent Global Note_NoteString = "Messagebox \"" + ": " + auth.text+"\n"+dtstmp.text+"\n\nע˵:\n"+ line1.text+ "\"" + ":ע͡"
		Persistent Global Note_AuthorString = auth.text
		Persistent Global Note_TextString = line1.text
		If Persist.checked == true do callbacks.addscript #filepostopen "Execute Note_NoteString" id:#SceneNote persistent:true
		destroydialog NoteRollout
		fileproperties.addproperty #summary "comments" Note_TextString
		fileproperties.addproperty #summary "author" Note_AuthorString

		)
	On NoteRollout Open do 
		(
			try (auth.text = fileProperties.getPropertyvalue #summary 2) Catch()
			try (line1.text = fileProperties.getPropertyvalue #summary 1) Catch()
		)
	On CanclAll pressed do destroydialog NoteRollout
	)
	CreateDialog  NoteRollout  width:500 height:300		
	
)

MacroScript ReadPopupNote
enabledIn:#("max", "viz") --pfb: 2003.12.12 added product switch

ButtonText:"Ķע"
Category:"Pop up Note" 
internalCategory:"Pop up Note" 
Tooltip:"Ķע" 
(
	If Note_NoteString != undefined then Execute Note_NoteString
	Else  MessageBox "δṩκע͡" Title:"ע" beep:no
)

MacroScript DeletePopupNote
enabledIn:#("max", "viz") --pfb: 2003.12.12 added product switch
ButtonText:"ɾע"
Category:"Pop up Note" 
internalCategory:"Pop up Note" 
Tooltip:"ɾע" 
(
	If Note_NoteString != undefined then
	(
		 if querybox "Ƿȷ?" then 
		(
		callbacks.removescripts id:#SceneNote
		messagebox "עɾ" title:"ע" beep:no
		Note_NoteString = undefined
		)
	)
	Else  MessageBox "δṩκע͡" Title:"ע" beep:no
)

MacroScript SupressPopupNote
enabledIn:#("max", "viz") --pfb: 2003.12.12 added product switch
ButtonText:"ȡע"
Category:"Pop up Note" 
internalCategory:"Pop up Note" 
Tooltip:"ȡԵע" 
(
	if Note_NoteString != undefined then
		(
		callbacks.removescripts id:#SceneNote
	
		messagebox "עȡ\n\nļʱٳ֡±ļԱĸġ" title:"ע" beep:no
		)
	Else MessageBox "δṩע͡" Title:"ע" beep:no
)
/* "Localize Off" */