/*

***************************************************************************
Macro_Scripts File
Author:   Attila Szabo
Macro_Scripts that implement some of the Help menu items

Revision History
    Aug 06, 2003 - aszabo - Created
	
	12 dec 2003, Pierre-Felix Breton, 
		added product switcher: this macro file can be shared with all Discreet products
		consolidated the hotkey movie macro in this file

-- MODIFY THIS AT YOUR OWN RISK
***************************************************************************

*/


macroScript Help_IntroAndNewFeaturesGuide
enabledIn:#("max", "viz") --pfb: 2003.12.12 added product switch
buttontext:"¹ָ(&N)..."
category:"Help" 
internalCategory:"Help" 
tooltip:"¹ָ" 
(
	local fname = "\\NEWFEATURES.PDF"
	local fpath = getdir #help
	local strErrMsg = "޷ʾ¹ָϡ\n\nȷϵͳȷװ Adobe Acrobat Reader\nȻٴγʾ"
	local strMsgTitle = ""
	if (productAPPID == #viz) do 
	(
		strMsgTitle = "Autodesk VIZ"
	)
	if (productAPPID == #max) do 
	(
		strMsgTitle = "3ds max"
	)
		
	On isEnabled Return 
	(
		(getfiles (fpath + fname)).count != 0 
	)
	
	
	On Execute Do
	(
		try
		(
			if (fpath != undefined) do
			(
				res = ShellLaunch (fpath + fname) ""
				if (res == false) then
					MessageBox strErrMsg  title:strMsgTitle
			)
		) 
		catch()
	)
)

MacroScript Help_New_Features_Workshop
enabledIn:#("viz") 
ButtonText:"¹ϰᣨ&W..."
category:"Help" 
internalcategory:"Help" 
Tooltip:"¹ϰ" 
(
	fname = "\\viz_nfw.chm"
	fpath = getdir #help
	
	On isEnabled Return 
	(
		(getfiles (fpath + fname)).count != 0 
	)
	strMsgTitle = "Autodesk VIZ"
	local strErrMsg = "޷ʾ¹ϰ\n\nȷİ鿴(.chm) ȷ\nװϵͳȻٳʾ"
	On Execute Do
	(
		try
		(
			if (fname != undefined) do
			(
				res = ShellLaunch (fpath + fname) ""
				if (res == false) then
					MessageBox strErrMsg  title:strMsgTitle
			)
		) 
		catch()
	)
)

MacroScript Help_QuickStart_Guide
enabledIn:#("vizr") --pfb: 2003.12.12 added product switch
ButtonText:"ʼָ"
category:"Help" 
internalcategory:"Help" 
Tooltip:"ʼָ" 
(
	fname = "\\VIZ_RENDER_QUICK_START_GUIDE.PDF"
	fpath = getdir #help
	
	On isEnabled Return 
	(
		(getfiles (fpath + fname)).count != 0 
	)
	
	
	On Execute Do
	(
		try
		(
			if (fpath != undefined) do
			(
				ShellLaunch (fpath + fname) ""
			)
		) 
		catch()
	)
)

macroScript Help_Web_OnlineSupport
enabledIn:#("max", "viz", "vizr") --pfb: 2003.12.12 added product switch
buttontext:"֧(&S)..."
category:"Help" 
internalCategory:"Help" 
tooltip:"֧" 
(
	local fname = ""
	local strMsgTitle = ""	
	
	if (productAPPID == #vizR) do -- msw 04 Feb 2004: VIZR
	(
		fname = "http://www.autodesk.com/support"
		strMsgTitle = "VIZ Render"
	)
	if (productAPPID == #viz) do -- pfb 19 Dec 2003: VIZ
	(
		fname = "http://www.autodesk.com/viz2005onlinesupport"
		strMsgTitle = "Autodesk VIZ"
	)
	if (productAPPID == #max) do -- pfb 19 Dec 2003: MAX
	(
		local fname = "http://www.autodesk.com/3dsmax-support"
		strMsgTitle = "3ds max"
	)

	local strErrMsg = "޷ʾ֧֡ҳ\n\nȷϵͳȷװ\nȻٴγʾ"
		
	On Execute Do
	(
		try
		(
			if (fname != undefined) do
			(
				res = ShellLaunch (fname) ""
				if (res == false) then
					MessageBox strErrMsg  title:strMsgTitle
			)
		) 
		catch()
	)
)

macroScript Help_Web_Updates
enabledIn:#("max", "viz") --pfb: 2003.12.12 added product switch
buttontext:"(&U)..."
category:"Help" 
internalCategory:"Help" 
tooltip:"" 
(
	local fname = ""
	local strMsgTitle = ""	

	if (productAPPID == #viz) do -- pfb 19 Dec 2003: VIZ
	(
		fname = "http://www.autodesk.com/viz2005updates"
		strMsgTitle = "Autodesk VIZ"
	)
	if (productAPPID == #max) do -- pfb 19 Dec 2003: MAX
	(
		fname = "http://www.autodesk.com/3dsmax-updates "
		strMsgTitle = "3ds max"
	)
	
	local strErrMsg = "޷ʾ¡ҳ\n\nȷϵͳȷװ\nȻٴγʾ"
		
	On Execute Do
	(
		try
		(
			if (fname != undefined) do
			(
				res = ShellLaunch (fname) ""
				if (res == false) then
					MessageBox strErrMsg  title:strMsgTitle
			)
		) 
		catch()
	)
)

macroScript Help_Web_Resources
enabledIn:#("max", "viz", "vizr") --pfb: 2003.12.12 added product switch
buttontext:"Դ(&R)..."
category:"Help" 
internalCategory:"Help" 
tooltip:"Դ" 
(

	local fname = ""
	local strMsgTitle = ""	
        
    if (productAPPID == #vizR) do -- msw 04 Feb 2004
	(
		fname = "http://www.autodesk.com/us/archdesk/html/adt_plugins/adt_plugins.htm"
		strMsgTitle = "VIZ Render"
	)
	if (productAPPID == #viz) do -- pfb 19 Dec 2003: VIZ
	(
		fname = "http://www.autodesk.com/viz2005helpmenu"
		strMsgTitle = "Autodesk VIZ"
	)
	if (productAPPID == #max) do -- pfb 19 Dec 2003: MAX
	(
		fname = "http://www.autodesk.com/3dsmax-resources"
		strMsgTitle = "3ds max"
	)

	
	local strErrMsg = "޷ʾԴҳ\n\nȷϵͳȷװ\nȻٴγʾ"
		
	On Execute Do
	(
		try
		(
			if (fname != undefined) do
			(
				res = ShellLaunch (fname) ""
				if (res == false) then
					MessageBox strErrMsg  title:strMsgTitle
			)
		) 
		catch()
	)
)

macroScript Help_Web_Training
enabledIn:#("max") --pfb: 2003.12.12 added product switch
buttontext:"ѵ(&T)..."
category:"Help" 
internalCategory:"Help" 
tooltip:"ѵ" 
(

	local fname = ""
	local strMsgTitle = ""	
        
    if (productAPPID == #vizR) do
	(
		fname = "http://www.autodesk.com/"
		strMsgTitle = "VIZ Render"
	)
	if (productAPPID == #viz) do 
	(
		fname = "http://www.autodesk.com/"
		strMsgTitle = "Autodesk VIZ"
	)
	if (productAPPID == #max) do 
	(
		fname = "http://www.autodesk.com/me_training"
		strMsgTitle = "3ds max"
	)

	
	local strErrMsg = "޷ʾԴҳ\n\nȷϵͳȷװ\nȻٴγʾ"
		
	On Execute Do
	(
		try
		(
			if (fname != undefined) do
			(
				res = ShellLaunch (fname) ""
				if (res == false) then
					MessageBox strErrMsg  title:strMsgTitle
			)
		) 
		catch()
	)
)

macroScript Help_Web_Partners
enabledIn:#("max", "viz") --pfb: 2003.12.12 added product switch
buttontext:"(&P)..."
category:"Help" 
internalCategory:"Help" 
tooltip:"" 
(
	local fname = ""
	
	local strMsgTitle = ""
	if (productAPPID == #viz) do -- pfb 19 Dec 2003: VIZ
	(
		fname = "http://www.autodesk.com/viz-content"
		strMsgTitle = "Autodesk VIZ"
	)
	if (productAPPID == #max) do -- pfb 19 Dec 2003: MAX
	(
		fname = "http://www.autodesk.com/3dsmax-developers"
		strMsgTitle = "3ds max"
	)	
        
	local strErrMsg = "޷ʾ顱ҳ\n\nȷϵͳȷװ\nȻٴγʾ"
	On Execute Do
	(
		try
		(
			if (fname != undefined) do
			(
				res = ShellLaunch (fname) ""
				if (res == false) then
					MessageBox strErrMsg  title:strMsgTitle
			)
		) 
		catch()
	)
)


macroScript HotkeyFlash 
enabledIn:#("max") --pfb: 2003.12.12 added product switch, aszabo|feb.06.04|No hotkey map for VIZ
category:"Help" 
internalCategory:"Help"
tooltip:"ȼ Flash ӰƬ" 
(
	rollout rFlashError "ȼӳ"
	(
		label lbl "޷ Flash ActiveX ȡ²" height:50 offset:[175,10] across:2
		hyperLink hl "http://www.macromedia.com" address:"http://www.macromedia.com/software/flash/" color:blue hoverColor:red offset:[-60,40]
		button btn "Ok" height:25 width:60 offset:[0, -3]

		on btn pressed do destroyDialog rFlashError	
	)
	rollout rHotkeyFlash "ȼӳ"
	( 
		activeXControl axFlash "ShockwaveFlash.ShockwaveFlash.5" height:300 width:600 align:#center offset:[0,-5]
		
	 	on rHotkeyFlash open do
		( 
			local vText = (getDir #maxroot) + "\\splash.cfg"
			local vMovie = (getDir #maxroot) + "\\hotkeymap.swf"
	
			local vData = ""
			local vStream = openFile vText
			axFlash.Menu = false
		 	while not eof vStream do vData += readLine vStream
			close vStream			
			axFlash.movie =  vMovie
		)	
	)
	on execute do
	(
		try
		(
			createDialog rHotkeyFlash width:600 height:300 escapeEnable:false
		)
		catch 
		( 			
			destroyDialog rHotkeyFlash
			createDialog rFlashError width:300 height:100 modal:true
		)
	)
)

-- END OF FILE