--
-- @file Macro_Hair.mcr
--
-- @author Gonzalo Rueda <grueda@animatedpixel.com>
--
-- $Started: 2004/08/02 $
-- $Date: 2005/03/17 23:45:01 $
-- $Revision: 1.42 $
--
-- @brief   These are the macro scripts declared by Hair.
--
-- Copyright Joe Alter, Inc. 2004 
--
-- This work may not be duplicated, in whole or part, without the express
-- written permission of Joe Alter, Inc.
--


macroScript Hair_AddMod 
            category:"Hair and Fur" 
            internalcategory:"Hair" 
            tooltip:"ͷ޸"
            buttontext:"ͷ޸"
(
   on execute do
   (
      if $ != undefined then
      (
         hair.addMod $
		   setCommandPanelTaskMode mode:#create
		   setCommandPanelTaskMode mode:#modify
		   completeRedraw()
      )
   )
)


macroScript Hair_AddEffect
            category:"Hair and Fur" 
            internalcategory:"Hair" 
            tooltip:"ͷЧ"
            buttontext:"ͷЧ"
(
   on execute do
   (
      hair.addEffect true
   )
)


macroScript Hair_Purge
            category:"Hair and Fur" 
            internalcategory:"Hair" 
            tooltip:""
            buttontext:""
(
   on execute do
   (
      hair.Purge()
   )
)


macroScript Hair_AddHairProperties
            category:"Hair and Fur" 
            internalcategory:"Hair" 
            tooltip:"ͷ"
            buttontext:"ͷ"
(
   on execute do
   (
      if $ != undefined then
      (
         hair.AddHairProperties $
      )
   )
)


macroScript Hair_StyleHair
            category:"Hair and Fur" 
            internalcategory:"Hair" 
            tooltip:"ͷ"
            buttontext:"ͷ"
(
   on execute do
   (
      if $ != undefined then
      (
         for obj in $ do
         (
            --modifier = getActiveHairMod()

			currentModifier = undefined			
			if getCommandPanelTaskMode() == #modify then
			(
				modifier = modPanel.getCurrentObject()
				if modifier != undefined then
				(
					if isKindOf modifier HairMod == true then
					(
						currentModifier = modifier
					)		
				)	
			)

			if currentModifier != undefined then currentModifier.LaunchGUI instance:obj
            break
         )
      )
   )
)

macroScript Hair_ConvertHairsToMesh
            category:"Hair and Fur" 
            internalcategory:"Hair" 
            tooltip:"ͷתΪ"
            buttontext:"ͷתΪ"
(
   on execute do
   (
      if $ != undefined then
      (
         for obj in $ do 
		 (
			--modifier = getActiveHairMod()

			currentModifier = undefined			
			if getCommandPanelTaskMode() == #modify then
			(
				modifier = modPanel.getCurrentObject()
				if modifier != undefined then
				(
					if isKindOf modifier HairMod == true then
					(
						currentModifier = modifier
					)		
				)	
			)

			if currentModifier != undefined then currentModifier.ConvertToMesh instance:obj
			break
		 )
      )
   )
)


macroScript Hair_ConvertHairsToSplines
            category:"Hair and Fur" 
            internalcategory:"Hair" 
            tooltip:"ͷתΪ"
            buttontext:"ͷתΪ"
(
   on execute do
   (
      if $ != undefined then
      (
         for obj in $ do 
		 (
			--modifier = getActiveHairMod()
			
			currentModifier = undefined			
			if getCommandPanelTaskMode() == #modify then
			(
				modifier = modPanel.getCurrentObject()
				if modifier != undefined then
				(
					if isKindOf modifier HairMod == true then
					(
						currentModifier = modifier
					)		
				)	
			)
			
			if currentModifier != undefined then currentModifier.ConvertHairsToSplines instance:obj
			break
		 )
      )
   )
)

macroScript Hair_ConvertGuidesToSplines
            category:"Hair and Fur" 
            internalcategory:"Hair" 
            tooltip:"תΪ"
            buttontext:"תΪ"
(
   on execute do
   (
      if $ != undefined then
      (
         for obj in $ do 
		 (
			--modifier = getActiveHairMod()
			
			currentModifier = undefined			
			if getCommandPanelTaskMode() == #modify then
			(
				modifier = modPanel.getCurrentObject()
				if modifier != undefined then
				(
					if isKindOf modifier HairMod == true then
					(
						currentModifier = modifier
					)		
				)	
			)
			
			if currentModifier != undefined then currentModifier.ConvertGuidesToSplines instance:obj
			break
		 )
      )
   )
)

macroScript Hair_CopyHairdo
            category:"Hair and Fur" 
            internalcategory:"Hair" 
            tooltip:"Ʒ"
            buttontext:"Ʒ"
(
   on execute do
   (
      if $ != undefined then
      (
         for obj in $ do 
		 (
			--modifier = getActiveHairMod()
			
			currentModifier = undefined			
			if getCommandPanelTaskMode() == #modify then
			(
				modifier = modPanel.getCurrentObject()
				if modifier != undefined then
				(
					if isKindOf modifier HairMod == true then
					(
						currentModifier = modifier
					)		
				)	
			)

			if currentModifier != undefined then currentModifier.CopyHairdo instance:obj
			break
		 )
      )
   )
)

macroScript Hair_PasteHairdo
            category:"Hair and Fur" 
            internalcategory:"Hair" 
            tooltip:"ճ"
            buttontext:"ճ"
(
   on execute do
   (
      if $ != undefined then
      (
         for obj in $ do 
		 (
			--modifier = getActiveHairMod()
			
			currentModifier = undefined			
			if getCommandPanelTaskMode() == #modify then
			(
				modifier = modPanel.getCurrentObject()
				if modifier != undefined then
				(
					if isKindOf modifier HairMod == true then
					(
						currentModifier = modifier
					)		
				)	
			)

			if currentModifier != undefined then currentModifier.PasteHairdo instance:obj
			break
		 )
      )
   )
)

macroScript Hair_ReplaceRest
            category:"Hair and Fur" 
            internalcategory:"Hair" 
            tooltip:"滻ʣ"
            buttontext:"滻ʣ"
(
   on execute do
   (
      if $ != undefined then
      (
         for obj in $ do 
		 (
			--modifier = getActiveHairMod()
			
			currentModifier = undefined			
			if getCommandPanelTaskMode() == #modify then
			(
				modifier = modPanel.getCurrentObject()
				if modifier != undefined then
				(
					if isKindOf modifier HairMod == true then
					(
						currentModifier = modifier
					)		
				)	
			)
			
			if currentModifier != undefined then currentModifier.ResetRest instance:obj
			break
		 )
      )
   )
)

macroScript Hair_RegrowHair
            category:"Hair and Fur" 
            internalcategory:"Hair" 
            tooltip:"ͷ"
            buttontext:"ͷ"
(
   on execute do
   (
      if $ != undefined then
      (
         for obj in $ do 
		 (
			--modifier = getActiveHairMod()
			
			currentModifier = undefined			
			if getCommandPanelTaskMode() == #modify then
			(
				modifier = modPanel.getCurrentObject()
				if modifier != undefined then
				(
					if isKindOf modifier HairMod == true then
					(
						currentModifier = modifier
					)		
				)	
			)
			
			if currentModifier != undefined then currentModifier.RegrowHair instance:obj
			break
		 )
      )
   )
)

macroScript Hair_ClearHairInstanceMesh
            category:"Hair and Fur" 
            internalcategory:"Hair" 
            tooltip:"ͷʵ"
            buttontext:"ͷʵ"
(
   on execute do
   (
      if $ != undefined then
      (
         for obj in $ do 
		 (
			--modifier = getActiveHairMod()

			currentModifier = undefined			
			if getCommandPanelTaskMode() == #modify then
			(
				modifier = modPanel.getCurrentObject()
				if modifier != undefined then
				(
					if isKindOf modifier HairMod == true then
					(
						currentModifier = modifier
					)		
				)	
			)

			if currentModifier != undefined then currentModifier.ClearInstance()
			break
		 )
      )
   )
)
