/*
Freeze Transform MacroScript File



Author :   Frederick Ruff

Revision History:
	
	Dec 1 2000, created
	
	Aug 22 2003, Larry Minton
	
	12 dec 2003, Pierre-Felix Breton, 
		added product switcher: this macroscript file can be shared with all Discreet products


 
This script adds tools for freezing a transform
This is done via adding a second controller to the controllers stack.
--***********************************************************************************************
-- MODIFY THIS AT YOUR OWN RISK
*/
macroScript FreezeTransform
enabledIn:#("max", "viz") --pfb: 2003.12.12 added product switch
	ButtonText:"任"  	
	Category:"Animation Tools"  	
	internalCategory:"Animation Tools"  	
	Tooltip:"任"  
( 	
	fn FreezeTransform = 	
	( 		
		local Obj = Selection as array 		
		suspendEditing which:#motion
		for i = 1 to Obj.count do 		
		( 
			Try
			(	
				local CurObj = Obj[i] 	
	
				-- freeze rotation		
				CurObj.rotation.controller = Euler_Xyz() 		
				CurObj.rotation.controller = Rotation_list() 			
				CurObj.rotation.controller.available.controller = Euler_xyz() 		
				
				/* "Localization on" */  
			
				CurObj.rotation.controller.setname 1 "ת" 		
				CurObj.rotation.controller.setname 2 "ŷ XYZ" 		
			
				/* "Localization off" */  
				
				CurObj.rotation.controller.SetActive 2 		
	
				-- freeze position
				CurObj.position.controller = Bezier_Position() 			
				CurObj.position.controller = position_list() 			
				CurObj.position.controller.available.controller = Position_XYZ() 	
	
				/* "Localization on" */  
						
				CurObj.position.controller.setname 1 "λ" 	
				CurObj.position.controller.setname 2 "λ XYZ" 			
				
				/* "Localization off" */  
				
				CurObj.position.controller.SetActive 2 		
	
				-- position to zero
				CurObj.Position.controller[2].x_Position = 0
				CurObj.Position.controller[2].y_Position = 0
				CurObj.Position.controller[2].z_Position = 0
			)	
			/* "Localization on" */  
					
			Catch( messagebox "ı任ʱ˹ϡ" title:"任")
					
			/* "Localization off" */  	
		)
		resumeEditing which:#motion
	)
	
	/* "Localization on" */  
	
	if querybox "任װһ\nʧȥӦЩԼ򶯻\n\nע⣺ʹá任㡱ʹЩ󷵻صñ任\n\n                                                  Ƿ?" title:"任"== true do 
	
	/* "Localization off" */
  
	FreezeTransform()

 )
 -- Set Transform to Zero
MacroScript TransformToZero
enabledIn:#("max", "viz") --pfb: 2003.12.12 added product switch
	ButtonText:"任" 
	Category:"Animation Tools" 
	internalCategory:"Animation Tools" 
	Tooltip:"任" 
(
	fn TransformToZero =
	(
	
		local Obj = Selection as array
		for i = 1 to Obj.count do
		(
			Try
			(
				local CurObj = Obj[i]
				CurObj.Position.controller[2].x_Position = 0
				CurObj.Position.controller[2].y_Position = 0
				CurObj.Position.controller[2].z_Position = 0
				
				CurObj.rotation.controller[2].x_rotation = 0
				CurObj.rotation.controller[2].y_rotation = 0
				CurObj.rotation.controller[2].z_rotation = 0	
			)
			/* "Localization on" */  
			
			Catch( messagebox "֮һı任δᡣ" title:"任")
			
			/* "Localization off" */  	
		)
		select Obj
	)

	TransformToZero()
)
 -- Freeze Rotation Only
 macroScript FreezeRotation
enabledIn:#("max", "viz") --pfb: 2003.12.12 added product switch
	ButtonText:"ת"  	
	Category:"Animation Tools"  	
	internalCategory:"Animation Tools"  	
	Tooltip:"ת"  
( 	
	fn FreezeRotation = 	
	( 		
		local Obj = Selection as array 		
		for i = 1 to Obj.count do 		
		( 	
			Try
			(		
				local CurObj = Obj[i] 			
				CurObj.rotation.controller = Euler_Xyz() 		
				CurObj.rotation.controller = Rotation_list() 		
				
				/* "Localization on" */
	  
				CurObj.rotation.controller.setname 1 "ʼ" 		
				CurObj.rotation.controller.available.controller = Euler_xyz() 		
				CurObj.rotation.controller.setname 1 "ʼ" 		
				CurObj.rotation.controller.setname 2 "ؼ֡ XYZ" 		
				CurObj.rotation.controller.SetActive 2 		
				
				/* "Localization off" */  
			)
			
			/* "Localization on" */  
			
			Catch( messagebox "תʱ˹ϡ" title:"任")
			
			/* "Localization off" */  	
		) 		
		select Obj 
	) 
	
	FreezeRotation()
 )
 
 -- Freeze Position only
macroScript FreezePosition
enabledIn:#("max", "viz") --pfb: 2003.12.12 added product switch
	ButtonText:"λ"  	
	Category:"Animation Tools"  	
	internalCategory:"Animation Tools"  	
	Tooltip:"λ"  
( 	
	fn FreezePosition = 	
	( 		
		local Obj = Selection as array 		
		for i = 1 to Obj.count do 		
		(
			Try
			(
				local CurObj = Obj[i] 	

				-- freeze position		
				CurObj.position.controller = Bezier_Position() 			
				CurObj.position.controller = position_list() 			
				
				/* "Localization on" */
	  
				CurObj.position.controller.setname 1 "ʼ" 			
				CurObj.position.controller.available.controller = Position_XYZ() 						
				CurObj.position.controller.setname 2 "ؼ֡ XYZ" 			
				CurObj.position.controller.SetActive 2 		
			
				/* "Localization off" */  	
				
				-- position to zero
				CurObj.Position.controller[2].x_Position = 0
				CurObj.Position.controller[2].y_Position = 0
				CurObj.Position.controller[2].z_Position = 0
			)
			
			/* "Localization on" */  
			
			Catch( messagebox "λʱ˹ϡ" title:"任")
			
			/* "Localization off" */  	
		) 		
		select Obj 	
	) 
	
	FreezePosition()
) 

--Set Rotation to Zero
MacroScript RotationToZero
enabledIn:#("max", "viz") --pfb: 2003.12.12 added product switch
	ButtonText:"ת" 
	Category:"Animation Tools" 
	internalCategory:"Animation Tools" 
	Tooltip:"ת" 
(
	fn RotationToZero =
	(
		local Obj = Selection as array
		for i = 1 to Obj.count do
		(
			Try
			(
				local CurObj = Obj[i]
				CurObj.rotation.controller[2].x_rotation = 0
				CurObj.rotation.controller[2].y_rotation = 0
				CurObj.rotation.controller[2].z_rotation = 0	
			)
			
			/* "Localization on" */  
	
			Catch( messagebox "One of the object's rotation was never frozen." title:"任")
		
			/* "Localization off" */  
		)
		select Obj
	)
	
	RotationToZero()
)

-- Position To Zero
MacroScript PositionToZero
enabledIn:#("max", "viz") --pfb: 2003.12.12 added product switch
	ButtonText:"λõ" 
	Category:"Animation Tools" 
	internalCategory:"Animation Tools" 
	Tooltip:"λõ" 
(
	fn PositionToZero =
	(
	
		local Obj = Selection as array
		for i = 1 to Obj.count do
		(
			Try
			(
				local CurObj = Obj[i]
				CurObj.Position.controller[2].x_Position = 0
				CurObj.Position.controller[2].y_Position = 0
				CurObj.Position.controller[2].z_Position = 0
			)
			/* "Localization on" */  
			
			Catch( messagebox "֮һλôδᡣ" title:"任")
			
			/* "Localization off" */  	
		)
		select Obj
	)

	PositionToZero()
)