/*
EditPoly Operations MacroScript File

Created:  		Aug 19 2000
Revision History: 	
	
	Feb 25, 2002, by Steve Anderson - heavily reorganized.
	
	12 dec 2003, Pierre-Felix Breton, 
		added product switcher: this macroscript file can be shared with all Discreet products

	28 May 2004, Steve Anderson
		Added support for Edit Poly modifier to most scripts.

EditPoly operations Macroscript file.

*/
--***********************************************************************************************
-- MODIFY THIS AT YOUR OWN RISK
--

-- *******************************************************************
--  Poly Ops: Selection
-- *******************************************************************

MacroScript EPoly_Shrink
enabledIn:#("max", "viz") --pfb: 2003.12.12 added product switch
ButtonText:""
Category:"Editable Polygon Object" 
internalCategory:"Editable Polygon Object" 
Tooltip:"ѡ()" 
-- Needs Icon
(
	On IsEnabled Return Filters.Is_EPoly()
	On IsVisible Return Filters.Is_EPoly()

	On Execute Do (
		Try (
			local A = Filters.GetModOrObj()
			A.buttonOp #ShrinkSelection
		)
		Catch (MessageBox "ʧ" Title:"α༭")
	)
)

MacroScript EPoly_Grow
enabledIn:#("max", "viz") --pfb: 2003.12.12 added product switch
ButtonText:""
Category:"Editable Polygon Object" 
internalCategory:"Editable Polygon Object" 
Tooltip:"ѡ()" 
-- Needs Icon
(
	On IsEnabled Return Filters.Is_EPoly()
	On IsVisible Return Filters.Is_EPoly()

	On Execute Do (
		Try (
			local A = Filters.GetModOrObj()
			A.buttonOp #GrowSelection
		)
		Catch (MessageBox "ʧ" Title:"α༭")
	)
)

MacroScript EPoly_Select_Loop
enabledIn:#("max", "viz") --pfb: 2003.12.12 added product switch
ButtonText:"ѡѭ"
Category:"Editable Polygon Object" 
internalCategory:"Editable Polygon Object" 
Tooltip:"ѡѭ()" 
-- Needs Icon
(
	On IsEnabled Return Filters.Is_EPolySpecifyLevel #{3..4}
	On IsVisible Return Filters.Is_EPolySpecifyLevel #{3..4}

	On Execute Do (
		Try (
			if subobjectlevel == undefined then max modify mode
			local A = Filters.GetModOrObj()
			A.buttonOp #SelectEdgeLoop
		)
		Catch (MessageBox "ʧ" Title:"α༭")
	)
)

MacroScript EPoly_Select_Ring
enabledIn:#("max", "viz") --pfb: 2003.12.12 added product switch
ButtonText:"ѡ"
Category:"Editable Polygon Object" 
internalCategory:"Editable Polygon Object" 
Tooltip:"ѡ()" 
-- Needs Icon
(
	On IsEnabled Return Filters.Is_EPolySpecifyLevel #{3..4}
	On IsVisible Return Filters.Is_EPolySpecifyLevel #{3..4}

	On Execute Do (
		Try (
			if subobjectlevel == undefined then max modify mode
			local A = Filters.GetModOrObj()
			A.buttonOp #SelectEdgeRing
		)
		Catch (MessageBox "ʧ" Title:"α༭")
	)
)

-- *******************************************************************
--  Poly Ops: Edit Geometry
-- *******************************************************************

MacroScript EPoly_Repeat_Last
enabledIn:#("max", "viz") --pfb: 2003.12.12 added product switch
ButtonText:"ظ"
Category:"Editable Polygon Object" 
internalCategory:"Editable Polygon Object" 
Tooltip:"ظϴβ()" 
-- Needs Icon
(
	On IsEnabled Return Filters.Is_EPoly()
	On IsVisible Return Filters.Is_EPoly()

	On Execute Do
	(
		Try (
			local A = Filters.GetModOrObj()
			A.RepeatLastOperation ()
		)
		Catch (MessageBox "ʧ" Title:"α༭")
	)
)

MacroScript EPoly_Collapse
enabledIn:#("max", "viz") --pfb: 2003.12.12 added product switch
ButtonText:""
Category:"Editable Polygon Object" 
internalCategory:"Editable Polygon Object" 
Tooltip:"()" 
-- Needs Icon
(
	On IsEnabled Return Filters.Is_EPoly()
	On IsVisible Return Filters.Is_EPoly()

	On Execute Do (
		Try (
			local A = Filters.GetModOrObj()
			if (Filters.Is_This_EditPolyMod A) then
			(
				if (subobjectLevel == 1) then (A.ButtonOp #CollapseVertex)
				else if (subobjectLevel>1) and (subobjectLevel<4) then (A.ButtonOp #CollapseEdge)
				else if (subobjectLevel>3) then (A.ButtonOp #CollapseFace)
			)
			else (A.buttonOp #Collapse)
		)
		Catch (MessageBox "ʧ" Title:"α༭")
	)
)

MacroScript EPoly_Attach
enabledIn:#("max", "viz") --pfb: 2003.12.12 added product switch
ButtonText:""
Category:"Editable Polygon Object" 
internalCategory:"Editable Polygon Object" 
Tooltip:"()" 
-- Needs Icon
(
	On IsEnabled Return Filters.Is_EPoly()
	On IsVisible Return Filters.Is_EPoly()
	On IsChecked Do (
		local A = Filters.GetModOrObj()
		(Filters.Is_This_EditPolyMod A) and (A.GetPickMode() == #Attach)
	)

	On Execute Do (
		if subobjectlevel == undefined then max modify mode
		local A = Filters.GetModOrObj()
		A.enterPickMode #Attach
	)
	
	On AltExecute type Do (
		if subobjectlevel == undefined then max modify mode
		local A = Filters.GetModOrObj()
		if (Filters.Is_This_EditPolyObj A) then (A.buttonOp #AttachList)
		else (A.PopupDialog #Attach)
	)
)

MacroScript EPoly_Detach
enabledIn:#("max", "viz") --pfb: 2003.12.12 added product switch
ButtonText:""
Category:"Editable Polygon Object"
internalCategory:"Editable Polygon Object"
Tooltip:"()" 
-- Needs Icon
(
	On IsEnabled Return Filters.Is_EPoly()
	On IsVisible Return Filters.Is_EPoly()

	On Execute Do
	(
		Try (
			local A = Filters.GetModOrObj()
			if (Filters.Is_This_EditPolyObj A) then (
				if (A.GetMeshSelLevel() != #Object) then $.EditablePoly.buttonOp #Detach
			) else (
				if (subobjectlevel == 1) then (A.PopupDialog #DetachVertex)
				else if (subobjectLevel > 1) then (A.PopupDialog #DetachFace)
			)
		)
		Catch(MessageBox "ʧ" Title:"α༭")
	)
)

MacroScript EPoly_SlicePlane
enabledIn:#("max", "viz") --pfb: 2003.12.12 added product switch
ButtonText:"Ƭƽ"
Category:"Editable Polygon Object" 
internalCategory:"Editable Polygon Object" 
Tooltip:"Ƭƽ()" 
-- Needs Icon
(
	On IsEnabled Return Filters.Is_EPolySpecifyLevel #{2..6}
	On IsVisible Return Filters.Is_EPolySpecifyLevel #{2..6}
	On IsChecked Return Filters.Is_EPoly_SliceMode()

	On Execute Do (
		Try	(
			If SubObjectLevel == undefined then Max Modify Mode
			local A = Filters.GetModOrObj()
			A.toggleCommandMode #SlicePlane
		)
		Catch(MessageBox "ʧ" Title:"α༭")
	)
)

MacroScript EPoly_Slice
enabledIn:#("max", "viz") --pfb: 2003.12.12 added product switch
ButtonText:"Ƭ"
Category:"Editable Polygon Object" 
internalCategory:"Editable Polygon Object" 
Tooltip:"Ƭ()" 
-- Needs Icon
(
	On IsEnabled Return (Filters.Is_EPoly_SliceMode())
	On IsVisible Return (Filters.Is_EPoly_SliceMode())

	On Execute Do (
		Try	(
			local A = Filters.GetModOrObj()
			if (A.inSlicePlaneMode ()) then (
				if (Filters.Is_This_EditPolyMod A) then (A.CommitAndRepeat())
				else (A.buttonOp #Slice)
			)
		)
		Catch(MessageBox "ʧ" Title:"α༭")
	)
)

MacroScript EPoly_resetPlane
enabledIn:#("max", "viz") --pfb: 2003.12.12 added product switch
ButtonText:"ƽ"
Category:"Editable Polygon Object" 
internalCategory:"Editable Polygon Object" 
Tooltip:"ƽ()" 
-- Needs Icon
(
	On IsEnabled Return (Filters.Is_EPoly_SliceMode())
	On IsVisible Return (Filters.Is_EPoly_SliceMode())

	On Execute Do (
		Try	(
			If SubObjectLevel == undefined then Max Modify Mode
			local A = Filters.GetModOrObj()
			A.buttonOp #ResetSlicePlane
		)
		Catch(MessageBox "ʧ" Title:"α༭")
	)
)

MacroScript EPoly_Quickslice
enabledIn:#("max", "viz") --pfb: 2003.12.12 added product switch
ButtonText:"Ƭ"
Category:"Editable Polygon Object" 
internalCategory:"Editable Polygon Object" 
Tooltip:"Ƭ()" 
-- Needs Icon
(
	On IsEnabled Return Filters.Is_EPoly()
	On IsVisible Return Filters.Is_EPoly()
	On IsChecked Do (
		try (
			local A = Filters.GetModOrObj()
			(Filters.Is_This_EditPolyMod A) and (A.GetCommandMode()==#Quickslice)
		)
		catch ( false )
	)

	On Execute Do (
		Try	(
			If SubObjectLevel == undefined then Max Modify Mode
			local A = Filters.GetModOrObj()
			A.ToggleCommandMode #Quickslice
		)
		Catch(MessageBox "ʧ" Title:"α༭")
	)
)

MacroScript EPoly_Cut
enabledIn:#("max", "viz") --pfb: 2003.12.12 added product switch
ButtonText:""
Category:"Editable Polygon Object" 
internalCategory:"Editable Polygon Object" 
Tooltip:"()" 
-- Needs Icon
(
	On IsEnabled Return Filters.Is_EPoly()
	On IsVisible Return Filters.Is_EPoly()
	On IsChecked Do (
		try (
			local A = Filters.GetModOrObj()
			(Filters.Is_This_EditPolyMod A) and (A.GetCommandMode()==#Cut)
		)
		catch ( false )
	)


	On Execute Do (
		Try	(
			If SubObjectLevel == undefined then Max Modify Mode
			local A = Filters.GetModOrObj()
			if (Filters.Is_This_EditPolyMod A) then (A.ToggleCommandMode #Cut)
			else (A.toggleCommandMode #CutVertex)	-- (Really a general Cut mode.)
		)
		Catch(MessageBox "ʧ" Title:"α༭")
	)
)

MacroScript EPoly_Meshsmooth
enabledIn:#("max", "viz") --pfb: 2003.12.12 added product switch
ButtonText:"ƽ"
Category:"Editable Polygon Object" 
internalCategory:"Editable Polygon Object" 
Tooltip:"ƽ()" 
-- Needs Icon
(
	On IsEnabled Return Filters.Is_EPoly()
	On IsVisible Return Filters.Is_EPoly()

	On Execute Do (
		Try	(
			If SubObjectLevel == undefined then Max Modify Mode
			else
			(
				local A = Filters.GetModOrObj()
				A.buttonOp #MeshSmooth
			)
		)
		Catch(MessageBox "ʧ" Title:"α༭")
	)
	On AltExecute type Do (
		Try (
			local A = Filters.GetModOrObj()
			A.popupDialog #MeshSmooth
		)
		Catch(MessageBox "ʧ" Title:"α༭")
	)
)

MacroScript EPoly_Tessellate
enabledIn:#("max", "viz") --pfb: 2003.12.12 added product switch
ButtonText:"ϸ"
Category:"Editable Polygon Object" 
internalCategory:"Editable Polygon Object" 
Tooltip:"ϸ()" 
-- Needs Icon
(
	On IsEnabled Return Filters.Is_EPoly()
	On IsVisible Return Filters.Is_EPoly()

	On Execute Do (
		Try	(
			If SubObjectLevel == undefined then Max Modify Mode
			else
			(
				local A = Filters.GetModOrObj()
				A.buttonOp #Tessellate
			)
		)
		Catch(MessageBox "ʧ" Title:"α༭")
	)
	On AltExecute type Do (
		Try (
			local A = Filters.GetModOrObj()
			A.popupDialog #Tessellate
		)
		Catch(MessageBox "ʧ" Title:"α༭")
	)
)

MacroScript EPoly_Make_Planar
enabledIn:#("max", "viz") --pfb: 2003.12.12 added product switch
ButtonText:"ƽ"
Category:"Editable Polygon Object" 
internalCategory:"Editable Polygon Object" 
Tooltip:"ƽ()" 
-- Needs Icon
(
	On IsEnabled Return Filters.Is_EPolySpecifyLevel #{2..6}	-- anything but object
	On IsVisible Return Filters.Is_EPolySpecifyLevel #{2..6}	-- anything but object

	On Execute Do (
		If SubObjectLevel == undefined then Max Modify Mode
		Try (
			local A = Filters.GetModOrObj()
			A.buttonOp #MakePlanar
		)
		Catch(MessageBox "ʧ" Title:"α༭")
	)
)

MacroScript EPoly_View_Align
enabledIn:#("max", "viz") --pfb: 2003.12.12 added product switch
ButtonText:"ͼ"
Category:"Editable Polygon Object" 
internalCategory:"Editable Polygon Object" 
Tooltip:"ͼ()" 
-- Needs Icon
(
	On IsEnabled Return Filters.Is_EPoly()
	On IsVisible Return Filters.Is_EPoly()

	On Execute Do (
		Try (
			local A = Filters.GetModOrObj()
			A.buttonOp #AlignView
		)
		Catch(MessageBox "ʧ" Title:"α༭")
	)

)

MacroScript EPoly_Grid_Align
enabledIn:#("max", "viz") --pfb: 2003.12.12 added product switch
ButtonText:"դ"
Category:"Editable Polygon Object" 
internalCategory:"Editable Polygon Object" 
Tooltip:"դ()" 
-- Needs Icon
(
	On IsEnabled Return Filters.Is_EPoly()
	On IsVisible Return Filters.Is_EPoly()

	On Execute Do (
		Try (
			local A = Filters.GetModOrObj()
			A.buttonOp #AlignGrid
		)
		Catch(MessageBox "ʧ" Title:"α༭")
	)
)

MacroScript EPoly_Hide
enabledIn:#("max", "viz") --pfb: 2003.12.12 added product switch
ButtonText:""
Category:"Editable Polygon Object" 
internalCategory:"Editable Polygon Object" 
Tooltip:"()" 
-- Needs Icon
(
	-- Active in Vertex, Face, Element levels:
	On IsEnabled Return Filters.Is_EPolySpecifyLevel #{2,5..6}
	On IsVisible Return Filters.Is_EPolySpecifyLevel #{2,5..6}

	On Execute Do (
		Try(
			local A = Filters.GetModOrObj()
			if (Filters.Is_This_EditPolyMod A) then
			(
				if (subobjectlevel == 1) then A.ButtonOp #HideVertex
				else A.ButtonOp #HideFace
			)
			else A.buttonOp #HideSelection
		)
		Catch(MessageBox "ʧ" Title:"α༭")
	)

)

MacroScript EPoly_Hide_Unselected
enabledIn:#("max", "viz") --pfb: 2003.12.12 added product switch
ButtonText:"δѡ"
Category:"Editable Polygon Object" 
internalCategory:"Editable Polygon Object" 
Tooltip:"δѡ()" 
-- Needs Icon
(
	-- Active in Vertex, Face, Element levels:
	On IsEnabled Return Filters.Is_EPolySpecifyLevel #{2,5..6}
	On IsVisible Return Filters.Is_EPolySpecifyLevel #{2,5..6}

	On Execute Do (
		Try(
			local A = Filters.GetModOrObj()
			if (Filters.Is_This_EditPolyMod A) then
			(
				if (subobjectlevel == 1) then A.ButtonOp #HideUnselectedVertex
				else A.ButtonOp #HideUnselectedFace
			)
			else A.buttonOp #HideUnselected
		)
		Catch(MessageBox "ʧ" Title:"α༭")
	)

)

MacroScript EPoly_UnHide
enabledIn:#("max", "viz") --pfb: 2003.12.12 added product switch
ButtonText:"ȫȡ"
Category:"Editable Polygon Object" 
internalCategory:"Editable Polygon Object" 
Tooltip:"ȫȡ()" 
-- Needs Icon
(
	-- Active in Vertex, Face, Element levels:
	On IsEnabled Return Filters.Is_EPolySpecifyLevel #{2,5..6}
	On IsVisible Return Filters.Is_EPolySpecifyLevel #{2,5..6}

	On Execute Do (
		Try (
			local A = Filters.GetModOrObj()
			if (Filters.Is_This_EditPolyMod A) then
			(
				if (subobjectlevel == 1) then A.ButtonOp #UnhideAllVertex
				else A.ButtonOp #UnhideAllFace
			)
			else A.buttonOp #UnhideAll
		)
		Catch(MessageBox "ʧ" Title:"α༭")
	)
)


-- *******************************************************************
--  Poly Ops:  Generalized versions of SO-specific operations
--             This section lets users simply call "Extrude",
--			   "Chamfer", etc, and it uses the current SO mode.
-- *******************************************************************

MacroScript EPoly_Create
enabledIn:#("max", "viz") --pfb: 2003.12.12 added product switch
ButtonText:""
Category:"Editable Polygon Object" 
internalCategory:"Editable Polygon Object" 
Tooltip:"()" 
-- Needs Icon
(
	On IsEnabled Return Filters.Is_EPoly()
	On IsVisible Return Filters.Is_EPoly()
	On IsChecked Do (
		try (
			local A = Filters.GetModOrObj()
			if (Filters.Is_This_EditPolyMod A) then
			(
				local mode = A.GetCommandMode
				(mode == #CreateVertex) or (mode == #CreateEdge) or (mode == #CreateFace)
			)
			else false
		)
		catch ( false )
	)

	On Execute Do (
		Try	(
			If SubObjectLevel == undefined then Max Modify Mode
			local A = Filters.GetModOrObj()
			local msl = A.GetMeshSelLevel ()
			if msl == #vertex then (A.toggleCommandMode #CreateVertex)
			else (
				if msl == #edge then (A.toggleCommandMode #CreateEdge)
				else (A.toggleCommandMode #CreateFace)
			)
		)
		Catch(MessageBox "ʧ" Title:"α༭")
	)
)

MacroScript EPoly_Remove
enabledIn:#("max", "viz") --pfb: 2003.12.12 added product switch
ButtonText:"ɾ"
Category:"Editable Polygon Object" 
internalCategory:"Editable Polygon Object" 
Tooltip:"ɾ()" 
-- Needs Icon
(
	-- Active in Vertex, Edge levels:
	On IsEnabled Return Filters.Is_EPolySpecifyLevel #{2..3}
	On IsVisible Return Filters.Is_EPolySpecifyLevel #{2..3}

	On Execute Do (
		try (
			if subobjectlevel == undefined then max modify mode
			local A = Filters.GetModOrObj()
			if ((subobjectLevel==1) or (subobjectLevel==2)) then (
				if (Filters.Is_This_EditPolyMod A) then
				(
					if (subobjectLevel == 1) then A.ButtonOp #RemoveVertex
					else A.ButtonOp #RemoveEdge
				)
				else A.buttonOp #Remove
			) else (
				-- Put us in a suitable SO level
				subobjectLevel = 2
			)
		)
		catch (MessageBox "ʧ" Title:"α༭")
	)
)

MacroScript EPoly_InsertVertex
enabledIn:#("max", "viz") --pfb: 2003.12.12 added product switch
ButtonText:"붥"
Category:"Editable Polygon Object" 
internalCategory:"Editable Polygon Object" 
Tooltip:"붥()" 
-- Needs Icon
(
	-- Active in Edge, Border, Face, Element levels:
	On IsEnabled Return Filters.Is_EPolySpecifyLevel #{3..6}
	On IsVisible Return Filters.Is_EPolySpecifyLevel #{3..6}
	On IsChecked Do (
		try (
			local A = Filters.GetModOrObj()
			if (Filters.Is_This_EditPolyMod A) then
			(
				local mode = A.GetCommandMode()
				(mode == #DivideEdge) or (mode == #DivideFace)
			)
			else false
		)
		catch ( false )
	)

	On Execute Do (
		Try	(
			If SubObjectLevel == undefined then Max Modify Mode
			-- default to Edge:
			if subobjectLevel < 2 then subobjectLevel = 2
			local A = Filters.GetModOrObj()
			msl = A.GetMeshSelLevel ()
			if msl == #Edge then (A.toggleCommandMode #DivideEdge)
			if msl == #Face then (A.toggleCommandMode #DivideFace)
		)
		Catch(MessageBox "ʧ" Title:"α༭")
	)
)

MacroScript EPoly_Extrude
enabledIn:#("max", "viz") --pfb: 2003.12.12 added product switch
ButtonText:""
Category:"Editable Polygon Object" 
internalCategory:"Editable Polygon Object" 
Tooltip:"()" 
-- Needs Icon
(
	-- Active in any SO level:
	On IsEnabled Return Filters.Is_EPolySpecifyLevel #{2..5}
	On IsVisible Return Filters.Is_EPolySpecifyLevel #{2..5}
	On IsChecked Do (
		try (
			local A = Filters.GetModOrObj()
			if (Filters.Is_This_EditPolyMod A) then
			(
				local mode = A.GetCommandMode()
				(mode == #ExtrudeVertex) or (mode == #ExtrudeEdge) or (mode == #ExtrudeFace)
			)
			else false
		)
		catch ( false )
	)

	On Execute Do (
		Try (
			If SubObjectLevel == undefined then Max Modify Mode
			-- default to Face level:
			if subobjectLevel == 0 then subobjectLevel = 4
			if subobjectLevel == 5 then subobjectLevel = 4
			local A = Filters.GetModOrObj()
			msl = A.GetMeshSelLevel ()
			if msl == #vertex then (A.toggleCommandMode #ExtrudeVertex)
			if msl == #edge then (A.toggleCommandMode #ExtrudeEdge)
			if msl == #face then (A.toggleCommandMode #ExtrudeFace)
		)
		Catch(MessageBox "ʧ" Title:"α༭")
	)
	On AltExecute type do (
		Try (
			If SubObjectLevel == undefined then Max Modify Mode
			-- default to Face level:
			if subobjectLevel == 0 then subobjectLevel = 4
			local A = Filters.GetModOrObj()
			if (Filters.Is_This_EditPolyMod A) then
			(
				local level = A.GetMeshSelLevel()
				if (level == #Vertex) then (A.PopupDialog #ExtrudeVertex)
				else if (level == #Edge) then (A.PopupDialog #ExtrudeEdge)
				else if (level == #Face) then (A.PopupDialog #ExtrudeFace)
			)
			else (A.popupDialog #Extrude)
		)
		Catch(MessageBox "ʧ" Title:"α༭")
	)
)

MacroScript EPoly_Chamfer
enabledIn:#("max", "viz") --pfb: 2003.12.12 added product switch
ButtonText:"н"
Category:"Editable Polygon Object" 
internalCategory:"Editable Polygon Object" 
Tooltip:"н()" 
-- Needs Icon
(
	-- Active in Vertex, Edge, Border levels:
	On IsEnabled Return Filters.Is_EPolySpecifyLevel #{2..4}
	On IsVisible Return Filters.Is_EPolySpecifyLevel #{2..4}
	On IsChecked Do (
		try (
			local A = Filters.GetModOrObj()
			if (Filters.Is_This_EditPolyMod A) then
			(
				local mode = A.GetCommandMode()
				(mode == #ChamferVertex) or (mode == #ChamferEdge)
			)
			else false
		)
		catch ( false )
	)

	On Execute Do (
		Try (
			If SubObjectLevel == undefined then Max Modify Mode
			local A = Filters.GetModOrObj()
			-- default to Edge level:
			if subobjectLevel > 3 then subobjectLevel = 2
			if subobjectLevel == 0 then subobjectLevel = 2
			if subobjectLevel == 1 then (A.toggleCommandMode #ChamferVertex)
			else (A.toggleCommandMode #ChamferEdge)
		)
		Catch(MessageBox "ʧ" Title:"α༭")
	)
	On AltExecute type do (
		Try (
			If SubObjectLevel == undefined then Max Modify Mode
			local A = Filters.GetModOrObj()
			-- default to Edge level:
			if subobjectLevel > 3 then subobjectLevel = 2
			if subobjectLevel == 0 then subobjectLevel = 2
			if (Filters.Is_This_EditPolyMod A) then
			(
				if (subobjectLevel == 1) then (A.PopupDialog #ChamferVertex)
				else (A.PopupDialog #ChamferEdge)
			)
			else (A.popupDialog #Chamfer)
		)
		Catch(MessageBox "ʧ" Title:"α༭")
	)
)

MacroScript EPoly_Weld
enabledIn:#("max", "viz") --pfb: 2003.12.12 added product switch
ButtonText:""
Category:"Editable Polygon Object" 
internalCategory:"Editable Polygon Object" 
Tooltip:"()" 
-- Needs Icon
(
	-- Active in Vertex, Edge levels:
	On IsEnabled Return Filters.Is_EPolySpecifyLevel #{2..3}
	On IsVisible Return Filters.Is_EPolySpecifyLevel #{2..3}

	On Execute Do (
		Try (
			if subobjectlevel == undefined then max modify mode
			local A = Filters.GetModOrObj()
			if Filters.Is_This_EditPolyMod A then 
			(
				if (subobjectLevel == 1) then A.ButtonOp #WeldVertex
				else A.buttonOp #WeldEdge
			)
			else A.buttonOp #WeldSelected
		)
		Catch(MessageBox "ʧ" Title:"α༭")
	)

	On AltExecute type do (
		Try (
			If SubObjectLevel == undefined then Max Modify Mode
			local A = Filters.GetModOrObj()
			if Filters.Is_This_EditPolyMod A then
			(
				if (subobjectLevel == 1) then A.PopupDialog #WeldVertex
				else A.popupDialog #WeldEdge
			)
			else A.popupDialog #WeldSelected
		)
		Catch(MessageBox "ʧ" Title:"α༭")
	)
)

MacroScript EPoly_TargetWeld
enabledIn:#("max", "viz") --pfb: 2003.12.12 added product switch
ButtonText:"Ŀ꺸"
Category:"Editable Polygon Object" 
internalCategory:"Editable Polygon Object" 
Tooltip:"Ŀ꺸()" 
-- Needs Icon
(
	-- Active in Vertex, Edge levels:
	On IsEnabled Return Filters.Is_EPolySpecifyLevel #{2..3}
	On IsVisible Return Filters.Is_EPolySpecifyLevel #{2..3}
	On IsChecked Do (
		try (
			local A = Filters.GetModOrObj()
			(Filters.Is_This_EditPolyMod A) and (A.GetCommandMode() == #Weld)
		)
		catch ( false )
	)

	On Execute Do (
		Try	(
			If SubObjectLevel == undefined do (Max Modify Mode)
			local A = Filters.GetModOrObj ()
			A.toggleCommandMode #Weld
		)
		Catch(MessageBox "ʧ" Title:"Poly Target Weld")
	)
)

-- We need two versions of this Connect macro, even though we really want one,
-- because the edge level has an altExecute method and the vertex level doesn't.
-- There's no way as yet to suppress the altExecute icon in vertex level.
-- (Should be something like On IsAltVisible...)

MacroScript EPoly_Connect
enabledIn:#("max", "viz") --pfb: 2003.12.12 added product switch
ButtonText:""
Category:"Editable Polygon Object" 
internalCategory:"Editable Polygon Object" 
Tooltip:"(޶Ի)()" 
-- Needs Icon
(
	-- Active in Vertex, Edge, levels:
	On IsEnabled Return Filters.Is_EPolySpecifyLevel #{2}
	On IsVisible Return Filters.Is_EPolySpecifyLevel #{2}

	On Execute Do (
		if subobjectlevel == undefined then max modify mode
		local A = Filters.GetModOrObj()
		A.buttonOp #ConnectVertices
	)
)

MacroScript EPoly_Connect2
enabledIn:#("max", "viz") --pfb: 2003.12.12 added product switch
ButtonText:""
Category:"Editable Polygon Object" 
internalCategory:"Editable Polygon Object" 
Tooltip:"(жԻ)()" 
-- Needs Icon
(
	-- Active in Vertex, Edge levels:
	On IsEnabled Return Filters.Is_EPolySpecifyLevel #{3}
	On IsVisible Return Filters.Is_EPolySpecifyLevel #{3}

	On Execute Do (
		if subobjectlevel == undefined then max modify mode
		local A = Filters.GetModOrObj()
		A.buttonOp #ConnectEdges
	)

	On AltExecute type do (
		Try (
			If SubObjectLevel == undefined then Max Modify Mode
			local A = Filters.GetModOrObj()
			A.popupDialog #ConnectEdges
		)
		Catch(MessageBox "ʧ" Title:"α༭")
	)
)

-- *******************************************************************
--  Poly Ops:  Vertex specific stuff
-- *******************************************************************

MacroScript EPoly_Break
enabledIn:#("max", "viz") --pfb: 2003.12.12 added product switch
ButtonText:"Ͽ"
Category:"Editable Polygon Object" 
internalCategory:"Editable Polygon Object" 
Tooltip:"Ͽ()" 
-- Needs Icon
(
	On IsEnabled Return Filters.Is_EPolySpecifyLevel #{2}
	On IsVisible Return Filters.Is_EPolySpecifyLevel #{2}

	On Execute Do (
		Try	(
			If SubObjectLevel == undefined then Max Modify Mode
			local A = Filters.GetModOrObj()
			A.buttonOp #BreakVertex
		)
		Catch(MessageBox "ʧ" Title:"α༭")
	)
)

MacroScript EPoly_RemoveIsolatedVerts
enabledIn:#("max", "viz") --pfb: 2003.12.12 added product switch
ButtonText:"ɾ"
Category:"Editable Polygon Object" 
internalCategory:"Editable Polygon Object" 
Tooltip:"ɾ()" 
-- Needs Icon
(
	On IsEnabled Return Filters.Is_EPolySpecifyLevel #{2}
	On IsVisible Return Filters.Is_EPolySpecifyLevel #{2}

	On Execute Do (
		Try	(
			If SubObjectLevel == undefined then Max Modify Mode
			local A = Filters.GetModOrObj()
			A.buttonOp #RemoveIsoVerts
		)
		Catch(MessageBox "ʧ" Title:"α༭")
	)
)

MacroScript EPoly_RemoveIsolatedMapVerts
enabledIn:#("max", "viz") --pfb: 2003.12.12 added product switch
ButtonText:"ɾδʹõͼ"
Category:"Editable Polygon Object" 
internalCategory:"Editable Polygon Object" 
Tooltip:"ɾδʹõͼ()" 
-- Needs Icon
(
	On IsEnabled Return Filters.Is_EPolySpecifyLevel #{2}
	On IsVisible Return Filters.Is_EPolySpecifyLevel #{2}

	On Execute Do (
		Try	(
			If SubObjectLevel == undefined then Max Modify Mode
			local A = Filters.GetModOrObj()
			A.buttonOp #RemoveIsoMapVerts
		)
		Catch(MessageBox "ʧ" Title:"α༭")
	)
)


-- *******************************************************************
-- Poly Ops:  Edit Edges
-- *******************************************************************

MacroScript EPoly_Split
enabledIn:#("max", "viz") --pfb: 2003.12.12 added product switch
ButtonText:"ָ"
Category:"Editable Polygon Object" 
internalCategory:"Editable Polygon Object" 
Tooltip:"ָ()" 
-- Needs Icon
(
	On IsEnabled Return Filters.Is_EPolySpecifyLevel #{3}
	On IsVisible Return Filters.Is_EPolySpecifyLevel #{3}

	On Execute Do (
		Try	(
			If SubObjectLevel == undefined then Max Modify Mode
			if subobjectlevel != 2 then subobjectlevel = 2
			else
			(
				local A = Filters.GetModOrObj()
				A.buttonOp #SplitEdges
			)
		)
		Catch(MessageBox "ʧ" Title:"α༭")
	)
)

MacroScript EPoly_ShapeFromEdges
enabledIn:#("max", "viz") --pfb: 2003.12.12 added product switch
ButtonText:"ͼ"
Category:"Editable Polygon Object" 
internalCategory:"Editable Polygon Object" 
Tooltip:"ͼ()" 
-- Needs Icon
(
	On IsEnabled Return Filters.Is_EPolySpecifyLevel #{3..4}
	On IsVisible Return Filters.Is_EPolySpecifyLevel #{3..4}

	On Execute Do (
		Try	(
			If SubObjectLevel == undefined then Max Modify Mode
			local A = Filters.GetModOrObj()
			if (Filters.Is_This_EditPolyMod A) then (A.PopupDialog #CreateShape)
			else (A.buttonOp #CreateShape)
		)
		Catch(MessageBox "ʧ" Title:"α༭")
	)
)

-- *******************************************************************
-- Poly Ops:  Border specific stuff
-- *******************************************************************

MacroScript EPoly_Cap
enabledIn:#("max", "viz") --pfb: 2003.12.12 added product switch
ButtonText:""
Category:"Editable Polygon Object" 
internalCategory:"Editable Polygon Object" 
Tooltip:"()" 
-- Needs Icon
(
	On IsEnabled Return Filters.Is_EPolySpecifyLevel #{4}
	On IsVisible Return Filters.Is_EPolySpecifyLevel #{4}

	On Execute Do (
		Try	(
			If SubObjectLevel == undefined then Max Modify Mode
			local A = Filters.GetModOrObj()
			A.buttonOp #Cap
		)
		Catch(MessageBox "ʧ" Title:"α༭")
	)
)

-- *******************************************************************
--  Poly Ops: Face specific stuff
-- *******************************************************************

MacroScript EPoly_Bevel
enabledIn:#("max", "viz") --pfb: 2003.12.12 added product switch
ButtonText:""
Category:"Editable Polygon Object" 
internalCategory:"Editable Polygon Object" 
Tooltip:"()" 
-- Needs Icon
(
	On IsEnabled Return Filters.Is_EPolySpecifyLevel #{5}
	On IsVisible Return Filters.Is_EPolySpecifyLevel #{5}
	On IsChecked Do (
		try (
			local A = Filters.GetModOrObj()
			(Filters.Is_This_EditPolyMod A) and (A.GetCommandMode() == #Bevel)
		)
		catch ( false )
	)

	On Execute Do (
		Try (
			If SubObjectLevel == undefined then Max Modify Mode
			local A = Filters.GetModOrObj()
			A.toggleCommandMode #Bevel
		)
		Catch(MessageBox "ʧ" Title:"α༭")
	)
	On AltExecute type do (
		Try (
			If SubObjectLevel == undefined then Max Modify Mode
			local A = Filters.GetModOrObj()
			A.popupDialog #Bevel
		)
		Catch(MessageBox "ʧ" Title:"α༭")
	)
)

MacroScript EPoly_Outline
enabledIn:#("max", "viz") --pfb: 2003.12.12 added product switch
ButtonText:""
Category:"Editable Polygon Object" 
internalCategory:"Editable Polygon Object" 
Tooltip:"()" 
-- Needs Icon
(
	On IsEnabled Return Filters.Is_EPolySpecifyLevel #{5}
	On IsVisible Return Filters.Is_EPolySpecifyLevel #{5}
	On IsChecked Do (
		try (
			local A = Filters.GetModOrObj()
			(Filters.Is_This_EditPolyMod A) and (A.GetCommandMode() == #OutlineFace)
		)
		catch ( false )
	)

	On Execute Do (
		Try (
			If SubObjectLevel == undefined then Max Modify Mode
			local A = Filters.GetModOrObj()
			A.toggleCommandMode #OutlineFace
		)
		Catch(MessageBox "ʧ" Title:"α༭")
	)
	On AltExecute type do (
		Try (
			If SubObjectLevel == undefined then Max Modify Mode
			local A = Filters.GetModOrObj()
			A.popupDialog #Outline
		)
		Catch(MessageBox "ʧ" Title:"α༭")
	)
)

MacroScript EPoly_Inset
enabledIn:#("max", "viz") --pfb: 2003.12.12 added product switch
ButtonText:""
Category:"Editable Polygon Object" 
internalCategory:"Editable Polygon Object" 
Tooltip:"()" 
-- Needs Icon
(
	On IsEnabled Return Filters.Is_EPolySpecifyLevel #{5}
	On IsVisible Return Filters.Is_EPolySpecifyLevel #{5}
	On IsChecked Do (
		try (
			local A = Filters.GetModOrObj()
			(Filters.Is_This_EditPolyMod A) and (A.GetCommandMode() == #InsetFace)
		)
		catch ( false )
	)

	On Execute Do (
		Try (
			If SubObjectLevel == undefined then Max Modify Mode
			local A = Filters.GetModOrObj()
			A.toggleCommandMode #InsetFace
		)
		Catch(MessageBox "ʧ" Title:"α༭")
	)
	On AltExecute type do (
		Try (
			If SubObjectLevel == undefined then Max Modify Mode
			local A = Filters.GetModOrObj()
			A.popupDialog #Inset
		)
		Catch(MessageBox "ʧ" Title:"α༭")
	)
)

MacroScript EPoly_Retriangulate
enabledIn:#("max", "viz") --pfb: 2003.12.12 added product switch
ButtonText:"»"
Category:"Editable Polygon Object" 
internalCategory:"Editable Polygon Object" 
Tooltip:"»()" 
-- Needs Icon
(
	On IsEnabled Return Filters.Is_EPolySpecifyLevel #{5..6}
	On IsVisible Return Filters.Is_EPolySpecifyLevel #{5..6}

	On Execute Do (
		Try	(
			If SubObjectLevel == undefined then Max Modify Mode
			if subobjectlevel < 4 then subobjectlevel = 4
			else
			(
				local A = Filters.GetModOrObj()
				A.buttonOp #Retriangulate
			)
		)
		Catch(MessageBox "ʧ" Title:"α༭")
	)
)

MacroScript EPoly_Flip
enabledIn:#("max", "viz") --pfb: 2003.12.12 added product switch
ButtonText:"ת"
Category:"Editable Polygon Object" 
internalCategory:"Editable Polygon Object" 
Tooltip:"ת()" 
-- Needs Icon
(
	On IsEnabled Return Filters.Is_EPolySpecifyLevel #{5..6}
	On IsVisible Return Filters.Is_EPolySpecifyLevel #{5..6}

	On Execute Do
	(
		If SubObjectLevel == undefined then Max Modify Mode
		-- default to Element level here:
		If SubObjectLevel < 4 then SubObjectLevel = 5
		else (
			Try(
				local A = Filters.GetModOrObj()
				if (Filters.Is_This_EditPolyMod A) then
				(
					if (subobjectLevel == 4) then A.buttonOp #FlipFace
					else A.ButtonOp #FlipElement
				)
				else A.buttonOp #FlipNormals
			)
			Catch(MessageBox "ʧ" Title:"α༭")
		)
	)

)

MacroScript EPoly_Hinge
enabledIn:#("max", "viz") --pfb: 2003.12.12 added product switch
ButtonText:"ӱת"
Category:"Editable Polygon Object" 
internalCategory:"Editable Polygon Object" 
Tooltip:"ӱת()" 
-- Needs Icon
(
	On IsEnabled Return Filters.Is_EPolySpecifyLevel #{5}
	On IsVisible Return Filters.Is_EPolySpecifyLevel #{5}
	On IsChecked Do (
		try (
			local A = Filters.GetModOrObj()
			(Filters.Is_This_EditPolyMod A) and (A.GetCommandMode() == #HingeFromEdge)
		)
		catch ( false )
	)

	On Execute Do (
		Try (
			If SubObjectLevel == undefined then Max Modify Mode
			local A = Filters.GetModOrObj()
			A.toggleCommandMode #HingeFromEdge
		)
		Catch(MessageBox "ʧ" Title:"α༭")
	)
	On AltExecute type do (
		Try (
			If SubObjectLevel == undefined then Max Modify Mode
			local A = Filters.GetModOrObj()
			A.popupDialog #HingeFromEdge
		)
		Catch(MessageBox "ʧ" Title:"α༭")
	)
)

MacroScript EPoly_Extrude_Along_Spline
enabledIn:#("max", "viz") --pfb: 2003.12.12 added product switch
ButtonText:"߼"
Category:"Editable Polygon Object"
internalCategory:"Editable Polygon Object" 
Tooltip:"߼()" 
-- Needs Icon
(
	On IsEnabled Return Filters.Is_EPolySpecifyLevel #{5}
	On IsVisible Return Filters.Is_EPolySpecifyLevel #{5}

	On Execute Do (
		Try (
			If SubObjectLevel == undefined then Max Modify Mode
			local A = Filters.GetModOrObj()
			A.enterPickMode #pickShape
		)
		Catch(MessageBox "ʧ" Title:"α༭")
	)
	On AltExecute type do (
		Try (
			If SubObjectLevel == undefined then Max Modify Mode
			local A = Filters.GetModOrObj ()
			A.popupDialog #ExtrudeAlongSpline
		)
		Catch(MessageBox "ʧ" Title:"α༭")
	)
)

MacroScript EPoly_EditTri
enabledIn:#("max", "viz") --pfb: 2003.12.12 added product switch
ButtonText:"༭ʷ"
Category:"Editable Polygon Object" 
internalCategory:"Editable Polygon Object" 
Tooltip:"༭ʷ()" 
-- Needs Icon
(
	-- active in Edge, Border, Face, Element levels:
	On IsEnabled Return Filters.Is_EPolySpecifyLevel #{3..6}
	On IsVisible Return Filters.Is_EPolySpecifyLevel #{3..6}
	On IsChecked Do (
		try (
			local A = Filters.GetModOrObj()
			(Filters.Is_This_EditPolyMod A) and (A.GetCommandMode() == #EditTriangulation)
		)
		catch ( false )
	)

	On Execute Do (
		Try	(
			If SubObjectLevel == undefined then Max Modify Mode
			if subobjectlevel < 2 then subobjectlevel = 4
			local A = Filters.GetModOrObj()
			A.toggleCommandMode #EditTriangulation
		)
		Catch(MessageBox "ʧ" Title:"α༭")
	)
)

MacroScript EPoly_ClearSmoothing
enabledIn:#("max", "viz") --pfb: 2003.12.12 added product switch
ButtonText:"ƽ"
Category:"Editable Polygon Object" 
internalCategory:"Editable Polygon Object" 
Tooltip:"ƽ()" 
-- Needs Icon
(
	On IsEnabled Return Filters.Is_EPolySpecifyLevel #{5..6}
	On IsVisible Return Filters.Is_EPolySpecifyLevel #{5..6}

	On Execute Do (
		Try	(
			If SubObjectLevel == undefined then Max Modify Mode
			if subobjectlevel < 4 then subobjectlevel = 4
			else (
				local A = Filters.GetModOrObj()
				if (Filters.Is_This_EditPolyObj A) then A.buttonOp #ClearSmoothingGroups
				else (
					A.smoothingGroupsToClear = -1
					A.smoothingGroupsToSet = 0
					A.ButtonOp #SetSmooth
				)
			)
		)
		Catch(MessageBox "ʧ" Title:"α༭")
	)
)

MacroScript EPoly_Autosmooth
enabledIn:#("max", "viz") --pfb: 2003.12.12 added product switch
ButtonText:"Զƽ"
Category:"Editable Polygon Object" 
internalCategory:"Editable Polygon Object" 
Tooltip:"Զƽ()" 
-- Needs Icon
(
	On IsEnabled Return Filters.Is_EPolySpecifyLevel #{5..6}
	On IsVisible Return Filters.Is_EPolySpecifyLevel #{5..6}

	On Execute Do (
		Try (
			If SubObjectLevel == undefined then Max Modify Mode
			if subobjectlevel < 4 then subobjectlevel = 4
			else (
				local A = Filters.GetModOrObj()
				A.ButtonOp #Autosmooth
			)
		)
		Catch(MessageBox "ʧ" Title:"α༭")
	)

)

-- *******************************************************************
--  Poly Ops: Parameter toggles
-- *******************************************************************

MacroScript EPoly_NURMS_Toggle
enabledIn:#("max", "viz") --pfb: 2003.12.12 added product switch
ButtonText:"NURMS л"
Category:"Editable Polygon Object" 
internalCategory:"Editable Polygon Object" 
Tooltip:"NURMS л()" 
-- Needs Icon
(
	On IsEnabled Return Filters.Is_EditPoly()
	On IsVisible Return Filters.Is_EditPoly()
	On IsChecked Do (
		Try ( $.surfSubdivide )
		Catch ( false )
	)

	On Execute Do
	(
		
		Try	
		(
		$.surfSubdivide = (not $.surfSubdivide)
		)
		Catch(MessageBox "ʧ" Title:"α༭")
	)

)

MacroScript EPoly_SoftSel_Toggle
enabledIn:#("max", "viz") --pfb: 2003.12.12 added product switch
ButtonText:"ѡ"
Category:"Editable Polygon Object" 
internalCategory:"Editable Polygon Object" 
Tooltip:"ѡл()" 
-- Needs Icon
(
	On IsEnabled Return Filters.Is_EPoly()
	On IsVisible Return Filters.Is_EPoly()
	On IsChecked Do (
		Try (
			local A = Filters.GetModOrObj()
			A.useSoftSel
		)
		Catch ( false )
	)

	On Execute Do
	(
		
		Try	
		(
			local A = Filters.GetModOrObj()
			A.useSoftSel = (not A.useSoftSel)
		)
		Catch(MessageBox "ʧ" Title:"α༭")
	)

)

MacroScript EPoly_IgnoreBack_Toggle
enabledIn:#("max", "viz") --pfb: 2003.12.12 added product switch
ButtonText:"Ա"
Category:"Editable Polygon Object" 
internalCategory:"Editable Polygon Object" 
Tooltip:"Ա()" 
-- Needs Icon
(
	On IsEnabled Return Filters.Is_EPoly()
	On IsVisible Return Filters.Is_EPoly()
	On IsChecked Do (
		Try (
			local A = Filters.GetModOrObj()
			A.ignoreBackfacing
		)
		Catch ( false )
	)

	On Execute Do (
		Try	(
			local A = Filters.GetModOrObj()
			A.ignoreBackfacing = (not A.ignoreBackfacing)
		)
		Catch(MessageBox "ʧ" Title:"α༭")
	)

)

MacroScript EPoly_Toggle_Edge_Constraint
enabledIn:#("max", "viz") --pfb: 2003.12.12 added product switch
ButtonText:"Լ"
Category:"Editable Polygon Object" 
internalCategory:"Editable Polygon Object" 
Tooltip:"Լл()" 
-- Needs Icon
(
	On IsEnabled Return Filters.Is_EPoly()
	On IsVisible Return Filters.Is_EPoly()
	On IsChecked Do (
		Try (
			local A = Filters.GetModOrObj()
			(A.constrainType == 1)
		)
		Catch ( false )
	)

	On Execute Do (
		Try (
			local A = Filters.GetModOrObj()
			if A.constrainType == 1 then (A.constrainType = 0)
			else (A.constrainType = 1)
		)
		Catch (MessageBox "ʧ" Title:"α༭")
	)
)

MacroScript EPoly_Toggle_Face_Constraint
enabledIn:#("max", "viz") --pfb: 2003.12.12 added product switch
ButtonText:"Լ"
Category:"Editable Polygon Object" 
internalCategory:"Editable Polygon Object" 
Tooltip:"Լл()" 
-- Needs Icon
(
	On IsEnabled Return Filters.Is_EPoly()
	On IsVisible Return Filters.Is_EPoly()
	On IsChecked Do (
		Try (
			local A = Filters.GetModOrObj()
			(A.constrainType == 2)
		)
		Catch ( false )
	)

	On Execute Do (
		Try (
			local A = Filters.GetModOrObj()
			if A.constrainType == 2 then (A.constrainType = 0)
			else (A.constrainType = 2)
		)
		Catch (MessageBox "ʧ" Title:"α༭")
	)
)

-- This isn't a parameter toggle, exactly, but it acts similar, so we put it here
MacroScript EPoly_Toggle_Shaded_Faces
enabledIn:#("max", "viz") --pfb: 2003.12.12 added product switch
ButtonText:"ɫ"
Category:"Editable Polygon Object" 
internalCategory:"Editable Polygon Object" 
Tooltip:"ɫл()" 
-- Needs Icon
(
	On IsEnabled Return Filters.Is_EPoly()
	On IsVisible Return Filters.Is_EPoly()

	On Execute Do (
		Try (
			if subobjectLevel == undefined then Max Modify Mode
			if subobjectLevel != 0 then (
				local A = Filters.GetModOrObj()
				A.buttonOp #ToggleShadedFaces
			)
		)
		Catch (MessageBox "ʧ" Title:"α༭")
	)
)

-- *******************************************************************
--  Poly Ops: Selection conversion
-- *******************************************************************

MacroScript EPoly_Convert_Sel_To_Vertex
enabledIn:#("max", "viz") --pfb: 2003.12.12 added product switch
ButtonText:"ת"
Category:"Editable Polygon Object" 
internalCategory:"Editable Polygon Object" 
Tooltip:"ת()" 
-- Needs Icon
(
	On IsEnabled Return Filters.Is_EPolySpecifyLevel #{3..6}
	On IsVisible Return Filters.Is_EPolySpecifyLevel #{3..6}

	On Execute Do (
		Try (
			if subobjectLevel == undefined then Max Modify Mode
			local A = Filters.GetModOrObj()
			A.ConvertSelection #CurrentLevel #Vertex
			subobjectLevel = 1
		)
		Catch (MessageBox "ʧ" Title:"α༭")
	)
)

MacroScript EPoly_Convert_Sel_To_Edge
enabledIn:#("max", "viz") --pfb: 2003.12.12 added product switch
ButtonText:"ת"
Category:"Editable Polygon Object" 
internalCategory:"Editable Polygon Object" 
Tooltip:"ת()" 
-- Needs Icon
(
	On IsEnabled Return Filters.Is_EPolySpecifyLevel #{2,5..6}
	On IsVisible Return Filters.Is_EPolySpecifyLevel #{2,5..6}

	On Execute Do (
		Try (
			if subobjectLevel == undefined then Max Modify Mode
			local A = Filters.GetModOrObj()
			A.ConvertSelection #CurrentLevel #Edge
			subobjectLevel = 2
		)
		Catch (MessageBox "ʧ" Title:"α༭")
	)
)

MacroScript EPoly_Convert_Sel_To_Face
enabledIn:#("max", "viz") --pfb: 2003.12.12 added product switch
ButtonText:"ת"
Category:"Editable Polygon Object" 
internalCategory:"Editable Polygon Object" 
Tooltip:"ת()" 
-- Needs Icon
(
	On IsEnabled Return Filters.Is_EPolySpecifyLevel #{2..4}
	On IsVisible Return Filters.Is_EPolySpecifyLevel #{2..4}

	On Execute Do (
		Try (
			if subobjectLevel == undefined then Max Modify Mode
			local A = Filters.GetModOrObj()
			A.ConvertSelection #CurrentLevel #Face
			subobjectLevel = 4
		)
		Catch (MessageBox "ʧ" Title:"α༭")
	)
)


