-- Macro Scripts File
-- Created:  Jan 12 2005
-- Author:   Michael Russo
-- Macro Scripts for Asset Tracking System
--***********************************************************************************************
-- MODIFY THIS AT YOUR OWN RISK

macroScript AssetTrackingSystemShow
	category:"Asset Tracking System" 
	internalcategory:"Asset Tracking System" 
	tooltip:"Դ׷..."
	ButtonText:"Դ׷..." 
(
	On Execute Do     
	(
		Try (
			if ATSOps != undefined do ATSOps.visible = true 
		)
		Catch() 
	)

	on closeDialogs do
	(
		Try (
			if ATSOps != undefined do ATSOps.visible = false 
		)
		Catch() 
	)

	on isChecked Do
	(
		if ATSOps == undefined do return FALSE
		return ATSOps.visible
	)

)

macroScript AssetTrackingSystemDisabled
	category:"Asset Tracking System" 
	internalcategory:"Asset Tracking System" 
	tooltip:"Դ׷"
	ButtonText:"Դ׷" 
(
	On Execute Do	
	(
		Try( ATSOps.disabled = not ATSOps.disabled )
		Catch() 
	)

	on isChecked return ATSOps.disabled
	on isEnabled return (ATSOps.NumProviders() > 0)
)

macroScript AssetTrackingSystemAutoLogin
	category:"Asset Tracking System" 
	internalcategory:"Asset Tracking System" 
	tooltip:"Զ¼"
	ButtonText:"Զ¼" 
(
	On Execute Do	
	(
		Try( ATSOps.autologin = not ATSOps.autologin )
		Catch() 
	)

	on isChecked return ATSOps.autologin
	on isEnabled return (ATSOps.NumProviders() > 0)	
)

macroScript AssetTrackingSystemCheckNetworkPaths
	category:"Asset Tracking System" 
	internalcategory:"Asset Tracking System" 
	tooltip:"·"
	ButtonText:"·" 
(
	On Execute Do	
	(
		Try( ATSOps.checkNetworkPaths = not ATSOps.checkNetworkPaths )
		Catch() 
	)

	on isChecked return ATSOps.checkNetworkPaths	
)

macroScript AssetTrackingSystemTreeView
	category:"Asset Tracking System" 
	internalcategory:"Asset Tracking System" 
	tooltip:"ͼ"
	ButtonText:"ͼ" 
(
	On Execute Do	
	(
		Try( ATSOps.treeview = not ATSOps.treeview )
		Catch() 
	)

	on isChecked return ATSOps.treeview
)

macroScript AssetTrackingSystemTableView
	category:"Asset Tracking System" 
	internalcategory:"Asset Tracking System" 
	tooltip:"ͼ"
	ButtonText:"ͼ" 
(
	On Execute Do	
	(
		Try( ATSOps.tableview = not ATSOps.tableview )
		Catch() 
	)

	on isChecked return ATSOps.tableview
)

macroScript AssetTrackingSystemDisplayExcluded
	category:"Asset Tracking System" 
	internalcategory:"Asset Tracking System" 
	tooltip:"ʾųļ"
	ButtonText:"ʾųļ" 
(
	On Execute Do	
	(
		Try( ATSOps.DisplayExcluded = not ATSOps.DisplayExcluded )
		Catch() 
	)

	on isChecked return ATSOps.DisplayExcluded
	on isEnabled return (ATSOps.NumProviders() > 0)	
)

macroScript AssetTrackingSystemExcludeOutputFiles
	category:"Asset Tracking System" 
	internalcategory:"Asset Tracking System" 
	tooltip:"ųļ"
	ButtonText:"ųļ" 
(
	On Execute Do	
	(
		Try( ATSOps.ExcludeOutputFiles = not ATSOps.ExcludeOutputFiles )
		Catch() 
	)

	on isChecked return ATSOps.ExcludeOutputFiles
	on isEnabled return (ATSOps.NumProviders() > 0)	
)

macroScript AssetTrackingSystemRefresh
	category:"Asset Tracking System" 
	internalcategory:"Asset Tracking System" 
	tooltip:"ˢ"
	ButtonText:"ˢ" 
(
	On Execute Do	
	(
		Try( ATSOps.Refresh() )
		Catch() 
	)

)

macroScript AssetTrackingSystemLogin
	category:"Asset Tracking System" 
	internalcategory:"Asset Tracking System" 
	tooltip:"¼..."
	ButtonText:"¼..." 
(
	On Execute Do	
	(
		Try( ATSOps.Login 0 )
		Catch() 
	)
	on isEnabled return ( (not ATSOps.IsInitialized 0) and (not ATSOps.Disabled) and (ATSOps.NumProviders() > 0))
)

macroScript AssetTrackingSystemLogout
	category:"Asset Tracking System" 
	internalcategory:"Asset Tracking System" 
	tooltip:"ע"
	ButtonText:"ע" 
(
	On Execute Do	
	(
		Try( ATSOps.Logout 0 )
		Catch() 
	)
	on isEnabled return (ATSOps.IsInitialized 0)
)

macroScript AssetTrackingSystemCheckin
	category:"Asset Tracking System" 
	internalcategory:"Asset Tracking System" 
	tooltip:"..."
	ButtonText:"..." 
(
	On Execute Do	
	(
		Try(
			local filelist = #() 
			local comment = ""
			ATSOps.Checkin 0 filelist comment
		)
		Catch() 
	)
	
	on isEnabled return ATSOps.CanCheckin()
)

macroScript AssetTrackingSystemCheckout
	category:"Asset Tracking System" 
	internalcategory:"Asset Tracking System" 
	tooltip:"..."
	ButtonText:"..." 
(
	On Execute Do	
	(
		Try(
			local filelist = #() 
			local comment = ""
			ATSOps.Checkout 0 filelist comment
		)
		Catch() 
	)
	
	on isEnabled return ATSOps.CanCheckout()
)

macroScript AssetTrackingSystemUndoCheckout
	category:"Asset Tracking System" 
	internalcategory:"Asset Tracking System" 
	tooltip:"..."
	ButtonText:"..." 
(
	On Execute Do	
	(
		Try(
			local filelist = #() 
			ATSOps.UndoCheckout 0 filelist
		)
		Catch() 
	)
	
	on isEnabled return ATSOps.CanUndoCheckout()
)

macroScript AssetTrackingSystemAddFile
	category:"Asset Tracking System" 
	internalcategory:"Asset Tracking System" 
	tooltip:"ļ..."
	ButtonText:"ļ..." 
(
	On Execute Do	
	(
		Try(	
			local filelist = #() 
			local comment = ""
			ATSOps.AddFiles 0 filelist comment
		)
		Catch() 
	)
	
	on isEnabled return ATSOps.CanAddFiles()
)

macroScript AssetTrackingSystemGetLatest
	category:"Asset Tracking System" 
	internalcategory:"Asset Tracking System" 
	tooltip:"ȡ°汾"
	ButtonText:"ȡ°汾" 
(
	On Execute Do	
	(
		Try(
			local filelist = #() 
			ATSOps.GetLatest 0 filelist
		)
		Catch() 
	)
	
	on isEnabled return ATSOps.CanGetLatest()
)

macroScript AssetTrackingSystemProperties
	category:"Asset Tracking System" 
	internalcategory:"Asset Tracking System" 
	tooltip:"..."
	ButtonText:"..." 
(
	On Execute Do	
	(
		Try(
			local filelist = #() 
			ATSOps.Properties 0 filelist
		)
		Catch() 
	)
	
	on isEnabled return ATSOps.CanProperties()
)

macroScript AssetTrackingSystemHistory
	category:"Asset Tracking System" 
	internalcategory:"Asset Tracking System" 
	tooltip:"ʷ¼..."
	ButtonText:"ʷ¼..." 
(
	On Execute Do	
	(
		Try(
			local filelist = #() 
			ATSOps.ShowHistory 0 filelist
		)
		Catch() 
	)
	
	on isEnabled return ATSOps.CanShowHistory()
)

macroScript AssetTrackingSystemOptions
	category:"Asset Tracking System" 
	internalcategory:"Asset Tracking System" 
	tooltip:"ѡ..."
	ButtonText:"ѡ..." 
(
	On Execute Do	
	(
		Try( ATSOps.LaunchOptions 0 )
		Catch() 
	)
	
	on isEnabled return (ATSOps.IsInitialized 0)
)

macroScript AssetTrackingSystemLaunchSCC
	category:"Asset Tracking System" 
	internalcategory:"Asset Tracking System" 
	tooltip:"ṩ..."
	ButtonText:"ṩ..." 
(
	On Execute Do	
	(
		Try( ATSOps.LaunchProvider 0 )
		Catch() 
	)
	
	on isEnabled return ((not ATSOps.Disabled) and (ATSOps.NumProviders() > 0))
)

macroScript AssetTrackingSystemWorkingComment
	category:"Asset Tracking System" 
	internalcategory:"Asset Tracking System" 
	tooltip:"ע..."
	ButtonText:"ע..." 
(
	On Execute Do	
	(
		Try( ATSOps.ShowWorkingCommentDialog() )
		Catch() 
	)
	
	on isEnabled return ((ATSOps.IsInitialized 0) and (ATSOps.IsProjectOpen 0))
)

macroScript AssetTrackingSystemPromptsDialog
	category:"Asset Tracking System" 
	internalcategory:"Asset Tracking System" 
	tooltip:"ʾԻ..."
	ButtonText:"ʾԻ..." 
(
	On Execute Do	
	(
		Try( ATSOps.ShowPromptsDialog() )
		Catch() 
	)
)

macroScript AssetTrackingSystemDViewImageFile
	category:"Asset Tracking System" 
	internalcategory:"Asset Tracking System" 
	tooltip:"鿴ͼļ..."
	ButtonText:"鿴ͼļ..." 
(
	On Execute Do	
	(
		Try(
			myFileList = #()
			iCount = atsops.getSelectedFiles &myFileList
			if iCount > 0 then (
				b = openBitmap myFileList[1]
				display b
			)
		)
		Catch()
	)
	
	on isEnabled Do
	(
		Try(	
			if atsops.numFilesSelected() != 1 do return false
			myFileList = #()
			atsops.getSelectedFiles &myFileList
			if not (maxops.canImportBitmap myFileList[1]) do return false
			return true
		)
		Catch()
	)
)

macroScript AssetTrackingSystemCustomDeps
	category:"Asset Tracking System" 
	internalcategory:"Asset Tracking System" 
	tooltip:"Զϵ..."
	ButtonText:"Զϵ..." 
(
	On Execute Do	
	(
		Try( 
			ATSCustomDepsOps.LaunchDialog() 
			if ATSOps.visible do ATSOps.Refresh()
		)
		Catch() 
	)
)

macroScript AssetTrackingSystemGetFromProvider
	category:"Asset Tracking System" 
	internalcategory:"Asset Tracking System" 
	tooltip:"ṩ߻ȡ..."
	ButtonText:"ṩ߻ȡ..." 
(
	On Execute Do	
	(
		Try(
			fl = #() 
			ATSOps.GetFromProvider 0 "All files (*.*)" "*.*" false true true &fl
			)
		Catch() 
	)
	
	on isEnabled return (ATSOps.CanGetFromProvider 0)
)
