// Used to assign a default value to global variables if missing (do not localize)
if (typeof(homeText) == "undefined") homeText = "*Home*";
if (typeof(indexText) == "undefined") indexText = "*Index*";
if (typeof(helpText) == "undefined") helpText = "*Help*";
if (typeof(searchText) == "undefined") searchText = "*Search*";
if (typeof(continuedText) == "undefined") continuedText = "*Continued*";

var scriptPath = "scripts/";
var stylePath = "style/";
var imagePath = "images/PTDCPM/";
var imagePathProduct = "images/PTDCPM/";
var imagePathCommon = "images/";
var tocPath = "";
var filePath = "files/";
var pageTopic_id = "";
var pageTopic_name = "";
var lastTopicNumber = "";
var topicNumber = "";

// Display the TOC on the content page
function displayTableOfContents ()
{
    var leftDiv = addLeftContentDIV();

   // Create column
   var tocDiv = document.createElement("div");
   tocDiv.className = "acad-contents";
   tocDiv.id = "acad-contents";
   leftDiv.appendChild(tocDiv);

   // Create table
   var table = document.createElement("table");
   table.border = "0";
   table.id = "tbl-acad-contents";
   tocDiv.appendChild(table);

   var tbody = document.createElement("tbody");
   tbody.id = "tbody-acad-contents";
   table.appendChild(tbody);

   g_cont = false;
   recurseTOCitem(tbody, '', top.tocItems, true, 0);
}

// Highlight/select a TOC item for the current content page
function highlightTOCItem (base_id, level, highlight, current)
{
    if (base_id != parent.topicNumber || current == true)
    {
        var col1 = document.getElementById("td" + base_id + "_i");
        var col2 = document.getElementById("td" + base_id);
        var col3 = document.getElementById("td" + base_id + "_it");

        if (highlight == true)
        {
            if (col1 != null) col1.className = "toc_item_selected";
            if (col2 != null) col2.className = "toc_entry_" + level + "_selected";
            if (col3 != null) col3.className = "toc_item_top_selected";
        }
        else
        {
            if (col1 != null) col1.className = "toc_item";
            if (col2 != null) col2.className = "toc_entry_" + level;
            if (col3 != null) col3.className = "toc_item_top";
        }
    }
}

// Build the TOC for the content page
function recurseTOCitem(tbody, parentItem, items, cont, indent)
{
    var b_cont = cont;

    if (b_cont == true) 
    {
        var level = 0;

        for (var nItems = 0; nItems < items.length; nItems++)
        {
           if (items[nItems].id == parent.topicNumber)
           {
               if (typeof(parentItem) != "undefined" && parentItem != "")
               {
                   var tr = document.createElement("tr");
                   tr.setAttribute("onClick", "parent.location.href=\"../" + parentItem.ln + "\"");
                   tr.setAttribute("onMouseOver", "highlightTOCItem('" + parentItem.id + "', " + level + ", true, false)");
                   tr.setAttribute("onMouseOut", "highlightTOCItem('" + parentItem.id + "', " + level + ", false, false)");
                   tbody.appendChild(tr);

                   var td = document.createElement("td");
                   td.className = "toc_item";
                   td.id = "td" + parentItem.id + "_i";
                   tr.appendChild(td);

                   td = document.createElement("td");
                   td.className = "toc_entry_" + level;
                   td.id = "td" + parentItem.id;
                   td.innerHTML = parentItem.ttl;
                   tr.appendChild(td);

                   td = document.createElement("td");
                   td.className = "toc_item_top";
                   td.id = "td" + parentItem.id + "_it";
                   td.innerHTML = "<img alt='' src='../" + imagePathCommon + "top_topic.gif' />";
                   tr.appendChild(td);

                   level = level + 1;
               }


               for (var nChildItems = 0; nChildItems < items.length; nChildItems++)
               {

                   var tr = document.createElement("tr");
                   tr.setAttribute("onClick", "parent.location.href=\"../" + items[nChildItems].ln + "\"");
                   tr.setAttribute("onMouseOver", "highlightTOCItem('" + items[nChildItems].id + "', " + level + ", true, false)");
                   tr.setAttribute("onMouseOut", "highlightTOCItem('" + items[nChildItems].id + "', " + level + ", false, false)");
                   tbody.appendChild(tr);

                   var td = document.createElement("td");
                   td.className = "toc_item";
                   td.id = "td" + items[nChildItems].id + "_i";
                   tr.appendChild(td);

                   td = document.createElement("td");
                   td.colSpan = 2;
                   td.className = "toc_entry_" + level;
                   td.id = "td" + items[nChildItems].id;
                   td.innerHTML = items[nChildItems].ttl;
                   tr.appendChild(td);

                   if (items[nChildItems].id == parent.topicNumber)
                   {
                       if (typeof(items[nChildItems].children) != "undefined")
                       {
                           grandChileItems = items[nChildItems].children;
                           level = level + 1;

                           for (var nGrandchildItems = 0; nGrandchildItems < grandChileItems.length; nGrandchildItems++)
                           {

                               var tr = document.createElement("tr");
                               tr.setAttribute("onClick", "parent.location.href=\"../" + grandChileItems[nGrandchildItems].ln + "\"");
                               tr.setAttribute("onMouseOver", "highlightTOCItem('" + grandChileItems[nGrandchildItems].id + "', " + level + ", true, false)");
                               tr.setAttribute("onMouseOut", "highlightTOCItem('" + grandChileItems[nGrandchildItems].id + "', " + level + ", false, false)");
                               tbody.appendChild(tr);

                               var td = document.createElement("td");
                               td.className = "toc_item";
                               td.id = "td" + grandChileItems[nGrandchildItems].id + "_i";
                               tr.appendChild(td);

                               td = document.createElement("td");
                               td.colSpan = 2;
                               td.className = "toc_entry_" + level;
                               td.id = "td" + grandChileItems[nGrandchildItems].id;
                               td.innerHTML = grandChileItems[nGrandchildItems].ttl;
                               tr.appendChild(td);
                           }

                           level = level - 1;
                       }
                   }
               }

               highlightTOCItem(items[nItems].id, level, true, true);

               return false;
           }

           if (typeof(items[nItems].children) != "undefined" && b_cont == true)
           {
               b_cont = recurseTOCitem(tbody, items[nItems], items[nItems].children, b_cont, indent);
           }
        }
    }

    return b_cont;
}

// Used to include a JS file dynamically
function include_js (file)
{
   var head = document.getElementsByTagName('head').item(0);
   script_file = document.createElement('script');
   script_file.src = file;
   script_file.type = 'text/javascript';
   head.appendChild(script_file)
}

// Used to include a CSS file dynamically
function include_style (file)
{
   var head = document.getElementsByTagName('head').item(0);
   style_file = document.createElement('link');
   style_file.rel = 'stylesheet';
   style_file.type = 'text/css';
   style_file.href = file;
   head.appendChild(style_file)
}

// Define which Style files to load
function includeStyleFiles ()
{
   // Standard styles
//   include_style("style/adsk.cpm.css");
//   include_style("style/adsk.panels.css");
//   include_style("style/acad-contents.css");
//   include_style("style/acad_html.css");
//   include_style("style/acad-landing.css");
}

function loadTocContent (frame, file)
{
   top.frames[frame].location = file;
}

function buildLandingTOC ()
{
   for (var nBooks = 0; nBooks < bookMapping.length; nBooks++)
   {
      var book = bookMapping[nBooks];

      try { if(book.found == 1 && book.display == 1){ addTOCLink(book.id, book.title);}} catch (err) {}
   }
}

// Used to build the TOC links on the landing pages
function addTOCLink (bookID, title)
{
   // Append the new TOC item
   var pos = bookID.indexOf('SEPARATOR:');
   if (pos == -1) {
       document.getElementById('divTocLinks').innerHTML = document.getElementById('divTocLinks').innerHTML + "<div class='toc_entry' id='" + bookID + "' onClick='buildLandingContentLinks(\"" + bookID + "\");'>" + title + "</div>";
   } else {
       document.getElementById('divTocLinks').innerHTML = document.getElementById('divTocLinks').innerHTML + "<div class='toc_separator'>" + title + "</div>";
   }
}

// Control which content is displayed on the landing page for the selected book
function buildLandingContentLinks(bookCode)
{
   var cookieWorker = new CookieWorker(top.document, "autodesk_landing", 24000);

   var lastBook = {
        bookString : ""
   };

   cookieWorker.load(lastBook);

//   var lastBook = getCookie("lastBook");

   var firstBook = "";
   var validBook = false;

   for (var nBooks = 0; nBooks < bookMapping.length; nBooks++)
   {
      var book = bookMapping[nBooks];
      var pos = book.id.indexOf('SEPARATOR:');

      if (firstBook == "" && nBooks > 0 && book.found == 1 && pos == -1) firstBook = book.id;
      if (lastBook.bookString == book.id) validBook = true;

      if (document.getElementById(book.id)) document.getElementById(book.id).className='toc_entry';
   }

   if (validBook == false) lastBook.bookString = firstBook;

   if (typeof(g_currentBook) == "undefined") g_currentBook = "";
   if (typeof(bookCode) == "undefined") bookCode = "";
   if (lastBook.bookString != "" && bookCode == "") bookCode = lastBook.bookString;

   if(bookCode.toLowerCase() == "hammer-acr")
   {
           var landingTOCDiv = document.getElementById('landingTOC');
           landingTOCDiv.innerHTML = '';
         
           landingTOCDiv.innerHTML = '<iframe id="subColumn2" name="featureframe" src="acr-topics.htm" scrolling="no" width="100%" height="590px" style="border: none; overflow:auto; overflow-x:hidden;" frameborder="0">';

           for (var nBooks = 0; nBooks < bookMapping.length; nBooks++)
           {
               var book = bookMapping[nBooks];

               if (book.id.toLowerCase() == bookCode.toLowerCase())
               {
                   lastBook.bookString = book.id;

                   cookieWorker.store(lastBook);
//                   setCookie("lastBook", book.id , 1);
                   bookCode = book.id;
               }
            }
        }
        else
        {
           if (bookCode == "")
           {
              for (var nBooks = 0; nBooks < bookMapping.length; nBooks++)
              {
                 var book = bookMapping[nBooks];

                 if (book.id.toLowerCase() == g_currentBook.toLowerCase())
                 {
                     lastBook.bookString = book.id;

                     cookieWorker.store(lastBook);
//                     setCookie("lastBook", book.id , 1);
                     displayTOCContent(book.bookVar);
                     bookCode = book.id;
                 }
              }
           }
           else
           {
              for (var nBooks = 0; nBooks < bookMapping.length; nBooks++)
              {
                 var book = bookMapping[nBooks];

                 if (book.id.toLowerCase() == bookCode.toLowerCase())
                 {
                     lastBook.bookString = book.id;

                     cookieWorker.store(lastBook);
//                     setCookie("lastBook", book.id , 1);
                     displayTOCContent(book.bookVar);
                     bookCode = book.id;
                 }
              }
           }
        }

   if (document.getElementById(bookCode)) document.getElementById(bookCode).className='toc_entry_selected';
}
// End Landing page TOC functions

function createLink (styleClass, fileName, linkTitle)
{
   document.write('<a class="' + styleClass + '" href="' + fileName + '" target="_parent">' + linkTitle + '</a><br>');
}

function createLinkNoBreak (styleClass, fileName, linkTitle)
{
   document.write('<a class="' + styleClass + '" href="' + fileName + '" target="_parent">' + linkTitle + '</a>&nbsp;');
}

function displayTOCContent (localTocItems)
{
   var landingTOCDiv = document.getElementById('landingTOC');
   landingTOCDiv.innerHTML = '';

   // Create column
   var divColumn = document.createElement("div");
   divColumn.className = "";
   landingTOCDiv.appendChild(divColumn);

   var nTotalItems = 0;
   var bFlagBreak = false;

   // Get the parent items and count up the total number of links and parent items
   for (var nParents = 0; nParents < localTocItems.length; nParents++) {
      var parent = localTocItems[nParents];

      // Increment the counter to determine column break
      nTotalItems = nTotalItems + 1;

      // Get the children TOC items
      if (parent.children)
      {
          nTotalItems = nTotalItems + parent.children.length;
      }
   }

   var nCountTotal = 0;

   // Get the parent items
   for (var nParents = 0; nParents < localTocItems.length; nParents++) {
      var parent = localTocItems[nParents];

      // Increment the counter to determine column break
      nCountTotal = nCountTotal + 1;

      // Get the children TOC items
      if (parent.children)
      {
         // Create the DIV - Chapter
         var divChapter = document.createElement("div");
         divChapter.className = "toc-chapter";

         // Append the DIV
         divColumn.appendChild(divChapter);

         // Create the DIV - Title
         var divTitle = document.createElement("div");
         divTitle.className = "toc-title";
            var aLink = document.createElement("a");
            aLink.className = "_toc-link";
            aLink.href = parent.ln;
            aLink.target = "_parent";
            aLink.innerHTML = parent.ttl;
            divTitle.appendChild(aLink);
            //divTitle.innerHTML = aLink; //parent.ttl; 

         var prevTitle = parent.ttl;

         // Append the DIV
         divChapter.appendChild(divTitle);

         // Append a break
         var br = document.createElement('br');
         divTitle.appendChild(br);

         for (var nChildren = 0; nChildren < parent.children.length; nChildren++)
         {
           if ((nCountTotal > (nTotalItems / 2)) && bFlagBreak==false && nTotalItems > 30)
           {
              bFlagBreak = true;
              divColumn = document.createElement("div");
              divColumn.className = "";
              landingTOCDiv.appendChild(divColumn);

              // Create the DIV - Chapter
              var divChapter = document.createElement("div");
              divChapter.className = "toc-chapter";

              // Append the DIV
              divColumn.appendChild(divChapter);

              // Append a break
              var br = document.createElement('br');
              divTitle.appendChild(br);
           }

         }
      }
      else
      {
         // Create the DIV - Chapter
         var divChapter = document.createElement("div");
         divChapter.className = "toc-chapter";

         // Append the DIV
         divColumn.appendChild(divChapter);

         var br = document.createElement('br');
         divTitle.appendChild(br);

         // Create and append link
         var aLink = document.createElement("a");
         aLink.className = "_toc-link";
         aLink.href = parent.ln;
         aLink.target = "_parent";
         aLink.innerHTML = parent.ttl;
         divTitle.appendChild(aLink);

         br = document.createElement('br');
         divTitle.appendChild(br);
      }
   }
}

// Used to display the secondary content on the right side of the page
function displaySecondaryContent ()
{
  try {
    if(tocItemsLanding)
    {
       var secondaryDiv = document.getElementById('secondarySection');

       // Create layout
       var divLayout = document.createElement("div");
       divLayout.className = "topic";
       secondaryDiv.appendChild(divLayout);

       var divTitle = document.createElement("div");
       divTitle.className = "topic-text";
       divTitle.innerHTML = secondaryHeading.replace('(productFullName)',productFullName);
       divLayout.appendChild(divTitle);

       var divDesc = document.createElement("div");
       divDesc.className = "topic-description";
       divDesc.innerHTML = secondaryDescription.replace('(productFullName)',productFullName);
       divLayout.appendChild(divDesc);

       // Get the parent items
       for (var nItem = 0; nItem < secondaryLinks.length; nItem++) {
          var item = secondaryLinks[nItem];

          var divLink = document.createElement("div");
          divLink.className = "topic-link";
          secondaryDiv.appendChild(divLink);

          var divLinkTitle = document.createElement("div");
          divLinkTitle.className = "topic-link-title";
          divLinkTitle.innerHTML = "<a href='" + item.ln + "' target='_parent'>" + item.ttl.replace('(productFullName)',productFullName) + "</a>";
          divLink.appendChild(divLinkTitle);

          var divLinkDesc = document.createElement("div");
          divLinkDesc.className = "topic-link-description";
          divLinkDesc.innerHTML = item.tld.replace('(productFullName)',productFullName);
          divLink.appendChild(divLinkDesc);
       }
    }
  }
  catch (err) {}
}

// Used to display the What's New box on a content page
function displayWhatsNewContent (elementId)
{
    if(typeof(whatsNewHeading) != "undefined")
    {
       var rightDiv = document.getElementById(elementId);

       // Create layout
       var whatsNewDiv = document.createElement("div");
       whatsNewDiv.className = "module_internal";
       rightDiv.appendChild(whatsNewDiv);

       var divHeader = document.createElement("div");
       divHeader.className = "module-header_internal";
       whatsNewDiv.appendChild(divHeader);

       var divTitle = document.createElement("div");
       divTitle.className = "module-title_internal";
       divTitle.innerHTML = whatsNewHeading.replace('(productFullName)',productFullName);
       divHeader.appendChild(divTitle);

       var divDesc = document.createElement("div");
       divDesc.className = "module-description_internal";
       divDesc.innerHTML = whatsNewDescription.replace('(productFullName)',productFullName);
       divHeader.appendChild(divDesc);

       var divLinks = document.createElement("div");
       divLinks.className = "module-content_internal";
       whatsNewDiv.appendChild(divLinks);

       var table = document.createElement("table");
       table.border = "0";
       divLinks.appendChild(table);

       var tbody = document.createElement("tbody");
       table.appendChild(tbody);
       
       // Get the parent items
       for (var nItem = 0; nItem < whatsNewLinks.length; nItem++)
       {
          var item = whatsNewLinks[nItem];
          
          var children = item.children;

          for (var nChild = 0; nChild < children.length; nChild++) {
             var child = children[nChild];

             if (child.fi == 1)
              {
                var tr = document.createElement("tr");
                tbody.appendChild(tr);

                var td = document.createElement("td");
                td.className = "module-link_internal";
                td.innerHTML = "<a href='" + child.ln + "' target='_parent'>" + child.ttl.replace('(productFullName)',productFullName) + "</a>";
                tr.appendChild(td);
              }
          }
       }
    }
}

// Creates a DIV element to use for the left side
function addLeftContentDIV ()
{
    var body = document.body;
    var leftDiv = document.createElement("div");
    leftDiv.className = "leftContent";
    leftDiv.id = "leftContent";
    body.appendChild(leftDiv);

    return leftDiv;
}
// Creates a DIV element to use for the right side
function addRightContentDIV ()
{
    var body = document.body;
    var rightDiv = document.createElement("div");
    rightDiv.className = "rightContent";
    rightDiv.id = "rightContent";
    body.appendChild(rightDiv);
}

// Used to display the online resouce links
function displayOnlineResources (elementId, root)
{
  if (typeof(onlineResHeading) != "undefined")
  {

   if (elementId == "")
   {
       var rightDiv = document.body;
   }
   else
   {
       var rightDiv = document.getElementById(elementId);
   }

   // Create layout
   var onlineResDiv = document.createElement("div");
   onlineResDiv.className = "module_external";
   rightDiv.appendChild(onlineResDiv);

   var divHeader = document.createElement("div");
   divHeader.className = "module-header_external";
   onlineResDiv.appendChild(divHeader);

   var divTitle = document.createElement("div");
   divTitle.className = "module-title_external";

   if (typeof(productFullName) != "undefined") divTitle.innerHTML = onlineResHeading.replace('(productFullName)',productFullName);
   divHeader.appendChild(divTitle);

   var divDesc = document.createElement("div");
   divDesc.className = "module-description_external";
   if (typeof(productFullName) != "undefined") divDesc.innerHTML = onlineResDescription.replace('(productFullName)',productFullName);
   divHeader.appendChild(divDesc);

   var divLinks = document.createElement("div");
   divLinks.className = "module-content_external";
   onlineResDiv.appendChild(divLinks);

   var table = document.createElement("table");
   table.border = "0";
   divLinks.appendChild(table);

   var tbody = document.createElement("tbody");
   table.appendChild(tbody);

   // Get the parent items
   for (var nItem = 0; nItem < onlineResLinks.length; nItem++) {
      var item = onlineResLinks[nItem];

      var tr = document.createElement("tr");
      tbody.appendChild(tr);

      var td = document.createElement("td");
      td.className = "module-link_external_main";
      td.innerHTML = "<a href='" + item.ln + "' target='_parent'>" + item.ttl.replace('(productFullName)',productFullName) + "</a>";
      tr.appendChild(td);
         
      td = document.createElement("td");
      td.className = "module-link_external";
      td.innerHTML = "<a href='" + item.ln + "' target='_parent'><img style='border:0;' alt='' src='" + root + imagePathCommon + "external_link.png' /></a>";
      tr.appendChild(td);
   }
  }
}

// Currently not used, used to determine if page is viewed locally or online
function isOnline()
{
  if (window.location.protocol == "http:")
    return true;
  else
    return false;
}

// Used to display the AutoCAD Exchange Search Results widget
function displayExchangeContentWidget (elementId, help_type, topic_id, topic_name)
{
   if (isOnline() == true)
   {
   if (elementId == "")
   {
       var element = document.body;
   }
   else
   {
       var element = document.getElementById(elementId);
   }

   // Replace the spaces in the title with %20
   var lastVal = "";
   while (lastVal != topic_name)
   {
       var lastVal = topic_name;
       topic_name = topic_name.replace(' ', '%20');
   }

   var div = document.createElement("div");
   div.className = "exchange_content_widget";
   div.innerHTML = "<iframe src='http://67.192.150.96/?html=fragment-autocad_help_rightnav_widget2&topic_id=" + topic_id + "&topic_name=" + topic_name + "' frameborder='0' width='190' height='600' scrolling='no' marginheight='0' marginwidth='0'/>";

   element.appendChild(div);
}
}

// Used to display the AutoCAD Exchange widget
function displayExchangeWidget (elementId)
{
   if (isOnline() == true)
   {
   if (elementId == "")
   {
       var element = document.body;
   }
   else
   {
       var element = document.getElementById(elementId);
   }

   var div = document.createElement("div");
   div.className = "exchange_widget";
   div.innerHTML = "<object width='190' height='200'><param name='movie' value='http://autocad.autodesk.com/ama/orig/flash_widget/flash_loaders/preloader_medium.swf'></param><param name='flashvars' value='SWFfile=http://autocad.autodesk.com/ama/orig/flash_widget/flash_loaders/widget_medium.swf&XMLfile=http://autocad.autodesk.com/?nd=flash_widget_xml%26size=medium&tagent=widget__535&tabBg=eaf4ff&tabText=555555&activeBg=eaf4ff&activeText=004182'/><embed src='http://autocad.autodesk.com/ama/orig/flash_widget/flash_loaders/preloader_medium.swf' flashvars='SWFfile=http://autocad.autodesk.com/ama/orig/flash_widget/flash_loaders/widget_medium.swf&XMLfile=http://autocad.autodesk.com/?nd=flash_widget_xml%26size=medium&tagent=widget__535&tabBg=eaf4ff&tabText=555555&activeBg=eaf4ff&activeText=004182' type='application/x-shockwave-flash' width='190' height='200'></embed></object>";

   element.appendChild(div);
}
}

// Standard content page call to show the TOC for the page
function showTOC(topicNumber) {
    // Get body
    // Insert iFrame or other object
    // Setup TOC
    var docBody = document.body;
    if (docBody === null)
        return false;

    displayTableOfContents();
    top.lastTopicNumber = topicNumber;

    return true;

}

// Standard content page call to show the header
function showHeader() {
    appendHeaderToBody(productFullNameHelp, 'true', 'false', '../');
    return true;
}

function isLocal()
{
  if (window.location.protocol == "file:")
    return true;
  else
    return false;
}

function resizeIframe(id)
{
     var tocBlock = parent.document.getElementById(id);
     var j2Block = parent.document.getElementById('jump-to-block');
     var saBlock = parent.document.getElementById('see-also');

     var nHgt = 0;
     var nTop = 133;

     if (tocBlock)
       {
         nHgt=tocBlock.offsetHeight;

         tocBlock.style.left="0px";
         nTop = tocBlock.offsetTop;
     }

     // Need to add id="see-also" to the div element added to the docs.
     if (saBlock)
     {

          // The following reformats the elements used to format the title of the See Also block
          // A request to the CMS team was declined to change the HTML element from SPAN to DIV
          // The remain formatting is handled via Cascading Styles

          var strHTML = new String();
          strHTML = saBlock.innerHTML;

          var strTemp = strHTML;
          strHTML = strHTML.replace('<span class="see-also">', '<div class="see-also-title">');
          strHTML = strHTML.replace('<SPAN class="see-also">', '<div class="see-also-title">');
          strHTML = strHTML.replace('<SPAN class=see-also>', '<div class="see-also-title">');

          if (strTemp != strHTML)
          {
               strHTML = strHTML.replace('</span>', '</div>');
               strHTML = strHTML.replace('</SPAN>', '</div>');
          }

          saBlock.innerHTML=strHTML;

          saBlock.style.top=(nTop + nHgt)+"px";
          saBlock.style.left="0px";
     }

     // Need to add id="jump-to-block" to the div element added to the docs.
     if (j2Block)
     {
          var strStart;

          if (saBlock)
              nHgt = saBlock.offsetHeight;

          if (saBlock)
              j2Block.style.top=(saBlock.offsetTop + nHgt)+"px";
          else
              j2Block.style.top=(nTop + nHgt)+"px";

          j2Block.style.left="0px";
     }
}

//From commons-processing.js
function convSymbols() { 

}

// Standard content page call
function initFrame(url, tn, index) {
    topicNumber = tn;
    if (showTOC(topicNumber) === true) {

    }

    // Assign to global variable
    top.pageTopic_id = url;

    showHeader();
}

// Standard content page call
function initPage(title, bookTitle)
{
    // Assign to global variable
    pageTopic_name = title;

    // Assign to HTML page
    document.title = bookTitle + ": " + title;

    // Resize the iFrame for the TOC on the left
    resizeIframe('acad-contents');

    // Create a DIV to control the overall placement of the content on the right side
    addRightContentDIV();

    // Display the AutoCAD Exchange widget
    // displayExchangeWidget('rightContent');
    var topicId = pageTopic_id.split('/')[2];
    if (!topicId) {topicId="dummy";}
    else {topicId = topicId.split('.')[0];}

    // Display the search results from AutoCAD Exchange
    displayExchangeContentWidget('rightContent', 'autocadhelp_content', topicId, pageTopic_name);
}

// Used to display the page header for all pages
// title is used to push in the product name to the page
// includeSearch controls the display of the search components
// includeMarquee controls the display of the product marquee image
function appendHeaderToBody(title, includeSearch, includeMarquee, root)
{
   var headerText = "";

   headerText = headerText + "<div class='acad-header'>";
   headerText = headerText + "<table width='100%'><tr><td valign='top' align='left'><div class='header-links'><a href='" + root + "landing.html' target='_parent'>" + homeText + "</a><a href='" + root + "acad-indexes.html' target='_parent' class='header_link'>" + indexText + "</a></div></td>";

   if (includeSearch == 'true')
   {
       headerText = headerText + "<td valign='top' align='right'><form name='searchForm' onsubmit='loadSearchResults(searchData.value,\"" + root + "\"); return false;'><input type='text' name='searchData' id='searchData' value='" + searchText + "' onfocus='javascript:searchData.value=\"\"' class='query' /><input type='image' src='" + root + "images/searchSubmit.gif' name='searchButton' id='searchButton' class='searchButton' onclick='loadSearchResults(searchData.value,\"" + root + "\"); return false;' value='Search' /></form></td>";
   }
   else
   {
       headerText = headerText + "<td valign='top' align='right'><div style='color:black; height:39px;'>Search</div></td>";
   }

   headerText = headerText + "</tr><tr><td valign='top'><div class='productName'>" + title + "</div></td><td valign='top'><div class='companyLogo'><img src='" + root + "images/Autodesk.png'></img></div></td></tr></table>";

   headerText = headerText + "</div>";

   if (includeMarquee == 'true')
   {
       headerText = headerText + "<div class='marquee'><img alt='' src='" + imagePathCommon + "marquee.jpg' /></div>";
   }

   headerText = headerText;

   var body = document.body;
   body.innerHTML = headerText + body.innerHTML;
}

// Special Fixed width header for the lannding page.
function appendHeaderToLandingPage(title, includeSearch, includeMarquee, root) {
    var headerText = "";

    headerText = headerText + "<div class='acad-header'>";
    headerText = headerText + "<table width='960px'><tr class='headerTop' ><td align='left'><div class='header-links'><a href='" + root + "landing.html' target='_parent'>" + homeText + "</a><a href='" + root + "acad-indexes.html' target='_parent' class='header_link'>" + indexText + "</a></div></td>";

    if (includeSearch == 'true') {
        headerText = headerText + "<td align='right'><form name='searchForm' onsubmit='loadSearchResults(searchData.value,\"" + root + "\"); return false;'><input type='text' name='searchData' id='searchData' value='" + searchText + "' onfocus='javascript:searchData.value=\"\"' class='query' /><input type='image' src='" + root + "images/searchSubmit.gif' name='searchButton' id='searchButton' class='searchButton2' onclick='loadSearchResults(searchData.value,\"" + root + "\"); return false;' value='Search' /></form></td>";
    }
    else {
        headerText = headerText + "<td valign='top' align='right'><div style='color:black; height:39px;'>Search</div></td>";
    }

    headerText = headerText + "</tr><tr class='headerBottom'><td valign='top'><div class='productName'>" + title + "</div></td><td valign='top'><div class='companyLogo'><img src='" + root + "images/Autodesk.png'></img></div></td></tr></table>";

    headerText = headerText + "</div>";

    if (includeMarquee == 'true') {
        headerText = headerText + "<div class='marquee'><img alt='' src='" + imagePathCommon + "marquee.jpg' /></div>";
    }

    headerText = headerText;

    var body = document.body;
    body.innerHTML = headerText + body.innerHTML;
}

// SIG // Begin signature block
// SIG // MIIMzQYJKoZIhvcNAQcCoIIMvjCCDLoCAQExDjAMBggq
// SIG // hkiG9w0CBQUAMGYGCisGAQQBgjcCAQSgWDBWMDIGCisG
// SIG // AQQBgjcCAR4wJAIBAQQQEODJBs441BGiowAQS9NQkAIB
// SIG // AAIBAAIBAAIBAAIBADAgMAwGCCqGSIb3DQIFBQAEEBmf
// SIG // u1WoMlWtvi7BEiEfnu+gggoPMIIE/DCCBGWgAwIBAgIQ
// SIG // ZVIm4bIuGOFZDymFrCLnXDANBgkqhkiG9w0BAQUFADBf
// SIG // MQswCQYDVQQGEwJVUzEXMBUGA1UEChMOVmVyaVNpZ24s
// SIG // IEluYy4xNzA1BgNVBAsTLkNsYXNzIDMgUHVibGljIFBy
// SIG // aW1hcnkgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkwHhcN
// SIG // MDkwNTIxMDAwMDAwWhcNMTkwNTIwMjM1OTU5WjCBtjEL
// SIG // MAkGA1UEBhMCVVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJ
// SIG // bmMuMR8wHQYDVQQLExZWZXJpU2lnbiBUcnVzdCBOZXR3
// SIG // b3JrMTswOQYDVQQLEzJUZXJtcyBvZiB1c2UgYXQgaHR0
// SIG // cHM6Ly93d3cudmVyaXNpZ24uY29tL3JwYSAoYykwOTEw
// SIG // MC4GA1UEAxMnVmVyaVNpZ24gQ2xhc3MgMyBDb2RlIFNp
// SIG // Z25pbmcgMjAwOS0yIENBMIIBIjANBgkqhkiG9w0BAQEF
// SIG // AAOCAQ8AMIIBCgKCAQEAvmcdtGCqEElvVhd8Zslehg3V
// SIG // 8ayncYOOi4n4iASJFQa6LYQhleTRnFBM+9IivdrysjU7
// SIG // Ho/DCfv8Ey5av4l8PTslHvbzWHuc9AG1xgq4gM6+J3Rh
// SIG // ZydNauXsgWFYeaPgFxASFSew4U00fytHIES53mYkZorN
// SIG // T7ofxTjIVJDhcvYZZnVquUlozzh5DaowqNssYEie16oU
// SIG // AamD1ziRMDkTlgM6fEBUtq3gLxuD3KgRUj4Cs9cr/SG2
// SIG // p1yjDwupphBQDjQuTafOyV4l1Iy88258KbwBXfwxh1rV
// SIG // jIVnWIgZoL818OoroyHnkPaD5ajtYHhee2CD/VcLXUEN
// SIG // Y1Rg1kMh7wIDAQABo4IB2zCCAdcwEgYDVR0TAQH/BAgw
// SIG // BgEB/wIBADBwBgNVHSAEaTBnMGUGC2CGSAGG+EUBBxcD
// SIG // MFYwKAYIKwYBBQUHAgEWHGh0dHBzOi8vd3d3LnZlcmlz
// SIG // aWduLmNvbS9jcHMwKgYIKwYBBQUHAgIwHhocaHR0cHM6
// SIG // Ly93d3cudmVyaXNpZ24uY29tL3JwYTAOBgNVHQ8BAf8E
// SIG // BAMCAQYwbQYIKwYBBQUHAQwEYTBfoV2gWzBZMFcwVRYJ
// SIG // aW1hZ2UvZ2lmMCEwHzAHBgUrDgMCGgQUj+XTGoasjY5r
// SIG // w8+AatRIGCx7GS4wJRYjaHR0cDovL2xvZ28udmVyaXNp
// SIG // Z24uY29tL3ZzbG9nby5naWYwHQYDVR0lBBYwFAYIKwYB
// SIG // BQUHAwIGCCsGAQUFBwMDMDQGCCsGAQUFBwEBBCgwJjAk
// SIG // BggrBgEFBQcwAYYYaHR0cDovL29jc3AudmVyaXNpZ24u
// SIG // Y29tMDEGA1UdHwQqMCgwJqAkoCKGIGh0dHA6Ly9jcmwu
// SIG // dmVyaXNpZ24uY29tL3BjYTMuY3JsMCkGA1UdEQQiMCCk
// SIG // HjAcMRowGAYDVQQDExFDbGFzczNDQTIwNDgtMS01NTAd
// SIG // BgNVHQ4EFgQUl9BrqCZwyKE/lB8ILcQ1m6ShHvIwDQYJ
// SIG // KoZIhvcNAQEFBQADgYEAiwPA3ZTYQaJhabAVqHjHMMaQ
// SIG // PH5C9yS25INzFwR/BBCcoeL6gS/rwMpE53LgULZVECCD
// SIG // bpaS5JpRarQ3MdylLeuMAMcdT+dNMrqF+E6++mdVZfBq
// SIG // vnrKZDgaEBB4RXYx84Z6Aw9gwrNdnfaLZnaCG1nhg+W9
// SIG // SaU4VuXeQXcOWA8wggULMIID86ADAgECAhAjTaBL0kKF
// SIG // PErLmuhhwhm7MA0GCSqGSIb3DQEBBQUAMIG2MQswCQYD
// SIG // VQQGEwJVUzEXMBUGA1UEChMOVmVyaVNpZ24sIEluYy4x
// SIG // HzAdBgNVBAsTFlZlcmlTaWduIFRydXN0IE5ldHdvcmsx
// SIG // OzA5BgNVBAsTMlRlcm1zIG9mIHVzZSBhdCBodHRwczov
// SIG // L3d3dy52ZXJpc2lnbi5jb20vcnBhIChjKTA5MTAwLgYD
// SIG // VQQDEydWZXJpU2lnbiBDbGFzcyAzIENvZGUgU2lnbmlu
// SIG // ZyAyMDA5LTIgQ0EwHhcNMDkwODI3MDAwMDAwWhcNMTIw
// SIG // OTIwMjM1OTU5WjCByDELMAkGA1UEBhMCVVMxEzARBgNV
// SIG // BAgTCkNhbGlmb3JuaWExEzARBgNVBAcTClNhbiBSYWZh
// SIG // ZWwxFjAUBgNVBAoUDUF1dG9kZXNrLCBJbmMxPjA8BgNV
// SIG // BAsTNURpZ2l0YWwgSUQgQ2xhc3MgMyAtIE1pY3Jvc29m
// SIG // dCBTb2Z0d2FyZSBWYWxpZGF0aW9uIHYyMR8wHQYDVQQL
// SIG // FBZEZXNpZ24gU29sdXRpb25zIEdyb3VwMRYwFAYDVQQD
// SIG // FA1BdXRvZGVzaywgSW5jMIGfMA0GCSqGSIb3DQEBAQUA
// SIG // A4GNADCBiQKBgQC1R1YKdvQF2Rj4+knWfj81afUtVyep
// SIG // GF2P4tcYD53qlYmYi9t9Csc6PMWlUZhMGbOceQKYcBjc
// SIG // mWvyghJnoaEQ6796ZcsLD0pMH2R4SpV/SjxiQ280beig
// SIG // NerJS5X+ftOMCs1qSQ1LXlRFEohaewkNWsIp/+f1Y0vE
// SIG // dGzggnEKOQIDAQABo4IBgzCCAX8wCQYDVR0TBAIwADAO
// SIG // BgNVHQ8BAf8EBAMCB4AwRAYDVR0fBD0wOzA5oDegNYYz
// SIG // aHR0cDovL2NzYzMtMjAwOS0yLWNybC52ZXJpc2lnbi5j
// SIG // b20vQ1NDMy0yMDA5LTIuY3JsMEQGA1UdIAQ9MDswOQYL
// SIG // YIZIAYb4RQEHFwMwKjAoBggrBgEFBQcCARYcaHR0cHM6
// SIG // Ly93d3cudmVyaXNpZ24uY29tL3JwYTATBgNVHSUEDDAK
// SIG // BggrBgEFBQcDAzB1BggrBgEFBQcBAQRpMGcwJAYIKwYB
// SIG // BQUHMAGGGGh0dHA6Ly9vY3NwLnZlcmlzaWduLmNvbTA/
// SIG // BggrBgEFBQcwAoYzaHR0cDovL2NzYzMtMjAwOS0yLWFp
// SIG // YS52ZXJpc2lnbi5jb20vQ1NDMy0yMDA5LTIuY2VyMB8G
// SIG // A1UdIwQYMBaAFJfQa6gmcMihP5QfCC3ENZukoR7yMBEG
// SIG // CWCGSAGG+EIBAQQEAwIEEDAWBgorBgEEAYI3AgEbBAgw
// SIG // BgEBAAEB/zANBgkqhkiG9w0BAQUFAAOCAQEAIfxkh8Fd
// SIG // IHK+qtTf+9Eq5fjkk5gMMTQCOa+2aR7mqDzLfIFRGQzr
// SIG // tcc5/izsb/wPLUwdw1cRpnxO8/qLA2Ol+b99FONTOyyc
// SIG // Y8unwviYhdEjuFmqHkyC5MUYroZEjvTObFkkgN98Y48h
// SIG // C+mG2hdlVKXR0zr9r5q/rmmivVWbojvcYKHoW31O5OcM
// SIG // PsrWuOD305Ygmpck/91iopE3UN4tfeWYhzNj1F6Ai4Xa
// SIG // 5KiaMcs3zmoZ+6SePyI2YUgtff6yvy/rk8KVT41KGD2h
// SIG // fC+QrtVSkoDWP/MDtLjbTPCWElC1NWSEKowRI8t2x594
// SIG // Skjnzu/W5Lh97ixircOuM4IvBzGCAigwggIkAgEBMIHL
// SIG // MIG2MQswCQYDVQQGEwJVUzEXMBUGA1UEChMOVmVyaVNp
// SIG // Z24sIEluYy4xHzAdBgNVBAsTFlZlcmlTaWduIFRydXN0
// SIG // IE5ldHdvcmsxOzA5BgNVBAsTMlRlcm1zIG9mIHVzZSBh
// SIG // dCBodHRwczovL3d3dy52ZXJpc2lnbi5jb20vcnBhIChj
// SIG // KTA5MTAwLgYDVQQDEydWZXJpU2lnbiBDbGFzcyAzIENv
// SIG // ZGUgU2lnbmluZyAyMDA5LTIgQ0ECECNNoEvSQoU8Ssua
// SIG // 6GHCGbswDAYIKoZIhvcNAgUFAKCBsDAZBgkqhkiG9w0B
// SIG // CQMxDAYKKwYBBAGCNwIBBDAcBgorBgEEAYI3AgELMQ4w
// SIG // DAYKKwYBBAGCNwIBFTAfBgkqhkiG9w0BCQQxEgQQTqDU
// SIG // w1ItYMnUPKocxp0dujBUBgorBgEEAYI3AgEMMUYwRKAm
// SIG // gCQAQQB1AHQAbwBkAGUAcwBrACAAQwBvAG0AcABvAG4A
// SIG // ZQBuAHShGoAYaHR0cDovL3d3dy5hdXRvZGVzay5jb20g
// SIG // MA0GCSqGSIb3DQEBAQUABIGAOASIMR3v+t/+VtVhunkw
// SIG // ZzK96f5QenidM6wc80lKcVC7YuN8o/i/3PpuvXuorIQt
// SIG // yhf18SUjwgSy3OQm0/UkbSg1Ga16usUiamcQ4aylqUzR
// SIG // mL7XxQT4UTOczUB/k4VJ6GQhyAGyLAtgL91+mMbn8380
// SIG // z6T0aPUXx94uez+Eykc=
// SIG // End signature block
