var searchResultProvider = new SearchResultsProvider("LIC", "Autodesk Licensing ");
searchResultProvider.setTopicInfoList(["",{"title":"Stand-Alone Licensing",
"href":"./filesLIC/WSfacf1429558a55de6d0beb1006696e53b-7d14.htm",
"description":"A stand-alone license allows you to run an Autodesk product on a single workstation.",
"ancestors":[]},
{"title":"Introduction",
"href":"./filesLIC/WS1a9193826455f5ff-3e1c256a12044482562-6916.htm",
"description":"Stand-alone licensing allows you to use your Autodesk product in trial mode for a given number of days from the first time you launch the product. The number of days that a trial mode is active differs between Autodesk products. You can activate your license at any time before the trial period expires.",
"ancestors":[{"title": "Stand-Alone Licensing","href":"./filesLIC/WSfacf1429558a55de6d0beb1006696e53b-7d14.htm"}]},
{"title":"Multi-Seat Stand-Alone License",
"href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-4933.htm",
"description":"A multi-seat stand-alone license allows you to install, register, and activate an Autodesk product on several workstations using a single serial number. Multi-seat licenses can be purchased through your Authorized Autodesk Reseller.",
"ancestors":[{"title": "Stand-Alone Licensing","href":"./filesLIC/WSfacf1429558a55de6d0beb1006696e53b-7d14.htm"},{"title": "Introduction","href":"./filesLIC/WS1a9193826455f5ff-3e1c256a12044482562-6916.htm"}]},
{"title":"Activate Your Product",
"href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-492f.htm",
"description":"You can activate your Autodesk product either on startup or while you are running the product. If you cannot activate online, offline activation is available.",
"ancestors":[{"title": "Stand-Alone Licensing","href":"./filesLIC/WSfacf1429558a55de6d0beb1006696e53b-7d14.htm"}]},
{"title":"Register Your Product",
"href":"./filesLIC/WS1a9193826455f5ff603f1a63123ab7a861f-75b8.htm",
"description":"Depending on your product, registration is optional or required. If required, you are asked to create a user Autodesk ID and associate this ID with an individual or company account. If registration is optional, you can choose to postpone it, and you will be reminded periodically to register.",
"ancestors":[{"title": "Stand-Alone Licensing","href":"./filesLIC/WSfacf1429558a55de6d0beb1006696e53b-7d14.htm"}]},
{"title":"Manage Your Stand-Alone License",
"href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-48e5.htm",
"description":"This section provides information about advanced stand-alone licensing tasks such as license types and behaviors, viewing product information, saving your license file as a text file, updating your serial number, and transferring a license.",
"ancestors":[{"title": "Stand-Alone Licensing","href":"./filesLIC/WSfacf1429558a55de6d0beb1006696e53b-7d14.htm"}]},
{"title":"Check Product Information",
"href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-48e2.htm",
"description":"You can view detailed information about your Autodesk product and your product license (such as the license usage type and the license behavior), and then save this information as a text file.",
"ancestors":[{"title": "Stand-Alone Licensing","href":"./filesLIC/WSfacf1429558a55de6d0beb1006696e53b-7d14.htm"},{"title": "Manage Your Stand-Alone License","href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-48e5.htm"}]},
{"title":"View Product Information",
"href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-48b7.htm",
"description":"You can view detailed information about your Autodesk product and your product license, such as the license usage type and the license behavior.",
"ancestors":[{"title": "Stand-Alone Licensing","href":"./filesLIC/WSfacf1429558a55de6d0beb1006696e53b-7d14.htm"},{"title": "Manage Your Stand-Alone License","href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-48e5.htm"}]},
{"title":"Save License Information as a Text File",
"href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-48ab.htm",
"description":"You can save your product license information as a text file.",
"ancestors":[{"title": "Stand-Alone Licensing","href":"./filesLIC/WSfacf1429558a55de6d0beb1006696e53b-7d14.htm"},{"title": "Manage Your Stand-Alone License","href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-48e5.htm"}]},
{"title":"Update Your Serial Number",
"href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-489f.htm",
"description":"Your valid serial number is located on the outside of the product packaging or in the Autodesk Upgrade and Licensing Information email you received if you downloaded your product.",
"ancestors":[{"title": "Stand-Alone Licensing","href":"./filesLIC/WSfacf1429558a55de6d0beb1006696e53b-7d14.htm"},{"title": "Manage Your Stand-Alone License","href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-48e5.htm"}]},
{"title":"Transfer Your Stand-Alone License",
"href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-488d.htm",
"description":"You can use an Autodesk product on more than one computer without purchasing a separate license for each computer. License transfers are only supported on products that require the creation of an Autodesk ID as part of the registration and activation process.",
"ancestors":[{"title": "Stand-Alone Licensing","href":"./filesLIC/WSfacf1429558a55de6d0beb1006696e53b-7d14.htm"}]},
{"title":"About the License Transfer Utility",
"href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838e77.htm",
"description":"The License Transfer Utility transfers a product license online from one computer to another, and ensures that the product works only on the computer that contains the license. The License Transfer Utility is a custom stand-alone installation option. During installation, a shortcut is created. A shortcut is installed once per product, per workstation.",
"ancestors":[{"title": "Stand-Alone Licensing","href":"./filesLIC/WSfacf1429558a55de6d0beb1006696e53b-7d14.htm"},{"title": "Transfer Your Stand-Alone License","href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-488d.htm"}]},
{"title":"Install the Autodesk Product",
"href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-4871.htm",
"description":"Before you can use the License Transfer Utility to transfer licenses, you must have an Autodesk product installed on all computers involved in the transfer.",
"ancestors":[{"title": "Stand-Alone Licensing","href":"./filesLIC/WSfacf1429558a55de6d0beb1006696e53b-7d14.htm"},{"title": "Transfer Your Stand-Alone License","href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-488d.htm"}]},
{"title":"Export a License",
"href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-4865.htm",
"description":"A license is exported when the License Transfer Utility moves a product license from a computer to the online Autodesk server.",
"ancestors":[{"title": "Stand-Alone Licensing","href":"./filesLIC/WSfacf1429558a55de6d0beb1006696e53b-7d14.htm"},{"title": "Transfer Your Stand-Alone License","href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-488d.htm"}]},
{"title":"Import a License",
"href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-484c.htm",
"description":"A license is imported when the License Transfer Utility moves a previously exported product license from the online Autodesk server to a computer.",
"ancestors":[{"title": "Stand-Alone Licensing","href":"./filesLIC/WSfacf1429558a55de6d0beb1006696e53b-7d14.htm"},{"title": "Transfer Your Stand-Alone License","href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-488d.htm"}]},
{"title":"Troubleshoot a Stand-Alone License Error",
"href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-4823.htm",
"description":"When you activate your Autodesk product, only the computer that you used to activate the product is licensed to run the product. If you make certain changes to your computer, your stand-alone license might fail. You will receive a license error and you will not be able to use your product. This section discusses ways in which you can troubleshoot a license error.",
"ancestors":[{"title": "Stand-Alone Licensing","href":"./filesLIC/WSfacf1429558a55de6d0beb1006696e53b-7d14.htm"}]},
{"title":"Hardware Changes",
"href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-4816.htm",
"description":"If you replace or reconfigure hardware on the computer where your Autodesk product license resides, the stand-alone license might fail. You will not be able to use your product.",
"ancestors":[{"title": "Stand-Alone Licensing","href":"./filesLIC/WSfacf1429558a55de6d0beb1006696e53b-7d14.htm"},{"title": "Troubleshoot a Stand-Alone License Error","href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-4823.htm"}]},
{"title":"Reinstalling an Operating System",
"href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-480c.htm",
"description":"If you reinstall your operating system on the computer where your Autodesk license resides, the license might fail. You will not be able to use your product.",
"ancestors":[{"title": "Stand-Alone Licensing","href":"./filesLIC/WSfacf1429558a55de6d0beb1006696e53b-7d14.htm"},{"title": "Troubleshoot a Stand-Alone License Error","href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-4823.htm"}]},
{"title":"Changing the System Date and Time",
"href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-47fc.htm",
"description":"Your product license allows for time changes to the system clock within two days of the current time. If you set your system clock back more than two days, the next time you start your product, you will receive a message that gives you the option of correcting the system clock. If you do not correct the system clock, you receive a license error.",
"ancestors":[{"title": "Stand-Alone Licensing","href":"./filesLIC/WSfacf1429558a55de6d0beb1006696e53b-7d14.htm"},{"title": "Troubleshoot a Stand-Alone License Error","href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-4823.htm"}]},
{"title":"Distributing Software Image to Multiple Computers",
"href":"./filesLIC/WS1a9193826455f5ff603f1a63123ab7a861f-7e8c.htm",
"description":"You can use the Deployment Wizard’s Stand-alone option to create a software installation image on your server. You can distribute this image by making it available on your computer network. During creation of this image, you are prompted for registration information, which is stored with the image and deployed to all installations.",
"ancestors":[{"title": "Stand-Alone Licensing","href":"./filesLIC/WSfacf1429558a55de6d0beb1006696e53b-7d14.htm"},{"title": "Troubleshoot a Stand-Alone License Error","href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-4823.htm"}]},
{"title":"Preserving Licenses on Re-Imaged Computers",
"href":"./filesLIC/WS73099cc142f48755-b497228123ab7be9f5-7b45.htm",
"description":"On a network license server, licenses are maintained on the server. No additional steps are needed to preserve network licenses.",
"ancestors":[{"title": "Stand-Alone Licensing","href":"./filesLIC/WSfacf1429558a55de6d0beb1006696e53b-7d14.htm"},{"title": "Troubleshoot a Stand-Alone License Error","href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-4823.htm"}]},
{"title":"Network Licensing",
"href":"./filesLIC/WSfacf1429558a55de6d0beb1006696e53b-7cf2.htm",
"description":"A network license allows you to run an Autodesk product on a network. Network licenses can be purchased through your Authorized Autodesk Reseller.",
"ancestors":[]},
{"title":"Plan Your Network Licensing",
"href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-47ed.htm",
"description":"This section contains information that you need to know before you set up a network license server. The section includes information about supported license server models, license operation and availability, network license file definitions and parameters, license file examples, license types and behaviors, and the license server heartbeat signal.",
"ancestors":[{"title": "Network Licensing","href":"./filesLIC/WSfacf1429558a55de6d0beb1006696e53b-7cf2.htm"}]},
{"title":"System Requirements for the Network License Manager (Windows)",
"href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-46e0.htm",
"description":"Make sure that your network license server meets the minimum recommended requirements. See the following tables for hardware and software requirements.",
"ancestors":[{"title": "Network Licensing","href":"./filesLIC/WSfacf1429558a55de6d0beb1006696e53b-7cf2.htm"},{"title": "Plan Your Network Licensing","href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-47ed.htm"}]},
{"title":"Plan Your License Server Configuration",
"href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-47e8.htm",
"description":"You must decide which license server model to use for managing your Autodesk product licenses on a server. Autodesk supports the following network license server models:",
"ancestors":[{"title": "Network Licensing","href":"./filesLIC/WSfacf1429558a55de6d0beb1006696e53b-7cf2.htm"},{"title": "Plan Your Network Licensing","href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-47ed.htm"}]},
{"title":"Single License Server Model",
"href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-47de.htm",
"description":"In the single license server model, the Network License Manager is installed on a single server, so license management and activity is restricted to this server. A single license file represents the total number of licenses available on the server.",
"ancestors":[{"title": "Network Licensing","href":"./filesLIC/WSfacf1429558a55de6d0beb1006696e53b-7cf2.htm"},{"title": "Plan Your Network Licensing","href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-47ed.htm"},{"title": "Plan Your License Server Configuration","href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-47e8.htm"}]},
{"title":"Distributed License Server Model",
"href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-47d3.htm",
"description":"In the distributed license server model, licenses are distributed across more than one server. A unique license file is required for each server. To create a distributed license server, you must run the Network License Manager on each server that is part of the distributed server pool.",
"ancestors":[{"title": "Network Licensing","href":"./filesLIC/WSfacf1429558a55de6d0beb1006696e53b-7cf2.htm"},{"title": "Plan Your Network Licensing","href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-47ed.htm"},{"title": "Plan Your License Server Configuration","href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-47e8.htm"}]},
{"title":"Redundant License Server Model",
"href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-47c6.htm",
"description":"In the redundant license server model, you use three servers to authenticate a single license file. One server acts as the master, while the other two provide backup if the master server fails. With this configuration, licenses continue to be monitored and issued as long as at least two servers are still functional. The license file on all three servers is the same. You must install the Network License Manager on each server.",
"ancestors":[{"title": "Network Licensing","href":"./filesLIC/WSfacf1429558a55de6d0beb1006696e53b-7cf2.htm"},{"title": "Plan Your Network Licensing","href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-47ed.htm"},{"title": "Plan Your License Server Configuration","href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-47e8.htm"}]},
{"title":"Learn About Your License",
"href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-47b8.htm",
"description":"In this section, you learn about license operation and availability, the license file, license types and behaviors, and the heartbeat signal.",
"ancestors":[{"title": "Network Licensing","href":"./filesLIC/WSfacf1429558a55de6d0beb1006696e53b-7cf2.htm"},{"title": "Plan Your Network Licensing","href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-47ed.htm"}]},
{"title":"License Operation and Availability",
"href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-47b4.htm",
"description":"When you start an Autodesk product, the product determines the server from which it should try to obtain a license. The product then requests a license through the TCP/IP network protocol to the license server.",
"ancestors":[{"title": "Network Licensing","href":"./filesLIC/WSfacf1429558a55de6d0beb1006696e53b-7cf2.htm"},{"title": "Plan Your Network Licensing","href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-47ed.htm"},{"title": "Learn About Your License","href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-47b8.htm"}]},
{"title":"License Files",
"href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-479f.htm",
"description":"The network license file you receive from Autodesk contains licensing information required for a network installation. You obtain license file data when you register your Autodesk product.",
"ancestors":[{"title": "Network Licensing","href":"./filesLIC/WSfacf1429558a55de6d0beb1006696e53b-7cf2.htm"},{"title": "Plan Your Network Licensing","href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-47ed.htm"},{"title": "Learn About Your License","href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-47b8.htm"}]},
{"title":"License File Examples",
"href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-4743.htm",
"description":"License file examples are provided in this document to help you understand how the license files work for your particular network setup. Autodesk provides a standard license file for individual products and a license file with additional parameters for products that are sold both individually and as part of a product set.",
"ancestors":[{"title": "Network Licensing","href":"./filesLIC/WSfacf1429558a55de6d0beb1006696e53b-7cf2.htm"},{"title": "Plan Your Network Licensing","href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-47ed.htm"},{"title": "Learn About Your License","href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-47b8.htm"}]},
{"title":"Example of a License File Not Specific to a Product",
"href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-473b.htm",
"description":"Here is an example of the contents of a license file and the parameters associated with each line:",
"ancestors":[{"title": "Network Licensing","href":"./filesLIC/WSfacf1429558a55de6d0beb1006696e53b-7cf2.htm"},{"title": "Plan Your Network Licensing","href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-47ed.htm"},{"title": "Learn About Your License","href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-47b8.htm"},{"title": "License File Examples","href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-4743.htm"}]},
{"title":"Example of a License File for a Single or Distributed Server",
"href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-4738.htm",
"description":"Here is an example of a completed license file for a single or distributed license server model:",
"ancestors":[{"title": "Network Licensing","href":"./filesLIC/WSfacf1429558a55de6d0beb1006696e53b-7cf2.htm"},{"title": "Plan Your Network Licensing","href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-47ed.htm"},{"title": "Learn About Your License","href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-47b8.htm"},{"title": "License File Examples","href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-4743.htm"}]},
{"title":"Example of a License File for a Redundant Server",
"href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-4733.htm",
"description":"Here is an example of a completed license file for a redundant license server model:",
"ancestors":[{"title": "Network Licensing","href":"./filesLIC/WSfacf1429558a55de6d0beb1006696e53b-7cf2.htm"},{"title": "Plan Your Network Licensing","href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-47ed.htm"},{"title": "Learn About Your License","href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-47b8.htm"},{"title": "License File Examples","href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-4743.htm"}]},
{"title":"Example of a License File for Combined Autodesk Product Versions",
"href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-472e.htm",
"description":"You can combine a license file for different releases of the same Autodesk product or for different Autodesk products, and run all products from one license server. For example, you can combine a license file for AutoCAD 2009 with license files for Autodesk Maya® 2009 and AutoCAD Map.",
"ancestors":[{"title": "Network Licensing","href":"./filesLIC/WSfacf1429558a55de6d0beb1006696e53b-7cf2.htm"},{"title": "Plan Your Network Licensing","href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-47ed.htm"},{"title": "Learn About Your License","href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-47b8.htm"},{"title": "License File Examples","href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-4743.htm"}]},
{"title":"Example of Additional Parameters in a License File",
"href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-4729.htm",
"description":"For Autodesk products that are included in a product set and are also sold as an individual product, licenses are allocated based on a sequence of priorities defined in the license file. For those products, information similar to the following example appears in a license file:",
"ancestors":[{"title": "Network Licensing","href":"./filesLIC/WSfacf1429558a55de6d0beb1006696e53b-7cf2.htm"},{"title": "Plan Your Network Licensing","href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-47ed.htm"},{"title": "Learn About Your License","href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-47b8.htm"},{"title": "License File Examples","href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-4743.htm"}]},
{"title":"Package License File Examples",
"href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-4724.htm",
"description":"Autodesk offers a package license file option, which allows you use of a set of products that are packaged and sold together. The package license file contains a set number of licenses for four different versions of your software. Running an instance of any one of the versions uses one license in the package. Packaged license files support prior versioning for subscription users. Package license files operate under the following guidelines:",
"ancestors":[{"title": "Network Licensing","href":"./filesLIC/WSfacf1429558a55de6d0beb1006696e53b-7cf2.htm"},{"title": "Plan Your Network Licensing","href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-47ed.htm"},{"title": "Learn About Your License","href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-47b8.htm"}]},
{"title":"Example of a Package License File for a Single or Distributed Server",
"href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-4717.htm",
"description":"Here is an example of a completed license file for a single or distributed license server model:",
"ancestors":[{"title": "Network Licensing","href":"./filesLIC/WSfacf1429558a55de6d0beb1006696e53b-7cf2.htm"},{"title": "Plan Your Network Licensing","href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-47ed.htm"},{"title": "Learn About Your License","href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-47b8.htm"},{"title": "Package License File Examples","href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-4724.htm"}]},
{"title":"Example of a Package License File for a Redundant Server",
"href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-4712.htm",
"description":"Here is an example of a completed license file for a redundant license server model:",
"ancestors":[{"title": "Network Licensing","href":"./filesLIC/WSfacf1429558a55de6d0beb1006696e53b-7cf2.htm"},{"title": "Plan Your Network Licensing","href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-47ed.htm"},{"title": "Learn About Your License","href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-47b8.htm"},{"title": "Package License File Examples","href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-4724.htm"}]},
{"title":"Example of a Package License File for Combined Autodesk Product Versions",
"href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-470d.htm",
"description":"Here is an example of a completed license file for combined Autodesk product versions:",
"ancestors":[{"title": "Network Licensing","href":"./filesLIC/WSfacf1429558a55de6d0beb1006696e53b-7cf2.htm"},{"title": "Plan Your Network Licensing","href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-47ed.htm"},{"title": "Learn About Your License","href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-47b8.htm"},{"title": "Package License File Examples","href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-4724.htm"}]},
{"title":"License Types and Behaviors",
"href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-4709.htm",
"description":"Autodesk supports dynamic product usage and license behaviors. This means that you can purchase a specific type of behavior with a specific license and change that license at a later date without having to uninstall and reinstall the Autodesk product.",
"ancestors":[{"title": "Network Licensing","href":"./filesLIC/WSfacf1429558a55de6d0beb1006696e53b-7cf2.htm"},{"title": "Plan Your Network Licensing","href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-47ed.htm"},{"title": "Learn About Your License","href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-47b8.htm"}]},
{"title":"Heartbeat Signal",
"href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-46f1.htm",
"description":"When an Autodesk product is running, it communicates with the license server at regular intervals using a communication method known as the “heartbeat” signal. If the heartbeat signal is lost, the server tries to reconnect. If the server cannot reconnect, the user receives a license error.",
"ancestors":[{"title": "Network Licensing","href":"./filesLIC/WSfacf1429558a55de6d0beb1006696e53b-7cf2.htm"},{"title": "Plan Your Network Licensing","href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-47ed.htm"},{"title": "Learn About Your License","href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-47b8.htm"}]},
{"title":"Network License Manager",
"href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-46eb.htm",
"description":"The Network License Manager is used to configure and manage the license servers. When creating a deployment, the Installation wizard prompts you for information about the license manager, such as license server model and server name.",
"ancestors":[{"title": "Network Licensing","href":"./filesLIC/WSfacf1429558a55de6d0beb1006696e53b-7cf2.htm"}]},
{"title":"Install the Network License Manager",
"href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-46be.htm",
"description":"You can install the Network License Manager before or after you use the Installation wizard. The order in which you install the network applications does not matter, as long as you install everything you need and you provide consistent license server information across the network applications.",
"ancestors":[{"title": "Network Licensing","href":"./filesLIC/WSfacf1429558a55de6d0beb1006696e53b-7cf2.htm"},{"title": "Network License Manager","href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-46eb.htm"}]},
{"title":"Obtain a License Through autodesk.com",
"href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-46a9.htm",
"description":"You can register and activate your network license by going to https://registeronce.autodesk.com and following the on-screen instructions.",
"ancestors":[{"title": "Network Licensing","href":"./filesLIC/WSfacf1429558a55de6d0beb1006696e53b-7cf2.htm"},{"title": "Network License Manager","href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-46eb.htm"}]},
{"title":"Obtain the Server Host Name and Host ID Manually",
"href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-46a6.htm",
"description":"Autodesk uses the server host name, host ID, and product serial number to generate a license file.",
"ancestors":[{"title": "Network Licensing","href":"./filesLIC/WSfacf1429558a55de6d0beb1006696e53b-7cf2.htm"},{"title": "Network License Manager","href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-46eb.htm"}]},
{"title":"Configure a License Server (Windows)",
"href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-4676.htm",
"description":"You configure a license server so that you can manage your Autodesk product licenses. Configure the license server with the lmtools.exe utility.",
"ancestors":[{"title": "Network Licensing","href":"./filesLIC/WSfacf1429558a55de6d0beb1006696e53b-7cf2.htm"},{"title": "Network License Manager","href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-46eb.htm"}]},
{"title":"Install SAMreport-Lite (Optional)",
"href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-4615.htm",
"description":"SAMreport-Lite is a reporting tool that helps you track network license usage. With SAMreport-Lite technology from Acresso™ Software, you can monitor client usage for Autodesk network licensed products.",
"ancestors":[{"title": "Network Licensing","href":"./filesLIC/WSfacf1429558a55de6d0beb1006696e53b-7cf2.htm"},{"title": "Network License Manager","href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-46eb.htm"}]},
{"title":"Uninstall the Network License Manager",
"href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-460f.htm",
"description":"You can uninstall the Network License Manager from the license server. When you uninstall the Network License Manager, licenses are no longer available to your users.",
"ancestors":[{"title": "Network Licensing","href":"./filesLIC/WSfacf1429558a55de6d0beb1006696e53b-7cf2.htm"},{"title": "Network License Manager","href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-46eb.htm"}]},
{"title":"Network Licensing Tools",
"href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-45fd.htm",
"description":"Autodesk Network licensing tools include FLEXnet configuration tools, license borrowing, and SAMreport-Lite. Each tool is described in the sections that follow.",
"ancestors":[{"title": "Network Licensing","href":"./filesLIC/WSfacf1429558a55de6d0beb1006696e53b-7cf2.htm"}]},
{"title":"FLEXnet Configuration Tools",
"href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-45f6.htm",
"description":"The Network License Manager uses FLEXnet® license management technology from Acresso Software. FLEXnet provides administrative tools that help to simplify management of network licenses. You can use FLEXnet tools to monitor network license status, reset licenses lost to a system failure, troubleshoot license servers, and update existing license files on the fly.",
"ancestors":[{"title": "Network Licensing","href":"./filesLIC/WSfacf1429558a55de6d0beb1006696e53b-7cf2.htm"},{"title": "Network Licensing Tools","href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-45fd.htm"}]},
{"title":"Utilities for License Server Management",
"href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-45f1.htm",
"description":"FLEXnet provides two utilities for managing the license server. These tools are located in the C:\Program Files\Autodesk Network License Manager folder.",
"ancestors":[{"title": "Network Licensing","href":"./filesLIC/WSfacf1429558a55de6d0beb1006696e53b-7cf2.htm"},{"title": "Network Licensing Tools","href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-45fd.htm"},{"title": "FLEXnet Configuration Tools","href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-45f6.htm"}]},
{"title":"Stop and Restart the License Server",
"href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-45e1.htm",
"description":"Before you can perform any system maintenance on your license server, you must stop the license server. When you have completed maintenance, you can restart the license server.",
"ancestors":[{"title": "Network Licensing","href":"./filesLIC/WSfacf1429558a55de6d0beb1006696e53b-7cf2.htm"},{"title": "Network Licensing Tools","href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-45fd.htm"},{"title": "FLEXnet Configuration Tools","href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-45f6.htm"}]},
{"title":"Update FLEXnet from a Previous Version",
"href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-45b6.htm",
"description":"This release of Autodesk products and later require FLEXnet version 11.7.0.0 or later. If you are currently using a version of FLEXnet that is earlier than 11.7.0.0, you need to upgrade to version 11.7.0.0 or later.",
"ancestors":[{"title": "Network Licensing","href":"./filesLIC/WSfacf1429558a55de6d0beb1006696e53b-7cf2.htm"},{"title": "Network Licensing Tools","href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-45fd.htm"},{"title": "FLEXnet Configuration Tools","href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-45f6.htm"}]},
{"title":"Set Up and Use an Options File",
"href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-4560.htm",
"description":"With an Options file, you set configuration options for managing licenses on each license server that you set up. An Options file sets parameters that the license file reads and the lmgrd program executes.",
"ancestors":[{"title": "Network Licensing","href":"./filesLIC/WSfacf1429558a55de6d0beb1006696e53b-7cf2.htm"},{"title": "Network Licensing Tools","href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-45fd.htm"},{"title": "FLEXnet Configuration Tools","href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-45f6.htm"}]},
{"title":"Create an Options file",
"href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-4543.htm",
"description":"You should be logged in with Administrator rights when working with the LMTOOLS utility.",
"ancestors":[{"title": "Network Licensing","href":"./filesLIC/WSfacf1429558a55de6d0beb1006696e53b-7cf2.htm"},{"title": "Network Licensing Tools","href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-45fd.htm"},{"title": "FLEXnet Configuration Tools","href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-45f6.htm"},{"title": "Set Up and Use an Options File","href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-4560.htm"}]},
{"title":"Create a Report Log",
"href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-4533.htm",
"description":"In the Options file, you can create a report log file that is used with SAMreport-Lite.",
"ancestors":[{"title": "Network Licensing","href":"./filesLIC/WSfacf1429558a55de6d0beb1006696e53b-7cf2.htm"},{"title": "Network Licensing Tools","href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-45fd.htm"},{"title": "FLEXnet Configuration Tools","href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-45f6.htm"},{"title": "Set Up and Use an Options File","href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-4560.htm"}]},
{"title":"Configure License Borrowing with the Options File",
"href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-4524.htm",
"description":"If your Autodesk product supports the license borrowing feature, you can use the Options file to configure license borrowing options. For example, you can define the maximum number of licenses that cannot be borrowed from your network at any one time. In addition, you can define which users can borrow an Autodesk product license. Licenses are borrowed per user, not per machine.",
"ancestors":[{"title": "Network Licensing","href":"./filesLIC/WSfacf1429558a55de6d0beb1006696e53b-7cf2.htm"},{"title": "Network Licensing Tools","href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-45fd.htm"},{"title": "FLEXnet Configuration Tools","href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-45f6.htm"},{"title": "Set Up and Use an Options File","href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-4560.htm"}]},
{"title":"Set Up License Timeout",
"href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-450d.htm",
"description":"License timeout is set in the Options file to determine how long a product session can be idle before the license is reclaimed by the license server. When you set this flag in the Options file, a user\'s license is reclaimed by the license server if the product is idle on a workstation for more than the timeout period you define.",
"ancestors":[{"title": "Network Licensing","href":"./filesLIC/WSfacf1429558a55de6d0beb1006696e53b-7cf2.htm"},{"title": "Network Licensing Tools","href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-45fd.htm"},{"title": "FLEXnet Configuration Tools","href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-45f6.htm"},{"title": "Set Up and Use an Options File","href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-4560.htm"}]},
{"title":"License Borrowing",
"href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-44f7.htm",
"description":"If you are running a network-licensed version of the program, you can borrow a license from a license server to use the program for a specified time when your computer is not connected to the network.",
"ancestors":[{"title": "Network Licensing","href":"./filesLIC/WSfacf1429558a55de6d0beb1006696e53b-7cf2.htm"},{"title": "Network Licensing Tools","href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-45fd.htm"}]},
{"title":"Overview",
"href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-44ed.htm",
"description":"If you are using a network-licensed version of your Autodesk product and your network administrator supports the license borrowing feature, you can borrow a product license from your network license server to use the program when your computer is not connected to the network. Your license is automatically returned to the license server at the end of the day on the return date you set when you borrowed the license. You can also return a license early.",
"ancestors":[{"title": "Network Licensing","href":"./filesLIC/WSfacf1429558a55de6d0beb1006696e53b-7cf2.htm"},{"title": "Network Licensing Tools","href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-45fd.htm"},{"title": "License Borrowing","href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-44f7.htm"}]},
{"title":"Borrow a License",
"href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-44df.htm",
"description":"You can run the program when your computer is not connected to the network until your license-borrowing period ends. If you don\'t remember the date that a license expires, you can check the date by placing your cursor over the Borrowing icon in the program\'s status tray or by clicking Help About and using the Product Information dialog box.",
"ancestors":[{"title": "Network Licensing","href":"./filesLIC/WSfacf1429558a55de6d0beb1006696e53b-7cf2.htm"},{"title": "Network Licensing Tools","href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-45fd.htm"},{"title": "License Borrowing","href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-44f7.htm"}]},
{"title":"BORROWLICENSE Command",
"href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-44ab.htm",
"description":"Borrows a product license so that you can run the product outside the network environment.",
"ancestors":[{"title": "Network Licensing","href":"./filesLIC/WSfacf1429558a55de6d0beb1006696e53b-7cf2.htm"},{"title": "Network Licensing Tools","href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-45fd.htm"},{"title": "License Borrowing","href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-44f7.htm"}]},
{"title":"Borrow a License Window",
"href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-44a1.htm",
"description":"Tools menu: License Borrowing Borrow License",
"ancestors":[{"title": "Network Licensing","href":"./filesLIC/WSfacf1429558a55de6d0beb1006696e53b-7cf2.htm"},{"title": "Network Licensing Tools","href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-45fd.htm"},{"title": "License Borrowing","href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-44f7.htm"},{"title": "BORROWLICENSE Command","href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-44ab.htm"}]},
{"title":"Return a License",
"href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-4491.htm",
"description":"Your network license is automatically returned to the network license server on the day that the license expires. You can also return a license earlier than the date you originally selected, as long as your computer is connected to the network license server when you attempt to return the borrowed license.",
"ancestors":[{"title": "Network Licensing","href":"./filesLIC/WSfacf1429558a55de6d0beb1006696e53b-7cf2.htm"},{"title": "Network Licensing Tools","href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-45fd.htm"},{"title": "License Borrowing","href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-44f7.htm"}]},
{"title":"RETURNLICENSE Command",
"href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-4473.htm",
"description":"Returns a borrowed Autodesk product license earlier than the original return date that you specified when you borrowed the license.",
"ancestors":[{"title": "Network Licensing","href":"./filesLIC/WSfacf1429558a55de6d0beb1006696e53b-7cf2.htm"},{"title": "Network Licensing Tools","href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-45fd.htm"},{"title": "License Borrowing","href":"./filesLIC/WS1a9193826455f5ff-3859b43c1209703a838-44f7.htm"}]},
{"title":"Network Licensing FAQs",
"href":"./filesLIC/WS73099cc142f48755f2fc9df120970276f7-50db.htm",
"description":"This section outlines some common questions and their solutions with regards to software licenses and licensing your product(s).",
"ancestors":[{"title": "Network Licensing","href":"./filesLIC/WSfacf1429558a55de6d0beb1006696e53b-7cf2.htm"}]},
{"title":"What is the difference between a stand-alone license and a network license?",
"href":"./filesLIC/WS73099cc142f48755f2fc9df120970276f7-50d5.htm",
"description":"Stand-alone licensed products are registered and activated to an individual workstation. While the software can be installed on multiple systems in your facility, the license only allows one system to be operational. If you need to run more systems, you need to purchase more stand-alone licensed products, or consider converting to network licenses.",
"ancestors":[{"title": "Network Licensing","href":"./filesLIC/WSfacf1429558a55de6d0beb1006696e53b-7cf2.htm"},{"title": "Network Licensing FAQs","href":"./filesLIC/WS73099cc142f48755f2fc9df120970276f7-50db.htm"}]},
{"title":"What is the benefit of using a network licensed version of the software?",
"href":"./filesLIC/WS73099cc142f48755f2fc9df120970276f7-50ce.htm",
"description":"Network licensed products are recommended for large drafting/design facilities, classrooms, and lab environments. The main advantage is that you can install products on more systems than the number of licenses you have purchased (for example, purchasing 25 licenses but installing on 40 workstations). At any one time, products will run on the maximum number of systems for which you have licenses. This means you get a true floating license. If software needs to be run on more systems, additional licenses can be purchased.",
"ancestors":[{"title": "Network Licensing","href":"./filesLIC/WSfacf1429558a55de6d0beb1006696e53b-7cf2.htm"},{"title": "Network Licensing FAQs","href":"./filesLIC/WS73099cc142f48755f2fc9df120970276f7-50db.htm"}]},
{"title":"What is Internet Explorer used for?",
"href":"./filesLIC/WS73099cc142f48755f2fc9df120970276f7-50c7.htm",
"description":"After installing your product, you can operate in trial mode for a given number of days. Whenever you launch the program, you are prompted to activate the software. When you choose to activate the software, Internet Explorer makes this process much faster. Once you entered your registration data and submit it to Autodesk, an activation code is returned and you are not prompted again during startup.",
"ancestors":[{"title": "Network Licensing","href":"./filesLIC/WSfacf1429558a55de6d0beb1006696e53b-7cf2.htm"},{"title": "Network Licensing FAQs","href":"./filesLIC/WS73099cc142f48755f2fc9df120970276f7-50db.htm"}]},
{"title":"Glossary",
"href":"./filesLIC/WSfacf1429558a55de6d0beb1006696e53b-7c1a.htm",
"description":"",
"ancestors":[]},
]);
top.HlpSys.search.data.registerSearchProvider(searchResultProvider);
// SIG // Begin signature block
// SIG // MIIMzQYJKoZIhvcNAQcCoIIMvjCCDLoCAQExDjAMBggq
// SIG // hkiG9w0CBQUAMGYGCisGAQQBgjcCAQSgWDBWMDIGCisG
// SIG // AQQBgjcCAR4wJAIBAQQQEODJBs441BGiowAQS9NQkAIB
// SIG // AAIBAAIBAAIBAAIBADAgMAwGCCqGSIb3DQIFBQAEEJwg
// SIG // IP2OB2J8y4Y2BSXADXigggoPMIIE/DCCBGWgAwIBAgIQ
// SIG // ZVIm4bIuGOFZDymFrCLnXDANBgkqhkiG9w0BAQUFADBf
// SIG // MQswCQYDVQQGEwJVUzEXMBUGA1UEChMOVmVyaVNpZ24s
// SIG // IEluYy4xNzA1BgNVBAsTLkNsYXNzIDMgUHVibGljIFBy
// SIG // aW1hcnkgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkwHhcN
// SIG // MDkwNTIxMDAwMDAwWhcNMTkwNTIwMjM1OTU5WjCBtjEL
// SIG // MAkGA1UEBhMCVVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJ
// SIG // bmMuMR8wHQYDVQQLExZWZXJpU2lnbiBUcnVzdCBOZXR3
// SIG // b3JrMTswOQYDVQQLEzJUZXJtcyBvZiB1c2UgYXQgaHR0
// SIG // cHM6Ly93d3cudmVyaXNpZ24uY29tL3JwYSAoYykwOTEw
// SIG // MC4GA1UEAxMnVmVyaVNpZ24gQ2xhc3MgMyBDb2RlIFNp
// SIG // Z25pbmcgMjAwOS0yIENBMIIBIjANBgkqhkiG9w0BAQEF
// SIG // AAOCAQ8AMIIBCgKCAQEAvmcdtGCqEElvVhd8Zslehg3V
// SIG // 8ayncYOOi4n4iASJFQa6LYQhleTRnFBM+9IivdrysjU7
// SIG // Ho/DCfv8Ey5av4l8PTslHvbzWHuc9AG1xgq4gM6+J3Rh
// SIG // ZydNauXsgWFYeaPgFxASFSew4U00fytHIES53mYkZorN
// SIG // T7ofxTjIVJDhcvYZZnVquUlozzh5DaowqNssYEie16oU
// SIG // AamD1ziRMDkTlgM6fEBUtq3gLxuD3KgRUj4Cs9cr/SG2
// SIG // p1yjDwupphBQDjQuTafOyV4l1Iy88258KbwBXfwxh1rV
// SIG // jIVnWIgZoL818OoroyHnkPaD5ajtYHhee2CD/VcLXUEN
// SIG // Y1Rg1kMh7wIDAQABo4IB2zCCAdcwEgYDVR0TAQH/BAgw
// SIG // BgEB/wIBADBwBgNVHSAEaTBnMGUGC2CGSAGG+EUBBxcD
// SIG // MFYwKAYIKwYBBQUHAgEWHGh0dHBzOi8vd3d3LnZlcmlz
// SIG // aWduLmNvbS9jcHMwKgYIKwYBBQUHAgIwHhocaHR0cHM6
// SIG // Ly93d3cudmVyaXNpZ24uY29tL3JwYTAOBgNVHQ8BAf8E
// SIG // BAMCAQYwbQYIKwYBBQUHAQwEYTBfoV2gWzBZMFcwVRYJ
// SIG // aW1hZ2UvZ2lmMCEwHzAHBgUrDgMCGgQUj+XTGoasjY5r
// SIG // w8+AatRIGCx7GS4wJRYjaHR0cDovL2xvZ28udmVyaXNp
// SIG // Z24uY29tL3ZzbG9nby5naWYwHQYDVR0lBBYwFAYIKwYB
// SIG // BQUHAwIGCCsGAQUFBwMDMDQGCCsGAQUFBwEBBCgwJjAk
// SIG // BggrBgEFBQcwAYYYaHR0cDovL29jc3AudmVyaXNpZ24u
// SIG // Y29tMDEGA1UdHwQqMCgwJqAkoCKGIGh0dHA6Ly9jcmwu
// SIG // dmVyaXNpZ24uY29tL3BjYTMuY3JsMCkGA1UdEQQiMCCk
// SIG // HjAcMRowGAYDVQQDExFDbGFzczNDQTIwNDgtMS01NTAd
// SIG // BgNVHQ4EFgQUl9BrqCZwyKE/lB8ILcQ1m6ShHvIwDQYJ
// SIG // KoZIhvcNAQEFBQADgYEAiwPA3ZTYQaJhabAVqHjHMMaQ
// SIG // PH5C9yS25INzFwR/BBCcoeL6gS/rwMpE53LgULZVECCD
// SIG // bpaS5JpRarQ3MdylLeuMAMcdT+dNMrqF+E6++mdVZfBq
// SIG // vnrKZDgaEBB4RXYx84Z6Aw9gwrNdnfaLZnaCG1nhg+W9
// SIG // SaU4VuXeQXcOWA8wggULMIID86ADAgECAhAjTaBL0kKF
// SIG // PErLmuhhwhm7MA0GCSqGSIb3DQEBBQUAMIG2MQswCQYD
// SIG // VQQGEwJVUzEXMBUGA1UEChMOVmVyaVNpZ24sIEluYy4x
// SIG // HzAdBgNVBAsTFlZlcmlTaWduIFRydXN0IE5ldHdvcmsx
// SIG // OzA5BgNVBAsTMlRlcm1zIG9mIHVzZSBhdCBodHRwczov
// SIG // L3d3dy52ZXJpc2lnbi5jb20vcnBhIChjKTA5MTAwLgYD
// SIG // VQQDEydWZXJpU2lnbiBDbGFzcyAzIENvZGUgU2lnbmlu
// SIG // ZyAyMDA5LTIgQ0EwHhcNMDkwODI3MDAwMDAwWhcNMTIw
// SIG // OTIwMjM1OTU5WjCByDELMAkGA1UEBhMCVVMxEzARBgNV
// SIG // BAgTCkNhbGlmb3JuaWExEzARBgNVBAcTClNhbiBSYWZh
// SIG // ZWwxFjAUBgNVBAoUDUF1dG9kZXNrLCBJbmMxPjA8BgNV
// SIG // BAsTNURpZ2l0YWwgSUQgQ2xhc3MgMyAtIE1pY3Jvc29m
// SIG // dCBTb2Z0d2FyZSBWYWxpZGF0aW9uIHYyMR8wHQYDVQQL
// SIG // FBZEZXNpZ24gU29sdXRpb25zIEdyb3VwMRYwFAYDVQQD
// SIG // FA1BdXRvZGVzaywgSW5jMIGfMA0GCSqGSIb3DQEBAQUA
// SIG // A4GNADCBiQKBgQC1R1YKdvQF2Rj4+knWfj81afUtVyep
// SIG // GF2P4tcYD53qlYmYi9t9Csc6PMWlUZhMGbOceQKYcBjc
// SIG // mWvyghJnoaEQ6796ZcsLD0pMH2R4SpV/SjxiQ280beig
// SIG // NerJS5X+ftOMCs1qSQ1LXlRFEohaewkNWsIp/+f1Y0vE
// SIG // dGzggnEKOQIDAQABo4IBgzCCAX8wCQYDVR0TBAIwADAO
// SIG // BgNVHQ8BAf8EBAMCB4AwRAYDVR0fBD0wOzA5oDegNYYz
// SIG // aHR0cDovL2NzYzMtMjAwOS0yLWNybC52ZXJpc2lnbi5j
// SIG // b20vQ1NDMy0yMDA5LTIuY3JsMEQGA1UdIAQ9MDswOQYL
// SIG // YIZIAYb4RQEHFwMwKjAoBggrBgEFBQcCARYcaHR0cHM6
// SIG // Ly93d3cudmVyaXNpZ24uY29tL3JwYTATBgNVHSUEDDAK
// SIG // BggrBgEFBQcDAzB1BggrBgEFBQcBAQRpMGcwJAYIKwYB
// SIG // BQUHMAGGGGh0dHA6Ly9vY3NwLnZlcmlzaWduLmNvbTA/
// SIG // BggrBgEFBQcwAoYzaHR0cDovL2NzYzMtMjAwOS0yLWFp
// SIG // YS52ZXJpc2lnbi5jb20vQ1NDMy0yMDA5LTIuY2VyMB8G
// SIG // A1UdIwQYMBaAFJfQa6gmcMihP5QfCC3ENZukoR7yMBEG
// SIG // CWCGSAGG+EIBAQQEAwIEEDAWBgorBgEEAYI3AgEbBAgw
// SIG // BgEBAAEB/zANBgkqhkiG9w0BAQUFAAOCAQEAIfxkh8Fd
// SIG // IHK+qtTf+9Eq5fjkk5gMMTQCOa+2aR7mqDzLfIFRGQzr
// SIG // tcc5/izsb/wPLUwdw1cRpnxO8/qLA2Ol+b99FONTOyyc
// SIG // Y8unwviYhdEjuFmqHkyC5MUYroZEjvTObFkkgN98Y48h
// SIG // C+mG2hdlVKXR0zr9r5q/rmmivVWbojvcYKHoW31O5OcM
// SIG // PsrWuOD305Ygmpck/91iopE3UN4tfeWYhzNj1F6Ai4Xa
// SIG // 5KiaMcs3zmoZ+6SePyI2YUgtff6yvy/rk8KVT41KGD2h
// SIG // fC+QrtVSkoDWP/MDtLjbTPCWElC1NWSEKowRI8t2x594
// SIG // Skjnzu/W5Lh97ixircOuM4IvBzGCAigwggIkAgEBMIHL
// SIG // MIG2MQswCQYDVQQGEwJVUzEXMBUGA1UEChMOVmVyaVNp
// SIG // Z24sIEluYy4xHzAdBgNVBAsTFlZlcmlTaWduIFRydXN0
// SIG // IE5ldHdvcmsxOzA5BgNVBAsTMlRlcm1zIG9mIHVzZSBh
// SIG // dCBodHRwczovL3d3dy52ZXJpc2lnbi5jb20vcnBhIChj
// SIG // KTA5MTAwLgYDVQQDEydWZXJpU2lnbiBDbGFzcyAzIENv
// SIG // ZGUgU2lnbmluZyAyMDA5LTIgQ0ECECNNoEvSQoU8Ssua
// SIG // 6GHCGbswDAYIKoZIhvcNAgUFAKCBsDAZBgkqhkiG9w0B
// SIG // CQMxDAYKKwYBBAGCNwIBBDAcBgorBgEEAYI3AgELMQ4w
// SIG // DAYKKwYBBAGCNwIBFTAfBgkqhkiG9w0BCQQxEgQQdmyF
// SIG // vqzKxrBXEh1f4+dNPjBUBgorBgEEAYI3AgEMMUYwRKAm
// SIG // gCQAQQB1AHQAbwBkAGUAcwBrACAAQwBvAG0AcABvAG4A
// SIG // ZQBuAHShGoAYaHR0cDovL3d3dy5hdXRvZGVzay5jb20g
// SIG // MA0GCSqGSIb3DQEBAQUABIGACTWQ0Qmu+1ifgG96XAkr
// SIG // U7Y2vmV7ngVtCnV1GFQxVn73h/a4cOoiBAB2HhAI/Zkz
// SIG // 2MO44tHrswb03iIfHhgOwbDmdFXkEBoKGGtM9oxckKn0
// SIG // 3cbVFLa+7htBec3z53+mH5492YkSRLTeEAuEwl0CAw8g
// SIG // D9m1i8njutD7MdInjS4=
// SIG // End signature block
