var searchResultProvider = new SearchResultsProvider("InstallLT", "Installation Guide");
searchResultProvider.setTopicInfoList(["",{"title":"Stand-Alone Installation",
"href":"./filesInstallLT/WS1a9193826455f5ff-3859b43c1209703a838-3015.htm",
"description":"AutoCAD LT Installation provides instructions about how to prepare, and then install AutoCAD LT 2011. If you have never installed the product before, you should familiarize yourself with the entire installation process and options before beginning.",
"ancestors":[]},
{"title":"Preparing for Installation",
"href":"./filesInstallLT/WS1a9193826455f5ff3d6161141208a8044f3-7b4c.htm",
"description":"To prepare for installation, you should review the system requirements, understand administrative permission requirements, locate your AutoCAD LT serial number and product key, and close all running applications. Complete these tasks, and you are ready to begin installing AutoCAD LT.",
"ancestors":[{"title": "Stand-Alone Installation","href":"./filesInstallLT/WS1a9193826455f5ff-3859b43c1209703a838-3015.htm"}]},
{"title":"System Requirements",
"href":"./filesInstallLT/WS1a9193826455f5ff3d6161141208a8044f3-7b48.htm",
"description":"The first task you need to complete is to make sure that your computer meets the minimum system requirements. If your system does not meet these requirements, problems can occur, both within AutoCAD LT and at the operating system level.",
"ancestors":[{"title": "Stand-Alone Installation","href":"./filesInstallLT/WS1a9193826455f5ff-3859b43c1209703a838-3015.htm"},{"title": "Preparing for Installation","href":"./filesInstallLT/WS1a9193826455f5ff3d6161141208a8044f3-7b4c.htm"}]},
{"title":"Administrative Permission Requirements",
"href":"./filesInstallLT/WS1a9193826455f5ff3d6161141208a8044f3-7ad5.htm",
"description":"To install AutoCAD LT, you must have administrator permissions. You do not need to have domain administrative permissions. See your system administrator for information about administrative permissions.",
"ancestors":[{"title": "Stand-Alone Installation","href":"./filesInstallLT/WS1a9193826455f5ff-3859b43c1209703a838-3015.htm"},{"title": "Preparing for Installation","href":"./filesInstallLT/WS1a9193826455f5ff3d6161141208a8044f3-7b4c.htm"}]},
{"title":"Locating Your Serial Number and Product Key",
"href":"./filesInstallLT/WS1a9193826455f5ff3d6161141208a8044f3-7acf.htm",
"description":"When you install AutoCAD LT, you are prompted for your serial number and product key in the Product and User Information page, or the option of installing the product in trial mode. You may enter your product information at any time during your trial mode period if you opt to install the product in that mode.",
"ancestors":[{"title": "Stand-Alone Installation","href":"./filesInstallLT/WS1a9193826455f5ff-3859b43c1209703a838-3015.htm"},{"title": "Preparing for Installation","href":"./filesInstallLT/WS1a9193826455f5ff3d6161141208a8044f3-7b4c.htm"}]},
{"title":"Minimize the Chances of Installation Failure",
"href":"./filesInstallLT/WS1a9193826455f5ff3d6161141208a8044f3-7ac6.htm",
"description":"The AutoCAD LT installation process may stop if some applications such as Microsoft® Outlook® or virus-checking programs are running. Close all running applications to avoid possible installation problems and data loss.",
"ancestors":[{"title": "Stand-Alone Installation","href":"./filesInstallLT/WS1a9193826455f5ff-3859b43c1209703a838-3015.htm"},{"title": "Preparing for Installation","href":"./filesInstallLT/WS1a9193826455f5ff3d6161141208a8044f3-7b4c.htm"}]},
{"title":"Choose a Language",
"href":"./filesInstallLT/WS1a9193826455f5ff3d6161141208a8044f3-7abe.htm",
"description":"You can specify both the language in which the installation or deployment instructions are displayed, and the language of the products being installed or deployed.",
"ancestors":[{"title": "Stand-Alone Installation","href":"./filesInstallLT/WS1a9193826455f5ff-3859b43c1209703a838-3015.htm"},{"title": "Preparing for Installation","href":"./filesInstallLT/WS1a9193826455f5ff3d6161141208a8044f3-7b4c.htm"}]},
{"title":"Migrating Custom Settings",
"href":"./filesInstallLT/WS1a9193826455f5ff3d6161141208a8044f3-7aa4.htm",
"description":"You can migrate your custom settings and files from previous releases of AutoCAD LT (AutoCAD LT 2000 through AutoCAD LT 2011). It is recommended that you migrate custom settings from a previous release right away. This prevents you from overwriting files or having to keep track of any custom settings you may make in the new release. Migrating settings overwrites any new settings.",
"ancestors":[{"title": "Stand-Alone Installation","href":"./filesInstallLT/WS1a9193826455f5ff-3859b43c1209703a838-3015.htm"},{"title": "Preparing for Installation","href":"./filesInstallLT/WS1a9193826455f5ff3d6161141208a8044f3-7b4c.htm"}]},
{"title":"Installing and Running the Product",
"href":"./filesInstallLT/WS1a9193826455f5ff3d6161141208a8044f3-7a94.htm",
"description":"To use the product, you must install the product, register and activate it, and then launch it. You must have administrative permissions to install AutoCAD LT.",
"ancestors":[{"title": "Stand-Alone Installation","href":"./filesInstallLT/WS1a9193826455f5ff-3859b43c1209703a838-3015.htm"}]},
{"title":"Installing AutoCAD LT",
"href":"./filesInstallLT/WS1a9193826455f5ff3d6161141208a8044f3-7a90.htm",
"description":"The AutoCAD LT Installation wizard contains all installation-related material in one place. From the installation wizard, you can access user documentation, change the installer language, select a language for your product, install supplemental tools, and add online support services.",
"ancestors":[{"title": "Stand-Alone Installation","href":"./filesInstallLT/WS1a9193826455f5ff-3859b43c1209703a838-3015.htm"},{"title": "Installing and Running the Product","href":"./filesInstallLT/WS1a9193826455f5ff3d6161141208a8044f3-7a94.htm"}]},
{"title":"Install AutoCAD LT Using Default Settings on a Stand-Alone Computer",
"href":"./filesInstallLT/WS1a9193826455f5ff453265c9125faa23bbb-6207.htm",
"description":"Using the default installation settings is the fastest way to install AutoCAD LT on a single, stand-alone system. A default installation does the following:",
"ancestors":[{"title": "Stand-Alone Installation","href":"./filesInstallLT/WS1a9193826455f5ff-3859b43c1209703a838-3015.htm"},{"title": "Installing and Running the Product","href":"./filesInstallLT/WS1a9193826455f5ff3d6161141208a8044f3-7a94.htm"},{"title": "Installing AutoCAD LT","href":"./filesInstallLT/WS1a9193826455f5ff3d6161141208a8044f3-7a90.htm"}]},
{"title":"Install AutoCAD LT Using Custom Settings on a Stand-Alone Computer",
"href":"./filesInstallLT/WS1a9193826455f5ff453265c9125faa23bbb-6203.htm",
"description":"With this method, you can customize your installation.",
"ancestors":[{"title": "Stand-Alone Installation","href":"./filesInstallLT/WS1a9193826455f5ff-3859b43c1209703a838-3015.htm"},{"title": "Installing and Running the Product","href":"./filesInstallLT/WS1a9193826455f5ff3d6161141208a8044f3-7a94.htm"},{"title": "Installing AutoCAD LT","href":"./filesInstallLT/WS1a9193826455f5ff3d6161141208a8044f3-7a90.htm"}]},
{"title":"Register and Activate AutoCAD LT",
"href":"./filesInstallLT/WS1a9193826455f5ff3d6161141208a8044f3-7a2b.htm",
"description":"The first time you start AutoCAD LT, the Product License Activation wizard is displayed. You can either activate AutoCAD LT at that time, or Try AutoCAD LT and activate it later. Until you register and enter a valid activation code for AutoCAD LT, you are operating the program in trial mode and the Product License Activation wizard is displayed for 30 days from the first time that you run the program.",
"ancestors":[{"title": "Stand-Alone Installation","href":"./filesInstallLT/WS1a9193826455f5ff-3859b43c1209703a838-3015.htm"},{"title": "Installing and Running the Product","href":"./filesInstallLT/WS1a9193826455f5ff3d6161141208a8044f3-7a94.htm"}]},
{"title":"Launch AutoCAD LT",
"href":"./filesInstallLT/WS1a9193826455f5ff3d6161141208a8044f3-7a09.htm",
"description":"Assuming that you followed all of the previous steps outlined in this installation section, you can launch AutoCAD LT and start taking advantage of its new and updated features. For more detailed information about the new features, learning videos, online Help, or AutoCAD LT services and support, see the Welcome screen after you launch the product.",
"ancestors":[{"title": "Stand-Alone Installation","href":"./filesInstallLT/WS1a9193826455f5ff-3859b43c1209703a838-3015.htm"},{"title": "Installing and Running the Product","href":"./filesInstallLT/WS1a9193826455f5ff3d6161141208a8044f3-7a94.htm"}]},
{"title":"Add or Remove Features",
"href":"./filesInstallLT/WS1a9193826455f5ff3d6161141208a8044f3-79fe.htm",
"description":"You can add or remove AutoCAD LT features at any time. For example, you may have chosen a Custom installation option when you first installed AutoCAD LT, but now you want to add features that you did not install originally. Or you may no longer need to use all of the features that were installed originally. You can add or remove features by using the Add or Remove Programs dialog box.",
"ancestors":[{"title": "Stand-Alone Installation","href":"./filesInstallLT/WS1a9193826455f5ff-3859b43c1209703a838-3015.htm"},{"title": "Installing and Running the Product","href":"./filesInstallLT/WS1a9193826455f5ff3d6161141208a8044f3-7a94.htm"}]},
{"title":"Reinstall or Repair AutoCAD LT",
"href":"./filesInstallLT/WS1a9193826455f5ff3d6161141208a8044f3-79e5.htm",
"description":"If you accidentally delete or alter files that are required by AutoCAD LT, AutoCAD LT might not perform correctly, and you might receive error messages when you try to execute a command or find a file. You can attempt to fix this problem by reinstalling or repairing AutoCAD LT. The reinstallation or repair uses the features that were part of the installation type you chose when you initially installed the program.",
"ancestors":[{"title": "Stand-Alone Installation","href":"./filesInstallLT/WS1a9193826455f5ff-3859b43c1209703a838-3015.htm"},{"title": "Installing and Running the Product","href":"./filesInstallLT/WS1a9193826455f5ff3d6161141208a8044f3-7a94.htm"}]},
{"title":"Uninstall AutoCAD LT",
"href":"./filesInstallLT/WS1a9193826455f5ff3d6161141208a8044f3-79cd.htm",
"description":"When you uninstall AutoCAD LT, all components are removed. This means that even if you\'ve previously added or removed components, or if you\'ve reinstalled or repaired AutoCAD LT, the uninstall removes all AutoCAD LT installation files from your system.",
"ancestors":[{"title": "Stand-Alone Installation","href":"./filesInstallLT/WS1a9193826455f5ff-3859b43c1209703a838-3015.htm"},{"title": "Installing and Running the Product","href":"./filesInstallLT/WS1a9193826455f5ff3d6161141208a8044f3-7a94.htm"}]},
{"title":"Installing Multiple or Bundled Products",
"href":"./filesInstallLT/WS1a9193826455f5ff3d6161141208a8044f3-7a9c.htm",
"description":"Some Autodesk packages are comprised of multiple products or are part of multi-product bundles.",
"ancestors":[{"title": "Stand-Alone Installation","href":"./filesInstallLT/WS1a9193826455f5ff-3859b43c1209703a838-3015.htm"},{"title": "Installing and Running the Product","href":"./filesInstallLT/WS1a9193826455f5ff3d6161141208a8044f3-7a94.htm"}]},
{"title":"Installing Design Review",
"href":"./filesInstallLT/WS1a9193826455f5ff3d6161141208a8044f3-79b7.htm",
"description":"Autodesk Design Review 2011 is not installed by default when you install AutoCAD LT. It is recommended that Design Review be installed if you need to view DWF or DWFx files.",
"ancestors":[{"title": "Stand-Alone Installation","href":"./filesInstallLT/WS1a9193826455f5ff-3859b43c1209703a838-3015.htm"},{"title": "Installing and Running the Product","href":"./filesInstallLT/WS1a9193826455f5ff3d6161141208a8044f3-7a94.htm"}]},
{"title":"Migrating and Customizing",
"href":"./filesInstallLT/WS1a9193826455f5ff-e569a012180ce58914566.htm",
"description":"If you have a previous version of AutoCAD LT installed on your system, you can install a newer version of AutoCAD LT and keep other versions of the program on the same system. This is called a side-by-side installation. If you have purchased an upgrade version of AutoCAD LT, you are required to uninstall the previous version within 120 days of installing your newer product. See your license agreement for more information.",
"ancestors":[]},
{"title":"Migrate Custom Settings and Files from Previous Releases",
"href":"./filesInstallLT/WS1a9193826455f5ff3d6161141208a8044f3-7999.htm",
"description":"You can migrate your custom settings and files from previous releases of AutoCAD LT to your new release. It is recommended that you migrate from a previous release right away. This prevents you from overwriting files or having to keep track of any custom settings you may make in the new release. Migrating settings overwrites any new settings.",
"ancestors":[{"title": "Migrating and Customizing","href":"./filesInstallLT/WS1a9193826455f5ff-e569a012180ce58914566.htm"}]},
{"title":"Migrate Custom Settings",
"href":"./filesInstallLT/WS1a9193826455f5ff3d6161141208a8044f3-7983.htm",
"description":"If you install AutoCAD LT on a computer where a previous release of the AutoCAD LT product is installed, you can migrate some custom settings from a previous release to your newer AutoCAD LT product.",
"ancestors":[{"title": "Migrating and Customizing","href":"./filesInstallLT/WS1a9193826455f5ff-e569a012180ce58914566.htm"},{"title": "Migrate Custom Settings and Files from Previous Releases","href":"./filesInstallLT/WS1a9193826455f5ff3d6161141208a8044f3-7999.htm"}]},
{"title":"View the Migration Log File",
"href":"./filesInstallLT/WS1a9193826455f5ff3d6161141208a8044f3-790c.htm",
"description":"The migration log file (migration.xml) provides specific information about any settings or files that were not successfully migrated to AutoCAD LT. The log file shows all the files that were successfully copied from a previous version to the newer AutoCAD LT. It also provides information about files that were not successfully migrated. Use the log for troubleshooting if there are unwanted or unexpected results in your AutoCAD LT profiles.",
"ancestors":[{"title": "Migrating and Customizing","href":"./filesInstallLT/WS1a9193826455f5ff-e569a012180ce58914566.htm"},{"title": "Migrate Custom Settings and Files from Previous Releases","href":"./filesInstallLT/WS1a9193826455f5ff3d6161141208a8044f3-7999.htm"},{"title": "Migrate Custom Settings","href":"./filesInstallLT/WS1a9193826455f5ff3d6161141208a8044f3-7983.htm"}]},
{"title":"Restore Profiles After Migrating Files from an Earlier Release",
"href":"./filesInstallLT/WS1a9193826455f5ff3d6161141208a8044f3-78fd.htm",
"description":"After you migrate your profiles from an earlier AutoCAD LT release, you may want to restore the newer AutoCAD LT default profile settings.",
"ancestors":[{"title": "Migrating and Customizing","href":"./filesInstallLT/WS1a9193826455f5ff-e569a012180ce58914566.htm"},{"title": "Migrate Custom Settings and Files from Previous Releases","href":"./filesInstallLT/WS1a9193826455f5ff3d6161141208a8044f3-7999.htm"},{"title": "Migrate Custom Settings","href":"./filesInstallLT/WS1a9193826455f5ff3d6161141208a8044f3-7983.htm"}]},
{"title":"Use Migration Tools",
"href":"./filesInstallLT/WS1a9193826455f5ff3d6161141208a8044f3-78ef.htm",
"description":"Migration tools take the guesswork out of updating your custom files from previous releases. The tools help you to share drawings when you upgrade to a new release of an AutoCAD LT product. You can download the migration tools in several languages from the Autodesk website.",
"ancestors":[{"title": "Migrating and Customizing","href":"./filesInstallLT/WS1a9193826455f5ff-e569a012180ce58914566.htm"},{"title": "Migrate Custom Settings and Files from Previous Releases","href":"./filesInstallLT/WS1a9193826455f5ff3d6161141208a8044f3-7999.htm"}]},
{"title":"Customize AutoCAD LT with Initial Setup",
"href":"./filesInstallLT/WS1a9193826455f5ff3d6161141208a8044f3-78e0.htm",
"description":"With Initial Setup you can perform some basic customization of AutoCAD LT.",
"ancestors":[{"title": "Migrating and Customizing","href":"./filesInstallLT/WS1a9193826455f5ff-e569a012180ce58914566.htm"}]},
{"title":"Export and Import Custom Settings from the Same Release",
"href":"./filesInstallLT/WS1a9193826455f5ff3d6161141208a8044f3-789a.htm",
"description":"You can export your custom settings between systems running the same release of an AutoCAD LT product, or export the custom settings and later re-import them on the same computer if you need to reinstall AutoCAD LT. When exporting custom settings, a migration package is created that contains an XML file. This file contains custom settings, a listing of the custom files from local locations used with AutoCAD LT, and optionally, custom files in network locations.",
"ancestors":[{"title": "Migrating and Customizing","href":"./filesInstallLT/WS1a9193826455f5ff-e569a012180ce58914566.htm"}]},
{"title":"Export Custom Settings",
"href":"./filesInstallLT/WS1a9193826455f5ff3d6161141208a8044f3-7842.htm",
"description":"When exporting custom settings, the custom files stored locally and all user profiles are exported to a migration package. You have the option to include custom files that are stored in network locations. During the creation of the migration package, you do not have any control over which types of files are included in the migration package.",
"ancestors":[{"title": "Migrating and Customizing","href":"./filesInstallLT/WS1a9193826455f5ff-e569a012180ce58914566.htm"},{"title": "Export and Import Custom Settings from the Same Release","href":"./filesInstallLT/WS1a9193826455f5ff3d6161141208a8044f3-789a.htm"}]},
{"title":"Import Custom Settings",
"href":"./filesInstallLT/WS1a9193826455f5ff3d6161141208a8044f3-782c.htm",
"description":"By importing a migration package, you can configure AutoCAD LT in the same way as other computers that are running the same release of the product. Upon the successful import of the migration package, a message box is displayed giving you the option of viewing the migration log that is created. If any errors are encountered during the import process, they are logged in the migration log.",
"ancestors":[{"title": "Migrating and Customizing","href":"./filesInstallLT/WS1a9193826455f5ff-e569a012180ce58914566.htm"},{"title": "Export and Import Custom Settings from the Same Release","href":"./filesInstallLT/WS1a9193826455f5ff3d6161141208a8044f3-789a.htm"}]},
{"title":"Migrating and Customizing Issues",
"href":"./filesInstallLT/WS1a9193826455f5ff3d6161141208a8044f3-7811.htm",
"description":"This section outlines common issues and their solutions with regards to migrating and customizing AutoCAD LT.",
"ancestors":[{"title": "Migrating and Customizing","href":"./filesInstallLT/WS1a9193826455f5ff-e569a012180ce58914566.htm"}]},
{"title":"What are the benefits of identifying my industry?",
"href":"./filesInstallLT/WS1a9193826455f5ff3d6161141208a8044f3-7809.htm",
"description":"By identifying your industry, Initial Setup can determine which default drawing template might be the one that best fits your needs. Along with defining the default drawing template, the industry you choose is also used to:",
"ancestors":[{"title": "Migrating and Customizing","href":"./filesInstallLT/WS1a9193826455f5ff-e569a012180ce58914566.htm"},{"title": "Migrating and Customizing Issues","href":"./filesInstallLT/WS1a9193826455f5ff3d6161141208a8044f3-7811.htm"}]},
{"title":"How is this information being used?",
"href":"./filesInstallLT/WS1a9193826455f5ff3d6161141208a8044f3-7802.htm",
"description":"The information gathered from Initial Setup is used to configure several different features and to help guide the future direction of the program. The following features are customized with Initial Setup:",
"ancestors":[{"title": "Migrating and Customizing","href":"./filesInstallLT/WS1a9193826455f5ff-e569a012180ce58914566.htm"},{"title": "Migrating and Customizing Issues","href":"./filesInstallLT/WS1a9193826455f5ff3d6161141208a8044f3-7811.htm"}]},
{"title":"What happens if I skip or cancel Initial Setup?",
"href":"./filesInstallLT/WS1a9193826455f5ff3d6161141208a8044f3-77f9.htm",
"description":"If you skip or cancel Initial Setup, AutoCAD LT is not changed from its current state. You can return to Initial Setup at any time by going to the User Preferences tab in the Options dialog box.",
"ancestors":[{"title": "Migrating and Customizing","href":"./filesInstallLT/WS1a9193826455f5ff-e569a012180ce58914566.htm"},{"title": "Migrating and Customizing Issues","href":"./filesInstallLT/WS1a9193826455f5ff3d6161141208a8044f3-7811.htm"}]},
{"title":"What are the benefits of selecting task-based tools?",
"href":"./filesInstallLT/WS1a9193826455f5ff3d6161141208a8044f3-77ee.htm",
"description":"Workspaces control which task-based tools are displayed in the Application window and when they are displayed. You can create different workspaces based on the types of drawings you work on. For more information about customizing the user interface and workspaces, see and in the Customization Guide.",
"ancestors":[{"title": "Migrating and Customizing","href":"./filesInstallLT/WS1a9193826455f5ff-e569a012180ce58914566.htm"},{"title": "Migrating and Customizing Issues","href":"./filesInstallLT/WS1a9193826455f5ff3d6161141208a8044f3-7811.htm"}]},
{"title":"What is a workspace?",
"href":"./filesInstallLT/WS1a9193826455f5ff3d6161141208a8044f3-77ea.htm",
"description":"Workspaces are sets of menus, toolbars, palettes, ribbon panels, and ribbon tabs that are organized so you can work in a custom, task-oriented drawing environment. When you use a workspace, only the user interface elements that are relevant to a task are displayed. For more information about customizing workspaces, see in the Customization Guide.",
"ancestors":[{"title": "Migrating and Customizing","href":"./filesInstallLT/WS1a9193826455f5ff-e569a012180ce58914566.htm"},{"title": "Migrating and Customizing Issues","href":"./filesInstallLT/WS1a9193826455f5ff3d6161141208a8044f3-7811.htm"}]},
{"title":"How do I make changes to a workspace at a later time?",
"href":"./filesInstallLT/WS1a9193826455f5ff3d6161141208a8044f3-77e6.htm",
"description":"Workspaces are used to control many of the tools displayed in the Application window of AutoCAD LT. You can modify the current workspace in a limited way from the Application window or you have full control over all aspects of a workspace with the Customize User Interface (CUI) Editor. For more information about customizing workspaces, see in the Customization Guide.",
"ancestors":[{"title": "Migrating and Customizing","href":"./filesInstallLT/WS1a9193826455f5ff-e569a012180ce58914566.htm"},{"title": "Migrating and Customizing Issues","href":"./filesInstallLT/WS1a9193826455f5ff3d6161141208a8044f3-7811.htm"}]},
{"title":"What is a drawing template file?",
"href":"./filesInstallLT/WS1a9193826455f5ff3d6161141208a8044f3-77e2.htm",
"description":"A drawing template (DWT) file is used to provide consistency for each new drawing (DWG) file that is created. DWT files can contain named objects, drawing based settings, and geometric objects. Stored named objects include layers, and text and dimension styles among others. Along with named objects, a DWT file can hold values for drawing based system variables, and any geometric object that might be common across multiple drawings such as a title block. For information about using a DWT file, see in the User’s Guide.",
"ancestors":[{"title": "Migrating and Customizing","href":"./filesInstallLT/WS1a9193826455f5ff-e569a012180ce58914566.htm"},{"title": "Migrating and Customizing Issues","href":"./filesInstallLT/WS1a9193826455f5ff3d6161141208a8044f3-7811.htm"}]},
{"title":"How do I modify drawing templates at a later time?",
"href":"./filesInstallLT/WS1a9193826455f5ff3d6161141208a8044f3-77de.htm",
"description":"Drawing template (DWT) files are no different than a drawing (DWG) file, with the exception of its file extension. Once a DWT file is opened, you can modify named objects such as layers, and text and dimension styles just as you would in a drawing. You open a DWT file with the OPEN command.",
"ancestors":[{"title": "Migrating and Customizing","href":"./filesInstallLT/WS1a9193826455f5ff-e569a012180ce58914566.htm"},{"title": "Migrating and Customizing Issues","href":"./filesInstallLT/WS1a9193826455f5ff3d6161141208a8044f3-7811.htm"}]},
{"title":"What are the benefits of customizing AutoCAD LT?",
"href":"./filesInstallLT/WS1a9193826455f5ff3d6161141208a8044f3-77d1.htm",
"description":"Customizing AutoCAD LT provides many benefits that can increase your productivity and make your drawings have a consistent appearance. Customization can be as simple as creating a block that can be used in many drawings over and over again, such as a title block, or customizing the user interface with the Customize User Interface (CUI) Editor. For information about customizing the user interface, see in the Customization Guide.",
"ancestors":[{"title": "Migrating and Customizing","href":"./filesInstallLT/WS1a9193826455f5ff-e569a012180ce58914566.htm"},{"title": "Migrating and Customizing Issues","href":"./filesInstallLT/WS1a9193826455f5ff3d6161141208a8044f3-7811.htm"}]},
{"title":"Network Administration and Deployment",
"href":"./filesInstallLT/WS1a9193826455f5ff-e569a012180ce589145cc.htm",
"description":"Network administration and deployment requires careful planning and execution. This section gives you information about how to prepare for deployment, set up and customize a deployment, and distribute the program.",
"ancestors":[]},
{"title":"Preparing a Deployment",
"href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-52c3.htm",
"description":"To prepare for a deployment, you should take the time to review the following requirements and options.",
"ancestors":[{"title": "Network Administration and Deployment","href":"./filesInstallLT/WS1a9193826455f5ff-e569a012180ce589145cc.htm"}]},
{"title":"System Requirements for Administrative Image",
"href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-52c0.htm",
"description":"This section contains the system requirements for the location of the administrative image.",
"ancestors":[{"title": "Network Administration and Deployment","href":"./filesInstallLT/WS1a9193826455f5ff-e569a012180ce589145cc.htm"},{"title": "Preparing a Deployment","href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-52c3.htm"}]},
{"title":"Choose an Installation Type",
"href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-5235.htm",
"description":"When you set up your deployment, you need to choose the type of installation to deploy. In the AutoCAD LT Deployment wizard, you specify one of the following installation types:",
"ancestors":[{"title": "Network Administration and Deployment","href":"./filesInstallLT/WS1a9193826455f5ff-e569a012180ce589145cc.htm"},{"title": "Preparing a Deployment","href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-52c3.htm"}]},
{"title":"Choose a License Server Model",
"href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-5221.htm",
"description":"If you chose the Network License option, you need to decide which license server model to use to distribute the product licenses.",
"ancestors":[{"title": "Network Administration and Deployment","href":"./filesInstallLT/WS1a9193826455f5ff-e569a012180ce589145cc.htm"},{"title": "Preparing a Deployment","href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-52c3.htm"}]},
{"title":"Create a Network Share",
"href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-51a5.htm",
"description":"Once you have fully prepared for creating a deployment, you are ready to set up and distribute AutoCAD LT by creating a network share location (folder). A network share is an installation folder that you make available to users\' computers on a network. You point users to this location to install the program.",
"ancestors":[{"title": "Network Administration and Deployment","href":"./filesInstallLT/WS1a9193826455f5ff-e569a012180ce589145cc.htm"},{"title": "Preparing a Deployment","href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-52c3.htm"}]},
{"title":"Network Tools and Your License Server",
"href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-5212.htm",
"description":"If users are running the program using network licenses, you need to use the Network License Manager. The Network License Manager helps you configure and manage license servers. For information about installing and setting up the Network License Manager and licensing tools, see the Autodesk Licensing guide.",
"ancestors":[{"title": "Network Administration and Deployment","href":"./filesInstallLT/WS1a9193826455f5ff-e569a012180ce589145cc.htm"},{"title": "Preparing a Deployment","href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-52c3.htm"}]},
{"title":"Setting Up and Creating a Deployment",
"href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-5174.htm",
"description":"The deployment process provides you with numerous options for creating, and customizing your deployments, so you should set aside ample time to complete the process in one sitting. To be successful, it is recommended that you review the following checklist and information before you begin. The deployment process is initiated from the installation wizard’s Create Deployments selection. Once a deployment is created, users then access the deployment to install products to their computers.",
"ancestors":[{"title": "Network Administration and Deployment","href":"./filesInstallLT/WS1a9193826455f5ff-e569a012180ce589145cc.htm"}]},
{"title":"Prepare for a Network Deployment",
"href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-516c.htm",
"description":"Complete the following preliminary tasks before creating a network deployment.",
"ancestors":[{"title": "Network Administration and Deployment","href":"./filesInstallLT/WS1a9193826455f5ff-e569a012180ce589145cc.htm"},{"title": "Setting Up and Creating a Deployment","href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-5174.htm"}]},
{"title":"Configure Individual Products",
"href":"./filesInstallLT/WS1a9193826455f5ff-3a17572711da7b6e15f-7d3b.htm",
"description":"You can create a deployment that uses the default product settings, or you can configure each product to be included in the deployment. To configure a product, on the Create Deployment page of the deployment wizard, select the appropriate product from the drop-down list, and click Configure.",
"ancestors":[{"title": "Network Administration and Deployment","href":"./filesInstallLT/WS1a9193826455f5ff-e569a012180ce589145cc.htm"},{"title": "Setting Up and Creating a Deployment","href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-5174.htm"}]},
{"title":"Your Deployment Choices",
"href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-5159.htm",
"description":"When you create a deployment, you will make several choices during the process to create various client deployment images and deployment types. The following sections outline your choices in more detail.",
"ancestors":[{"title": "Network Administration and Deployment","href":"./filesInstallLT/WS1a9193826455f5ff-e569a012180ce589145cc.htm"},{"title": "Setting Up and Creating a Deployment","href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-5174.htm"}]},
{"title":"Enter User and Product Information",
"href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-5155.htm",
"description":"The User and Product Information page is used to personalize the program for your environment. The information you enter is permanently retained with the product and is displayed in the Help menu on all workstations. Because you can\'t change this information later without uninstalling, take care when entering the information.",
"ancestors":[{"title": "Network Administration and Deployment","href":"./filesInstallLT/WS1a9193826455f5ff-e569a012180ce589145cc.htm"},{"title": "Setting Up and Creating a Deployment","href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-5174.htm"},{"title": "Your Deployment Choices","href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-5159.htm"}]},
{"title":"Creating Log Files",
"href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-5151.htm",
"description":"From the General Deployment Settings dialog, you can setup two types of log files with which you can monitor information about deployments and installations.",
"ancestors":[{"title": "Network Administration and Deployment","href":"./filesInstallLT/WS1a9193826455f5ff-e569a012180ce589145cc.htm"},{"title": "Setting Up and Creating a Deployment","href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-5174.htm"},{"title": "Your Deployment Choices","href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-5159.htm"}]},
{"title":"What Is Silent Mode?",
"href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-5143.htm",
"description":"When silent mode is active and a user initiates the deployment, the installation proceeds without any explicit user input. Users cannot change any of your installation settings. No dialog boxes are presented that require interaction from the user.",
"ancestors":[{"title": "Network Administration and Deployment","href":"./filesInstallLT/WS1a9193826455f5ff-e569a012180ce589145cc.htm"},{"title": "Setting Up and Creating a Deployment","href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-5174.htm"},{"title": "Your Deployment Choices","href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-5159.htm"}]},
{"title":"Select a License Type (Optional)",
"href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-513c.htm",
"description":"When you set up your deployment, you choose the type of installation to deploy based on the type of software license you purchased: stand-alone or network. You also select the network license server model you want to use to distribute product licenses.",
"ancestors":[{"title": "Network Administration and Deployment","href":"./filesInstallLT/WS1a9193826455f5ff-e569a012180ce589145cc.htm"},{"title": "Setting Up and Creating a Deployment","href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-5174.htm"},{"title": "Your Deployment Choices","href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-5159.htm"}]},
{"title":"Select the Installation Type (Optional)",
"href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-510f.htm",
"description":"As part of making your deployment choices, you select the type of installation that users receive when they install the program, choose which optional tools or features are included, and specify where the product is installed on each workstation.",
"ancestors":[{"title": "Network Administration and Deployment","href":"./filesInstallLT/WS1a9193826455f5ff-e569a012180ce589145cc.htm"},{"title": "Setting Up and Creating a Deployment","href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-5174.htm"},{"title": "Your Deployment Choices","href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-5159.htm"}]},
{"title":"Select Installation Folders for Support Content",
"href":"./filesInstallLT/WS73099cc142f48755-385a98b0121d1bb015f-2b4c.htm",
"description":"On the Select Installation Folders for Support Content page, you choose where your support content gets installed by specifying a folder other than the default user profile folder used in previous releases. As a network administrator, these options give you greater control over where you place support content during installations or deployments.",
"ancestors":[{"title": "Network Administration and Deployment","href":"./filesInstallLT/WS1a9193826455f5ff-e569a012180ce589145cc.htm"},{"title": "Setting Up and Creating a Deployment","href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-5174.htm"},{"title": "Your Deployment Choices","href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-5159.htm"}]},
{"title":"Specify User Preferences (Optional)",
"href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-50d0.htm",
"description":"On the Specify User Preferences page, you specify:",
"ancestors":[{"title": "Network Administration and Deployment","href":"./filesInstallLT/WS1a9193826455f5ff-e569a012180ce589145cc.htm"},{"title": "Setting Up and Creating a Deployment","href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-5174.htm"},{"title": "Your Deployment Choices","href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-5159.htm"}]},
{"title":"Include Service Packs (Optional)",
"href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-50c5.htm",
"description":"You have the option to include service packs for your product. You can select to download and apply a service pack from autodesk.com, or choose to use a locally stored (local hard drive or local network) service pack. In either case, the service pack will be applied only after the installation of the main product is completed.",
"ancestors":[{"title": "Network Administration and Deployment","href":"./filesInstallLT/WS1a9193826455f5ff-e569a012180ce589145cc.htm"},{"title": "Setting Up and Creating a Deployment","href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-5174.htm"},{"title": "Your Deployment Choices","href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-5159.htm"}]},
{"title":"Configure InfoCenter Communication Center (Optional)",
"href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-50ac.htm",
"description":"The Communications Center is accessed through InfoCenter. Products are updated with Live Update, which downloads patches to your product using Communication Center. Beyond Live Update, other information channels and feeds can be displayed by the Communication Center.",
"ancestors":[{"title": "Network Administration and Deployment","href":"./filesInstallLT/WS1a9193826455f5ff-e569a012180ce589145cc.htm"},{"title": "Setting Up and Creating a Deployment","href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-5174.htm"},{"title": "Your Deployment Choices","href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-5159.htm"}]},
{"title":"Allow Users to Access Online Resources (Optional)",
"href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-508e.htm",
"description":"On the Configure Access to Online Resources pages, you can specify whether users can access online resources such as receiving live updates from Autodesk, enabling information or CAD Manager channels, or subscribing to RSS feeds. You can also allow access to the DesignCenter as well as specifying Customer Error Reporting and InfoCenter settings.",
"ancestors":[{"title": "Network Administration and Deployment","href":"./filesInstallLT/WS1a9193826455f5ff-e569a012180ce589145cc.htm"},{"title": "Setting Up and Creating a Deployment","href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-5174.htm"},{"title": "Your Deployment Choices","href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-5159.htm"}]},
{"title":"Create a Default Deployment",
"href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-5071.htm",
"description":"If you do not plan to customize your deployment, you can create a default deployment.",
"ancestors":[{"title": "Network Administration and Deployment","href":"./filesInstallLT/WS1a9193826455f5ff-e569a012180ce589145cc.htm"},{"title": "Setting Up and Creating a Deployment","href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-5174.htm"}]},
{"title":"Create a Custom Deployment",
"href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-504e.htm",
"description":"To alter your deployment by removing features or restricting access to online resources, customize the configuration of each product included in the deployment.",
"ancestors":[{"title": "Network Administration and Deployment","href":"./filesInstallLT/WS1a9193826455f5ff-e569a012180ce589145cc.htm"},{"title": "Setting Up and Creating a Deployment","href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-5174.htm"}]},
{"title":"Modify a Deployment (Optional)",
"href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-4fed.htm",
"description":"After a deployment is created, it may be necessary to modify the deployment for some client workstations. You can apply a patch or include various custom files that are not part of the base administrative image. You can also perform modifications such as changing the installation directory from drive C to drive D.",
"ancestors":[{"title": "Network Administration and Deployment","href":"./filesInstallLT/WS1a9193826455f5ff-e569a012180ce589145cc.htm"},{"title": "Setting Up and Creating a Deployment","href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-5174.htm"}]},
{"title":"Point Users to the Administrative Image",
"href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-4fe2.htm",
"description":"When you are done creating the deployment, users can install the program using the shortcut located with the administrative image. The shortcut name matches the deployment name that you specified in the deployment wizard. Notify users of the location of the administrative image, instruct them to double-click the shortcut, and provide any other necessary instructions.",
"ancestors":[{"title": "Network Administration and Deployment","href":"./filesInstallLT/WS1a9193826455f5ff-e569a012180ce589145cc.htm"},{"title": "Setting Up and Creating a Deployment","href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-5174.htm"}]},
{"title":"Distributing an Autodesk Program",
"href":"./filesInstallLT/WS1a9193826455f5ff-e569a012180ce589145ce.htm",
"description":"You can choose from several methods of distributing an Autodesk program. Network sharing is the default method.",
"ancestors":[]},
{"title":"Use Scripts to Deploy the Program",
"href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-4fac.htm",
"description":"A script executes a command or a set of commands. Scripts are similar to batch files but are more flexible. Installation scripts are most useful for stand-alone installation of programs on computers that are connected to a network. Scripts are also useful for installing service packs, extensions, and object enablers on a network.",
"ancestors":[{"title": "Distributing an Autodesk Program","href":"./filesInstallLT/WS1a9193826455f5ff-e569a012180ce589145ce.htm"}]},
{"title":"A Sample Installation Script",
"href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-4f8f.htm",
"description":"The sample script in this section installs the program in a typical configuration. To make it easy to copy this sample script and substitute your own information, the same names are used throughout for variable items. The log file name is based on the product being installed. You can either use the log file name in the script or change it to something else.",
"ancestors":[{"title": "Distributing an Autodesk Program","href":"./filesInstallLT/WS1a9193826455f5ff-e569a012180ce589145ce.htm"},{"title": "Use Scripts to Deploy the Program","href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-4fac.htm"}]},
{"title":"Use Switches and Flags in Scripts",
"href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-4f80.htm",
"description":"The following table lists all of the switches and flags that are relevant to installation.",
"ancestors":[{"title": "Distributing an Autodesk Program","href":"./filesInstallLT/WS1a9193826455f5ff-e569a012180ce589145ce.htm"},{"title": "Use Scripts to Deploy the Program","href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-4fac.htm"}]},
{"title":"Run Scripts",
"href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-4f5d.htm",
"description":"After creating a script, you move it to a server or use a mapped drive letter or a UNC (universal naming convention) path. If you place it on a server for users to run, create a share on the server, and then add users to the share with the rights they need. Because all that users need to do is run the script, provide read-only access to the share directory.",
"ancestors":[{"title": "Distributing an Autodesk Program","href":"./filesInstallLT/WS1a9193826455f5ff-e569a012180ce589145ce.htm"},{"title": "Use Scripts to Deploy the Program","href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-4fac.htm"}]},
{"title":"Use Group Policies to Run a Deployment",
"href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-4f52.htm",
"description":"With group policies, you can advertise and install a program by assigning a deployment to computers. A deployment that is assigned to a computer can be used by any user of that computer. Generally, you would assign the deployment to a computer that is used by a large number of users.",
"ancestors":[{"title": "Distributing an Autodesk Program","href":"./filesInstallLT/WS1a9193826455f5ff-e569a012180ce589145ce.htm"}]},
{"title":"Use Group Policies to Assign a Deployment to Computers",
"href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-4f14.htm",
"description":"Perform the following procedures from a Windows XP workstation or a Windows 2000 or 2003 server that has Group Policy Management Console installed, and has access to the Active Directory server.",
"ancestors":[{"title": "Distributing an Autodesk Program","href":"./filesInstallLT/WS1a9193826455f5ff-e569a012180ce589145ce.htm"},{"title": "Use Group Policies to Run a Deployment","href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-4f52.htm"}]},
{"title":"Verify a Group Policy Deployment",
"href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-4edd.htm",
"description":"To verify that this deployment has been correctly assigned to a computer, restart a computer that is in the organizational unit for which the group policy was created. The program installation begins before the login prompt is displayed. The operating system displays group policy messages, including a message indicating the installation of any managed software.",
"ancestors":[{"title": "Distributing an Autodesk Program","href":"./filesInstallLT/WS1a9193826455f5ff-e569a012180ce589145ce.htm"},{"title": "Use Group Policies to Run a Deployment","href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-4f52.htm"}]},
{"title":"Distribute the Product Using Imaging Software",
"href":"./filesInstallLT/WS73099cc142f48755-1257e12111bf108800e-142c.htm",
"description":"The following information is provided for those who use imaging software, such as Norton Ghost, to create a master image to distribute Autodesk products. Once created, the master image is then replicated to other computers throughout your facility.",
"ancestors":[{"title": "Distributing an Autodesk Program","href":"./filesInstallLT/WS1a9193826455f5ff-e569a012180ce589145ce.htm"}]},
{"title":"Use a Master Image to Distribute Multi-Seat Stand-Alone Products to Multiple Systems",
"href":"./filesInstallLT/WS73099cc142f48755-1257e12111bf108800e-1419.htm",
"description":"You can distribute the product using a master image for a multi-seat stand-alone product.",
"ancestors":[{"title": "Distributing an Autodesk Program","href":"./filesInstallLT/WS1a9193826455f5ff-e569a012180ce589145ce.htm"},{"title": "Distribute the Product Using Imaging Software","href":"./filesInstallLT/WS73099cc142f48755-1257e12111bf108800e-142c.htm"}]},
{"title":"Use a Master Image to Distribute Network Licensed Products to Multiple Systems",
"href":"./filesInstallLT/WS73099cc142f48755-1257e12111bf108800e-1408.htm",
"description":"You can distribute the product using a master image for a network licensed product.",
"ancestors":[{"title": "Distributing an Autodesk Program","href":"./filesInstallLT/WS1a9193826455f5ff-e569a012180ce589145ce.htm"},{"title": "Distribute the Product Using Imaging Software","href":"./filesInstallLT/WS73099cc142f48755-1257e12111bf108800e-142c.htm"}]},
{"title":"Restore the Master Image",
"href":"./filesInstallLT/WS73099cc142f48755-1257e12111bf108800e-13fb.htm",
"description":"The following procedure assumes that you have saved a copy of each workstation’s AdLM folder (and Product Licenses folder, if present) to either another workstation or a disc before you reformat the workstation.",
"ancestors":[{"title": "Distributing an Autodesk Program","href":"./filesInstallLT/WS1a9193826455f5ff-e569a012180ce589145ce.htm"},{"title": "Distribute the Product Using Imaging Software","href":"./filesInstallLT/WS73099cc142f48755-1257e12111bf108800e-142c.htm"}]},
{"title":"Clean a Master System and Restore the Operating System",
"href":"./filesInstallLT/WS73099cc142f48755-1257e12111bf108800e-13e8.htm",
"description":"If you have already run AutoCAD LT on the master computer, the master computer should be properly cleaned first.",
"ancestors":[{"title": "Distributing an Autodesk Program","href":"./filesInstallLT/WS1a9193826455f5ff-e569a012180ce589145ce.htm"},{"title": "Distribute the Product Using Imaging Software","href":"./filesInstallLT/WS73099cc142f48755-1257e12111bf108800e-142c.htm"}]},
{"title":"Troubleshooting",
"href":"./filesInstallLT/WS1a9193826455f5ff-e569a012180ce589145d0.htm",
"description":"This section provides solutions to installation issues and answers to commonly asked questions that may arise while installing your product(s). Additional troubleshooting information and support is also available at http://usa.autodesk.com/adsk/servlet/index?siteID=123112&id=1068444http://autodesk.com/servicesandsupport",
"ancestors":[]},
{"title":"General Installation Issues",
"href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-4e71.htm",
"description":"This section outlines common issues and their solutions that may arise while performing a general install of your product(s).",
"ancestors":[{"title": "Troubleshooting","href":"./filesInstallLT/WS1a9193826455f5ff-e569a012180ce589145d0.htm"}]},
{"title":"How can I check my graphics card driver to see if it needs to be updated?",
"href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-4e6c.htm",
"description":"It is recommended that you verify and update your graphics card driver to optimize your program. Use the following procedure to identify your current graphics card driver.",
"ancestors":[{"title": "Troubleshooting","href":"./filesInstallLT/WS1a9193826455f5ff-e569a012180ce589145d0.htm"},{"title": "General Installation Issues","href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-4e71.htm"}]},
{"title":"What is the text editor used for?",
"href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-4e59.htm",
"description":"The text editor you designate during installation is used for editing text files such as PGP and CUS dictionary files while you are running your product.",
"ancestors":[{"title": "Troubleshooting","href":"./filesInstallLT/WS1a9193826455f5ff-e569a012180ce589145d0.htm"},{"title": "General Installation Issues","href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-4e71.htm"}]},
{"title":"What is the difference between a stand-alone license and a network license?",
"href":"./filesInstallLT/WS73099cc142f48755-575eab4c124f5234aa8-52a0.htm",
"description":"Stand-alone licensed products are registered and activated to an individual workstation. While the software can be installed on multiple systems in your facility, the license only allows one system to be operational. If you need to run more systems, you need to purchase more stand-alone licensed products, or consider converting to network licenses.",
"ancestors":[{"title": "Troubleshooting","href":"./filesInstallLT/WS1a9193826455f5ff-e569a012180ce589145d0.htm"},{"title": "General Installation Issues","href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-4e71.htm"}]},
{"title":"What is the benefit of using a network licensed version of the software?",
"href":"./filesInstallLT/WS73099cc142f48755-575eab4c124f5234aa8-529b.htm",
"description":"Network licensed products are recommended for large drafting/design facilities, classrooms, and lab environments. The main advantage is that you can install products on more systems than the number of licenses you have purchased (for example, purchasing 25 licenses but installing on 40 workstations). At any one time, products will run on the maximum number of systems for which you have licenses. This means you get a true floating license. If software needs to be run on more systems, additional licenses can be purchased.",
"ancestors":[{"title": "Troubleshooting","href":"./filesInstallLT/WS1a9193826455f5ff-e569a012180ce589145d0.htm"},{"title": "General Installation Issues","href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-4e71.htm"}]},
{"title":"What features get installed during a Typical or Custom installation?",
"href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-4e55.htm",
"description":"A Typical installation includes all of the following features. If you choose to do a Custom installation, you can pick and choose from the feature list below.",
"ancestors":[{"title": "Troubleshooting","href":"./filesInstallLT/WS1a9193826455f5ff-e569a012180ce589145d0.htm"},{"title": "General Installation Issues","href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-4e71.htm"}]},
{"title":"How do I access my product documentation?",
"href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-4e48.htm",
"description":"Documentation in the form of a Help file is available on the product media or as a web-based (online) Help file. The complete Help system is installed during the product installation process. During the installation process, you can access specific installation and licensing topics by clicking on the links in the left-panel of the installation wizards, or by selecting the Read the Documentation or Documentation links in the installation wizards.",
"ancestors":[{"title": "Troubleshooting","href":"./filesInstallLT/WS1a9193826455f5ff-e569a012180ce589145d0.htm"},{"title": "General Installation Issues","href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-4e71.htm"}]},
{"title":"What is SAMreport-Lite?",
"href":"./filesInstallLT/WS1a9193826455f5ff-75c1f7c3124f51ccbd1-44e.htm",
"description":"SAMreport-Lite is a report generator that helps you monitor the usage of applications that use FLEXnet. SAMreport-Lite complements FLEXnet by providing a graphical user interface (GUI) from which to run usage reports. SAMreport-Lite can help you make better decisions about your software assets. For more information, see the SAMreport-Lite User’s Guide in Help.",
"ancestors":[{"title": "Troubleshooting","href":"./filesInstallLT/WS1a9193826455f5ff-e569a012180ce589145d0.htm"},{"title": "General Installation Issues","href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-4e71.htm"}]},
{"title":"Deployment Issues",
"href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-4e3f.htm",
"description":"This section outlines common issues and their solutions with regards to software deployments.",
"ancestors":[{"title": "Troubleshooting","href":"./filesInstallLT/WS1a9193826455f5ff-e569a012180ce589145d0.htm"}]},
{"title":"Is there a checklist I can refer to when performing a deployment?",
"href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-4e38.htm",
"description":"AutoCAD LT Installation contains a checklist that describes preliminary actions of the deployment process. See .",
"ancestors":[{"title": "Troubleshooting","href":"./filesInstallLT/WS1a9193826455f5ff-e569a012180ce589145d0.htm"},{"title": "Deployment Issues","href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-4e3f.htm"}]},
{"title":"Where should deployments be located?",
"href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-4e34.htm",
"description":"Shared folders are required for both network license and multi-seat stand-alone methods of installation. The shared folder (network share) is created before you run the installation wizard and is where product deployments are stored.",
"ancestors":[{"title": "Troubleshooting","href":"./filesInstallLT/WS1a9193826455f5ff-e569a012180ce589145d0.htm"},{"title": "Deployment Issues","href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-4e3f.htm"}]},
{"title":"What are the default search paths and file location settings?",
"href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-4e2d.htm",
"description":"On the Select Installation Folders for Support Content page of the deployment wizard, you can choose where your support content gets installed by specifying a folder other than the user profile folder. Support files include drivers, menus, and optional, user-defined settings such as dictionary and customization files.",
"ancestors":[{"title": "Troubleshooting","href":"./filesInstallLT/WS1a9193826455f5ff-e569a012180ce589145d0.htm"},{"title": "Deployment Issues","href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-4e3f.htm"}]},
{"title":"How will changing the support file locations affect my search paths?",
"href":"./filesInstallLT/WS1a9193826455f5ff-4f6d1f1d11d24be3e031b56.htm",
"description":"When a different install path for support content is specified, it will be populated into the correspondent search paths on the Define Search Paths and File Locations page. If one is not specified, the first search path will replace the install path. The table below outlines the specific search paths that can be affected by resetting your support file install paths.",
"ancestors":[{"title": "Troubleshooting","href":"./filesInstallLT/WS1a9193826455f5ff-e569a012180ce589145d0.htm"},{"title": "Deployment Issues","href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-4e3f.htm"}]},
{"title":"Along with defining search paths and file location, can files be added?",
"href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-4df0.htm",
"description":"Using the Add button, you can set paths to folders where files are stored. You cannot add specific files.",
"ancestors":[{"title": "Troubleshooting","href":"./filesInstallLT/WS1a9193826455f5ff-e569a012180ce589145d0.htm"},{"title": "Deployment Issues","href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-4e3f.htm"}]},
{"title":"Where can I check if service packs are available for my software?",
"href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-4dec.htm",
"description":"To find out if a patch or Service Pack is available for your product, visit AutoCAD LT Support page at http://usa.autodesk.com/adsk/servlet/index?siteID=123112&id=1068444http://autodesk.com/servicesandsupport.",
"ancestors":[{"title": "Troubleshooting","href":"./filesInstallLT/WS1a9193826455f5ff-e569a012180ce589145d0.htm"},{"title": "Deployment Issues","href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-4e3f.htm"}]},
{"title":"How do I extract an MSP file?",
"href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-4de8.htm",
"description":"A Microsoft Patch (MSP) file is usually contained in a Service Pack executable that you download from AutoCAD LT Support website. To extract the MSP file from the executable, run the patch program from the Windows command prompt using the /e switch.",
"ancestors":[{"title": "Troubleshooting","href":"./filesInstallLT/WS1a9193826455f5ff-e569a012180ce589145d0.htm"},{"title": "Deployment Issues","href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-4e3f.htm"}]},
{"title":"Can Online Resource settings be modified later?",
"href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-4de3.htm",
"description":"Yes. If you want to change the state of online resources after a product is installed, you can do that from the CAD Manager Control utility. The CAD Manager Control utility is installed separately from AutoCAD LT.",
"ancestors":[{"title": "Troubleshooting","href":"./filesInstallLT/WS1a9193826455f5ff-e569a012180ce589145d0.htm"},{"title": "Deployment Issues","href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-4e3f.htm"}]},
{"title":"Where can I learn about InfoCenter?",
"href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-4ddb.htm",
"description":"You can use InfoCenter to enter a question for help, display the Communication Center panel for product updates and announcements, or display the Favorites panel to access saved topics. For more information, refer to .",
"ancestors":[{"title": "Troubleshooting","href":"./filesInstallLT/WS1a9193826455f5ff-e569a012180ce589145d0.htm"},{"title": "Deployment Issues","href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-4e3f.htm"}]},
{"title":"What are information channels?",
"href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-4dd7.htm",
"description":"The Communication Center component of InfoCenter allows you to receive announcements from various information channels. Through information channels, you can receive the following:",
"ancestors":[{"title": "Troubleshooting","href":"./filesInstallLT/WS1a9193826455f5ff-e569a012180ce589145d0.htm"},{"title": "Deployment Issues","href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-4e3f.htm"}]},
{"title":"What are the benefits to enabling CAD Manager Channels?",
"href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-4dcf.htm",
"description":"CAD Manager Channels allow access to Internet-based content and information feeds from a specified feed location.",
"ancestors":[{"title": "Troubleshooting","href":"./filesInstallLT/WS1a9193826455f5ff-e569a012180ce589145d0.htm"},{"title": "Deployment Issues","href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-4e3f.htm"}]},
{"title":"What are RSS feeds and how do they benefit my installation?",
"href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-4dcb.htm",
"description":"An RSS feed is a live link you initiate by subscribing to someone’s website. Once subscribed, the primary benefit is a constantly updating stream of content that is delivered to your system in the form of summarized articles, forum threads, blog posts, and so on. RSS stands for Rich Site Summary (or Really Simple Syndication).",
"ancestors":[{"title": "Troubleshooting","href":"./filesInstallLT/WS1a9193826455f5ff-e569a012180ce589145d0.htm"},{"title": "Deployment Issues","href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-4e3f.htm"}]},
{"title":"Where can I learn about InfoCenter search locations?",
"href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-4dc7.htm",
"description":"You can use InfoCenter to search multiple sources (for example, Help and specified files) at one time, or choose to search a single file or location.",
"ancestors":[{"title": "Troubleshooting","href":"./filesInstallLT/WS1a9193826455f5ff-e569a012180ce589145d0.htm"},{"title": "Deployment Issues","href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-4e3f.htm"}]},
{"title":"How do I set or customize search locations?",
"href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-4dc2.htm",
"description":"InfoCenter Search and Communication Center settings can be set in the InfoCenter Settings dialog box or in the CAD Manager Control utility. You must use the CAD Manager Control utility to specify CAD Manager Channel settings.",
"ancestors":[{"title": "Troubleshooting","href":"./filesInstallLT/WS1a9193826455f5ff-e569a012180ce589145d0.htm"},{"title": "Deployment Issues","href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-4e3f.htm"}]},
{"title":"Networking Issues",
"href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-4da4.htm",
"description":"This section outlines common issues and their solutions with regards to performing a network installation or configuring your network license server(s).",
"ancestors":[{"title": "Troubleshooting","href":"./filesInstallLT/WS1a9193826455f5ff-e569a012180ce589145d0.htm"}]},
{"title":"When installing tools and utilities, which selections are applicable for a multi-seat stand-alone installation?",
"href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-4d9d.htm",
"description":"Since a multi-seat stand-alone licensed product does not rely upon a license server to manage or activate the license, the only tool that is beneficial is the Autodesk CAD Manager tool.",
"ancestors":[{"title": "Troubleshooting","href":"./filesInstallLT/WS1a9193826455f5ff-e569a012180ce589145d0.htm"},{"title": "Networking Issues","href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-4da4.htm"}]},
{"title":"When installing tools and utilities, which selections are applicable for a stand-alone installation?",
"href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-4d98.htm",
"description":"The Autodesk CAD Manager tool is the only tool that is beneficial to a stand-alone licensed product. With the CAD Manager tool, you can modify CAD Manager Channels.",
"ancestors":[{"title": "Troubleshooting","href":"./filesInstallLT/WS1a9193826455f5ff-e569a012180ce589145d0.htm"},{"title": "Networking Issues","href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-4da4.htm"}]},
{"title":"Where do I find my server name?",
"href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-4d94.htm",
"description":"When installing a network licensed product, you must specify the name of the server that will run the Network License Manager. If you don’t know the server name, you can quickly find it by opening a Windows command prompt on the system that will be the Network License Manager. At the prompt, enter ipconfig /all and note the Host Name entry.",
"ancestors":[{"title": "Troubleshooting","href":"./filesInstallLT/WS1a9193826455f5ff-e569a012180ce589145d0.htm"},{"title": "Networking Issues","href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-4da4.htm"}]},
{"title":"When specifying user workstation settings, I am given the option to specify a profile. What are profiles?",
"href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-4d8a.htm",
"description":"Profiles are created on the Profiles tab of the Options dialog box. Profiles can contain configuration settings for just about anything that is not a drawing based system variable. For example, a profile can contain things like support paths, grip settings, and plot settings.",
"ancestors":[{"title": "Troubleshooting","href":"./filesInstallLT/WS1a9193826455f5ff-e569a012180ce589145d0.htm"},{"title": "Networking Issues","href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-4da4.htm"}]},
{"title":"Can I create custom desktop shortcuts?",
"href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-4d85.htm",
"description":"You can choose to create custom desktop shortcuts that use command line switches to specify several options when you start the program. For example, command line switches can be set to run a script during program launch, create a drawing based on a template or prototype drawing, or designate a workspace that should be restored on startup.",
"ancestors":[{"title": "Troubleshooting","href":"./filesInstallLT/WS1a9193826455f5ff-e569a012180ce589145d0.htm"},{"title": "Networking Issues","href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-4da4.htm"}]},
{"title":"What happens when you choose to append or merge service packs?",
"href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-4d80.htm",
"description":"When you append a service pack, the service pack is applied to the current deployment only. Multiple service packs may be appended to a deployment. The service pack file is included in the deployment and the service pack is applied after the product is deployed.",
"ancestors":[{"title": "Troubleshooting","href":"./filesInstallLT/WS1a9193826455f5ff-e569a012180ce589145d0.htm"},{"title": "Networking Issues","href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-4da4.htm"}]},
{"title":"What is an administrative image (MSI) file?",
"href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-4d7a.htm",
"description":"An administrative image is a collection of shared file resources created during the deployment process and is used by deployments to install the program to networked workstations. Service packs (patches) can be applied to an administrative image when you create the deployment. A .msi file is a Microsoft Installer file.",
"ancestors":[{"title": "Troubleshooting","href":"./filesInstallLT/WS1a9193826455f5ff-e569a012180ce589145d0.htm"},{"title": "Networking Issues","href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-4da4.htm"}]},
{"title":"What is the impact of selecting all products for the administrative image, and can I add products later?",
"href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-4d76.htm",
"description":"If you elect to include all products in your deployment, the administrative image will be larger. You should select all products only when you create multiple deployments from this image and prefer not to use the installation disc. If there are products you rarely or never use, and you do not expect to create additional deployments, you should only select a subset of products.",
"ancestors":[{"title": "Troubleshooting","href":"./filesInstallLT/WS1a9193826455f5ff-e569a012180ce589145d0.htm"},{"title": "Networking Issues","href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-4da4.htm"}]},
{"title":"Uninstall and Maintenance Issues",
"href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-4d71.htm",
"description":"This section outlines common issues and their solutions with regards to adding and removing features, reinstalling or repairing your installation, and uninstalling products.",
"ancestors":[{"title": "Troubleshooting","href":"./filesInstallLT/WS1a9193826455f5ff-e569a012180ce589145d0.htm"}]},
{"title":"When adding or removing features, how can I tell what features get installed by default?",
"href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-4d6a.htm",
"description":"To quickly see what gets installed during a Typical, default installation, click the Restore Defaults button on the Add/Remove Features page.",
"ancestors":[{"title": "Troubleshooting","href":"./filesInstallLT/WS1a9193826455f5ff-e569a012180ce589145d0.htm"},{"title": "Uninstall and Maintenance Issues","href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-4d71.htm"}]},
{"title":"Is it possible to change the installation folder when adding or removing features?",
"href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-4d64.htm",
"description":"Once your product is installed, you cannot change the installation path from the Add/Remove Features page. Changing the path while adding features results in program corruption, so it is not an option.",
"ancestors":[{"title": "Troubleshooting","href":"./filesInstallLT/WS1a9193826455f5ff-e569a012180ce589145d0.htm"},{"title": "Uninstall and Maintenance Issues","href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-4d71.htm"}]},
{"title":"When should I reinstall the product instead of a repair?",
"href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-4d60.htm",
"description":"You should reinstall your product if you accidentally delete or alter files that are required by the program. Missing or altered files adversely affect the performance of your product and cause error messages when you try to execute a command or find a file.",
"ancestors":[{"title": "Troubleshooting","href":"./filesInstallLT/WS1a9193826455f5ff-e569a012180ce589145d0.htm"},{"title": "Uninstall and Maintenance Issues","href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-4d71.htm"}]},
{"title":"Do I need my original disc(s) to reinstall my product?",
"href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-4d5b.htm",
"description":"When performing a reinstall of the product, you are prompted to load your original disc(s). Installation data is cached locally on your drive and that data is reused when reinstalling.",
"ancestors":[{"title": "Troubleshooting","href":"./filesInstallLT/WS1a9193826455f5ff-e569a012180ce589145d0.htm"},{"title": "Uninstall and Maintenance Issues","href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-4d71.htm"}]},
{"title":"After repairing my installation, is it possible to recover my settings?",
"href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-4d57.htm",
"description":"Custom settings can be exported and later re-imported to the same system in case you have to repair the installation of your program.",
"ancestors":[{"title": "Troubleshooting","href":"./filesInstallLT/WS1a9193826455f5ff-e569a012180ce589145d0.htm"},{"title": "Uninstall and Maintenance Issues","href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-4d71.htm"}]},
{"title":"When I uninstall my software, what files are left on my system?",
"href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-4d52.htm",
"description":"If you uninstall the product, some files remain on your system such as files you created or edited (drawings or custom menus).",
"ancestors":[{"title": "Troubleshooting","href":"./filesInstallLT/WS1a9193826455f5ff-e569a012180ce589145d0.htm"},{"title": "Uninstall and Maintenance Issues","href":"./filesInstallLT/WS1a9193826455f5ff4e421d7d11bf108001d-4d71.htm"}]},
{"title":"Glossary",
"href":"./filesInstallLT/WS73099cc142f48755f2fc9df120970276f7-6245.htm",
"description":"",
"ancestors":[]},
]);
top.HlpSys.search.data.registerSearchProvider(searchResultProvider);
// SIG // Begin signature block
// SIG // MIIMzQYJKoZIhvcNAQcCoIIMvjCCDLoCAQExDjAMBggq
// SIG // hkiG9w0CBQUAMGYGCisGAQQBgjcCAQSgWDBWMDIGCisG
// SIG // AQQBgjcCAR4wJAIBAQQQEODJBs441BGiowAQS9NQkAIB
// SIG // AAIBAAIBAAIBAAIBADAgMAwGCCqGSIb3DQIFBQAEEHNn
// SIG // Dt8dkaLOYKOUlXqBMJ6gggoPMIIE/DCCBGWgAwIBAgIQ
// SIG // ZVIm4bIuGOFZDymFrCLnXDANBgkqhkiG9w0BAQUFADBf
// SIG // MQswCQYDVQQGEwJVUzEXMBUGA1UEChMOVmVyaVNpZ24s
// SIG // IEluYy4xNzA1BgNVBAsTLkNsYXNzIDMgUHVibGljIFBy
// SIG // aW1hcnkgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkwHhcN
// SIG // MDkwNTIxMDAwMDAwWhcNMTkwNTIwMjM1OTU5WjCBtjEL
// SIG // MAkGA1UEBhMCVVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJ
// SIG // bmMuMR8wHQYDVQQLExZWZXJpU2lnbiBUcnVzdCBOZXR3
// SIG // b3JrMTswOQYDVQQLEzJUZXJtcyBvZiB1c2UgYXQgaHR0
// SIG // cHM6Ly93d3cudmVyaXNpZ24uY29tL3JwYSAoYykwOTEw
// SIG // MC4GA1UEAxMnVmVyaVNpZ24gQ2xhc3MgMyBDb2RlIFNp
// SIG // Z25pbmcgMjAwOS0yIENBMIIBIjANBgkqhkiG9w0BAQEF
// SIG // AAOCAQ8AMIIBCgKCAQEAvmcdtGCqEElvVhd8Zslehg3V
// SIG // 8ayncYOOi4n4iASJFQa6LYQhleTRnFBM+9IivdrysjU7
// SIG // Ho/DCfv8Ey5av4l8PTslHvbzWHuc9AG1xgq4gM6+J3Rh
// SIG // ZydNauXsgWFYeaPgFxASFSew4U00fytHIES53mYkZorN
// SIG // T7ofxTjIVJDhcvYZZnVquUlozzh5DaowqNssYEie16oU
// SIG // AamD1ziRMDkTlgM6fEBUtq3gLxuD3KgRUj4Cs9cr/SG2
// SIG // p1yjDwupphBQDjQuTafOyV4l1Iy88258KbwBXfwxh1rV
// SIG // jIVnWIgZoL818OoroyHnkPaD5ajtYHhee2CD/VcLXUEN
// SIG // Y1Rg1kMh7wIDAQABo4IB2zCCAdcwEgYDVR0TAQH/BAgw
// SIG // BgEB/wIBADBwBgNVHSAEaTBnMGUGC2CGSAGG+EUBBxcD
// SIG // MFYwKAYIKwYBBQUHAgEWHGh0dHBzOi8vd3d3LnZlcmlz
// SIG // aWduLmNvbS9jcHMwKgYIKwYBBQUHAgIwHhocaHR0cHM6
// SIG // Ly93d3cudmVyaXNpZ24uY29tL3JwYTAOBgNVHQ8BAf8E
// SIG // BAMCAQYwbQYIKwYBBQUHAQwEYTBfoV2gWzBZMFcwVRYJ
// SIG // aW1hZ2UvZ2lmMCEwHzAHBgUrDgMCGgQUj+XTGoasjY5r
// SIG // w8+AatRIGCx7GS4wJRYjaHR0cDovL2xvZ28udmVyaXNp
// SIG // Z24uY29tL3ZzbG9nby5naWYwHQYDVR0lBBYwFAYIKwYB
// SIG // BQUHAwIGCCsGAQUFBwMDMDQGCCsGAQUFBwEBBCgwJjAk
// SIG // BggrBgEFBQcwAYYYaHR0cDovL29jc3AudmVyaXNpZ24u
// SIG // Y29tMDEGA1UdHwQqMCgwJqAkoCKGIGh0dHA6Ly9jcmwu
// SIG // dmVyaXNpZ24uY29tL3BjYTMuY3JsMCkGA1UdEQQiMCCk
// SIG // HjAcMRowGAYDVQQDExFDbGFzczNDQTIwNDgtMS01NTAd
// SIG // BgNVHQ4EFgQUl9BrqCZwyKE/lB8ILcQ1m6ShHvIwDQYJ
// SIG // KoZIhvcNAQEFBQADgYEAiwPA3ZTYQaJhabAVqHjHMMaQ
// SIG // PH5C9yS25INzFwR/BBCcoeL6gS/rwMpE53LgULZVECCD
// SIG // bpaS5JpRarQ3MdylLeuMAMcdT+dNMrqF+E6++mdVZfBq
// SIG // vnrKZDgaEBB4RXYx84Z6Aw9gwrNdnfaLZnaCG1nhg+W9
// SIG // SaU4VuXeQXcOWA8wggULMIID86ADAgECAhAjTaBL0kKF
// SIG // PErLmuhhwhm7MA0GCSqGSIb3DQEBBQUAMIG2MQswCQYD
// SIG // VQQGEwJVUzEXMBUGA1UEChMOVmVyaVNpZ24sIEluYy4x
// SIG // HzAdBgNVBAsTFlZlcmlTaWduIFRydXN0IE5ldHdvcmsx
// SIG // OzA5BgNVBAsTMlRlcm1zIG9mIHVzZSBhdCBodHRwczov
// SIG // L3d3dy52ZXJpc2lnbi5jb20vcnBhIChjKTA5MTAwLgYD
// SIG // VQQDEydWZXJpU2lnbiBDbGFzcyAzIENvZGUgU2lnbmlu
// SIG // ZyAyMDA5LTIgQ0EwHhcNMDkwODI3MDAwMDAwWhcNMTIw
// SIG // OTIwMjM1OTU5WjCByDELMAkGA1UEBhMCVVMxEzARBgNV
// SIG // BAgTCkNhbGlmb3JuaWExEzARBgNVBAcTClNhbiBSYWZh
// SIG // ZWwxFjAUBgNVBAoUDUF1dG9kZXNrLCBJbmMxPjA8BgNV
// SIG // BAsTNURpZ2l0YWwgSUQgQ2xhc3MgMyAtIE1pY3Jvc29m
// SIG // dCBTb2Z0d2FyZSBWYWxpZGF0aW9uIHYyMR8wHQYDVQQL
// SIG // FBZEZXNpZ24gU29sdXRpb25zIEdyb3VwMRYwFAYDVQQD
// SIG // FA1BdXRvZGVzaywgSW5jMIGfMA0GCSqGSIb3DQEBAQUA
// SIG // A4GNADCBiQKBgQC1R1YKdvQF2Rj4+knWfj81afUtVyep
// SIG // GF2P4tcYD53qlYmYi9t9Csc6PMWlUZhMGbOceQKYcBjc
// SIG // mWvyghJnoaEQ6796ZcsLD0pMH2R4SpV/SjxiQ280beig
// SIG // NerJS5X+ftOMCs1qSQ1LXlRFEohaewkNWsIp/+f1Y0vE
// SIG // dGzggnEKOQIDAQABo4IBgzCCAX8wCQYDVR0TBAIwADAO
// SIG // BgNVHQ8BAf8EBAMCB4AwRAYDVR0fBD0wOzA5oDegNYYz
// SIG // aHR0cDovL2NzYzMtMjAwOS0yLWNybC52ZXJpc2lnbi5j
// SIG // b20vQ1NDMy0yMDA5LTIuY3JsMEQGA1UdIAQ9MDswOQYL
// SIG // YIZIAYb4RQEHFwMwKjAoBggrBgEFBQcCARYcaHR0cHM6
// SIG // Ly93d3cudmVyaXNpZ24uY29tL3JwYTATBgNVHSUEDDAK
// SIG // BggrBgEFBQcDAzB1BggrBgEFBQcBAQRpMGcwJAYIKwYB
// SIG // BQUHMAGGGGh0dHA6Ly9vY3NwLnZlcmlzaWduLmNvbTA/
// SIG // BggrBgEFBQcwAoYzaHR0cDovL2NzYzMtMjAwOS0yLWFp
// SIG // YS52ZXJpc2lnbi5jb20vQ1NDMy0yMDA5LTIuY2VyMB8G
// SIG // A1UdIwQYMBaAFJfQa6gmcMihP5QfCC3ENZukoR7yMBEG
// SIG // CWCGSAGG+EIBAQQEAwIEEDAWBgorBgEEAYI3AgEbBAgw
// SIG // BgEBAAEB/zANBgkqhkiG9w0BAQUFAAOCAQEAIfxkh8Fd
// SIG // IHK+qtTf+9Eq5fjkk5gMMTQCOa+2aR7mqDzLfIFRGQzr
// SIG // tcc5/izsb/wPLUwdw1cRpnxO8/qLA2Ol+b99FONTOyyc
// SIG // Y8unwviYhdEjuFmqHkyC5MUYroZEjvTObFkkgN98Y48h
// SIG // C+mG2hdlVKXR0zr9r5q/rmmivVWbojvcYKHoW31O5OcM
// SIG // PsrWuOD305Ygmpck/91iopE3UN4tfeWYhzNj1F6Ai4Xa
// SIG // 5KiaMcs3zmoZ+6SePyI2YUgtff6yvy/rk8KVT41KGD2h
// SIG // fC+QrtVSkoDWP/MDtLjbTPCWElC1NWSEKowRI8t2x594
// SIG // Skjnzu/W5Lh97ixircOuM4IvBzGCAigwggIkAgEBMIHL
// SIG // MIG2MQswCQYDVQQGEwJVUzEXMBUGA1UEChMOVmVyaVNp
// SIG // Z24sIEluYy4xHzAdBgNVBAsTFlZlcmlTaWduIFRydXN0
// SIG // IE5ldHdvcmsxOzA5BgNVBAsTMlRlcm1zIG9mIHVzZSBh
// SIG // dCBodHRwczovL3d3dy52ZXJpc2lnbi5jb20vcnBhIChj
// SIG // KTA5MTAwLgYDVQQDEydWZXJpU2lnbiBDbGFzcyAzIENv
// SIG // ZGUgU2lnbmluZyAyMDA5LTIgQ0ECECNNoEvSQoU8Ssua
// SIG // 6GHCGbswDAYIKoZIhvcNAgUFAKCBsDAZBgkqhkiG9w0B
// SIG // CQMxDAYKKwYBBAGCNwIBBDAcBgorBgEEAYI3AgELMQ4w
// SIG // DAYKKwYBBAGCNwIBFTAfBgkqhkiG9w0BCQQxEgQQXDgu
// SIG // rRi0mSjdGxQNVZWMoDBUBgorBgEEAYI3AgEMMUYwRKAm
// SIG // gCQAQQB1AHQAbwBkAGUAcwBrACAAQwBvAG0AcABvAG4A
// SIG // ZQBuAHShGoAYaHR0cDovL3d3dy5hdXRvZGVzay5jb20g
// SIG // MA0GCSqGSIb3DQEBAQUABIGAL6TOnrp40FeZTWdVyGNc
// SIG // afAg9rcNdeVZws4fQc4UkPcPuzvYrD8q5WikB6B2hEBC
// SIG // LmKoMP7zdKDeJWVZqKPDjljzYSaaIevA0yA6WpdctI4G
// SIG // vqFaxk13ml/qNVl2fsoYAzkCCXBUYXTfXO5yxWRd8o/5
// SIG // isrb2DEbm++QDQcrMdc=
// SIG // End signature block
