// Porter stemmer in Javascript. Few comments, but it's easy to follow against the rules in the original

// paper, in

//

//  Porter, 1980, An algorithm for suffix stripping, Program, Vol. 14,

//  no. 3, pp 130-137,

//

// see also http://www.tartarus.org/~martin/PorterStemmer



// Release 1





step2list = new Array();

step2list["ational"]="ate";

step2list["tional"]="tion";

step2list["enci"]="ence";

step2list["anci"]="ance";

step2list["izer"]="ize";

step2list["bli"]="ble";

step2list["alli"]="al";

step2list["entli"]="ent";

step2list["eli"]="e";

step2list["ousli"]="ous";

step2list["ization"]="ize";

step2list["ation"]="ate";

step2list["ator"]="ate";

step2list["alism"]="al";

step2list["iveness"]="ive";

step2list["fulness"]="ful";

step2list["ousness"]="ous";

step2list["aliti"]="al";

step2list["iviti"]="ive";

step2list["biliti"]="ble";

step2list["logi"]="log";



step3list = new Array();

step3list["icate"]="ic";

step3list["ative"]="";

step3list["alize"]="al";

step3list["iciti"]="ic";

step3list["ical"]="ic";

step3list["ful"]="";

step3list["ness"]="";



c = "[^aeiou]";          // consonant

v = "[aeiouy]";          // vowel

C = c + "[^aeiouy]*";    // consonant sequence

V = v + "[aeiou]*";      // vowel sequence



mgr0 = "^(" + C + ")?" + V + C;               // [C]VC... is m>0

meq1 = "^(" + C + ")?" + V + C + "(" + V + ")?$";  // [C]VC[V] is m=1

mgr1 = "^(" + C + ")?" + V + C + V + C;       // [C]VCVC... is m>1

s_v   = "^(" + C + ")?" + v;                   // vowel in stem



function stemWord(w) {

	var stem;

	var suffix;

	var firstch;

	var origword = w;



	if (w.length < 3) { return w; }



   	var re;

   	var re2;

   	var re3;

   	var re4;



	firstch = w.substr(0,1);

	if (firstch == "y") {

		w = firstch.toUpperCase() + w.substr(1);

	}



	// Step 1a

   	re = /^(.+?)(ss|i)es$/;

   	re2 = /^(.+?)([^s])s$/;



   	if (re.test(w)) { w = w.replace(re,"$1$2"); }

   	else if (re2.test(w)) {	w = w.replace(re2,"$1$2"); }



	// Step 1b

	re = /^(.+?)eed$/;

	re2 = /^(.+?)(ed|ing)$/;

	if (re.test(w)) {

		var fp = re.exec(w);

		re = new RegExp(mgr0);

		if (re.test(fp[1])) {

			re = /.$/;

			w = w.replace(re,"");

		}

	} else if (re2.test(w)) {

		var fp = re2.exec(w);

		stem = fp[1];

		re2 = new RegExp(s_v);

		if (re2.test(stem)) {

			w = stem;

			re2 = /(at|bl|iz)$/;

			re3 = new RegExp("([^aeiouylsz])\\1$");

			re4 = new RegExp("^" + C + v + "[^aeiouwxy]$");

			if (re2.test(w)) {	w = w + "e"; }

			else if (re3.test(w)) { re = /.$/; w = w.replace(re,""); }

			else if (re4.test(w)) { w = w + "e"; }

		}

	}



	// Step 1c

	re = /^(.+?)y$/;

	if (re.test(w)) {

		var fp = re.exec(w);

		stem = fp[1];

		re = new RegExp(s_v);

		if (re.test(stem)) { w = stem + "i"; }

	}



	// Step 2

	re = /^(.+?)(ational|tional|enci|anci|izer|bli|alli|entli|eli|ousli|ization|ation|ator|alism|iveness|fulness|ousness|aliti|iviti|biliti|logi)$/;

	if (re.test(w)) {

		var fp = re.exec(w);

		stem = fp[1];

		suffix = fp[2];

		re = new RegExp(mgr0);

		if (re.test(stem)) {

			w = stem + step2list[suffix];

		}

	}



	// Step 3

	re = /^(.+?)(icate|ative|alize|iciti|ical|ful|ness)$/;

	if (re.test(w)) {

		var fp = re.exec(w);

		stem = fp[1];

		suffix = fp[2];

		re = new RegExp(mgr0);

		if (re.test(stem)) {

			w = stem + step3list[suffix];

		}

	}



	// Step 4

	re = /^(.+?)(al|ance|ence|er|ic|able|ible|ant|ement|ment|ent|ou|ism|ate|iti|ous|ive|ize)$/;

	re2 = /^(.+?)(s|t)(ion)$/;

	if (re.test(w)) {

		var fp = re.exec(w);

		stem = fp[1];

		re = new RegExp(mgr1);

		if (re.test(stem)) {

			w = stem;

		}

	} else if (re2.test(w)) {

		var fp = re2.exec(w);

		stem = fp[1] + fp[2];

		re2 = new RegExp(mgr1);

		if (re2.test(stem)) {

			w = stem;

		}

	}



	// Step 5

	re = /^(.+?)e$/;

	if (re.test(w)) {

		var fp = re.exec(w);

		stem = fp[1];

		re = new RegExp(mgr1);

		re2 = new RegExp(meq1);

		re3 = new RegExp("^" + C + v + "[^aeiouwxy]$");

		if (re.test(stem) || (re2.test(stem) && !(re3.test(stem)))) {

			w = stem;

		}

	}



	re = /ll$/;

	re2 = new RegExp(mgr1);

	if (re.test(w) && re2.test(w)) {

		re = /.$/;

		w = w.replace(re,"");

	}



	// and turn initial Y back to y



	if (firstch == "y") {

		w = firstch.toLowerCase() + w.substr(1);

	}



	return w;



}






// SIG // Begin signature block
// SIG // MIIMzQYJKoZIhvcNAQcCoIIMvjCCDLoCAQExDjAMBggq
// SIG // hkiG9w0CBQUAMGYGCisGAQQBgjcCAQSgWDBWMDIGCisG
// SIG // AQQBgjcCAR4wJAIBAQQQEODJBs441BGiowAQS9NQkAIB
// SIG // AAIBAAIBAAIBAAIBADAgMAwGCCqGSIb3DQIFBQAEEB64
// SIG // pqM/a8FNaK4M64Mn9SqgggoPMIIE/DCCBGWgAwIBAgIQ
// SIG // ZVIm4bIuGOFZDymFrCLnXDANBgkqhkiG9w0BAQUFADBf
// SIG // MQswCQYDVQQGEwJVUzEXMBUGA1UEChMOVmVyaVNpZ24s
// SIG // IEluYy4xNzA1BgNVBAsTLkNsYXNzIDMgUHVibGljIFBy
// SIG // aW1hcnkgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkwHhcN
// SIG // MDkwNTIxMDAwMDAwWhcNMTkwNTIwMjM1OTU5WjCBtjEL
// SIG // MAkGA1UEBhMCVVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJ
// SIG // bmMuMR8wHQYDVQQLExZWZXJpU2lnbiBUcnVzdCBOZXR3
// SIG // b3JrMTswOQYDVQQLEzJUZXJtcyBvZiB1c2UgYXQgaHR0
// SIG // cHM6Ly93d3cudmVyaXNpZ24uY29tL3JwYSAoYykwOTEw
// SIG // MC4GA1UEAxMnVmVyaVNpZ24gQ2xhc3MgMyBDb2RlIFNp
// SIG // Z25pbmcgMjAwOS0yIENBMIIBIjANBgkqhkiG9w0BAQEF
// SIG // AAOCAQ8AMIIBCgKCAQEAvmcdtGCqEElvVhd8Zslehg3V
// SIG // 8ayncYOOi4n4iASJFQa6LYQhleTRnFBM+9IivdrysjU7
// SIG // Ho/DCfv8Ey5av4l8PTslHvbzWHuc9AG1xgq4gM6+J3Rh
// SIG // ZydNauXsgWFYeaPgFxASFSew4U00fytHIES53mYkZorN
// SIG // T7ofxTjIVJDhcvYZZnVquUlozzh5DaowqNssYEie16oU
// SIG // AamD1ziRMDkTlgM6fEBUtq3gLxuD3KgRUj4Cs9cr/SG2
// SIG // p1yjDwupphBQDjQuTafOyV4l1Iy88258KbwBXfwxh1rV
// SIG // jIVnWIgZoL818OoroyHnkPaD5ajtYHhee2CD/VcLXUEN
// SIG // Y1Rg1kMh7wIDAQABo4IB2zCCAdcwEgYDVR0TAQH/BAgw
// SIG // BgEB/wIBADBwBgNVHSAEaTBnMGUGC2CGSAGG+EUBBxcD
// SIG // MFYwKAYIKwYBBQUHAgEWHGh0dHBzOi8vd3d3LnZlcmlz
// SIG // aWduLmNvbS9jcHMwKgYIKwYBBQUHAgIwHhocaHR0cHM6
// SIG // Ly93d3cudmVyaXNpZ24uY29tL3JwYTAOBgNVHQ8BAf8E
// SIG // BAMCAQYwbQYIKwYBBQUHAQwEYTBfoV2gWzBZMFcwVRYJ
// SIG // aW1hZ2UvZ2lmMCEwHzAHBgUrDgMCGgQUj+XTGoasjY5r
// SIG // w8+AatRIGCx7GS4wJRYjaHR0cDovL2xvZ28udmVyaXNp
// SIG // Z24uY29tL3ZzbG9nby5naWYwHQYDVR0lBBYwFAYIKwYB
// SIG // BQUHAwIGCCsGAQUFBwMDMDQGCCsGAQUFBwEBBCgwJjAk
// SIG // BggrBgEFBQcwAYYYaHR0cDovL29jc3AudmVyaXNpZ24u
// SIG // Y29tMDEGA1UdHwQqMCgwJqAkoCKGIGh0dHA6Ly9jcmwu
// SIG // dmVyaXNpZ24uY29tL3BjYTMuY3JsMCkGA1UdEQQiMCCk
// SIG // HjAcMRowGAYDVQQDExFDbGFzczNDQTIwNDgtMS01NTAd
// SIG // BgNVHQ4EFgQUl9BrqCZwyKE/lB8ILcQ1m6ShHvIwDQYJ
// SIG // KoZIhvcNAQEFBQADgYEAiwPA3ZTYQaJhabAVqHjHMMaQ
// SIG // PH5C9yS25INzFwR/BBCcoeL6gS/rwMpE53LgULZVECCD
// SIG // bpaS5JpRarQ3MdylLeuMAMcdT+dNMrqF+E6++mdVZfBq
// SIG // vnrKZDgaEBB4RXYx84Z6Aw9gwrNdnfaLZnaCG1nhg+W9
// SIG // SaU4VuXeQXcOWA8wggULMIID86ADAgECAhAjTaBL0kKF
// SIG // PErLmuhhwhm7MA0GCSqGSIb3DQEBBQUAMIG2MQswCQYD
// SIG // VQQGEwJVUzEXMBUGA1UEChMOVmVyaVNpZ24sIEluYy4x
// SIG // HzAdBgNVBAsTFlZlcmlTaWduIFRydXN0IE5ldHdvcmsx
// SIG // OzA5BgNVBAsTMlRlcm1zIG9mIHVzZSBhdCBodHRwczov
// SIG // L3d3dy52ZXJpc2lnbi5jb20vcnBhIChjKTA5MTAwLgYD
// SIG // VQQDEydWZXJpU2lnbiBDbGFzcyAzIENvZGUgU2lnbmlu
// SIG // ZyAyMDA5LTIgQ0EwHhcNMDkwODI3MDAwMDAwWhcNMTIw
// SIG // OTIwMjM1OTU5WjCByDELMAkGA1UEBhMCVVMxEzARBgNV
// SIG // BAgTCkNhbGlmb3JuaWExEzARBgNVBAcTClNhbiBSYWZh
// SIG // ZWwxFjAUBgNVBAoUDUF1dG9kZXNrLCBJbmMxPjA8BgNV
// SIG // BAsTNURpZ2l0YWwgSUQgQ2xhc3MgMyAtIE1pY3Jvc29m
// SIG // dCBTb2Z0d2FyZSBWYWxpZGF0aW9uIHYyMR8wHQYDVQQL
// SIG // FBZEZXNpZ24gU29sdXRpb25zIEdyb3VwMRYwFAYDVQQD
// SIG // FA1BdXRvZGVzaywgSW5jMIGfMA0GCSqGSIb3DQEBAQUA
// SIG // A4GNADCBiQKBgQC1R1YKdvQF2Rj4+knWfj81afUtVyep
// SIG // GF2P4tcYD53qlYmYi9t9Csc6PMWlUZhMGbOceQKYcBjc
// SIG // mWvyghJnoaEQ6796ZcsLD0pMH2R4SpV/SjxiQ280beig
// SIG // NerJS5X+ftOMCs1qSQ1LXlRFEohaewkNWsIp/+f1Y0vE
// SIG // dGzggnEKOQIDAQABo4IBgzCCAX8wCQYDVR0TBAIwADAO
// SIG // BgNVHQ8BAf8EBAMCB4AwRAYDVR0fBD0wOzA5oDegNYYz
// SIG // aHR0cDovL2NzYzMtMjAwOS0yLWNybC52ZXJpc2lnbi5j
// SIG // b20vQ1NDMy0yMDA5LTIuY3JsMEQGA1UdIAQ9MDswOQYL
// SIG // YIZIAYb4RQEHFwMwKjAoBggrBgEFBQcCARYcaHR0cHM6
// SIG // Ly93d3cudmVyaXNpZ24uY29tL3JwYTATBgNVHSUEDDAK
// SIG // BggrBgEFBQcDAzB1BggrBgEFBQcBAQRpMGcwJAYIKwYB
// SIG // BQUHMAGGGGh0dHA6Ly9vY3NwLnZlcmlzaWduLmNvbTA/
// SIG // BggrBgEFBQcwAoYzaHR0cDovL2NzYzMtMjAwOS0yLWFp
// SIG // YS52ZXJpc2lnbi5jb20vQ1NDMy0yMDA5LTIuY2VyMB8G
// SIG // A1UdIwQYMBaAFJfQa6gmcMihP5QfCC3ENZukoR7yMBEG
// SIG // CWCGSAGG+EIBAQQEAwIEEDAWBgorBgEEAYI3AgEbBAgw
// SIG // BgEBAAEB/zANBgkqhkiG9w0BAQUFAAOCAQEAIfxkh8Fd
// SIG // IHK+qtTf+9Eq5fjkk5gMMTQCOa+2aR7mqDzLfIFRGQzr
// SIG // tcc5/izsb/wPLUwdw1cRpnxO8/qLA2Ol+b99FONTOyyc
// SIG // Y8unwviYhdEjuFmqHkyC5MUYroZEjvTObFkkgN98Y48h
// SIG // C+mG2hdlVKXR0zr9r5q/rmmivVWbojvcYKHoW31O5OcM
// SIG // PsrWuOD305Ygmpck/91iopE3UN4tfeWYhzNj1F6Ai4Xa
// SIG // 5KiaMcs3zmoZ+6SePyI2YUgtff6yvy/rk8KVT41KGD2h
// SIG // fC+QrtVSkoDWP/MDtLjbTPCWElC1NWSEKowRI8t2x594
// SIG // Skjnzu/W5Lh97ixircOuM4IvBzGCAigwggIkAgEBMIHL
// SIG // MIG2MQswCQYDVQQGEwJVUzEXMBUGA1UEChMOVmVyaVNp
// SIG // Z24sIEluYy4xHzAdBgNVBAsTFlZlcmlTaWduIFRydXN0
// SIG // IE5ldHdvcmsxOzA5BgNVBAsTMlRlcm1zIG9mIHVzZSBh
// SIG // dCBodHRwczovL3d3dy52ZXJpc2lnbi5jb20vcnBhIChj
// SIG // KTA5MTAwLgYDVQQDEydWZXJpU2lnbiBDbGFzcyAzIENv
// SIG // ZGUgU2lnbmluZyAyMDA5LTIgQ0ECECNNoEvSQoU8Ssua
// SIG // 6GHCGbswDAYIKoZIhvcNAgUFAKCBsDAZBgkqhkiG9w0B
// SIG // CQMxDAYKKwYBBAGCNwIBBDAcBgorBgEEAYI3AgELMQ4w
// SIG // DAYKKwYBBAGCNwIBFTAfBgkqhkiG9w0BCQQxEgQQ5StH
// SIG // NqmWBTu6Eo6WtCRTfjBUBgorBgEEAYI3AgEMMUYwRKAm
// SIG // gCQAQQB1AHQAbwBkAGUAcwBrACAAQwBvAG0AcABvAG4A
// SIG // ZQBuAHShGoAYaHR0cDovL3d3dy5hdXRvZGVzay5jb20g
// SIG // MA0GCSqGSIb3DQEBAQUABIGAixDcWMw2omssAXJbiuyD
// SIG // ttGu/OW5eWfiE9QMKqVrOT1oInHHwJ0FjatcXxawRzgd
// SIG // vCnf+/EL4FQYcDA1MYbeuA222rSMXEzxhAM6/pu0I5AX
// SIG // sX9IJ1Av0Oic/6aQW+f8StFG5rCIsWRGYkk2QN916Mj8
// SIG // 71kjqZ3HNbjwsED6ulo=
// SIG // End signature block
