<?php
namespace Home\Controller;

use Think\Controller;
class LastController extends Controller
{

    public function index() {
        $Model = new \Think\Model();
        $time=time();
        $nowtime=' AND tm <= '.$time.'';
        $programList = $Model->query('SELECT FROM_UNIXTIME(`tm`,\'%Y/%m/%d\') as ctm, `id`, `name`, `logo`, `introduce` FROM `program` WHERE `is_del`=0  AND tm <= '.$time.' AND (UNIX_TIMESTAMP() - `tm`) < 3600*24*8 group by ctm,`id`  order by ctm,`id` desc');

        $programLast = array();
        $today = '';
        $yestoday = '';
        for($i=0; $i<7; $i++) {
        	$key = date('Y/m/d', strtotime('-' . $i . ' day'));
        	if($i == 0) {
        		$today = $key;
        	} else if($i == 1) {
				$yestoday = $key;
        	}
        	$programLast[$key] = array();
        }

        foreach ($programList as $program) {
        	if(isset($programLast[$program['ctm']])) {
        		$program['category'] = $this->getlCategoryByProgramID($Model, $program['id']);
    			$program['label'] = $this->getlLabelByProgramID($Model, $program['id']);

        		array_push($programLast[$program['ctm']], $program);
        	}
        }

        $this->assign('today', $today);
        $this->assign('yestoday', $yestoday);
        $this->assign('programLast', $programLast);

        //SEO
        $seo= array('title'=>'最新微信小程序');
        $this->assign('seo', $seo);

        $this->display("index");
    }

        //获取小程序分类信息
    private function getlCategoryByProgramID($Model, $programID) {
		$categoryList = $Model->query('SELECT `pcategory`.`id`,`pcategory`.`category` FROM `pcategory`, `program_category`, `program` WHERE `program`.`id`=' . $programID . ' AND `pcategory`.`id`=`program_category`.`cid` AND `program`.`id` = `program_category`.`pid`');

    	if(count($categoryList) == 0) {
    		return array();
    	} else {
    		return $categoryList[0];
    	}
    }

    //获取小程序tag
    private function getlLabelByProgramID($Model, $programID) {
		$labelList = $Model->query('SELECT `plabel`.`id`,`plabel`.`name` FROM `plabel`, `program_label`, `program` WHERE `program`.`id`=' . $programID . ' AND `plabel`.`id`=`program_label`.`lid` AND `program`.`id` = `program_label`.`pid`');

    	return $labelList;
    }



}