var InstallStatus = {
    downloading: 1,
    installing: 2,
    finished: 3,
    current: 0
}

var FinalStatus = {
    NotStart: 0,
    Completed: 1,
    Error: 2,
    Cancel: 3,
    EnvironmentNotMeet: 4
}

function notifyFinalStatus(status) {
    appExternal.setInstallStatus(status);
}

function manageShortcut(create) {
    appExternal.manageShortcut(stubParams["shortcut"], create);
}

function setWindowSize(width, height) {
    appExternal.setWindowSize(width, height);
}

function splitVersionStr(version) {
    var versions = version.split(".");
    var ret = [];
    for (var i = 0; i < versions.length; i++) {
        ret[i] = parseInt(versions[i]);
    }
    return ret;
}

function environmentCheck() {
    var osVersion = splitVersionStr(appExternal.getProperty("osVersion"));
    var spVersion = splitVersionStr(appExternal.getProperty("servicePackVersion"));
    var dotNetVersion = splitVersionStr(appExternal.getProperty("dotNetVersion"));
    var ieVersion = splitVersionStr(appExternal.getProperty("ieVersion"));

    // check OS > xp sp3 for X86 or OS>xp sp2 for X64   
    if (osVersion[0] < 5 || (osVersion[0] == 5 && ((osVersion[1] == 1 && spVersion[0] < 3) || (osVersion[1] == 2 && spVersion[0] < 2)))) {
        appExternal.messageBox(getMuiText("osRequirements"), getMuiText("errorText"));
        return false;
    }

    if (dotNetVersion[0] < 3 || (dotNetVersion[0] == 3 && dotNetVersion[1] < 5)) {
        appExternal.messageBox(getMuiText("dotNetRequirements"), getMuiText("errorText"));
        return false;
    }

    if (ieVersion[0] < 8) {
        appExternal.messageBox(getMuiText("ieRequirements"), getMuiText("errorText"));
        return false;
    }

    return true;
}

function setTextToPage() {
    var langText = stubParams.mui[appExternal.getProperty("lang")];
    $(".lang").each(function (i) {
        var property = $(this).attr("text");
        $(this).html(langText[property]);
    });
}

function getMuiText(property) {
    var langText = stubParams.mui[appExternal.getProperty("lang")];
    return langText[property];
}

function replaceParams(str) {
    var result = str;
    var tokens = str.match(/\$\{([a-z]|[A-Z]|[0-9]|_)*\}/g);
    if (tokens != null) {
        $.each(tokens, function (index, token) {
            result = result.replace(token, appExternal.getProperty(token.substr(2, token.length - 3)));
        });
    }
    return result;
}

function getDefaultDownloadUrl(str) {
    return str.replace("\$\{osbits\}", "32").replace("\$\{lang\}", "en");
}

function gotoPage(page) {
    window.location.href = page;
}

function setProductProperty() {
     appExternal.setChannel(installParams["CHNL"]);
}

function install() {
    notifyFinalStatus(FinalStatus.Error);
    InstallStatus.current = InstallStatus.downloading;
    var url = replaceParams(installParams["DOWNLOAD_URL"]);
    appExternal.download(url, downloadCallback);
}

var download_using_default_url = false;

function downloadCallback(ret) {
    if (ret == 0) { // success
        InstallStatus.current = InstallStatus.installing;
        var exeParam = installParams["EXE_PARAMETERS"];
        appExternal.install(exeParam, installCallback);
    } else if (ret == 2 && !download_using_default_url) { // resource not exist;
        var defaultUrl = getDefaultDownloadUrl(installParams["DOWNLOAD_URL"]);
        download_using_default_url = true;
        appExternal.download(defaultUrl, downloadCallback);
    } else if (ret == 3) {
        processError(getMuiText("diskfullMessageText"));
    } else {
        processError(getMuiText("errorMessageText"));
    }
}

var showInstallUI = false;

function installCallback(error) {
    if (error == 0) {
        InstallStatus.current = InstallStatus.finished;
        $("#next_button").show();
        $(".progress-label").empty();
        notifyFinalStatus(FinalStatus.Completed);
        manageShortcut(false);
        appExternal.restoreWindow();
    } else if (error == 1) {
        close();
    } else if (error == 2) {
        notifyFinalStatus(FinalStatus.Cancel);
        close();
    } else if (error == 3) {
        if (appExternal.getProperty("errorHandled") == "false" && !showInstallUI) {
            var exeParam = installParams["EXE_PARAMETERS"];
            appExternal.installWithUI(exeParam, installCallback);
            showInstallUI = true;
        } else {
            close();
        }
    } else if (error == 4) {
        var text = getMuiText("retryMessageText");
        if (appExternal.retryMessageBox(text)) {
            var exeParam = installParams["EXE_PARAMETERS"];
            appExternal.install(exeParam, installCallback);
        } else {
            notifyFinalStatus(FinalStatus.Cancel);
            close();
        }
    }
}

function processError(message) {
    appExternal.messageBox(message, getMuiText("errorText"));
    close();
}

function getInstallProcess() {
    var total = parseInt(appExternal.getProperty("downloadTotal"));
    var current = parseInt(appExternal.getProperty("downloadCurrent"));
    return parseInt(current * (InstallStatus.current == InstallStatus.finished ? 100 : 99) / total);
}

var preDownload = 0;
var lastTickcount = 0;
var beforePreDownload = 0;

function getDownloadSpeed() {
    var curDownload = parseInt(appExternal.getProperty("downloadCurrent"));
    var curTickcount = new Date().getTime();
    if (lastTickcount == 0) {
        lastTickcount = curTickcount;
    }
    var delta = curTickcount - lastTickcount;
    if (delta > 1000) {
        beforePreDownload = preDownload;
        preDownload += (curDownload - beforePreDownload) * 1000 / delta;
        lastTickcount += 1000;
    }
    var speed = curDownload - (beforePreDownload + (preDownload - beforePreDownload) * (curTickcount - lastTickcount) / 1000);
    return speed;
}

function strFormatByteSize(size) {
    if (size < 1000) {
        return size.toFixed(2) + "B";
    }
    size = size / 1024;
    if (size < 1000) {
        return size.toFixed(2) + "KB";
    }
    size = size / 1024;
    if (size < 1000) {
        return size.toFixed(2) + "MB";
    }
    size = size / 1024;
    return size.toFixed(2) + "GB";
}

function getInstallProcessLabel() {
    if (InstallStatus.current == InstallStatus.downloading) {
        var total = parseInt(appExternal.getProperty("downloadTotal"));
        var current = parseInt(appExternal.getProperty("downloadCurrent"));
        var speed = getDownloadSpeed();
        return strFormatByteSize(current) + " out of " + strFormatByteSize(total) + " @ " + strFormatByteSize(speed) + "/s";
    } else if (InstallStatus.current == InstallStatus.installing) {
        return getMuiText("installLabel");
    }
    return "";
}

function gotoThankYouPage() {
    var url = replaceParams(installParams["TYP_URL"]);
    appExternal.openPage(url);
}

function startInstallProgram() {
    appExternal.startInstallProgram("");
}

function dragWindow(element) {
    if (window.event.srcElement === element) {
        appExternal.dragWindow();
    }
}

function cancel() {
    appExternal.closeWindow();
}

function disableClose(disable) {
    appExternal.disableCloseWindow(disable);
}

function hide() {
    appExternal.hideWindow();
}

function close() {
    appExternal.closeWindow();
}

function finish() {
    gotoThankYouPage();
    startInstallProgram();
    appExternal.closeWindow();
}

$(document).ready(function () {
    setTextToPage();
});