var InputNumber = React.createClass({
    getInitialState: function () {
        return {
            value: 4,
            nullableValue: null
        };
    },
    // Wijmo event handlers
    valueChanged: function (s, e) {
        this.setState({ value: s.value });
    },
    nullableValueChanged: function (s, e) {
        this.setState({ nullableValue: s.value });
    },
    render: function () {
        return React.createElement("div", null, 
            React.createElement("h2", null, "InputNumber"), 
            React.createElement("p", null, 
                "The InputNumber control allows you to edit numbers, preventing you from entering invalid" + ' ' + "data and optionally formatting the numeric value as it is edited. The InputNumber can be" + ' ' + "used without specifying any of its properties; however, you'll typically want to bind it" + ' ' + "to some data using the ", 
                React.createElement("b", null, "value"), 
                " property."), 
            React.createElement("p", null, 
                "In addition to the ", 
                React.createElement("b", null, "value"), 
                " property, the InputNumber control offers several other" + ' ' + "properties that can be used to alter its behavior, such as:"), 
            React.createElement("ul", null, 
                React.createElement("li", null, 
                    React.createElement("b", null, "min"), 
                    ": Specifies the minimum numeric value that can be entered."), 
                React.createElement("li", null, 
                    React.createElement("b", null, "max"), 
                    ": Specifies the maximum numeric value that can be entered."), 
                React.createElement("li", null, 
                    React.createElement("b", null, "step"), 
                    ": Specifies the amount to add or subtract from the current" + ' ' + "value when the spinner buttons are clicked."), 
                React.createElement("li", null, 
                    React.createElement("b", null, "format"), 
                    ": Specifies the numeric format used to display the number being" + ' ' + "edited. The format property uses a .NET-style", 
                    React.createElement("a", {href: "http://msdn.microsoft.com/en-us/library/dwhawy9k(v=vs.110).aspx", target: "_blank"}, "numeric format string"), 
                    ".")), 
            React.createElement("p", null, "The example below demonstrates how to use all of these properties."), 
            React.createElement("div", {className: "row"}, 
                React.createElement("div", {className: "col-md-6"}, 
                    React.createElement("div", null, 
                        React.createElement("ul", {className: "nav nav-tabs", role: "tablist"}, 
                            React.createElement("li", {className: "active"}, 
                                React.createElement("a", {href: "#inJsx", role: "tab", "data-toggle": "tab"}, "JSX")
                            ), 
                            React.createElement("li", null, 
                                React.createElement("a", {href: "#inJs", role: "tab", "data-toggle": "tab"}, "JS")
                            )), 
                        React.createElement("div", {className: "tab-content"}, 
                            React.createElement("div", {className: "tab-pane active pane-content", id: "inJsx"}, 
                                '<div className="app-input-group">\n', 
                                '    <label>Unbound with format: </label>\n', 
                                '    <Wj.InputNumber\n', 
                                '        value={ Math.PI }\n', 
                                '        step={ 1 }\n', 
                                '        format="n"/>\n', 
                                '</div>\n', 
                                '<div className="app-input-group">\n', 
                                '    <label>Bound with min, max, step, and format: </label>\n', 
                                '    <Wj.InputNumber\n', 
                                '        format="c2"\n', 
                                '        min={ 0 } max={ 10 } step={ .5 }\n', 
                                '        value={ this.state.value }\n', 
                                '        valueChanged={ this.valueChanged }/>\n', 
                                '    <p>\n', 
                                '        <b>Value: { Util.format(this.state.value, \'c2\') }</b>\n', 
                                '    </p>\n', 
                                '</div>\n', 
                                '<div className="app-input-group">\n', 
                                '    <label>, not required: </label>\n', 
                                '    <Wj.InputNumber\n', 
                                '        placeholder="Enter a number..."\n', 
                                '        isRequired={ false }\n', 
                                '        format="c2"\n', 
                                '        min={ 0 } max={ 10 } step={ .5 }\n', 
                                '        value={ this.state.nullableValue }\n', 
                                '        valueChanged={ this.nullableValueChanged }/>\n', 
                                '    <p>\n', 
                                '        <b>Value: { Util.format(this.state.nullableValue, \'c2\') }</b>\n', 
                                '    </p>\n', 
                                '</div>'), 
                            React.createElement("div", {className: "tab-pane pane-content", id: "inJs"}, 
                                'getInitialState: function () {\n', 
                                '    return {\n', 
                                '        value: 4,\n', 
                                '        nullableValue: null\n', 
                                '    }\n', 
                                '},\n', 
                                '\n', 
                                '// Wijmo event handlers\n', 
                                'valueChanged: function(s, e) {\n', 
                                '    this.setState({ value: s.value });\n', 
                                '},\n', 
                                'nullableValueChanged: function(s, e) {\n', 
                                '    this.setState({ nullableValue: s.value });\n', 
                                '}')))
                ), 
                React.createElement("div", {className: "col-md-6"}, 
                    React.createElement("h4", null, "Result (live):"), 
                    React.createElement("div", {className: "app-input-group"}, 
                        React.createElement("label", null, "Unbound with format: "), 
                        React.createElement(Wj.InputNumber, {value: Math.PI, step: 1, format: "n"})), 
                    React.createElement("div", {className: "app-input-group"}, 
                        React.createElement("label", null, "Bound with min, max, step, and format: "), 
                        React.createElement(Wj.InputNumber, {format: "c2", min: 0, max: 10, step: .5, value: this.state.value, valueChanged: this.valueChanged}), 
                        React.createElement("p", null, 
                            React.createElement("b", null, 
                                "Value: ", 
                                Util.format(this.state.value, 'c2'))
                        )), 
                    React.createElement("div", {className: "app-input-group"}, 
                        React.createElement("label", null, "Bound, not required: "), 
                        React.createElement(Wj.InputNumber, {placeholder: "Enter a number...", isRequired: false, format: "c2", min: 0, max: 10, step: .5, value: this.state.nullableValue, valueChanged: this.nullableValueChanged}), 
                        React.createElement("p", null, 
                            React.createElement("b", null, 
                                "Value: ", 
                                Util.format(this.state.nullableValue, 'c2'))
                        )))));
    }
});
//# sourceMappingURL=InputNumber.js.map