var InputMask = React.createClass({
    getInitialState: function () {
        return {
            customMask: null,
            theDateTime: new Date()
        };
    },
    // Wijmo event handlers
    customMaskChanged: function (s, e) {
        this.setState({ customMask: s.value });
    },
    theDateTimeChanged: function (s, e) {
        this.setState({ theDateTime: s.value });
    },
    render: function () {
        return React.createElement("div", null, 
            React.createElement("h2", null, "InputMask"), 
            React.createElement("p", null, 
                "The InputMask control allows you to validate and format user input as it is entered, preventing" + ' ' + "invalid data.  The InputMask control can be used without specifying any of its properties; however," + ' ' + "you will typically set its ", 
                React.createElement("b", null, "value"), 
                " and ", 
                React.createElement("b", null, "mask"), 
                " properties.  Like the other Wijmo input" + ' ' + "controls, the ", 
                React.createElement("b", null, "value"), 
                " property specifies the value for the InputMask control." + ' ' + "The ", 
                React.createElement("b", null, "mask"), 
                " property specifies the control's mask and supports a combination of the following" + ' ' + "characters:"), 
            React.createElement("dl", {className: "dl-horizontal"}, 
                React.createElement("dt", null, "0"), 
                React.createElement("dd", null, "Digit."), 
                React.createElement("dt", null, "9"), 
                React.createElement("dd", null, "Digit or space."), 
                React.createElement("dt", null, "#"), 
                React.createElement("dd", null, "Digit, sign, or space."), 
                React.createElement("dt", null, "L"), 
                React.createElement("dd", null, "Letter."), 
                React.createElement("dt", null, "l"), 
                React.createElement("dd", null, "Letter or space."), 
                React.createElement("dt", null, "A"), 
                React.createElement("dd", null, "Alphanumeric."), 
                React.createElement("dt", null, "a"), 
                React.createElement("dd", null, "Alphanumeric or space."), 
                React.createElement("dt", null, "."), 
                React.createElement("dd", null, "Localized decimal point."), 
                React.createElement("dt", null, ","), 
                React.createElement("dd", null, "Localized thousand separator."), 
                React.createElement("dt", null, ":"), 
                React.createElement("dd", null, "Localized time separator."), 
                React.createElement("dt", null, "/"), 
                React.createElement("dd", null, "Localized date separator."), 
                React.createElement("dt", null, "$"), 
                React.createElement("dd", null, "Localized currency symbol."), 
                React.createElement("dt", null, "<"), 
                React.createElement("dd", null, "Converts characters that follow to lowercase."), 
                React.createElement("dt", null, ">"), 
                React.createElement("dd", null, "Converts characters that follow to uppercase."), 
                React.createElement("dt", null, "|"), 
                React.createElement("dd", null, "Disables case conversion."), 
                React.createElement("dt", null, "\\"), 
                React.createElement("dd", null, "Escapes any character, turning it into a literal."), 
                React.createElement("dt", null, "All others"), 
                React.createElement("dd", null, "Literals.")), 
            React.createElement("p", null, 
                "The examples below demonstrates how to use the ", 
                React.createElement("b", null, "value"), 
                " and ", 
                React.createElement("b", null, "mask"), 
                " properties with the" + ' ' + "InputMask, InputDate, and InputTime controls."), 
            React.createElement("div", {className: "row"}, 
                React.createElement("div", {className: "col-md-6"}, 
                    React.createElement("div", null, 
                        React.createElement("ul", {className: "nav nav-tabs", role: "tablist"}, 
                            React.createElement("li", {className: "active"}, 
                                React.createElement("a", {href: "#imJsx", role: "tab", "data-toggle": "tab"}, "JSX")
                            ), 
                            React.createElement("li", null, 
                                React.createElement("a", {href: "#imJs", role: "tab", "data-toggle": "tab"}, "JS")
                            )), 
                        React.createElement("div", {className: "tab-content"}, 
                            React.createElement("div", {className: "tab-pane active pane-content", id: "imJsx"}, 
                                '<div className="app-input-group">\n', 
                                '    <label>Social Security Number</label>\n', 
                                '    <Wj.InputMask\n', 
                                '        mask="000-00-0000"\n', 
                                '        title="Mask: 000-00-0000"/>\n', 
                                '</div>\n', 
                                '<div className="app-input-group">\n', 
                                '    <label>Phone Number</label>\n', 
                                '    <Wj.InputMask\n', 
                                '        mask="(999) 000-0000"\n', 
                                '        title="Mask: (999) 000-0000"/>\n', 
                                '</div>\n', 
                                '<div className="app-input-group">\n', 
                                '    <label>Try your own</label>\n', 
                                '    <Wj.InputMask\n', 
                                '        value={ this.state.customMask }\n', 
                                '        valueChanged={ this.customMaskChanged }\n', 
                                '        isRequired={ false }\n', 
                                '        placeholder="Enter an input mask..."/>\n', 
                                '    <Wj.InputMask\n', 
                                '        mask={ this.state.customMask }\n', 
                                '        title="Mask: {{ customMask || \'N/A\' }}"/>\n', 
                                '</div>\n', 
                                '<div className="app-input-group">\n', 
                                '    <label>InputDate with mask</label>\n', 
                                '    <Wj.InputDate\n', 
                                '        format="MM/dd/yyyy"\n', 
                                '        mask="99/99/9999"\n', 
                                '        title="Mask: 99/99/9999"\n', 
                                '        value={ this.state.theDateTime }\n', 
                                '        valueChanged={ this.theDateTimeChanged }/>\n', 
                                '</div>\n', 
                                '<div className="app-input-group">\n', 
                                '    <label>InputTime with mask</label>\n', 
                                '    <Wj.InputTime\n', 
                                '        format="hh:mm tt"\n', 
                                '        isEditable={ true }\n', 
                                '        step={ 15 }\n', 
                                '        mask="00:00 >LL"\n', 
                                '        title="Mask: 00:00 >LL"\n', 
                                '        value={ this.state.theDateTime }\n', 
                                '        valueChanged={ this.theDateTimeChanged }/>\n', 
                                '</div>'), 
                            React.createElement("div", {className: "tab-pane pane-content", id: "imJs"}, 
                                'getInitialState: function () {\n', 
                                '    return {\n', 
                                '        customMask: null,\n', 
                                '        theDateTime: new Date()\n', 
                                '    }\n', 
                                '},\n', 
                                '\n', 
                                '// Wijmo event handlers\n', 
                                'customMaskChanged: function(s, e) {\n', 
                                '    this.setState({ customMask: s.value });\n', 
                                '},\n', 
                                'theDateTimeChanged: function(s, e) {\n', 
                                '    this.setState({ theDateTime: s.value });\n', 
                                '}')))
                ), 
                React.createElement("div", {className: "col-md-6"}, 
                    React.createElement("h4", null, "Result (live):"), 
                    React.createElement("div", {className: "app-input-group"}, 
                        React.createElement("label", null, "Social Security Number"), 
                        React.createElement(Wj.InputMask, {mask: "000-00-0000", title: "Mask: 000-00-0000"})), 
                    React.createElement("div", {className: "app-input-group"}, 
                        React.createElement("label", null, "Phone Number"), 
                        React.createElement(Wj.InputMask, {mask: "(999) 000-0000", title: "Mask: (999) 000-0000"})), 
                    React.createElement("div", {className: "app-input-group"}, 
                        React.createElement("label", null, "Try your own"), 
                        React.createElement(Wj.InputMask, {value: this.state.customMask, valueChanged: this.customMaskChanged, isRequired: false, placeholder: "Enter an input mask..."}), 
                        React.createElement(Wj.InputMask, {mask: this.state.customMask, title: "Mask: {{ customMask || 'N/A' }}"})), 
                    React.createElement("div", {className: "app-input-group"}, 
                        React.createElement("label", null, "InputDate with mask"), 
                        React.createElement(Wj.InputDate, {format: "MM/dd/yyyy", mask: "99/99/9999", title: "Mask: 99/99/9999", value: this.state.theDateTime, valueChanged: this.theDateTimeChanged})), 
                    React.createElement("div", {className: "app-input-group"}, 
                        React.createElement("label", null, "InputTime with mask"), 
                        React.createElement(Wj.InputTime, {format: "hh:mm tt", isEditable: true, step: 15, mask: "00:00 >LL", title: "Mask: 00:00 >LL", value: this.state.theDateTime, valueChanged: this.theDateTimeChanged})))));
    }
});
//# sourceMappingURL=InputMask.js.map