var ColumnDefinitions = React.createClass({
    render: function () {
        return React.createElement("div", null, 
            React.createElement("h2", null, "Column Definitions"), 
            React.createElement("p", null, "The Getting Started example did not define any columns, so FlexGrid generated them" + ' ' + "automatically."), 
            React.createElement("p", null, 
                "This example shows how you can define columns using the FlexGrid's ", 
                React.createElement("b", null, "columns"), 
                " property." + ' ' + "The markup sets the ", 
                React.createElement("b", null, "autoGenerateColumns"), 
                " property to false and assigns an array of columns" + ' ' + "to the ", 
                React.createElement("b", null, "columns"), 
                " property."), 
            React.createElement("p", null, "Specifying the columns allows you to choose which columns to show, and in what order." + ' ' + "This also gives you control over each column&#39;s width, heading, formatting, alignment," + ' ' + "and other properties."), 
            React.createElement("p", null, "In this case, we use star sizing to set the width of the \"Country\" column. This tells the" + ' ' + "column to stretch to fill the available width of the grid, so that there is no empty space. On" + ' ' + "the \"Revenue\" column, we set the format property to \"n0\", which results in numbers with" + ' ' + "thousand separators and no decimal digits."), 
            React.createElement("div", {className: "row"}, 
                React.createElement("div", {className: "col-md-6"}, 
                    React.createElement("ul", {className: "nav nav-tabs", role: "tablist"}, 
                        React.createElement("li", {className: "active"}, 
                            React.createElement("a", {href: "#cdJsx", role: "tab", "data-toggle": "tab"}, "JSX")
                        ), 
                        React.createElement("li", null, 
                            React.createElement("a", {href: "#cdJs", role: "tab", "data-toggle": "tab"}, "JS")
                        )), 
                    React.createElement("div", {className: "tab-content"}, 
                        React.createElement("div", {className: "tab-pane active pane-content", id: "cdJsx"}, 
                            '<Wj.FlexGrid\n', 
                            '    autoGenerateColumns={ false }\n', 
                            '    columns={[\n', 
                            '        { header: \'Country\', binding: \'country\', width: \'*\' },\n', 
                            '        { header: \'Date\', binding: \'date\' },\n', 
                            '        { header: \'Revenue\', binding: \'amount\', format: \'n0\' },\n', 
                            '        { header: \'Active\', binding: \'active\' }\n', 
                            '    ]}\n', 
                            '    itemsSource={ Util.getData() } />\n'), 
                        React.createElement("div", {className: "tab-pane pane-content", id: "cdJs"}, 
                            '// generate some random data\n', 
                            'export function getCountries() {\n', 
                            '    return \'US,Germany,UK,Japan,Italy,Greece\'.split(\',\');\n', 
                            '}\n', 
                            'export function getData() {\n', 
                            '    var countries = getCountries(),\n', 
                            '        data = [];\n', 
                            '    for (var i = 0; i < 100; i++) {\n', 
                            '        data.push({\n', 
                            '            id: i,\n', 
                            '            country: countries[i % countries.length],\n', 
                            '            date: new Date(2014, i % 12, i % 28),\n', 
                            '            amount: Math.random() * 10000,\n', 
                            '            active: i % 4 == 0\n', 
                            '        });\n', 
                            '    }\n', 
                            '    return data;\n', 
                            '}'))), 
                React.createElement("div", {className: "col-md-6"}, 
                    React.createElement("h4", null, "Result (live):"), 
                    React.createElement(Wj.FlexGrid, {autoGenerateColumns: false, columns: [
                        { header: 'Country', binding: 'country', width: '*' },
                        { header: 'Date', binding: 'date' },
                        { header: 'Revenue', binding: 'amount', format: 'n0' },
                        { header: 'Active', binding: 'active' }
                    ], itemsSource: Util.getData()}))));
    }
});
//# sourceMappingURL=ColumnDefinitions.js.map