var GettingStarted = React.createClass({
    render: function () {
        return React.createElement("div", null, 
            React.createElement("h2", null, "Getting Started"), 
            React.createElement("p", null, "Steps for getting started with FlexChart in React applications:"), 
            React.createElement("ol", null, 
                React.createElement("li", null, "Add references to React, Wijmo, and the Wijmo/React interop module."), 
                React.createElement("li", null, 
                    "Add FlexChart controls to your React components using regular JSX markup" + ' ' + "(", 
                    React.createElement("code", null, "<Wj.FlexChart>"), 
                    ")."), 
                React.createElement("li", null, 
                    "Set the ", 
                    React.createElement("b", null, "itemsSource"), 
                    " attribute to an array that contains the data."), 
                React.createElement("li", null, 
                    "Add one or more ", 
                    React.createElement("b", null, "chartSeries"), 
                    " to the chart's ", 
                    React.createElement("b", null, "series"), 
                    " collection."), 
                React.createElement("li", null, "(Optional) Use CSS to customize the appearance of the controls.")), 
            React.createElement("div", {className: "row"}, 
                React.createElement("div", {className: "col-md-6"}, 
                    React.createElement("div", null, 
                        React.createElement("ul", {className: "nav nav-tabs", role: "tablist"}, 
                            React.createElement("li", {className: "active"}, 
                                React.createElement("a", {href: "#gsJsx", role: "tab", "data-toggle": "tab"}, "JSX")
                            ), 
                            React.createElement("li", null, 
                                React.createElement("a", {href: "#gsJs", role: "tab", "data-toggle": "tab"}, "JS")
                            )), 
                        React.createElement("div", {className: "tab-content"}, 
                            React.createElement("div", {className: "tab-pane active pane-content", id: "gsJsx"}, 
                                '<Wj.FlexChart\n', 
                                '    itemsSource={ Util.getData() } \n', 
                                '    bindingX="country"\n', 
                                '    series={[\n', 
                                '        { name: \'Sales\', binding: \'sales\' },\n', 
                                '        { name: \'Expenses\', binding: \'expenses\' },\n', 
                                '        { name: \'Downloads\', binding: \'downloads\' }\n', 
                                '    ]} />'), 
                            React.createElement("div", {className: "tab-pane pane-content", id: "gsJs"}, 
                                'export function getCountries() {\n', 
                                '    return \'US,Germany,UK,Japan,Italy,Greece\'.split(\',\');\n', 
                                '}\n', 
                                'export function getData() {\n', 
                                '    var countries = getCountries(),\n', 
                                '        data = [];\n', 
                                '    for (var i = 0; i < countries.length; i++) {\n', 
                                '        data.push({\n', 
                                '            country: countries[i],\n', 
                                '            downloads: Math.round(Math.random() * 20000),\n', 
                                '            sales: Math.random() * 10000,\n', 
                                '            expenses: Math.random() * 5000\n', 
                                '        });\n', 
                                '    }\n', 
                                '    return data;\n', 
                                '}')))
                ), 
                React.createElement("div", {className: "col-md-6"}, 
                    React.createElement("h4", null, "Result (live):"), 
                    React.createElement(Wj.FlexChart, {itemsSource: Util.getData(), bindingX: "country", series: [
                        { name: 'Sales', binding: 'sales' },
                        { name: 'Expenses', binding: 'expenses' },
                        { name: 'Downloads', binding: 'downloads' }
                    ]}))));
    }
});
//# sourceMappingURL=GettingStarted.js.map